/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FilterChain;

public final class LoadProperties
extends Task {
    private File srcFile = null;
    private final Vector filterChains = new Vector();
    private String encoding = null;

    public final void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final void execute() throws BuildException {
        if (this.srcFile == null) {
            throw new BuildException("Source file not defined.");
        }
        if (!this.srcFile.exists()) {
            throw new BuildException("Source file does not exist.");
        }
        if (!this.srcFile.isFile()) {
            throw new BuildException("Source file is not a file.");
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        Reader instream = null;
        ByteArrayInputStream tis = null;
        try {
            long len = this.srcFile.length();
            fis = new FileInputStream(this.srcFile);
            bis = new BufferedInputStream(fis);
            instream = this.encoding == null ? new InputStreamReader(bis) : new InputStreamReader((InputStream)bis, this.encoding);
            ChainReaderHelper crh = new ChainReaderHelper();
            crh.setPrimaryReader(instream);
            crh.setFilterChains(this.filterChains);
            crh.setProject(this.getProject());
            instream = crh.getAssembledReader();
            String text = crh.readFully(instream);
            if (text != null) {
                if (!text.endsWith("\n")) {
                    text = text + "\n";
                }
                tis = this.encoding == null ? new ByteArrayInputStream(text.getBytes()) : new ByteArrayInputStream(text.getBytes(this.encoding));
                Properties props = new Properties();
                props.load(tis);
                Property propertyTask = (Property)this.getProject().createTask("property");
                propertyTask.setTaskName(this.getTaskName());
                propertyTask.addProperties(props);
            }
        }
        catch (IOException ioe) {
            String message = "Unable to load file: " + ioe.toString();
            throw new BuildException(message, ioe, this.getLocation());
        }
        catch (BuildException be) {
            throw be;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioex) {}
            try {
                if (tis != null) {
                    tis.close();
                }
            }
            catch (IOException ioex) {}
        }
    }

    public final void addFilterChain(FilterChain filter) {
        this.filterChains.addElement(filter);
    }
}

