# libnbd Python bindings
# Copyright (C) 2010-2019 Red Hat Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

import nbd

h = nbd.NBD()
h.connect_command(["nbdkit", "-s", "--exit-with-parent", "-v",
                   "pattern", "size=512"])
buf = h.pread(512, 0)

print("%r" % buf)

assert buf == (b'\x00\x00\x00\x00\x00\x00\x00\x00'
               + b'\x00\x00\x00\x00\x00\x00\x00\x08'
               + b'\x00\x00\x00\x00\x00\x00\x00\x10'
               + b'\x00\x00\x00\x00\x00\x00\x00\x18'
               + b'\x00\x00\x00\x00\x00\x00\x00 '
               + b'\x00\x00\x00\x00\x00\x00\x00('
               + b'\x00\x00\x00\x00\x00\x00\x000'
               + b'\x00\x00\x00\x00\x00\x00\x008'
               + b'\x00\x00\x00\x00\x00\x00\x00@'
               + b'\x00\x00\x00\x00\x00\x00\x00H'
               + b'\x00\x00\x00\x00\x00\x00\x00P'
               + b'\x00\x00\x00\x00\x00\x00\x00X'
               + b'\x00\x00\x00\x00\x00\x00\x00`'
               + b'\x00\x00\x00\x00\x00\x00\x00h'
               + b'\x00\x00\x00\x00\x00\x00\x00p'
               + b'\x00\x00\x00\x00\x00\x00\x00x'
               + b'\x00\x00\x00\x00\x00\x00\x00\x80'
               + b'\x00\x00\x00\x00\x00\x00\x00\x88'
               + b'\x00\x00\x00\x00\x00\x00\x00\x90'
               + b'\x00\x00\x00\x00\x00\x00\x00\x98'
               + b'\x00\x00\x00\x00\x00\x00\x00\xa0'
               + b'\x00\x00\x00\x00\x00\x00\x00\xa8'
               + b'\x00\x00\x00\x00\x00\x00\x00\xb0'
               + b'\x00\x00\x00\x00\x00\x00\x00\xb8'
               + b'\x00\x00\x00\x00\x00\x00\x00\xc0'
               + b'\x00\x00\x00\x00\x00\x00\x00\xc8'
               + b'\x00\x00\x00\x00\x00\x00\x00\xd0'
               + b'\x00\x00\x00\x00\x00\x00\x00\xd8'
               + b'\x00\x00\x00\x00\x00\x00\x00\xe0'
               + b'\x00\x00\x00\x00\x00\x00\x00\xe8'
               + b'\x00\x00\x00\x00\x00\x00\x00\xf0'
               + b'\x00\x00\x00\x00\x00\x00\x00\xf8'
               + b'\x00\x00\x00\x00\x00\x00\x01\x00'
               + b'\x00\x00\x00\x00\x00\x00\x01\x08'
               + b'\x00\x00\x00\x00\x00\x00\x01\x10'
               + b'\x00\x00\x00\x00\x00\x00\x01\x18'
               + b'\x00\x00\x00\x00\x00\x00\x01 '
               + b'\x00\x00\x00\x00\x00\x00\x01('
               + b'\x00\x00\x00\x00\x00\x00\x010'
               + b'\x00\x00\x00\x00\x00\x00\x018'
               + b'\x00\x00\x00\x00\x00\x00\x01@'
               + b'\x00\x00\x00\x00\x00\x00\x01H'
               + b'\x00\x00\x00\x00\x00\x00\x01P'
               + b'\x00\x00\x00\x00\x00\x00\x01X'
               + b'\x00\x00\x00\x00\x00\x00\x01`'
               + b'\x00\x00\x00\x00\x00\x00\x01h'
               + b'\x00\x00\x00\x00\x00\x00\x01p'
               + b'\x00\x00\x00\x00\x00\x00\x01x'
               + b'\x00\x00\x00\x00\x00\x00\x01\x80'
               + b'\x00\x00\x00\x00\x00\x00\x01\x88'
               + b'\x00\x00\x00\x00\x00\x00\x01\x90'
               + b'\x00\x00\x00\x00\x00\x00\x01\x98'
               + b'\x00\x00\x00\x00\x00\x00\x01\xa0'
               + b'\x00\x00\x00\x00\x00\x00\x01\xa8'
               + b'\x00\x00\x00\x00\x00\x00\x01\xb0'
               + b'\x00\x00\x00\x00\x00\x00\x01\xb8'
               + b'\x00\x00\x00\x00\x00\x00\x01\xc0'
               + b'\x00\x00\x00\x00\x00\x00\x01\xc8'
               + b'\x00\x00\x00\x00\x00\x00\x01\xd0'
               + b'\x00\x00\x00\x00\x00\x00\x01\xd8'
               + b'\x00\x00\x00\x00\x00\x00\x01\xe0'
               + b'\x00\x00\x00\x00\x00\x00\x01\xe8'
               + b'\x00\x00\x00\x00\x00\x00\x01\xf0'
               + b'\x00\x00\x00\x00\x00\x00\x01\xf8')
