/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - scanner_init
 * - core_yylex_init
 * - core_yyalloc
 * - yy_init_globals
 * - core_yyset_extra
 * - backslash_quote
 * - escape_string_warning
 * - standard_conforming_strings
 * - core_yy_scan_buffer
 * - core_yy_switch_to_buffer
 * - core_yyensure_buffer_stack
 * - core_yyrealloc
 * - core_yy_load_buffer_state
 * - yy_fatal_error
 * - fprintf_to_ereport
 * - ScanKeywordTokens
 * - core_yylex
 * - core_yy_create_buffer
 * - core_yy_init_buffer
 * - core_yy_flush_buffer
 * - core_yyrestart
 * - yy_start_state_list
 * - yy_transition
 * - addlitchar
 * - addlit
 * - litbufdup
 * - check_escape_warning
 * - addunicode
 * - setup_scanner_errposition_callback
 * - scb_error_callback
 * - cancel_scanner_errposition_callback
 * - check_string_escape_warning
 * - unescape_single_char
 * - process_integer_literal
 * - yy_get_previous_state
 * - yy_try_NUL_trans
 * - yy_get_next_buffer
 * - scanner_errposition
 * - scanner_yyerror
 * - scanner_finish
 *--------------------------------------------------------------------
 */

#line 1 "scan.c"
/*-------------------------------------------------------------------------
 *
 * scan.l
 *	  lexical scanner for PostgreSQL
 *
 * NOTE NOTE NOTE:
 *
 * The rules in this file must be kept in sync with src/fe_utils/psqlscan.l
 * and src/interfaces/ecpg/preproc/pgc.l!
 *
 * The rules are designed so that the scanner never has to backtrack,
 * in the sense that there is always a rule that can match the input
 * consumed so far (the rule action may internally throw back some input
 * with yyless(), however).  As explained in the flex manual, this makes
 * for a useful speed increase --- several percent faster when measuring
 * raw parsing (Flex + Bison).  The extra complexity is mostly in the rules
 * for handling float numbers and continued string literals.  If you change
 * the lexical rules, verify that you haven't broken the no-backtrack
 * property by running flex with the "-b" option and checking that the
 * resulting "lex.backup" file says that no backing up is needed.  (As of
 * Postgres 9.2, this check is made automatically by the Makefile.)
 *
 *
 * Portions Copyright (c) 1996-2024, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/backend/parser/scan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <ctype.h>
#include <unistd.h>

#include "common/string.h"
#include "gramparse.h"
#include "nodes/miscnodes.h"
#include "parser/parser.h"		/* only needed for GUC variables */
#include "parser/scansup.h"
#include "port/pg_bitutils.h"
#include "mb/pg_wchar.h"
#include "utils/builtins.h"

#line 47 "scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define core_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer core_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define core_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer core_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define core_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer core_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define core_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string core_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define core_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes core_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define core_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer core_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define core_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer core_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define core_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state core_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define core_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer core_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define core_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state core_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define core_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state core_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define core_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack core_yyensure_buffer_stack
#endif

#ifdef yylex
#define core_yylex_ALREADY_DEFINED
#else
#define yylex core_yylex
#endif

#ifdef yyrestart
#define core_yyrestart_ALREADY_DEFINED
#else
#define yyrestart core_yyrestart
#endif

#ifdef yylex_init
#define core_yylex_init_ALREADY_DEFINED
#else
#define yylex_init core_yylex_init
#endif

#ifdef yylex_init_extra
#define core_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra core_yylex_init_extra
#endif

#ifdef yylex_destroy
#define core_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy core_yylex_destroy
#endif

#ifdef yyget_debug
#define core_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug core_yyget_debug
#endif

#ifdef yyset_debug
#define core_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug core_yyset_debug
#endif

#ifdef yyget_extra
#define core_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra core_yyget_extra
#endif

#ifdef yyset_extra
#define core_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra core_yyset_extra
#endif

#ifdef yyget_in
#define core_yyget_in_ALREADY_DEFINED
#else
#define yyget_in core_yyget_in
#endif

#ifdef yyset_in
#define core_yyset_in_ALREADY_DEFINED
#else
#define yyset_in core_yyset_in
#endif

#ifdef yyget_out
#define core_yyget_out_ALREADY_DEFINED
#else
#define yyget_out core_yyget_out
#endif

#ifdef yyset_out
#define core_yyset_out_ALREADY_DEFINED
#else
#define yyset_out core_yyset_out
#endif

#ifdef yyget_leng
#define core_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng core_yyget_leng
#endif

#ifdef yyget_text
#define core_yyget_text_ALREADY_DEFINED
#else
#define yyget_text core_yyget_text
#endif

#ifdef yyget_lineno
#define core_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno core_yyget_lineno
#endif

#ifdef yyset_lineno
#define core_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno core_yyset_lineno
#endif

#ifdef yyget_column
#define core_yyget_column_ALREADY_DEFINED
#else
#define yyget_column core_yyget_column
#endif

#ifdef yyset_column
#define core_yyset_column_ALREADY_DEFINED
#else
#define yyset_column core_yyset_column
#endif

#ifdef yywrap
#define core_yywrap_ALREADY_DEFINED
#else
#define yywrap core_yywrap
#endif

#ifdef yyget_lval
#define core_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval core_yyget_lval
#endif

#ifdef yyset_lval
#define core_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval core_yyset_lval
#endif

#ifdef yyget_lloc
#define core_yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc core_yyget_lloc
#endif

#ifdef yyset_lloc
#define core_yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc core_yyset_lloc
#endif

#ifdef yyalloc
#define core_yyalloc_ALREADY_DEFINED
#else
#define yyalloc core_yyalloc
#endif

#ifdef yyrealloc
#define core_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc core_yyrealloc
#endif

#ifdef yyfree
#define core_yyfree_ALREADY_DEFINED
#else
#define yyfree core_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
typedef uint64_t flex_uint64_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, yy_size_t len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define core_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (yy_size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 73
#define YY_END_OF_BUFFER 74
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[33677] =
    {
 {   0,   0 }, {   0,33421 }, {   0,   0 }, {   0,33419 }, {   1,6192 },
 {   2,6192 }, {   3,6192 }, {   4,6192 }, {   5,6192 }, {   6,6192 },
 {   7,6192 }, {   8,6192 }, {   9,6194 }, {  10,6199 }, {  11,6194 },
 {  12,6194 }, {  13,6194 }, {  14,6192 }, {  15,6192 }, {  16,6192 },
 {  17,6192 }, {  18,6192 }, {  19,6192 }, {  20,6192 }, {  21,6192 },
 {  22,6192 }, {  23,6192 }, {  24,6192 }, {  25,6192 }, {  26,6192 },
 {  27,6192 }, {  28,6192 }, {  29,6192 }, {  30,6192 }, {  31,6192 },
 {  32,6194 }, {  33,6201 }, {  34,6196 }, {  35,6241 }, {  36,6307 },
 {  37,6564 }, {  38,6241 }, {  39,6214 }, {  40,6216 }, {  41,6216 },
 {  42,6564 }, {  43,6564 }, {  44,6216 }, {  45,6575 }, {  46,6594 },

 {  47,6665 }, {  48,6697 }, {  49,6954 }, {  50,6954 }, {  51,6954 },
 {  52,6954 }, {  53,6954 }, {  54,6954 }, {  55,6954 }, {  56,6954 },
 {  57,6954 }, {  58,6219 }, {  59,6216 }, {  60,7211 }, {  61,7222 },
 {  62,7289 }, {  63,6241 }, {  64,6241 }, {  65,7321 }, {  66,7578 },
 {  67,7321 }, {  68,7321 }, {  69,7835 }, {  70,7321 }, {  71,7321 },
 {  72,7321 }, {  73,7321 }, {  74,7321 }, {  75,7321 }, {  76,7321 },
 {  77,7321 }, {  78,8092 }, {  79,7321 }, {  80,7321 }, {  81,7321 },
 {  82,7321 }, {  83,7321 }, {  84,7321 }, {  85,8349 }, {  86,7321 },
 {  87,7321 }, {  88,8606 }, {  89,7321 }, {  90,7321 }, {  91,6216 },
 {  92,6192 }, {  93,6216 }, {  94,6564 }, {  95,7321 }, {  96,6241 },

 {  97,7321 }, {  98,7578 }, {  99,7321 }, { 100,7321 }, { 101,7835 },
 { 102,7321 }, { 103,7321 }, { 104,7321 }, { 105,7321 }, { 106,7321 },
 { 107,7321 }, { 108,7321 }, { 109,7321 }, { 110,8092 }, { 111,7321 },
 { 112,7321 }, { 113,7321 }, { 114,7321 }, { 115,7321 }, { 116,7321 },
 { 117,8349 }, { 118,7321 }, { 119,7321 }, { 120,8606 }, { 121,7321 },
 { 122,7321 }, { 123,6192 }, { 124,6241 }, { 125,6192 }, { 126,6241 },
 { 127,6192 }, { 128,7321 }, { 129,7321 }, { 130,7321 }, { 131,7321 },
 { 132,7321 }, { 133,7321 }, { 134,7321 }, { 135,7321 }, { 136,7321 },
 { 137,7321 }, { 138,7321 }, { 139,7321 }, { 140,7321 }, { 141,7321 },
 { 142,7321 }, { 143,7321 }, { 144,7321 }, { 145,7321 }, { 146,7321 },

 { 147,7321 }, { 148,7321 }, { 149,7321 }, { 150,7321 }, { 151,7321 },
 { 152,7321 }, { 153,7321 }, { 154,7321 }, { 155,7321 }, { 156,7321 },
 { 157,7321 }, { 158,7321 }, { 159,7321 }, { 160,7321 }, { 161,7321 },
 { 162,7321 }, { 163,7321 }, { 164,7321 }, { 165,7321 }, { 166,7321 },
 { 167,7321 }, { 168,7321 }, { 169,7321 }, { 170,7321 }, { 171,7321 },
 { 172,7321 }, { 173,7321 }, { 174,7321 }, { 175,7321 }, { 176,7321 },
 { 177,7321 }, { 178,7321 }, { 179,7321 }, { 180,7321 }, { 181,7321 },
 { 182,7321 }, { 183,7321 }, { 184,7321 }, { 185,7321 }, { 186,7321 },
 { 187,7321 }, { 188,7321 }, { 189,7321 }, { 190,7321 }, { 191,7321 },
 { 192,7321 }, { 193,7321 }, { 194,7321 }, { 195,7321 }, { 196,7321 },

 { 197,7321 }, { 198,7321 }, { 199,7321 }, { 200,7321 }, { 201,7321 },
 { 202,7321 }, { 203,7321 }, { 204,7321 }, { 205,7321 }, { 206,7321 },
 { 207,7321 }, { 208,7321 }, { 209,7321 }, { 210,7321 }, { 211,7321 },
 { 212,7321 }, { 213,7321 }, { 214,7321 }, { 215,7321 }, { 216,7321 },
 { 217,7321 }, { 218,7321 }, { 219,7321 }, { 220,7321 }, { 221,7321 },
 { 222,7321 }, { 223,7321 }, { 224,7321 }, { 225,7321 }, { 226,7321 },
 { 227,7321 }, { 228,7321 }, { 229,7321 }, { 230,7321 }, { 231,7321 },
 { 232,7321 }, { 233,7321 }, { 234,7321 }, { 235,7321 }, { 236,7321 },
 { 237,7321 }, { 238,7321 }, { 239,7321 }, { 240,7321 }, { 241,7321 },
 { 242,7321 }, { 243,7321 }, { 244,7321 }, { 245,7321 }, { 246,7321 },

 { 247,7321 }, { 248,7321 }, { 249,7321 }, { 250,7321 }, { 251,7321 },
 { 252,7321 }, { 253,7321 }, { 254,7321 }, { 255,7321 }, { 256,6192 },
 {   0,   0 }, {   0,33161 }, {   1,5934 }, {   2,5934 }, {   3,5934 },
 {   4,5934 }, {   5,5934 }, {   6,5934 }, {   7,5934 }, {   8,5934 },
 {   9,5936 }, {  10,5941 }, {  11,5936 }, {  12,5936 }, {  13,5936 },
 {  14,5934 }, {  15,5934 }, {  16,5934 }, {  17,5934 }, {  18,5934 },
 {  19,5934 }, {  20,5934 }, {  21,5934 }, {  22,5934 }, {  23,5934 },
 {  24,5934 }, {  25,5934 }, {  26,5934 }, {  27,5934 }, {  28,5934 },
 {  29,5934 }, {  30,5934 }, {  31,5934 }, {  32,5936 }, {  33,5943 },
 {  34,5938 }, {  35,5983 }, {  36,6049 }, {  37,6306 }, {  38,5983 },

 {  39,5956 }, {  40,5958 }, {  41,5958 }, {  42,6306 }, {  43,6306 },
 {  44,5958 }, {  45,6317 }, {  46,6336 }, {  47,6407 }, {  48,6439 },
 {  49,6696 }, {  50,6696 }, {  51,6696 }, {  52,6696 }, {  53,6696 },
 {  54,6696 }, {  55,6696 }, {  56,6696 }, {  57,6696 }, {  58,5961 },
 {  59,5958 }, {  60,6953 }, {  61,6964 }, {  62,7031 }, {  63,5983 },
 {  64,5983 }, {  65,7063 }, {  66,7320 }, {  67,7063 }, {  68,7063 },
 {  69,7577 }, {  70,7063 }, {  71,7063 }, {  72,7063 }, {  73,7063 },
 {  74,7063 }, {  75,7063 }, {  76,7063 }, {  77,7063 }, {  78,7834 },
 {  79,7063 }, {  80,7063 }, {  81,7063 }, {  82,7063 }, {  83,7063 },
 {  84,7063 }, {  85,8091 }, {  86,7063 }, {  87,7063 }, {  88,8348 },

 {  89,7063 }, {  90,7063 }, {  91,5958 }, {  92,5934 }, {  93,5958 },
 {  94,6306 }, {  95,7063 }, {  96,5983 }, {  97,7063 }, {  98,7320 },
 {  99,7063 }, { 100,7063 }, { 101,7577 }, { 102,7063 }, { 103,7063 },
 { 104,7063 }, { 105,7063 }, { 106,7063 }, { 107,7063 }, { 108,7063 },
 { 109,7063 }, { 110,7834 }, { 111,7063 }, { 112,7063 }, { 113,7063 },
 { 114,7063 }, { 115,7063 }, { 116,7063 }, { 117,8091 }, { 118,7063 },
 { 119,7063 }, { 120,8348 }, { 121,7063 }, { 122,7063 }, { 123,5934 },
 { 124,5983 }, { 125,5934 }, { 126,5983 }, { 127,5934 }, { 128,7063 },
 { 129,7063 }, { 130,7063 }, { 131,7063 }, { 132,7063 }, { 133,7063 },
 { 134,7063 }, { 135,7063 }, { 136,7063 }, { 137,7063 }, { 138,7063 },

 { 139,7063 }, { 140,7063 }, { 141,7063 }, { 142,7063 }, { 143,7063 },
 { 144,7063 }, { 145,7063 }, { 146,7063 }, { 147,7063 }, { 148,7063 },
 { 149,7063 }, { 150,7063 }, { 151,7063 }, { 152,7063 }, { 153,7063 },
 { 154,7063 }, { 155,7063 }, { 156,7063 }, { 157,7063 }, { 158,7063 },
 { 159,7063 }, { 160,7063 }, { 161,7063 }, { 162,7063 }, { 163,7063 },
 { 164,7063 }, { 165,7063 }, { 166,7063 }, { 167,7063 }, { 168,7063 },
 { 169,7063 }, { 170,7063 }, { 171,7063 }, { 172,7063 }, { 173,7063 },
 { 174,7063 }, { 175,7063 }, { 176,7063 }, { 177,7063 }, { 178,7063 },
 { 179,7063 }, { 180,7063 }, { 181,7063 }, { 182,7063 }, { 183,7063 },
 { 184,7063 }, { 185,7063 }, { 186,7063 }, { 187,7063 }, { 188,7063 },

 { 189,7063 }, { 190,7063 }, { 191,7063 }, { 192,7063 }, { 193,7063 },
 { 194,7063 }, { 195,7063 }, { 196,7063 }, { 197,7063 }, { 198,7063 },
 { 199,7063 }, { 200,7063 }, { 201,7063 }, { 202,7063 }, { 203,7063 },
 { 204,7063 }, { 205,7063 }, { 206,7063 }, { 207,7063 }, { 208,7063 },
 { 209,7063 }, { 210,7063 }, { 211,7063 }, { 212,7063 }, { 213,7063 },
 { 214,7063 }, { 215,7063 }, { 216,7063 }, { 217,7063 }, { 218,7063 },
 { 219,7063 }, { 220,7063 }, { 221,7063 }, { 222,7063 }, { 223,7063 },
 { 224,7063 }, { 225,7063 }, { 226,7063 }, { 227,7063 }, { 228,7063 },
 { 229,7063 }, { 230,7063 }, { 231,7063 }, { 232,7063 }, { 233,7063 },
 { 234,7063 }, { 235,7063 }, { 236,7063 }, { 237,7063 }, { 238,7063 },

 { 239,7063 }, { 240,7063 }, { 241,7063 }, { 242,7063 }, { 243,7063 },
 { 244,7063 }, { 245,7063 }, { 246,7063 }, { 247,7063 }, { 248,7063 },
 { 249,7063 }, { 250,7063 }, { 251,7063 }, { 252,7063 }, { 253,7063 },
 { 254,7063 }, { 255,7063 }, { 256,5934 }, {   0,  11 }, {   0,32903 },
 {   1,8347 }, {   2,8347 }, {   3,8347 }, {   4,8347 }, {   5,8347 },
 {   6,8347 }, {   7,8347 }, {   8,8347 }, {   9,8347 }, {  10,8347 },
 {  11,8347 }, {  12,8347 }, {  13,8347 }, {  14,8347 }, {  15,8347 },
 {  16,8347 }, {  17,8347 }, {  18,8347 }, {  19,8347 }, {  20,8347 },
 {  21,8347 }, {  22,8347 }, {  23,8347 }, {  24,8347 }, {  25,8347 },
 {  26,8347 }, {  27,8347 }, {  28,8347 }, {  29,8347 }, {  30,8347 },

 {  31,8347 }, {  32,8347 }, {  33,8347 }, {  34,8347 }, {  35,8347 },
 {  36,8347 }, {  37,8347 }, {  38,8347 }, {  39,5705 }, {  40,8347 },
 {  41,8347 }, {  42,8347 }, {  43,8347 }, {  44,8347 }, {  45,8347 },
 {  46,8347 }, {  47,8347 }, {  48,8347 }, {  49,8347 }, {  50,8347 },
 {  51,8347 }, {  52,8347 }, {  53,8347 }, {  54,8347 }, {  55,8347 },
 {  56,8347 }, {  57,8347 }, {  58,8347 }, {  59,8347 }, {  60,8347 },
 {  61,8347 }, {  62,8347 }, {  63,8347 }, {  64,8347 }, {  65,8347 },
 {  66,8347 }, {  67,8347 }, {  68,8347 }, {  69,8347 }, {  70,8347 },
 {  71,8347 }, {  72,8347 }, {  73,8347 }, {  74,8347 }, {  75,8347 },
 {  76,8347 }, {  77,8347 }, {  78,8347 }, {  79,8347 }, {  80,8347 },

 {  81,8347 }, {  82,8347 }, {  83,8347 }, {  84,8347 }, {  85,8347 },
 {  86,8347 }, {  87,8347 }, {  88,8347 }, {  89,8347 }, {  90,8347 },
 {  91,8347 }, {  92,8347 }, {  93,8347 }, {  94,8347 }, {  95,8347 },
 {  96,8347 }, {  97,8347 }, {  98,8347 }, {  99,8347 }, { 100,8347 },
 { 101,8347 }, { 102,8347 }, { 103,8347 }, { 104,8347 }, { 105,8347 },
 { 106,8347 }, { 107,8347 }, { 108,8347 }, { 109,8347 }, { 110,8347 },
 { 111,8347 }, { 112,8347 }, { 113,8347 }, { 114,8347 }, { 115,8347 },
 { 116,8347 }, { 117,8347 }, { 118,8347 }, { 119,8347 }, { 120,8347 },
 { 121,8347 }, { 122,8347 }, { 123,8347 }, { 124,8347 }, { 125,8347 },
 { 126,8347 }, { 127,8347 }, { 128,8347 }, { 129,8347 }, { 130,8347 },

 { 131,8347 }, { 132,8347 }, { 133,8347 }, { 134,8347 }, { 135,8347 },
 { 136,8347 }, { 137,8347 }, { 138,8347 }, { 139,8347 }, { 140,8347 },
 { 141,8347 }, { 142,8347 }, { 143,8347 }, { 144,8347 }, { 145,8347 },
 { 146,8347 }, { 147,8347 }, { 148,8347 }, { 149,8347 }, { 150,8347 },
 { 151,8347 }, { 152,8347 }, { 153,8347 }, { 154,8347 }, { 155,8347 },
 { 156,8347 }, { 157,8347 }, { 158,8347 }, { 159,8347 }, { 160,8347 },
 { 161,8347 }, { 162,8347 }, { 163,8347 }, { 164,8347 }, { 165,8347 },
 { 166,8347 }, { 167,8347 }, { 168,8347 }, { 169,8347 }, { 170,8347 },
 { 171,8347 }, { 172,8347 }, { 173,8347 }, { 174,8347 }, { 175,8347 },
 { 176,8347 }, { 177,8347 }, { 178,8347 }, { 179,8347 }, { 180,8347 },

 { 181,8347 }, { 182,8347 }, { 183,8347 }, { 184,8347 }, { 185,8347 },
 { 186,8347 }, { 187,8347 }, { 188,8347 }, { 189,8347 }, { 190,8347 },
 { 191,8347 }, { 192,8347 }, { 193,8347 }, { 194,8347 }, { 195,8347 },
 { 196,8347 }, { 197,8347 }, { 198,8347 }, { 199,8347 }, { 200,8347 },
 { 201,8347 }, { 202,8347 }, { 203,8347 }, { 204,8347 }, { 205,8347 },
 { 206,8347 }, { 207,8347 }, { 208,8347 }, { 209,8347 }, { 210,8347 },
 { 211,8347 }, { 212,8347 }, { 213,8347 }, { 214,8347 }, { 215,8347 },
 { 216,8347 }, { 217,8347 }, { 218,8347 }, { 219,8347 }, { 220,8347 },
 { 221,8347 }, { 222,8347 }, { 223,8347 }, { 224,8347 }, { 225,8347 },
 { 226,8347 }, { 227,8347 }, { 228,8347 }, { 229,8347 }, { 230,8347 },

 { 231,8347 }, { 232,8347 }, { 233,8347 }, { 234,8347 }, { 235,8347 },
 { 236,8347 }, { 237,8347 }, { 238,8347 }, { 239,8347 }, { 240,8347 },
 { 241,8347 }, { 242,8347 }, { 243,8347 }, { 244,8347 }, { 245,8347 },
 { 246,8347 }, { 247,8347 }, { 248,8347 }, { 249,8347 }, { 250,8347 },
 { 251,8347 }, { 252,8347 }, { 253,8347 }, { 254,8347 }, { 255,8347 },
 { 256,8347 }, {   0,  11 }, {   0,32645 }, {   1,8089 }, {   2,8089 },
 {   3,8089 }, {   4,8089 }, {   5,8089 }, {   6,8089 }, {   7,8089 },
 {   8,8089 }, {   9,8089 }, {  10,8089 }, {  11,8089 }, {  12,8089 },
 {  13,8089 }, {  14,8089 }, {  15,8089 }, {  16,8089 }, {  17,8089 },
 {  18,8089 }, {  19,8089 }, {  20,8089 }, {  21,8089 }, {  22,8089 },

 {  23,8089 }, {  24,8089 }, {  25,8089 }, {  26,8089 }, {  27,8089 },
 {  28,8089 }, {  29,8089 }, {  30,8089 }, {  31,8089 }, {  32,8089 },
 {  33,8089 }, {  34,8089 }, {  35,8089 }, {  36,8089 }, {  37,8089 },
 {  38,8089 }, {  39,5447 }, {  40,8089 }, {  41,8089 }, {  42,8089 },
 {  43,8089 }, {  44,8089 }, {  45,8089 }, {  46,8089 }, {  47,8089 },
 {  48,8089 }, {  49,8089 }, {  50,8089 }, {  51,8089 }, {  52,8089 },
 {  53,8089 }, {  54,8089 }, {  55,8089 }, {  56,8089 }, {  57,8089 },
 {  58,8089 }, {  59,8089 }, {  60,8089 }, {  61,8089 }, {  62,8089 },
 {  63,8089 }, {  64,8089 }, {  65,8089 }, {  66,8089 }, {  67,8089 },
 {  68,8089 }, {  69,8089 }, {  70,8089 }, {  71,8089 }, {  72,8089 },

 {  73,8089 }, {  74,8089 }, {  75,8089 }, {  76,8089 }, {  77,8089 },
 {  78,8089 }, {  79,8089 }, {  80,8089 }, {  81,8089 }, {  82,8089 },
 {  83,8089 }, {  84,8089 }, {  85,8089 }, {  86,8089 }, {  87,8089 },
 {  88,8089 }, {  89,8089 }, {  90,8089 }, {  91,8089 }, {  92,8089 },
 {  93,8089 }, {  94,8089 }, {  95,8089 }, {  96,8089 }, {  97,8089 },
 {  98,8089 }, {  99,8089 }, { 100,8089 }, { 101,8089 }, { 102,8089 },
 { 103,8089 }, { 104,8089 }, { 105,8089 }, { 106,8089 }, { 107,8089 },
 { 108,8089 }, { 109,8089 }, { 110,8089 }, { 111,8089 }, { 112,8089 },
 { 113,8089 }, { 114,8089 }, { 115,8089 }, { 116,8089 }, { 117,8089 },
 { 118,8089 }, { 119,8089 }, { 120,8089 }, { 121,8089 }, { 122,8089 },

 { 123,8089 }, { 124,8089 }, { 125,8089 }, { 126,8089 }, { 127,8089 },
 { 128,8089 }, { 129,8089 }, { 130,8089 }, { 131,8089 }, { 132,8089 },
 { 133,8089 }, { 134,8089 }, { 135,8089 }, { 136,8089 }, { 137,8089 },
 { 138,8089 }, { 139,8089 }, { 140,8089 }, { 141,8089 }, { 142,8089 },
 { 143,8089 }, { 144,8089 }, { 145,8089 }, { 146,8089 }, { 147,8089 },
 { 148,8089 }, { 149,8089 }, { 150,8089 }, { 151,8089 }, { 152,8089 },
 { 153,8089 }, { 154,8089 }, { 155,8089 }, { 156,8089 }, { 157,8089 },
 { 158,8089 }, { 159,8089 }, { 160,8089 }, { 161,8089 }, { 162,8089 },
 { 163,8089 }, { 164,8089 }, { 165,8089 }, { 166,8089 }, { 167,8089 },
 { 168,8089 }, { 169,8089 }, { 170,8089 }, { 171,8089 }, { 172,8089 },

 { 173,8089 }, { 174,8089 }, { 175,8089 }, { 176,8089 }, { 177,8089 },
 { 178,8089 }, { 179,8089 }, { 180,8089 }, { 181,8089 }, { 182,8089 },
 { 183,8089 }, { 184,8089 }, { 185,8089 }, { 186,8089 }, { 187,8089 },
 { 188,8089 }, { 189,8089 }, { 190,8089 }, { 191,8089 }, { 192,8089 },
 { 193,8089 }, { 194,8089 }, { 195,8089 }, { 196,8089 }, { 197,8089 },
 { 198,8089 }, { 199,8089 }, { 200,8089 }, { 201,8089 }, { 202,8089 },
 { 203,8089 }, { 204,8089 }, { 205,8089 }, { 206,8089 }, { 207,8089 },
 { 208,8089 }, { 209,8089 }, { 210,8089 }, { 211,8089 }, { 212,8089 },
 { 213,8089 }, { 214,8089 }, { 215,8089 }, { 216,8089 }, { 217,8089 },
 { 218,8089 }, { 219,8089 }, { 220,8089 }, { 221,8089 }, { 222,8089 },

 { 223,8089 }, { 224,8089 }, { 225,8089 }, { 226,8089 }, { 227,8089 },
 { 228,8089 }, { 229,8089 }, { 230,8089 }, { 231,8089 }, { 232,8089 },
 { 233,8089 }, { 234,8089 }, { 235,8089 }, { 236,8089 }, { 237,8089 },
 { 238,8089 }, { 239,8089 }, { 240,8089 }, { 241,8089 }, { 242,8089 },
 { 243,8089 }, { 244,8089 }, { 245,8089 }, { 246,8089 }, { 247,8089 },
 { 248,8089 }, { 249,8089 }, { 250,8089 }, { 251,8089 }, { 252,8089 },
 { 253,8089 }, { 254,8089 }, { 255,8089 }, { 256,8089 }, {   0,   0 },
 {   0,32387 }, {   1,8089 }, {   2,8089 }, {   3,8089 }, {   4,8089 },
 {   5,8089 }, {   6,8089 }, {   7,8089 }, {   8,8089 }, {   9,8089 },
 {  10,8089 }, {  11,8089 }, {  12,8089 }, {  13,8089 }, {  14,8089 },

 {  15,8089 }, {  16,8089 }, {  17,8089 }, {  18,8089 }, {  19,8089 },
 {  20,8089 }, {  21,8089 }, {  22,8089 }, {  23,8089 }, {  24,8089 },
 {  25,8089 }, {  26,8089 }, {  27,8089 }, {  28,8089 }, {  29,8089 },
 {  30,8089 }, {  31,8089 }, {  32,8089 }, {  33,8347 }, {  34,8089 },
 {  35,8347 }, {  36,8089 }, {  37,8347 }, {  38,8347 }, {  39,8089 },
 {  40,8089 }, {  41,8089 }, {  42,5192 }, {  43,8347 }, {  44,8089 },
 {  45,8347 }, {  46,8089 }, {  47,5196 }, {  48,8089 }, {  49,8089 },
 {  50,8089 }, {  51,8089 }, {  52,8089 }, {  53,8089 }, {  54,8089 },
 {  55,8089 }, {  56,8089 }, {  57,8089 }, {  58,8089 }, {  59,8089 },
 {  60,8347 }, {  61,8347 }, {  62,8347 }, {  63,8347 }, {  64,8347 },

 {  65,8089 }, {  66,8089 }, {  67,8089 }, {  68,8089 }, {  69,8089 },
 {  70,8089 }, {  71,8089 }, {  72,8089 }, {  73,8089 }, {  74,8089 },
 {  75,8089 }, {  76,8089 }, {  77,8089 }, {  78,8089 }, {  79,8089 },
 {  80,8089 }, {  81,8089 }, {  82,8089 }, {  83,8089 }, {  84,8089 },
 {  85,8089 }, {  86,8089 }, {  87,8089 }, {  88,8089 }, {  89,8089 },
 {  90,8089 }, {  91,8089 }, {  92,8089 }, {  93,8089 }, {  94,8347 },
 {  95,8089 }, {  96,8347 }, {  97,8089 }, {  98,8089 }, {  99,8089 },
 { 100,8089 }, { 101,8089 }, { 102,8089 }, { 103,8089 }, { 104,8089 },
 { 105,8089 }, { 106,8089 }, { 107,8089 }, { 108,8089 }, { 109,8089 },
 { 110,8089 }, { 111,8089 }, { 112,8089 }, { 113,8089 }, { 114,8089 },

 { 115,8089 }, { 116,8089 }, { 117,8089 }, { 118,8089 }, { 119,8089 },
 { 120,8089 }, { 121,8089 }, { 122,8089 }, { 123,8089 }, { 124,8347 },
 { 125,8089 }, { 126,8347 }, { 127,8089 }, { 128,8089 }, { 129,8089 },
 { 130,8089 }, { 131,8089 }, { 132,8089 }, { 133,8089 }, { 134,8089 },
 { 135,8089 }, { 136,8089 }, { 137,8089 }, { 138,8089 }, { 139,8089 },
 { 140,8089 }, { 141,8089 }, { 142,8089 }, { 143,8089 }, { 144,8089 },
 { 145,8089 }, { 146,8089 }, { 147,8089 }, { 148,8089 }, { 149,8089 },
 { 150,8089 }, { 151,8089 }, { 152,8089 }, { 153,8089 }, { 154,8089 },
 { 155,8089 }, { 156,8089 }, { 157,8089 }, { 158,8089 }, { 159,8089 },
 { 160,8089 }, { 161,8089 }, { 162,8089 }, { 163,8089 }, { 164,8089 },

 { 165,8089 }, { 166,8089 }, { 167,8089 }, { 168,8089 }, { 169,8089 },
 { 170,8089 }, { 171,8089 }, { 172,8089 }, { 173,8089 }, { 174,8089 },
 { 175,8089 }, { 176,8089 }, { 177,8089 }, { 178,8089 }, { 179,8089 },
 { 180,8089 }, { 181,8089 }, { 182,8089 }, { 183,8089 }, { 184,8089 },
 { 185,8089 }, { 186,8089 }, { 187,8089 }, { 188,8089 }, { 189,8089 },
 { 190,8089 }, { 191,8089 }, { 192,8089 }, { 193,8089 }, { 194,8089 },
 { 195,8089 }, { 196,8089 }, { 197,8089 }, { 198,8089 }, { 199,8089 },
 { 200,8089 }, { 201,8089 }, { 202,8089 }, { 203,8089 }, { 204,8089 },
 { 205,8089 }, { 206,8089 }, { 207,8089 }, { 208,8089 }, { 209,8089 },
 { 210,8089 }, { 211,8089 }, { 212,8089 }, { 213,8089 }, { 214,8089 },

 { 215,8089 }, { 216,8089 }, { 217,8089 }, { 218,8089 }, { 219,8089 },
 { 220,8089 }, { 221,8089 }, { 222,8089 }, { 223,8089 }, { 224,8089 },
 { 225,8089 }, { 226,8089 }, { 227,8089 }, { 228,8089 }, { 229,8089 },
 { 230,8089 }, { 231,8089 }, { 232,8089 }, { 233,8089 }, { 234,8089 },
 { 235,8089 }, { 236,8089 }, { 237,8089 }, { 238,8089 }, { 239,8089 },
 { 240,8089 }, { 241,8089 }, { 242,8089 }, { 243,8089 }, { 244,8089 },
 { 245,8089 }, { 246,8089 }, { 247,8089 }, { 248,8089 }, { 249,8089 },
 { 250,8089 }, { 251,8089 }, { 252,8089 }, { 253,8089 }, { 254,8089 },
 { 255,8089 }, { 256,8089 }, {   0,   0 }, {   0,32129 }, {   1,7831 },
 {   2,7831 }, {   3,7831 }, {   4,7831 }, {   5,7831 }, {   6,7831 },

 {   7,7831 }, {   8,7831 }, {   9,7831 }, {  10,7831 }, {  11,7831 },
 {  12,7831 }, {  13,7831 }, {  14,7831 }, {  15,7831 }, {  16,7831 },
 {  17,7831 }, {  18,7831 }, {  19,7831 }, {  20,7831 }, {  21,7831 },
 {  22,7831 }, {  23,7831 }, {  24,7831 }, {  25,7831 }, {  26,7831 },
 {  27,7831 }, {  28,7831 }, {  29,7831 }, {  30,7831 }, {  31,7831 },
 {  32,7831 }, {  33,8089 }, {  34,7831 }, {  35,8089 }, {  36,7831 },
 {  37,8089 }, {  38,8089 }, {  39,7831 }, {  40,7831 }, {  41,7831 },
 {  42,4934 }, {  43,8089 }, {  44,7831 }, {  45,8089 }, {  46,7831 },
 {  47,4938 }, {  48,7831 }, {  49,7831 }, {  50,7831 }, {  51,7831 },
 {  52,7831 }, {  53,7831 }, {  54,7831 }, {  55,7831 }, {  56,7831 },

 {  57,7831 }, {  58,7831 }, {  59,7831 }, {  60,8089 }, {  61,8089 },
 {  62,8089 }, {  63,8089 }, {  64,8089 }, {  65,7831 }, {  66,7831 },
 {  67,7831 }, {  68,7831 }, {  69,7831 }, {  70,7831 }, {  71,7831 },
 {  72,7831 }, {  73,7831 }, {  74,7831 }, {  75,7831 }, {  76,7831 },
 {  77,7831 }, {  78,7831 }, {  79,7831 }, {  80,7831 }, {  81,7831 },
 {  82,7831 }, {  83,7831 }, {  84,7831 }, {  85,7831 }, {  86,7831 },
 {  87,7831 }, {  88,7831 }, {  89,7831 }, {  90,7831 }, {  91,7831 },
 {  92,7831 }, {  93,7831 }, {  94,8089 }, {  95,7831 }, {  96,8089 },
 {  97,7831 }, {  98,7831 }, {  99,7831 }, { 100,7831 }, { 101,7831 },
 { 102,7831 }, { 103,7831 }, { 104,7831 }, { 105,7831 }, { 106,7831 },

 { 107,7831 }, { 108,7831 }, { 109,7831 }, { 110,7831 }, { 111,7831 },
 { 112,7831 }, { 113,7831 }, { 114,7831 }, { 115,7831 }, { 116,7831 },
 { 117,7831 }, { 118,7831 }, { 119,7831 }, { 120,7831 }, { 121,7831 },
 { 122,7831 }, { 123,7831 }, { 124,8089 }, { 125,7831 }, { 126,8089 },
 { 127,7831 }, { 128,7831 }, { 129,7831 }, { 130,7831 }, { 131,7831 },
 { 132,7831 }, { 133,7831 }, { 134,7831 }, { 135,7831 }, { 136,7831 },
 { 137,7831 }, { 138,7831 }, { 139,7831 }, { 140,7831 }, { 141,7831 },
 { 142,7831 }, { 143,7831 }, { 144,7831 }, { 145,7831 }, { 146,7831 },
 { 147,7831 }, { 148,7831 }, { 149,7831 }, { 150,7831 }, { 151,7831 },
 { 152,7831 }, { 153,7831 }, { 154,7831 }, { 155,7831 }, { 156,7831 },

 { 157,7831 }, { 158,7831 }, { 159,7831 }, { 160,7831 }, { 161,7831 },
 { 162,7831 }, { 163,7831 }, { 164,7831 }, { 165,7831 }, { 166,7831 },
 { 167,7831 }, { 168,7831 }, { 169,7831 }, { 170,7831 }, { 171,7831 },
 { 172,7831 }, { 173,7831 }, { 174,7831 }, { 175,7831 }, { 176,7831 },
 { 177,7831 }, { 178,7831 }, { 179,7831 }, { 180,7831 }, { 181,7831 },
 { 182,7831 }, { 183,7831 }, { 184,7831 }, { 185,7831 }, { 186,7831 },
 { 187,7831 }, { 188,7831 }, { 189,7831 }, { 190,7831 }, { 191,7831 },
 { 192,7831 }, { 193,7831 }, { 194,7831 }, { 195,7831 }, { 196,7831 },
 { 197,7831 }, { 198,7831 }, { 199,7831 }, { 200,7831 }, { 201,7831 },
 { 202,7831 }, { 203,7831 }, { 204,7831 }, { 205,7831 }, { 206,7831 },

 { 207,7831 }, { 208,7831 }, { 209,7831 }, { 210,7831 }, { 211,7831 },
 { 212,7831 }, { 213,7831 }, { 214,7831 }, { 215,7831 }, { 216,7831 },
 { 217,7831 }, { 218,7831 }, { 219,7831 }, { 220,7831 }, { 221,7831 },
 { 222,7831 }, { 223,7831 }, { 224,7831 }, { 225,7831 }, { 226,7831 },
 { 227,7831 }, { 228,7831 }, { 229,7831 }, { 230,7831 }, { 231,7831 },
 { 232,7831 }, { 233,7831 }, { 234,7831 }, { 235,7831 }, { 236,7831 },
 { 237,7831 }, { 238,7831 }, { 239,7831 }, { 240,7831 }, { 241,7831 },
 { 242,7831 }, { 243,7831 }, { 244,7831 }, { 245,7831 }, { 246,7831 },
 { 247,7831 }, { 248,7831 }, { 249,7831 }, { 250,7831 }, { 251,7831 },
 { 252,7831 }, { 253,7831 }, { 254,7831 }, { 255,7831 }, { 256,7831 },

 {   0,   0 }, {   0,31871 }, {   1,8089 }, {   2,8089 }, {   3,8089 },
 {   4,8089 }, {   5,8089 }, {   6,8089 }, {   7,8089 }, {   8,8089 },
 {   9,8089 }, {  10,8089 }, {  11,8089 }, {  12,8089 }, {  13,8089 },
 {  14,8089 }, {  15,8089 }, {  16,8089 }, {  17,8089 }, {  18,8089 },
 {  19,8089 }, {  20,8089 }, {  21,8089 }, {  22,8089 }, {  23,8089 },
 {  24,8089 }, {  25,8089 }, {  26,8089 }, {  27,8089 }, {  28,8089 },
 {  29,8089 }, {  30,8089 }, {  31,8089 }, {  32,8089 }, {  33,8089 },
 {  34,4685 }, {  35,8089 }, {  36,8089 }, {  37,8089 }, {  38,8089 },
 {  39,8089 }, {  40,8089 }, {  41,8089 }, {  42,8089 }, {  43,8089 },
 {  44,8089 }, {  45,8089 }, {  46,8089 }, {  47,8089 }, {  48,8089 },

 {  49,8089 }, {  50,8089 }, {  51,8089 }, {  52,8089 }, {  53,8089 },
 {  54,8089 }, {  55,8089 }, {  56,8089 }, {  57,8089 }, {  58,8089 },
 {  59,8089 }, {  60,8089 }, {  61,8089 }, {  62,8089 }, {  63,8089 },
 {  64,8089 }, {  65,8089 }, {  66,8089 }, {  67,8089 }, {  68,8089 },
 {  69,8089 }, {  70,8089 }, {  71,8089 }, {  72,8089 }, {  73,8089 },
 {  74,8089 }, {  75,8089 }, {  76,8089 }, {  77,8089 }, {  78,8089 },
 {  79,8089 }, {  80,8089 }, {  81,8089 }, {  82,8089 }, {  83,8089 },
 {  84,8089 }, {  85,8089 }, {  86,8089 }, {  87,8089 }, {  88,8089 },
 {  89,8089 }, {  90,8089 }, {  91,8089 }, {  92,8089 }, {  93,8089 },
 {  94,8089 }, {  95,8089 }, {  96,8089 }, {  97,8089 }, {  98,8089 },

 {  99,8089 }, { 100,8089 }, { 101,8089 }, { 102,8089 }, { 103,8089 },
 { 104,8089 }, { 105,8089 }, { 106,8089 }, { 107,8089 }, { 108,8089 },
 { 109,8089 }, { 110,8089 }, { 111,8089 }, { 112,8089 }, { 113,8089 },
 { 114,8089 }, { 115,8089 }, { 116,8089 }, { 117,8089 }, { 118,8089 },
 { 119,8089 }, { 120,8089 }, { 121,8089 }, { 122,8089 }, { 123,8089 },
 { 124,8089 }, { 125,8089 }, { 126,8089 }, { 127,8089 }, { 128,8089 },
 { 129,8089 }, { 130,8089 }, { 131,8089 }, { 132,8089 }, { 133,8089 },
 { 134,8089 }, { 135,8089 }, { 136,8089 }, { 137,8089 }, { 138,8089 },
 { 139,8089 }, { 140,8089 }, { 141,8089 }, { 142,8089 }, { 143,8089 },
 { 144,8089 }, { 145,8089 }, { 146,8089 }, { 147,8089 }, { 148,8089 },

 { 149,8089 }, { 150,8089 }, { 151,8089 }, { 152,8089 }, { 153,8089 },
 { 154,8089 }, { 155,8089 }, { 156,8089 }, { 157,8089 }, { 158,8089 },
 { 159,8089 }, { 160,8089 }, { 161,8089 }, { 162,8089 }, { 163,8089 },
 { 164,8089 }, { 165,8089 }, { 166,8089 }, { 167,8089 }, { 168,8089 },
 { 169,8089 }, { 170,8089 }, { 171,8089 }, { 172,8089 }, { 173,8089 },
 { 174,8089 }, { 175,8089 }, { 176,8089 }, { 177,8089 }, { 178,8089 },
 { 179,8089 }, { 180,8089 }, { 181,8089 }, { 182,8089 }, { 183,8089 },
 { 184,8089 }, { 185,8089 }, { 186,8089 }, { 187,8089 }, { 188,8089 },
 { 189,8089 }, { 190,8089 }, { 191,8089 }, { 192,8089 }, { 193,8089 },
 { 194,8089 }, { 195,8089 }, { 196,8089 }, { 197,8089 }, { 198,8089 },

 { 199,8089 }, { 200,8089 }, { 201,8089 }, { 202,8089 }, { 203,8089 },
 { 204,8089 }, { 205,8089 }, { 206,8089 }, { 207,8089 }, { 208,8089 },
 { 209,8089 }, { 210,8089 }, { 211,8089 }, { 212,8089 }, { 213,8089 },
 { 214,8089 }, { 215,8089 }, { 216,8089 }, { 217,8089 }, { 218,8089 },
 { 219,8089 }, { 220,8089 }, { 221,8089 }, { 222,8089 }, { 223,8089 },
 { 224,8089 }, { 225,8089 }, { 226,8089 }, { 227,8089 }, { 228,8089 },
 { 229,8089 }, { 230,8089 }, { 231,8089 }, { 232,8089 }, { 233,8089 },
 { 234,8089 }, { 235,8089 }, { 236,8089 }, { 237,8089 }, { 238,8089 },
 { 239,8089 }, { 240,8089 }, { 241,8089 }, { 242,8089 }, { 243,8089 },
 { 244,8089 }, { 245,8089 }, { 246,8089 }, { 247,8089 }, { 248,8089 },

 { 249,8089 }, { 250,8089 }, { 251,8089 }, { 252,8089 }, { 253,8089 },
 { 254,8089 }, { 255,8089 }, { 256,8089 }, {   0,   0 }, {   0,31613 },
 {   1,7831 }, {   2,7831 }, {   3,7831 }, {   4,7831 }, {   5,7831 },
 {   6,7831 }, {   7,7831 }, {   8,7831 }, {   9,7831 }, {  10,7831 },
 {  11,7831 }, {  12,7831 }, {  13,7831 }, {  14,7831 }, {  15,7831 },
 {  16,7831 }, {  17,7831 }, {  18,7831 }, {  19,7831 }, {  20,7831 },
 {  21,7831 }, {  22,7831 }, {  23,7831 }, {  24,7831 }, {  25,7831 },
 {  26,7831 }, {  27,7831 }, {  28,7831 }, {  29,7831 }, {  30,7831 },
 {  31,7831 }, {  32,7831 }, {  33,7831 }, {  34,4427 }, {  35,7831 },
 {  36,7831 }, {  37,7831 }, {  38,7831 }, {  39,7831 }, {  40,7831 },

 {  41,7831 }, {  42,7831 }, {  43,7831 }, {  44,7831 }, {  45,7831 },
 {  46,7831 }, {  47,7831 }, {  48,7831 }, {  49,7831 }, {  50,7831 },
 {  51,7831 }, {  52,7831 }, {  53,7831 }, {  54,7831 }, {  55,7831 },
 {  56,7831 }, {  57,7831 }, {  58,7831 }, {  59,7831 }, {  60,7831 },
 {  61,7831 }, {  62,7831 }, {  63,7831 }, {  64,7831 }, {  65,7831 },
 {  66,7831 }, {  67,7831 }, {  68,7831 }, {  69,7831 }, {  70,7831 },
 {  71,7831 }, {  72,7831 }, {  73,7831 }, {  74,7831 }, {  75,7831 },
 {  76,7831 }, {  77,7831 }, {  78,7831 }, {  79,7831 }, {  80,7831 },
 {  81,7831 }, {  82,7831 }, {  83,7831 }, {  84,7831 }, {  85,7831 },
 {  86,7831 }, {  87,7831 }, {  88,7831 }, {  89,7831 }, {  90,7831 },

 {  91,7831 }, {  92,7831 }, {  93,7831 }, {  94,7831 }, {  95,7831 },
 {  96,7831 }, {  97,7831 }, {  98,7831 }, {  99,7831 }, { 100,7831 },
 { 101,7831 }, { 102,7831 }, { 103,7831 }, { 104,7831 }, { 105,7831 },
 { 106,7831 }, { 107,7831 }, { 108,7831 }, { 109,7831 }, { 110,7831 },
 { 111,7831 }, { 112,7831 }, { 113,7831 }, { 114,7831 }, { 115,7831 },
 { 116,7831 }, { 117,7831 }, { 118,7831 }, { 119,7831 }, { 120,7831 },
 { 121,7831 }, { 122,7831 }, { 123,7831 }, { 124,7831 }, { 125,7831 },
 { 126,7831 }, { 127,7831 }, { 128,7831 }, { 129,7831 }, { 130,7831 },
 { 131,7831 }, { 132,7831 }, { 133,7831 }, { 134,7831 }, { 135,7831 },
 { 136,7831 }, { 137,7831 }, { 138,7831 }, { 139,7831 }, { 140,7831 },

 { 141,7831 }, { 142,7831 }, { 143,7831 }, { 144,7831 }, { 145,7831 },
 { 146,7831 }, { 147,7831 }, { 148,7831 }, { 149,7831 }, { 150,7831 },
 { 151,7831 }, { 152,7831 }, { 153,7831 }, { 154,7831 }, { 155,7831 },
 { 156,7831 }, { 157,7831 }, { 158,7831 }, { 159,7831 }, { 160,7831 },
 { 161,7831 }, { 162,7831 }, { 163,7831 }, { 164,7831 }, { 165,7831 },
 { 166,7831 }, { 167,7831 }, { 168,7831 }, { 169,7831 }, { 170,7831 },
 { 171,7831 }, { 172,7831 }, { 173,7831 }, { 174,7831 }, { 175,7831 },
 { 176,7831 }, { 177,7831 }, { 178,7831 }, { 179,7831 }, { 180,7831 },
 { 181,7831 }, { 182,7831 }, { 183,7831 }, { 184,7831 }, { 185,7831 },
 { 186,7831 }, { 187,7831 }, { 188,7831 }, { 189,7831 }, { 190,7831 },

 { 191,7831 }, { 192,7831 }, { 193,7831 }, { 194,7831 }, { 195,7831 },
 { 196,7831 }, { 197,7831 }, { 198,7831 }, { 199,7831 }, { 200,7831 },
 { 201,7831 }, { 202,7831 }, { 203,7831 }, { 204,7831 }, { 205,7831 },
 { 206,7831 }, { 207,7831 }, { 208,7831 }, { 209,7831 }, { 210,7831 },
 { 211,7831 }, { 212,7831 }, { 213,7831 }, { 214,7831 }, { 215,7831 },
 { 216,7831 }, { 217,7831 }, { 218,7831 }, { 219,7831 }, { 220,7831 },
 { 221,7831 }, { 222,7831 }, { 223,7831 }, { 224,7831 }, { 225,7831 },
 { 226,7831 }, { 227,7831 }, { 228,7831 }, { 229,7831 }, { 230,7831 },
 { 231,7831 }, { 232,7831 }, { 233,7831 }, { 234,7831 }, { 235,7831 },
 { 236,7831 }, { 237,7831 }, { 238,7831 }, { 239,7831 }, { 240,7831 },

 { 241,7831 }, { 242,7831 }, { 243,7831 }, { 244,7831 }, { 245,7831 },
 { 246,7831 }, { 247,7831 }, { 248,7831 }, { 249,7831 }, { 250,7831 },
 { 251,7831 }, { 252,7831 }, { 253,7831 }, { 254,7831 }, { 255,7831 },
 { 256,7831 }, {   0,  10 }, {   0,31355 }, {   1,7831 }, {   2,7831 },
 {   3,7831 }, {   4,7831 }, {   5,7831 }, {   6,7831 }, {   7,7831 },
 {   8,7831 }, {   9,7831 }, {  10,7831 }, {  11,7831 }, {  12,7831 },
 {  13,7831 }, {  14,7831 }, {  15,7831 }, {  16,7831 }, {  17,7831 },
 {  18,7831 }, {  19,7831 }, {  20,7831 }, {  21,7831 }, {  22,7831 },
 {  23,7831 }, {  24,7831 }, {  25,7831 }, {  26,7831 }, {  27,7831 },
 {  28,7831 }, {  29,7831 }, {  30,7831 }, {  31,7831 }, {  32,7831 },

 {  33,7831 }, {  34,7831 }, {  35,7831 }, {  36,7831 }, {  37,7831 },
 {  38,7831 }, {  39,4157 }, {  40,7831 }, {  41,7831 }, {  42,7831 },
 {  43,7831 }, {  44,7831 }, {  45,7831 }, {  46,7831 }, {  47,7831 },
 {  48,7831 }, {  49,7831 }, {  50,7831 }, {  51,7831 }, {  52,7831 },
 {  53,7831 }, {  54,7831 }, {  55,7831 }, {  56,7831 }, {  57,7831 },
 {  58,7831 }, {  59,7831 }, {  60,7831 }, {  61,7831 }, {  62,7831 },
 {  63,7831 }, {  64,7831 }, {  65,7831 }, {  66,7831 }, {  67,7831 },
 {  68,7831 }, {  69,7831 }, {  70,7831 }, {  71,7831 }, {  72,7831 },
 {  73,7831 }, {  74,7831 }, {  75,7831 }, {  76,7831 }, {  77,7831 },
 {  78,7831 }, {  79,7831 }, {  80,7831 }, {  81,7831 }, {  82,7831 },

 {  83,7831 }, {  84,7831 }, {  85,7831 }, {  86,7831 }, {  87,7831 },
 {  88,7831 }, {  89,7831 }, {  90,7831 }, {  91,7831 }, {  92,7831 },
 {  93,7831 }, {  94,7831 }, {  95,7831 }, {  96,7831 }, {  97,7831 },
 {  98,7831 }, {  99,7831 }, { 100,7831 }, { 101,7831 }, { 102,7831 },
 { 103,7831 }, { 104,7831 }, { 105,7831 }, { 106,7831 }, { 107,7831 },
 { 108,7831 }, { 109,7831 }, { 110,7831 }, { 111,7831 }, { 112,7831 },
 { 113,7831 }, { 114,7831 }, { 115,7831 }, { 116,7831 }, { 117,7831 },
 { 118,7831 }, { 119,7831 }, { 120,7831 }, { 121,7831 }, { 122,7831 },
 { 123,7831 }, { 124,7831 }, { 125,7831 }, { 126,7831 }, { 127,7831 },
 { 128,7831 }, { 129,7831 }, { 130,7831 }, { 131,7831 }, { 132,7831 },

 { 133,7831 }, { 134,7831 }, { 135,7831 }, { 136,7831 }, { 137,7831 },
 { 138,7831 }, { 139,7831 }, { 140,7831 }, { 141,7831 }, { 142,7831 },
 { 143,7831 }, { 144,7831 }, { 145,7831 }, { 146,7831 }, { 147,7831 },
 { 148,7831 }, { 149,7831 }, { 150,7831 }, { 151,7831 }, { 152,7831 },
 { 153,7831 }, { 154,7831 }, { 155,7831 }, { 156,7831 }, { 157,7831 },
 { 158,7831 }, { 159,7831 }, { 160,7831 }, { 161,7831 }, { 162,7831 },
 { 163,7831 }, { 164,7831 }, { 165,7831 }, { 166,7831 }, { 167,7831 },
 { 168,7831 }, { 169,7831 }, { 170,7831 }, { 171,7831 }, { 172,7831 },
 { 173,7831 }, { 174,7831 }, { 175,7831 }, { 176,7831 }, { 177,7831 },
 { 178,7831 }, { 179,7831 }, { 180,7831 }, { 181,7831 }, { 182,7831 },

 { 183,7831 }, { 184,7831 }, { 185,7831 }, { 186,7831 }, { 187,7831 },
 { 188,7831 }, { 189,7831 }, { 190,7831 }, { 191,7831 }, { 192,7831 },
 { 193,7831 }, { 194,7831 }, { 195,7831 }, { 196,7831 }, { 197,7831 },
 { 198,7831 }, { 199,7831 }, { 200,7831 }, { 201,7831 }, { 202,7831 },
 { 203,7831 }, { 204,7831 }, { 205,7831 }, { 206,7831 }, { 207,7831 },
 { 208,7831 }, { 209,7831 }, { 210,7831 }, { 211,7831 }, { 212,7831 },
 { 213,7831 }, { 214,7831 }, { 215,7831 }, { 216,7831 }, { 217,7831 },
 { 218,7831 }, { 219,7831 }, { 220,7831 }, { 221,7831 }, { 222,7831 },
 { 223,7831 }, { 224,7831 }, { 225,7831 }, { 226,7831 }, { 227,7831 },
 { 228,7831 }, { 229,7831 }, { 230,7831 }, { 231,7831 }, { 232,7831 },

 { 233,7831 }, { 234,7831 }, { 235,7831 }, { 236,7831 }, { 237,7831 },
 { 238,7831 }, { 239,7831 }, { 240,7831 }, { 241,7831 }, { 242,7831 },
 { 243,7831 }, { 244,7831 }, { 245,7831 }, { 246,7831 }, { 247,7831 },
 { 248,7831 }, { 249,7831 }, { 250,7831 }, { 251,7831 }, { 252,7831 },
 { 253,7831 }, { 254,7831 }, { 255,7831 }, { 256,7831 }, {   0,  10 },
 {   0,31097 }, {   1,7573 }, {   2,7573 }, {   3,7573 }, {   4,7573 },
 {   5,7573 }, {   6,7573 }, {   7,7573 }, {   8,7573 }, {   9,7573 },
 {  10,7573 }, {  11,7573 }, {  12,7573 }, {  13,7573 }, {  14,7573 },
 {  15,7573 }, {  16,7573 }, {  17,7573 }, {  18,7573 }, {  19,7573 },
 {  20,7573 }, {  21,7573 }, {  22,7573 }, {  23,7573 }, {  24,7573 },

 {  25,7573 }, {  26,7573 }, {  27,7573 }, {  28,7573 }, {  29,7573 },
 {  30,7573 }, {  31,7573 }, {  32,7573 }, {  33,7573 }, {  34,7573 },
 {  35,7573 }, {  36,7573 }, {  37,7573 }, {  38,7573 }, {  39,3899 },
 {  40,7573 }, {  41,7573 }, {  42,7573 }, {  43,7573 }, {  44,7573 },
 {  45,7573 }, {  46,7573 }, {  47,7573 }, {  48,7573 }, {  49,7573 },
 {  50,7573 }, {  51,7573 }, {  52,7573 }, {  53,7573 }, {  54,7573 },
 {  55,7573 }, {  56,7573 }, {  57,7573 }, {  58,7573 }, {  59,7573 },
 {  60,7573 }, {  61,7573 }, {  62,7573 }, {  63,7573 }, {  64,7573 },
 {  65,7573 }, {  66,7573 }, {  67,7573 }, {  68,7573 }, {  69,7573 },
 {  70,7573 }, {  71,7573 }, {  72,7573 }, {  73,7573 }, {  74,7573 },

 {  75,7573 }, {  76,7573 }, {  77,7573 }, {  78,7573 }, {  79,7573 },
 {  80,7573 }, {  81,7573 }, {  82,7573 }, {  83,7573 }, {  84,7573 },
 {  85,7573 }, {  86,7573 }, {  87,7573 }, {  88,7573 }, {  89,7573 },
 {  90,7573 }, {  91,7573 }, {  92,7573 }, {  93,7573 }, {  94,7573 },
 {  95,7573 }, {  96,7573 }, {  97,7573 }, {  98,7573 }, {  99,7573 },
 { 100,7573 }, { 101,7573 }, { 102,7573 }, { 103,7573 }, { 104,7573 },
 { 105,7573 }, { 106,7573 }, { 107,7573 }, { 108,7573 }, { 109,7573 },
 { 110,7573 }, { 111,7573 }, { 112,7573 }, { 113,7573 }, { 114,7573 },
 { 115,7573 }, { 116,7573 }, { 117,7573 }, { 118,7573 }, { 119,7573 },
 { 120,7573 }, { 121,7573 }, { 122,7573 }, { 123,7573 }, { 124,7573 },

 { 125,7573 }, { 126,7573 }, { 127,7573 }, { 128,7573 }, { 129,7573 },
 { 130,7573 }, { 131,7573 }, { 132,7573 }, { 133,7573 }, { 134,7573 },
 { 135,7573 }, { 136,7573 }, { 137,7573 }, { 138,7573 }, { 139,7573 },
 { 140,7573 }, { 141,7573 }, { 142,7573 }, { 143,7573 }, { 144,7573 },
 { 145,7573 }, { 146,7573 }, { 147,7573 }, { 148,7573 }, { 149,7573 },
 { 150,7573 }, { 151,7573 }, { 152,7573 }, { 153,7573 }, { 154,7573 },
 { 155,7573 }, { 156,7573 }, { 157,7573 }, { 158,7573 }, { 159,7573 },
 { 160,7573 }, { 161,7573 }, { 162,7573 }, { 163,7573 }, { 164,7573 },
 { 165,7573 }, { 166,7573 }, { 167,7573 }, { 168,7573 }, { 169,7573 },
 { 170,7573 }, { 171,7573 }, { 172,7573 }, { 173,7573 }, { 174,7573 },

 { 175,7573 }, { 176,7573 }, { 177,7573 }, { 178,7573 }, { 179,7573 },
 { 180,7573 }, { 181,7573 }, { 182,7573 }, { 183,7573 }, { 184,7573 },
 { 185,7573 }, { 186,7573 }, { 187,7573 }, { 188,7573 }, { 189,7573 },
 { 190,7573 }, { 191,7573 }, { 192,7573 }, { 193,7573 }, { 194,7573 },
 { 195,7573 }, { 196,7573 }, { 197,7573 }, { 198,7573 }, { 199,7573 },
 { 200,7573 }, { 201,7573 }, { 202,7573 }, { 203,7573 }, { 204,7573 },
 { 205,7573 }, { 206,7573 }, { 207,7573 }, { 208,7573 }, { 209,7573 },
 { 210,7573 }, { 211,7573 }, { 212,7573 }, { 213,7573 }, { 214,7573 },
 { 215,7573 }, { 216,7573 }, { 217,7573 }, { 218,7573 }, { 219,7573 },
 { 220,7573 }, { 221,7573 }, { 222,7573 }, { 223,7573 }, { 224,7573 },

 { 225,7573 }, { 226,7573 }, { 227,7573 }, { 228,7573 }, { 229,7573 },
 { 230,7573 }, { 231,7573 }, { 232,7573 }, { 233,7573 }, { 234,7573 },
 { 235,7573 }, { 236,7573 }, { 237,7573 }, { 238,7573 }, { 239,7573 },
 { 240,7573 }, { 241,7573 }, { 242,7573 }, { 243,7573 }, { 244,7573 },
 { 245,7573 }, { 246,7573 }, { 247,7573 }, { 248,7573 }, { 249,7573 },
 { 250,7573 }, { 251,7573 }, { 252,7573 }, { 253,7573 }, { 254,7573 },
 { 255,7573 }, { 256,7573 }, {   0,   0 }, {   0,30839 }, {   1,7573 },
 {   2,7573 }, {   3,7573 }, {   4,7573 }, {   5,7573 }, {   6,7573 },
 {   7,7573 }, {   8,7573 }, {   9,7573 }, {  10,7573 }, {  11,7573 },
 {  12,7573 }, {  13,7573 }, {  14,7573 }, {  15,7573 }, {  16,7573 },

 {  17,7573 }, {  18,7573 }, {  19,7573 }, {  20,7573 }, {  21,7573 },
 {  22,7573 }, {  23,7573 }, {  24,7573 }, {  25,7573 }, {  26,7573 },
 {  27,7573 }, {  28,7573 }, {  29,7573 }, {  30,7573 }, {  31,7573 },
 {  32,7573 }, {  33,7573 }, {  34,7573 }, {  35,7573 }, {  36,7573 },
 {  37,7573 }, {  38,7573 }, {  39,3670 }, {  40,7573 }, {  41,7573 },
 {  42,7573 }, {  43,7573 }, {  44,7573 }, {  45,7573 }, {  46,7573 },
 {  47,7573 }, {  48,7573 }, {  49,7573 }, {  50,7573 }, {  51,7573 },
 {  52,7573 }, {  53,7573 }, {  54,7573 }, {  55,7573 }, {  56,7573 },
 {  57,7573 }, {  58,7573 }, {  59,7573 }, {  60,7573 }, {  61,7573 },
 {  62,7573 }, {  63,7573 }, {  64,7573 }, {  65,7573 }, {  66,7573 },

 {  67,7573 }, {  68,7573 }, {  69,7573 }, {  70,7573 }, {  71,7573 },
 {  72,7573 }, {  73,7573 }, {  74,7573 }, {  75,7573 }, {  76,7573 },
 {  77,7573 }, {  78,7573 }, {  79,7573 }, {  80,7573 }, {  81,7573 },
 {  82,7573 }, {  83,7573 }, {  84,7573 }, {  85,7573 }, {  86,7573 },
 {  87,7573 }, {  88,7573 }, {  89,7573 }, {  90,7573 }, {  91,7573 },
 {  92,7573 }, {  93,7573 }, {  94,7573 }, {  95,7573 }, {  96,7573 },
 {  97,7573 }, {  98,7573 }, {  99,7573 }, { 100,7573 }, { 101,7573 },
 { 102,7573 }, { 103,7573 }, { 104,7573 }, { 105,7573 }, { 106,7573 },
 { 107,7573 }, { 108,7573 }, { 109,7573 }, { 110,7573 }, { 111,7573 },
 { 112,7573 }, { 113,7573 }, { 114,7573 }, { 115,7573 }, { 116,7573 },

 { 117,7573 }, { 118,7573 }, { 119,7573 }, { 120,7573 }, { 121,7573 },
 { 122,7573 }, { 123,7573 }, { 124,7573 }, { 125,7573 }, { 126,7573 },
 { 127,7573 }, { 128,7573 }, { 129,7573 }, { 130,7573 }, { 131,7573 },
 { 132,7573 }, { 133,7573 }, { 134,7573 }, { 135,7573 }, { 136,7573 },
 { 137,7573 }, { 138,7573 }, { 139,7573 }, { 140,7573 }, { 141,7573 },
 { 142,7573 }, { 143,7573 }, { 144,7573 }, { 145,7573 }, { 146,7573 },
 { 147,7573 }, { 148,7573 }, { 149,7573 }, { 150,7573 }, { 151,7573 },
 { 152,7573 }, { 153,7573 }, { 154,7573 }, { 155,7573 }, { 156,7573 },
 { 157,7573 }, { 158,7573 }, { 159,7573 }, { 160,7573 }, { 161,7573 },
 { 162,7573 }, { 163,7573 }, { 164,7573 }, { 165,7573 }, { 166,7573 },

 { 167,7573 }, { 168,7573 }, { 169,7573 }, { 170,7573 }, { 171,7573 },
 { 172,7573 }, { 173,7573 }, { 174,7573 }, { 175,7573 }, { 176,7573 },
 { 177,7573 }, { 178,7573 }, { 179,7573 }, { 180,7573 }, { 181,7573 },
 { 182,7573 }, { 183,7573 }, { 184,7573 }, { 185,7573 }, { 186,7573 },
 { 187,7573 }, { 188,7573 }, { 189,7573 }, { 190,7573 }, { 191,7573 },
 { 192,7573 }, { 193,7573 }, { 194,7573 }, { 195,7573 }, { 196,7573 },
 { 197,7573 }, { 198,7573 }, { 199,7573 }, { 200,7573 }, { 201,7573 },
 { 202,7573 }, { 203,7573 }, { 204,7573 }, { 205,7573 }, { 206,7573 },
 { 207,7573 }, { 208,7573 }, { 209,7573 }, { 210,7573 }, { 211,7573 },
 { 212,7573 }, { 213,7573 }, { 214,7573 }, { 215,7573 }, { 216,7573 },

 { 217,7573 }, { 218,7573 }, { 219,7573 }, { 220,7573 }, { 221,7573 },
 { 222,7573 }, { 223,7573 }, { 224,7573 }, { 225,7573 }, { 226,7573 },
 { 227,7573 }, { 228,7573 }, { 229,7573 }, { 230,7573 }, { 231,7573 },
 { 232,7573 }, { 233,7573 }, { 234,7573 }, { 235,7573 }, { 236,7573 },
 { 237,7573 }, { 238,7573 }, { 239,7573 }, { 240,7573 }, { 241,7573 },
 { 242,7573 }, { 243,7573 }, { 244,7573 }, { 245,7573 }, { 246,7573 },
 { 247,7573 }, { 248,7573 }, { 249,7573 }, { 250,7573 }, { 251,7573 },
 { 252,7573 }, { 253,7573 }, { 254,7573 }, { 255,7573 }, { 256,7573 },
 {   0,   0 }, {   0,30581 }, {   1,7315 }, {   2,7315 }, {   3,7315 },
 {   4,7315 }, {   5,7315 }, {   6,7315 }, {   7,7315 }, {   8,7315 },

 {   9,7315 }, {  10,7315 }, {  11,7315 }, {  12,7315 }, {  13,7315 },
 {  14,7315 }, {  15,7315 }, {  16,7315 }, {  17,7315 }, {  18,7315 },
 {  19,7315 }, {  20,7315 }, {  21,7315 }, {  22,7315 }, {  23,7315 },
 {  24,7315 }, {  25,7315 }, {  26,7315 }, {  27,7315 }, {  28,7315 },
 {  29,7315 }, {  30,7315 }, {  31,7315 }, {  32,7315 }, {  33,7315 },
 {  34,7315 }, {  35,7315 }, {  36,7315 }, {  37,7315 }, {  38,7315 },
 {  39,3412 }, {  40,7315 }, {  41,7315 }, {  42,7315 }, {  43,7315 },
 {  44,7315 }, {  45,7315 }, {  46,7315 }, {  47,7315 }, {  48,7315 },
 {  49,7315 }, {  50,7315 }, {  51,7315 }, {  52,7315 }, {  53,7315 },
 {  54,7315 }, {  55,7315 }, {  56,7315 }, {  57,7315 }, {  58,7315 },

 {  59,7315 }, {  60,7315 }, {  61,7315 }, {  62,7315 }, {  63,7315 },
 {  64,7315 }, {  65,7315 }, {  66,7315 }, {  67,7315 }, {  68,7315 },
 {  69,7315 }, {  70,7315 }, {  71,7315 }, {  72,7315 }, {  73,7315 },
 {  74,7315 }, {  75,7315 }, {  76,7315 }, {  77,7315 }, {  78,7315 },
 {  79,7315 }, {  80,7315 }, {  81,7315 }, {  82,7315 }, {  83,7315 },
 {  84,7315 }, {  85,7315 }, {  86,7315 }, {  87,7315 }, {  88,7315 },
 {  89,7315 }, {  90,7315 }, {  91,7315 }, {  92,7315 }, {  93,7315 },
 {  94,7315 }, {  95,7315 }, {  96,7315 }, {  97,7315 }, {  98,7315 },
 {  99,7315 }, { 100,7315 }, { 101,7315 }, { 102,7315 }, { 103,7315 },
 { 104,7315 }, { 105,7315 }, { 106,7315 }, { 107,7315 }, { 108,7315 },

 { 109,7315 }, { 110,7315 }, { 111,7315 }, { 112,7315 }, { 113,7315 },
 { 114,7315 }, { 115,7315 }, { 116,7315 }, { 117,7315 }, { 118,7315 },
 { 119,7315 }, { 120,7315 }, { 121,7315 }, { 122,7315 }, { 123,7315 },
 { 124,7315 }, { 125,7315 }, { 126,7315 }, { 127,7315 }, { 128,7315 },
 { 129,7315 }, { 130,7315 }, { 131,7315 }, { 132,7315 }, { 133,7315 },
 { 134,7315 }, { 135,7315 }, { 136,7315 }, { 137,7315 }, { 138,7315 },
 { 139,7315 }, { 140,7315 }, { 141,7315 }, { 142,7315 }, { 143,7315 },
 { 144,7315 }, { 145,7315 }, { 146,7315 }, { 147,7315 }, { 148,7315 },
 { 149,7315 }, { 150,7315 }, { 151,7315 }, { 152,7315 }, { 153,7315 },
 { 154,7315 }, { 155,7315 }, { 156,7315 }, { 157,7315 }, { 158,7315 },

 { 159,7315 }, { 160,7315 }, { 161,7315 }, { 162,7315 }, { 163,7315 },
 { 164,7315 }, { 165,7315 }, { 166,7315 }, { 167,7315 }, { 168,7315 },
 { 169,7315 }, { 170,7315 }, { 171,7315 }, { 172,7315 }, { 173,7315 },
 { 174,7315 }, { 175,7315 }, { 176,7315 }, { 177,7315 }, { 178,7315 },
 { 179,7315 }, { 180,7315 }, { 181,7315 }, { 182,7315 }, { 183,7315 },
 { 184,7315 }, { 185,7315 }, { 186,7315 }, { 187,7315 }, { 188,7315 },
 { 189,7315 }, { 190,7315 }, { 191,7315 }, { 192,7315 }, { 193,7315 },
 { 194,7315 }, { 195,7315 }, { 196,7315 }, { 197,7315 }, { 198,7315 },
 { 199,7315 }, { 200,7315 }, { 201,7315 }, { 202,7315 }, { 203,7315 },
 { 204,7315 }, { 205,7315 }, { 206,7315 }, { 207,7315 }, { 208,7315 },

 { 209,7315 }, { 210,7315 }, { 211,7315 }, { 212,7315 }, { 213,7315 },
 { 214,7315 }, { 215,7315 }, { 216,7315 }, { 217,7315 }, { 218,7315 },
 { 219,7315 }, { 220,7315 }, { 221,7315 }, { 222,7315 }, { 223,7315 },
 { 224,7315 }, { 225,7315 }, { 226,7315 }, { 227,7315 }, { 228,7315 },
 { 229,7315 }, { 230,7315 }, { 231,7315 }, { 232,7315 }, { 233,7315 },
 { 234,7315 }, { 235,7315 }, { 236,7315 }, { 237,7315 }, { 238,7315 },
 { 239,7315 }, { 240,7315 }, { 241,7315 }, { 242,7315 }, { 243,7315 },
 { 244,7315 }, { 245,7315 }, { 246,7315 }, { 247,7315 }, { 248,7315 },
 { 249,7315 }, { 250,7315 }, { 251,7315 }, { 252,7315 }, { 253,7315 },
 { 254,7315 }, { 255,7315 }, { 256,7315 }, {   0,  19 }, {   0,30323 },

 {   1,3156 }, {   2,3156 }, {   3,3156 }, {   4,3156 }, {   5,3156 },
 {   6,3156 }, {   7,3156 }, {   8,3156 }, {   9,7315 }, {  10,7320 },
 {  11,7315 }, {  12,7315 }, {  13,7344 }, {  14,3156 }, {  15,3156 },
 {  16,3156 }, {  17,3156 }, {  18,3156 }, {  19,3156 }, {  20,3156 },
 {  21,3156 }, {  22,3156 }, {  23,3156 }, {  24,3156 }, {  25,3156 },
 {  26,3156 }, {  27,3156 }, {  28,3156 }, {  29,3156 }, {  30,3156 },
 {  31,3156 }, {  32,7315 }, {  33,3156 }, {  34,3156 }, {  35,3156 },
 {  36,3156 }, {  37,3156 }, {  38,3156 }, {  39,3156 }, {  40,3156 },
 {  41,3156 }, {  42,3156 }, {  43,3156 }, {  44,3156 }, {  45,3158 },
 {  46,3156 }, {  47,3156 }, {  48,3156 }, {  49,3156 }, {  50,3156 },

 {  51,3156 }, {  52,3156 }, {  53,3156 }, {  54,3156 }, {  55,3156 },
 {  56,3156 }, {  57,3156 }, {  58,3156 }, {  59,3156 }, {  60,3156 },
 {  61,3156 }, {  62,3156 }, {  63,3156 }, {  64,3156 }, {  65,3156 },
 {  66,3156 }, {  67,3156 }, {  68,3156 }, {  69,3156 }, {  70,3156 },
 {  71,3156 }, {  72,3156 }, {  73,3156 }, {  74,3156 }, {  75,3156 },
 {  76,3156 }, {  77,3156 }, {  78,3156 }, {  79,3156 }, {  80,3156 },
 {  81,3156 }, {  82,3156 }, {  83,3156 }, {  84,3156 }, {  85,3156 },
 {  86,3156 }, {  87,3156 }, {  88,3156 }, {  89,3156 }, {  90,3156 },
 {  91,3156 }, {  92,3156 }, {  93,3156 }, {  94,3156 }, {  95,3156 },
 {  96,3156 }, {  97,3156 }, {  98,3156 }, {  99,3156 }, { 100,3156 },

 { 101,3156 }, { 102,3156 }, { 103,3156 }, { 104,3156 }, { 105,3156 },
 { 106,3156 }, { 107,3156 }, { 108,3156 }, { 109,3156 }, { 110,3156 },
 { 111,3156 }, { 112,3156 }, { 113,3156 }, { 114,3156 }, { 115,3156 },
 { 116,3156 }, { 117,3156 }, { 118,3156 }, { 119,3156 }, { 120,3156 },
 { 121,3156 }, { 122,3156 }, { 123,3156 }, { 124,3156 }, { 125,3156 },
 { 126,3156 }, { 127,3156 }, { 128,3156 }, { 129,3156 }, { 130,3156 },
 { 131,3156 }, { 132,3156 }, { 133,3156 }, { 134,3156 }, { 135,3156 },
 { 136,3156 }, { 137,3156 }, { 138,3156 }, { 139,3156 }, { 140,3156 },
 { 141,3156 }, { 142,3156 }, { 143,3156 }, { 144,3156 }, { 145,3156 },
 { 146,3156 }, { 147,3156 }, { 148,3156 }, { 149,3156 }, { 150,3156 },

 { 151,3156 }, { 152,3156 }, { 153,3156 }, { 154,3156 }, { 155,3156 },
 { 156,3156 }, { 157,3156 }, { 158,3156 }, { 159,3156 }, { 160,3156 },
 { 161,3156 }, { 162,3156 }, { 163,3156 }, { 164,3156 }, { 165,3156 },
 { 166,3156 }, { 167,3156 }, { 168,3156 }, { 169,3156 }, { 170,3156 },
 { 171,3156 }, { 172,3156 }, { 173,3156 }, { 174,3156 }, { 175,3156 },
 { 176,3156 }, { 177,3156 }, { 178,3156 }, { 179,3156 }, { 180,3156 },
 { 181,3156 }, { 182,3156 }, { 183,3156 }, { 184,3156 }, { 185,3156 },
 { 186,3156 }, { 187,3156 }, { 188,3156 }, { 189,3156 }, { 190,3156 },
 { 191,3156 }, { 192,3156 }, { 193,3156 }, { 194,3156 }, { 195,3156 },
 { 196,3156 }, { 197,3156 }, { 198,3156 }, { 199,3156 }, { 200,3156 },

 { 201,3156 }, { 202,3156 }, { 203,3156 }, { 204,3156 }, { 205,3156 },
 { 206,3156 }, { 207,3156 }, { 208,3156 }, { 209,3156 }, { 210,3156 },
 { 211,3156 }, { 212,3156 }, { 213,3156 }, { 214,3156 }, { 215,3156 },
 { 216,3156 }, { 217,3156 }, { 218,3156 }, { 219,3156 }, { 220,3156 },
 { 221,3156 }, { 222,3156 }, { 223,3156 }, { 224,3156 }, { 225,3156 },
 { 226,3156 }, { 227,3156 }, { 228,3156 }, { 229,3156 }, { 230,3156 },
 { 231,3156 }, { 232,3156 }, { 233,3156 }, { 234,3156 }, { 235,3156 },
 { 236,3156 }, { 237,3156 }, { 238,3156 }, { 239,3156 }, { 240,3156 },
 { 241,3156 }, { 242,3156 }, { 243,3156 }, { 244,3156 }, { 245,3156 },
 { 246,3156 }, { 247,3156 }, { 248,3156 }, { 249,3156 }, { 250,3156 },

 { 251,3156 }, { 252,3156 }, { 253,3156 }, { 254,3156 }, { 255,3156 },
 { 256,3156 }, {   0,  19 }, {   0,30065 }, {   1,2898 }, {   2,2898 },
 {   3,2898 }, {   4,2898 }, {   5,2898 }, {   6,2898 }, {   7,2898 },
 {   8,2898 }, {   9,7057 }, {  10,7062 }, {  11,7057 }, {  12,7057 },
 {  13,7086 }, {  14,2898 }, {  15,2898 }, {  16,2898 }, {  17,2898 },
 {  18,2898 }, {  19,2898 }, {  20,2898 }, {  21,2898 }, {  22,2898 },
 {  23,2898 }, {  24,2898 }, {  25,2898 }, {  26,2898 }, {  27,2898 },
 {  28,2898 }, {  29,2898 }, {  30,2898 }, {  31,2898 }, {  32,7057 },
 {  33,2898 }, {  34,2898 }, {  35,2898 }, {  36,2898 }, {  37,2898 },
 {  38,2898 }, {  39,2898 }, {  40,2898 }, {  41,2898 }, {  42,2898 },

 {  43,2898 }, {  44,2898 }, {  45,2900 }, {  46,2898 }, {  47,2898 },
 {  48,2898 }, {  49,2898 }, {  50,2898 }, {  51,2898 }, {  52,2898 },
 {  53,2898 }, {  54,2898 }, {  55,2898 }, {  56,2898 }, {  57,2898 },
 {  58,2898 }, {  59,2898 }, {  60,2898 }, {  61,2898 }, {  62,2898 },
 {  63,2898 }, {  64,2898 }, {  65,2898 }, {  66,2898 }, {  67,2898 },
 {  68,2898 }, {  69,2898 }, {  70,2898 }, {  71,2898 }, {  72,2898 },
 {  73,2898 }, {  74,2898 }, {  75,2898 }, {  76,2898 }, {  77,2898 },
 {  78,2898 }, {  79,2898 }, {  80,2898 }, {  81,2898 }, {  82,2898 },
 {  83,2898 }, {  84,2898 }, {  85,2898 }, {  86,2898 }, {  87,2898 },
 {  88,2898 }, {  89,2898 }, {  90,2898 }, {  91,2898 }, {  92,2898 },

 {  93,2898 }, {  94,2898 }, {  95,2898 }, {  96,2898 }, {  97,2898 },
 {  98,2898 }, {  99,2898 }, { 100,2898 }, { 101,2898 }, { 102,2898 },
 { 103,2898 }, { 104,2898 }, { 105,2898 }, { 106,2898 }, { 107,2898 },
 { 108,2898 }, { 109,2898 }, { 110,2898 }, { 111,2898 }, { 112,2898 },
 { 113,2898 }, { 114,2898 }, { 115,2898 }, { 116,2898 }, { 117,2898 },
 { 118,2898 }, { 119,2898 }, { 120,2898 }, { 121,2898 }, { 122,2898 },
 { 123,2898 }, { 124,2898 }, { 125,2898 }, { 126,2898 }, { 127,2898 },
 { 128,2898 }, { 129,2898 }, { 130,2898 }, { 131,2898 }, { 132,2898 },
 { 133,2898 }, { 134,2898 }, { 135,2898 }, { 136,2898 }, { 137,2898 },
 { 138,2898 }, { 139,2898 }, { 140,2898 }, { 141,2898 }, { 142,2898 },

 { 143,2898 }, { 144,2898 }, { 145,2898 }, { 146,2898 }, { 147,2898 },
 { 148,2898 }, { 149,2898 }, { 150,2898 }, { 151,2898 }, { 152,2898 },
 { 153,2898 }, { 154,2898 }, { 155,2898 }, { 156,2898 }, { 157,2898 },
 { 158,2898 }, { 159,2898 }, { 160,2898 }, { 161,2898 }, { 162,2898 },
 { 163,2898 }, { 164,2898 }, { 165,2898 }, { 166,2898 }, { 167,2898 },
 { 168,2898 }, { 169,2898 }, { 170,2898 }, { 171,2898 }, { 172,2898 },
 { 173,2898 }, { 174,2898 }, { 175,2898 }, { 176,2898 }, { 177,2898 },
 { 178,2898 }, { 179,2898 }, { 180,2898 }, { 181,2898 }, { 182,2898 },
 { 183,2898 }, { 184,2898 }, { 185,2898 }, { 186,2898 }, { 187,2898 },
 { 188,2898 }, { 189,2898 }, { 190,2898 }, { 191,2898 }, { 192,2898 },

 { 193,2898 }, { 194,2898 }, { 195,2898 }, { 196,2898 }, { 197,2898 },
 { 198,2898 }, { 199,2898 }, { 200,2898 }, { 201,2898 }, { 202,2898 },
 { 203,2898 }, { 204,2898 }, { 205,2898 }, { 206,2898 }, { 207,2898 },
 { 208,2898 }, { 209,2898 }, { 210,2898 }, { 211,2898 }, { 212,2898 },
 { 213,2898 }, { 214,2898 }, { 215,2898 }, { 216,2898 }, { 217,2898 },
 { 218,2898 }, { 219,2898 }, { 220,2898 }, { 221,2898 }, { 222,2898 },
 { 223,2898 }, { 224,2898 }, { 225,2898 }, { 226,2898 }, { 227,2898 },
 { 228,2898 }, { 229,2898 }, { 230,2898 }, { 231,2898 }, { 232,2898 },
 { 233,2898 }, { 234,2898 }, { 235,2898 }, { 236,2898 }, { 237,2898 },
 { 238,2898 }, { 239,2898 }, { 240,2898 }, { 241,2898 }, { 242,2898 },

 { 243,2898 }, { 244,2898 }, { 245,2898 }, { 246,2898 }, { 247,2898 },
 { 248,2898 }, { 249,2898 }, { 250,2898 }, { 251,2898 }, { 252,2898 },
 { 253,2898 }, { 254,2898 }, { 255,2898 }, { 256,2898 }, {   0,   0 },
 {   0,29807 }, {   1,6875 }, {   2,6875 }, {   3,6875 }, {   4,6875 },
 {   5,6875 }, {   6,6875 }, {   7,6875 }, {   8,6875 }, {   9,6875 },
 {  10,7133 }, {  11,6875 }, {  12,6875 }, {  13,6875 }, {  14,6875 },
 {  15,6875 }, {  16,6875 }, {  17,6875 }, {  18,6875 }, {  19,6875 },
 {  20,6875 }, {  21,6875 }, {  22,6875 }, {  23,6875 }, {  24,6875 },
 {  25,6875 }, {  26,6875 }, {  27,6875 }, {  28,6875 }, {  29,6875 },
 {  30,6875 }, {  31,6875 }, {  32,6875 }, {  33,6875 }, {  34,6875 },

 {  35,6875 }, {  36,6875 }, {  37,6875 }, {  38,6875 }, {  39,2645 },
 {  40,6875 }, {  41,6875 }, {  42,6875 }, {  43,6875 }, {  44,6875 },
 {  45,6875 }, {  46,6875 }, {  47,6875 }, {  48,6875 }, {  49,6875 },
 {  50,6875 }, {  51,6875 }, {  52,6875 }, {  53,6875 }, {  54,6875 },
 {  55,6875 }, {  56,6875 }, {  57,6875 }, {  58,6875 }, {  59,6875 },
 {  60,6875 }, {  61,6875 }, {  62,6875 }, {  63,6875 }, {  64,6875 },
 {  65,6875 }, {  66,6875 }, {  67,6875 }, {  68,6875 }, {  69,6875 },
 {  70,6875 }, {  71,6875 }, {  72,6875 }, {  73,6875 }, {  74,6875 },
 {  75,6875 }, {  76,6875 }, {  77,6875 }, {  78,6875 }, {  79,6875 },
 {  80,6875 }, {  81,6875 }, {  82,6875 }, {  83,6875 }, {  84,6875 },

 {  85,6875 }, {  86,6875 }, {  87,6875 }, {  88,6875 }, {  89,6875 },
 {  90,6875 }, {  91,6875 }, {  92,7391 }, {  93,6875 }, {  94,6875 },
 {  95,6875 }, {  96,6875 }, {  97,6875 }, {  98,6875 }, {  99,6875 },
 { 100,6875 }, { 101,6875 }, { 102,6875 }, { 103,6875 }, { 104,6875 },
 { 105,6875 }, { 106,6875 }, { 107,6875 }, { 108,6875 }, { 109,6875 },
 { 110,6875 }, { 111,6875 }, { 112,6875 }, { 113,6875 }, { 114,6875 },
 { 115,6875 }, { 116,6875 }, { 117,6875 }, { 118,6875 }, { 119,6875 },
 { 120,6875 }, { 121,6875 }, { 122,6875 }, { 123,6875 }, { 124,6875 },
 { 125,6875 }, { 126,6875 }, { 127,6875 }, { 128,6875 }, { 129,6875 },
 { 130,6875 }, { 131,6875 }, { 132,6875 }, { 133,6875 }, { 134,6875 },

 { 135,6875 }, { 136,6875 }, { 137,6875 }, { 138,6875 }, { 139,6875 },
 { 140,6875 }, { 141,6875 }, { 142,6875 }, { 143,6875 }, { 144,6875 },
 { 145,6875 }, { 146,6875 }, { 147,6875 }, { 148,6875 }, { 149,6875 },
 { 150,6875 }, { 151,6875 }, { 152,6875 }, { 153,6875 }, { 154,6875 },
 { 155,6875 }, { 156,6875 }, { 157,6875 }, { 158,6875 }, { 159,6875 },
 { 160,6875 }, { 161,6875 }, { 162,6875 }, { 163,6875 }, { 164,6875 },
 { 165,6875 }, { 166,6875 }, { 167,6875 }, { 168,6875 }, { 169,6875 },
 { 170,6875 }, { 171,6875 }, { 172,6875 }, { 173,6875 }, { 174,6875 },
 { 175,6875 }, { 176,6875 }, { 177,6875 }, { 178,6875 }, { 179,6875 },
 { 180,6875 }, { 181,6875 }, { 182,6875 }, { 183,6875 }, { 184,6875 },

 { 185,6875 }, { 186,6875 }, { 187,6875 }, { 188,6875 }, { 189,6875 },
 { 190,6875 }, { 191,6875 }, { 192,6875 }, { 193,6875 }, { 194,6875 },
 { 195,6875 }, { 196,6875 }, { 197,6875 }, { 198,6875 }, { 199,6875 },
 { 200,6875 }, { 201,6875 }, { 202,6875 }, { 203,6875 }, { 204,6875 },
 { 205,6875 }, { 206,6875 }, { 207,6875 }, { 208,6875 }, { 209,6875 },
 { 210,6875 }, { 211,6875 }, { 212,6875 }, { 213,6875 }, { 214,6875 },
 { 215,6875 }, { 216,6875 }, { 217,6875 }, { 218,6875 }, { 219,6875 },
 { 220,6875 }, { 221,6875 }, { 222,6875 }, { 223,6875 }, { 224,6875 },
 { 225,6875 }, { 226,6875 }, { 227,6875 }, { 228,6875 }, { 229,6875 },
 { 230,6875 }, { 231,6875 }, { 232,6875 }, { 233,6875 }, { 234,6875 },

 { 235,6875 }, { 236,6875 }, { 237,6875 }, { 238,6875 }, { 239,6875 },
 { 240,6875 }, { 241,6875 }, { 242,6875 }, { 243,6875 }, { 244,6875 },
 { 245,6875 }, { 246,6875 }, { 247,6875 }, { 248,6875 }, { 249,6875 },
 { 250,6875 }, { 251,6875 }, { 252,6875 }, { 253,6875 }, { 254,6875 },
 { 255,6875 }, { 256,6875 }, {   0,   0 }, {   0,29549 }, {   1,6617 },
 {   2,6617 }, {   3,6617 }, {   4,6617 }, {   5,6617 }, {   6,6617 },
 {   7,6617 }, {   8,6617 }, {   9,6617 }, {  10,6875 }, {  11,6617 },
 {  12,6617 }, {  13,6617 }, {  14,6617 }, {  15,6617 }, {  16,6617 },
 {  17,6617 }, {  18,6617 }, {  19,6617 }, {  20,6617 }, {  21,6617 },
 {  22,6617 }, {  23,6617 }, {  24,6617 }, {  25,6617 }, {  26,6617 },

 {  27,6617 }, {  28,6617 }, {  29,6617 }, {  30,6617 }, {  31,6617 },
 {  32,6617 }, {  33,6617 }, {  34,6617 }, {  35,6617 }, {  36,6617 },
 {  37,6617 }, {  38,6617 }, {  39,2387 }, {  40,6617 }, {  41,6617 },
 {  42,6617 }, {  43,6617 }, {  44,6617 }, {  45,6617 }, {  46,6617 },
 {  47,6617 }, {  48,6617 }, {  49,6617 }, {  50,6617 }, {  51,6617 },
 {  52,6617 }, {  53,6617 }, {  54,6617 }, {  55,6617 }, {  56,6617 },
 {  57,6617 }, {  58,6617 }, {  59,6617 }, {  60,6617 }, {  61,6617 },
 {  62,6617 }, {  63,6617 }, {  64,6617 }, {  65,6617 }, {  66,6617 },
 {  67,6617 }, {  68,6617 }, {  69,6617 }, {  70,6617 }, {  71,6617 },
 {  72,6617 }, {  73,6617 }, {  74,6617 }, {  75,6617 }, {  76,6617 },

 {  77,6617 }, {  78,6617 }, {  79,6617 }, {  80,6617 }, {  81,6617 },
 {  82,6617 }, {  83,6617 }, {  84,6617 }, {  85,6617 }, {  86,6617 },
 {  87,6617 }, {  88,6617 }, {  89,6617 }, {  90,6617 }, {  91,6617 },
 {  92,7133 }, {  93,6617 }, {  94,6617 }, {  95,6617 }, {  96,6617 },
 {  97,6617 }, {  98,6617 }, {  99,6617 }, { 100,6617 }, { 101,6617 },
 { 102,6617 }, { 103,6617 }, { 104,6617 }, { 105,6617 }, { 106,6617 },
 { 107,6617 }, { 108,6617 }, { 109,6617 }, { 110,6617 }, { 111,6617 },
 { 112,6617 }, { 113,6617 }, { 114,6617 }, { 115,6617 }, { 116,6617 },
 { 117,6617 }, { 118,6617 }, { 119,6617 }, { 120,6617 }, { 121,6617 },
 { 122,6617 }, { 123,6617 }, { 124,6617 }, { 125,6617 }, { 126,6617 },

 { 127,6617 }, { 128,6617 }, { 129,6617 }, { 130,6617 }, { 131,6617 },
 { 132,6617 }, { 133,6617 }, { 134,6617 }, { 135,6617 }, { 136,6617 },
 { 137,6617 }, { 138,6617 }, { 139,6617 }, { 140,6617 }, { 141,6617 },
 { 142,6617 }, { 143,6617 }, { 144,6617 }, { 145,6617 }, { 146,6617 },
 { 147,6617 }, { 148,6617 }, { 149,6617 }, { 150,6617 }, { 151,6617 },
 { 152,6617 }, { 153,6617 }, { 154,6617 }, { 155,6617 }, { 156,6617 },
 { 157,6617 }, { 158,6617 }, { 159,6617 }, { 160,6617 }, { 161,6617 },
 { 162,6617 }, { 163,6617 }, { 164,6617 }, { 165,6617 }, { 166,6617 },
 { 167,6617 }, { 168,6617 }, { 169,6617 }, { 170,6617 }, { 171,6617 },
 { 172,6617 }, { 173,6617 }, { 174,6617 }, { 175,6617 }, { 176,6617 },

 { 177,6617 }, { 178,6617 }, { 179,6617 }, { 180,6617 }, { 181,6617 },
 { 182,6617 }, { 183,6617 }, { 184,6617 }, { 185,6617 }, { 186,6617 },
 { 187,6617 }, { 188,6617 }, { 189,6617 }, { 190,6617 }, { 191,6617 },
 { 192,6617 }, { 193,6617 }, { 194,6617 }, { 195,6617 }, { 196,6617 },
 { 197,6617 }, { 198,6617 }, { 199,6617 }, { 200,6617 }, { 201,6617 },
 { 202,6617 }, { 203,6617 }, { 204,6617 }, { 205,6617 }, { 206,6617 },
 { 207,6617 }, { 208,6617 }, { 209,6617 }, { 210,6617 }, { 211,6617 },
 { 212,6617 }, { 213,6617 }, { 214,6617 }, { 215,6617 }, { 216,6617 },
 { 217,6617 }, { 218,6617 }, { 219,6617 }, { 220,6617 }, { 221,6617 },
 { 222,6617 }, { 223,6617 }, { 224,6617 }, { 225,6617 }, { 226,6617 },

 { 227,6617 }, { 228,6617 }, { 229,6617 }, { 230,6617 }, { 231,6617 },
 { 232,6617 }, { 233,6617 }, { 234,6617 }, { 235,6617 }, { 236,6617 },
 { 237,6617 }, { 238,6617 }, { 239,6617 }, { 240,6617 }, { 241,6617 },
 { 242,6617 }, { 243,6617 }, { 244,6617 }, { 245,6617 }, { 246,6617 },
 { 247,6617 }, { 248,6617 }, { 249,6617 }, { 250,6617 }, { 251,6617 },
 { 252,6617 }, { 253,6617 }, { 254,6617 }, { 255,6617 }, { 256,6617 },
 {   0,   0 }, {   0,29291 }, {   1,7133 }, {   2,7133 }, {   3,7133 },
 {   4,7133 }, {   5,7133 }, {   6,7133 }, {   7,7133 }, {   8,7133 },
 {   9,7133 }, {  10,7391 }, {  11,7133 }, {  12,7133 }, {  13,7133 },
 {  14,7133 }, {  15,7133 }, {  16,7133 }, {  17,7133 }, {  18,7133 },

 {  19,7133 }, {  20,7133 }, {  21,7133 }, {  22,7133 }, {  23,7133 },
 {  24,7133 }, {  25,7133 }, {  26,7133 }, {  27,7133 }, {  28,7133 },
 {  29,7133 }, {  30,7133 }, {  31,7133 }, {  32,7133 }, {  33,7133 },
 {  34,7133 }, {  35,7133 }, {  36,7649 }, {  37,7133 }, {  38,7133 },
 {  39,7133 }, {  40,7133 }, {  41,7133 }, {  42,7133 }, {  43,7133 },
 {  44,7133 }, {  45,7133 }, {  46,7133 }, {  47,7133 }, {  48,7133 },
 {  49,7133 }, {  50,7133 }, {  51,7133 }, {  52,7133 }, {  53,7133 },
 {  54,7133 }, {  55,7133 }, {  56,7133 }, {  57,7133 }, {  58,7133 },
 {  59,7133 }, {  60,7133 }, {  61,7133 }, {  62,7133 }, {  63,7133 },
 {  64,7133 }, {  65,7133 }, {  66,7133 }, {  67,7133 }, {  68,7133 },

 {  69,7133 }, {  70,7133 }, {  71,7133 }, {  72,7133 }, {  73,7133 },
 {  74,7133 }, {  75,7133 }, {  76,7133 }, {  77,7133 }, {  78,7133 },
 {  79,7133 }, {  80,7133 }, {  81,7133 }, {  82,7133 }, {  83,7133 },
 {  84,7133 }, {  85,7133 }, {  86,7133 }, {  87,7133 }, {  88,7133 },
 {  89,7133 }, {  90,7133 }, {  91,7133 }, {  92,7133 }, {  93,7133 },
 {  94,7133 }, {  95,7133 }, {  96,7133 }, {  97,7133 }, {  98,7133 },
 {  99,7133 }, { 100,7133 }, { 101,7133 }, { 102,7133 }, { 103,7133 },
 { 104,7133 }, { 105,7133 }, { 106,7133 }, { 107,7133 }, { 108,7133 },
 { 109,7133 }, { 110,7133 }, { 111,7133 }, { 112,7133 }, { 113,7133 },
 { 114,7133 }, { 115,7133 }, { 116,7133 }, { 117,7133 }, { 118,7133 },

 { 119,7133 }, { 120,7133 }, { 121,7133 }, { 122,7133 }, { 123,7133 },
 { 124,7133 }, { 125,7133 }, { 126,7133 }, { 127,7133 }, { 128,7133 },
 { 129,7133 }, { 130,7133 }, { 131,7133 }, { 132,7133 }, { 133,7133 },
 { 134,7133 }, { 135,7133 }, { 136,7133 }, { 137,7133 }, { 138,7133 },
 { 139,7133 }, { 140,7133 }, { 141,7133 }, { 142,7133 }, { 143,7133 },
 { 144,7133 }, { 145,7133 }, { 146,7133 }, { 147,7133 }, { 148,7133 },
 { 149,7133 }, { 150,7133 }, { 151,7133 }, { 152,7133 }, { 153,7133 },
 { 154,7133 }, { 155,7133 }, { 156,7133 }, { 157,7133 }, { 158,7133 },
 { 159,7133 }, { 160,7133 }, { 161,7133 }, { 162,7133 }, { 163,7133 },
 { 164,7133 }, { 165,7133 }, { 166,7133 }, { 167,7133 }, { 168,7133 },

 { 169,7133 }, { 170,7133 }, { 171,7133 }, { 172,7133 }, { 173,7133 },
 { 174,7133 }, { 175,7133 }, { 176,7133 }, { 177,7133 }, { 178,7133 },
 { 179,7133 }, { 180,7133 }, { 181,7133 }, { 182,7133 }, { 183,7133 },
 { 184,7133 }, { 185,7133 }, { 186,7133 }, { 187,7133 }, { 188,7133 },
 { 189,7133 }, { 190,7133 }, { 191,7133 }, { 192,7133 }, { 193,7133 },
 { 194,7133 }, { 195,7133 }, { 196,7133 }, { 197,7133 }, { 198,7133 },
 { 199,7133 }, { 200,7133 }, { 201,7133 }, { 202,7133 }, { 203,7133 },
 { 204,7133 }, { 205,7133 }, { 206,7133 }, { 207,7133 }, { 208,7133 },
 { 209,7133 }, { 210,7133 }, { 211,7133 }, { 212,7133 }, { 213,7133 },
 { 214,7133 }, { 215,7133 }, { 216,7133 }, { 217,7133 }, { 218,7133 },

 { 219,7133 }, { 220,7133 }, { 221,7133 }, { 222,7133 }, { 223,7133 },
 { 224,7133 }, { 225,7133 }, { 226,7133 }, { 227,7133 }, { 228,7133 },
 { 229,7133 }, { 230,7133 }, { 231,7133 }, { 232,7133 }, { 233,7133 },
 { 234,7133 }, { 235,7133 }, { 236,7133 }, { 237,7133 }, { 238,7133 },
 { 239,7133 }, { 240,7133 }, { 241,7133 }, { 242,7133 }, { 243,7133 },
 { 244,7133 }, { 245,7133 }, { 246,7133 }, { 247,7133 }, { 248,7133 },
 { 249,7133 }, { 250,7133 }, { 251,7133 }, { 252,7133 }, { 253,7133 },
 { 254,7133 }, { 255,7133 }, { 256,7133 }, {   0,   0 }, {   0,29033 },
 {   1,6875 }, {   2,6875 }, {   3,6875 }, {   4,6875 }, {   5,6875 },
 {   6,6875 }, {   7,6875 }, {   8,6875 }, {   9,6875 }, {  10,7133 },

 {  11,6875 }, {  12,6875 }, {  13,6875 }, {  14,6875 }, {  15,6875 },
 {  16,6875 }, {  17,6875 }, {  18,6875 }, {  19,6875 }, {  20,6875 },
 {  21,6875 }, {  22,6875 }, {  23,6875 }, {  24,6875 }, {  25,6875 },
 {  26,6875 }, {  27,6875 }, {  28,6875 }, {  29,6875 }, {  30,6875 },
 {  31,6875 }, {  32,6875 }, {  33,6875 }, {  34,6875 }, {  35,6875 },
 {  36,7391 }, {  37,6875 }, {  38,6875 }, {  39,6875 }, {  40,6875 },
 {  41,6875 }, {  42,6875 }, {  43,6875 }, {  44,6875 }, {  45,6875 },
 {  46,6875 }, {  47,6875 }, {  48,6875 }, {  49,6875 }, {  50,6875 },
 {  51,6875 }, {  52,6875 }, {  53,6875 }, {  54,6875 }, {  55,6875 },
 {  56,6875 }, {  57,6875 }, {  58,6875 }, {  59,6875 }, {  60,6875 },

 {  61,6875 }, {  62,6875 }, {  63,6875 }, {  64,6875 }, {  65,6875 },
 {  66,6875 }, {  67,6875 }, {  68,6875 }, {  69,6875 }, {  70,6875 },
 {  71,6875 }, {  72,6875 }, {  73,6875 }, {  74,6875 }, {  75,6875 },
 {  76,6875 }, {  77,6875 }, {  78,6875 }, {  79,6875 }, {  80,6875 },
 {  81,6875 }, {  82,6875 }, {  83,6875 }, {  84,6875 }, {  85,6875 },
 {  86,6875 }, {  87,6875 }, {  88,6875 }, {  89,6875 }, {  90,6875 },
 {  91,6875 }, {  92,6875 }, {  93,6875 }, {  94,6875 }, {  95,6875 },
 {  96,6875 }, {  97,6875 }, {  98,6875 }, {  99,6875 }, { 100,6875 },
 { 101,6875 }, { 102,6875 }, { 103,6875 }, { 104,6875 }, { 105,6875 },
 { 106,6875 }, { 107,6875 }, { 108,6875 }, { 109,6875 }, { 110,6875 },

 { 111,6875 }, { 112,6875 }, { 113,6875 }, { 114,6875 }, { 115,6875 },
 { 116,6875 }, { 117,6875 }, { 118,6875 }, { 119,6875 }, { 120,6875 },
 { 121,6875 }, { 122,6875 }, { 123,6875 }, { 124,6875 }, { 125,6875 },
 { 126,6875 }, { 127,6875 }, { 128,6875 }, { 129,6875 }, { 130,6875 },
 { 131,6875 }, { 132,6875 }, { 133,6875 }, { 134,6875 }, { 135,6875 },
 { 136,6875 }, { 137,6875 }, { 138,6875 }, { 139,6875 }, { 140,6875 },
 { 141,6875 }, { 142,6875 }, { 143,6875 }, { 144,6875 }, { 145,6875 },
 { 146,6875 }, { 147,6875 }, { 148,6875 }, { 149,6875 }, { 150,6875 },
 { 151,6875 }, { 152,6875 }, { 153,6875 }, { 154,6875 }, { 155,6875 },
 { 156,6875 }, { 157,6875 }, { 158,6875 }, { 159,6875 }, { 160,6875 },

 { 161,6875 }, { 162,6875 }, { 163,6875 }, { 164,6875 }, { 165,6875 },
 { 166,6875 }, { 167,6875 }, { 168,6875 }, { 169,6875 }, { 170,6875 },
 { 171,6875 }, { 172,6875 }, { 173,6875 }, { 174,6875 }, { 175,6875 },
 { 176,6875 }, { 177,6875 }, { 178,6875 }, { 179,6875 }, { 180,6875 },
 { 181,6875 }, { 182,6875 }, { 183,6875 }, { 184,6875 }, { 185,6875 },
 { 186,6875 }, { 187,6875 }, { 188,6875 }, { 189,6875 }, { 190,6875 },
 { 191,6875 }, { 192,6875 }, { 193,6875 }, { 194,6875 }, { 195,6875 },
 { 196,6875 }, { 197,6875 }, { 198,6875 }, { 199,6875 }, { 200,6875 },
 { 201,6875 }, { 202,6875 }, { 203,6875 }, { 204,6875 }, { 205,6875 },
 { 206,6875 }, { 207,6875 }, { 208,6875 }, { 209,6875 }, { 210,6875 },

 { 211,6875 }, { 212,6875 }, { 213,6875 }, { 214,6875 }, { 215,6875 },
 { 216,6875 }, { 217,6875 }, { 218,6875 }, { 219,6875 }, { 220,6875 },
 { 221,6875 }, { 222,6875 }, { 223,6875 }, { 224,6875 }, { 225,6875 },
 { 226,6875 }, { 227,6875 }, { 228,6875 }, { 229,6875 }, { 230,6875 },
 { 231,6875 }, { 232,6875 }, { 233,6875 }, { 234,6875 }, { 235,6875 },
 { 236,6875 }, { 237,6875 }, { 238,6875 }, { 239,6875 }, { 240,6875 },
 { 241,6875 }, { 242,6875 }, { 243,6875 }, { 244,6875 }, { 245,6875 },
 { 246,6875 }, { 247,6875 }, { 248,6875 }, { 249,6875 }, { 250,6875 },
 { 251,6875 }, { 252,6875 }, { 253,6875 }, { 254,6875 }, { 255,6875 },
 { 256,6875 }, {   0,   0 }, {   0,28775 }, {   1,4993 }, {   2,4993 },

 {   3,4993 }, {   4,4993 }, {   5,4993 }, {   6,4993 }, {   7,4993 },
 {   8,4993 }, {   9,4993 }, {  10,4993 }, {  11,4993 }, {  12,4993 },
 {  13,4993 }, {  14,4993 }, {  15,4993 }, {  16,4993 }, {  17,4993 },
 {  18,4993 }, {  19,4993 }, {  20,4993 }, {  21,4993 }, {  22,4993 },
 {  23,4993 }, {  24,4993 }, {  25,4993 }, {  26,4993 }, {  27,4993 },
 {  28,4993 }, {  29,4993 }, {  30,4993 }, {  31,4993 }, {  32,4993 },
 {  33,4993 }, {  34,1615 }, {  35,4993 }, {  36,4993 }, {  37,4993 },
 {  38,4993 }, {  39,4993 }, {  40,4993 }, {  41,4993 }, {  42,4993 },
 {  43,4993 }, {  44,4993 }, {  45,4993 }, {  46,4993 }, {  47,4993 },
 {  48,4993 }, {  49,4993 }, {  50,4993 }, {  51,4993 }, {  52,4993 },

 {  53,4993 }, {  54,4993 }, {  55,4993 }, {  56,4993 }, {  57,4993 },
 {  58,4993 }, {  59,4993 }, {  60,4993 }, {  61,4993 }, {  62,4993 },
 {  63,4993 }, {  64,4993 }, {  65,4993 }, {  66,4993 }, {  67,4993 },
 {  68,4993 }, {  69,4993 }, {  70,4993 }, {  71,4993 }, {  72,4993 },
 {  73,4993 }, {  74,4993 }, {  75,4993 }, {  76,4993 }, {  77,4993 },
 {  78,4993 }, {  79,4993 }, {  80,4993 }, {  81,4993 }, {  82,4993 },
 {  83,4993 }, {  84,4993 }, {  85,4993 }, {  86,4993 }, {  87,4993 },
 {  88,4993 }, {  89,4993 }, {  90,4993 }, {  91,4993 }, {  92,4993 },
 {  93,4993 }, {  94,4993 }, {  95,4993 }, {  96,4993 }, {  97,4993 },
 {  98,4993 }, {  99,4993 }, { 100,4993 }, { 101,4993 }, { 102,4993 },

 { 103,4993 }, { 104,4993 }, { 105,4993 }, { 106,4993 }, { 107,4993 },
 { 108,4993 }, { 109,4993 }, { 110,4993 }, { 111,4993 }, { 112,4993 },
 { 113,4993 }, { 114,4993 }, { 115,4993 }, { 116,4993 }, { 117,4993 },
 { 118,4993 }, { 119,4993 }, { 120,4993 }, { 121,4993 }, { 122,4993 },
 { 123,4993 }, { 124,4993 }, { 125,4993 }, { 126,4993 }, { 127,4993 },
 { 128,4993 }, { 129,4993 }, { 130,4993 }, { 131,4993 }, { 132,4993 },
 { 133,4993 }, { 134,4993 }, { 135,4993 }, { 136,4993 }, { 137,4993 },
 { 138,4993 }, { 139,4993 }, { 140,4993 }, { 141,4993 }, { 142,4993 },
 { 143,4993 }, { 144,4993 }, { 145,4993 }, { 146,4993 }, { 147,4993 },
 { 148,4993 }, { 149,4993 }, { 150,4993 }, { 151,4993 }, { 152,4993 },

 { 153,4993 }, { 154,4993 }, { 155,4993 }, { 156,4993 }, { 157,4993 },
 { 158,4993 }, { 159,4993 }, { 160,4993 }, { 161,4993 }, { 162,4993 },
 { 163,4993 }, { 164,4993 }, { 165,4993 }, { 166,4993 }, { 167,4993 },
 { 168,4993 }, { 169,4993 }, { 170,4993 }, { 171,4993 }, { 172,4993 },
 { 173,4993 }, { 174,4993 }, { 175,4993 }, { 176,4993 }, { 177,4993 },
 { 178,4993 }, { 179,4993 }, { 180,4993 }, { 181,4993 }, { 182,4993 },
 { 183,4993 }, { 184,4993 }, { 185,4993 }, { 186,4993 }, { 187,4993 },
 { 188,4993 }, { 189,4993 }, { 190,4993 }, { 191,4993 }, { 192,4993 },
 { 193,4993 }, { 194,4993 }, { 195,4993 }, { 196,4993 }, { 197,4993 },
 { 198,4993 }, { 199,4993 }, { 200,4993 }, { 201,4993 }, { 202,4993 },

 { 203,4993 }, { 204,4993 }, { 205,4993 }, { 206,4993 }, { 207,4993 },
 { 208,4993 }, { 209,4993 }, { 210,4993 }, { 211,4993 }, { 212,4993 },
 { 213,4993 }, { 214,4993 }, { 215,4993 }, { 216,4993 }, { 217,4993 },
 { 218,4993 }, { 219,4993 }, { 220,4993 }, { 221,4993 }, { 222,4993 },
 { 223,4993 }, { 224,4993 }, { 225,4993 }, { 226,4993 }, { 227,4993 },
 { 228,4993 }, { 229,4993 }, { 230,4993 }, { 231,4993 }, { 232,4993 },
 { 233,4993 }, { 234,4993 }, { 235,4993 }, { 236,4993 }, { 237,4993 },
 { 238,4993 }, { 239,4993 }, { 240,4993 }, { 241,4993 }, { 242,4993 },
 { 243,4993 }, { 244,4993 }, { 245,4993 }, { 246,4993 }, { 247,4993 },
 { 248,4993 }, { 249,4993 }, { 250,4993 }, { 251,4993 }, { 252,4993 },

 { 253,4993 }, { 254,4993 }, { 255,4993 }, { 256,4993 }, {   0,   0 },
 {   0,28517 }, {   1,4735 }, {   2,4735 }, {   3,4735 }, {   4,4735 },
 {   5,4735 }, {   6,4735 }, {   7,4735 }, {   8,4735 }, {   9,4735 },
 {  10,4735 }, {  11,4735 }, {  12,4735 }, {  13,4735 }, {  14,4735 },
 {  15,4735 }, {  16,4735 }, {  17,4735 }, {  18,4735 }, {  19,4735 },
 {  20,4735 }, {  21,4735 }, {  22,4735 }, {  23,4735 }, {  24,4735 },
 {  25,4735 }, {  26,4735 }, {  27,4735 }, {  28,4735 }, {  29,4735 },
 {  30,4735 }, {  31,4735 }, {  32,4735 }, {  33,4735 }, {  34,1357 },
 {  35,4735 }, {  36,4735 }, {  37,4735 }, {  38,4735 }, {  39,4735 },
 {  40,4735 }, {  41,4735 }, {  42,4735 }, {  43,4735 }, {  44,4735 },

 {  45,4735 }, {  46,4735 }, {  47,4735 }, {  48,4735 }, {  49,4735 },
 {  50,4735 }, {  51,4735 }, {  52,4735 }, {  53,4735 }, {  54,4735 },
 {  55,4735 }, {  56,4735 }, {  57,4735 }, {  58,4735 }, {  59,4735 },
 {  60,4735 }, {  61,4735 }, {  62,4735 }, {  63,4735 }, {  64,4735 },
 {  65,4735 }, {  66,4735 }, {  67,4735 }, {  68,4735 }, {  69,4735 },
 {  70,4735 }, {  71,4735 }, {  72,4735 }, {  73,4735 }, {  74,4735 },
 {  75,4735 }, {  76,4735 }, {  77,4735 }, {  78,4735 }, {  79,4735 },
 {  80,4735 }, {  81,4735 }, {  82,4735 }, {  83,4735 }, {  84,4735 },
 {  85,4735 }, {  86,4735 }, {  87,4735 }, {  88,4735 }, {  89,4735 },
 {  90,4735 }, {  91,4735 }, {  92,4735 }, {  93,4735 }, {  94,4735 },

 {  95,4735 }, {  96,4735 }, {  97,4735 }, {  98,4735 }, {  99,4735 },
 { 100,4735 }, { 101,4735 }, { 102,4735 }, { 103,4735 }, { 104,4735 },
 { 105,4735 }, { 106,4735 }, { 107,4735 }, { 108,4735 }, { 109,4735 },
 { 110,4735 }, { 111,4735 }, { 112,4735 }, { 113,4735 }, { 114,4735 },
 { 115,4735 }, { 116,4735 }, { 117,4735 }, { 118,4735 }, { 119,4735 },
 { 120,4735 }, { 121,4735 }, { 122,4735 }, { 123,4735 }, { 124,4735 },
 { 125,4735 }, { 126,4735 }, { 127,4735 }, { 128,4735 }, { 129,4735 },
 { 130,4735 }, { 131,4735 }, { 132,4735 }, { 133,4735 }, { 134,4735 },
 { 135,4735 }, { 136,4735 }, { 137,4735 }, { 138,4735 }, { 139,4735 },
 { 140,4735 }, { 141,4735 }, { 142,4735 }, { 143,4735 }, { 144,4735 },

 { 145,4735 }, { 146,4735 }, { 147,4735 }, { 148,4735 }, { 149,4735 },
 { 150,4735 }, { 151,4735 }, { 152,4735 }, { 153,4735 }, { 154,4735 },
 { 155,4735 }, { 156,4735 }, { 157,4735 }, { 158,4735 }, { 159,4735 },
 { 160,4735 }, { 161,4735 }, { 162,4735 }, { 163,4735 }, { 164,4735 },
 { 165,4735 }, { 166,4735 }, { 167,4735 }, { 168,4735 }, { 169,4735 },
 { 170,4735 }, { 171,4735 }, { 172,4735 }, { 173,4735 }, { 174,4735 },
 { 175,4735 }, { 176,4735 }, { 177,4735 }, { 178,4735 }, { 179,4735 },
 { 180,4735 }, { 181,4735 }, { 182,4735 }, { 183,4735 }, { 184,4735 },
 { 185,4735 }, { 186,4735 }, { 187,4735 }, { 188,4735 }, { 189,4735 },
 { 190,4735 }, { 191,4735 }, { 192,4735 }, { 193,4735 }, { 194,4735 },

 { 195,4735 }, { 196,4735 }, { 197,4735 }, { 198,4735 }, { 199,4735 },
 { 200,4735 }, { 201,4735 }, { 202,4735 }, { 203,4735 }, { 204,4735 },
 { 205,4735 }, { 206,4735 }, { 207,4735 }, { 208,4735 }, { 209,4735 },
 { 210,4735 }, { 211,4735 }, { 212,4735 }, { 213,4735 }, { 214,4735 },
 { 215,4735 }, { 216,4735 }, { 217,4735 }, { 218,4735 }, { 219,4735 },
 { 220,4735 }, { 221,4735 }, { 222,4735 }, { 223,4735 }, { 224,4735 },
 { 225,4735 }, { 226,4735 }, { 227,4735 }, { 228,4735 }, { 229,4735 },
 { 230,4735 }, { 231,4735 }, { 232,4735 }, { 233,4735 }, { 234,4735 },
 { 235,4735 }, { 236,4735 }, { 237,4735 }, { 238,4735 }, { 239,4735 },
 { 240,4735 }, { 241,4735 }, { 242,4735 }, { 243,4735 }, { 244,4735 },

 { 245,4735 }, { 246,4735 }, { 247,4735 }, { 248,4735 }, { 249,4735 },
 { 250,4735 }, { 251,4735 }, { 252,4735 }, { 253,4735 }, { 254,4735 },
 { 255,4735 }, { 256,4735 }, {   0,   0 }, {   0,28259 }, {   1,4993 },
 {   2,4993 }, {   3,4993 }, {   4,4993 }, {   5,4993 }, {   6,4993 },
 {   7,4993 }, {   8,4993 }, {   9,4993 }, {  10,4993 }, {  11,4993 },
 {  12,4993 }, {  13,4993 }, {  14,4993 }, {  15,4993 }, {  16,4993 },
 {  17,4993 }, {  18,4993 }, {  19,4993 }, {  20,4993 }, {  21,4993 },
 {  22,4993 }, {  23,4993 }, {  24,4993 }, {  25,4993 }, {  26,4993 },
 {  27,4993 }, {  28,4993 }, {  29,4993 }, {  30,4993 }, {  31,4993 },
 {  32,4993 }, {  33,4993 }, {  34,4993 }, {  35,4993 }, {  36,4993 },

 {  37,4993 }, {  38,4993 }, {  39,1090 }, {  40,4993 }, {  41,4993 },
 {  42,4993 }, {  43,4993 }, {  44,4993 }, {  45,4993 }, {  46,4993 },
 {  47,4993 }, {  48,4993 }, {  49,4993 }, {  50,4993 }, {  51,4993 },
 {  52,4993 }, {  53,4993 }, {  54,4993 }, {  55,4993 }, {  56,4993 },
 {  57,4993 }, {  58,4993 }, {  59,4993 }, {  60,4993 }, {  61,4993 },
 {  62,4993 }, {  63,4993 }, {  64,4993 }, {  65,4993 }, {  66,4993 },
 {  67,4993 }, {  68,4993 }, {  69,4993 }, {  70,4993 }, {  71,4993 },
 {  72,4993 }, {  73,4993 }, {  74,4993 }, {  75,4993 }, {  76,4993 },
 {  77,4993 }, {  78,4993 }, {  79,4993 }, {  80,4993 }, {  81,4993 },
 {  82,4993 }, {  83,4993 }, {  84,4993 }, {  85,4993 }, {  86,4993 },

 {  87,4993 }, {  88,4993 }, {  89,4993 }, {  90,4993 }, {  91,4993 },
 {  92,4993 }, {  93,4993 }, {  94,4993 }, {  95,4993 }, {  96,4993 },
 {  97,4993 }, {  98,4993 }, {  99,4993 }, { 100,4993 }, { 101,4993 },
 { 102,4993 }, { 103,4993 }, { 104,4993 }, { 105,4993 }, { 106,4993 },
 { 107,4993 }, { 108,4993 }, { 109,4993 }, { 110,4993 }, { 111,4993 },
 { 112,4993 }, { 113,4993 }, { 114,4993 }, { 115,4993 }, { 116,4993 },
 { 117,4993 }, { 118,4993 }, { 119,4993 }, { 120,4993 }, { 121,4993 },
 { 122,4993 }, { 123,4993 }, { 124,4993 }, { 125,4993 }, { 126,4993 },
 { 127,4993 }, { 128,4993 }, { 129,4993 }, { 130,4993 }, { 131,4993 },
 { 132,4993 }, { 133,4993 }, { 134,4993 }, { 135,4993 }, { 136,4993 },

 { 137,4993 }, { 138,4993 }, { 139,4993 }, { 140,4993 }, { 141,4993 },
 { 142,4993 }, { 143,4993 }, { 144,4993 }, { 145,4993 }, { 146,4993 },
 { 147,4993 }, { 148,4993 }, { 149,4993 }, { 150,4993 }, { 151,4993 },
 { 152,4993 }, { 153,4993 }, { 154,4993 }, { 155,4993 }, { 156,4993 },
 { 157,4993 }, { 158,4993 }, { 159,4993 }, { 160,4993 }, { 161,4993 },
 { 162,4993 }, { 163,4993 }, { 164,4993 }, { 165,4993 }, { 166,4993 },
 { 167,4993 }, { 168,4993 }, { 169,4993 }, { 170,4993 }, { 171,4993 },
 { 172,4993 }, { 173,4993 }, { 174,4993 }, { 175,4993 }, { 176,4993 },
 { 177,4993 }, { 178,4993 }, { 179,4993 }, { 180,4993 }, { 181,4993 },
 { 182,4993 }, { 183,4993 }, { 184,4993 }, { 185,4993 }, { 186,4993 },

 { 187,4993 }, { 188,4993 }, { 189,4993 }, { 190,4993 }, { 191,4993 },
 { 192,4993 }, { 193,4993 }, { 194,4993 }, { 195,4993 }, { 196,4993 },
 { 197,4993 }, { 198,4993 }, { 199,4993 }, { 200,4993 }, { 201,4993 },
 { 202,4993 }, { 203,4993 }, { 204,4993 }, { 205,4993 }, { 206,4993 },
 { 207,4993 }, { 208,4993 }, { 209,4993 }, { 210,4993 }, { 211,4993 },
 { 212,4993 }, { 213,4993 }, { 214,4993 }, { 215,4993 }, { 216,4993 },
 { 217,4993 }, { 218,4993 }, { 219,4993 }, { 220,4993 }, { 221,4993 },
 { 222,4993 }, { 223,4993 }, { 224,4993 }, { 225,4993 }, { 226,4993 },
 { 227,4993 }, { 228,4993 }, { 229,4993 }, { 230,4993 }, { 231,4993 },
 { 232,4993 }, { 233,4993 }, { 234,4993 }, { 235,4993 }, { 236,4993 },

 { 237,4993 }, { 238,4993 }, { 239,4993 }, { 240,4993 }, { 241,4993 },
 { 242,4993 }, { 243,4993 }, { 244,4993 }, { 245,4993 }, { 246,4993 },
 { 247,4993 }, { 248,4993 }, { 249,4993 }, { 250,4993 }, { 251,4993 },
 { 252,4993 }, { 253,4993 }, { 254,4993 }, { 255,4993 }, { 256,4993 },
 {   0,   0 }, {   0,28001 }, {   1,4735 }, {   2,4735 }, {   3,4735 },
 {   4,4735 }, {   5,4735 }, {   6,4735 }, {   7,4735 }, {   8,4735 },
 {   9,4735 }, {  10,4735 }, {  11,4735 }, {  12,4735 }, {  13,4735 },
 {  14,4735 }, {  15,4735 }, {  16,4735 }, {  17,4735 }, {  18,4735 },
 {  19,4735 }, {  20,4735 }, {  21,4735 }, {  22,4735 }, {  23,4735 },
 {  24,4735 }, {  25,4735 }, {  26,4735 }, {  27,4735 }, {  28,4735 },

 {  29,4735 }, {  30,4735 }, {  31,4735 }, {  32,4735 }, {  33,4735 },
 {  34,4735 }, {  35,4735 }, {  36,4735 }, {  37,4735 }, {  38,4735 },
 {  39, 832 }, {  40,4735 }, {  41,4735 }, {  42,4735 }, {  43,4735 },
 {  44,4735 }, {  45,4735 }, {  46,4735 }, {  47,4735 }, {  48,4735 },
 {  49,4735 }, {  50,4735 }, {  51,4735 }, {  52,4735 }, {  53,4735 },
 {  54,4735 }, {  55,4735 }, {  56,4735 }, {  57,4735 }, {  58,4735 },
 {  59,4735 }, {  60,4735 }, {  61,4735 }, {  62,4735 }, {  63,4735 },
 {  64,4735 }, {  65,4735 }, {  66,4735 }, {  67,4735 }, {  68,4735 },
 {  69,4735 }, {  70,4735 }, {  71,4735 }, {  72,4735 }, {  73,4735 },
 {  74,4735 }, {  75,4735 }, {  76,4735 }, {  77,4735 }, {  78,4735 },

 {  79,4735 }, {  80,4735 }, {  81,4735 }, {  82,4735 }, {  83,4735 },
 {  84,4735 }, {  85,4735 }, {  86,4735 }, {  87,4735 }, {  88,4735 },
 {  89,4735 }, {  90,4735 }, {  91,4735 }, {  92,4735 }, {  93,4735 },
 {  94,4735 }, {  95,4735 }, {  96,4735 }, {  97,4735 }, {  98,4735 },
 {  99,4735 }, { 100,4735 }, { 101,4735 }, { 102,4735 }, { 103,4735 },
 { 104,4735 }, { 105,4735 }, { 106,4735 }, { 107,4735 }, { 108,4735 },
 { 109,4735 }, { 110,4735 }, { 111,4735 }, { 112,4735 }, { 113,4735 },
 { 114,4735 }, { 115,4735 }, { 116,4735 }, { 117,4735 }, { 118,4735 },
 { 119,4735 }, { 120,4735 }, { 121,4735 }, { 122,4735 }, { 123,4735 },
 { 124,4735 }, { 125,4735 }, { 126,4735 }, { 127,4735 }, { 128,4735 },

 { 129,4735 }, { 130,4735 }, { 131,4735 }, { 132,4735 }, { 133,4735 },
 { 134,4735 }, { 135,4735 }, { 136,4735 }, { 137,4735 }, { 138,4735 },
 { 139,4735 }, { 140,4735 }, { 141,4735 }, { 142,4735 }, { 143,4735 },
 { 144,4735 }, { 145,4735 }, { 146,4735 }, { 147,4735 }, { 148,4735 },
 { 149,4735 }, { 150,4735 }, { 151,4735 }, { 152,4735 }, { 153,4735 },
 { 154,4735 }, { 155,4735 }, { 156,4735 }, { 157,4735 }, { 158,4735 },
 { 159,4735 }, { 160,4735 }, { 161,4735 }, { 162,4735 }, { 163,4735 },
 { 164,4735 }, { 165,4735 }, { 166,4735 }, { 167,4735 }, { 168,4735 },
 { 169,4735 }, { 170,4735 }, { 171,4735 }, { 172,4735 }, { 173,4735 },
 { 174,4735 }, { 175,4735 }, { 176,4735 }, { 177,4735 }, { 178,4735 },

 { 179,4735 }, { 180,4735 }, { 181,4735 }, { 182,4735 }, { 183,4735 },
 { 184,4735 }, { 185,4735 }, { 186,4735 }, { 187,4735 }, { 188,4735 },
 { 189,4735 }, { 190,4735 }, { 191,4735 }, { 192,4735 }, { 193,4735 },
 { 194,4735 }, { 195,4735 }, { 196,4735 }, { 197,4735 }, { 198,4735 },
 { 199,4735 }, { 200,4735 }, { 201,4735 }, { 202,4735 }, { 203,4735 },
 { 204,4735 }, { 205,4735 }, { 206,4735 }, { 207,4735 }, { 208,4735 },
 { 209,4735 }, { 210,4735 }, { 211,4735 }, { 212,4735 }, { 213,4735 },
 { 214,4735 }, { 215,4735 }, { 216,4735 }, { 217,4735 }, { 218,4735 },
 { 219,4735 }, { 220,4735 }, { 221,4735 }, { 222,4735 }, { 223,4735 },
 { 224,4735 }, { 225,4735 }, { 226,4735 }, { 227,4735 }, { 228,4735 },

 { 229,4735 }, { 230,4735 }, { 231,4735 }, { 232,4735 }, { 233,4735 },
 { 234,4735 }, { 235,4735 }, { 236,4735 }, { 237,4735 }, { 238,4735 },
 { 239,4735 }, { 240,4735 }, { 241,4735 }, { 242,4735 }, { 243,4735 },
 { 244,4735 }, { 245,4735 }, { 246,4735 }, { 247,4735 }, { 248,4735 },
 { 249,4735 }, { 250,4735 }, { 251,4735 }, { 252,4735 }, { 253,4735 },
 { 254,4735 }, { 255,4735 }, { 256,4735 }, {   0,   0 }, {   0,27743 },
 {   1, 593 }, {   2, 593 }, {   3, 593 }, {   4, 593 }, {   5, 593 },
 {   6, 593 }, {   7, 593 }, {   8, 593 }, {   9, 593 }, {  10, 597 },
 {  11, 593 }, {  12, 593 }, {  13, 593 }, {  14, 593 }, {  15, 593 },
 {  16, 593 }, {  17, 593 }, {  18, 593 }, {  19, 593 }, {  20, 593 },

 {  21, 593 }, {  22, 593 }, {  23, 593 }, {  24, 593 }, {  25, 593 },
 {  26, 593 }, {  27, 593 }, {  28, 593 }, {  29, 593 }, {  30, 593 },
 {  31, 593 }, {  32, 593 }, {  33, 593 }, {  34, 593 }, {  35, 593 },
 {  36, 593 }, {  37, 593 }, {  38, 593 }, {  39, 593 }, {  40, 593 },
 {  41, 593 }, {  42, 593 }, {  43, 593 }, {  44, 593 }, {  45, 593 },
 {  46, 593 }, {  47, 593 }, {  48, 593 }, {  49, 593 }, {  50, 593 },
 {  51, 593 }, {  52, 593 }, {  53, 593 }, {  54, 593 }, {  55, 593 },
 {  56, 593 }, {  57, 593 }, {  58, 593 }, {  59, 593 }, {  60, 593 },
 {  61, 593 }, {  62, 593 }, {  63, 593 }, {  64, 593 }, {  65, 593 },
 {  66, 593 }, {  67, 593 }, {  68, 593 }, {  69, 593 }, {  70, 593 },

 {  71, 593 }, {  72, 593 }, {  73, 593 }, {  74, 593 }, {  75, 593 },
 {  76, 593 }, {  77, 593 }, {  78, 593 }, {  79, 593 }, {  80, 593 },
 {  81, 593 }, {  82, 593 }, {  83, 593 }, {  84, 593 }, {  85, 593 },
 {  86, 593 }, {  87, 593 }, {  88, 593 }, {  89, 593 }, {  90, 593 },
 {  91, 593 }, {  92, 637 }, {  93, 593 }, {  94, 593 }, {  95, 593 },
 {  96, 593 }, {  97, 593 }, {  98, 593 }, {  99, 593 }, { 100, 593 },
 { 101, 593 }, { 102, 593 }, { 103, 593 }, { 104, 593 }, { 105, 593 },
 { 106, 593 }, { 107, 593 }, { 108, 593 }, { 109, 593 }, { 110, 593 },
 { 111, 593 }, { 112, 593 }, { 113, 593 }, { 114, 593 }, { 115, 593 },
 { 116, 593 }, { 117, 593 }, { 118, 593 }, { 119, 593 }, { 120, 593 },

 { 121, 593 }, { 122, 593 }, { 123, 593 }, { 124, 593 }, { 125, 593 },
 { 126, 593 }, { 127, 593 }, { 128, 593 }, { 129, 593 }, { 130, 593 },
 { 131, 593 }, { 132, 593 }, { 133, 593 }, { 134, 593 }, { 135, 593 },
 { 136, 593 }, { 137, 593 }, { 138, 593 }, { 139, 593 }, { 140, 593 },
 { 141, 593 }, { 142, 593 }, { 143, 593 }, { 144, 593 }, { 145, 593 },
 { 146, 593 }, { 147, 593 }, { 148, 593 }, { 149, 593 }, { 150, 593 },
 { 151, 593 }, { 152, 593 }, { 153, 593 }, { 154, 593 }, { 155, 593 },
 { 156, 593 }, { 157, 593 }, { 158, 593 }, { 159, 593 }, { 160, 593 },
 { 161, 593 }, { 162, 593 }, { 163, 593 }, { 164, 593 }, { 165, 593 },
 { 166, 593 }, { 167, 593 }, { 168, 593 }, { 169, 593 }, { 170, 593 },

 { 171, 593 }, { 172, 593 }, { 173, 593 }, { 174, 593 }, { 175, 593 },
 { 176, 593 }, { 177, 593 }, { 178, 593 }, { 179, 593 }, { 180, 593 },
 { 181, 593 }, { 182, 593 }, { 183, 593 }, { 184, 593 }, { 185, 593 },
 { 186, 593 }, { 187, 593 }, { 188, 593 }, { 189, 593 }, { 190, 593 },
 { 191, 593 }, { 192, 593 }, { 193, 593 }, { 194, 593 }, { 195, 593 },
 { 196, 593 }, { 197, 593 }, { 198, 593 }, { 199, 593 }, { 200, 593 },
 { 201, 593 }, { 202, 593 }, { 203, 593 }, { 204, 593 }, { 205, 593 },
 { 206, 593 }, { 207, 593 }, { 208, 593 }, { 209, 593 }, { 210, 593 },
 { 211, 593 }, { 212, 593 }, { 213, 593 }, { 214, 593 }, { 215, 593 },
 { 216, 593 }, { 217, 593 }, { 218, 593 }, { 219, 593 }, { 220, 593 },

 { 221, 593 }, { 222, 593 }, { 223, 593 }, { 224, 593 }, { 225, 593 },
 { 226, 593 }, { 227, 593 }, { 228, 593 }, { 229, 593 }, { 230, 593 },
 { 231, 593 }, { 232, 593 }, { 233, 593 }, { 234, 593 }, { 235, 593 },
 { 236, 593 }, { 237, 593 }, { 238, 593 }, { 239, 593 }, { 240, 593 },
 { 241, 593 }, { 242, 593 }, { 243, 593 }, { 244, 593 }, { 245, 593 },
 { 246, 593 }, { 247, 593 }, { 248, 593 }, { 249, 593 }, { 250, 593 },
 { 251, 593 }, { 252, 593 }, { 253, 593 }, { 254, 593 }, { 255, 593 },
 { 256, 593 }, {   0,   0 }, {   0,27485 }, {   1, 335 }, {   2, 335 },
 {   3, 335 }, {   4, 335 }, {   5, 335 }, {   6, 335 }, {   7, 335 },
 {   8, 335 }, {   9, 335 }, {  10, 339 }, {  11, 335 }, {  12, 335 },

 {  13, 335 }, {  14, 335 }, {  15, 335 }, {  16, 335 }, {  17, 335 },
 {  18, 335 }, {  19, 335 }, {  20, 335 }, {  21, 335 }, {  22, 335 },
 {  23, 335 }, {  24, 335 }, {  25, 335 }, {  26, 335 }, {  27, 335 },
 {  28, 335 }, {  29, 335 }, {  30, 335 }, {  31, 335 }, {  32, 335 },
 {  33, 335 }, {  34, 335 }, {  35, 335 }, {  36, 335 }, {  37, 335 },
 {  38, 335 }, {  39, 335 }, {  40, 335 }, {  41, 335 }, {  42, 335 },
 {  43, 335 }, {  44, 335 }, {  45, 335 }, {  46, 335 }, {  47, 335 },
 {  48, 335 }, {  49, 335 }, {  50, 335 }, {  51, 335 }, {  52, 335 },
 {  53, 335 }, {  54, 335 }, {  55, 335 }, {  56, 335 }, {  57, 335 },
 {  58, 335 }, {  59, 335 }, {  60, 335 }, {  61, 335 }, {  62, 335 },

 {  63, 335 }, {  64, 335 }, {  65, 335 }, {  66, 335 }, {  67, 335 },
 {  68, 335 }, {  69, 335 }, {  70, 335 }, {  71, 335 }, {  72, 335 },
 {  73, 335 }, {  74, 335 }, {  75, 335 }, {  76, 335 }, {  77, 335 },
 {  78, 335 }, {  79, 335 }, {  80, 335 }, {  81, 335 }, {  82, 335 },
 {  83, 335 }, {  84, 335 }, {  85, 335 }, {  86, 335 }, {  87, 335 },
 {  88, 335 }, {  89, 335 }, {  90, 335 }, {  91, 335 }, {  92, 379 },
 {  93, 335 }, {  94, 335 }, {  95, 335 }, {  96, 335 }, {  97, 335 },
 {  98, 335 }, {  99, 335 }, { 100, 335 }, { 101, 335 }, { 102, 335 },
 { 103, 335 }, { 104, 335 }, { 105, 335 }, { 106, 335 }, { 107, 335 },
 { 108, 335 }, { 109, 335 }, { 110, 335 }, { 111, 335 }, { 112, 335 },

 { 113, 335 }, { 114, 335 }, { 115, 335 }, { 116, 335 }, { 117, 335 },
 { 118, 335 }, { 119, 335 }, { 120, 335 }, { 121, 335 }, { 122, 335 },
 { 123, 335 }, { 124, 335 }, { 125, 335 }, { 126, 335 }, { 127, 335 },
 { 128, 335 }, { 129, 335 }, { 130, 335 }, { 131, 335 }, { 132, 335 },
 { 133, 335 }, { 134, 335 }, { 135, 335 }, { 136, 335 }, { 137, 335 },
 { 138, 335 }, { 139, 335 }, { 140, 335 }, { 141, 335 }, { 142, 335 },
 { 143, 335 }, { 144, 335 }, { 145, 335 }, { 146, 335 }, { 147, 335 },
 { 148, 335 }, { 149, 335 }, { 150, 335 }, { 151, 335 }, { 152, 335 },
 { 153, 335 }, { 154, 335 }, { 155, 335 }, { 156, 335 }, { 157, 335 },
 { 158, 335 }, { 159, 335 }, { 160, 335 }, { 161, 335 }, { 162, 335 },

 { 163, 335 }, { 164, 335 }, { 165, 335 }, { 166, 335 }, { 167, 335 },
 { 168, 335 }, { 169, 335 }, { 170, 335 }, { 171, 335 }, { 172, 335 },
 { 173, 335 }, { 174, 335 }, { 175, 335 }, { 176, 335 }, { 177, 335 },
 { 178, 335 }, { 179, 335 }, { 180, 335 }, { 181, 335 }, { 182, 335 },
 { 183, 335 }, { 184, 335 }, { 185, 335 }, { 186, 335 }, { 187, 335 },
 { 188, 335 }, { 189, 335 }, { 190, 335 }, { 191, 335 }, { 192, 335 },
 { 193, 335 }, { 194, 335 }, { 195, 335 }, { 196, 335 }, { 197, 335 },
 { 198, 335 }, { 199, 335 }, { 200, 335 }, { 201, 335 }, { 202, 335 },
 { 203, 335 }, { 204, 335 }, { 205, 335 }, { 206, 335 }, { 207, 335 },
 { 208, 335 }, { 209, 335 }, { 210, 335 }, { 211, 335 }, { 212, 335 },

 { 213, 335 }, { 214, 335 }, { 215, 335 }, { 216, 335 }, { 217, 335 },
 { 218, 335 }, { 219, 335 }, { 220, 335 }, { 221, 335 }, { 222, 335 },
 { 223, 335 }, { 224, 335 }, { 225, 335 }, { 226, 335 }, { 227, 335 },
 { 228, 335 }, { 229, 335 }, { 230, 335 }, { 231, 335 }, { 232, 335 },
 { 233, 335 }, { 234, 335 }, { 235, 335 }, { 236, 335 }, { 237, 335 },
 { 238, 335 }, { 239, 335 }, { 240, 335 }, { 241, 335 }, { 242, 335 },
 { 243, 335 }, { 244, 335 }, { 245, 335 }, { 246, 335 }, { 247, 335 },
 { 248, 335 }, { 249, 335 }, { 250, 335 }, { 251, 335 }, { 252, 335 },
 { 253, 335 }, { 254, 335 }, { 255, 335 }, { 256, 335 }, {   0,  72 },
 {   0,27227 }, {   0,   1 }, {   0,27225 }, {   0,  39 }, {   0,27223 },

 {   0,   0 }, {   0,   1 }, {   0,27220 }, {   0,  55 }, {   0,27218 },
 {   0,   0 }, {   9,5585 }, {  10,5585 }, {  11,5585 }, {  12,5585 },
 {  13,5585 }, {   9,5580 }, {  10,5580 }, {  11,5580 }, {  12,5580 },
 {  13,5580 }, {   0,  14 }, {   0,27205 }, {   0,  54 }, {   0,27203 },
 {   0,   0 }, {   0,  54 }, {   0,27200 }, {   0,  17 }, {   0,27198 },
 {   0,   0 }, {   0,   7 }, {   0,27195 }, {   0,   0 }, {  32,5585 },
 {   0,   7 }, {   0,27191 }, {   0,   0 }, {   0,   0 }, {  32,5580 },
 {   0,  41 }, {   0,27186 }, {  33,5833 }, {   0,   0 }, {  35,5833 },
 {   0,   0 }, {  37,5833 }, {  38,5833 }, {   0,  55 }, {   0,27178 },
 {   0,   0 }, {  42,5833 }, {  43,5833 }, {   0,   0 }, {  45,5833 },

 {   0,   0 }, {  47,5833 }, {   0,  17 }, {   0,27169 }, {   0,  20 },
 {   0,27167 }, {   0,  19 }, {   0,27165 }, {   0,   0 }, {   0,  17 },
 {   0,27162 }, {   0,  42 }, {   0,27160 }, {   0,   0 }, {  60,5833 },
 {  61,5844 }, {  62,5833 }, {  63,5833 }, {  64,5833 }, {  42, 348 },
 {  34, 346 }, {   0,  26 }, {   0,27150 }, {  42,9714 }, {  47, 353 },
 {   0,  27 }, {   0,27146 }, {  33,5793 }, {   0,   0 }, {  35,5793 },
 {  58, 100 }, {  37,5793 }, {  38,5793 }, {  61, 102 }, {   0,   0 },
 {   0,   0 }, {  42,5793 }, {  43,5793 }, {   0,   0 }, {  45,5793 },
 {   0,   0 }, {  47,5793 }, {  39, 331 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  34, 320 }, {   0,   0 }, {  94,5833 }, {  39, 324 },

 {  96,5833 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5793 },
 {  61,5793 }, {  62,5793 }, {  63,5793 }, {  64,5793 }, {   0,  72 },
 {   0,27112 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  26 }, {   0,27106 }, {   0,  33 }, {   0,27104 }, {   0,  47 },
 {   0,27102 }, {   0,  46 }, {   0,27100 }, {   0,  48 }, {   0,27098 },
 {   0,   9 }, {   0,27096 }, {   0,   0 }, { 124,5833 }, {   0,   0 },
 { 126,5833 }, {   0,  15 }, {   0,27090 }, {   0,  13 }, {   0,27088 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,5793 }, {   0,   0 },
 {  96,5793 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   8 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5755 }, {  49,5755 },
 {  50,5755 }, {  51,5755 }, {  52,5755 }, {  53,5755 }, {  54,5755 },
 {  55,5755 }, {  56,5755 }, {  57,5755 }, { 124,5793 }, {   0,   0 },
 { 126,5793 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5818 }, {  66,5818 }, {  67,5818 }, {  68,5818 }, {  69,5818 },
 {  70,5818 }, {  71,5818 }, {  72,5818 }, {  73,5818 }, {  74,5818 },
 {  75,5818 }, {  76,5818 }, {  77,5818 }, {  78,5818 }, {  79,5818 },
 {  80,5818 }, {  81,5818 }, {  82,5818 }, {  83,5818 }, {  84,5818 },
 {  85,5818 }, {  86,5818 }, {  87,5818 }, {  88,5818 }, {  89,5818 },

 {  90,5818 }, {  85,11553 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5818 }, {   0,   0 }, {  97,5818 }, {  98,5818 }, {  99,5818 },
 { 100,5818 }, { 101,5818 }, { 102,5818 }, { 103,5818 }, { 104,5818 },
 { 105,5818 }, { 106,5818 }, { 107,5818 }, { 108,5818 }, { 109,5818 },
 { 110,5818 }, { 111,5818 }, { 112,5818 }, { 113,5818 }, { 114,5818 },
 { 115,5818 }, { 116,5818 }, { 117,5818 }, { 118,5818 }, { 119,5818 },
 { 120,5818 }, { 121,5818 }, { 122,5818 }, { 117,11576 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5818 }, { 129,5818 },
 { 130,5818 }, { 131,5818 }, { 132,5818 }, { 133,5818 }, { 134,5818 },
 { 135,5818 }, { 136,5818 }, { 137,5818 }, { 138,5818 }, { 139,5818 },

 { 140,5818 }, { 141,5818 }, { 142,5818 }, { 143,5818 }, { 144,5818 },
 { 145,5818 }, { 146,5818 }, { 147,5818 }, { 148,5818 }, { 149,5818 },
 { 150,5818 }, { 151,5818 }, { 152,5818 }, { 153,5818 }, { 154,5818 },
 { 155,5818 }, { 156,5818 }, { 157,5818 }, { 158,5818 }, { 159,5818 },
 { 160,5818 }, { 161,5818 }, { 162,5818 }, { 163,5818 }, { 164,5818 },
 { 165,5818 }, { 166,5818 }, { 167,5818 }, { 168,5818 }, { 169,5818 },
 { 170,5818 }, { 171,5818 }, { 172,5818 }, { 173,5818 }, { 174,5818 },
 { 175,5818 }, { 176,5818 }, { 177,5818 }, { 178,5818 }, { 179,5818 },
 { 180,5818 }, { 181,5818 }, { 182,5818 }, { 183,5818 }, { 184,5818 },
 { 185,5818 }, { 186,5818 }, { 187,5818 }, { 188,5818 }, { 189,5818 },

 { 190,5818 }, { 191,5818 }, { 192,5818 }, { 193,5818 }, { 194,5818 },
 { 195,5818 }, { 196,5818 }, { 197,5818 }, { 198,5818 }, { 199,5818 },
 { 200,5818 }, { 201,5818 }, { 202,5818 }, { 203,5818 }, { 204,5818 },
 { 205,5818 }, { 206,5818 }, { 207,5818 }, { 208,5818 }, { 209,5818 },
 { 210,5818 }, { 211,5818 }, { 212,5818 }, { 213,5818 }, { 214,5818 },
 { 215,5818 }, { 216,5818 }, { 217,5818 }, { 218,5818 }, { 219,5818 },
 { 220,5818 }, { 221,5818 }, { 222,5818 }, { 223,5818 }, { 224,5818 },
 { 225,5818 }, { 226,5818 }, { 227,5818 }, { 228,5818 }, { 229,5818 },
 { 230,5818 }, { 231,5818 }, { 232,5818 }, { 233,5818 }, { 234,5818 },
 { 235,5818 }, { 236,5818 }, { 237,5818 }, { 238,5818 }, { 239,5818 },

 { 240,5818 }, { 241,5818 }, { 242,5818 }, { 243,5818 }, { 244,5818 },
 { 245,5818 }, { 246,5818 }, { 247,5818 }, { 248,5818 }, { 249,5818 },
 { 250,5818 }, { 251,5818 }, { 252,5818 }, { 253,5818 }, { 254,5818 },
 { 255,5818 }, {   0,  54 }, {   0,26855 }, {   0,  45 }, {   0,26853 },
 {   0,  12 }, {   0,26851 }, {   0,   0 }, {   0,   0 }, {   0,   8 },
 {   0,26847 }, {   0,   0 }, {   0,  54 }, {   0,26844 }, {   0,   5 },
 {   0,26842 }, {   0,  43 }, {   0,26840 }, {   0,  21 }, {   0,26838 },
 {   0,  19 }, {   0,26836 }, {   0,  18 }, {   0,26834 }, {   0,  29 },
 {   0,26832 }, {   0,  35 }, {   0,26830 }, {   0,  65 }, {   0,26828 },
 {   0,   0 }, {   0,  54 }, {   0,26825 }, {   0,  40 }, {   0,26823 },

 {  33,5470 }, {   0,   0 }, {  35,5470 }, {  34,  30 }, {  37,5470 },
 {  38,5470 }, {   0,  16 }, {   0,26815 }, {  39,  38 }, {  42,5470 },
 {  43,5470 }, {  33,5459 }, {  45,5470 }, {  35,5459 }, {  47,5470 },
 {  37,5459 }, {  38,5459 }, {  42,   0 }, {   0,  30 }, {   0,26803 },
 {  42,5459 }, {  43,5459 }, {  47,   5 }, {  45,5807 }, {   0,   0 },
 {  47,5459 }, {   0,   0 }, {  60,5470 }, {  61,5470 }, {  62,5470 },
 {  63,5470 }, {  64,5470 }, {   0,  31 }, {   0,26789 }, {   0,  24 },
 {   0,26787 }, {   0,  25 }, {   0,26785 }, {  60,5459 }, {  61,5459 },
 {  62,5459 }, {  63,5459 }, {  64,5459 }, {  46,-277 }, {   0,   0 },
 {  48,6046 }, {  49,6046 }, {  50,6046 }, {  51,6046 }, {  52,6046 },

 {  53,6046 }, {  54,6046 }, {  55,6046 }, {  56,6046 }, {  57,6046 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,5470 }, {   0,   0 }, {  96,5470 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  54 }, {   0,26754 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5459 }, {   0,   0 }, {  96,5459 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,5470 }, {   0,   0 }, { 126,5470 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  57 },

 {   0,26722 }, {  33,5369 }, { 124,5459 }, {  35,5369 }, { 126,5459 },
 {  37,5369 }, {  38,5369 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,6232 }, {  43,5369 }, {   0,   0 }, {  45,5369 }, {   0,   0 },
 {  47,5369 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5369 }, {  61,5369 },
 {  62,5369 }, {  63,5369 }, {  64,5369 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,6232 }, {   0,   0 }, {  48,6489 }, {  49,6489 },

 {  50,6489 }, {  51,6489 }, {  52,6489 }, {  53,6489 }, {  54,6489 },
 {  55,6489 }, {  56,6489 }, {  57,6489 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5369 }, {   0,   0 }, {  96,5369 },
 {  65,6746 }, {  66,7003 }, {  67,6746 }, {  68,6746 }, {  69,7260 },
 {  70,6746 }, {  71,6746 }, {  72,6746 }, {  73,6746 }, {  74,6746 },
 {  75,6746 }, {  76,6746 }, {  77,6746 }, {  78,6746 }, {  79,7517 },
 {  80,6746 }, {  81,6746 }, {  82,6746 }, {  83,6746 }, {  84,6746 },
 {  85,6746 }, {  86,6746 }, {  87,6746 }, {  88,7774 }, {  89,6746 },
 {  90,6746 }, {   0,   0 }, { 124,5369 }, {   0,   0 }, { 126,5369 },
 {  95,8031 }, {   0,   0 }, {  97,6746 }, {  98,7003 }, {  99,6746 },

 { 100,6746 }, { 101,7260 }, { 102,6746 }, { 103,6746 }, { 104,6746 },
 { 105,6746 }, { 106,6746 }, { 107,6746 }, { 108,6746 }, { 109,6746 },
 { 110,6746 }, { 111,7517 }, { 112,6746 }, { 113,6746 }, { 114,6746 },
 { 115,6746 }, { 116,6746 }, { 117,6746 }, { 118,6746 }, { 119,6746 },
 { 120,7774 }, { 121,6746 }, { 122,6746 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6746 }, { 129,6746 },
 { 130,6746 }, { 131,6746 }, { 132,6746 }, { 133,6746 }, { 134,6746 },
 { 135,6746 }, { 136,6746 }, { 137,6746 }, { 138,6746 }, { 139,6746 },
 { 140,6746 }, { 141,6746 }, { 142,6746 }, { 143,6746 }, { 144,6746 },
 { 145,6746 }, { 146,6746 }, { 147,6746 }, { 148,6746 }, { 149,6746 },

 { 150,6746 }, { 151,6746 }, { 152,6746 }, { 153,6746 }, { 154,6746 },
 { 155,6746 }, { 156,6746 }, { 157,6746 }, { 158,6746 }, { 159,6746 },
 { 160,6746 }, { 161,6746 }, { 162,6746 }, { 163,6746 }, { 164,6746 },
 { 165,6746 }, { 166,6746 }, { 167,6746 }, { 168,6746 }, { 169,6746 },
 { 170,6746 }, { 171,6746 }, { 172,6746 }, { 173,6746 }, { 174,6746 },
 { 175,6746 }, { 176,6746 }, { 177,6746 }, { 178,6746 }, { 179,6746 },
 { 180,6746 }, { 181,6746 }, { 182,6746 }, { 183,6746 }, { 184,6746 },
 { 185,6746 }, { 186,6746 }, { 187,6746 }, { 188,6746 }, { 189,6746 },
 { 190,6746 }, { 191,6746 }, { 192,6746 }, { 193,6746 }, { 194,6746 },
 { 195,6746 }, { 196,6746 }, { 197,6746 }, { 198,6746 }, { 199,6746 },

 { 200,6746 }, { 201,6746 }, { 202,6746 }, { 203,6746 }, { 204,6746 },
 { 205,6746 }, { 206,6746 }, { 207,6746 }, { 208,6746 }, { 209,6746 },
 { 210,6746 }, { 211,6746 }, { 212,6746 }, { 213,6746 }, { 214,6746 },
 { 215,6746 }, { 216,6746 }, { 217,6746 }, { 218,6746 }, { 219,6746 },
 { 220,6746 }, { 221,6746 }, { 222,6746 }, { 223,6746 }, { 224,6746 },
 { 225,6746 }, { 226,6746 }, { 227,6746 }, { 228,6746 }, { 229,6746 },
 { 230,6746 }, { 231,6746 }, { 232,6746 }, { 233,6746 }, { 234,6746 },
 { 235,6746 }, { 236,6746 }, { 237,6746 }, { 238,6746 }, { 239,6746 },
 { 240,6746 }, { 241,6746 }, { 242,6746 }, { 243,6746 }, { 244,6746 },
 { 245,6746 }, { 246,6746 }, { 247,6746 }, { 248,6746 }, { 249,6746 },

 { 250,6746 }, { 251,6746 }, { 252,6746 }, { 253,6746 }, { 254,6746 },
 { 255,6746 }, {   0,  57 }, {   0,26465 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,5975 }, {   0,   0 },
 {  48,6232 }, {  49,6232 }, {  50,6232 }, {  51,6232 }, {  52,6232 },
 {  53,6232 }, {  54,6232 }, {  55,6232 }, {  56,6232 }, {  57,6232 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,6489 }, {  66,6489 }, {  67,6489 },
 {  68,6489 }, {  69,7003 }, {  70,6489 }, {  71,6489 }, {  72,6489 },
 {  73,6489 }, {  74,6489 }, {  75,6489 }, {  76,6489 }, {  77,6489 },
 {  78,6489 }, {  79,6489 }, {  80,6489 }, {  81,6489 }, {  82,6489 },
 {  83,6489 }, {  84,6489 }, {  85,6489 }, {  86,6489 }, {  87,6489 },
 {  88,6489 }, {  89,6489 }, {  90,6489 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  95,7774 }, {   0,   0 }, {  97,6489 },
 {  98,6489 }, {  99,6489 }, { 100,6489 }, { 101,7003 }, { 102,6489 },
 { 103,6489 }, { 104,6489 }, { 105,6489 }, { 106,6489 }, { 107,6489 },
 { 108,6489 }, { 109,6489 }, { 110,6489 }, { 111,6489 }, { 112,6489 },
 { 113,6489 }, { 114,6489 }, { 115,6489 }, { 116,6489 }, { 117,6489 },
 { 118,6489 }, { 119,6489 }, { 120,6489 }, { 121,6489 }, { 122,6489 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,6489 }, { 129,6489 }, { 130,6489 }, { 131,6489 }, { 132,6489 },
 { 133,6489 }, { 134,6489 }, { 135,6489 }, { 136,6489 }, { 137,6489 },
 { 138,6489 }, { 139,6489 }, { 140,6489 }, { 141,6489 }, { 142,6489 },

 { 143,6489 }, { 144,6489 }, { 145,6489 }, { 146,6489 }, { 147,6489 },
 { 148,6489 }, { 149,6489 }, { 150,6489 }, { 151,6489 }, { 152,6489 },
 { 153,6489 }, { 154,6489 }, { 155,6489 }, { 156,6489 }, { 157,6489 },
 { 158,6489 }, { 159,6489 }, { 160,6489 }, { 161,6489 }, { 162,6489 },
 { 163,6489 }, { 164,6489 }, { 165,6489 }, { 166,6489 }, { 167,6489 },
 { 168,6489 }, { 169,6489 }, { 170,6489 }, { 171,6489 }, { 172,6489 },
 { 173,6489 }, { 174,6489 }, { 175,6489 }, { 176,6489 }, { 177,6489 },
 { 178,6489 }, { 179,6489 }, { 180,6489 }, { 181,6489 }, { 182,6489 },
 { 183,6489 }, { 184,6489 }, { 185,6489 }, { 186,6489 }, { 187,6489 },
 { 188,6489 }, { 189,6489 }, { 190,6489 }, { 191,6489 }, { 192,6489 },

 { 193,6489 }, { 194,6489 }, { 195,6489 }, { 196,6489 }, { 197,6489 },
 { 198,6489 }, { 199,6489 }, { 200,6489 }, { 201,6489 }, { 202,6489 },
 { 203,6489 }, { 204,6489 }, { 205,6489 }, { 206,6489 }, { 207,6489 },
 { 208,6489 }, { 209,6489 }, { 210,6489 }, { 211,6489 }, { 212,6489 },
 { 213,6489 }, { 214,6489 }, { 215,6489 }, { 216,6489 }, { 217,6489 },
 { 218,6489 }, { 219,6489 }, { 220,6489 }, { 221,6489 }, { 222,6489 },
 { 223,6489 }, { 224,6489 }, { 225,6489 }, { 226,6489 }, { 227,6489 },
 { 228,6489 }, { 229,6489 }, { 230,6489 }, { 231,6489 }, { 232,6489 },
 { 233,6489 }, { 234,6489 }, { 235,6489 }, { 236,6489 }, { 237,6489 },
 { 238,6489 }, { 239,6489 }, { 240,6489 }, { 241,6489 }, { 242,6489 },

 { 243,6489 }, { 244,6489 }, { 245,6489 }, { 246,6489 }, { 247,6489 },
 { 248,6489 }, { 249,6489 }, { 250,6489 }, { 251,6489 }, { 252,6489 },
 { 253,6489 }, { 254,6489 }, { 255,6489 }, {   0,  54 }, {   0,26208 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  54 },
 {   0,26197 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,4823 }, {   0,   0 }, {  35,4823 },

 {   0,   0 }, {  37,4823 }, {  38,4823 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,4823 }, {  43,4823 }, {  33,4812 }, {  45,4823 },
 {  35,4812 }, {  47,4823 }, {  37,4812 }, {  38,4812 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,4812 }, {  43,4812 }, {   0,   0 },
 {  45,4812 }, {   0,   0 }, {  47,4812 }, {   0,   0 }, {  60,4823 },
 {  61,7774 }, {  62,7785 }, {  63,4823 }, {  64,4823 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,4812 }, {  61,4812 }, {  62,7841 }, {  63,4812 }, {  64,4812 },
 {   0,   0 }, {   0,  54 }, {   0,26130 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4823 }, {   0,   0 },
 {  96,4823 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4812 },
 {   0,   0 }, {  96,4812 }, {   0,   0 }, {   0,  71 }, {   0,26098 },
 {  33,4745 }, {   0,   0 }, {  35,4745 }, {   0,   0 }, {  37,4745 },
 {  38,4745 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4745 },
 {  43,4745 }, {   0,   0 }, {  45,4745 }, { 124,4823 }, {  47,4745 },
 { 126,4823 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,4812 },

 {   0,   0 }, { 126,4812 }, {  60,4745 }, {  61,7814 }, {  62,4745 },
 {  63,4745 }, {  64,4745 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,7848 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,7848 }, {  49,7848 }, {  50,7848 },
 {  51,7848 }, {  52,7848 }, {  53,7848 }, {  54,7848 }, {  55,7848 },
 {  56,7848 }, {  57,7848 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,4745 }, {   0,   0 }, {  96,4745 }, {  65,7848 },
 {  66,7848 }, {  67,7848 }, {  68,7848 }, {  69,7848 }, {  70,7848 },
 {  71,7848 }, {  72,7848 }, {  73,7848 }, {  74,7848 }, {  75,7848 },

 {  76,7848 }, {  77,7848 }, {  78,7848 }, {  79,7848 }, {  80,7848 },
 {  81,7848 }, {  82,7848 }, {  83,7848 }, {  84,7848 }, {  85,7848 },
 {  86,7848 }, {  87,7848 }, {  88,7848 }, {  89,7848 }, {  90,7848 },
 {   0,   0 }, { 124,4745 }, {   0,   0 }, { 126,4745 }, {  95,7848 },
 {   0,   0 }, {  97,7848 }, {  98,7848 }, {  99,7848 }, { 100,7848 },
 { 101,7848 }, { 102,7848 }, { 103,7848 }, { 104,7848 }, { 105,7848 },
 { 106,7848 }, { 107,7848 }, { 108,7848 }, { 109,7848 }, { 110,7848 },
 { 111,7848 }, { 112,7848 }, { 113,7848 }, { 114,7848 }, { 115,7848 },
 { 116,7848 }, { 117,7848 }, { 118,7848 }, { 119,7848 }, { 120,7848 },
 { 121,7848 }, { 122,7848 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,7848 }, { 129,7848 }, { 130,7848 },
 { 131,7848 }, { 132,7848 }, { 133,7848 }, { 134,7848 }, { 135,7848 },
 { 136,7848 }, { 137,7848 }, { 138,7848 }, { 139,7848 }, { 140,7848 },
 { 141,7848 }, { 142,7848 }, { 143,7848 }, { 144,7848 }, { 145,7848 },
 { 146,7848 }, { 147,7848 }, { 148,7848 }, { 149,7848 }, { 150,7848 },
 { 151,7848 }, { 152,7848 }, { 153,7848 }, { 154,7848 }, { 155,7848 },
 { 156,7848 }, { 157,7848 }, { 158,7848 }, { 159,7848 }, { 160,7848 },
 { 161,7848 }, { 162,7848 }, { 163,7848 }, { 164,7848 }, { 165,7848 },
 { 166,7848 }, { 167,7848 }, { 168,7848 }, { 169,7848 }, { 170,7848 },
 { 171,7848 }, { 172,7848 }, { 173,7848 }, { 174,7848 }, { 175,7848 },

 { 176,7848 }, { 177,7848 }, { 178,7848 }, { 179,7848 }, { 180,7848 },
 { 181,7848 }, { 182,7848 }, { 183,7848 }, { 184,7848 }, { 185,7848 },
 { 186,7848 }, { 187,7848 }, { 188,7848 }, { 189,7848 }, { 190,7848 },
 { 191,7848 }, { 192,7848 }, { 193,7848 }, { 194,7848 }, { 195,7848 },
 { 196,7848 }, { 197,7848 }, { 198,7848 }, { 199,7848 }, { 200,7848 },
 { 201,7848 }, { 202,7848 }, { 203,7848 }, { 204,7848 }, { 205,7848 },
 { 206,7848 }, { 207,7848 }, { 208,7848 }, { 209,7848 }, { 210,7848 },
 { 211,7848 }, { 212,7848 }, { 213,7848 }, { 214,7848 }, { 215,7848 },
 { 216,7848 }, { 217,7848 }, { 218,7848 }, { 219,7848 }, { 220,7848 },
 { 221,7848 }, { 222,7848 }, { 223,7848 }, { 224,7848 }, { 225,7848 },

 { 226,7848 }, { 227,7848 }, { 228,7848 }, { 229,7848 }, { 230,7848 },
 { 231,7848 }, { 232,7848 }, { 233,7848 }, { 234,7848 }, { 235,7848 },
 { 236,7848 }, { 237,7848 }, { 238,7848 }, { 239,7848 }, { 240,7848 },
 { 241,7848 }, { 242,7848 }, { 243,7848 }, { 244,7848 }, { 245,7848 },
 { 246,7848 }, { 247,7848 }, { 248,7848 }, { 249,7848 }, { 250,7848 },
 { 251,7848 }, { 252,7848 }, { 253,7848 }, { 254,7848 }, { 255,7848 },
 {   0,  71 }, {   0,25841 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,7591 }, {   0,   0 }, {   0,   0 },
 {  39,-1255 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,7591 },
 {  49,7591 }, {  50,7591 }, {  51,7591 }, {  52,7591 }, {  53,7591 },
 {  54,7591 }, {  55,7591 }, {  56,7591 }, {  57,7591 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,7591 }, {  66,7591 }, {  67,7591 }, {  68,7591 },

 {  69,7591 }, {  70,7591 }, {  71,7591 }, {  72,7591 }, {  73,7591 },
 {  74,7591 }, {  75,7591 }, {  76,7591 }, {  77,7591 }, {  78,7591 },
 {  79,7591 }, {  80,7591 }, {  81,7591 }, {  82,7591 }, {  83,7591 },
 {  84,7591 }, {  85,7591 }, {  86,7591 }, {  87,7591 }, {  88,7591 },
 {  89,7591 }, {  90,7591 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,7591 }, {   0,   0 }, {  97,7591 }, {  98,7591 },
 {  99,7591 }, { 100,7591 }, { 101,7591 }, { 102,7591 }, { 103,7591 },
 { 104,7591 }, { 105,7591 }, { 106,7591 }, { 107,7591 }, { 108,7591 },
 { 109,7591 }, { 110,7591 }, { 111,7591 }, { 112,7591 }, { 113,7591 },
 { 114,7591 }, { 115,7591 }, { 116,7591 }, { 117,7591 }, { 118,7591 },

 { 119,7591 }, { 120,7591 }, { 121,7591 }, { 122,7591 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,7591 },
 { 129,7591 }, { 130,7591 }, { 131,7591 }, { 132,7591 }, { 133,7591 },
 { 134,7591 }, { 135,7591 }, { 136,7591 }, { 137,7591 }, { 138,7591 },
 { 139,7591 }, { 140,7591 }, { 141,7591 }, { 142,7591 }, { 143,7591 },
 { 144,7591 }, { 145,7591 }, { 146,7591 }, { 147,7591 }, { 148,7591 },
 { 149,7591 }, { 150,7591 }, { 151,7591 }, { 152,7591 }, { 153,7591 },
 { 154,7591 }, { 155,7591 }, { 156,7591 }, { 157,7591 }, { 158,7591 },
 { 159,7591 }, { 160,7591 }, { 161,7591 }, { 162,7591 }, { 163,7591 },
 { 164,7591 }, { 165,7591 }, { 166,7591 }, { 167,7591 }, { 168,7591 },

 { 169,7591 }, { 170,7591 }, { 171,7591 }, { 172,7591 }, { 173,7591 },
 { 174,7591 }, { 175,7591 }, { 176,7591 }, { 177,7591 }, { 178,7591 },
 { 179,7591 }, { 180,7591 }, { 181,7591 }, { 182,7591 }, { 183,7591 },
 { 184,7591 }, { 185,7591 }, { 186,7591 }, { 187,7591 }, { 188,7591 },
 { 189,7591 }, { 190,7591 }, { 191,7591 }, { 192,7591 }, { 193,7591 },
 { 194,7591 }, { 195,7591 }, { 196,7591 }, { 197,7591 }, { 198,7591 },
 { 199,7591 }, { 200,7591 }, { 201,7591 }, { 202,7591 }, { 203,7591 },
 { 204,7591 }, { 205,7591 }, { 206,7591 }, { 207,7591 }, { 208,7591 },
 { 209,7591 }, { 210,7591 }, { 211,7591 }, { 212,7591 }, { 213,7591 },
 { 214,7591 }, { 215,7591 }, { 216,7591 }, { 217,7591 }, { 218,7591 },

 { 219,7591 }, { 220,7591 }, { 221,7591 }, { 222,7591 }, { 223,7591 },
 { 224,7591 }, { 225,7591 }, { 226,7591 }, { 227,7591 }, { 228,7591 },
 { 229,7591 }, { 230,7591 }, { 231,7591 }, { 232,7591 }, { 233,7591 },
 { 234,7591 }, { 235,7591 }, { 236,7591 }, { 237,7591 }, { 238,7591 },
 { 239,7591 }, { 240,7591 }, { 241,7591 }, { 242,7591 }, { 243,7591 },
 { 244,7591 }, { 245,7591 }, { 246,7591 }, { 247,7591 }, { 248,7591 },
 { 249,7591 }, { 250,7591 }, { 251,7591 }, { 252,7591 }, { 253,7591 },
 { 254,7591 }, { 255,7591 }, {   0,  71 }, {   0,25584 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,7334 },
 {   0,   0 }, {   0,   0 }, {  39,-1506 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,7334 }, {  49,7334 }, {  50,7334 }, {  51,7334 },
 {  52,7334 }, {  53,7334 }, {  54,7334 }, {  55,7334 }, {  56,7334 },
 {  57,7334 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,7334 }, {  66,7334 },
 {  67,7334 }, {  68,7334 }, {  69,7334 }, {  70,7334 }, {  71,7334 },
 {  72,7334 }, {  73,7334 }, {  74,7334 }, {  75,7334 }, {  76,7334 },
 {  77,7334 }, {  78,7334 }, {  79,7334 }, {  80,7334 }, {  81,7334 },
 {  82,7334 }, {  83,7334 }, {  84,7334 }, {  85,7334 }, {  86,7334 },
 {  87,7334 }, {  88,7334 }, {  89,7334 }, {  90,7334 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,7334 }, {   0,   0 },
 {  97,7334 }, {  98,7334 }, {  99,7334 }, { 100,7334 }, { 101,7334 },
 { 102,7334 }, { 103,7334 }, { 104,7334 }, { 105,7334 }, { 106,7334 },
 { 107,7334 }, { 108,7334 }, { 109,7334 }, { 110,7334 }, { 111,7334 },

 { 112,7334 }, { 113,7334 }, { 114,7334 }, { 115,7334 }, { 116,7334 },
 { 117,7334 }, { 118,7334 }, { 119,7334 }, { 120,7334 }, { 121,7334 },
 { 122,7334 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,7334 }, { 129,7334 }, { 130,7334 }, { 131,7334 },
 { 132,7334 }, { 133,7334 }, { 134,7334 }, { 135,7334 }, { 136,7334 },
 { 137,7334 }, { 138,7334 }, { 139,7334 }, { 140,7334 }, { 141,7334 },
 { 142,7334 }, { 143,7334 }, { 144,7334 }, { 145,7334 }, { 146,7334 },
 { 147,7334 }, { 148,7334 }, { 149,7334 }, { 150,7334 }, { 151,7334 },
 { 152,7334 }, { 153,7334 }, { 154,7334 }, { 155,7334 }, { 156,7334 },
 { 157,7334 }, { 158,7334 }, { 159,7334 }, { 160,7334 }, { 161,7334 },

 { 162,7334 }, { 163,7334 }, { 164,7334 }, { 165,7334 }, { 166,7334 },
 { 167,7334 }, { 168,7334 }, { 169,7334 }, { 170,7334 }, { 171,7334 },
 { 172,7334 }, { 173,7334 }, { 174,7334 }, { 175,7334 }, { 176,7334 },
 { 177,7334 }, { 178,7334 }, { 179,7334 }, { 180,7334 }, { 181,7334 },
 { 182,7334 }, { 183,7334 }, { 184,7334 }, { 185,7334 }, { 186,7334 },
 { 187,7334 }, { 188,7334 }, { 189,7334 }, { 190,7334 }, { 191,7334 },
 { 192,7334 }, { 193,7334 }, { 194,7334 }, { 195,7334 }, { 196,7334 },
 { 197,7334 }, { 198,7334 }, { 199,7334 }, { 200,7334 }, { 201,7334 },
 { 202,7334 }, { 203,7334 }, { 204,7334 }, { 205,7334 }, { 206,7334 },
 { 207,7334 }, { 208,7334 }, { 209,7334 }, { 210,7334 }, { 211,7334 },

 { 212,7334 }, { 213,7334 }, { 214,7334 }, { 215,7334 }, { 216,7334 },
 { 217,7334 }, { 218,7334 }, { 219,7334 }, { 220,7334 }, { 221,7334 },
 { 222,7334 }, { 223,7334 }, { 224,7334 }, { 225,7334 }, { 226,7334 },
 { 227,7334 }, { 228,7334 }, { 229,7334 }, { 230,7334 }, { 231,7334 },
 { 232,7334 }, { 233,7334 }, { 234,7334 }, { 235,7334 }, { 236,7334 },
 { 237,7334 }, { 238,7334 }, { 239,7334 }, { 240,7334 }, { 241,7334 },
 { 242,7334 }, { 243,7334 }, { 244,7334 }, { 245,7334 }, { 246,7334 },
 { 247,7334 }, { 248,7334 }, { 249,7334 }, { 250,7334 }, { 251,7334 },
 { 252,7334 }, { 253,7334 }, { 254,7334 }, { 255,7334 }, {   0,  71 },
 {   0,25327 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,7077 }, {   0,   0 }, {   0,   0 }, {  39,-1761 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,7077 }, {  49,7077 },
 {  50,7077 }, {  51,7077 }, {  52,7077 }, {  53,7077 }, {  54,7077 },

 {  55,7077 }, {  56,7077 }, {  57,7077 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,7077 }, {  66,7077 }, {  67,7077 }, {  68,7077 }, {  69,7077 },
 {  70,7077 }, {  71,7077 }, {  72,7077 }, {  73,7077 }, {  74,7077 },
 {  75,7077 }, {  76,7077 }, {  77,7077 }, {  78,7077 }, {  79,7077 },
 {  80,7077 }, {  81,7077 }, {  82,7077 }, {  83,7077 }, {  84,7077 },
 {  85,7077 }, {  86,7077 }, {  87,7077 }, {  88,7077 }, {  89,7077 },
 {  90,7077 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,7077 }, {   0,   0 }, {  97,7077 }, {  98,7077 }, {  99,7077 },
 { 100,7077 }, { 101,7077 }, { 102,7077 }, { 103,7077 }, { 104,7077 },

 { 105,7077 }, { 106,7077 }, { 107,7077 }, { 108,7077 }, { 109,7077 },
 { 110,7077 }, { 111,7077 }, { 112,7077 }, { 113,7077 }, { 114,7077 },
 { 115,7077 }, { 116,7077 }, { 117,7077 }, { 118,7077 }, { 119,7077 },
 { 120,7077 }, { 121,7077 }, { 122,7077 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,7077 }, { 129,7077 },
 { 130,7077 }, { 131,7077 }, { 132,7077 }, { 133,7077 }, { 134,7077 },
 { 135,7077 }, { 136,7077 }, { 137,7077 }, { 138,7077 }, { 139,7077 },
 { 140,7077 }, { 141,7077 }, { 142,7077 }, { 143,7077 }, { 144,7077 },
 { 145,7077 }, { 146,7077 }, { 147,7077 }, { 148,7077 }, { 149,7077 },
 { 150,7077 }, { 151,7077 }, { 152,7077 }, { 153,7077 }, { 154,7077 },

 { 155,7077 }, { 156,7077 }, { 157,7077 }, { 158,7077 }, { 159,7077 },
 { 160,7077 }, { 161,7077 }, { 162,7077 }, { 163,7077 }, { 164,7077 },
 { 165,7077 }, { 166,7077 }, { 167,7077 }, { 168,7077 }, { 169,7077 },
 { 170,7077 }, { 171,7077 }, { 172,7077 }, { 173,7077 }, { 174,7077 },
 { 175,7077 }, { 176,7077 }, { 177,7077 }, { 178,7077 }, { 179,7077 },
 { 180,7077 }, { 181,7077 }, { 182,7077 }, { 183,7077 }, { 184,7077 },
 { 185,7077 }, { 186,7077 }, { 187,7077 }, { 188,7077 }, { 189,7077 },
 { 190,7077 }, { 191,7077 }, { 192,7077 }, { 193,7077 }, { 194,7077 },
 { 195,7077 }, { 196,7077 }, { 197,7077 }, { 198,7077 }, { 199,7077 },
 { 200,7077 }, { 201,7077 }, { 202,7077 }, { 203,7077 }, { 204,7077 },

 { 205,7077 }, { 206,7077 }, { 207,7077 }, { 208,7077 }, { 209,7077 },
 { 210,7077 }, { 211,7077 }, { 212,7077 }, { 213,7077 }, { 214,7077 },
 { 215,7077 }, { 216,7077 }, { 217,7077 }, { 218,7077 }, { 219,7077 },
 { 220,7077 }, { 221,7077 }, { 222,7077 }, { 223,7077 }, { 224,7077 },
 { 225,7077 }, { 226,7077 }, { 227,7077 }, { 228,7077 }, { 229,7077 },
 { 230,7077 }, { 231,7077 }, { 232,7077 }, { 233,7077 }, { 234,7077 },
 { 235,7077 }, { 236,7077 }, { 237,7077 }, { 238,7077 }, { 239,7077 },
 { 240,7077 }, { 241,7077 }, { 242,7077 }, { 243,7077 }, { 244,7077 },
 { 245,7077 }, { 246,7077 }, { 247,7077 }, { 248,7077 }, { 249,7077 },
 { 250,7077 }, { 251,7077 }, { 252,7077 }, { 253,7077 }, { 254,7077 },

 { 255,7077 }, {   0,  71 }, {   0,25070 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,6820 }, {   0,   0 },
 {  38,-1783 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,6820 }, {  49,6820 }, {  50,6820 }, {  51,6820 }, {  52,6820 },
 {  53,6820 }, {  54,6820 }, {  55,6820 }, {  56,6820 }, {  57,6820 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,6820 }, {  66,6820 }, {  67,6820 },
 {  68,6820 }, {  69,6820 }, {  70,6820 }, {  71,6820 }, {  72,6820 },
 {  73,6820 }, {  74,6820 }, {  75,6820 }, {  76,6820 }, {  77,6820 },
 {  78,6820 }, {  79,6820 }, {  80,6820 }, {  81,6820 }, {  82,6820 },
 {  83,6820 }, {  84,6820 }, {  85,6820 }, {  86,6820 }, {  87,6820 },
 {  88,6820 }, {  89,6820 }, {  90,6820 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,6820 }, {   0,   0 }, {  97,6820 },

 {  98,6820 }, {  99,6820 }, { 100,6820 }, { 101,6820 }, { 102,6820 },
 { 103,6820 }, { 104,6820 }, { 105,6820 }, { 106,6820 }, { 107,6820 },
 { 108,6820 }, { 109,6820 }, { 110,6820 }, { 111,6820 }, { 112,6820 },
 { 113,6820 }, { 114,6820 }, { 115,6820 }, { 116,6820 }, { 117,6820 },
 { 118,6820 }, { 119,6820 }, { 120,6820 }, { 121,6820 }, { 122,6820 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,6820 }, { 129,6820 }, { 130,6820 }, { 131,6820 }, { 132,6820 },
 { 133,6820 }, { 134,6820 }, { 135,6820 }, { 136,6820 }, { 137,6820 },
 { 138,6820 }, { 139,6820 }, { 140,6820 }, { 141,6820 }, { 142,6820 },
 { 143,6820 }, { 144,6820 }, { 145,6820 }, { 146,6820 }, { 147,6820 },

 { 148,6820 }, { 149,6820 }, { 150,6820 }, { 151,6820 }, { 152,6820 },
 { 153,6820 }, { 154,6820 }, { 155,6820 }, { 156,6820 }, { 157,6820 },
 { 158,6820 }, { 159,6820 }, { 160,6820 }, { 161,6820 }, { 162,6820 },
 { 163,6820 }, { 164,6820 }, { 165,6820 }, { 166,6820 }, { 167,6820 },
 { 168,6820 }, { 169,6820 }, { 170,6820 }, { 171,6820 }, { 172,6820 },
 { 173,6820 }, { 174,6820 }, { 175,6820 }, { 176,6820 }, { 177,6820 },
 { 178,6820 }, { 179,6820 }, { 180,6820 }, { 181,6820 }, { 182,6820 },
 { 183,6820 }, { 184,6820 }, { 185,6820 }, { 186,6820 }, { 187,6820 },
 { 188,6820 }, { 189,6820 }, { 190,6820 }, { 191,6820 }, { 192,6820 },
 { 193,6820 }, { 194,6820 }, { 195,6820 }, { 196,6820 }, { 197,6820 },

 { 198,6820 }, { 199,6820 }, { 200,6820 }, { 201,6820 }, { 202,6820 },
 { 203,6820 }, { 204,6820 }, { 205,6820 }, { 206,6820 }, { 207,6820 },
 { 208,6820 }, { 209,6820 }, { 210,6820 }, { 211,6820 }, { 212,6820 },
 { 213,6820 }, { 214,6820 }, { 215,6820 }, { 216,6820 }, { 217,6820 },
 { 218,6820 }, { 219,6820 }, { 220,6820 }, { 221,6820 }, { 222,6820 },
 { 223,6820 }, { 224,6820 }, { 225,6820 }, { 226,6820 }, { 227,6820 },
 { 228,6820 }, { 229,6820 }, { 230,6820 }, { 231,6820 }, { 232,6820 },
 { 233,6820 }, { 234,6820 }, { 235,6820 }, { 236,6820 }, { 237,6820 },
 { 238,6820 }, { 239,6820 }, { 240,6820 }, { 241,6820 }, { 242,6820 },
 { 243,6820 }, { 244,6820 }, { 245,6820 }, { 246,6820 }, { 247,6820 },

 { 248,6820 }, { 249,6820 }, { 250,6820 }, { 251,6820 }, { 252,6820 },
 { 253,6820 }, { 254,6820 }, { 255,6820 }, {   0,  71 }, {   0,24813 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,6563 }, {   0,   0 }, {   0,   0 }, {  39,-2038 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6563 }, {  49,6563 }, {  50,6563 },
 {  51,6563 }, {  52,6563 }, {  53,6563 }, {  54,6563 }, {  55,6563 },
 {  56,6563 }, {  57,6563 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6563 },
 {  66,6563 }, {  67,6563 }, {  68,6563 }, {  69,6563 }, {  70,6563 },
 {  71,6563 }, {  72,6563 }, {  73,6563 }, {  74,6563 }, {  75,6563 },
 {  76,6563 }, {  77,6563 }, {  78,6563 }, {  79,6563 }, {  80,6563 },
 {  81,6563 }, {  82,6563 }, {  83,6563 }, {  84,6563 }, {  85,6563 },
 {  86,6563 }, {  87,6563 }, {  88,6563 }, {  89,6563 }, {  90,6563 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6563 },
 {   0,   0 }, {  97,6563 }, {  98,6563 }, {  99,6563 }, { 100,6563 },
 { 101,6563 }, { 102,6563 }, { 103,6563 }, { 104,6563 }, { 105,6563 },
 { 106,6563 }, { 107,6563 }, { 108,6563 }, { 109,6563 }, { 110,6563 },
 { 111,6563 }, { 112,6563 }, { 113,6563 }, { 114,6563 }, { 115,6563 },
 { 116,6563 }, { 117,6563 }, { 118,6563 }, { 119,6563 }, { 120,6563 },
 { 121,6563 }, { 122,6563 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,6563 }, { 129,6563 }, { 130,6563 },
 { 131,6563 }, { 132,6563 }, { 133,6563 }, { 134,6563 }, { 135,6563 },
 { 136,6563 }, { 137,6563 }, { 138,6563 }, { 139,6563 }, { 140,6563 },

 { 141,6563 }, { 142,6563 }, { 143,6563 }, { 144,6563 }, { 145,6563 },
 { 146,6563 }, { 147,6563 }, { 148,6563 }, { 149,6563 }, { 150,6563 },
 { 151,6563 }, { 152,6563 }, { 153,6563 }, { 154,6563 }, { 155,6563 },
 { 156,6563 }, { 157,6563 }, { 158,6563 }, { 159,6563 }, { 160,6563 },
 { 161,6563 }, { 162,6563 }, { 163,6563 }, { 164,6563 }, { 165,6563 },
 { 166,6563 }, { 167,6563 }, { 168,6563 }, { 169,6563 }, { 170,6563 },
 { 171,6563 }, { 172,6563 }, { 173,6563 }, { 174,6563 }, { 175,6563 },
 { 176,6563 }, { 177,6563 }, { 178,6563 }, { 179,6563 }, { 180,6563 },
 { 181,6563 }, { 182,6563 }, { 183,6563 }, { 184,6563 }, { 185,6563 },
 { 186,6563 }, { 187,6563 }, { 188,6563 }, { 189,6563 }, { 190,6563 },

 { 191,6563 }, { 192,6563 }, { 193,6563 }, { 194,6563 }, { 195,6563 },
 { 196,6563 }, { 197,6563 }, { 198,6563 }, { 199,6563 }, { 200,6563 },
 { 201,6563 }, { 202,6563 }, { 203,6563 }, { 204,6563 }, { 205,6563 },
 { 206,6563 }, { 207,6563 }, { 208,6563 }, { 209,6563 }, { 210,6563 },
 { 211,6563 }, { 212,6563 }, { 213,6563 }, { 214,6563 }, { 215,6563 },
 { 216,6563 }, { 217,6563 }, { 218,6563 }, { 219,6563 }, { 220,6563 },
 { 221,6563 }, { 222,6563 }, { 223,6563 }, { 224,6563 }, { 225,6563 },
 { 226,6563 }, { 227,6563 }, { 228,6563 }, { 229,6563 }, { 230,6563 },
 { 231,6563 }, { 232,6563 }, { 233,6563 }, { 234,6563 }, { 235,6563 },
 { 236,6563 }, { 237,6563 }, { 238,6563 }, { 239,6563 }, { 240,6563 },

 { 241,6563 }, { 242,6563 }, { 243,6563 }, { 244,6563 }, { 245,6563 },
 { 246,6563 }, { 247,6563 }, { 248,6563 }, { 249,6563 }, { 250,6563 },
 { 251,6563 }, { 252,6563 }, { 253,6563 }, { 254,6563 }, { 255,6563 },
 {   0,  11 }, {   0,24556 }, {   1,6563 }, {   2,6563 }, {   3,6563 },
 {   4,6563 }, {   5,6563 }, {   6,6563 }, {   7,6563 }, {   8,6563 },
 {   9,6563 }, {  10,6563 }, {  11,6563 }, {  12,6563 }, {  13,6563 },
 {  14,6563 }, {  15,6563 }, {  16,6563 }, {  17,6563 }, {  18,6563 },
 {  19,6563 }, {  20,6563 }, {  21,6563 }, {  22,6563 }, {  23,6563 },
 {  24,6563 }, {  25,6563 }, {  26,6563 }, {  27,6563 }, {  28,6563 },
 {  29,6563 }, {  30,6563 }, {  31,6563 }, {  32,6563 }, {  33,6563 },

 {  34,6563 }, {  35,6563 }, {  36,6563 }, {  37,6563 }, {  38,6563 },
 {   0,   0 }, {  40,6563 }, {  41,6563 }, {  42,6563 }, {  43,6563 },
 {  44,6563 }, {  45,6563 }, {  46,6563 }, {  47,6563 }, {  48,6563 },
 {  49,6563 }, {  50,6563 }, {  51,6563 }, {  52,6563 }, {  53,6563 },
 {  54,6563 }, {  55,6563 }, {  56,6563 }, {  57,6563 }, {  58,6563 },
 {  59,6563 }, {  60,6563 }, {  61,6563 }, {  62,6563 }, {  63,6563 },
 {  64,6563 }, {  65,6563 }, {  66,6563 }, {  67,6563 }, {  68,6563 },
 {  69,6563 }, {  70,6563 }, {  71,6563 }, {  72,6563 }, {  73,6563 },
 {  74,6563 }, {  75,6563 }, {  76,6563 }, {  77,6563 }, {  78,6563 },
 {  79,6563 }, {  80,6563 }, {  81,6563 }, {  82,6563 }, {  83,6563 },

 {  84,6563 }, {  85,6563 }, {  86,6563 }, {  87,6563 }, {  88,6563 },
 {  89,6563 }, {  90,6563 }, {  91,6563 }, {  92,6563 }, {  93,6563 },
 {  94,6563 }, {  95,6563 }, {  96,6563 }, {  97,6563 }, {  98,6563 },
 {  99,6563 }, { 100,6563 }, { 101,6563 }, { 102,6563 }, { 103,6563 },
 { 104,6563 }, { 105,6563 }, { 106,6563 }, { 107,6563 }, { 108,6563 },
 { 109,6563 }, { 110,6563 }, { 111,6563 }, { 112,6563 }, { 113,6563 },
 { 114,6563 }, { 115,6563 }, { 116,6563 }, { 117,6563 }, { 118,6563 },
 { 119,6563 }, { 120,6563 }, { 121,6563 }, { 122,6563 }, { 123,6563 },
 { 124,6563 }, { 125,6563 }, { 126,6563 }, { 127,6563 }, { 128,6563 },
 { 129,6563 }, { 130,6563 }, { 131,6563 }, { 132,6563 }, { 133,6563 },

 { 134,6563 }, { 135,6563 }, { 136,6563 }, { 137,6563 }, { 138,6563 },
 { 139,6563 }, { 140,6563 }, { 141,6563 }, { 142,6563 }, { 143,6563 },
 { 144,6563 }, { 145,6563 }, { 146,6563 }, { 147,6563 }, { 148,6563 },
 { 149,6563 }, { 150,6563 }, { 151,6563 }, { 152,6563 }, { 153,6563 },
 { 154,6563 }, { 155,6563 }, { 156,6563 }, { 157,6563 }, { 158,6563 },
 { 159,6563 }, { 160,6563 }, { 161,6563 }, { 162,6563 }, { 163,6563 },
 { 164,6563 }, { 165,6563 }, { 166,6563 }, { 167,6563 }, { 168,6563 },
 { 169,6563 }, { 170,6563 }, { 171,6563 }, { 172,6563 }, { 173,6563 },
 { 174,6563 }, { 175,6563 }, { 176,6563 }, { 177,6563 }, { 178,6563 },
 { 179,6563 }, { 180,6563 }, { 181,6563 }, { 182,6563 }, { 183,6563 },

 { 184,6563 }, { 185,6563 }, { 186,6563 }, { 187,6563 }, { 188,6563 },
 { 189,6563 }, { 190,6563 }, { 191,6563 }, { 192,6563 }, { 193,6563 },
 { 194,6563 }, { 195,6563 }, { 196,6563 }, { 197,6563 }, { 198,6563 },
 { 199,6563 }, { 200,6563 }, { 201,6563 }, { 202,6563 }, { 203,6563 },
 { 204,6563 }, { 205,6563 }, { 206,6563 }, { 207,6563 }, { 208,6563 },
 { 209,6563 }, { 210,6563 }, { 211,6563 }, { 212,6563 }, { 213,6563 },
 { 214,6563 }, { 215,6563 }, { 216,6563 }, { 217,6563 }, { 218,6563 },
 { 219,6563 }, { 220,6563 }, { 221,6563 }, { 222,6563 }, { 223,6563 },
 { 224,6563 }, { 225,6563 }, { 226,6563 }, { 227,6563 }, { 228,6563 },
 { 229,6563 }, { 230,6563 }, { 231,6563 }, { 232,6563 }, { 233,6563 },

 { 234,6563 }, { 235,6563 }, { 236,6563 }, { 237,6563 }, { 238,6563 },
 { 239,6563 }, { 240,6563 }, { 241,6563 }, { 242,6563 }, { 243,6563 },
 { 244,6563 }, { 245,6563 }, { 246,6563 }, { 247,6563 }, { 248,6563 },
 { 249,6563 }, { 250,6563 }, { 251,6563 }, { 252,6563 }, { 253,6563 },
 { 254,6563 }, { 255,6563 }, { 256,6563 }, {   0,   6 }, {   0,24298 },
 {   1,6563 }, {   2,6563 }, {   3,6563 }, {   4,6563 }, {   5,6563 },
 {   6,6563 }, {   7,6563 }, {   8,6563 }, {   9,6563 }, {  10,6563 },
 {  11,6563 }, {  12,6563 }, {  13,6563 }, {  14,6563 }, {  15,6563 },
 {  16,6563 }, {  17,6563 }, {  18,6563 }, {  19,6563 }, {  20,6563 },
 {  21,6563 }, {  22,6563 }, {  23,6563 }, {  24,6563 }, {  25,6563 },

 {  26,6563 }, {  27,6563 }, {  28,6563 }, {  29,6563 }, {  30,6563 },
 {  31,6563 }, {  32,6563 }, {  33,6563 }, {  34,6563 }, {  35,6563 },
 {  36,6563 }, {  37,6563 }, {  38,6563 }, {  39,6563 }, {  40,6563 },
 {  41,6563 }, {   0,   0 }, {  43,6563 }, {  44,6563 }, {  45,6563 },
 {  46,6563 }, {   0,   0 }, {  48,6563 }, {  49,6563 }, {  50,6563 },
 {  51,6563 }, {  52,6563 }, {  53,6563 }, {  54,6563 }, {  55,6563 },
 {  56,6563 }, {  57,6563 }, {  58,6563 }, {  59,6563 }, {  60,6563 },
 {  61,6563 }, {  62,6563 }, {  63,6563 }, {  64,6563 }, {  65,6563 },
 {  66,6563 }, {  67,6563 }, {  68,6563 }, {  69,6563 }, {  70,6563 },
 {  71,6563 }, {  72,6563 }, {  73,6563 }, {  74,6563 }, {  75,6563 },

 {  76,6563 }, {  77,6563 }, {  78,6563 }, {  79,6563 }, {  80,6563 },
 {  81,6563 }, {  82,6563 }, {  83,6563 }, {  84,6563 }, {  85,6563 },
 {  86,6563 }, {  87,6563 }, {  88,6563 }, {  89,6563 }, {  90,6563 },
 {  91,6563 }, {  92,6563 }, {  93,6563 }, {  94,6563 }, {  95,6563 },
 {  96,6563 }, {  97,6563 }, {  98,6563 }, {  99,6563 }, { 100,6563 },
 { 101,6563 }, { 102,6563 }, { 103,6563 }, { 104,6563 }, { 105,6563 },
 { 106,6563 }, { 107,6563 }, { 108,6563 }, { 109,6563 }, { 110,6563 },
 { 111,6563 }, { 112,6563 }, { 113,6563 }, { 114,6563 }, { 115,6563 },
 { 116,6563 }, { 117,6563 }, { 118,6563 }, { 119,6563 }, { 120,6563 },
 { 121,6563 }, { 122,6563 }, { 123,6563 }, { 124,6563 }, { 125,6563 },

 { 126,6563 }, { 127,6563 }, { 128,6563 }, { 129,6563 }, { 130,6563 },
 { 131,6563 }, { 132,6563 }, { 133,6563 }, { 134,6563 }, { 135,6563 },
 { 136,6563 }, { 137,6563 }, { 138,6563 }, { 139,6563 }, { 140,6563 },
 { 141,6563 }, { 142,6563 }, { 143,6563 }, { 144,6563 }, { 145,6563 },
 { 146,6563 }, { 147,6563 }, { 148,6563 }, { 149,6563 }, { 150,6563 },
 { 151,6563 }, { 152,6563 }, { 153,6563 }, { 154,6563 }, { 155,6563 },
 { 156,6563 }, { 157,6563 }, { 158,6563 }, { 159,6563 }, { 160,6563 },
 { 161,6563 }, { 162,6563 }, { 163,6563 }, { 164,6563 }, { 165,6563 },
 { 166,6563 }, { 167,6563 }, { 168,6563 }, { 169,6563 }, { 170,6563 },
 { 171,6563 }, { 172,6563 }, { 173,6563 }, { 174,6563 }, { 175,6563 },

 { 176,6563 }, { 177,6563 }, { 178,6563 }, { 179,6563 }, { 180,6563 },
 { 181,6563 }, { 182,6563 }, { 183,6563 }, { 184,6563 }, { 185,6563 },
 { 186,6563 }, { 187,6563 }, { 188,6563 }, { 189,6563 }, { 190,6563 },
 { 191,6563 }, { 192,6563 }, { 193,6563 }, { 194,6563 }, { 195,6563 },
 { 196,6563 }, { 197,6563 }, { 198,6563 }, { 199,6563 }, { 200,6563 },
 { 201,6563 }, { 202,6563 }, { 203,6563 }, { 204,6563 }, { 205,6563 },
 { 206,6563 }, { 207,6563 }, { 208,6563 }, { 209,6563 }, { 210,6563 },
 { 211,6563 }, { 212,6563 }, { 213,6563 }, { 214,6563 }, { 215,6563 },
 { 216,6563 }, { 217,6563 }, { 218,6563 }, { 219,6563 }, { 220,6563 },
 { 221,6563 }, { 222,6563 }, { 223,6563 }, { 224,6563 }, { 225,6563 },

 { 226,6563 }, { 227,6563 }, { 228,6563 }, { 229,6563 }, { 230,6563 },
 { 231,6563 }, { 232,6563 }, { 233,6563 }, { 234,6563 }, { 235,6563 },
 { 236,6563 }, { 237,6563 }, { 238,6563 }, { 239,6563 }, { 240,6563 },
 { 241,6563 }, { 242,6563 }, { 243,6563 }, { 244,6563 }, { 245,6563 },
 { 246,6563 }, { 247,6563 }, { 248,6563 }, { 249,6563 }, { 250,6563 },
 { 251,6563 }, { 252,6563 }, { 253,6563 }, { 254,6563 }, { 255,6563 },
 { 256,6563 }, {   0,   6 }, {   0,24040 }, {   1,6305 }, {   2,6305 },
 {   3,6305 }, {   4,6305 }, {   5,6305 }, {   6,6305 }, {   7,6305 },
 {   8,6305 }, {   9,6305 }, {  10,6305 }, {  11,6305 }, {  12,6305 },
 {  13,6305 }, {  14,6305 }, {  15,6305 }, {  16,6305 }, {  17,6305 },

 {  18,6305 }, {  19,6305 }, {  20,6305 }, {  21,6305 }, {  22,6305 },
 {  23,6305 }, {  24,6305 }, {  25,6305 }, {  26,6305 }, {  27,6305 },
 {  28,6305 }, {  29,6305 }, {  30,6305 }, {  31,6305 }, {  32,6305 },
 {  33,6305 }, {  34,6305 }, {  35,6305 }, {  36,6305 }, {  37,6305 },
 {  38,6305 }, {  39,6305 }, {  40,6305 }, {  41,6305 }, {   0,   0 },
 {  43,6305 }, {  44,6305 }, {  45,6305 }, {  46,6305 }, {   0,   0 },
 {  48,6305 }, {  49,6305 }, {  50,6305 }, {  51,6305 }, {  52,6305 },
 {  53,6305 }, {  54,6305 }, {  55,6305 }, {  56,6305 }, {  57,6305 },
 {  58,6305 }, {  59,6305 }, {  60,6305 }, {  61,6305 }, {  62,6305 },
 {  63,6305 }, {  64,6305 }, {  65,6305 }, {  66,6305 }, {  67,6305 },

 {  68,6305 }, {  69,6305 }, {  70,6305 }, {  71,6305 }, {  72,6305 },
 {  73,6305 }, {  74,6305 }, {  75,6305 }, {  76,6305 }, {  77,6305 },
 {  78,6305 }, {  79,6305 }, {  80,6305 }, {  81,6305 }, {  82,6305 },
 {  83,6305 }, {  84,6305 }, {  85,6305 }, {  86,6305 }, {  87,6305 },
 {  88,6305 }, {  89,6305 }, {  90,6305 }, {  91,6305 }, {  92,6305 },
 {  93,6305 }, {  94,6305 }, {  95,6305 }, {  96,6305 }, {  97,6305 },
 {  98,6305 }, {  99,6305 }, { 100,6305 }, { 101,6305 }, { 102,6305 },
 { 103,6305 }, { 104,6305 }, { 105,6305 }, { 106,6305 }, { 107,6305 },
 { 108,6305 }, { 109,6305 }, { 110,6305 }, { 111,6305 }, { 112,6305 },
 { 113,6305 }, { 114,6305 }, { 115,6305 }, { 116,6305 }, { 117,6305 },

 { 118,6305 }, { 119,6305 }, { 120,6305 }, { 121,6305 }, { 122,6305 },
 { 123,6305 }, { 124,6305 }, { 125,6305 }, { 126,6305 }, { 127,6305 },
 { 128,6305 }, { 129,6305 }, { 130,6305 }, { 131,6305 }, { 132,6305 },
 { 133,6305 }, { 134,6305 }, { 135,6305 }, { 136,6305 }, { 137,6305 },
 { 138,6305 }, { 139,6305 }, { 140,6305 }, { 141,6305 }, { 142,6305 },
 { 143,6305 }, { 144,6305 }, { 145,6305 }, { 146,6305 }, { 147,6305 },
 { 148,6305 }, { 149,6305 }, { 150,6305 }, { 151,6305 }, { 152,6305 },
 { 153,6305 }, { 154,6305 }, { 155,6305 }, { 156,6305 }, { 157,6305 },
 { 158,6305 }, { 159,6305 }, { 160,6305 }, { 161,6305 }, { 162,6305 },
 { 163,6305 }, { 164,6305 }, { 165,6305 }, { 166,6305 }, { 167,6305 },

 { 168,6305 }, { 169,6305 }, { 170,6305 }, { 171,6305 }, { 172,6305 },
 { 173,6305 }, { 174,6305 }, { 175,6305 }, { 176,6305 }, { 177,6305 },
 { 178,6305 }, { 179,6305 }, { 180,6305 }, { 181,6305 }, { 182,6305 },
 { 183,6305 }, { 184,6305 }, { 185,6305 }, { 186,6305 }, { 187,6305 },
 { 188,6305 }, { 189,6305 }, { 190,6305 }, { 191,6305 }, { 192,6305 },
 { 193,6305 }, { 194,6305 }, { 195,6305 }, { 196,6305 }, { 197,6305 },
 { 198,6305 }, { 199,6305 }, { 200,6305 }, { 201,6305 }, { 202,6305 },
 { 203,6305 }, { 204,6305 }, { 205,6305 }, { 206,6305 }, { 207,6305 },
 { 208,6305 }, { 209,6305 }, { 210,6305 }, { 211,6305 }, { 212,6305 },
 { 213,6305 }, { 214,6305 }, { 215,6305 }, { 216,6305 }, { 217,6305 },

 { 218,6305 }, { 219,6305 }, { 220,6305 }, { 221,6305 }, { 222,6305 },
 { 223,6305 }, { 224,6305 }, { 225,6305 }, { 226,6305 }, { 227,6305 },
 { 228,6305 }, { 229,6305 }, { 230,6305 }, { 231,6305 }, { 232,6305 },
 { 233,6305 }, { 234,6305 }, { 235,6305 }, { 236,6305 }, { 237,6305 },
 { 238,6305 }, { 239,6305 }, { 240,6305 }, { 241,6305 }, { 242,6305 },
 { 243,6305 }, { 244,6305 }, { 245,6305 }, { 246,6305 }, { 247,6305 },
 { 248,6305 }, { 249,6305 }, { 250,6305 }, { 251,6305 }, { 252,6305 },
 { 253,6305 }, { 254,6305 }, { 255,6305 }, { 256,6305 }, {   0,  44 },
 {   0,23782 }, {   1,6433 }, {   2,6433 }, {   3,6433 }, {   4,6433 },
 {   5,6433 }, {   6,6433 }, {   7,6433 }, {   8,6433 }, {   9,6433 },

 {  10,6433 }, {  11,6433 }, {  12,6433 }, {  13,6433 }, {  14,6433 },
 {  15,6433 }, {  16,6433 }, {  17,6433 }, {  18,6433 }, {  19,6433 },
 {  20,6433 }, {  21,6433 }, {  22,6433 }, {  23,6433 }, {  24,6433 },
 {  25,6433 }, {  26,6433 }, {  27,6433 }, {  28,6433 }, {  29,6433 },
 {  30,6433 }, {  31,6433 }, {  32,6433 }, {  33,6433 }, {   0,   0 },
 {  35,6433 }, {  36,6433 }, {  37,6433 }, {  38,6433 }, {  39,6433 },
 {  40,6433 }, {  41,6433 }, {  42,6433 }, {  43,6433 }, {  44,6433 },
 {  45,6433 }, {  46,6433 }, {  47,6433 }, {  48,6433 }, {  49,6433 },
 {  50,6433 }, {  51,6433 }, {  52,6433 }, {  53,6433 }, {  54,6433 },
 {  55,6433 }, {  56,6433 }, {  57,6433 }, {  58,6433 }, {  59,6433 },

 {  60,6433 }, {  61,6433 }, {  62,6433 }, {  63,6433 }, {  64,6433 },
 {  65,6433 }, {  66,6433 }, {  67,6433 }, {  68,6433 }, {  69,6433 },
 {  70,6433 }, {  71,6433 }, {  72,6433 }, {  73,6433 }, {  74,6433 },
 {  75,6433 }, {  76,6433 }, {  77,6433 }, {  78,6433 }, {  79,6433 },
 {  80,6433 }, {  81,6433 }, {  82,6433 }, {  83,6433 }, {  84,6433 },
 {  85,6433 }, {  86,6433 }, {  87,6433 }, {  88,6433 }, {  89,6433 },
 {  90,6433 }, {  91,6433 }, {  92,6433 }, {  93,6433 }, {  94,6433 },
 {  95,6433 }, {  96,6433 }, {  97,6433 }, {  98,6433 }, {  99,6433 },
 { 100,6433 }, { 101,6433 }, { 102,6433 }, { 103,6433 }, { 104,6433 },
 { 105,6433 }, { 106,6433 }, { 107,6433 }, { 108,6433 }, { 109,6433 },

 { 110,6433 }, { 111,6433 }, { 112,6433 }, { 113,6433 }, { 114,6433 },
 { 115,6433 }, { 116,6433 }, { 117,6433 }, { 118,6433 }, { 119,6433 },
 { 120,6433 }, { 121,6433 }, { 122,6433 }, { 123,6433 }, { 124,6433 },
 { 125,6433 }, { 126,6433 }, { 127,6433 }, { 128,6433 }, { 129,6433 },
 { 130,6433 }, { 131,6433 }, { 132,6433 }, { 133,6433 }, { 134,6433 },
 { 135,6433 }, { 136,6433 }, { 137,6433 }, { 138,6433 }, { 139,6433 },
 { 140,6433 }, { 141,6433 }, { 142,6433 }, { 143,6433 }, { 144,6433 },
 { 145,6433 }, { 146,6433 }, { 147,6433 }, { 148,6433 }, { 149,6433 },
 { 150,6433 }, { 151,6433 }, { 152,6433 }, { 153,6433 }, { 154,6433 },
 { 155,6433 }, { 156,6433 }, { 157,6433 }, { 158,6433 }, { 159,6433 },

 { 160,6433 }, { 161,6433 }, { 162,6433 }, { 163,6433 }, { 164,6433 },
 { 165,6433 }, { 166,6433 }, { 167,6433 }, { 168,6433 }, { 169,6433 },
 { 170,6433 }, { 171,6433 }, { 172,6433 }, { 173,6433 }, { 174,6433 },
 { 175,6433 }, { 176,6433 }, { 177,6433 }, { 178,6433 }, { 179,6433 },
 { 180,6433 }, { 181,6433 }, { 182,6433 }, { 183,6433 }, { 184,6433 },
 { 185,6433 }, { 186,6433 }, { 187,6433 }, { 188,6433 }, { 189,6433 },
 { 190,6433 }, { 191,6433 }, { 192,6433 }, { 193,6433 }, { 194,6433 },
 { 195,6433 }, { 196,6433 }, { 197,6433 }, { 198,6433 }, { 199,6433 },
 { 200,6433 }, { 201,6433 }, { 202,6433 }, { 203,6433 }, { 204,6433 },
 { 205,6433 }, { 206,6433 }, { 207,6433 }, { 208,6433 }, { 209,6433 },

 { 210,6433 }, { 211,6433 }, { 212,6433 }, { 213,6433 }, { 214,6433 },
 { 215,6433 }, { 216,6433 }, { 217,6433 }, { 218,6433 }, { 219,6433 },
 { 220,6433 }, { 221,6433 }, { 222,6433 }, { 223,6433 }, { 224,6433 },
 { 225,6433 }, { 226,6433 }, { 227,6433 }, { 228,6433 }, { 229,6433 },
 { 230,6433 }, { 231,6433 }, { 232,6433 }, { 233,6433 }, { 234,6433 },
 { 235,6433 }, { 236,6433 }, { 237,6433 }, { 238,6433 }, { 239,6433 },
 { 240,6433 }, { 241,6433 }, { 242,6433 }, { 243,6433 }, { 244,6433 },
 { 245,6433 }, { 246,6433 }, { 247,6433 }, { 248,6433 }, { 249,6433 },
 { 250,6433 }, { 251,6433 }, { 252,6433 }, { 253,6433 }, { 254,6433 },
 { 255,6433 }, { 256,6433 }, {   0,  10 }, {   0,23524 }, {   1,6433 },

 {   2,6433 }, {   3,6433 }, {   4,6433 }, {   5,6433 }, {   6,6433 },
 {   7,6433 }, {   8,6433 }, {   9,6433 }, {  10,6433 }, {  11,6433 },
 {  12,6433 }, {  13,6433 }, {  14,6433 }, {  15,6433 }, {  16,6433 },
 {  17,6433 }, {  18,6433 }, {  19,6433 }, {  20,6433 }, {  21,6433 },
 {  22,6433 }, {  23,6433 }, {  24,6433 }, {  25,6433 }, {  26,6433 },
 {  27,6433 }, {  28,6433 }, {  29,6433 }, {  30,6433 }, {  31,6433 },
 {  32,6433 }, {  33,6433 }, {  34,6433 }, {  35,6433 }, {  36,6433 },
 {  37,6433 }, {  38,6433 }, {   0,   0 }, {  40,6433 }, {  41,6433 },
 {  42,6433 }, {  43,6433 }, {  44,6433 }, {  45,6433 }, {  46,6433 },
 {  47,6433 }, {  48,6433 }, {  49,6433 }, {  50,6433 }, {  51,6433 },

 {  52,6433 }, {  53,6433 }, {  54,6433 }, {  55,6433 }, {  56,6433 },
 {  57,6433 }, {  58,6433 }, {  59,6433 }, {  60,6433 }, {  61,6433 },
 {  62,6433 }, {  63,6433 }, {  64,6433 }, {  65,6433 }, {  66,6433 },
 {  67,6433 }, {  68,6433 }, {  69,6433 }, {  70,6433 }, {  71,6433 },
 {  72,6433 }, {  73,6433 }, {  74,6433 }, {  75,6433 }, {  76,6433 },
 {  77,6433 }, {  78,6433 }, {  79,6433 }, {  80,6433 }, {  81,6433 },
 {  82,6433 }, {  83,6433 }, {  84,6433 }, {  85,6433 }, {  86,6433 },
 {  87,6433 }, {  88,6433 }, {  89,6433 }, {  90,6433 }, {  91,6433 },
 {  92,6433 }, {  93,6433 }, {  94,6433 }, {  95,6433 }, {  96,6433 },
 {  97,6433 }, {  98,6433 }, {  99,6433 }, { 100,6433 }, { 101,6433 },

 { 102,6433 }, { 103,6433 }, { 104,6433 }, { 105,6433 }, { 106,6433 },
 { 107,6433 }, { 108,6433 }, { 109,6433 }, { 110,6433 }, { 111,6433 },
 { 112,6433 }, { 113,6433 }, { 114,6433 }, { 115,6433 }, { 116,6433 },
 { 117,6433 }, { 118,6433 }, { 119,6433 }, { 120,6433 }, { 121,6433 },
 { 122,6433 }, { 123,6433 }, { 124,6433 }, { 125,6433 }, { 126,6433 },
 { 127,6433 }, { 128,6433 }, { 129,6433 }, { 130,6433 }, { 131,6433 },
 { 132,6433 }, { 133,6433 }, { 134,6433 }, { 135,6433 }, { 136,6433 },
 { 137,6433 }, { 138,6433 }, { 139,6433 }, { 140,6433 }, { 141,6433 },
 { 142,6433 }, { 143,6433 }, { 144,6433 }, { 145,6433 }, { 146,6433 },
 { 147,6433 }, { 148,6433 }, { 149,6433 }, { 150,6433 }, { 151,6433 },

 { 152,6433 }, { 153,6433 }, { 154,6433 }, { 155,6433 }, { 156,6433 },
 { 157,6433 }, { 158,6433 }, { 159,6433 }, { 160,6433 }, { 161,6433 },
 { 162,6433 }, { 163,6433 }, { 164,6433 }, { 165,6433 }, { 166,6433 },
 { 167,6433 }, { 168,6433 }, { 169,6433 }, { 170,6433 }, { 171,6433 },
 { 172,6433 }, { 173,6433 }, { 174,6433 }, { 175,6433 }, { 176,6433 },
 { 177,6433 }, { 178,6433 }, { 179,6433 }, { 180,6433 }, { 181,6433 },
 { 182,6433 }, { 183,6433 }, { 184,6433 }, { 185,6433 }, { 186,6433 },
 { 187,6433 }, { 188,6433 }, { 189,6433 }, { 190,6433 }, { 191,6433 },
 { 192,6433 }, { 193,6433 }, { 194,6433 }, { 195,6433 }, { 196,6433 },
 { 197,6433 }, { 198,6433 }, { 199,6433 }, { 200,6433 }, { 201,6433 },

 { 202,6433 }, { 203,6433 }, { 204,6433 }, { 205,6433 }, { 206,6433 },
 { 207,6433 }, { 208,6433 }, { 209,6433 }, { 210,6433 }, { 211,6433 },
 { 212,6433 }, { 213,6433 }, { 214,6433 }, { 215,6433 }, { 216,6433 },
 { 217,6433 }, { 218,6433 }, { 219,6433 }, { 220,6433 }, { 221,6433 },
 { 222,6433 }, { 223,6433 }, { 224,6433 }, { 225,6433 }, { 226,6433 },
 { 227,6433 }, { 228,6433 }, { 229,6433 }, { 230,6433 }, { 231,6433 },
 { 232,6433 }, { 233,6433 }, { 234,6433 }, { 235,6433 }, { 236,6433 },
 { 237,6433 }, { 238,6433 }, { 239,6433 }, { 240,6433 }, { 241,6433 },
 { 242,6433 }, { 243,6433 }, { 244,6433 }, { 245,6433 }, { 246,6433 },
 { 247,6433 }, { 248,6433 }, { 249,6433 }, { 250,6433 }, { 251,6433 },

 { 252,6433 }, { 253,6433 }, { 254,6433 }, { 255,6433 }, { 256,6433 },
 {   0,  22 }, {   0,23266 }, {   1,6433 }, {   2,6433 }, {   3,6433 },
 {   4,6433 }, {   5,6433 }, {   6,6433 }, {   7,6433 }, {   8,6433 },
 {   9,6433 }, {  10,6433 }, {  11,6433 }, {  12,6433 }, {  13,6433 },
 {  14,6433 }, {  15,6433 }, {  16,6433 }, {  17,6433 }, {  18,6433 },
 {  19,6433 }, {  20,6433 }, {  21,6433 }, {  22,6433 }, {  23,6433 },
 {  24,6433 }, {  25,6433 }, {  26,6433 }, {  27,6433 }, {  28,6433 },
 {  29,6433 }, {  30,6433 }, {  31,6433 }, {  32,6433 }, {  33,6433 },
 {  34,6433 }, {  35,6433 }, {  36,6433 }, {  37,6433 }, {  38,6433 },
 {   0,   0 }, {  40,6433 }, {  41,6433 }, {  42,6433 }, {  43,6433 },

 {  44,6433 }, {  45,6433 }, {  46,6433 }, {  47,6433 }, {  48,6433 },
 {  49,6433 }, {  50,6433 }, {  51,6433 }, {  52,6433 }, {  53,6433 },
 {  54,6433 }, {  55,6433 }, {  56,6433 }, {  57,6433 }, {  58,6433 },
 {  59,6433 }, {  60,6433 }, {  61,6433 }, {  62,6433 }, {  63,6433 },
 {  64,6433 }, {  65,6433 }, {  66,6433 }, {  67,6433 }, {  68,6433 },
 {  69,6433 }, {  70,6433 }, {  71,6433 }, {  72,6433 }, {  73,6433 },
 {  74,6433 }, {  75,6433 }, {  76,6433 }, {  77,6433 }, {  78,6433 },
 {  79,6433 }, {  80,6433 }, {  81,6433 }, {  82,6433 }, {  83,6433 },
 {  84,6433 }, {  85,6433 }, {  86,6433 }, {  87,6433 }, {  88,6433 },
 {  89,6433 }, {  90,6433 }, {  91,6433 }, {  92,6433 }, {  93,6433 },

 {  94,6433 }, {  95,6433 }, {  96,6433 }, {  97,6433 }, {  98,6433 },
 {  99,6433 }, { 100,6433 }, { 101,6433 }, { 102,6433 }, { 103,6433 },
 { 104,6433 }, { 105,6433 }, { 106,6433 }, { 107,6433 }, { 108,6433 },
 { 109,6433 }, { 110,6433 }, { 111,6433 }, { 112,6433 }, { 113,6433 },
 { 114,6433 }, { 115,6433 }, { 116,6433 }, { 117,6433 }, { 118,6433 },
 { 119,6433 }, { 120,6433 }, { 121,6433 }, { 122,6433 }, { 123,6433 },
 { 124,6433 }, { 125,6433 }, { 126,6433 }, { 127,6433 }, { 128,6433 },
 { 129,6433 }, { 130,6433 }, { 131,6433 }, { 132,6433 }, { 133,6433 },
 { 134,6433 }, { 135,6433 }, { 136,6433 }, { 137,6433 }, { 138,6433 },
 { 139,6433 }, { 140,6433 }, { 141,6433 }, { 142,6433 }, { 143,6433 },

 { 144,6433 }, { 145,6433 }, { 146,6433 }, { 147,6433 }, { 148,6433 },
 { 149,6433 }, { 150,6433 }, { 151,6433 }, { 152,6433 }, { 153,6433 },
 { 154,6433 }, { 155,6433 }, { 156,6433 }, { 157,6433 }, { 158,6433 },
 { 159,6433 }, { 160,6433 }, { 161,6433 }, { 162,6433 }, { 163,6433 },
 { 164,6433 }, { 165,6433 }, { 166,6433 }, { 167,6433 }, { 168,6433 },
 { 169,6433 }, { 170,6433 }, { 171,6433 }, { 172,6433 }, { 173,6433 },
 { 174,6433 }, { 175,6433 }, { 176,6433 }, { 177,6433 }, { 178,6433 },
 { 179,6433 }, { 180,6433 }, { 181,6433 }, { 182,6433 }, { 183,6433 },
 { 184,6433 }, { 185,6433 }, { 186,6433 }, { 187,6433 }, { 188,6433 },
 { 189,6433 }, { 190,6433 }, { 191,6433 }, { 192,6433 }, { 193,6433 },

 { 194,6433 }, { 195,6433 }, { 196,6433 }, { 197,6433 }, { 198,6433 },
 { 199,6433 }, { 200,6433 }, { 201,6433 }, { 202,6433 }, { 203,6433 },
 { 204,6433 }, { 205,6433 }, { 206,6433 }, { 207,6433 }, { 208,6433 },
 { 209,6433 }, { 210,6433 }, { 211,6433 }, { 212,6433 }, { 213,6433 },
 { 214,6433 }, { 215,6433 }, { 216,6433 }, { 217,6433 }, { 218,6433 },
 { 219,6433 }, { 220,6433 }, { 221,6433 }, { 222,6433 }, { 223,6433 },
 { 224,6433 }, { 225,6433 }, { 226,6433 }, { 227,6433 }, { 228,6433 },
 { 229,6433 }, { 230,6433 }, { 231,6433 }, { 232,6433 }, { 233,6433 },
 { 234,6433 }, { 235,6433 }, { 236,6433 }, { 237,6433 }, { 238,6433 },
 { 239,6433 }, { 240,6433 }, { 241,6433 }, { 242,6433 }, { 243,6433 },

 { 244,6433 }, { 245,6433 }, { 246,6433 }, { 247,6433 }, { 248,6433 },
 { 249,6433 }, { 250,6433 }, { 251,6433 }, { 252,6433 }, { 253,6433 },
 { 254,6433 }, { 255,6433 }, { 256,6433 }, {   0,  19 }, {   0,23008 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  19 }, {   0,23003 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,6433 }, {  10,6438 },
 {  11,6433 }, {  12,6433 }, {  13,6438 }, {   9,6457 }, {  10,6457 },
 {  11,6457 }, {  12,6457 }, {  13,6457 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  19 }, {   0,22979 }, {   0,   0 },
 {   0,   0 }, {  32,6433 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  32,6457 }, {   9,6433 }, {  10,6433 }, {  11,6433 },
 {  12,6433 }, {  13,6433 }, {   0,   0 }, {  39,-3831 }, {  45,-3828 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-3833 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  32,6433 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-3855 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-3857 }, {   0,  23 },
 {   0,22932 }, {   1,6433 }, {   2,6433 }, {   3,6433 }, {   4,6433 },
 {   5,6433 }, {   6,6433 }, {   7,6433 }, {   8,6433 }, {   9,6433 },

 {  10,6433 }, {  11,6433 }, {  12,6433 }, {  13,6433 }, {  14,6433 },
 {  15,6433 }, {  16,6433 }, {  17,6433 }, {  18,6433 }, {  19,6433 },
 {  20,6433 }, {  21,6433 }, {  22,6433 }, {  23,6433 }, {  24,6433 },
 {  25,6433 }, {  26,6433 }, {  27,6433 }, {  28,6433 }, {  29,6433 },
 {  30,6433 }, {  31,6433 }, {  32,6433 }, {  33,6433 }, {  34,6433 },
 {  35,6433 }, {  36,6433 }, {  37,6433 }, {  38,6433 }, {   0,   0 },
 {  40,6433 }, {  41,6433 }, {  42,6433 }, {  43,6433 }, {  44,6433 },
 {  45,6433 }, {  46,6433 }, {  47,6433 }, {  48,6433 }, {  49,6433 },
 {  50,6433 }, {  51,6433 }, {  52,6433 }, {  53,6433 }, {  54,6433 },
 {  55,6433 }, {  56,6433 }, {  57,6433 }, {  58,6433 }, {  59,6433 },

 {  60,6433 }, {  61,6433 }, {  62,6433 }, {  63,6433 }, {  64,6433 },
 {  65,6433 }, {  66,6433 }, {  67,6433 }, {  68,6433 }, {  69,6433 },
 {  70,6433 }, {  71,6433 }, {  72,6433 }, {  73,6433 }, {  74,6433 },
 {  75,6433 }, {  76,6433 }, {  77,6433 }, {  78,6433 }, {  79,6433 },
 {  80,6433 }, {  81,6433 }, {  82,6433 }, {  83,6433 }, {  84,6433 },
 {  85,6433 }, {  86,6433 }, {  87,6433 }, {  88,6433 }, {  89,6433 },
 {  90,6433 }, {  91,6433 }, {   0,   0 }, {  93,6433 }, {  94,6433 },
 {  95,6433 }, {  96,6433 }, {  97,6433 }, {  98,6433 }, {  99,6433 },
 { 100,6433 }, { 101,6433 }, { 102,6433 }, { 103,6433 }, { 104,6433 },
 { 105,6433 }, { 106,6433 }, { 107,6433 }, { 108,6433 }, { 109,6433 },

 { 110,6433 }, { 111,6433 }, { 112,6433 }, { 113,6433 }, { 114,6433 },
 { 115,6433 }, { 116,6433 }, { 117,6433 }, { 118,6433 }, { 119,6433 },
 { 120,6433 }, { 121,6433 }, { 122,6433 }, { 123,6433 }, { 124,6433 },
 { 125,6433 }, { 126,6433 }, { 127,6433 }, { 128,6433 }, { 129,6433 },
 { 130,6433 }, { 131,6433 }, { 132,6433 }, { 133,6433 }, { 134,6433 },
 { 135,6433 }, { 136,6433 }, { 137,6433 }, { 138,6433 }, { 139,6433 },
 { 140,6433 }, { 141,6433 }, { 142,6433 }, { 143,6433 }, { 144,6433 },
 { 145,6433 }, { 146,6433 }, { 147,6433 }, { 148,6433 }, { 149,6433 },
 { 150,6433 }, { 151,6433 }, { 152,6433 }, { 153,6433 }, { 154,6433 },
 { 155,6433 }, { 156,6433 }, { 157,6433 }, { 158,6433 }, { 159,6433 },

 { 160,6433 }, { 161,6433 }, { 162,6433 }, { 163,6433 }, { 164,6433 },
 { 165,6433 }, { 166,6433 }, { 167,6433 }, { 168,6433 }, { 169,6433 },
 { 170,6433 }, { 171,6433 }, { 172,6433 }, { 173,6433 }, { 174,6433 },
 { 175,6433 }, { 176,6433 }, { 177,6433 }, { 178,6433 }, { 179,6433 },
 { 180,6433 }, { 181,6433 }, { 182,6433 }, { 183,6433 }, { 184,6433 },
 { 185,6433 }, { 186,6433 }, { 187,6433 }, { 188,6433 }, { 189,6433 },
 { 190,6433 }, { 191,6433 }, { 192,6433 }, { 193,6433 }, { 194,6433 },
 { 195,6433 }, { 196,6433 }, { 197,6433 }, { 198,6433 }, { 199,6433 },
 { 200,6433 }, { 201,6433 }, { 202,6433 }, { 203,6433 }, { 204,6433 },
 { 205,6433 }, { 206,6433 }, { 207,6433 }, { 208,6433 }, { 209,6433 },

 { 210,6433 }, { 211,6433 }, { 212,6433 }, { 213,6433 }, { 214,6433 },
 { 215,6433 }, { 216,6433 }, { 217,6433 }, { 218,6433 }, { 219,6433 },
 { 220,6433 }, { 221,6433 }, { 222,6433 }, { 223,6433 }, { 224,6433 },
 { 225,6433 }, { 226,6433 }, { 227,6433 }, { 228,6433 }, { 229,6433 },
 { 230,6433 }, { 231,6433 }, { 232,6433 }, { 233,6433 }, { 234,6433 },
 { 235,6433 }, { 236,6433 }, { 237,6433 }, { 238,6433 }, { 239,6433 },
 { 240,6433 }, { 241,6433 }, { 242,6433 }, { 243,6433 }, { 244,6433 },
 { 245,6433 }, { 246,6433 }, { 247,6433 }, { 248,6433 }, { 249,6433 },
 { 250,6433 }, { 251,6433 }, { 252,6433 }, { 253,6433 }, { 254,6433 },
 { 255,6433 }, { 256,6433 }, {   0,  23 }, {   0,22674 }, {   1,6175 },

 {   2,6175 }, {   3,6175 }, {   4,6175 }, {   5,6175 }, {   6,6175 },
 {   7,6175 }, {   8,6175 }, {   9,6175 }, {  10,6175 }, {  11,6175 },
 {  12,6175 }, {  13,6175 }, {  14,6175 }, {  15,6175 }, {  16,6175 },
 {  17,6175 }, {  18,6175 }, {  19,6175 }, {  20,6175 }, {  21,6175 },
 {  22,6175 }, {  23,6175 }, {  24,6175 }, {  25,6175 }, {  26,6175 },
 {  27,6175 }, {  28,6175 }, {  29,6175 }, {  30,6175 }, {  31,6175 },
 {  32,6175 }, {  33,6175 }, {  34,6175 }, {  35,6175 }, {  36,6175 },
 {  37,6175 }, {  38,6175 }, {   0,   0 }, {  40,6175 }, {  41,6175 },
 {  42,6175 }, {  43,6175 }, {  44,6175 }, {  45,6175 }, {  46,6175 },
 {  47,6175 }, {  48,6175 }, {  49,6175 }, {  50,6175 }, {  51,6175 },

 {  52,6175 }, {  53,6175 }, {  54,6175 }, {  55,6175 }, {  56,6175 },
 {  57,6175 }, {  58,6175 }, {  59,6175 }, {  60,6175 }, {  61,6175 },
 {  62,6175 }, {  63,6175 }, {  64,6175 }, {  65,6175 }, {  66,6175 },
 {  67,6175 }, {  68,6175 }, {  69,6175 }, {  70,6175 }, {  71,6175 },
 {  72,6175 }, {  73,6175 }, {  74,6175 }, {  75,6175 }, {  76,6175 },
 {  77,6175 }, {  78,6175 }, {  79,6175 }, {  80,6175 }, {  81,6175 },
 {  82,6175 }, {  83,6175 }, {  84,6175 }, {  85,6175 }, {  86,6175 },
 {  87,6175 }, {  88,6175 }, {  89,6175 }, {  90,6175 }, {  91,6175 },
 {   0,   0 }, {  93,6175 }, {  94,6175 }, {  95,6175 }, {  96,6175 },
 {  97,6175 }, {  98,6175 }, {  99,6175 }, { 100,6175 }, { 101,6175 },

 { 102,6175 }, { 103,6175 }, { 104,6175 }, { 105,6175 }, { 106,6175 },
 { 107,6175 }, { 108,6175 }, { 109,6175 }, { 110,6175 }, { 111,6175 },
 { 112,6175 }, { 113,6175 }, { 114,6175 }, { 115,6175 }, { 116,6175 },
 { 117,6175 }, { 118,6175 }, { 119,6175 }, { 120,6175 }, { 121,6175 },
 { 122,6175 }, { 123,6175 }, { 124,6175 }, { 125,6175 }, { 126,6175 },
 { 127,6175 }, { 128,6175 }, { 129,6175 }, { 130,6175 }, { 131,6175 },
 { 132,6175 }, { 133,6175 }, { 134,6175 }, { 135,6175 }, { 136,6175 },
 { 137,6175 }, { 138,6175 }, { 139,6175 }, { 140,6175 }, { 141,6175 },
 { 142,6175 }, { 143,6175 }, { 144,6175 }, { 145,6175 }, { 146,6175 },
 { 147,6175 }, { 148,6175 }, { 149,6175 }, { 150,6175 }, { 151,6175 },

 { 152,6175 }, { 153,6175 }, { 154,6175 }, { 155,6175 }, { 156,6175 },
 { 157,6175 }, { 158,6175 }, { 159,6175 }, { 160,6175 }, { 161,6175 },
 { 162,6175 }, { 163,6175 }, { 164,6175 }, { 165,6175 }, { 166,6175 },
 { 167,6175 }, { 168,6175 }, { 169,6175 }, { 170,6175 }, { 171,6175 },
 { 172,6175 }, { 173,6175 }, { 174,6175 }, { 175,6175 }, { 176,6175 },
 { 177,6175 }, { 178,6175 }, { 179,6175 }, { 180,6175 }, { 181,6175 },
 { 182,6175 }, { 183,6175 }, { 184,6175 }, { 185,6175 }, { 186,6175 },
 { 187,6175 }, { 188,6175 }, { 189,6175 }, { 190,6175 }, { 191,6175 },
 { 192,6175 }, { 193,6175 }, { 194,6175 }, { 195,6175 }, { 196,6175 },
 { 197,6175 }, { 198,6175 }, { 199,6175 }, { 200,6175 }, { 201,6175 },

 { 202,6175 }, { 203,6175 }, { 204,6175 }, { 205,6175 }, { 206,6175 },
 { 207,6175 }, { 208,6175 }, { 209,6175 }, { 210,6175 }, { 211,6175 },
 { 212,6175 }, { 213,6175 }, { 214,6175 }, { 215,6175 }, { 216,6175 },
 { 217,6175 }, { 218,6175 }, { 219,6175 }, { 220,6175 }, { 221,6175 },
 { 222,6175 }, { 223,6175 }, { 224,6175 }, { 225,6175 }, { 226,6175 },
 { 227,6175 }, { 228,6175 }, { 229,6175 }, { 230,6175 }, { 231,6175 },
 { 232,6175 }, { 233,6175 }, { 234,6175 }, { 235,6175 }, { 236,6175 },
 { 237,6175 }, { 238,6175 }, { 239,6175 }, { 240,6175 }, { 241,6175 },
 { 242,6175 }, { 243,6175 }, { 244,6175 }, { 245,6175 }, { 246,6175 },
 { 247,6175 }, { 248,6175 }, { 249,6175 }, { 250,6175 }, { 251,6175 },

 { 252,6175 }, { 253,6175 }, { 254,6175 }, { 255,6175 }, { 256,6175 },
 {   0,  32 }, {   0,22416 }, {   1,-4416 }, {   2,-4416 }, {   3,-4416 },
 {   4,-4416 }, {   5,-4416 }, {   6,-4416 }, {   7,-4416 }, {   8,-4416 },
 {   9,-4416 }, {  10,-4416 }, {  11,-4416 }, {  12,-4416 }, {  13,-4416 },
 {  14,-4416 }, {  15,-4416 }, {  16,-4416 }, {  17,-4416 }, {  18,-4416 },
 {  19,-4416 }, {  20,-4416 }, {  21,-4416 }, {  22,-4416 }, {  23,-4416 },
 {  24,-4416 }, {  25,-4416 }, {  26,-4416 }, {  27,-4416 }, {  28,-4416 },
 {  29,-4416 }, {  30,-4416 }, {  31,-4416 }, {  32,-4416 }, {  33,-4416 },
 {  34,-4416 }, {  35,-4416 }, {  36,-4416 }, {  37,-4416 }, {  38,-4416 },
 {  39,-4416 }, {  40,-4416 }, {  41,-4416 }, {  42,-4416 }, {  43,-4416 },

 {  44,-4416 }, {  45,-4416 }, {  46,-4416 }, {  47,-4416 }, {  48,6175 },
 {  49,6175 }, {  50,6175 }, {  51,6175 }, {  52,6175 }, {  53,6175 },
 {  54,6175 }, {  55,6175 }, {  56,-4416 }, {  57,-4416 }, {  58,-4416 },
 {  59,-4416 }, {  60,-4416 }, {  61,-4416 }, {  62,-4416 }, {  63,-4416 },
 {  64,-4416 }, {  65,-4416 }, {  66,-4416 }, {  67,-4416 }, {  68,-4416 },
 {  69,-4416 }, {  70,-4416 }, {  71,-4416 }, {  72,-4416 }, {  73,-4416 },
 {  74,-4416 }, {  75,-4416 }, {  76,-4416 }, {  77,-4416 }, {  78,-4416 },
 {  79,-4416 }, {  80,-4416 }, {  81,-4416 }, {  82,-4416 }, {  83,-4416 },
 {  84,-4416 }, {  85,6183 }, {  86,-4416 }, {  87,-4416 }, {  88,-4416 },
 {  89,-4416 }, {  90,-4416 }, {  91,-4416 }, {  92,-4416 }, {  93,-4416 },

 {  94,-4416 }, {  95,-4416 }, {  96,-4416 }, {  97,-4416 }, {  98,-4416 },
 {  99,-4416 }, { 100,-4416 }, { 101,-4416 }, { 102,-4416 }, { 103,-4416 },
 { 104,-4416 }, { 105,-4416 }, { 106,-4416 }, { 107,-4416 }, { 108,-4416 },
 { 109,-4416 }, { 110,-4416 }, { 111,-4416 }, { 112,-4416 }, { 113,-4416 },
 { 114,-4416 }, { 115,-4416 }, { 116,-4416 }, { 117,6206 }, { 118,-4416 },
 { 119,-4416 }, { 120,6244 }, { 121,-4416 }, { 122,-4416 }, { 123,-4416 },
 { 124,-4416 }, { 125,-4416 }, { 126,-4416 }, { 127,-4416 }, { 128,-4416 },
 { 129,-4416 }, { 130,-4416 }, { 131,-4416 }, { 132,-4416 }, { 133,-4416 },
 { 134,-4416 }, { 135,-4416 }, { 136,-4416 }, { 137,-4416 }, { 138,-4416 },
 { 139,-4416 }, { 140,-4416 }, { 141,-4416 }, { 142,-4416 }, { 143,-4416 },

 { 144,-4416 }, { 145,-4416 }, { 146,-4416 }, { 147,-4416 }, { 148,-4416 },
 { 149,-4416 }, { 150,-4416 }, { 151,-4416 }, { 152,-4416 }, { 153,-4416 },
 { 154,-4416 }, { 155,-4416 }, { 156,-4416 }, { 157,-4416 }, { 158,-4416 },
 { 159,-4416 }, { 160,-4416 }, { 161,-4416 }, { 162,-4416 }, { 163,-4416 },
 { 164,-4416 }, { 165,-4416 }, { 166,-4416 }, { 167,-4416 }, { 168,-4416 },
 { 169,-4416 }, { 170,-4416 }, { 171,-4416 }, { 172,-4416 }, { 173,-4416 },
 { 174,-4416 }, { 175,-4416 }, { 176,-4416 }, { 177,-4416 }, { 178,-4416 },
 { 179,-4416 }, { 180,-4416 }, { 181,-4416 }, { 182,-4416 }, { 183,-4416 },
 { 184,-4416 }, { 185,-4416 }, { 186,-4416 }, { 187,-4416 }, { 188,-4416 },
 { 189,-4416 }, { 190,-4416 }, { 191,-4416 }, { 192,-4416 }, { 193,-4416 },

 { 194,-4416 }, { 195,-4416 }, { 196,-4416 }, { 197,-4416 }, { 198,-4416 },
 { 199,-4416 }, { 200,-4416 }, { 201,-4416 }, { 202,-4416 }, { 203,-4416 },
 { 204,-4416 }, { 205,-4416 }, { 206,-4416 }, { 207,-4416 }, { 208,-4416 },
 { 209,-4416 }, { 210,-4416 }, { 211,-4416 }, { 212,-4416 }, { 213,-4416 },
 { 214,-4416 }, { 215,-4416 }, { 216,-4416 }, { 217,-4416 }, { 218,-4416 },
 { 219,-4416 }, { 220,-4416 }, { 221,-4416 }, { 222,-4416 }, { 223,-4416 },
 { 224,-4416 }, { 225,-4416 }, { 226,-4416 }, { 227,-4416 }, { 228,-4416 },
 { 229,-4416 }, { 230,-4416 }, { 231,-4416 }, { 232,-4416 }, { 233,-4416 },
 { 234,-4416 }, { 235,-4416 }, { 236,-4416 }, { 237,-4416 }, { 238,-4416 },
 { 239,-4416 }, { 240,-4416 }, { 241,-4416 }, { 242,-4416 }, { 243,-4416 },

 { 244,-4416 }, { 245,-4416 }, { 246,-4416 }, { 247,-4416 }, { 248,-4416 },
 { 249,-4416 }, { 250,-4416 }, { 251,-4416 }, { 252,-4416 }, { 253,-4416 },
 { 254,-4416 }, { 255,-4416 }, { 256,-4416 }, {   0,  36 }, {   0,22158 },
 {   1,6090 }, {   2,6090 }, {   3,6090 }, {   4,6090 }, {   5,6090 },
 {   6,6090 }, {   7,6090 }, {   8,6090 }, {   9,6090 }, {  10,6090 },
 {  11,6090 }, {  12,6090 }, {  13,6090 }, {  14,6090 }, {  15,6090 },
 {  16,6090 }, {  17,6090 }, {  18,6090 }, {  19,6090 }, {  20,6090 },
 {  21,6090 }, {  22,6090 }, {  23,6090 }, {  24,6090 }, {  25,6090 },
 {  26,6090 }, {  27,6090 }, {  28,6090 }, {  29,6090 }, {  30,6090 },
 {  31,6090 }, {  32,6090 }, {  33,6090 }, {  34,6090 }, {  35,6090 },

 {   0,   0 }, {  37,6090 }, {  38,6090 }, {  39,6090 }, {  40,6090 },
 {  41,6090 }, {  42,6090 }, {  43,6090 }, {  44,6090 }, {  45,6090 },
 {  46,6090 }, {  47,6090 }, {  48,6090 }, {  49,6090 }, {  50,6090 },
 {  51,6090 }, {  52,6090 }, {  53,6090 }, {  54,6090 }, {  55,6090 },
 {  56,6090 }, {  57,6090 }, {  58,6090 }, {  59,6090 }, {  60,6090 },
 {  61,6090 }, {  62,6090 }, {  63,6090 }, {  64,6090 }, {  65,6090 },
 {  66,6090 }, {  67,6090 }, {  68,6090 }, {  69,6090 }, {  70,6090 },
 {  71,6090 }, {  72,6090 }, {  73,6090 }, {  74,6090 }, {  75,6090 },
 {  76,6090 }, {  77,6090 }, {  78,6090 }, {  79,6090 }, {  80,6090 },
 {  81,6090 }, {  82,6090 }, {  83,6090 }, {  84,6090 }, {  85,6090 },

 {  86,6090 }, {  87,6090 }, {  88,6090 }, {  89,6090 }, {  90,6090 },
 {  91,6090 }, {  92,6090 }, {  93,6090 }, {  94,6090 }, {  95,6090 },
 {  96,6090 }, {  97,6090 }, {  98,6090 }, {  99,6090 }, { 100,6090 },
 { 101,6090 }, { 102,6090 }, { 103,6090 }, { 104,6090 }, { 105,6090 },
 { 106,6090 }, { 107,6090 }, { 108,6090 }, { 109,6090 }, { 110,6090 },
 { 111,6090 }, { 112,6090 }, { 113,6090 }, { 114,6090 }, { 115,6090 },
 { 116,6090 }, { 117,6090 }, { 118,6090 }, { 119,6090 }, { 120,6090 },
 { 121,6090 }, { 122,6090 }, { 123,6090 }, { 124,6090 }, { 125,6090 },
 { 126,6090 }, { 127,6090 }, { 128,6090 }, { 129,6090 }, { 130,6090 },
 { 131,6090 }, { 132,6090 }, { 133,6090 }, { 134,6090 }, { 135,6090 },

 { 136,6090 }, { 137,6090 }, { 138,6090 }, { 139,6090 }, { 140,6090 },
 { 141,6090 }, { 142,6090 }, { 143,6090 }, { 144,6090 }, { 145,6090 },
 { 146,6090 }, { 147,6090 }, { 148,6090 }, { 149,6090 }, { 150,6090 },
 { 151,6090 }, { 152,6090 }, { 153,6090 }, { 154,6090 }, { 155,6090 },
 { 156,6090 }, { 157,6090 }, { 158,6090 }, { 159,6090 }, { 160,6090 },
 { 161,6090 }, { 162,6090 }, { 163,6090 }, { 164,6090 }, { 165,6090 },
 { 166,6090 }, { 167,6090 }, { 168,6090 }, { 169,6090 }, { 170,6090 },
 { 171,6090 }, { 172,6090 }, { 173,6090 }, { 174,6090 }, { 175,6090 },
 { 176,6090 }, { 177,6090 }, { 178,6090 }, { 179,6090 }, { 180,6090 },
 { 181,6090 }, { 182,6090 }, { 183,6090 }, { 184,6090 }, { 185,6090 },

 { 186,6090 }, { 187,6090 }, { 188,6090 }, { 189,6090 }, { 190,6090 },
 { 191,6090 }, { 192,6090 }, { 193,6090 }, { 194,6090 }, { 195,6090 },
 { 196,6090 }, { 197,6090 }, { 198,6090 }, { 199,6090 }, { 200,6090 },
 { 201,6090 }, { 202,6090 }, { 203,6090 }, { 204,6090 }, { 205,6090 },
 { 206,6090 }, { 207,6090 }, { 208,6090 }, { 209,6090 }, { 210,6090 },
 { 211,6090 }, { 212,6090 }, { 213,6090 }, { 214,6090 }, { 215,6090 },
 { 216,6090 }, { 217,6090 }, { 218,6090 }, { 219,6090 }, { 220,6090 },
 { 221,6090 }, { 222,6090 }, { 223,6090 }, { 224,6090 }, { 225,6090 },
 { 226,6090 }, { 227,6090 }, { 228,6090 }, { 229,6090 }, { 230,6090 },
 { 231,6090 }, { 232,6090 }, { 233,6090 }, { 234,6090 }, { 235,6090 },

 { 236,6090 }, { 237,6090 }, { 238,6090 }, { 239,6090 }, { 240,6090 },
 { 241,6090 }, { 242,6090 }, { 243,6090 }, { 244,6090 }, { 245,6090 },
 { 246,6090 }, { 247,6090 }, { 248,6090 }, { 249,6090 }, { 250,6090 },
 { 251,6090 }, { 252,6090 }, { 253,6090 }, { 254,6090 }, { 255,6090 },
 { 256,6090 }, {   0,  36 }, {   0,21900 }, {   1,5832 }, {   2,5832 },
 {   3,5832 }, {   4,5832 }, {   5,5832 }, {   6,5832 }, {   7,5832 },
 {   8,5832 }, {   9,5832 }, {  10,5832 }, {  11,5832 }, {  12,5832 },
 {  13,5832 }, {  14,5832 }, {  15,5832 }, {  16,5832 }, {  17,5832 },
 {  18,5832 }, {  19,5832 }, {  20,5832 }, {  21,5832 }, {  22,5832 },
 {  23,5832 }, {  24,5832 }, {  25,5832 }, {  26,5832 }, {  27,5832 },

 {  28,5832 }, {  29,5832 }, {  30,5832 }, {  31,5832 }, {  32,5832 },
 {  33,5832 }, {  34,5832 }, {  35,5832 }, {   0,   0 }, {  37,5832 },
 {  38,5832 }, {  39,5832 }, {  40,5832 }, {  41,5832 }, {  42,5832 },
 {  43,5832 }, {  44,5832 }, {  45,5832 }, {  46,5832 }, {  47,5832 },
 {  48,5832 }, {  49,5832 }, {  50,5832 }, {  51,5832 }, {  52,5832 },
 {  53,5832 }, {  54,5832 }, {  55,5832 }, {  56,5832 }, {  57,5832 },
 {  58,5832 }, {  59,5832 }, {  60,5832 }, {  61,5832 }, {  62,5832 },
 {  63,5832 }, {  64,5832 }, {  65,5832 }, {  66,5832 }, {  67,5832 },
 {  68,5832 }, {  69,5832 }, {  70,5832 }, {  71,5832 }, {  72,5832 },
 {  73,5832 }, {  74,5832 }, {  75,5832 }, {  76,5832 }, {  77,5832 },

 {  78,5832 }, {  79,5832 }, {  80,5832 }, {  81,5832 }, {  82,5832 },
 {  83,5832 }, {  84,5832 }, {  85,5832 }, {  86,5832 }, {  87,5832 },
 {  88,5832 }, {  89,5832 }, {  90,5832 }, {  91,5832 }, {  92,5832 },
 {  93,5832 }, {  94,5832 }, {  95,5832 }, {  96,5832 }, {  97,5832 },
 {  98,5832 }, {  99,5832 }, { 100,5832 }, { 101,5832 }, { 102,5832 },
 { 103,5832 }, { 104,5832 }, { 105,5832 }, { 106,5832 }, { 107,5832 },
 { 108,5832 }, { 109,5832 }, { 110,5832 }, { 111,5832 }, { 112,5832 },
 { 113,5832 }, { 114,5832 }, { 115,5832 }, { 116,5832 }, { 117,5832 },
 { 118,5832 }, { 119,5832 }, { 120,5832 }, { 121,5832 }, { 122,5832 },
 { 123,5832 }, { 124,5832 }, { 125,5832 }, { 126,5832 }, { 127,5832 },

 { 128,5832 }, { 129,5832 }, { 130,5832 }, { 131,5832 }, { 132,5832 },
 { 133,5832 }, { 134,5832 }, { 135,5832 }, { 136,5832 }, { 137,5832 },
 { 138,5832 }, { 139,5832 }, { 140,5832 }, { 141,5832 }, { 142,5832 },
 { 143,5832 }, { 144,5832 }, { 145,5832 }, { 146,5832 }, { 147,5832 },
 { 148,5832 }, { 149,5832 }, { 150,5832 }, { 151,5832 }, { 152,5832 },
 { 153,5832 }, { 154,5832 }, { 155,5832 }, { 156,5832 }, { 157,5832 },
 { 158,5832 }, { 159,5832 }, { 160,5832 }, { 161,5832 }, { 162,5832 },
 { 163,5832 }, { 164,5832 }, { 165,5832 }, { 166,5832 }, { 167,5832 },
 { 168,5832 }, { 169,5832 }, { 170,5832 }, { 171,5832 }, { 172,5832 },
 { 173,5832 }, { 174,5832 }, { 175,5832 }, { 176,5832 }, { 177,5832 },

 { 178,5832 }, { 179,5832 }, { 180,5832 }, { 181,5832 }, { 182,5832 },
 { 183,5832 }, { 184,5832 }, { 185,5832 }, { 186,5832 }, { 187,5832 },
 { 188,5832 }, { 189,5832 }, { 190,5832 }, { 191,5832 }, { 192,5832 },
 { 193,5832 }, { 194,5832 }, { 195,5832 }, { 196,5832 }, { 197,5832 },
 { 198,5832 }, { 199,5832 }, { 200,5832 }, { 201,5832 }, { 202,5832 },
 { 203,5832 }, { 204,5832 }, { 205,5832 }, { 206,5832 }, { 207,5832 },
 { 208,5832 }, { 209,5832 }, { 210,5832 }, { 211,5832 }, { 212,5832 },
 { 213,5832 }, { 214,5832 }, { 215,5832 }, { 216,5832 }, { 217,5832 },
 { 218,5832 }, { 219,5832 }, { 220,5832 }, { 221,5832 }, { 222,5832 },
 { 223,5832 }, { 224,5832 }, { 225,5832 }, { 226,5832 }, { 227,5832 },

 { 228,5832 }, { 229,5832 }, { 230,5832 }, { 231,5832 }, { 232,5832 },
 { 233,5832 }, { 234,5832 }, { 235,5832 }, { 236,5832 }, { 237,5832 },
 { 238,5832 }, { 239,5832 }, { 240,5832 }, { 241,5832 }, { 242,5832 },
 { 243,5832 }, { 244,5832 }, { 245,5832 }, { 246,5832 }, { 247,5832 },
 { 248,5832 }, { 249,5832 }, { 250,5832 }, { 251,5832 }, { 252,5832 },
 { 253,5832 }, { 254,5832 }, { 255,5832 }, { 256,5832 }, {   0,  38 },
 {   0,21642 }, {   0,   1 }, {   0,21640 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },
 {  13,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,   0 },
 {   0,   0 }, {  36,-5188 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5832 }, {  66,5832 }, {  67,5832 }, {  68,5832 }, {  69,5832 },

 {  70,5832 }, {  71,5832 }, {  72,5832 }, {  73,5832 }, {  74,5832 },
 {  75,5832 }, {  76,5832 }, {  77,5832 }, {  78,5832 }, {  79,5832 },
 {  80,5832 }, {  81,5832 }, {  82,5832 }, {  83,5832 }, {  84,5832 },
 {  85,5832 }, {  86,5832 }, {  87,5832 }, {  88,5832 }, {  89,5832 },
 {  90,5832 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5832 }, {   0,   0 }, {  97,5832 }, {  98,5832 }, {  99,5832 },
 { 100,5832 }, { 101,5832 }, { 102,5832 }, { 103,5832 }, { 104,5832 },
 { 105,5832 }, { 106,5832 }, { 107,5832 }, { 108,5832 }, { 109,5832 },
 { 110,5832 }, { 111,5832 }, { 112,5832 }, { 113,5832 }, { 114,5832 },
 { 115,5832 }, { 116,5832 }, { 117,5832 }, { 118,5832 }, { 119,5832 },

 { 120,5832 }, { 121,5832 }, { 122,5832 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5832 }, { 129,5832 },
 { 130,5832 }, { 131,5832 }, { 132,5832 }, { 133,5832 }, { 134,5832 },
 { 135,5832 }, { 136,5832 }, { 137,5832 }, { 138,5832 }, { 139,5832 },
 { 140,5832 }, { 141,5832 }, { 142,5832 }, { 143,5832 }, { 144,5832 },
 { 145,5832 }, { 146,5832 }, { 147,5832 }, { 148,5832 }, { 149,5832 },
 { 150,5832 }, { 151,5832 }, { 152,5832 }, { 153,5832 }, { 154,5832 },
 { 155,5832 }, { 156,5832 }, { 157,5832 }, { 158,5832 }, { 159,5832 },
 { 160,5832 }, { 161,5832 }, { 162,5832 }, { 163,5832 }, { 164,5832 },
 { 165,5832 }, { 166,5832 }, { 167,5832 }, { 168,5832 }, { 169,5832 },

 { 170,5832 }, { 171,5832 }, { 172,5832 }, { 173,5832 }, { 174,5832 },
 { 175,5832 }, { 176,5832 }, { 177,5832 }, { 178,5832 }, { 179,5832 },
 { 180,5832 }, { 181,5832 }, { 182,5832 }, { 183,5832 }, { 184,5832 },
 { 185,5832 }, { 186,5832 }, { 187,5832 }, { 188,5832 }, { 189,5832 },
 { 190,5832 }, { 191,5832 }, { 192,5832 }, { 193,5832 }, { 194,5832 },
 { 195,5832 }, { 196,5832 }, { 197,5832 }, { 198,5832 }, { 199,5832 },
 { 200,5832 }, { 201,5832 }, { 202,5832 }, { 203,5832 }, { 204,5832 },
 { 205,5832 }, { 206,5832 }, { 207,5832 }, { 208,5832 }, { 209,5832 },
 { 210,5832 }, { 211,5832 }, { 212,5832 }, { 213,5832 }, { 214,5832 },
 { 215,5832 }, { 216,5832 }, { 217,5832 }, { 218,5832 }, { 219,5832 },

 { 220,5832 }, { 221,5832 }, { 222,5832 }, { 223,5832 }, { 224,5832 },
 { 225,5832 }, { 226,5832 }, { 227,5832 }, { 228,5832 }, { 229,5832 },
 { 230,5832 }, { 231,5832 }, { 232,5832 }, { 233,5832 }, { 234,5832 },
 { 235,5832 }, { 236,5832 }, { 237,5832 }, { 238,5832 }, { 239,5832 },
 { 240,5832 }, { 241,5832 }, { 242,5832 }, { 243,5832 }, { 244,5832 },
 { 245,5832 }, { 246,5832 }, { 247,5832 }, { 248,5832 }, { 249,5832 },
 { 250,5832 }, { 251,5832 }, { 252,5832 }, { 253,5832 }, { 254,5832 },
 { 255,5832 }, {   0,  55 }, {   0,21385 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  53 }, {   0,21374 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  56 },
 {   0,21357 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 },
 {  43,   0 }, {  33, -11 }, {  45,   0 }, {  35, -11 }, {  47,   0 },
 {  37, -11 }, {  38, -11 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42, -11 }, {  43, -11 }, {   0,   0 }, {  45, -11 }, {   0,   0 },
 {  47, -11 }, {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60, -11 }, {  61, -11 },
 {  62, -11 }, {  63, -11 }, {  64, -11 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  34 }, {   0,21294 }, {   0,   0 },
 {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94, -11 }, {   0,   0 }, {  96, -11 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 }, {  36,-5810 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 124, -11 }, {   0,   0 }, { 126, -11 },
 {   0,   0 }, {  48,5823 }, {  49,5823 }, {  50,5823 }, {  51,5823 },
 {  52,5823 }, {  53,5823 }, {  54,5823 }, {  55,5823 }, {  56,5823 },
 {  57,5823 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5823 }, {  66,5823 },
 {  67,5823 }, {  68,5823 }, {  69,5823 }, {  70,5823 }, {  71,5823 },

 {  72,5823 }, {  73,5823 }, {  74,5823 }, {  75,5823 }, {  76,5823 },
 {  77,5823 }, {  78,5823 }, {  79,5823 }, {  80,5823 }, {  81,5823 },
 {  82,5823 }, {  83,5823 }, {  84,5823 }, {  85,5823 }, {  86,5823 },
 {  87,5823 }, {  88,5823 }, {  89,5823 }, {  90,5823 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5823 }, {   0,   0 },
 {  97,5823 }, {  98,5823 }, {  99,5823 }, { 100,5823 }, { 101,5823 },
 { 102,5823 }, { 103,5823 }, { 104,5823 }, { 105,5823 }, { 106,5823 },
 { 107,5823 }, { 108,5823 }, { 109,5823 }, { 110,5823 }, { 111,5823 },
 { 112,5823 }, { 113,5823 }, { 114,5823 }, { 115,5823 }, { 116,5823 },
 { 117,5823 }, { 118,5823 }, { 119,5823 }, { 120,5823 }, { 121,5823 },

 { 122,5823 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,5823 }, { 129,5823 }, { 130,5823 }, { 131,5823 },
 { 132,5823 }, { 133,5823 }, { 134,5823 }, { 135,5823 }, { 136,5823 },
 { 137,5823 }, { 138,5823 }, { 139,5823 }, { 140,5823 }, { 141,5823 },
 { 142,5823 }, { 143,5823 }, { 144,5823 }, { 145,5823 }, { 146,5823 },
 { 147,5823 }, { 148,5823 }, { 149,5823 }, { 150,5823 }, { 151,5823 },
 { 152,5823 }, { 153,5823 }, { 154,5823 }, { 155,5823 }, { 156,5823 },
 { 157,5823 }, { 158,5823 }, { 159,5823 }, { 160,5823 }, { 161,5823 },
 { 162,5823 }, { 163,5823 }, { 164,5823 }, { 165,5823 }, { 166,5823 },
 { 167,5823 }, { 168,5823 }, { 169,5823 }, { 170,5823 }, { 171,5823 },

 { 172,5823 }, { 173,5823 }, { 174,5823 }, { 175,5823 }, { 176,5823 },
 { 177,5823 }, { 178,5823 }, { 179,5823 }, { 180,5823 }, { 181,5823 },
 { 182,5823 }, { 183,5823 }, { 184,5823 }, { 185,5823 }, { 186,5823 },
 { 187,5823 }, { 188,5823 }, { 189,5823 }, { 190,5823 }, { 191,5823 },
 { 192,5823 }, { 193,5823 }, { 194,5823 }, { 195,5823 }, { 196,5823 },
 { 197,5823 }, { 198,5823 }, { 199,5823 }, { 200,5823 }, { 201,5823 },
 { 202,5823 }, { 203,5823 }, { 204,5823 }, { 205,5823 }, { 206,5823 },
 { 207,5823 }, { 208,5823 }, { 209,5823 }, { 210,5823 }, { 211,5823 },
 { 212,5823 }, { 213,5823 }, { 214,5823 }, { 215,5823 }, { 216,5823 },
 { 217,5823 }, { 218,5823 }, { 219,5823 }, { 220,5823 }, { 221,5823 },

 { 222,5823 }, { 223,5823 }, { 224,5823 }, { 225,5823 }, { 226,5823 },
 { 227,5823 }, { 228,5823 }, { 229,5823 }, { 230,5823 }, { 231,5823 },
 { 232,5823 }, { 233,5823 }, { 234,5823 }, { 235,5823 }, { 236,5823 },
 { 237,5823 }, { 238,5823 }, { 239,5823 }, { 240,5823 }, { 241,5823 },
 { 242,5823 }, { 243,5823 }, { 244,5823 }, { 245,5823 }, { 246,5823 },
 { 247,5823 }, { 248,5823 }, { 249,5823 }, { 250,5823 }, { 251,5823 },
 { 252,5823 }, { 253,5823 }, { 254,5823 }, { 255,5823 }, {   0,   2 },
 {   0,21037 }, {   1,5823 }, {   2,5823 }, {   3,5823 }, {   4,5823 },
 {   5,5823 }, {   6,5823 }, {   7,5823 }, {   8,5823 }, {   9,5823 },
 {   0,   0 }, {  11,5823 }, {  12,5823 }, {   0,   0 }, {  14,5823 },

 {  15,5823 }, {  16,5823 }, {  17,5823 }, {  18,5823 }, {  19,5823 },
 {  20,5823 }, {  21,5823 }, {  22,5823 }, {  23,5823 }, {  24,5823 },
 {  25,5823 }, {  26,5823 }, {  27,5823 }, {  28,5823 }, {  29,5823 },
 {  30,5823 }, {  31,5823 }, {  32,5823 }, {  33,6081 }, {  34,5823 },
 {  35,6081 }, {  36,5823 }, {  37,6081 }, {  38,6081 }, {  39,5823 },
 {  40,5823 }, {  41,5823 }, {  42,6081 }, {  43,6081 }, {  44,5823 },
 {  45,6081 }, {  46,5823 }, {  47,6081 }, {  48,5823 }, {  49,5823 },
 {  50,5823 }, {  51,5823 }, {  52,5823 }, {  53,5823 }, {  54,5823 },
 {  55,5823 }, {  56,5823 }, {  57,5823 }, {  58,5823 }, {  59,5823 },
 {  60,6081 }, {  61,6081 }, {  62,6081 }, {  63,6081 }, {  64,6081 },

 {  65,5823 }, {  66,5823 }, {  67,5823 }, {  68,5823 }, {  69,5823 },
 {  70,5823 }, {  71,5823 }, {  72,5823 }, {  73,5823 }, {  74,5823 },
 {  75,5823 }, {  76,5823 }, {  77,5823 }, {  78,5823 }, {  79,5823 },
 {  80,5823 }, {  81,5823 }, {  82,5823 }, {  83,5823 }, {  84,5823 },
 {  85,5823 }, {  86,5823 }, {  87,5823 }, {  88,5823 }, {  89,5823 },
 {  90,5823 }, {  91,5823 }, {  92,5823 }, {  93,5823 }, {  94,6081 },
 {  95,5823 }, {  96,6081 }, {  97,5823 }, {  98,5823 }, {  99,5823 },
 { 100,5823 }, { 101,5823 }, { 102,5823 }, { 103,5823 }, { 104,5823 },
 { 105,5823 }, { 106,5823 }, { 107,5823 }, { 108,5823 }, { 109,5823 },
 { 110,5823 }, { 111,5823 }, { 112,5823 }, { 113,5823 }, { 114,5823 },

 { 115,5823 }, { 116,5823 }, { 117,5823 }, { 118,5823 }, { 119,5823 },
 { 120,5823 }, { 121,5823 }, { 122,5823 }, { 123,5823 }, { 124,6081 },
 { 125,5823 }, { 126,6081 }, { 127,5823 }, { 128,5823 }, { 129,5823 },
 { 130,5823 }, { 131,5823 }, { 132,5823 }, { 133,5823 }, { 134,5823 },
 { 135,5823 }, { 136,5823 }, { 137,5823 }, { 138,5823 }, { 139,5823 },
 { 140,5823 }, { 141,5823 }, { 142,5823 }, { 143,5823 }, { 144,5823 },
 { 145,5823 }, { 146,5823 }, { 147,5823 }, { 148,5823 }, { 149,5823 },
 { 150,5823 }, { 151,5823 }, { 152,5823 }, { 153,5823 }, { 154,5823 },
 { 155,5823 }, { 156,5823 }, { 157,5823 }, { 158,5823 }, { 159,5823 },
 { 160,5823 }, { 161,5823 }, { 162,5823 }, { 163,5823 }, { 164,5823 },

 { 165,5823 }, { 166,5823 }, { 167,5823 }, { 168,5823 }, { 169,5823 },
 { 170,5823 }, { 171,5823 }, { 172,5823 }, { 173,5823 }, { 174,5823 },
 { 175,5823 }, { 176,5823 }, { 177,5823 }, { 178,5823 }, { 179,5823 },
 { 180,5823 }, { 181,5823 }, { 182,5823 }, { 183,5823 }, { 184,5823 },
 { 185,5823 }, { 186,5823 }, { 187,5823 }, { 188,5823 }, { 189,5823 },
 { 190,5823 }, { 191,5823 }, { 192,5823 }, { 193,5823 }, { 194,5823 },
 { 195,5823 }, { 196,5823 }, { 197,5823 }, { 198,5823 }, { 199,5823 },
 { 200,5823 }, { 201,5823 }, { 202,5823 }, { 203,5823 }, { 204,5823 },
 { 205,5823 }, { 206,5823 }, { 207,5823 }, { 208,5823 }, { 209,5823 },
 { 210,5823 }, { 211,5823 }, { 212,5823 }, { 213,5823 }, { 214,5823 },

 { 215,5823 }, { 216,5823 }, { 217,5823 }, { 218,5823 }, { 219,5823 },
 { 220,5823 }, { 221,5823 }, { 222,5823 }, { 223,5823 }, { 224,5823 },
 { 225,5823 }, { 226,5823 }, { 227,5823 }, { 228,5823 }, { 229,5823 },
 { 230,5823 }, { 231,5823 }, { 232,5823 }, { 233,5823 }, { 234,5823 },
 { 235,5823 }, { 236,5823 }, { 237,5823 }, { 238,5823 }, { 239,5823 },
 { 240,5823 }, { 241,5823 }, { 242,5823 }, { 243,5823 }, { 244,5823 },
 { 245,5823 }, { 246,5823 }, { 247,5823 }, { 248,5823 }, { 249,5823 },
 { 250,5823 }, { 251,5823 }, { 252,5823 }, { 253,5823 }, { 254,5823 },
 { 255,5823 }, { 256,5823 }, {   0,  64 }, {   0,20779 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,6081 }, {  49,6081 }, {  50,6081 }, {  51,6081 },
 {  52,6081 }, {  53,6081 }, {  54,6081 }, {  55,6081 }, {  56,6081 },

 {  57,6081 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6338 }, {  66,6338 },
 {  67,6338 }, {  68,6338 }, {  69,6595 }, {  70,6338 }, {  71,6338 },
 {  72,6338 }, {  73,6338 }, {  74,6338 }, {  75,6338 }, {  76,6338 },
 {  77,6338 }, {  78,6338 }, {  79,6338 }, {  80,6338 }, {  81,6338 },
 {  82,6338 }, {  83,6338 }, {  84,6338 }, {  85,6338 }, {  86,6338 },
 {  87,6338 }, {  88,6338 }, {  89,6338 }, {  90,6338 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6852 }, {   0,   0 },
 {  97,6338 }, {  98,6338 }, {  99,6338 }, { 100,6338 }, { 101,6595 },
 { 102,6338 }, { 103,6338 }, { 104,6338 }, { 105,6338 }, { 106,6338 },

 { 107,6338 }, { 108,6338 }, { 109,6338 }, { 110,6338 }, { 111,6338 },
 { 112,6338 }, { 113,6338 }, { 114,6338 }, { 115,6338 }, { 116,6338 },
 { 117,6338 }, { 118,6338 }, { 119,6338 }, { 120,6338 }, { 121,6338 },
 { 122,6338 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,6338 }, { 129,6338 }, { 130,6338 }, { 131,6338 },
 { 132,6338 }, { 133,6338 }, { 134,6338 }, { 135,6338 }, { 136,6338 },
 { 137,6338 }, { 138,6338 }, { 139,6338 }, { 140,6338 }, { 141,6338 },
 { 142,6338 }, { 143,6338 }, { 144,6338 }, { 145,6338 }, { 146,6338 },
 { 147,6338 }, { 148,6338 }, { 149,6338 }, { 150,6338 }, { 151,6338 },
 { 152,6338 }, { 153,6338 }, { 154,6338 }, { 155,6338 }, { 156,6338 },

 { 157,6338 }, { 158,6338 }, { 159,6338 }, { 160,6338 }, { 161,6338 },
 { 162,6338 }, { 163,6338 }, { 164,6338 }, { 165,6338 }, { 166,6338 },
 { 167,6338 }, { 168,6338 }, { 169,6338 }, { 170,6338 }, { 171,6338 },
 { 172,6338 }, { 173,6338 }, { 174,6338 }, { 175,6338 }, { 176,6338 },
 { 177,6338 }, { 178,6338 }, { 179,6338 }, { 180,6338 }, { 181,6338 },
 { 182,6338 }, { 183,6338 }, { 184,6338 }, { 185,6338 }, { 186,6338 },
 { 187,6338 }, { 188,6338 }, { 189,6338 }, { 190,6338 }, { 191,6338 },
 { 192,6338 }, { 193,6338 }, { 194,6338 }, { 195,6338 }, { 196,6338 },
 { 197,6338 }, { 198,6338 }, { 199,6338 }, { 200,6338 }, { 201,6338 },
 { 202,6338 }, { 203,6338 }, { 204,6338 }, { 205,6338 }, { 206,6338 },

 { 207,6338 }, { 208,6338 }, { 209,6338 }, { 210,6338 }, { 211,6338 },
 { 212,6338 }, { 213,6338 }, { 214,6338 }, { 215,6338 }, { 216,6338 },
 { 217,6338 }, { 218,6338 }, { 219,6338 }, { 220,6338 }, { 221,6338 },
 { 222,6338 }, { 223,6338 }, { 224,6338 }, { 225,6338 }, { 226,6338 },
 { 227,6338 }, { 228,6338 }, { 229,6338 }, { 230,6338 }, { 231,6338 },
 { 232,6338 }, { 233,6338 }, { 234,6338 }, { 235,6338 }, { 236,6338 },
 { 237,6338 }, { 238,6338 }, { 239,6338 }, { 240,6338 }, { 241,6338 },
 { 242,6338 }, { 243,6338 }, { 244,6338 }, { 245,6338 }, { 246,6338 },
 { 247,6338 }, { 248,6338 }, { 249,6338 }, { 250,6338 }, { 251,6338 },
 { 252,6338 }, { 253,6338 }, { 254,6338 }, { 255,6338 }, {   0,   3 },

 {   0,20522 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  64 }, {   0,20490 }, {  33,6852 }, {   0,   0 },
 {  35,6852 }, {   0,   0 }, {  37,6852 }, {  38,6852 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,6852 }, {  43,6852 }, {   0,   0 },
 {  45,6852 }, {   0,   0 }, {  47,6852 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,6852 }, {  61,6852 }, {  62,6852 }, {  63,6852 }, {  64,6852 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,-6338 }, {   0,   0 },
 {  48,6852 }, {  49,6852 }, {  50,6852 }, {  51,6852 }, {  52,6852 },
 {  53,6852 }, {  54,6852 }, {  55,6852 }, {  56,6852 }, {  57,6852 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,6852 },
 {   0,   0 }, {  96,6852 }, {  65,6049 }, {  66,6049 }, {  67,6049 },

 {  68,6049 }, {  69,6306 }, {  70,6049 }, {  71,6049 }, {  72,6049 },
 {  73,6049 }, {  74,6049 }, {  75,6049 }, {  76,6049 }, {  77,6049 },
 {  78,6049 }, {  79,6049 }, {  80,6049 }, {  81,6049 }, {  82,6049 },
 {  83,6049 }, {  84,6049 }, {  85,6049 }, {  86,6049 }, {  87,6049 },
 {  88,6049 }, {  89,6049 }, {  90,6049 }, {   0,   0 }, { 124,6852 },
 {   0,   0 }, { 126,6852 }, {  95,6049 }, {   0,   0 }, {  97,6049 },
 {  98,6049 }, {  99,6049 }, { 100,6049 }, { 101,6306 }, { 102,6049 },
 { 103,6049 }, { 104,6049 }, { 105,6049 }, { 106,6049 }, { 107,6049 },
 { 108,6049 }, { 109,6049 }, { 110,6049 }, { 111,6049 }, { 112,6049 },
 { 113,6049 }, { 114,6049 }, { 115,6049 }, { 116,6049 }, { 117,6049 },

 { 118,6049 }, { 119,6049 }, { 120,6049 }, { 121,6049 }, { 122,6049 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,6049 }, { 129,6049 }, { 130,6049 }, { 131,6049 }, { 132,6049 },
 { 133,6049 }, { 134,6049 }, { 135,6049 }, { 136,6049 }, { 137,6049 },
 { 138,6049 }, { 139,6049 }, { 140,6049 }, { 141,6049 }, { 142,6049 },
 { 143,6049 }, { 144,6049 }, { 145,6049 }, { 146,6049 }, { 147,6049 },
 { 148,6049 }, { 149,6049 }, { 150,6049 }, { 151,6049 }, { 152,6049 },
 { 153,6049 }, { 154,6049 }, { 155,6049 }, { 156,6049 }, { 157,6049 },
 { 158,6049 }, { 159,6049 }, { 160,6049 }, { 161,6049 }, { 162,6049 },
 { 163,6049 }, { 164,6049 }, { 165,6049 }, { 166,6049 }, { 167,6049 },

 { 168,6049 }, { 169,6049 }, { 170,6049 }, { 171,6049 }, { 172,6049 },
 { 173,6049 }, { 174,6049 }, { 175,6049 }, { 176,6049 }, { 177,6049 },
 { 178,6049 }, { 179,6049 }, { 180,6049 }, { 181,6049 }, { 182,6049 },
 { 183,6049 }, { 184,6049 }, { 185,6049 }, { 186,6049 }, { 187,6049 },
 { 188,6049 }, { 189,6049 }, { 190,6049 }, { 191,6049 }, { 192,6049 },
 { 193,6049 }, { 194,6049 }, { 195,6049 }, { 196,6049 }, { 197,6049 },
 { 198,6049 }, { 199,6049 }, { 200,6049 }, { 201,6049 }, { 202,6049 },
 { 203,6049 }, { 204,6049 }, { 205,6049 }, { 206,6049 }, { 207,6049 },
 { 208,6049 }, { 209,6049 }, { 210,6049 }, { 211,6049 }, { 212,6049 },
 { 213,6049 }, { 214,6049 }, { 215,6049 }, { 216,6049 }, { 217,6049 },

 { 218,6049 }, { 219,6049 }, { 220,6049 }, { 221,6049 }, { 222,6049 },
 { 223,6049 }, { 224,6049 }, { 225,6049 }, { 226,6049 }, { 227,6049 },
 { 228,6049 }, { 229,6049 }, { 230,6049 }, { 231,6049 }, { 232,6049 },
 { 233,6049 }, { 234,6049 }, { 235,6049 }, { 236,6049 }, { 237,6049 },
 { 238,6049 }, { 239,6049 }, { 240,6049 }, { 241,6049 }, { 242,6049 },
 { 243,6049 }, { 244,6049 }, { 245,6049 }, { 246,6049 }, { 247,6049 },
 { 248,6049 }, { 249,6049 }, { 250,6049 }, { 251,6049 }, { 252,6049 },
 { 253,6049 }, { 254,6049 }, { 255,6049 }, {   0,  57 }, {   0,20233 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  46,-257 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 257 },
 {  66, 257 }, {  67, 257 }, {  68, 257 }, {  69, 771 }, {  70, 257 },
 {  71, 257 }, {  72, 257 }, {  73, 257 }, {  74, 257 }, {  75, 257 },
 {  76, 257 }, {  77, 257 }, {  78, 257 }, {  79, 257 }, {  80, 257 },
 {  81, 257 }, {  82, 257 }, {  83, 257 }, {  84, 257 }, {  85, 257 },
 {  86, 257 }, {  87, 257 }, {  88, 257 }, {  89, 257 }, {  90, 257 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,1542 },
 {   0,   0 }, {  97, 257 }, {  98, 257 }, {  99, 257 }, { 100, 257 },
 { 101, 771 }, { 102, 257 }, { 103, 257 }, { 104, 257 }, { 105, 257 },
 { 106, 257 }, { 107, 257 }, { 108, 257 }, { 109, 257 }, { 110, 257 },

 { 111, 257 }, { 112, 257 }, { 113, 257 }, { 114, 257 }, { 115, 257 },
 { 116, 257 }, { 117, 257 }, { 118, 257 }, { 119, 257 }, { 120, 257 },
 { 121, 257 }, { 122, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128, 257 }, { 129, 257 }, { 130, 257 },
 { 131, 257 }, { 132, 257 }, { 133, 257 }, { 134, 257 }, { 135, 257 },
 { 136, 257 }, { 137, 257 }, { 138, 257 }, { 139, 257 }, { 140, 257 },
 { 141, 257 }, { 142, 257 }, { 143, 257 }, { 144, 257 }, { 145, 257 },
 { 146, 257 }, { 147, 257 }, { 148, 257 }, { 149, 257 }, { 150, 257 },
 { 151, 257 }, { 152, 257 }, { 153, 257 }, { 154, 257 }, { 155, 257 },
 { 156, 257 }, { 157, 257 }, { 158, 257 }, { 159, 257 }, { 160, 257 },

 { 161, 257 }, { 162, 257 }, { 163, 257 }, { 164, 257 }, { 165, 257 },
 { 166, 257 }, { 167, 257 }, { 168, 257 }, { 169, 257 }, { 170, 257 },
 { 171, 257 }, { 172, 257 }, { 173, 257 }, { 174, 257 }, { 175, 257 },
 { 176, 257 }, { 177, 257 }, { 178, 257 }, { 179, 257 }, { 180, 257 },
 { 181, 257 }, { 182, 257 }, { 183, 257 }, { 184, 257 }, { 185, 257 },
 { 186, 257 }, { 187, 257 }, { 188, 257 }, { 189, 257 }, { 190, 257 },
 { 191, 257 }, { 192, 257 }, { 193, 257 }, { 194, 257 }, { 195, 257 },
 { 196, 257 }, { 197, 257 }, { 198, 257 }, { 199, 257 }, { 200, 257 },
 { 201, 257 }, { 202, 257 }, { 203, 257 }, { 204, 257 }, { 205, 257 },
 { 206, 257 }, { 207, 257 }, { 208, 257 }, { 209, 257 }, { 210, 257 },

 { 211, 257 }, { 212, 257 }, { 213, 257 }, { 214, 257 }, { 215, 257 },
 { 216, 257 }, { 217, 257 }, { 218, 257 }, { 219, 257 }, { 220, 257 },
 { 221, 257 }, { 222, 257 }, { 223, 257 }, { 224, 257 }, { 225, 257 },
 { 226, 257 }, { 227, 257 }, { 228, 257 }, { 229, 257 }, { 230, 257 },
 { 231, 257 }, { 232, 257 }, { 233, 257 }, { 234, 257 }, { 235, 257 },
 { 236, 257 }, { 237, 257 }, { 238, 257 }, { 239, 257 }, { 240, 257 },
 { 241, 257 }, { 242, 257 }, { 243, 257 }, { 244, 257 }, { 245, 257 },
 { 246, 257 }, { 247, 257 }, { 248, 257 }, { 249, 257 }, { 250, 257 },
 { 251, 257 }, { 252, 257 }, { 253, 257 }, { 254, 257 }, { 255, 257 },
 {   0,  68 }, {   0,19976 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,6595 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6595 },
 {  49,6595 }, {  50,6595 }, {  51,6595 }, {  52,6595 }, {  53,6595 },

 {  54,6595 }, {  55,6595 }, {  56,6595 }, {  57,6595 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6595 }, {  66,6595 }, {  67,6595 }, {  68,6595 },
 {  69,6595 }, {  70,6595 }, {  71,6595 }, {  72,6595 }, {  73,6595 },
 {  74,6595 }, {  75,6595 }, {  76,6595 }, {  77,6595 }, {  78,6595 },
 {  79,6595 }, {  80,6595 }, {  81,6595 }, {  82,6595 }, {  83,6595 },
 {  84,6595 }, {  85,6595 }, {  86,6595 }, {  87,6595 }, {  88,6595 },
 {  89,6595 }, {  90,6595 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,6595 }, {   0,   0 }, {  97,6595 }, {  98,6595 },
 {  99,6595 }, { 100,6595 }, { 101,6595 }, { 102,6595 }, { 103,6595 },

 { 104,6595 }, { 105,6595 }, { 106,6595 }, { 107,6595 }, { 108,6595 },
 { 109,6595 }, { 110,6595 }, { 111,6595 }, { 112,6595 }, { 113,6595 },
 { 114,6595 }, { 115,6595 }, { 116,6595 }, { 117,6595 }, { 118,6595 },
 { 119,6595 }, { 120,6595 }, { 121,6595 }, { 122,6595 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6595 },
 { 129,6595 }, { 130,6595 }, { 131,6595 }, { 132,6595 }, { 133,6595 },
 { 134,6595 }, { 135,6595 }, { 136,6595 }, { 137,6595 }, { 138,6595 },
 { 139,6595 }, { 140,6595 }, { 141,6595 }, { 142,6595 }, { 143,6595 },
 { 144,6595 }, { 145,6595 }, { 146,6595 }, { 147,6595 }, { 148,6595 },
 { 149,6595 }, { 150,6595 }, { 151,6595 }, { 152,6595 }, { 153,6595 },

 { 154,6595 }, { 155,6595 }, { 156,6595 }, { 157,6595 }, { 158,6595 },
 { 159,6595 }, { 160,6595 }, { 161,6595 }, { 162,6595 }, { 163,6595 },
 { 164,6595 }, { 165,6595 }, { 166,6595 }, { 167,6595 }, { 168,6595 },
 { 169,6595 }, { 170,6595 }, { 171,6595 }, { 172,6595 }, { 173,6595 },
 { 174,6595 }, { 175,6595 }, { 176,6595 }, { 177,6595 }, { 178,6595 },
 { 179,6595 }, { 180,6595 }, { 181,6595 }, { 182,6595 }, { 183,6595 },
 { 184,6595 }, { 185,6595 }, { 186,6595 }, { 187,6595 }, { 188,6595 },
 { 189,6595 }, { 190,6595 }, { 191,6595 }, { 192,6595 }, { 193,6595 },
 { 194,6595 }, { 195,6595 }, { 196,6595 }, { 197,6595 }, { 198,6595 },
 { 199,6595 }, { 200,6595 }, { 201,6595 }, { 202,6595 }, { 203,6595 },

 { 204,6595 }, { 205,6595 }, { 206,6595 }, { 207,6595 }, { 208,6595 },
 { 209,6595 }, { 210,6595 }, { 211,6595 }, { 212,6595 }, { 213,6595 },
 { 214,6595 }, { 215,6595 }, { 216,6595 }, { 217,6595 }, { 218,6595 },
 { 219,6595 }, { 220,6595 }, { 221,6595 }, { 222,6595 }, { 223,6595 },
 { 224,6595 }, { 225,6595 }, { 226,6595 }, { 227,6595 }, { 228,6595 },
 { 229,6595 }, { 230,6595 }, { 231,6595 }, { 232,6595 }, { 233,6595 },
 { 234,6595 }, { 235,6595 }, { 236,6595 }, { 237,6595 }, { 238,6595 },
 { 239,6595 }, { 240,6595 }, { 241,6595 }, { 242,6595 }, { 243,6595 },
 { 244,6595 }, { 245,6595 }, { 246,6595 }, { 247,6595 }, { 248,6595 },
 { 249,6595 }, { 250,6595 }, { 251,6595 }, { 252,6595 }, { 253,6595 },

 { 254,6595 }, { 255,6595 }, {   0,  63 }, {   0,19719 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,6338 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  48,6595 }, {  49,6595 }, {  50,6338 }, {  51,6338 },
 {  52,6338 }, {  53,6338 }, {  54,6338 }, {  55,6338 }, {  56,6338 },
 {  57,6338 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6338 }, {  66,6338 },
 {  67,6338 }, {  68,6338 }, {  69,6338 }, {  70,6338 }, {  71,6338 },
 {  72,6338 }, {  73,6338 }, {  74,6338 }, {  75,6338 }, {  76,6338 },
 {  77,6338 }, {  78,6338 }, {  79,6338 }, {  80,6338 }, {  81,6338 },
 {  82,6338 }, {  83,6338 }, {  84,6338 }, {  85,6338 }, {  86,6338 },
 {  87,6338 }, {  88,6338 }, {  89,6338 }, {  90,6338 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6852 }, {   0,   0 },

 {  97,6338 }, {  98,6338 }, {  99,6338 }, { 100,6338 }, { 101,6338 },
 { 102,6338 }, { 103,6338 }, { 104,6338 }, { 105,6338 }, { 106,6338 },
 { 107,6338 }, { 108,6338 }, { 109,6338 }, { 110,6338 }, { 111,6338 },
 { 112,6338 }, { 113,6338 }, { 114,6338 }, { 115,6338 }, { 116,6338 },
 { 117,6338 }, { 118,6338 }, { 119,6338 }, { 120,6338 }, { 121,6338 },
 { 122,6338 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,6338 }, { 129,6338 }, { 130,6338 }, { 131,6338 },
 { 132,6338 }, { 133,6338 }, { 134,6338 }, { 135,6338 }, { 136,6338 },
 { 137,6338 }, { 138,6338 }, { 139,6338 }, { 140,6338 }, { 141,6338 },
 { 142,6338 }, { 143,6338 }, { 144,6338 }, { 145,6338 }, { 146,6338 },

 { 147,6338 }, { 148,6338 }, { 149,6338 }, { 150,6338 }, { 151,6338 },
 { 152,6338 }, { 153,6338 }, { 154,6338 }, { 155,6338 }, { 156,6338 },
 { 157,6338 }, { 158,6338 }, { 159,6338 }, { 160,6338 }, { 161,6338 },
 { 162,6338 }, { 163,6338 }, { 164,6338 }, { 165,6338 }, { 166,6338 },
 { 167,6338 }, { 168,6338 }, { 169,6338 }, { 170,6338 }, { 171,6338 },
 { 172,6338 }, { 173,6338 }, { 174,6338 }, { 175,6338 }, { 176,6338 },
 { 177,6338 }, { 178,6338 }, { 179,6338 }, { 180,6338 }, { 181,6338 },
 { 182,6338 }, { 183,6338 }, { 184,6338 }, { 185,6338 }, { 186,6338 },
 { 187,6338 }, { 188,6338 }, { 189,6338 }, { 190,6338 }, { 191,6338 },
 { 192,6338 }, { 193,6338 }, { 194,6338 }, { 195,6338 }, { 196,6338 },

 { 197,6338 }, { 198,6338 }, { 199,6338 }, { 200,6338 }, { 201,6338 },
 { 202,6338 }, { 203,6338 }, { 204,6338 }, { 205,6338 }, { 206,6338 },
 { 207,6338 }, { 208,6338 }, { 209,6338 }, { 210,6338 }, { 211,6338 },
 { 212,6338 }, { 213,6338 }, { 214,6338 }, { 215,6338 }, { 216,6338 },
 { 217,6338 }, { 218,6338 }, { 219,6338 }, { 220,6338 }, { 221,6338 },
 { 222,6338 }, { 223,6338 }, { 224,6338 }, { 225,6338 }, { 226,6338 },
 { 227,6338 }, { 228,6338 }, { 229,6338 }, { 230,6338 }, { 231,6338 },
 { 232,6338 }, { 233,6338 }, { 234,6338 }, { 235,6338 }, { 236,6338 },
 { 237,6338 }, { 238,6338 }, { 239,6338 }, { 240,6338 }, { 241,6338 },
 { 242,6338 }, { 243,6338 }, { 244,6338 }, { 245,6338 }, { 246,6338 },

 { 247,6338 }, { 248,6338 }, { 249,6338 }, { 250,6338 }, { 251,6338 },
 { 252,6338 }, { 253,6338 }, { 254,6338 }, { 255,6338 }, {   0,  68 },
 {   0,19462 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,6081 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  43,6852 }, {   0,   0 },
 {  45,6852 }, {   0,   0 }, {   0,   0 }, {  48,6862 }, {  49,6862 },
 {  50,6862 }, {  51,6862 }, {  52,6862 }, {  53,6862 }, {  54,6862 },
 {  55,6862 }, {  56,6862 }, {  57,6862 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,6081 }, {  66,6081 }, {  67,6081 }, {  68,6081 }, {  69,6081 },
 {  70,6081 }, {  71,6081 }, {  72,6081 }, {  73,6081 }, {  74,6081 },
 {  75,6081 }, {  76,6081 }, {  77,6081 }, {  78,6081 }, {  79,6081 },
 {  80,6081 }, {  81,6081 }, {  82,6081 }, {  83,6081 }, {  84,6081 },
 {  85,6081 }, {  86,6081 }, {  87,6081 }, {  88,6081 }, {  89,6081 },

 {  90,6081 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,6081 }, {   0,   0 }, {  97,6081 }, {  98,6081 }, {  99,6081 },
 { 100,6081 }, { 101,6081 }, { 102,6081 }, { 103,6081 }, { 104,6081 },
 { 105,6081 }, { 106,6081 }, { 107,6081 }, { 108,6081 }, { 109,6081 },
 { 110,6081 }, { 111,6081 }, { 112,6081 }, { 113,6081 }, { 114,6081 },
 { 115,6081 }, { 116,6081 }, { 117,6081 }, { 118,6081 }, { 119,6081 },
 { 120,6081 }, { 121,6081 }, { 122,6081 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6081 }, { 129,6081 },
 { 130,6081 }, { 131,6081 }, { 132,6081 }, { 133,6081 }, { 134,6081 },
 { 135,6081 }, { 136,6081 }, { 137,6081 }, { 138,6081 }, { 139,6081 },

 { 140,6081 }, { 141,6081 }, { 142,6081 }, { 143,6081 }, { 144,6081 },
 { 145,6081 }, { 146,6081 }, { 147,6081 }, { 148,6081 }, { 149,6081 },
 { 150,6081 }, { 151,6081 }, { 152,6081 }, { 153,6081 }, { 154,6081 },
 { 155,6081 }, { 156,6081 }, { 157,6081 }, { 158,6081 }, { 159,6081 },
 { 160,6081 }, { 161,6081 }, { 162,6081 }, { 163,6081 }, { 164,6081 },
 { 165,6081 }, { 166,6081 }, { 167,6081 }, { 168,6081 }, { 169,6081 },
 { 170,6081 }, { 171,6081 }, { 172,6081 }, { 173,6081 }, { 174,6081 },
 { 175,6081 }, { 176,6081 }, { 177,6081 }, { 178,6081 }, { 179,6081 },
 { 180,6081 }, { 181,6081 }, { 182,6081 }, { 183,6081 }, { 184,6081 },
 { 185,6081 }, { 186,6081 }, { 187,6081 }, { 188,6081 }, { 189,6081 },

 { 190,6081 }, { 191,6081 }, { 192,6081 }, { 193,6081 }, { 194,6081 },
 { 195,6081 }, { 196,6081 }, { 197,6081 }, { 198,6081 }, { 199,6081 },
 { 200,6081 }, { 201,6081 }, { 202,6081 }, { 203,6081 }, { 204,6081 },
 { 205,6081 }, { 206,6081 }, { 207,6081 }, { 208,6081 }, { 209,6081 },
 { 210,6081 }, { 211,6081 }, { 212,6081 }, { 213,6081 }, { 214,6081 },
 { 215,6081 }, { 216,6081 }, { 217,6081 }, { 218,6081 }, { 219,6081 },
 { 220,6081 }, { 221,6081 }, { 222,6081 }, { 223,6081 }, { 224,6081 },
 { 225,6081 }, { 226,6081 }, { 227,6081 }, { 228,6081 }, { 229,6081 },
 { 230,6081 }, { 231,6081 }, { 232,6081 }, { 233,6081 }, { 234,6081 },
 { 235,6081 }, { 236,6081 }, { 237,6081 }, { 238,6081 }, { 239,6081 },

 { 240,6081 }, { 241,6081 }, { 242,6081 }, { 243,6081 }, { 244,6081 },
 { 245,6081 }, { 246,6081 }, { 247,6081 }, { 248,6081 }, { 249,6081 },
 { 250,6081 }, { 251,6081 }, { 252,6081 }, { 253,6081 }, { 254,6081 },
 { 255,6081 }, {   0,  62 }, {   0,19205 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5824 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,6862 }, {  49,6862 }, {  50,6862 }, {  51,6862 }, {  52,6862 },
 {  53,6862 }, {  54,6862 }, {  55,6862 }, {  56,5824 }, {  57,5824 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5824 }, {  66,5824 }, {  67,5824 },
 {  68,5824 }, {  69,5824 }, {  70,5824 }, {  71,5824 }, {  72,5824 },
 {  73,5824 }, {  74,5824 }, {  75,5824 }, {  76,5824 }, {  77,5824 },
 {  78,5824 }, {  79,5824 }, {  80,5824 }, {  81,5824 }, {  82,5824 },

 {  83,5824 }, {  84,5824 }, {  85,5824 }, {  86,5824 }, {  87,5824 },
 {  88,5824 }, {  89,5824 }, {  90,5824 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,7119 }, {   0,   0 }, {  97,5824 },
 {  98,5824 }, {  99,5824 }, { 100,5824 }, { 101,5824 }, { 102,5824 },
 { 103,5824 }, { 104,5824 }, { 105,5824 }, { 106,5824 }, { 107,5824 },
 { 108,5824 }, { 109,5824 }, { 110,5824 }, { 111,5824 }, { 112,5824 },
 { 113,5824 }, { 114,5824 }, { 115,5824 }, { 116,5824 }, { 117,5824 },
 { 118,5824 }, { 119,5824 }, { 120,5824 }, { 121,5824 }, { 122,5824 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5824 }, { 129,5824 }, { 130,5824 }, { 131,5824 }, { 132,5824 },

 { 133,5824 }, { 134,5824 }, { 135,5824 }, { 136,5824 }, { 137,5824 },
 { 138,5824 }, { 139,5824 }, { 140,5824 }, { 141,5824 }, { 142,5824 },
 { 143,5824 }, { 144,5824 }, { 145,5824 }, { 146,5824 }, { 147,5824 },
 { 148,5824 }, { 149,5824 }, { 150,5824 }, { 151,5824 }, { 152,5824 },
 { 153,5824 }, { 154,5824 }, { 155,5824 }, { 156,5824 }, { 157,5824 },
 { 158,5824 }, { 159,5824 }, { 160,5824 }, { 161,5824 }, { 162,5824 },
 { 163,5824 }, { 164,5824 }, { 165,5824 }, { 166,5824 }, { 167,5824 },
 { 168,5824 }, { 169,5824 }, { 170,5824 }, { 171,5824 }, { 172,5824 },
 { 173,5824 }, { 174,5824 }, { 175,5824 }, { 176,5824 }, { 177,5824 },
 { 178,5824 }, { 179,5824 }, { 180,5824 }, { 181,5824 }, { 182,5824 },

 { 183,5824 }, { 184,5824 }, { 185,5824 }, { 186,5824 }, { 187,5824 },
 { 188,5824 }, { 189,5824 }, { 190,5824 }, { 191,5824 }, { 192,5824 },
 { 193,5824 }, { 194,5824 }, { 195,5824 }, { 196,5824 }, { 197,5824 },
 { 198,5824 }, { 199,5824 }, { 200,5824 }, { 201,5824 }, { 202,5824 },
 { 203,5824 }, { 204,5824 }, { 205,5824 }, { 206,5824 }, { 207,5824 },
 { 208,5824 }, { 209,5824 }, { 210,5824 }, { 211,5824 }, { 212,5824 },
 { 213,5824 }, { 214,5824 }, { 215,5824 }, { 216,5824 }, { 217,5824 },
 { 218,5824 }, { 219,5824 }, { 220,5824 }, { 221,5824 }, { 222,5824 },
 { 223,5824 }, { 224,5824 }, { 225,5824 }, { 226,5824 }, { 227,5824 },
 { 228,5824 }, { 229,5824 }, { 230,5824 }, { 231,5824 }, { 232,5824 },

 { 233,5824 }, { 234,5824 }, { 235,5824 }, { 236,5824 }, { 237,5824 },
 { 238,5824 }, { 239,5824 }, { 240,5824 }, { 241,5824 }, { 242,5824 },
 { 243,5824 }, { 244,5824 }, { 245,5824 }, { 246,5824 }, { 247,5824 },
 { 248,5824 }, { 249,5824 }, { 250,5824 }, { 251,5824 }, { 252,5824 },
 { 253,5824 }, { 254,5824 }, { 255,5824 }, {   0,  61 }, {   0,18948 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,5567 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,7119 }, {  49,7119 }, {  50,7119 },
 {  51,7119 }, {  52,7119 }, {  53,7119 }, {  54,7119 }, {  55,7119 },
 {  56,7119 }, {  57,7119 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,7119 },
 {  66,7119 }, {  67,7119 }, {  68,7119 }, {  69,7119 }, {  70,7119 },
 {  71,5567 }, {  72,5567 }, {  73,5567 }, {  74,5567 }, {  75,5567 },

 {  76,5567 }, {  77,5567 }, {  78,5567 }, {  79,5567 }, {  80,5567 },
 {  81,5567 }, {  82,5567 }, {  83,5567 }, {  84,5567 }, {  85,5567 },
 {  86,5567 }, {  87,5567 }, {  88,5567 }, {  89,5567 }, {  90,5567 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,7376 },
 {   0,   0 }, {  97,7119 }, {  98,7119 }, {  99,7119 }, { 100,7119 },
 { 101,7119 }, { 102,7119 }, { 103,5567 }, { 104,5567 }, { 105,5567 },
 { 106,5567 }, { 107,5567 }, { 108,5567 }, { 109,5567 }, { 110,5567 },
 { 111,5567 }, { 112,5567 }, { 113,5567 }, { 114,5567 }, { 115,5567 },
 { 116,5567 }, { 117,5567 }, { 118,5567 }, { 119,5567 }, { 120,5567 },
 { 121,5567 }, { 122,5567 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,5567 }, { 129,5567 }, { 130,5567 },
 { 131,5567 }, { 132,5567 }, { 133,5567 }, { 134,5567 }, { 135,5567 },
 { 136,5567 }, { 137,5567 }, { 138,5567 }, { 139,5567 }, { 140,5567 },
 { 141,5567 }, { 142,5567 }, { 143,5567 }, { 144,5567 }, { 145,5567 },
 { 146,5567 }, { 147,5567 }, { 148,5567 }, { 149,5567 }, { 150,5567 },
 { 151,5567 }, { 152,5567 }, { 153,5567 }, { 154,5567 }, { 155,5567 },
 { 156,5567 }, { 157,5567 }, { 158,5567 }, { 159,5567 }, { 160,5567 },
 { 161,5567 }, { 162,5567 }, { 163,5567 }, { 164,5567 }, { 165,5567 },
 { 166,5567 }, { 167,5567 }, { 168,5567 }, { 169,5567 }, { 170,5567 },
 { 171,5567 }, { 172,5567 }, { 173,5567 }, { 174,5567 }, { 175,5567 },

 { 176,5567 }, { 177,5567 }, { 178,5567 }, { 179,5567 }, { 180,5567 },
 { 181,5567 }, { 182,5567 }, { 183,5567 }, { 184,5567 }, { 185,5567 },
 { 186,5567 }, { 187,5567 }, { 188,5567 }, { 189,5567 }, { 190,5567 },
 { 191,5567 }, { 192,5567 }, { 193,5567 }, { 194,5567 }, { 195,5567 },
 { 196,5567 }, { 197,5567 }, { 198,5567 }, { 199,5567 }, { 200,5567 },
 { 201,5567 }, { 202,5567 }, { 203,5567 }, { 204,5567 }, { 205,5567 },
 { 206,5567 }, { 207,5567 }, { 208,5567 }, { 209,5567 }, { 210,5567 },
 { 211,5567 }, { 212,5567 }, { 213,5567 }, { 214,5567 }, { 215,5567 },
 { 216,5567 }, { 217,5567 }, { 218,5567 }, { 219,5567 }, { 220,5567 },
 { 221,5567 }, { 222,5567 }, { 223,5567 }, { 224,5567 }, { 225,5567 },

 { 226,5567 }, { 227,5567 }, { 228,5567 }, { 229,5567 }, { 230,5567 },
 { 231,5567 }, { 232,5567 }, { 233,5567 }, { 234,5567 }, { 235,5567 },
 { 236,5567 }, { 237,5567 }, { 238,5567 }, { 239,5567 }, { 240,5567 },
 { 241,5567 }, { 242,5567 }, { 243,5567 }, { 244,5567 }, { 245,5567 },
 { 246,5567 }, { 247,5567 }, { 248,5567 }, { 249,5567 }, { 250,5567 },
 { 251,5567 }, { 252,5567 }, { 253,5567 }, { 254,5567 }, { 255,5567 },
 {   0,  68 }, {   0,18691 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,5310 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,7376 },
 {  49,7376 }, {  50,7376 }, {  51,7376 }, {  52,7376 }, {  53,7376 },
 {  54,7376 }, {  55,7376 }, {  56,7376 }, {  57,7376 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,5310 }, {  66,5310 }, {  67,5310 }, {  68,5310 },

 {  69,5310 }, {  70,5310 }, {  71,5310 }, {  72,5310 }, {  73,5310 },
 {  74,5310 }, {  75,5310 }, {  76,5310 }, {  77,5310 }, {  78,5310 },
 {  79,5310 }, {  80,5310 }, {  81,5310 }, {  82,5310 }, {  83,5310 },
 {  84,5310 }, {  85,5310 }, {  86,5310 }, {  87,5310 }, {  88,5310 },
 {  89,5310 }, {  90,5310 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,5310 }, {   0,   0 }, {  97,5310 }, {  98,5310 },
 {  99,5310 }, { 100,5310 }, { 101,5310 }, { 102,5310 }, { 103,5310 },
 { 104,5310 }, { 105,5310 }, { 106,5310 }, { 107,5310 }, { 108,5310 },
 { 109,5310 }, { 110,5310 }, { 111,5310 }, { 112,5310 }, { 113,5310 },
 { 114,5310 }, { 115,5310 }, { 116,5310 }, { 117,5310 }, { 118,5310 },

 { 119,5310 }, { 120,5310 }, { 121,5310 }, { 122,5310 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5310 },
 { 129,5310 }, { 130,5310 }, { 131,5310 }, { 132,5310 }, { 133,5310 },
 { 134,5310 }, { 135,5310 }, { 136,5310 }, { 137,5310 }, { 138,5310 },
 { 139,5310 }, { 140,5310 }, { 141,5310 }, { 142,5310 }, { 143,5310 },
 { 144,5310 }, { 145,5310 }, { 146,5310 }, { 147,5310 }, { 148,5310 },
 { 149,5310 }, { 150,5310 }, { 151,5310 }, { 152,5310 }, { 153,5310 },
 { 154,5310 }, { 155,5310 }, { 156,5310 }, { 157,5310 }, { 158,5310 },
 { 159,5310 }, { 160,5310 }, { 161,5310 }, { 162,5310 }, { 163,5310 },
 { 164,5310 }, { 165,5310 }, { 166,5310 }, { 167,5310 }, { 168,5310 },

 { 169,5310 }, { 170,5310 }, { 171,5310 }, { 172,5310 }, { 173,5310 },
 { 174,5310 }, { 175,5310 }, { 176,5310 }, { 177,5310 }, { 178,5310 },
 { 179,5310 }, { 180,5310 }, { 181,5310 }, { 182,5310 }, { 183,5310 },
 { 184,5310 }, { 185,5310 }, { 186,5310 }, { 187,5310 }, { 188,5310 },
 { 189,5310 }, { 190,5310 }, { 191,5310 }, { 192,5310 }, { 193,5310 },
 { 194,5310 }, { 195,5310 }, { 196,5310 }, { 197,5310 }, { 198,5310 },
 { 199,5310 }, { 200,5310 }, { 201,5310 }, { 202,5310 }, { 203,5310 },
 { 204,5310 }, { 205,5310 }, { 206,5310 }, { 207,5310 }, { 208,5310 },
 { 209,5310 }, { 210,5310 }, { 211,5310 }, { 212,5310 }, { 213,5310 },
 { 214,5310 }, { 215,5310 }, { 216,5310 }, { 217,5310 }, { 218,5310 },

 { 219,5310 }, { 220,5310 }, { 221,5310 }, { 222,5310 }, { 223,5310 },
 { 224,5310 }, { 225,5310 }, { 226,5310 }, { 227,5310 }, { 228,5310 },
 { 229,5310 }, { 230,5310 }, { 231,5310 }, { 232,5310 }, { 233,5310 },
 { 234,5310 }, { 235,5310 }, { 236,5310 }, { 237,5310 }, { 238,5310 },
 { 239,5310 }, { 240,5310 }, { 241,5310 }, { 242,5310 }, { 243,5310 },
 { 244,5310 }, { 245,5310 }, { 246,5310 }, { 247,5310 }, { 248,5310 },
 { 249,5310 }, { 250,5310 }, { 251,5310 }, { 252,5310 }, { 253,5310 },
 { 254,5310 }, { 255,5310 }, {   0,  50 }, {   0,18434 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  52 }, {   0,18423 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  33,-2951 }, {   0,   0 }, {  35,-2951 }, {   0,   0 },
 {  37,-2951 }, {  38,-2951 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,-2951 }, {  43,-2951 }, {  33,-2962 }, {  45,-2951 }, {  35,-2962 },
 {  47,-2951 }, {  37,-2962 }, {  38,-2962 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,-2962 }, {  43,-2962 }, {   0,   0 }, {  45,-2962 },
 {   0,   0 }, {  47,-2962 }, {   0,   0 }, {  60,-2951 }, {  61,-2951 },

 {  62,-2951 }, {  63,-2951 }, {  64,-2951 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,-2962 },
 {  61,-2962 }, {  62,-2962 }, {  63,-2962 }, {  64,-2962 }, {   0,   0 },
 {   0,  49 }, {   0,18356 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,-2951 }, {   0,   0 }, {  96,-2951 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-2962 }, {   0,   0 },
 {  96,-2962 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-3029 },

 {   0,   0 }, {  35,-3029 }, {   0,   0 }, {  37,-3029 }, {  38,-3029 },
 {   0,  51 }, {   0,18316 }, {   0,   0 }, {  42,-3029 }, {  43,-3029 },
 {   0,   0 }, {  45,-3029 }, { 124,-2951 }, {  47,-3029 }, { 126,-2951 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,-2962 }, {   0,   0 },
 { 126,-2962 }, {  60,-3029 }, {  61,-3029 }, {  62,-3029 }, {  63,-3029 },
 {  64,-3029 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,-3069 },
 {   0,   0 }, {  35,-3069 }, {   0,   0 }, {  37,-3069 }, {  38,-3069 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-3069 }, {  43,-3069 },

 {   0,   0 }, {  45,-3069 }, {   0,   0 }, {  47,-3069 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,-3029 }, {   0,   0 }, {  96,-3029 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,-3069 }, {  61,-3069 }, {  62,-3069 }, {  63,-3069 },
 {  64,-3069 }, {   0,  71 }, {   0,18250 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,-3029 }, {   0,   0 }, { 126,-3029 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  94,-3069 }, {   0,   0 }, {  96,-3069 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 { 124,-3069 }, {   0,   0 }, { 126,-3069 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },

 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },

 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },

 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  11 }, {   0,17993 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },

 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },

 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },

 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },

 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },

 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,   6 }, {   0,17735 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },

 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {   0,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,   4 },
 {   0,17477 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,6419 }, {   0,   0 },
 {  35,6419 }, {   0,   0 }, {  37,6419 }, {  38,6419 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,6419 }, {  43,6419 }, {   0,   0 },
 {  45,6419 }, {   0,   0 }, {  47,6419 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,6419 }, {  61,6419 }, {  62,6419 }, {  63,6419 }, {  64,6419 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,6419 },
 {   0,   0 }, {  96,6419 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,6419 },
 {   0,   0 }, { 126,6419 }, {   0,  44 }, {   0,17349 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },

 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },

 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },

 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },

 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },

 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  10 }, {   0,17091 }, {   1,   0 }, {   2,   0 }, {   3,   0 },
 {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 },
 {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 },
 {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 },

 {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 },
 {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 },
 {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 },
 {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 },
 {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 },
 {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 },
 {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },

 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 },
 {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },

 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 },
 { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },

 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },

 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  22 }, {   0,16833 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },

 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },

 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },

 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },

 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },

 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  19 }, {   0,16575 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,  19 }, {   0,16570 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   9,   0 }, {  10,   5 }, {  11,   0 }, {  12,   0 },
 {  13,   5 }, {   9,  24 }, {  10,  24 }, {  11,  24 }, {  12,  24 },
 {  13,  24 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  19 }, {   0,16546 }, {   0,   0 }, {   0,   0 }, {  32,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,  24 },
 {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 },
 {   0,   0 }, {  39,-10264 }, {  45,-10261 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  45,-10266 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  32,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  39,-10288 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  45,-10290 }, {   0,  23 }, {   0,16499 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },

 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },

 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {   0,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },

 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },

 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },

 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  30 }, {   0,16241 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,16233 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0,16210 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5185 },
 {  49,5185 }, {  50,5185 }, {  51,5185 }, {  52,5185 }, {  53,5185 },
 {  54,5185 }, {  55,5185 }, {  48,5192 }, {  49,5192 }, {  50,5192 },
 {  51,5192 }, {  52,5192 }, {  53,5192 }, {  54,5192 }, {  55,5192 },
 {  56,5192 }, {  57,5192 }, {   0,   0 }, {   0,   0 }, {   0,  29 },

 {   0,16172 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5192 },
 {  66,5192 }, {  67,5192 }, {  68,5192 }, {  69,5192 }, {  70,5192 },
 {  48,5231 }, {  49,5231 }, {  50,5231 }, {  51,5231 }, {  52,5231 },
 {  53,5231 }, {  54,5231 }, {  55,5231 }, {  56,5231 }, {  57,5231 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5231 }, {  66,5231 }, {  67,5231 },
 {  68,5231 }, {  69,5231 }, {  70,5231 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,5192 }, {  98,5192 }, {  99,5192 }, { 100,5192 },
 { 101,5192 }, { 102,5192 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5216 }, {  49,5216 },

 {  50,5216 }, {  51,5216 }, {  52,5216 }, {  53,5216 }, {  54,5216 },
 {  55,5216 }, {  56,5216 }, {  57,5216 }, {   0,   0 }, {  97,5231 },
 {  98,5231 }, {  99,5231 }, { 100,5231 }, { 101,5231 }, { 102,5231 },
 {  65,5216 }, {  66,5216 }, {  67,5216 }, {  68,5216 }, {  69,5216 },
 {  70,5216 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,5216 }, {  98,5216 }, {  99,5216 },

 { 100,5216 }, { 101,5216 }, { 102,5216 }, {   0,  36 }, {   0,16068 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {   0,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },

 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },

 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },

 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },

 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },

 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  37 }, {   0,15810 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-11020 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,4913 }, {  49,4913 }, {  50,4913 }, {  51,4913 }, {  52,4913 },
 {  53,4913 }, {  54,4913 }, {  55,4913 }, {  56,4913 }, {  57,4913 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,4913 }, {  66,4913 }, {  67,4913 },
 {  68,4913 }, {  69,4913 }, {  70,4913 }, {  71,4913 }, {  72,4913 },
 {  73,4913 }, {  74,4913 }, {  75,4913 }, {  76,4913 }, {  77,4913 },
 {  78,4913 }, {  79,4913 }, {  80,4913 }, {  81,4913 }, {  82,4913 },
 {  83,4913 }, {  84,4913 }, {  85,4913 }, {  86,4913 }, {  87,4913 },

 {  88,4913 }, {  89,4913 }, {  90,4913 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,4913 }, {   0,   0 }, {  97,4913 },
 {  98,4913 }, {  99,4913 }, { 100,4913 }, { 101,4913 }, { 102,4913 },
 { 103,4913 }, { 104,4913 }, { 105,4913 }, { 106,4913 }, { 107,4913 },
 { 108,4913 }, { 109,4913 }, { 110,4913 }, { 111,4913 }, { 112,4913 },
 { 113,4913 }, { 114,4913 }, { 115,4913 }, { 116,4913 }, { 117,4913 },
 { 118,4913 }, { 119,4913 }, { 120,4913 }, { 121,4913 }, { 122,4913 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,4913 }, { 129,4913 }, { 130,4913 }, { 131,4913 }, { 132,4913 },
 { 133,4913 }, { 134,4913 }, { 135,4913 }, { 136,4913 }, { 137,4913 },

 { 138,4913 }, { 139,4913 }, { 140,4913 }, { 141,4913 }, { 142,4913 },
 { 143,4913 }, { 144,4913 }, { 145,4913 }, { 146,4913 }, { 147,4913 },
 { 148,4913 }, { 149,4913 }, { 150,4913 }, { 151,4913 }, { 152,4913 },
 { 153,4913 }, { 154,4913 }, { 155,4913 }, { 156,4913 }, { 157,4913 },
 { 158,4913 }, { 159,4913 }, { 160,4913 }, { 161,4913 }, { 162,4913 },
 { 163,4913 }, { 164,4913 }, { 165,4913 }, { 166,4913 }, { 167,4913 },
 { 168,4913 }, { 169,4913 }, { 170,4913 }, { 171,4913 }, { 172,4913 },
 { 173,4913 }, { 174,4913 }, { 175,4913 }, { 176,4913 }, { 177,4913 },
 { 178,4913 }, { 179,4913 }, { 180,4913 }, { 181,4913 }, { 182,4913 },
 { 183,4913 }, { 184,4913 }, { 185,4913 }, { 186,4913 }, { 187,4913 },

 { 188,4913 }, { 189,4913 }, { 190,4913 }, { 191,4913 }, { 192,4913 },
 { 193,4913 }, { 194,4913 }, { 195,4913 }, { 196,4913 }, { 197,4913 },
 { 198,4913 }, { 199,4913 }, { 200,4913 }, { 201,4913 }, { 202,4913 },
 { 203,4913 }, { 204,4913 }, { 205,4913 }, { 206,4913 }, { 207,4913 },
 { 208,4913 }, { 209,4913 }, { 210,4913 }, { 211,4913 }, { 212,4913 },
 { 213,4913 }, { 214,4913 }, { 215,4913 }, { 216,4913 }, { 217,4913 },
 { 218,4913 }, { 219,4913 }, { 220,4913 }, { 221,4913 }, { 222,4913 },
 { 223,4913 }, { 224,4913 }, { 225,4913 }, { 226,4913 }, { 227,4913 },
 { 228,4913 }, { 229,4913 }, { 230,4913 }, { 231,4913 }, { 232,4913 },
 { 233,4913 }, { 234,4913 }, { 235,4913 }, { 236,4913 }, { 237,4913 },

 { 238,4913 }, { 239,4913 }, { 240,4913 }, { 241,4913 }, { 242,4913 },
 { 243,4913 }, { 244,4913 }, { 245,4913 }, { 246,4913 }, { 247,4913 },
 { 248,4913 }, { 249,4913 }, { 250,4913 }, { 251,4913 }, { 252,4913 },
 { 253,4913 }, { 254,4913 }, { 255,4913 }, {   0,  28 }, {   0,15553 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0,15530 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,4913 }, {  49,4913 }, {  50,4913 },
 {  51,4913 }, {  52,4913 }, {  53,4913 }, {  54,4913 }, {  55,4913 },
 {  56,4913 }, {  57,4913 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4913 },
 {  66,4913 }, {  67,4913 }, {  68,4913 }, {  69,4913 }, {  70,4913 },
 {  48,4913 }, {  49,4913 }, {  50,4913 }, {  51,4913 }, {  52,4913 },
 {  53,4913 }, {  54,4913 }, {  55,4913 }, {  56,4913 }, {  57,4913 },

 {   0,  34 }, {   0,15471 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,4913 }, {  66,4913 }, {  67,4913 },
 {  68,4913 }, {  69,4913 }, {  70,4913 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,4913 }, {  98,4913 }, {  99,4913 }, { 100,4913 },
 { 101,4913 }, { 102,4913 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-11633 }, {   0,   0 }, {  97,4913 },
 {  98,4913 }, {  99,4913 }, { 100,4913 }, { 101,4913 }, { 102,4913 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },

 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },

 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },
 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },

 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },
 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },

 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },
 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },

 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, {   0,   2 }, {   0,15214 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9,   0 }, {   0,   0 }, {  11,   0 },
 {  12,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },

 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },

 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },

 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },

 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },

 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,   2 }, {   0,14956 }, {   1,-258 }, {   2,-258 }, {   3,-258 },
 {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 },
 {   9,-258 }, {   0,   0 }, {  11,-258 }, {  12,-258 }, {   0,   0 },
 {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 },
 {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 },
 {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 },
 {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,-258 }, {  33,   0 },

 {  34,-258 }, {  35,   0 }, {  36,-258 }, {  37,   0 }, {  38,   0 },
 {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,   0 }, {  43,   0 },
 {  44,-258 }, {  45,   0 }, {  46,-258 }, {  47,   0 }, {  48,-258 },
 {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 },
 {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 },
 {  59,-258 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 },
 {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 },
 {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 },
 {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 },

 {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 },
 {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 },
 {  94,   0 }, {  95,-258 }, {  96,   0 }, {  97,-258 }, {  98,-258 },
 {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 },
 { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 },
 { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 },
 { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 },
 { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 },
 { 124,   0 }, { 125,-258 }, { 126,   0 }, { 127,-258 }, { 128,-258 },
 { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 },

 { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 },
 { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 },
 { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 },
 { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 },
 { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 },
 { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 },
 { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 },
 { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 },
 { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 },
 { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 },

 { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 },
 { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 },
 { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 },
 { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 },
 { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 },
 { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 },
 { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 },
 { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 },
 { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 },
 { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 },

 { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 },
 { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 },
 { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 },
 { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 },
 { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  64 }, {   0,14698 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 257 },
 {  66, 257 }, {  67, 257 }, {  68, 257 }, {  69, 514 }, {  70, 257 },
 {  71, 257 }, {  72, 257 }, {  73, 257 }, {  74, 257 }, {  75, 257 },

 {  76, 257 }, {  77, 257 }, {  78, 257 }, {  79, 257 }, {  80, 257 },
 {  81, 257 }, {  82, 257 }, {  83, 257 }, {  84, 257 }, {  85, 257 },
 {  86, 257 }, {  87, 257 }, {  88, 257 }, {  89, 257 }, {  90, 257 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95, 771 },
 {   0,   0 }, {  97, 257 }, {  98, 257 }, {  99, 257 }, { 100, 257 },
 { 101, 514 }, { 102, 257 }, { 103, 257 }, { 104, 257 }, { 105, 257 },
 { 106, 257 }, { 107, 257 }, { 108, 257 }, { 109, 257 }, { 110, 257 },
 { 111, 257 }, { 112, 257 }, { 113, 257 }, { 114, 257 }, { 115, 257 },
 { 116, 257 }, { 117, 257 }, { 118, 257 }, { 119, 257 }, { 120, 257 },
 { 121, 257 }, { 122, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128, 257 }, { 129, 257 }, { 130, 257 },
 { 131, 257 }, { 132, 257 }, { 133, 257 }, { 134, 257 }, { 135, 257 },
 { 136, 257 }, { 137, 257 }, { 138, 257 }, { 139, 257 }, { 140, 257 },
 { 141, 257 }, { 142, 257 }, { 143, 257 }, { 144, 257 }, { 145, 257 },
 { 146, 257 }, { 147, 257 }, { 148, 257 }, { 149, 257 }, { 150, 257 },
 { 151, 257 }, { 152, 257 }, { 153, 257 }, { 154, 257 }, { 155, 257 },
 { 156, 257 }, { 157, 257 }, { 158, 257 }, { 159, 257 }, { 160, 257 },
 { 161, 257 }, { 162, 257 }, { 163, 257 }, { 164, 257 }, { 165, 257 },
 { 166, 257 }, { 167, 257 }, { 168, 257 }, { 169, 257 }, { 170, 257 },
 { 171, 257 }, { 172, 257 }, { 173, 257 }, { 174, 257 }, { 175, 257 },

 { 176, 257 }, { 177, 257 }, { 178, 257 }, { 179, 257 }, { 180, 257 },
 { 181, 257 }, { 182, 257 }, { 183, 257 }, { 184, 257 }, { 185, 257 },
 { 186, 257 }, { 187, 257 }, { 188, 257 }, { 189, 257 }, { 190, 257 },
 { 191, 257 }, { 192, 257 }, { 193, 257 }, { 194, 257 }, { 195, 257 },
 { 196, 257 }, { 197, 257 }, { 198, 257 }, { 199, 257 }, { 200, 257 },
 { 201, 257 }, { 202, 257 }, { 203, 257 }, { 204, 257 }, { 205, 257 },
 { 206, 257 }, { 207, 257 }, { 208, 257 }, { 209, 257 }, { 210, 257 },
 { 211, 257 }, { 212, 257 }, { 213, 257 }, { 214, 257 }, { 215, 257 },
 { 216, 257 }, { 217, 257 }, { 218, 257 }, { 219, 257 }, { 220, 257 },
 { 221, 257 }, { 222, 257 }, { 223, 257 }, { 224, 257 }, { 225, 257 },

 { 226, 257 }, { 227, 257 }, { 228, 257 }, { 229, 257 }, { 230, 257 },
 { 231, 257 }, { 232, 257 }, { 233, 257 }, { 234, 257 }, { 235, 257 },
 { 236, 257 }, { 237, 257 }, { 238, 257 }, { 239, 257 }, { 240, 257 },
 { 241, 257 }, { 242, 257 }, { 243, 257 }, { 244, 257 }, { 245, 257 },
 { 246, 257 }, { 247, 257 }, { 248, 257 }, { 249, 257 }, { 250, 257 },
 { 251, 257 }, { 252, 257 }, { 253, 257 }, { 254, 257 }, { 255, 257 },
 {   0,  69 }, {   0,14441 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,3883 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3883 },
 {  49,3883 }, {  50,3883 }, {  51,3883 }, {  52,3883 }, {  53,3883 },
 {  54,3883 }, {  55,3883 }, {  56,3883 }, {  57,3883 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,3883 }, {  66,3883 }, {  67,3883 }, {  68,3883 },

 {  69,3883 }, {  70,3883 }, {  71,3883 }, {  72,3883 }, {  73,3883 },
 {  74,3883 }, {  75,3883 }, {  76,3883 }, {  77,3883 }, {  78,3883 },
 {  79,3883 }, {  80,3883 }, {  81,3883 }, {  82,3883 }, {  83,3883 },
 {  84,3883 }, {  85,3883 }, {  86,3883 }, {  87,3883 }, {  88,3883 },
 {  89,3883 }, {  90,3883 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,3883 }, {   0,   0 }, {  97,3883 }, {  98,3883 },
 {  99,3883 }, { 100,3883 }, { 101,3883 }, { 102,3883 }, { 103,3883 },
 { 104,3883 }, { 105,3883 }, { 106,3883 }, { 107,3883 }, { 108,3883 },
 { 109,3883 }, { 110,3883 }, { 111,3883 }, { 112,3883 }, { 113,3883 },
 { 114,3883 }, { 115,3883 }, { 116,3883 }, { 117,3883 }, { 118,3883 },

 { 119,3883 }, { 120,3883 }, { 121,3883 }, { 122,3883 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,3883 },
 { 129,3883 }, { 130,3883 }, { 131,3883 }, { 132,3883 }, { 133,3883 },
 { 134,3883 }, { 135,3883 }, { 136,3883 }, { 137,3883 }, { 138,3883 },
 { 139,3883 }, { 140,3883 }, { 141,3883 }, { 142,3883 }, { 143,3883 },
 { 144,3883 }, { 145,3883 }, { 146,3883 }, { 147,3883 }, { 148,3883 },
 { 149,3883 }, { 150,3883 }, { 151,3883 }, { 152,3883 }, { 153,3883 },
 { 154,3883 }, { 155,3883 }, { 156,3883 }, { 157,3883 }, { 158,3883 },
 { 159,3883 }, { 160,3883 }, { 161,3883 }, { 162,3883 }, { 163,3883 },
 { 164,3883 }, { 165,3883 }, { 166,3883 }, { 167,3883 }, { 168,3883 },

 { 169,3883 }, { 170,3883 }, { 171,3883 }, { 172,3883 }, { 173,3883 },
 { 174,3883 }, { 175,3883 }, { 176,3883 }, { 177,3883 }, { 178,3883 },
 { 179,3883 }, { 180,3883 }, { 181,3883 }, { 182,3883 }, { 183,3883 },
 { 184,3883 }, { 185,3883 }, { 186,3883 }, { 187,3883 }, { 188,3883 },
 { 189,3883 }, { 190,3883 }, { 191,3883 }, { 192,3883 }, { 193,3883 },
 { 194,3883 }, { 195,3883 }, { 196,3883 }, { 197,3883 }, { 198,3883 },
 { 199,3883 }, { 200,3883 }, { 201,3883 }, { 202,3883 }, { 203,3883 },
 { 204,3883 }, { 205,3883 }, { 206,3883 }, { 207,3883 }, { 208,3883 },
 { 209,3883 }, { 210,3883 }, { 211,3883 }, { 212,3883 }, { 213,3883 },
 { 214,3883 }, { 215,3883 }, { 216,3883 }, { 217,3883 }, { 218,3883 },

 { 219,3883 }, { 220,3883 }, { 221,3883 }, { 222,3883 }, { 223,3883 },
 { 224,3883 }, { 225,3883 }, { 226,3883 }, { 227,3883 }, { 228,3883 },
 { 229,3883 }, { 230,3883 }, { 231,3883 }, { 232,3883 }, { 233,3883 },
 { 234,3883 }, { 235,3883 }, { 236,3883 }, { 237,3883 }, { 238,3883 },
 { 239,3883 }, { 240,3883 }, { 241,3883 }, { 242,3883 }, { 243,3883 },
 { 244,3883 }, { 245,3883 }, { 246,3883 }, { 247,3883 }, { 248,3883 },
 { 249,3883 }, { 250,3883 }, { 251,3883 }, { 252,3883 }, { 253,3883 },
 { 254,3883 }, { 255,3883 }, {   0,  69 }, {   0,14184 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,3626 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  43,1574 }, {   0,   0 }, {  45,1574 }, {   0,   0 },
 {   0,   0 }, {  48,3883 }, {  49,3883 }, {  50,3883 }, {  51,3883 },
 {  52,3883 }, {  53,3883 }, {  54,3883 }, {  55,3883 }, {  56,3883 },
 {  57,3883 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3626 }, {  66,3626 },
 {  67,3626 }, {  68,3626 }, {  69,3626 }, {  70,3626 }, {  71,3626 },
 {  72,3626 }, {  73,3626 }, {  74,3626 }, {  75,3626 }, {  76,3626 },
 {  77,3626 }, {  78,3626 }, {  79,3626 }, {  80,3626 }, {  81,3626 },
 {  82,3626 }, {  83,3626 }, {  84,3626 }, {  85,3626 }, {  86,3626 },
 {  87,3626 }, {  88,3626 }, {  89,3626 }, {  90,3626 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,3626 }, {   0,   0 },
 {  97,3626 }, {  98,3626 }, {  99,3626 }, { 100,3626 }, { 101,3626 },
 { 102,3626 }, { 103,3626 }, { 104,3626 }, { 105,3626 }, { 106,3626 },
 { 107,3626 }, { 108,3626 }, { 109,3626 }, { 110,3626 }, { 111,3626 },

 { 112,3626 }, { 113,3626 }, { 114,3626 }, { 115,3626 }, { 116,3626 },
 { 117,3626 }, { 118,3626 }, { 119,3626 }, { 120,3626 }, { 121,3626 },
 { 122,3626 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,3626 }, { 129,3626 }, { 130,3626 }, { 131,3626 },
 { 132,3626 }, { 133,3626 }, { 134,3626 }, { 135,3626 }, { 136,3626 },
 { 137,3626 }, { 138,3626 }, { 139,3626 }, { 140,3626 }, { 141,3626 },
 { 142,3626 }, { 143,3626 }, { 144,3626 }, { 145,3626 }, { 146,3626 },
 { 147,3626 }, { 148,3626 }, { 149,3626 }, { 150,3626 }, { 151,3626 },
 { 152,3626 }, { 153,3626 }, { 154,3626 }, { 155,3626 }, { 156,3626 },
 { 157,3626 }, { 158,3626 }, { 159,3626 }, { 160,3626 }, { 161,3626 },

 { 162,3626 }, { 163,3626 }, { 164,3626 }, { 165,3626 }, { 166,3626 },
 { 167,3626 }, { 168,3626 }, { 169,3626 }, { 170,3626 }, { 171,3626 },
 { 172,3626 }, { 173,3626 }, { 174,3626 }, { 175,3626 }, { 176,3626 },
 { 177,3626 }, { 178,3626 }, { 179,3626 }, { 180,3626 }, { 181,3626 },
 { 182,3626 }, { 183,3626 }, { 184,3626 }, { 185,3626 }, { 186,3626 },
 { 187,3626 }, { 188,3626 }, { 189,3626 }, { 190,3626 }, { 191,3626 },
 { 192,3626 }, { 193,3626 }, { 194,3626 }, { 195,3626 }, { 196,3626 },
 { 197,3626 }, { 198,3626 }, { 199,3626 }, { 200,3626 }, { 201,3626 },
 { 202,3626 }, { 203,3626 }, { 204,3626 }, { 205,3626 }, { 206,3626 },
 { 207,3626 }, { 208,3626 }, { 209,3626 }, { 210,3626 }, { 211,3626 },

 { 212,3626 }, { 213,3626 }, { 214,3626 }, { 215,3626 }, { 216,3626 },
 { 217,3626 }, { 218,3626 }, { 219,3626 }, { 220,3626 }, { 221,3626 },
 { 222,3626 }, { 223,3626 }, { 224,3626 }, { 225,3626 }, { 226,3626 },
 { 227,3626 }, { 228,3626 }, { 229,3626 }, { 230,3626 }, { 231,3626 },
 { 232,3626 }, { 233,3626 }, { 234,3626 }, { 235,3626 }, { 236,3626 },
 { 237,3626 }, { 238,3626 }, { 239,3626 }, { 240,3626 }, { 241,3626 },
 { 242,3626 }, { 243,3626 }, { 244,3626 }, { 245,3626 }, { 246,3626 },
 { 247,3626 }, { 248,3626 }, { 249,3626 }, { 250,3626 }, { 251,3626 },
 { 252,3626 }, { 253,3626 }, { 254,3626 }, { 255,3626 }, {   0,  69 },
 {   0,13927 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,3369 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3883 }, {  49,3883 },
 {  50,3883 }, {  51,3883 }, {  52,3883 }, {  53,3883 }, {  54,3883 },

 {  55,3883 }, {  56,3883 }, {  57,3883 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,3369 }, {  66,3369 }, {  67,3369 }, {  68,3369 }, {  69,3369 },
 {  70,3369 }, {  71,3369 }, {  72,3369 }, {  73,3369 }, {  74,3369 },
 {  75,3369 }, {  76,3369 }, {  77,3369 }, {  78,3369 }, {  79,3369 },
 {  80,3369 }, {  81,3369 }, {  82,3369 }, {  83,3369 }, {  84,3369 },
 {  85,3369 }, {  86,3369 }, {  87,3369 }, {  88,3369 }, {  89,3369 },
 {  90,3369 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,3369 }, {   0,   0 }, {  97,3369 }, {  98,3369 }, {  99,3369 },
 { 100,3369 }, { 101,3369 }, { 102,3369 }, { 103,3369 }, { 104,3369 },

 { 105,3369 }, { 106,3369 }, { 107,3369 }, { 108,3369 }, { 109,3369 },
 { 110,3369 }, { 111,3369 }, { 112,3369 }, { 113,3369 }, { 114,3369 },
 { 115,3369 }, { 116,3369 }, { 117,3369 }, { 118,3369 }, { 119,3369 },
 { 120,3369 }, { 121,3369 }, { 122,3369 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,3369 }, { 129,3369 },
 { 130,3369 }, { 131,3369 }, { 132,3369 }, { 133,3369 }, { 134,3369 },
 { 135,3369 }, { 136,3369 }, { 137,3369 }, { 138,3369 }, { 139,3369 },
 { 140,3369 }, { 141,3369 }, { 142,3369 }, { 143,3369 }, { 144,3369 },
 { 145,3369 }, { 146,3369 }, { 147,3369 }, { 148,3369 }, { 149,3369 },
 { 150,3369 }, { 151,3369 }, { 152,3369 }, { 153,3369 }, { 154,3369 },

 { 155,3369 }, { 156,3369 }, { 157,3369 }, { 158,3369 }, { 159,3369 },
 { 160,3369 }, { 161,3369 }, { 162,3369 }, { 163,3369 }, { 164,3369 },
 { 165,3369 }, { 166,3369 }, { 167,3369 }, { 168,3369 }, { 169,3369 },
 { 170,3369 }, { 171,3369 }, { 172,3369 }, { 173,3369 }, { 174,3369 },
 { 175,3369 }, { 176,3369 }, { 177,3369 }, { 178,3369 }, { 179,3369 },
 { 180,3369 }, { 181,3369 }, { 182,3369 }, { 183,3369 }, { 184,3369 },
 { 185,3369 }, { 186,3369 }, { 187,3369 }, { 188,3369 }, { 189,3369 },
 { 190,3369 }, { 191,3369 }, { 192,3369 }, { 193,3369 }, { 194,3369 },
 { 195,3369 }, { 196,3369 }, { 197,3369 }, { 198,3369 }, { 199,3369 },
 { 200,3369 }, { 201,3369 }, { 202,3369 }, { 203,3369 }, { 204,3369 },

 { 205,3369 }, { 206,3369 }, { 207,3369 }, { 208,3369 }, { 209,3369 },
 { 210,3369 }, { 211,3369 }, { 212,3369 }, { 213,3369 }, { 214,3369 },
 { 215,3369 }, { 216,3369 }, { 217,3369 }, { 218,3369 }, { 219,3369 },
 { 220,3369 }, { 221,3369 }, { 222,3369 }, { 223,3369 }, { 224,3369 },
 { 225,3369 }, { 226,3369 }, { 227,3369 }, { 228,3369 }, { 229,3369 },
 { 230,3369 }, { 231,3369 }, { 232,3369 }, { 233,3369 }, { 234,3369 },
 { 235,3369 }, { 236,3369 }, { 237,3369 }, { 238,3369 }, { 239,3369 },
 { 240,3369 }, { 241,3369 }, { 242,3369 }, { 243,3369 }, { 244,3369 },
 { 245,3369 }, { 246,3369 }, { 247,3369 }, { 248,3369 }, { 249,3369 },
 { 250,3369 }, { 251,3369 }, { 252,3369 }, { 253,3369 }, { 254,3369 },

 { 255,3369 }, {   0,   3 }, {   0,13670 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  64 }, {   0,13638 },
 {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 },
 {  43,   0 }, {   0,   0 }, {  45,   0 }, {   0,   0 }, {  47,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3851 }, {  49,3851 }, {  50,3851 },
 {  51,3851 }, {  52,3851 }, {  53,3851 }, {  54,3851 }, {  55,3851 },
 {  56,3851 }, {  57,3851 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 }, {  65,-803 },

 {  66,-803 }, {  67,-803 }, {  68,-803 }, {  69,-546 }, {  70,-803 },
 {  71,-803 }, {  72,-803 }, {  73,-803 }, {  74,-803 }, {  75,-803 },
 {  76,-803 }, {  77,-803 }, {  78,-803 }, {  79,-803 }, {  80,-803 },
 {  81,-803 }, {  82,-803 }, {  83,-803 }, {  84,-803 }, {  85,-803 },
 {  86,-803 }, {  87,-803 }, {  88,-803 }, {  89,-803 }, {  90,-803 },
 {   0,   0 }, { 124,   0 }, {   0,   0 }, { 126,   0 }, {  95,4108 },
 {   0,   0 }, {  97,-803 }, {  98,-803 }, {  99,-803 }, { 100,-803 },
 { 101,-546 }, { 102,-803 }, { 103,-803 }, { 104,-803 }, { 105,-803 },
 { 106,-803 }, { 107,-803 }, { 108,-803 }, { 109,-803 }, { 110,-803 },
 { 111,-803 }, { 112,-803 }, { 113,-803 }, { 114,-803 }, { 115,-803 },

 { 116,-803 }, { 117,-803 }, { 118,-803 }, { 119,-803 }, { 120,-803 },
 { 121,-803 }, { 122,-803 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-803 }, { 129,-803 }, { 130,-803 },
 { 131,-803 }, { 132,-803 }, { 133,-803 }, { 134,-803 }, { 135,-803 },
 { 136,-803 }, { 137,-803 }, { 138,-803 }, { 139,-803 }, { 140,-803 },
 { 141,-803 }, { 142,-803 }, { 143,-803 }, { 144,-803 }, { 145,-803 },
 { 146,-803 }, { 147,-803 }, { 148,-803 }, { 149,-803 }, { 150,-803 },
 { 151,-803 }, { 152,-803 }, { 153,-803 }, { 154,-803 }, { 155,-803 },
 { 156,-803 }, { 157,-803 }, { 158,-803 }, { 159,-803 }, { 160,-803 },
 { 161,-803 }, { 162,-803 }, { 163,-803 }, { 164,-803 }, { 165,-803 },

 { 166,-803 }, { 167,-803 }, { 168,-803 }, { 169,-803 }, { 170,-803 },
 { 171,-803 }, { 172,-803 }, { 173,-803 }, { 174,-803 }, { 175,-803 },
 { 176,-803 }, { 177,-803 }, { 178,-803 }, { 179,-803 }, { 180,-803 },
 { 181,-803 }, { 182,-803 }, { 183,-803 }, { 184,-803 }, { 185,-803 },
 { 186,-803 }, { 187,-803 }, { 188,-803 }, { 189,-803 }, { 190,-803 },
 { 191,-803 }, { 192,-803 }, { 193,-803 }, { 194,-803 }, { 195,-803 },
 { 196,-803 }, { 197,-803 }, { 198,-803 }, { 199,-803 }, { 200,-803 },
 { 201,-803 }, { 202,-803 }, { 203,-803 }, { 204,-803 }, { 205,-803 },
 { 206,-803 }, { 207,-803 }, { 208,-803 }, { 209,-803 }, { 210,-803 },
 { 211,-803 }, { 212,-803 }, { 213,-803 }, { 214,-803 }, { 215,-803 },

 { 216,-803 }, { 217,-803 }, { 218,-803 }, { 219,-803 }, { 220,-803 },
 { 221,-803 }, { 222,-803 }, { 223,-803 }, { 224,-803 }, { 225,-803 },
 { 226,-803 }, { 227,-803 }, { 228,-803 }, { 229,-803 }, { 230,-803 },
 { 231,-803 }, { 232,-803 }, { 233,-803 }, { 234,-803 }, { 235,-803 },
 { 236,-803 }, { 237,-803 }, { 238,-803 }, { 239,-803 }, { 240,-803 },
 { 241,-803 }, { 242,-803 }, { 243,-803 }, { 244,-803 }, { 245,-803 },
 { 246,-803 }, { 247,-803 }, { 248,-803 }, { 249,-803 }, { 250,-803 },
 { 251,-803 }, { 252,-803 }, { 253,-803 }, { 254,-803 }, { 255,-803 },
 {   0,  68 }, {   0,13381 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 },
 {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 },
 {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 },
 {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 },
 {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 },
 {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 },
 {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 },
 { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 },

 { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 },
 { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 },
 { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 },
 { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 },
 { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 },
 { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 },
 { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 },
 { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 },
 { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 },

 { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 },
 { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 },
 { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 },
 { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 },
 { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 },
 { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 },
 { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 },
 { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 },
 { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 },
 { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 },

 { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 },
 { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 },
 { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 },
 { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 },
 { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 },
 { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 },
 { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 },
 { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 },
 { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 },
 { 254,   0 }, { 255,   0 }, {   0,  60 }, {   0,13124 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-257 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,-257 }, {  51,-257 },

 {  52,-257 }, {  53,-257 }, {  54,-257 }, {  55,-257 }, {  56,-257 },
 {  57,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-257 }, {  66,-257 },
 {  67,-257 }, {  68,-257 }, {  69,-257 }, {  70,-257 }, {  71,-257 },
 {  72,-257 }, {  73,-257 }, {  74,-257 }, {  75,-257 }, {  76,-257 },
 {  77,-257 }, {  78,-257 }, {  79,-257 }, {  80,-257 }, {  81,-257 },
 {  82,-257 }, {  83,-257 }, {  84,-257 }, {  85,-257 }, {  86,-257 },
 {  87,-257 }, {  88,-257 }, {  89,-257 }, {  90,-257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,3851 }, {   0,   0 },
 {  97,-257 }, {  98,-257 }, {  99,-257 }, { 100,-257 }, { 101,-257 },

 { 102,-257 }, { 103,-257 }, { 104,-257 }, { 105,-257 }, { 106,-257 },
 { 107,-257 }, { 108,-257 }, { 109,-257 }, { 110,-257 }, { 111,-257 },
 { 112,-257 }, { 113,-257 }, { 114,-257 }, { 115,-257 }, { 116,-257 },
 { 117,-257 }, { 118,-257 }, { 119,-257 }, { 120,-257 }, { 121,-257 },
 { 122,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-257 }, { 129,-257 }, { 130,-257 }, { 131,-257 },
 { 132,-257 }, { 133,-257 }, { 134,-257 }, { 135,-257 }, { 136,-257 },
 { 137,-257 }, { 138,-257 }, { 139,-257 }, { 140,-257 }, { 141,-257 },
 { 142,-257 }, { 143,-257 }, { 144,-257 }, { 145,-257 }, { 146,-257 },
 { 147,-257 }, { 148,-257 }, { 149,-257 }, { 150,-257 }, { 151,-257 },

 { 152,-257 }, { 153,-257 }, { 154,-257 }, { 155,-257 }, { 156,-257 },
 { 157,-257 }, { 158,-257 }, { 159,-257 }, { 160,-257 }, { 161,-257 },
 { 162,-257 }, { 163,-257 }, { 164,-257 }, { 165,-257 }, { 166,-257 },
 { 167,-257 }, { 168,-257 }, { 169,-257 }, { 170,-257 }, { 171,-257 },
 { 172,-257 }, { 173,-257 }, { 174,-257 }, { 175,-257 }, { 176,-257 },
 { 177,-257 }, { 178,-257 }, { 179,-257 }, { 180,-257 }, { 181,-257 },
 { 182,-257 }, { 183,-257 }, { 184,-257 }, { 185,-257 }, { 186,-257 },
 { 187,-257 }, { 188,-257 }, { 189,-257 }, { 190,-257 }, { 191,-257 },
 { 192,-257 }, { 193,-257 }, { 194,-257 }, { 195,-257 }, { 196,-257 },
 { 197,-257 }, { 198,-257 }, { 199,-257 }, { 200,-257 }, { 201,-257 },

 { 202,-257 }, { 203,-257 }, { 204,-257 }, { 205,-257 }, { 206,-257 },
 { 207,-257 }, { 208,-257 }, { 209,-257 }, { 210,-257 }, { 211,-257 },
 { 212,-257 }, { 213,-257 }, { 214,-257 }, { 215,-257 }, { 216,-257 },
 { 217,-257 }, { 218,-257 }, { 219,-257 }, { 220,-257 }, { 221,-257 },
 { 222,-257 }, { 223,-257 }, { 224,-257 }, { 225,-257 }, { 226,-257 },
 { 227,-257 }, { 228,-257 }, { 229,-257 }, { 230,-257 }, { 231,-257 },
 { 232,-257 }, { 233,-257 }, { 234,-257 }, { 235,-257 }, { 236,-257 },
 { 237,-257 }, { 238,-257 }, { 239,-257 }, { 240,-257 }, { 241,-257 },
 { 242,-257 }, { 243,-257 }, { 244,-257 }, { 245,-257 }, { 246,-257 },
 { 247,-257 }, { 248,-257 }, { 249,-257 }, { 250,-257 }, { 251,-257 },

 { 252,-257 }, { 253,-257 }, { 254,-257 }, { 255,-257 }, {   0,  63 },
 {   0,12867 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-514 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-257 }, {  49,-257 },
 {  50,-514 }, {  51,-514 }, {  52,-514 }, {  53,-514 }, {  54,-514 },
 {  55,-514 }, {  56,-514 }, {  57,-514 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-514 }, {  66,-514 }, {  67,-514 }, {  68,-514 }, {  69,-514 },
 {  70,-514 }, {  71,-514 }, {  72,-514 }, {  73,-514 }, {  74,-514 },
 {  75,-514 }, {  76,-514 }, {  77,-514 }, {  78,-514 }, {  79,-514 },
 {  80,-514 }, {  81,-514 }, {  82,-514 }, {  83,-514 }, {  84,-514 },
 {  85,-514 }, {  86,-514 }, {  87,-514 }, {  88,-514 }, {  89,-514 },
 {  90,-514 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  95,-514 }, {   0,   0 }, {  97,-514 }, {  98,-514 }, {  99,-514 },
 { 100,-514 }, { 101,-514 }, { 102,-514 }, { 103,-514 }, { 104,-514 },
 { 105,-514 }, { 106,-514 }, { 107,-514 }, { 108,-514 }, { 109,-514 },
 { 110,-514 }, { 111,-514 }, { 112,-514 }, { 113,-514 }, { 114,-514 },
 { 115,-514 }, { 116,-514 }, { 117,-514 }, { 118,-514 }, { 119,-514 },
 { 120,-514 }, { 121,-514 }, { 122,-514 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-514 }, { 129,-514 },
 { 130,-514 }, { 131,-514 }, { 132,-514 }, { 133,-514 }, { 134,-514 },
 { 135,-514 }, { 136,-514 }, { 137,-514 }, { 138,-514 }, { 139,-514 },
 { 140,-514 }, { 141,-514 }, { 142,-514 }, { 143,-514 }, { 144,-514 },

 { 145,-514 }, { 146,-514 }, { 147,-514 }, { 148,-514 }, { 149,-514 },
 { 150,-514 }, { 151,-514 }, { 152,-514 }, { 153,-514 }, { 154,-514 },
 { 155,-514 }, { 156,-514 }, { 157,-514 }, { 158,-514 }, { 159,-514 },
 { 160,-514 }, { 161,-514 }, { 162,-514 }, { 163,-514 }, { 164,-514 },
 { 165,-514 }, { 166,-514 }, { 167,-514 }, { 168,-514 }, { 169,-514 },
 { 170,-514 }, { 171,-514 }, { 172,-514 }, { 173,-514 }, { 174,-514 },
 { 175,-514 }, { 176,-514 }, { 177,-514 }, { 178,-514 }, { 179,-514 },
 { 180,-514 }, { 181,-514 }, { 182,-514 }, { 183,-514 }, { 184,-514 },
 { 185,-514 }, { 186,-514 }, { 187,-514 }, { 188,-514 }, { 189,-514 },
 { 190,-514 }, { 191,-514 }, { 192,-514 }, { 193,-514 }, { 194,-514 },

 { 195,-514 }, { 196,-514 }, { 197,-514 }, { 198,-514 }, { 199,-514 },
 { 200,-514 }, { 201,-514 }, { 202,-514 }, { 203,-514 }, { 204,-514 },
 { 205,-514 }, { 206,-514 }, { 207,-514 }, { 208,-514 }, { 209,-514 },
 { 210,-514 }, { 211,-514 }, { 212,-514 }, { 213,-514 }, { 214,-514 },
 { 215,-514 }, { 216,-514 }, { 217,-514 }, { 218,-514 }, { 219,-514 },
 { 220,-514 }, { 221,-514 }, { 222,-514 }, { 223,-514 }, { 224,-514 },
 { 225,-514 }, { 226,-514 }, { 227,-514 }, { 228,-514 }, { 229,-514 },
 { 230,-514 }, { 231,-514 }, { 232,-514 }, { 233,-514 }, { 234,-514 },
 { 235,-514 }, { 236,-514 }, { 237,-514 }, { 238,-514 }, { 239,-514 },
 { 240,-514 }, { 241,-514 }, { 242,-514 }, { 243,-514 }, { 244,-514 },

 { 245,-514 }, { 246,-514 }, { 247,-514 }, { 248,-514 }, { 249,-514 },
 { 250,-514 }, { 251,-514 }, { 252,-514 }, { 253,-514 }, { 254,-514 },
 { 255,-514 }, {   0,  67 }, {   0,12610 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  66 }, {   0,12600 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-781 }, {   0,   0 },
 {  48,3594 }, {  49,3594 }, {  50,3594 }, {  51,3594 }, {  52,3594 },
 {  53,3594 }, {  54,3594 }, {  55,3594 }, {  56,3594 }, {  57,3594 },
 {  48,3841 }, {  49,3841 }, {  50,3841 }, {  51,3841 }, {  52,3841 },
 {  53,3841 }, {  54,3841 }, {  55,3841 }, {  56,3841 }, {  57,3841 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,4098 }, {  66,4098 }, {  67,4098 },
 {  68,4098 }, {  69,4098 }, {  70,4098 }, {  71,4098 }, {  72,4098 },
 {  73,4098 }, {  74,4098 }, {  75,4098 }, {  76,4098 }, {  77,4098 },

 {  78,4098 }, {  79,4098 }, {  80,4098 }, {  81,4098 }, {  82,4098 },
 {  83,4098 }, {  84,4098 }, {  85,4098 }, {  86,4098 }, {  87,4098 },
 {  88,4098 }, {  89,4098 }, {  90,4098 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,4355 }, {   0,   0 }, {  97,4098 },
 {  98,4098 }, {  99,4098 }, { 100,4098 }, { 101,4098 }, { 102,4098 },
 { 103,4098 }, { 104,4098 }, { 105,4098 }, { 106,4098 }, { 107,4098 },
 { 108,4098 }, { 109,4098 }, { 110,4098 }, { 111,4098 }, { 112,4098 },
 { 113,4098 }, { 114,4098 }, { 115,4098 }, { 116,4098 }, { 117,4098 },
 { 118,4098 }, { 119,4098 }, { 120,4098 }, { 121,4098 }, { 122,4098 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,4098 }, { 129,4098 }, { 130,4098 }, { 131,4098 }, { 132,4098 },
 { 133,4098 }, { 134,4098 }, { 135,4098 }, { 136,4098 }, { 137,4098 },
 { 138,4098 }, { 139,4098 }, { 140,4098 }, { 141,4098 }, { 142,4098 },
 { 143,4098 }, { 144,4098 }, { 145,4098 }, { 146,4098 }, { 147,4098 },
 { 148,4098 }, { 149,4098 }, { 150,4098 }, { 151,4098 }, { 152,4098 },
 { 153,4098 }, { 154,4098 }, { 155,4098 }, { 156,4098 }, { 157,4098 },
 { 158,4098 }, { 159,4098 }, { 160,4098 }, { 161,4098 }, { 162,4098 },
 { 163,4098 }, { 164,4098 }, { 165,4098 }, { 166,4098 }, { 167,4098 },
 { 168,4098 }, { 169,4098 }, { 170,4098 }, { 171,4098 }, { 172,4098 },
 { 173,4098 }, { 174,4098 }, { 175,4098 }, { 176,4098 }, { 177,4098 },

 { 178,4098 }, { 179,4098 }, { 180,4098 }, { 181,4098 }, { 182,4098 },
 { 183,4098 }, { 184,4098 }, { 185,4098 }, { 186,4098 }, { 187,4098 },
 { 188,4098 }, { 189,4098 }, { 190,4098 }, { 191,4098 }, { 192,4098 },
 { 193,4098 }, { 194,4098 }, { 195,4098 }, { 196,4098 }, { 197,4098 },
 { 198,4098 }, { 199,4098 }, { 200,4098 }, { 201,4098 }, { 202,4098 },
 { 203,4098 }, { 204,4098 }, { 205,4098 }, { 206,4098 }, { 207,4098 },
 { 208,4098 }, { 209,4098 }, { 210,4098 }, { 211,4098 }, { 212,4098 },
 { 213,4098 }, { 214,4098 }, { 215,4098 }, { 216,4098 }, { 217,4098 },
 { 218,4098 }, { 219,4098 }, { 220,4098 }, { 221,4098 }, { 222,4098 },
 { 223,4098 }, { 224,4098 }, { 225,4098 }, { 226,4098 }, { 227,4098 },

 { 228,4098 }, { 229,4098 }, { 230,4098 }, { 231,4098 }, { 232,4098 },
 { 233,4098 }, { 234,4098 }, { 235,4098 }, { 236,4098 }, { 237,4098 },
 { 238,4098 }, { 239,4098 }, { 240,4098 }, { 241,4098 }, { 242,4098 },
 { 243,4098 }, { 244,4098 }, { 245,4098 }, { 246,4098 }, { 247,4098 },
 { 248,4098 }, { 249,4098 }, { 250,4098 }, { 251,4098 }, { 252,4098 },
 { 253,4098 }, { 254,4098 }, { 255,4098 }, {   0,  59 }, {   0,12343 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-1038 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,-1038 }, {  57,-1038 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-1038 },
 {  66,-1038 }, {  67,-1038 }, {  68,-1038 }, {  69,-1038 }, {  70,-1038 },

 {  71,-1038 }, {  72,-1038 }, {  73,-1038 }, {  74,-1038 }, {  75,-1038 },
 {  76,-1038 }, {  77,-1038 }, {  78,-1038 }, {  79,-1038 }, {  80,-1038 },
 {  81,-1038 }, {  82,-1038 }, {  83,-1038 }, {  84,-1038 }, {  85,-1038 },
 {  86,-1038 }, {  87,-1038 }, {  88,-1038 }, {  89,-1038 }, {  90,-1038 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4355 },
 {   0,   0 }, {  97,-1038 }, {  98,-1038 }, {  99,-1038 }, { 100,-1038 },
 { 101,-1038 }, { 102,-1038 }, { 103,-1038 }, { 104,-1038 }, { 105,-1038 },
 { 106,-1038 }, { 107,-1038 }, { 108,-1038 }, { 109,-1038 }, { 110,-1038 },
 { 111,-1038 }, { 112,-1038 }, { 113,-1038 }, { 114,-1038 }, { 115,-1038 },
 { 116,-1038 }, { 117,-1038 }, { 118,-1038 }, { 119,-1038 }, { 120,-1038 },

 { 121,-1038 }, { 122,-1038 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-1038 }, { 129,-1038 }, { 130,-1038 },
 { 131,-1038 }, { 132,-1038 }, { 133,-1038 }, { 134,-1038 }, { 135,-1038 },
 { 136,-1038 }, { 137,-1038 }, { 138,-1038 }, { 139,-1038 }, { 140,-1038 },
 { 141,-1038 }, { 142,-1038 }, { 143,-1038 }, { 144,-1038 }, { 145,-1038 },
 { 146,-1038 }, { 147,-1038 }, { 148,-1038 }, { 149,-1038 }, { 150,-1038 },
 { 151,-1038 }, { 152,-1038 }, { 153,-1038 }, { 154,-1038 }, { 155,-1038 },
 { 156,-1038 }, { 157,-1038 }, { 158,-1038 }, { 159,-1038 }, { 160,-1038 },
 { 161,-1038 }, { 162,-1038 }, { 163,-1038 }, { 164,-1038 }, { 165,-1038 },
 { 166,-1038 }, { 167,-1038 }, { 168,-1038 }, { 169,-1038 }, { 170,-1038 },

 { 171,-1038 }, { 172,-1038 }, { 173,-1038 }, { 174,-1038 }, { 175,-1038 },
 { 176,-1038 }, { 177,-1038 }, { 178,-1038 }, { 179,-1038 }, { 180,-1038 },
 { 181,-1038 }, { 182,-1038 }, { 183,-1038 }, { 184,-1038 }, { 185,-1038 },
 { 186,-1038 }, { 187,-1038 }, { 188,-1038 }, { 189,-1038 }, { 190,-1038 },
 { 191,-1038 }, { 192,-1038 }, { 193,-1038 }, { 194,-1038 }, { 195,-1038 },
 { 196,-1038 }, { 197,-1038 }, { 198,-1038 }, { 199,-1038 }, { 200,-1038 },
 { 201,-1038 }, { 202,-1038 }, { 203,-1038 }, { 204,-1038 }, { 205,-1038 },
 { 206,-1038 }, { 207,-1038 }, { 208,-1038 }, { 209,-1038 }, { 210,-1038 },
 { 211,-1038 }, { 212,-1038 }, { 213,-1038 }, { 214,-1038 }, { 215,-1038 },
 { 216,-1038 }, { 217,-1038 }, { 218,-1038 }, { 219,-1038 }, { 220,-1038 },

 { 221,-1038 }, { 222,-1038 }, { 223,-1038 }, { 224,-1038 }, { 225,-1038 },
 { 226,-1038 }, { 227,-1038 }, { 228,-1038 }, { 229,-1038 }, { 230,-1038 },
 { 231,-1038 }, { 232,-1038 }, { 233,-1038 }, { 234,-1038 }, { 235,-1038 },
 { 236,-1038 }, { 237,-1038 }, { 238,-1038 }, { 239,-1038 }, { 240,-1038 },
 { 241,-1038 }, { 242,-1038 }, { 243,-1038 }, { 244,-1038 }, { 245,-1038 },
 { 246,-1038 }, { 247,-1038 }, { 248,-1038 }, { 249,-1038 }, { 250,-1038 },
 { 251,-1038 }, { 252,-1038 }, { 253,-1038 }, { 254,-1038 }, { 255,-1038 },
 {   0,  62 }, {   0,12086 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-1295 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-257 },
 {  49,-257 }, {  50,-257 }, {  51,-257 }, {  52,-257 }, {  53,-257 },
 {  54,-257 }, {  55,-257 }, {  56,-1295 }, {  57,-1295 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,-1295 }, {  66,-1295 }, {  67,-1295 }, {  68,-1295 },
 {  69,-1295 }, {  70,-1295 }, {  71,-1295 }, {  72,-1295 }, {  73,-1295 },
 {  74,-1295 }, {  75,-1295 }, {  76,-1295 }, {  77,-1295 }, {  78,-1295 },
 {  79,-1295 }, {  80,-1295 }, {  81,-1295 }, {  82,-1295 }, {  83,-1295 },
 {  84,-1295 }, {  85,-1295 }, {  86,-1295 }, {  87,-1295 }, {  88,-1295 },
 {  89,-1295 }, {  90,-1295 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-1295 }, {   0,   0 }, {  97,-1295 }, {  98,-1295 },
 {  99,-1295 }, { 100,-1295 }, { 101,-1295 }, { 102,-1295 }, { 103,-1295 },
 { 104,-1295 }, { 105,-1295 }, { 106,-1295 }, { 107,-1295 }, { 108,-1295 },
 { 109,-1295 }, { 110,-1295 }, { 111,-1295 }, { 112,-1295 }, { 113,-1295 },

 { 114,-1295 }, { 115,-1295 }, { 116,-1295 }, { 117,-1295 }, { 118,-1295 },
 { 119,-1295 }, { 120,-1295 }, { 121,-1295 }, { 122,-1295 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1295 },
 { 129,-1295 }, { 130,-1295 }, { 131,-1295 }, { 132,-1295 }, { 133,-1295 },
 { 134,-1295 }, { 135,-1295 }, { 136,-1295 }, { 137,-1295 }, { 138,-1295 },
 { 139,-1295 }, { 140,-1295 }, { 141,-1295 }, { 142,-1295 }, { 143,-1295 },
 { 144,-1295 }, { 145,-1295 }, { 146,-1295 }, { 147,-1295 }, { 148,-1295 },
 { 149,-1295 }, { 150,-1295 }, { 151,-1295 }, { 152,-1295 }, { 153,-1295 },
 { 154,-1295 }, { 155,-1295 }, { 156,-1295 }, { 157,-1295 }, { 158,-1295 },
 { 159,-1295 }, { 160,-1295 }, { 161,-1295 }, { 162,-1295 }, { 163,-1295 },

 { 164,-1295 }, { 165,-1295 }, { 166,-1295 }, { 167,-1295 }, { 168,-1295 },
 { 169,-1295 }, { 170,-1295 }, { 171,-1295 }, { 172,-1295 }, { 173,-1295 },
 { 174,-1295 }, { 175,-1295 }, { 176,-1295 }, { 177,-1295 }, { 178,-1295 },
 { 179,-1295 }, { 180,-1295 }, { 181,-1295 }, { 182,-1295 }, { 183,-1295 },
 { 184,-1295 }, { 185,-1295 }, { 186,-1295 }, { 187,-1295 }, { 188,-1295 },
 { 189,-1295 }, { 190,-1295 }, { 191,-1295 }, { 192,-1295 }, { 193,-1295 },
 { 194,-1295 }, { 195,-1295 }, { 196,-1295 }, { 197,-1295 }, { 198,-1295 },
 { 199,-1295 }, { 200,-1295 }, { 201,-1295 }, { 202,-1295 }, { 203,-1295 },
 { 204,-1295 }, { 205,-1295 }, { 206,-1295 }, { 207,-1295 }, { 208,-1295 },
 { 209,-1295 }, { 210,-1295 }, { 211,-1295 }, { 212,-1295 }, { 213,-1295 },

 { 214,-1295 }, { 215,-1295 }, { 216,-1295 }, { 217,-1295 }, { 218,-1295 },
 { 219,-1295 }, { 220,-1295 }, { 221,-1295 }, { 222,-1295 }, { 223,-1295 },
 { 224,-1295 }, { 225,-1295 }, { 226,-1295 }, { 227,-1295 }, { 228,-1295 },
 { 229,-1295 }, { 230,-1295 }, { 231,-1295 }, { 232,-1295 }, { 233,-1295 },
 { 234,-1295 }, { 235,-1295 }, { 236,-1295 }, { 237,-1295 }, { 238,-1295 },
 { 239,-1295 }, { 240,-1295 }, { 241,-1295 }, { 242,-1295 }, { 243,-1295 },
 { 244,-1295 }, { 245,-1295 }, { 246,-1295 }, { 247,-1295 }, { 248,-1295 },
 { 249,-1295 }, { 250,-1295 }, { 251,-1295 }, { 252,-1295 }, { 253,-1295 },
 { 254,-1295 }, { 255,-1295 }, {   0,  58 }, {   0,11829 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-1552 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },

 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,-1552 },
 {  72,-1552 }, {  73,-1552 }, {  74,-1552 }, {  75,-1552 }, {  76,-1552 },
 {  77,-1552 }, {  78,-1552 }, {  79,-1552 }, {  80,-1552 }, {  81,-1552 },
 {  82,-1552 }, {  83,-1552 }, {  84,-1552 }, {  85,-1552 }, {  86,-1552 },
 {  87,-1552 }, {  88,-1552 }, {  89,-1552 }, {  90,-1552 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4098 }, {   0,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,-1552 }, { 104,-1552 }, { 105,-1552 }, { 106,-1552 },

 { 107,-1552 }, { 108,-1552 }, { 109,-1552 }, { 110,-1552 }, { 111,-1552 },
 { 112,-1552 }, { 113,-1552 }, { 114,-1552 }, { 115,-1552 }, { 116,-1552 },
 { 117,-1552 }, { 118,-1552 }, { 119,-1552 }, { 120,-1552 }, { 121,-1552 },
 { 122,-1552 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-1552 }, { 129,-1552 }, { 130,-1552 }, { 131,-1552 },
 { 132,-1552 }, { 133,-1552 }, { 134,-1552 }, { 135,-1552 }, { 136,-1552 },
 { 137,-1552 }, { 138,-1552 }, { 139,-1552 }, { 140,-1552 }, { 141,-1552 },
 { 142,-1552 }, { 143,-1552 }, { 144,-1552 }, { 145,-1552 }, { 146,-1552 },
 { 147,-1552 }, { 148,-1552 }, { 149,-1552 }, { 150,-1552 }, { 151,-1552 },
 { 152,-1552 }, { 153,-1552 }, { 154,-1552 }, { 155,-1552 }, { 156,-1552 },

 { 157,-1552 }, { 158,-1552 }, { 159,-1552 }, { 160,-1552 }, { 161,-1552 },
 { 162,-1552 }, { 163,-1552 }, { 164,-1552 }, { 165,-1552 }, { 166,-1552 },
 { 167,-1552 }, { 168,-1552 }, { 169,-1552 }, { 170,-1552 }, { 171,-1552 },
 { 172,-1552 }, { 173,-1552 }, { 174,-1552 }, { 175,-1552 }, { 176,-1552 },
 { 177,-1552 }, { 178,-1552 }, { 179,-1552 }, { 180,-1552 }, { 181,-1552 },
 { 182,-1552 }, { 183,-1552 }, { 184,-1552 }, { 185,-1552 }, { 186,-1552 },
 { 187,-1552 }, { 188,-1552 }, { 189,-1552 }, { 190,-1552 }, { 191,-1552 },
 { 192,-1552 }, { 193,-1552 }, { 194,-1552 }, { 195,-1552 }, { 196,-1552 },
 { 197,-1552 }, { 198,-1552 }, { 199,-1552 }, { 200,-1552 }, { 201,-1552 },
 { 202,-1552 }, { 203,-1552 }, { 204,-1552 }, { 205,-1552 }, { 206,-1552 },

 { 207,-1552 }, { 208,-1552 }, { 209,-1552 }, { 210,-1552 }, { 211,-1552 },
 { 212,-1552 }, { 213,-1552 }, { 214,-1552 }, { 215,-1552 }, { 216,-1552 },
 { 217,-1552 }, { 218,-1552 }, { 219,-1552 }, { 220,-1552 }, { 221,-1552 },
 { 222,-1552 }, { 223,-1552 }, { 224,-1552 }, { 225,-1552 }, { 226,-1552 },
 { 227,-1552 }, { 228,-1552 }, { 229,-1552 }, { 230,-1552 }, { 231,-1552 },
 { 232,-1552 }, { 233,-1552 }, { 234,-1552 }, { 235,-1552 }, { 236,-1552 },
 { 237,-1552 }, { 238,-1552 }, { 239,-1552 }, { 240,-1552 }, { 241,-1552 },
 { 242,-1552 }, { 243,-1552 }, { 244,-1552 }, { 245,-1552 }, { 246,-1552 },
 { 247,-1552 }, { 248,-1552 }, { 249,-1552 }, { 250,-1552 }, { 251,-1552 },
 { 252,-1552 }, { 253,-1552 }, { 254,-1552 }, { 255,-1552 }, {   0,  61 },

 {   0,11572 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-1809 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-257 }, {  49,-257 },

 {  50,-257 }, {  51,-257 }, {  52,-257 }, {  53,-257 }, {  54,-257 },
 {  55,-257 }, {  56,-257 }, {  57,-257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-257 }, {  66,-257 }, {  67,-257 }, {  68,-257 }, {  69,-257 },
 {  70,-257 }, {  71,-1809 }, {  72,-1809 }, {  73,-1809 }, {  74,-1809 },
 {  75,-1809 }, {  76,-1809 }, {  77,-1809 }, {  78,-1809 }, {  79,-1809 },
 {  80,-1809 }, {  81,-1809 }, {  82,-1809 }, {  83,-1809 }, {  84,-1809 },
 {  85,-1809 }, {  86,-1809 }, {  87,-1809 }, {  88,-1809 }, {  89,-1809 },
 {  90,-1809 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-1809 }, {   0,   0 }, {  97,-257 }, {  98,-257 }, {  99,-257 },

 { 100,-257 }, { 101,-257 }, { 102,-257 }, { 103,-1809 }, { 104,-1809 },
 { 105,-1809 }, { 106,-1809 }, { 107,-1809 }, { 108,-1809 }, { 109,-1809 },
 { 110,-1809 }, { 111,-1809 }, { 112,-1809 }, { 113,-1809 }, { 114,-1809 },
 { 115,-1809 }, { 116,-1809 }, { 117,-1809 }, { 118,-1809 }, { 119,-1809 },
 { 120,-1809 }, { 121,-1809 }, { 122,-1809 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1809 }, { 129,-1809 },
 { 130,-1809 }, { 131,-1809 }, { 132,-1809 }, { 133,-1809 }, { 134,-1809 },
 { 135,-1809 }, { 136,-1809 }, { 137,-1809 }, { 138,-1809 }, { 139,-1809 },
 { 140,-1809 }, { 141,-1809 }, { 142,-1809 }, { 143,-1809 }, { 144,-1809 },
 { 145,-1809 }, { 146,-1809 }, { 147,-1809 }, { 148,-1809 }, { 149,-1809 },

 { 150,-1809 }, { 151,-1809 }, { 152,-1809 }, { 153,-1809 }, { 154,-1809 },
 { 155,-1809 }, { 156,-1809 }, { 157,-1809 }, { 158,-1809 }, { 159,-1809 },
 { 160,-1809 }, { 161,-1809 }, { 162,-1809 }, { 163,-1809 }, { 164,-1809 },
 { 165,-1809 }, { 166,-1809 }, { 167,-1809 }, { 168,-1809 }, { 169,-1809 },
 { 170,-1809 }, { 171,-1809 }, { 172,-1809 }, { 173,-1809 }, { 174,-1809 },
 { 175,-1809 }, { 176,-1809 }, { 177,-1809 }, { 178,-1809 }, { 179,-1809 },
 { 180,-1809 }, { 181,-1809 }, { 182,-1809 }, { 183,-1809 }, { 184,-1809 },
 { 185,-1809 }, { 186,-1809 }, { 187,-1809 }, { 188,-1809 }, { 189,-1809 },
 { 190,-1809 }, { 191,-1809 }, { 192,-1809 }, { 193,-1809 }, { 194,-1809 },
 { 195,-1809 }, { 196,-1809 }, { 197,-1809 }, { 198,-1809 }, { 199,-1809 },

 { 200,-1809 }, { 201,-1809 }, { 202,-1809 }, { 203,-1809 }, { 204,-1809 },
 { 205,-1809 }, { 206,-1809 }, { 207,-1809 }, { 208,-1809 }, { 209,-1809 },
 { 210,-1809 }, { 211,-1809 }, { 212,-1809 }, { 213,-1809 }, { 214,-1809 },
 { 215,-1809 }, { 216,-1809 }, { 217,-1809 }, { 218,-1809 }, { 219,-1809 },
 { 220,-1809 }, { 221,-1809 }, { 222,-1809 }, { 223,-1809 }, { 224,-1809 },
 { 225,-1809 }, { 226,-1809 }, { 227,-1809 }, { 228,-1809 }, { 229,-1809 },
 { 230,-1809 }, { 231,-1809 }, { 232,-1809 }, { 233,-1809 }, { 234,-1809 },
 { 235,-1809 }, { 236,-1809 }, { 237,-1809 }, { 238,-1809 }, { 239,-1809 },
 { 240,-1809 }, { 241,-1809 }, { 242,-1809 }, { 243,-1809 }, { 244,-1809 },
 { 245,-1809 }, { 246,-1809 }, { 247,-1809 }, { 248,-1809 }, { 249,-1809 },

 { 250,-1809 }, { 251,-1809 }, { 252,-1809 }, { 253,-1809 }, { 254,-1809 },
 { 255,-1809 }, {   0,  57 }, {   0,11315 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-2066 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,-9175 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,3841 }, {  66,3841 }, {  67,3841 },
 {  68,3841 }, {  69,4098 }, {  70,3841 }, {  71,3841 }, {  72,3841 },
 {  73,3841 }, {  74,3841 }, {  75,3841 }, {  76,3841 }, {  77,3841 },
 {  78,3841 }, {  79,3841 }, {  80,3841 }, {  81,3841 }, {  82,3841 },
 {  83,3841 }, {  84,3841 }, {  85,3841 }, {  86,3841 }, {  87,3841 },
 {  88,3841 }, {  89,3841 }, {  90,3841 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  95,4355 }, {   0,   0 }, {  97,3841 },
 {  98,3841 }, {  99,3841 }, { 100,3841 }, { 101,4098 }, { 102,3841 },
 { 103,3841 }, { 104,3841 }, { 105,3841 }, { 106,3841 }, { 107,3841 },
 { 108,3841 }, { 109,3841 }, { 110,3841 }, { 111,3841 }, { 112,3841 },
 { 113,3841 }, { 114,3841 }, { 115,3841 }, { 116,3841 }, { 117,3841 },
 { 118,3841 }, { 119,3841 }, { 120,3841 }, { 121,3841 }, { 122,3841 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,3841 }, { 129,3841 }, { 130,3841 }, { 131,3841 }, { 132,3841 },
 { 133,3841 }, { 134,3841 }, { 135,3841 }, { 136,3841 }, { 137,3841 },
 { 138,3841 }, { 139,3841 }, { 140,3841 }, { 141,3841 }, { 142,3841 },

 { 143,3841 }, { 144,3841 }, { 145,3841 }, { 146,3841 }, { 147,3841 },
 { 148,3841 }, { 149,3841 }, { 150,3841 }, { 151,3841 }, { 152,3841 },
 { 153,3841 }, { 154,3841 }, { 155,3841 }, { 156,3841 }, { 157,3841 },
 { 158,3841 }, { 159,3841 }, { 160,3841 }, { 161,3841 }, { 162,3841 },
 { 163,3841 }, { 164,3841 }, { 165,3841 }, { 166,3841 }, { 167,3841 },
 { 168,3841 }, { 169,3841 }, { 170,3841 }, { 171,3841 }, { 172,3841 },
 { 173,3841 }, { 174,3841 }, { 175,3841 }, { 176,3841 }, { 177,3841 },
 { 178,3841 }, { 179,3841 }, { 180,3841 }, { 181,3841 }, { 182,3841 },
 { 183,3841 }, { 184,3841 }, { 185,3841 }, { 186,3841 }, { 187,3841 },
 { 188,3841 }, { 189,3841 }, { 190,3841 }, { 191,3841 }, { 192,3841 },

 { 193,3841 }, { 194,3841 }, { 195,3841 }, { 196,3841 }, { 197,3841 },
 { 198,3841 }, { 199,3841 }, { 200,3841 }, { 201,3841 }, { 202,3841 },
 { 203,3841 }, { 204,3841 }, { 205,3841 }, { 206,3841 }, { 207,3841 },
 { 208,3841 }, { 209,3841 }, { 210,3841 }, { 211,3841 }, { 212,3841 },
 { 213,3841 }, { 214,3841 }, { 215,3841 }, { 216,3841 }, { 217,3841 },
 { 218,3841 }, { 219,3841 }, { 220,3841 }, { 221,3841 }, { 222,3841 },
 { 223,3841 }, { 224,3841 }, { 225,3841 }, { 226,3841 }, { 227,3841 },
 { 228,3841 }, { 229,3841 }, { 230,3841 }, { 231,3841 }, { 232,3841 },
 { 233,3841 }, { 234,3841 }, { 235,3841 }, { 236,3841 }, { 237,3841 },
 { 238,3841 }, { 239,3841 }, { 240,3841 }, { 241,3841 }, { 242,3841 },

 { 243,3841 }, { 244,3841 }, { 245,3841 }, { 246,3841 }, { 247,3841 },
 { 248,3841 }, { 249,3841 }, { 250,3841 }, { 251,3841 }, { 252,3841 },
 { 253,3841 }, { 254,3841 }, { 255,3841 }, {   0,   4 }, {   0,11058 },
 {   0,  30 }, {   0,11056 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0,11041 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },

 {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,   0 }, {  43,   0 }, {   0,   0 }, {  45,   0 },
 {   0,   0 }, {  47,   0 }, {   0,   0 }, {   0,   0 }, {  48,-15747 },
 {  49,-15747 }, {  50,-15747 }, {  51,-15747 }, {  52,-15747 }, {  53,-15747 },
 {  54,-15747 }, {  55,-15747 }, {   0,   0 }, {   0,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  48,4338 },
 {  49,4338 }, {  50,4338 }, {  51,4338 }, {  52,4338 }, {  53,4338 },
 {  54,4338 }, {  55,4338 }, {  56,4338 }, {  57,4338 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,10979 }, {   0,   0 },
 {   0,   0 }, {  65,4338 }, {  66,4338 }, {  67,4338 }, {  68,4338 },

 {  69,4338 }, {  70,4338 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 }, {   0,   0 },
 {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  31 }, {   0,10956 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,4338 }, {  98,4338 },
 {  99,4338 }, { 100,4338 }, { 101,4338 }, { 102,4338 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,   0 }, {   0,   0 },
 { 126,   0 }, {  48,4299 }, {  49,4299 }, {  50,4299 }, {  51,4299 },
 {  52,4299 }, {  53,4299 }, {  54,4299 }, {  55,4299 }, {  56,4299 },

 {  57,4299 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4299 }, {  66,4299 },
 {  67,4299 }, {  68,4299 }, {  69,4299 }, {  70,4299 }, {  48,-15833 },
 {  49,-15833 }, {  50,-15833 }, {  51,-15833 }, {  52,-15833 }, {  53,-15833 },
 {  54,-15833 }, {  55,-15833 }, {  56,-15833 }, {  57,-15833 }, {   0,  37 },
 {   0,10897 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-15833 }, {  66,-15833 }, {  67,-15833 }, {  68,-15833 },
 {  69,-15833 }, {  70,-15833 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,4299 }, {  98,4299 }, {  99,4299 }, { 100,4299 }, { 101,4299 },
 { 102,4299 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-15933 }, {   0,   0 }, {  97,-15833 }, {  98,-15833 },
 {  99,-15833 }, { 100,-15833 }, { 101,-15833 }, { 102,-15833 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },

 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },

 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },

 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, {   0,  28 }, {   0,10640 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 },
 {   0,10617 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,3998 }, {  49,3998 }, {  50,3998 }, {  51,3998 }, {  52,3998 },
 {  53,3998 }, {  54,3998 }, {  55,3998 }, {  56,3998 }, {  57,3998 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,3998 }, {  66,3998 }, {  67,3998 },

 {  68,3998 }, {  69,3998 }, {  70,3998 }, {  48,3998 }, {  49,3998 },
 {  50,3998 }, {  51,3998 }, {  52,3998 }, {  53,3998 }, {  54,3998 },
 {  55,3998 }, {  56,3998 }, {  57,3998 }, {   0,  69 }, {   0,10558 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,3998 }, {  66,3998 }, {  67,3998 }, {  68,3998 }, {  69,3998 },
 {  70,3998 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,3998 },
 {  98,3998 }, {  99,3998 }, { 100,3998 }, { 101,3998 }, { 102,3998 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  36,   0 }, {   0,   0 }, {  97,3998 }, {  98,3998 }, {  99,3998 },
 { 100,3998 }, { 101,3998 }, { 102,3998 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },

 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 },
 {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },

 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },

 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },

 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 {   0,  66 }, {   0,10301 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3741 },
 {  49,3741 }, {  50,3741 }, {  51,3741 }, {  52,3741 }, {  53,3741 },
 {  54,3741 }, {  55,3741 }, {  56,3741 }, {  57,3741 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,3998 }, {  66,3998 }, {  67,3998 }, {  68,3998 },
 {  69,3998 }, {  70,3998 }, {  71,3998 }, {  72,3998 }, {  73,3998 },
 {  74,3998 }, {  75,3998 }, {  76,3998 }, {  77,3998 }, {  78,3998 },

 {  79,3998 }, {  80,3998 }, {  81,3998 }, {  82,3998 }, {  83,3998 },
 {  84,3998 }, {  85,3998 }, {  86,3998 }, {  87,3998 }, {  88,3998 },
 {  89,3998 }, {  90,3998 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,4255 }, {   0,   0 }, {  97,3998 }, {  98,3998 },
 {  99,3998 }, { 100,3998 }, { 101,3998 }, { 102,3998 }, { 103,3998 },
 { 104,3998 }, { 105,3998 }, { 106,3998 }, { 107,3998 }, { 108,3998 },
 { 109,3998 }, { 110,3998 }, { 111,3998 }, { 112,3998 }, { 113,3998 },
 { 114,3998 }, { 115,3998 }, { 116,3998 }, { 117,3998 }, { 118,3998 },
 { 119,3998 }, { 120,3998 }, { 121,3998 }, { 122,3998 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,3998 },

 { 129,3998 }, { 130,3998 }, { 131,3998 }, { 132,3998 }, { 133,3998 },
 { 134,3998 }, { 135,3998 }, { 136,3998 }, { 137,3998 }, { 138,3998 },
 { 139,3998 }, { 140,3998 }, { 141,3998 }, { 142,3998 }, { 143,3998 },
 { 144,3998 }, { 145,3998 }, { 146,3998 }, { 147,3998 }, { 148,3998 },
 { 149,3998 }, { 150,3998 }, { 151,3998 }, { 152,3998 }, { 153,3998 },
 { 154,3998 }, { 155,3998 }, { 156,3998 }, { 157,3998 }, { 158,3998 },
 { 159,3998 }, { 160,3998 }, { 161,3998 }, { 162,3998 }, { 163,3998 },
 { 164,3998 }, { 165,3998 }, { 166,3998 }, { 167,3998 }, { 168,3998 },
 { 169,3998 }, { 170,3998 }, { 171,3998 }, { 172,3998 }, { 173,3998 },
 { 174,3998 }, { 175,3998 }, { 176,3998 }, { 177,3998 }, { 178,3998 },

 { 179,3998 }, { 180,3998 }, { 181,3998 }, { 182,3998 }, { 183,3998 },
 { 184,3998 }, { 185,3998 }, { 186,3998 }, { 187,3998 }, { 188,3998 },
 { 189,3998 }, { 190,3998 }, { 191,3998 }, { 192,3998 }, { 193,3998 },
 { 194,3998 }, { 195,3998 }, { 196,3998 }, { 197,3998 }, { 198,3998 },
 { 199,3998 }, { 200,3998 }, { 201,3998 }, { 202,3998 }, { 203,3998 },
 { 204,3998 }, { 205,3998 }, { 206,3998 }, { 207,3998 }, { 208,3998 },
 { 209,3998 }, { 210,3998 }, { 211,3998 }, { 212,3998 }, { 213,3998 },
 { 214,3998 }, { 215,3998 }, { 216,3998 }, { 217,3998 }, { 218,3998 },
 { 219,3998 }, { 220,3998 }, { 221,3998 }, { 222,3998 }, { 223,3998 },
 { 224,3998 }, { 225,3998 }, { 226,3998 }, { 227,3998 }, { 228,3998 },

 { 229,3998 }, { 230,3998 }, { 231,3998 }, { 232,3998 }, { 233,3998 },
 { 234,3998 }, { 235,3998 }, { 236,3998 }, { 237,3998 }, { 238,3998 },
 { 239,3998 }, { 240,3998 }, { 241,3998 }, { 242,3998 }, { 243,3998 },
 { 244,3998 }, { 245,3998 }, { 246,3998 }, { 247,3998 }, { 248,3998 },
 { 249,3998 }, { 250,3998 }, { 251,3998 }, { 252,3998 }, { 253,3998 },
 { 254,3998 }, { 255,3998 }, {   0,  64 }, {   0,10044 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-514 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4255 }, {  66,4255 },
 {  67,4255 }, {  68,4255 }, {  69,4512 }, {  70,4255 }, {  71,4255 },

 {  72,4255 }, {  73,4255 }, {  74,4255 }, {  75,4255 }, {  76,4255 },
 {  77,4255 }, {  78,4255 }, {  79,4255 }, {  80,4255 }, {  81,4255 },
 {  82,4255 }, {  83,4255 }, {  84,4255 }, {  85,4255 }, {  86,4255 },
 {  87,4255 }, {  88,4255 }, {  89,4255 }, {  90,4255 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4769 }, {   0,   0 },
 {  97,4255 }, {  98,4255 }, {  99,4255 }, { 100,4255 }, { 101,4512 },
 { 102,4255 }, { 103,4255 }, { 104,4255 }, { 105,4255 }, { 106,4255 },
 { 107,4255 }, { 108,4255 }, { 109,4255 }, { 110,4255 }, { 111,4255 },
 { 112,4255 }, { 113,4255 }, { 114,4255 }, { 115,4255 }, { 116,4255 },
 { 117,4255 }, { 118,4255 }, { 119,4255 }, { 120,4255 }, { 121,4255 },

 { 122,4255 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,4255 }, { 129,4255 }, { 130,4255 }, { 131,4255 },
 { 132,4255 }, { 133,4255 }, { 134,4255 }, { 135,4255 }, { 136,4255 },
 { 137,4255 }, { 138,4255 }, { 139,4255 }, { 140,4255 }, { 141,4255 },
 { 142,4255 }, { 143,4255 }, { 144,4255 }, { 145,4255 }, { 146,4255 },
 { 147,4255 }, { 148,4255 }, { 149,4255 }, { 150,4255 }, { 151,4255 },
 { 152,4255 }, { 153,4255 }, { 154,4255 }, { 155,4255 }, { 156,4255 },
 { 157,4255 }, { 158,4255 }, { 159,4255 }, { 160,4255 }, { 161,4255 },
 { 162,4255 }, { 163,4255 }, { 164,4255 }, { 165,4255 }, { 166,4255 },
 { 167,4255 }, { 168,4255 }, { 169,4255 }, { 170,4255 }, { 171,4255 },

 { 172,4255 }, { 173,4255 }, { 174,4255 }, { 175,4255 }, { 176,4255 },
 { 177,4255 }, { 178,4255 }, { 179,4255 }, { 180,4255 }, { 181,4255 },
 { 182,4255 }, { 183,4255 }, { 184,4255 }, { 185,4255 }, { 186,4255 },
 { 187,4255 }, { 188,4255 }, { 189,4255 }, { 190,4255 }, { 191,4255 },
 { 192,4255 }, { 193,4255 }, { 194,4255 }, { 195,4255 }, { 196,4255 },
 { 197,4255 }, { 198,4255 }, { 199,4255 }, { 200,4255 }, { 201,4255 },
 { 202,4255 }, { 203,4255 }, { 204,4255 }, { 205,4255 }, { 206,4255 },
 { 207,4255 }, { 208,4255 }, { 209,4255 }, { 210,4255 }, { 211,4255 },
 { 212,4255 }, { 213,4255 }, { 214,4255 }, { 215,4255 }, { 216,4255 },
 { 217,4255 }, { 218,4255 }, { 219,4255 }, { 220,4255 }, { 221,4255 },

 { 222,4255 }, { 223,4255 }, { 224,4255 }, { 225,4255 }, { 226,4255 },
 { 227,4255 }, { 228,4255 }, { 229,4255 }, { 230,4255 }, { 231,4255 },
 { 232,4255 }, { 233,4255 }, { 234,4255 }, { 235,4255 }, { 236,4255 },
 { 237,4255 }, { 238,4255 }, { 239,4255 }, { 240,4255 }, { 241,4255 },
 { 242,4255 }, { 243,4255 }, { 244,4255 }, { 245,4255 }, { 246,4255 },
 { 247,4255 }, { 248,4255 }, { 249,4255 }, { 250,4255 }, { 251,4255 },
 { 252,4255 }, { 253,4255 }, { 254,4255 }, { 255,4255 }, {   0,  64 },
 {   0,9787 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  65,-4654 }, {  66,-4654 }, {  67,-4654 }, {  68,-4654 }, {  69,-4397 },
 {  70,-4654 }, {  71,-4654 }, {  72,-4654 }, {  73,-4654 }, {  74,-4654 },
 {  75,-4654 }, {  76,-4654 }, {  77,-4654 }, {  78,-4654 }, {  79,-4654 },
 {  80,-4654 }, {  81,-4654 }, {  82,-4654 }, {  83,-4654 }, {  84,-4654 },
 {  85,-4654 }, {  86,-4654 }, {  87,-4654 }, {  88,-4654 }, {  89,-4654 },
 {  90,-4654 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95, 257 }, {   0,   0 }, {  97,-4654 }, {  98,-4654 }, {  99,-4654 },
 { 100,-4654 }, { 101,-4397 }, { 102,-4654 }, { 103,-4654 }, { 104,-4654 },
 { 105,-4654 }, { 106,-4654 }, { 107,-4654 }, { 108,-4654 }, { 109,-4654 },
 { 110,-4654 }, { 111,-4654 }, { 112,-4654 }, { 113,-4654 }, { 114,-4654 },

 { 115,-4654 }, { 116,-4654 }, { 117,-4654 }, { 118,-4654 }, { 119,-4654 },
 { 120,-4654 }, { 121,-4654 }, { 122,-4654 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-4654 }, { 129,-4654 },
 { 130,-4654 }, { 131,-4654 }, { 132,-4654 }, { 133,-4654 }, { 134,-4654 },
 { 135,-4654 }, { 136,-4654 }, { 137,-4654 }, { 138,-4654 }, { 139,-4654 },
 { 140,-4654 }, { 141,-4654 }, { 142,-4654 }, { 143,-4654 }, { 144,-4654 },
 { 145,-4654 }, { 146,-4654 }, { 147,-4654 }, { 148,-4654 }, { 149,-4654 },
 { 150,-4654 }, { 151,-4654 }, { 152,-4654 }, { 153,-4654 }, { 154,-4654 },
 { 155,-4654 }, { 156,-4654 }, { 157,-4654 }, { 158,-4654 }, { 159,-4654 },
 { 160,-4654 }, { 161,-4654 }, { 162,-4654 }, { 163,-4654 }, { 164,-4654 },

 { 165,-4654 }, { 166,-4654 }, { 167,-4654 }, { 168,-4654 }, { 169,-4654 },
 { 170,-4654 }, { 171,-4654 }, { 172,-4654 }, { 173,-4654 }, { 174,-4654 },
 { 175,-4654 }, { 176,-4654 }, { 177,-4654 }, { 178,-4654 }, { 179,-4654 },
 { 180,-4654 }, { 181,-4654 }, { 182,-4654 }, { 183,-4654 }, { 184,-4654 },
 { 185,-4654 }, { 186,-4654 }, { 187,-4654 }, { 188,-4654 }, { 189,-4654 },
 { 190,-4654 }, { 191,-4654 }, { 192,-4654 }, { 193,-4654 }, { 194,-4654 },
 { 195,-4654 }, { 196,-4654 }, { 197,-4654 }, { 198,-4654 }, { 199,-4654 },
 { 200,-4654 }, { 201,-4654 }, { 202,-4654 }, { 203,-4654 }, { 204,-4654 },
 { 205,-4654 }, { 206,-4654 }, { 207,-4654 }, { 208,-4654 }, { 209,-4654 },
 { 210,-4654 }, { 211,-4654 }, { 212,-4654 }, { 213,-4654 }, { 214,-4654 },

 { 215,-4654 }, { 216,-4654 }, { 217,-4654 }, { 218,-4654 }, { 219,-4654 },
 { 220,-4654 }, { 221,-4654 }, { 222,-4654 }, { 223,-4654 }, { 224,-4654 },
 { 225,-4654 }, { 226,-4654 }, { 227,-4654 }, { 228,-4654 }, { 229,-4654 },
 { 230,-4654 }, { 231,-4654 }, { 232,-4654 }, { 233,-4654 }, { 234,-4654 },
 { 235,-4654 }, { 236,-4654 }, { 237,-4654 }, { 238,-4654 }, { 239,-4654 },
 { 240,-4654 }, { 241,-4654 }, { 242,-4654 }, { 243,-4654 }, { 244,-4654 },
 { 245,-4654 }, { 246,-4654 }, { 247,-4654 }, { 248,-4654 }, { 249,-4654 },
 { 250,-4654 }, { 251,-4654 }, { 252,-4654 }, { 253,-4654 }, { 254,-4654 },
 { 255,-4654 }, {   0,  69 }, {   0,9530 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-1028 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,4512 }, {  49,4512 }, {  50,4512 }, {  51,4512 }, {  52,4512 },
 {  53,4512 }, {  54,4512 }, {  55,4512 }, {  56,4512 }, {  57,4512 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-1028 }, {  66,-1028 }, {  67,-1028 },
 {  68,-1028 }, {  69,-1028 }, {  70,-1028 }, {  71,-1028 }, {  72,-1028 },
 {  73,-1028 }, {  74,-1028 }, {  75,-1028 }, {  76,-1028 }, {  77,-1028 },
 {  78,-1028 }, {  79,-1028 }, {  80,-1028 }, {  81,-1028 }, {  82,-1028 },
 {  83,-1028 }, {  84,-1028 }, {  85,-1028 }, {  86,-1028 }, {  87,-1028 },
 {  88,-1028 }, {  89,-1028 }, {  90,-1028 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-1028 }, {   0,   0 }, {  97,-1028 },
 {  98,-1028 }, {  99,-1028 }, { 100,-1028 }, { 101,-1028 }, { 102,-1028 },
 { 103,-1028 }, { 104,-1028 }, { 105,-1028 }, { 106,-1028 }, { 107,-1028 },

 { 108,-1028 }, { 109,-1028 }, { 110,-1028 }, { 111,-1028 }, { 112,-1028 },
 { 113,-1028 }, { 114,-1028 }, { 115,-1028 }, { 116,-1028 }, { 117,-1028 },
 { 118,-1028 }, { 119,-1028 }, { 120,-1028 }, { 121,-1028 }, { 122,-1028 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-1028 }, { 129,-1028 }, { 130,-1028 }, { 131,-1028 }, { 132,-1028 },
 { 133,-1028 }, { 134,-1028 }, { 135,-1028 }, { 136,-1028 }, { 137,-1028 },
 { 138,-1028 }, { 139,-1028 }, { 140,-1028 }, { 141,-1028 }, { 142,-1028 },
 { 143,-1028 }, { 144,-1028 }, { 145,-1028 }, { 146,-1028 }, { 147,-1028 },
 { 148,-1028 }, { 149,-1028 }, { 150,-1028 }, { 151,-1028 }, { 152,-1028 },
 { 153,-1028 }, { 154,-1028 }, { 155,-1028 }, { 156,-1028 }, { 157,-1028 },

 { 158,-1028 }, { 159,-1028 }, { 160,-1028 }, { 161,-1028 }, { 162,-1028 },
 { 163,-1028 }, { 164,-1028 }, { 165,-1028 }, { 166,-1028 }, { 167,-1028 },
 { 168,-1028 }, { 169,-1028 }, { 170,-1028 }, { 171,-1028 }, { 172,-1028 },
 { 173,-1028 }, { 174,-1028 }, { 175,-1028 }, { 176,-1028 }, { 177,-1028 },
 { 178,-1028 }, { 179,-1028 }, { 180,-1028 }, { 181,-1028 }, { 182,-1028 },
 { 183,-1028 }, { 184,-1028 }, { 185,-1028 }, { 186,-1028 }, { 187,-1028 },
 { 188,-1028 }, { 189,-1028 }, { 190,-1028 }, { 191,-1028 }, { 192,-1028 },
 { 193,-1028 }, { 194,-1028 }, { 195,-1028 }, { 196,-1028 }, { 197,-1028 },
 { 198,-1028 }, { 199,-1028 }, { 200,-1028 }, { 201,-1028 }, { 202,-1028 },
 { 203,-1028 }, { 204,-1028 }, { 205,-1028 }, { 206,-1028 }, { 207,-1028 },

 { 208,-1028 }, { 209,-1028 }, { 210,-1028 }, { 211,-1028 }, { 212,-1028 },
 { 213,-1028 }, { 214,-1028 }, { 215,-1028 }, { 216,-1028 }, { 217,-1028 },
 { 218,-1028 }, { 219,-1028 }, { 220,-1028 }, { 221,-1028 }, { 222,-1028 },
 { 223,-1028 }, { 224,-1028 }, { 225,-1028 }, { 226,-1028 }, { 227,-1028 },
 { 228,-1028 }, { 229,-1028 }, { 230,-1028 }, { 231,-1028 }, { 232,-1028 },
 { 233,-1028 }, { 234,-1028 }, { 235,-1028 }, { 236,-1028 }, { 237,-1028 },
 { 238,-1028 }, { 239,-1028 }, { 240,-1028 }, { 241,-1028 }, { 242,-1028 },
 { 243,-1028 }, { 244,-1028 }, { 245,-1028 }, { 246,-1028 }, { 247,-1028 },
 { 248,-1028 }, { 249,-1028 }, { 250,-1028 }, { 251,-1028 }, { 252,-1028 },
 { 253,-1028 }, { 254,-1028 }, { 255,-1028 }, {   0,  68 }, {   0,9273 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-4108 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-3851 }, {  49,-3851 }, {  50,-4108 },

 {  51,-4108 }, {  52,-4108 }, {  53,-4108 }, {  54,-4108 }, {  55,-4108 },
 {  56,-4108 }, {  57,-4108 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-4108 },
 {  66,-4108 }, {  67,-4108 }, {  68,-4108 }, {  69,-4108 }, {  70,-4108 },
 {  71,-4108 }, {  72,-4108 }, {  73,-4108 }, {  74,-4108 }, {  75,-4108 },
 {  76,-4108 }, {  77,-4108 }, {  78,-4108 }, {  79,-4108 }, {  80,-4108 },
 {  81,-4108 }, {  82,-4108 }, {  83,-4108 }, {  84,-4108 }, {  85,-4108 },
 {  86,-4108 }, {  87,-4108 }, {  88,-4108 }, {  89,-4108 }, {  90,-4108 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-4108 },
 {   0,   0 }, {  97,-4108 }, {  98,-4108 }, {  99,-4108 }, { 100,-4108 },

 { 101,-4108 }, { 102,-4108 }, { 103,-4108 }, { 104,-4108 }, { 105,-4108 },
 { 106,-4108 }, { 107,-4108 }, { 108,-4108 }, { 109,-4108 }, { 110,-4108 },
 { 111,-4108 }, { 112,-4108 }, { 113,-4108 }, { 114,-4108 }, { 115,-4108 },
 { 116,-4108 }, { 117,-4108 }, { 118,-4108 }, { 119,-4108 }, { 120,-4108 },
 { 121,-4108 }, { 122,-4108 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-4108 }, { 129,-4108 }, { 130,-4108 },
 { 131,-4108 }, { 132,-4108 }, { 133,-4108 }, { 134,-4108 }, { 135,-4108 },
 { 136,-4108 }, { 137,-4108 }, { 138,-4108 }, { 139,-4108 }, { 140,-4108 },
 { 141,-4108 }, { 142,-4108 }, { 143,-4108 }, { 144,-4108 }, { 145,-4108 },
 { 146,-4108 }, { 147,-4108 }, { 148,-4108 }, { 149,-4108 }, { 150,-4108 },

 { 151,-4108 }, { 152,-4108 }, { 153,-4108 }, { 154,-4108 }, { 155,-4108 },
 { 156,-4108 }, { 157,-4108 }, { 158,-4108 }, { 159,-4108 }, { 160,-4108 },
 { 161,-4108 }, { 162,-4108 }, { 163,-4108 }, { 164,-4108 }, { 165,-4108 },
 { 166,-4108 }, { 167,-4108 }, { 168,-4108 }, { 169,-4108 }, { 170,-4108 },
 { 171,-4108 }, { 172,-4108 }, { 173,-4108 }, { 174,-4108 }, { 175,-4108 },
 { 176,-4108 }, { 177,-4108 }, { 178,-4108 }, { 179,-4108 }, { 180,-4108 },
 { 181,-4108 }, { 182,-4108 }, { 183,-4108 }, { 184,-4108 }, { 185,-4108 },
 { 186,-4108 }, { 187,-4108 }, { 188,-4108 }, { 189,-4108 }, { 190,-4108 },
 { 191,-4108 }, { 192,-4108 }, { 193,-4108 }, { 194,-4108 }, { 195,-4108 },
 { 196,-4108 }, { 197,-4108 }, { 198,-4108 }, { 199,-4108 }, { 200,-4108 },

 { 201,-4108 }, { 202,-4108 }, { 203,-4108 }, { 204,-4108 }, { 205,-4108 },
 { 206,-4108 }, { 207,-4108 }, { 208,-4108 }, { 209,-4108 }, { 210,-4108 },
 { 211,-4108 }, { 212,-4108 }, { 213,-4108 }, { 214,-4108 }, { 215,-4108 },
 { 216,-4108 }, { 217,-4108 }, { 218,-4108 }, { 219,-4108 }, { 220,-4108 },
 { 221,-4108 }, { 222,-4108 }, { 223,-4108 }, { 224,-4108 }, { 225,-4108 },
 { 226,-4108 }, { 227,-4108 }, { 228,-4108 }, { 229,-4108 }, { 230,-4108 },
 { 231,-4108 }, { 232,-4108 }, { 233,-4108 }, { 234,-4108 }, { 235,-4108 },
 { 236,-4108 }, { 237,-4108 }, { 238,-4108 }, { 239,-4108 }, { 240,-4108 },
 { 241,-4108 }, { 242,-4108 }, { 243,-4108 }, { 244,-4108 }, { 245,-4108 },
 { 246,-4108 }, { 247,-4108 }, { 248,-4108 }, { 249,-4108 }, { 250,-4108 },

 { 251,-4108 }, { 252,-4108 }, { 253,-4108 }, { 254,-4108 }, { 255,-4108 },
 {   0,  66 }, {   0,9016 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4255 },
 {  49,4255 }, {  50,4255 }, {  51,4255 }, {  52,4255 }, {  53,4255 },
 {  54,4255 }, {  55,4255 }, {  56,4255 }, {  57,4255 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,4512 }, {  66,4512 }, {  67,4512 }, {  68,4512 },
 {  69,4512 }, {  70,4512 }, {  71,4512 }, {  72,4512 }, {  73,4512 },
 {  74,4512 }, {  75,4512 }, {  76,4512 }, {  77,4512 }, {  78,4512 },
 {  79,4512 }, {  80,4512 }, {  81,4512 }, {  82,4512 }, {  83,4512 },
 {  84,4512 }, {  85,4512 }, {  86,4512 }, {  87,4512 }, {  88,4512 },
 {  89,4512 }, {  90,4512 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  95,4769 }, {   0,   0 }, {  97,4512 }, {  98,4512 },
 {  99,4512 }, { 100,4512 }, { 101,4512 }, { 102,4512 }, { 103,4512 },
 { 104,4512 }, { 105,4512 }, { 106,4512 }, { 107,4512 }, { 108,4512 },
 { 109,4512 }, { 110,4512 }, { 111,4512 }, { 112,4512 }, { 113,4512 },
 { 114,4512 }, { 115,4512 }, { 116,4512 }, { 117,4512 }, { 118,4512 },
 { 119,4512 }, { 120,4512 }, { 121,4512 }, { 122,4512 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4512 },
 { 129,4512 }, { 130,4512 }, { 131,4512 }, { 132,4512 }, { 133,4512 },
 { 134,4512 }, { 135,4512 }, { 136,4512 }, { 137,4512 }, { 138,4512 },
 { 139,4512 }, { 140,4512 }, { 141,4512 }, { 142,4512 }, { 143,4512 },

 { 144,4512 }, { 145,4512 }, { 146,4512 }, { 147,4512 }, { 148,4512 },
 { 149,4512 }, { 150,4512 }, { 151,4512 }, { 152,4512 }, { 153,4512 },
 { 154,4512 }, { 155,4512 }, { 156,4512 }, { 157,4512 }, { 158,4512 },
 { 159,4512 }, { 160,4512 }, { 161,4512 }, { 162,4512 }, { 163,4512 },
 { 164,4512 }, { 165,4512 }, { 166,4512 }, { 167,4512 }, { 168,4512 },
 { 169,4512 }, { 170,4512 }, { 171,4512 }, { 172,4512 }, { 173,4512 },
 { 174,4512 }, { 175,4512 }, { 176,4512 }, { 177,4512 }, { 178,4512 },
 { 179,4512 }, { 180,4512 }, { 181,4512 }, { 182,4512 }, { 183,4512 },
 { 184,4512 }, { 185,4512 }, { 186,4512 }, { 187,4512 }, { 188,4512 },
 { 189,4512 }, { 190,4512 }, { 191,4512 }, { 192,4512 }, { 193,4512 },

 { 194,4512 }, { 195,4512 }, { 196,4512 }, { 197,4512 }, { 198,4512 },
 { 199,4512 }, { 200,4512 }, { 201,4512 }, { 202,4512 }, { 203,4512 },
 { 204,4512 }, { 205,4512 }, { 206,4512 }, { 207,4512 }, { 208,4512 },
 { 209,4512 }, { 210,4512 }, { 211,4512 }, { 212,4512 }, { 213,4512 },
 { 214,4512 }, { 215,4512 }, { 216,4512 }, { 217,4512 }, { 218,4512 },
 { 219,4512 }, { 220,4512 }, { 221,4512 }, { 222,4512 }, { 223,4512 },
 { 224,4512 }, { 225,4512 }, { 226,4512 }, { 227,4512 }, { 228,4512 },
 { 229,4512 }, { 230,4512 }, { 231,4512 }, { 232,4512 }, { 233,4512 },
 { 234,4512 }, { 235,4512 }, { 236,4512 }, { 237,4512 }, { 238,4512 },
 { 239,4512 }, { 240,4512 }, { 241,4512 }, { 242,4512 }, { 243,4512 },

 { 244,4512 }, { 245,4512 }, { 246,4512 }, { 247,4512 }, { 248,4512 },
 { 249,4512 }, { 250,4512 }, { 251,4512 }, { 252,4512 }, { 253,4512 },
 { 254,4512 }, { 255,4512 }, {   0,  66 }, {   0,8759 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-4622 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 257 }, {  66, 257 },
 {  67, 257 }, {  68, 257 }, {  69, 257 }, {  70, 257 }, {  71, 257 },
 {  72, 257 }, {  73, 257 }, {  74, 257 }, {  75, 257 }, {  76, 257 },
 {  77, 257 }, {  78, 257 }, {  79, 257 }, {  80, 257 }, {  81, 257 },
 {  82, 257 }, {  83, 257 }, {  84, 257 }, {  85, 257 }, {  86, 257 },

 {  87, 257 }, {  88, 257 }, {  89, 257 }, {  90, 257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95, 514 }, {   0,   0 },
 {  97, 257 }, {  98, 257 }, {  99, 257 }, { 100, 257 }, { 101, 257 },
 { 102, 257 }, { 103, 257 }, { 104, 257 }, { 105, 257 }, { 106, 257 },
 { 107, 257 }, { 108, 257 }, { 109, 257 }, { 110, 257 }, { 111, 257 },
 { 112, 257 }, { 113, 257 }, { 114, 257 }, { 115, 257 }, { 116, 257 },
 { 117, 257 }, { 118, 257 }, { 119, 257 }, { 120, 257 }, { 121, 257 },
 { 122, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128, 257 }, { 129, 257 }, { 130, 257 }, { 131, 257 },
 { 132, 257 }, { 133, 257 }, { 134, 257 }, { 135, 257 }, { 136, 257 },

 { 137, 257 }, { 138, 257 }, { 139, 257 }, { 140, 257 }, { 141, 257 },
 { 142, 257 }, { 143, 257 }, { 144, 257 }, { 145, 257 }, { 146, 257 },
 { 147, 257 }, { 148, 257 }, { 149, 257 }, { 150, 257 }, { 151, 257 },
 { 152, 257 }, { 153, 257 }, { 154, 257 }, { 155, 257 }, { 156, 257 },
 { 157, 257 }, { 158, 257 }, { 159, 257 }, { 160, 257 }, { 161, 257 },
 { 162, 257 }, { 163, 257 }, { 164, 257 }, { 165, 257 }, { 166, 257 },
 { 167, 257 }, { 168, 257 }, { 169, 257 }, { 170, 257 }, { 171, 257 },
 { 172, 257 }, { 173, 257 }, { 174, 257 }, { 175, 257 }, { 176, 257 },
 { 177, 257 }, { 178, 257 }, { 179, 257 }, { 180, 257 }, { 181, 257 },
 { 182, 257 }, { 183, 257 }, { 184, 257 }, { 185, 257 }, { 186, 257 },

 { 187, 257 }, { 188, 257 }, { 189, 257 }, { 190, 257 }, { 191, 257 },
 { 192, 257 }, { 193, 257 }, { 194, 257 }, { 195, 257 }, { 196, 257 },
 { 197, 257 }, { 198, 257 }, { 199, 257 }, { 200, 257 }, { 201, 257 },
 { 202, 257 }, { 203, 257 }, { 204, 257 }, { 205, 257 }, { 206, 257 },
 { 207, 257 }, { 208, 257 }, { 209, 257 }, { 210, 257 }, { 211, 257 },
 { 212, 257 }, { 213, 257 }, { 214, 257 }, { 215, 257 }, { 216, 257 },
 { 217, 257 }, { 218, 257 }, { 219, 257 }, { 220, 257 }, { 221, 257 },
 { 222, 257 }, { 223, 257 }, { 224, 257 }, { 225, 257 }, { 226, 257 },
 { 227, 257 }, { 228, 257 }, { 229, 257 }, { 230, 257 }, { 231, 257 },
 { 232, 257 }, { 233, 257 }, { 234, 257 }, { 235, 257 }, { 236, 257 },

 { 237, 257 }, { 238, 257 }, { 239, 257 }, { 240, 257 }, { 241, 257 },
 { 242, 257 }, { 243, 257 }, { 244, 257 }, { 245, 257 }, { 246, 257 },
 { 247, 257 }, { 248, 257 }, { 249, 257 }, { 250, 257 }, { 251, 257 },
 { 252, 257 }, { 253, 257 }, { 254, 257 }, { 255, 257 }, {   0,  68 },
 {   0,8502 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,4512 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4512 }, {  49,4512 },
 {  50,4512 }, {  51,4512 }, {  52,4512 }, {  53,4512 }, {  54,4512 },
 {  55,4512 }, {  56,4512 }, {  57,4512 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4512 }, {  66,4512 }, {  67,4512 }, {  68,4512 }, {  69,4512 },
 {  70,4512 }, {  71,4512 }, {  72,4512 }, {  73,4512 }, {  74,4512 },
 {  75,4512 }, {  76,4512 }, {  77,4512 }, {  78,4512 }, {  79,4512 },

 {  80,4512 }, {  81,4512 }, {  82,4512 }, {  83,4512 }, {  84,4512 },
 {  85,4512 }, {  86,4512 }, {  87,4512 }, {  88,4512 }, {  89,4512 },
 {  90,4512 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,4512 }, {   0,   0 }, {  97,4512 }, {  98,4512 }, {  99,4512 },
 { 100,4512 }, { 101,4512 }, { 102,4512 }, { 103,4512 }, { 104,4512 },
 { 105,4512 }, { 106,4512 }, { 107,4512 }, { 108,4512 }, { 109,4512 },
 { 110,4512 }, { 111,4512 }, { 112,4512 }, { 113,4512 }, { 114,4512 },
 { 115,4512 }, { 116,4512 }, { 117,4512 }, { 118,4512 }, { 119,4512 },
 { 120,4512 }, { 121,4512 }, { 122,4512 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4512 }, { 129,4512 },

 { 130,4512 }, { 131,4512 }, { 132,4512 }, { 133,4512 }, { 134,4512 },
 { 135,4512 }, { 136,4512 }, { 137,4512 }, { 138,4512 }, { 139,4512 },
 { 140,4512 }, { 141,4512 }, { 142,4512 }, { 143,4512 }, { 144,4512 },
 { 145,4512 }, { 146,4512 }, { 147,4512 }, { 148,4512 }, { 149,4512 },
 { 150,4512 }, { 151,4512 }, { 152,4512 }, { 153,4512 }, { 154,4512 },
 { 155,4512 }, { 156,4512 }, { 157,4512 }, { 158,4512 }, { 159,4512 },
 { 160,4512 }, { 161,4512 }, { 162,4512 }, { 163,4512 }, { 164,4512 },
 { 165,4512 }, { 166,4512 }, { 167,4512 }, { 168,4512 }, { 169,4512 },
 { 170,4512 }, { 171,4512 }, { 172,4512 }, { 173,4512 }, { 174,4512 },
 { 175,4512 }, { 176,4512 }, { 177,4512 }, { 178,4512 }, { 179,4512 },

 { 180,4512 }, { 181,4512 }, { 182,4512 }, { 183,4512 }, { 184,4512 },
 { 185,4512 }, { 186,4512 }, { 187,4512 }, { 188,4512 }, { 189,4512 },
 { 190,4512 }, { 191,4512 }, { 192,4512 }, { 193,4512 }, { 194,4512 },
 { 195,4512 }, { 196,4512 }, { 197,4512 }, { 198,4512 }, { 199,4512 },
 { 200,4512 }, { 201,4512 }, { 202,4512 }, { 203,4512 }, { 204,4512 },
 { 205,4512 }, { 206,4512 }, { 207,4512 }, { 208,4512 }, { 209,4512 },
 { 210,4512 }, { 211,4512 }, { 212,4512 }, { 213,4512 }, { 214,4512 },
 { 215,4512 }, { 216,4512 }, { 217,4512 }, { 218,4512 }, { 219,4512 },
 { 220,4512 }, { 221,4512 }, { 222,4512 }, { 223,4512 }, { 224,4512 },
 { 225,4512 }, { 226,4512 }, { 227,4512 }, { 228,4512 }, { 229,4512 },

 { 230,4512 }, { 231,4512 }, { 232,4512 }, { 233,4512 }, { 234,4512 },
 { 235,4512 }, { 236,4512 }, { 237,4512 }, { 238,4512 }, { 239,4512 },
 { 240,4512 }, { 241,4512 }, { 242,4512 }, { 243,4512 }, { 244,4512 },
 { 245,4512 }, { 246,4512 }, { 247,4512 }, { 248,4512 }, { 249,4512 },
 { 250,4512 }, { 251,4512 }, { 252,4512 }, { 253,4512 }, { 254,4512 },
 { 255,4512 }, {   0,  68 }, {   0,8245 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,4255 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,4512 }, {  49,4512 }, {  50,4512 }, {  51,4512 }, {  52,4512 },
 {  53,4512 }, {  54,4512 }, {  55,4512 }, {  56,4512 }, {  57,4512 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,4255 }, {  66,4255 }, {  67,4255 },
 {  68,4255 }, {  69,4255 }, {  70,4255 }, {  71,4255 }, {  72,4255 },

 {  73,4255 }, {  74,4255 }, {  75,4255 }, {  76,4255 }, {  77,4255 },
 {  78,4255 }, {  79,4255 }, {  80,4255 }, {  81,4255 }, {  82,4255 },
 {  83,4255 }, {  84,4255 }, {  85,4255 }, {  86,4255 }, {  87,4255 },
 {  88,4255 }, {  89,4255 }, {  90,4255 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,4255 }, {   0,   0 }, {  97,4255 },
 {  98,4255 }, {  99,4255 }, { 100,4255 }, { 101,4255 }, { 102,4255 },
 { 103,4255 }, { 104,4255 }, { 105,4255 }, { 106,4255 }, { 107,4255 },
 { 108,4255 }, { 109,4255 }, { 110,4255 }, { 111,4255 }, { 112,4255 },
 { 113,4255 }, { 114,4255 }, { 115,4255 }, { 116,4255 }, { 117,4255 },
 { 118,4255 }, { 119,4255 }, { 120,4255 }, { 121,4255 }, { 122,4255 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,4255 }, { 129,4255 }, { 130,4255 }, { 131,4255 }, { 132,4255 },
 { 133,4255 }, { 134,4255 }, { 135,4255 }, { 136,4255 }, { 137,4255 },
 { 138,4255 }, { 139,4255 }, { 140,4255 }, { 141,4255 }, { 142,4255 },
 { 143,4255 }, { 144,4255 }, { 145,4255 }, { 146,4255 }, { 147,4255 },
 { 148,4255 }, { 149,4255 }, { 150,4255 }, { 151,4255 }, { 152,4255 },
 { 153,4255 }, { 154,4255 }, { 155,4255 }, { 156,4255 }, { 157,4255 },
 { 158,4255 }, { 159,4255 }, { 160,4255 }, { 161,4255 }, { 162,4255 },
 { 163,4255 }, { 164,4255 }, { 165,4255 }, { 166,4255 }, { 167,4255 },
 { 168,4255 }, { 169,4255 }, { 170,4255 }, { 171,4255 }, { 172,4255 },

 { 173,4255 }, { 174,4255 }, { 175,4255 }, { 176,4255 }, { 177,4255 },
 { 178,4255 }, { 179,4255 }, { 180,4255 }, { 181,4255 }, { 182,4255 },
 { 183,4255 }, { 184,4255 }, { 185,4255 }, { 186,4255 }, { 187,4255 },
 { 188,4255 }, { 189,4255 }, { 190,4255 }, { 191,4255 }, { 192,4255 },
 { 193,4255 }, { 194,4255 }, { 195,4255 }, { 196,4255 }, { 197,4255 },
 { 198,4255 }, { 199,4255 }, { 200,4255 }, { 201,4255 }, { 202,4255 },
 { 203,4255 }, { 204,4255 }, { 205,4255 }, { 206,4255 }, { 207,4255 },
 { 208,4255 }, { 209,4255 }, { 210,4255 }, { 211,4255 }, { 212,4255 },
 { 213,4255 }, { 214,4255 }, { 215,4255 }, { 216,4255 }, { 217,4255 },
 { 218,4255 }, { 219,4255 }, { 220,4255 }, { 221,4255 }, { 222,4255 },

 { 223,4255 }, { 224,4255 }, { 225,4255 }, { 226,4255 }, { 227,4255 },
 { 228,4255 }, { 229,4255 }, { 230,4255 }, { 231,4255 }, { 232,4255 },
 { 233,4255 }, { 234,4255 }, { 235,4255 }, { 236,4255 }, { 237,4255 },
 { 238,4255 }, { 239,4255 }, { 240,4255 }, { 241,4255 }, { 242,4255 },
 { 243,4255 }, { 244,4255 }, { 245,4255 }, { 246,4255 }, { 247,4255 },
 { 248,4255 }, { 249,4255 }, { 250,4255 }, { 251,4255 }, { 252,4255 },
 { 253,4255 }, { 254,4255 }, { 255,4255 }, {   0,  68 }, {   0,7988 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-5393 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-4355 }, {  49,-4355 }, {  50,-4355 },
 {  51,-4355 }, {  52,-4355 }, {  53,-4355 }, {  54,-4355 }, {  55,-4355 },
 {  56,-5393 }, {  57,-5393 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-5393 },

 {  66,-5393 }, {  67,-5393 }, {  68,-5393 }, {  69,-5393 }, {  70,-5393 },
 {  71,-5393 }, {  72,-5393 }, {  73,-5393 }, {  74,-5393 }, {  75,-5393 },
 {  76,-5393 }, {  77,-5393 }, {  78,-5393 }, {  79,-5393 }, {  80,-5393 },
 {  81,-5393 }, {  82,-5393 }, {  83,-5393 }, {  84,-5393 }, {  85,-5393 },
 {  86,-5393 }, {  87,-5393 }, {  88,-5393 }, {  89,-5393 }, {  90,-5393 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-5393 },
 {   0,   0 }, {  97,-5393 }, {  98,-5393 }, {  99,-5393 }, { 100,-5393 },
 { 101,-5393 }, { 102,-5393 }, { 103,-5393 }, { 104,-5393 }, { 105,-5393 },
 { 106,-5393 }, { 107,-5393 }, { 108,-5393 }, { 109,-5393 }, { 110,-5393 },
 { 111,-5393 }, { 112,-5393 }, { 113,-5393 }, { 114,-5393 }, { 115,-5393 },

 { 116,-5393 }, { 117,-5393 }, { 118,-5393 }, { 119,-5393 }, { 120,-5393 },
 { 121,-5393 }, { 122,-5393 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-5393 }, { 129,-5393 }, { 130,-5393 },
 { 131,-5393 }, { 132,-5393 }, { 133,-5393 }, { 134,-5393 }, { 135,-5393 },
 { 136,-5393 }, { 137,-5393 }, { 138,-5393 }, { 139,-5393 }, { 140,-5393 },
 { 141,-5393 }, { 142,-5393 }, { 143,-5393 }, { 144,-5393 }, { 145,-5393 },
 { 146,-5393 }, { 147,-5393 }, { 148,-5393 }, { 149,-5393 }, { 150,-5393 },
 { 151,-5393 }, { 152,-5393 }, { 153,-5393 }, { 154,-5393 }, { 155,-5393 },
 { 156,-5393 }, { 157,-5393 }, { 158,-5393 }, { 159,-5393 }, { 160,-5393 },
 { 161,-5393 }, { 162,-5393 }, { 163,-5393 }, { 164,-5393 }, { 165,-5393 },

 { 166,-5393 }, { 167,-5393 }, { 168,-5393 }, { 169,-5393 }, { 170,-5393 },
 { 171,-5393 }, { 172,-5393 }, { 173,-5393 }, { 174,-5393 }, { 175,-5393 },
 { 176,-5393 }, { 177,-5393 }, { 178,-5393 }, { 179,-5393 }, { 180,-5393 },
 { 181,-5393 }, { 182,-5393 }, { 183,-5393 }, { 184,-5393 }, { 185,-5393 },
 { 186,-5393 }, { 187,-5393 }, { 188,-5393 }, { 189,-5393 }, { 190,-5393 },
 { 191,-5393 }, { 192,-5393 }, { 193,-5393 }, { 194,-5393 }, { 195,-5393 },
 { 196,-5393 }, { 197,-5393 }, { 198,-5393 }, { 199,-5393 }, { 200,-5393 },
 { 201,-5393 }, { 202,-5393 }, { 203,-5393 }, { 204,-5393 }, { 205,-5393 },
 { 206,-5393 }, { 207,-5393 }, { 208,-5393 }, { 209,-5393 }, { 210,-5393 },
 { 211,-5393 }, { 212,-5393 }, { 213,-5393 }, { 214,-5393 }, { 215,-5393 },

 { 216,-5393 }, { 217,-5393 }, { 218,-5393 }, { 219,-5393 }, { 220,-5393 },
 { 221,-5393 }, { 222,-5393 }, { 223,-5393 }, { 224,-5393 }, { 225,-5393 },
 { 226,-5393 }, { 227,-5393 }, { 228,-5393 }, { 229,-5393 }, { 230,-5393 },
 { 231,-5393 }, { 232,-5393 }, { 233,-5393 }, { 234,-5393 }, { 235,-5393 },
 { 236,-5393 }, { 237,-5393 }, { 238,-5393 }, { 239,-5393 }, { 240,-5393 },
 { 241,-5393 }, { 242,-5393 }, { 243,-5393 }, { 244,-5393 }, { 245,-5393 },
 { 246,-5393 }, { 247,-5393 }, { 248,-5393 }, { 249,-5393 }, { 250,-5393 },
 { 251,-5393 }, { 252,-5393 }, { 253,-5393 }, { 254,-5393 }, { 255,-5393 },
 {   0,  68 }, {   0,7731 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-5650 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-4098 },
 {  49,-4098 }, {  50,-4098 }, {  51,-4098 }, {  52,-4098 }, {  53,-4098 },
 {  54,-4098 }, {  55,-4098 }, {  56,-4098 }, {  57,-4098 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-4098 }, {  66,-4098 }, {  67,-4098 }, {  68,-4098 },
 {  69,-4098 }, {  70,-4098 }, {  71,-5650 }, {  72,-5650 }, {  73,-5650 },
 {  74,-5650 }, {  75,-5650 }, {  76,-5650 }, {  77,-5650 }, {  78,-5650 },
 {  79,-5650 }, {  80,-5650 }, {  81,-5650 }, {  82,-5650 }, {  83,-5650 },
 {  84,-5650 }, {  85,-5650 }, {  86,-5650 }, {  87,-5650 }, {  88,-5650 },
 {  89,-5650 }, {  90,-5650 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-5650 }, {   0,   0 }, {  97,-4098 }, {  98,-4098 },
 {  99,-4098 }, { 100,-4098 }, { 101,-4098 }, { 102,-4098 }, { 103,-5650 },
 { 104,-5650 }, { 105,-5650 }, { 106,-5650 }, { 107,-5650 }, { 108,-5650 },

 { 109,-5650 }, { 110,-5650 }, { 111,-5650 }, { 112,-5650 }, { 113,-5650 },
 { 114,-5650 }, { 115,-5650 }, { 116,-5650 }, { 117,-5650 }, { 118,-5650 },
 { 119,-5650 }, { 120,-5650 }, { 121,-5650 }, { 122,-5650 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-5650 },
 { 129,-5650 }, { 130,-5650 }, { 131,-5650 }, { 132,-5650 }, { 133,-5650 },
 { 134,-5650 }, { 135,-5650 }, { 136,-5650 }, { 137,-5650 }, { 138,-5650 },
 { 139,-5650 }, { 140,-5650 }, { 141,-5650 }, { 142,-5650 }, { 143,-5650 },
 { 144,-5650 }, { 145,-5650 }, { 146,-5650 }, { 147,-5650 }, { 148,-5650 },
 { 149,-5650 }, { 150,-5650 }, { 151,-5650 }, { 152,-5650 }, { 153,-5650 },
 { 154,-5650 }, { 155,-5650 }, { 156,-5650 }, { 157,-5650 }, { 158,-5650 },

 { 159,-5650 }, { 160,-5650 }, { 161,-5650 }, { 162,-5650 }, { 163,-5650 },
 { 164,-5650 }, { 165,-5650 }, { 166,-5650 }, { 167,-5650 }, { 168,-5650 },
 { 169,-5650 }, { 170,-5650 }, { 171,-5650 }, { 172,-5650 }, { 173,-5650 },
 { 174,-5650 }, { 175,-5650 }, { 176,-5650 }, { 177,-5650 }, { 178,-5650 },
 { 179,-5650 }, { 180,-5650 }, { 181,-5650 }, { 182,-5650 }, { 183,-5650 },
 { 184,-5650 }, { 185,-5650 }, { 186,-5650 }, { 187,-5650 }, { 188,-5650 },
 { 189,-5650 }, { 190,-5650 }, { 191,-5650 }, { 192,-5650 }, { 193,-5650 },
 { 194,-5650 }, { 195,-5650 }, { 196,-5650 }, { 197,-5650 }, { 198,-5650 },
 { 199,-5650 }, { 200,-5650 }, { 201,-5650 }, { 202,-5650 }, { 203,-5650 },
 { 204,-5650 }, { 205,-5650 }, { 206,-5650 }, { 207,-5650 }, { 208,-5650 },

 { 209,-5650 }, { 210,-5650 }, { 211,-5650 }, { 212,-5650 }, { 213,-5650 },
 { 214,-5650 }, { 215,-5650 }, { 216,-5650 }, { 217,-5650 }, { 218,-5650 },
 { 219,-5650 }, { 220,-5650 }, { 221,-5650 }, { 222,-5650 }, { 223,-5650 },
 { 224,-5650 }, { 225,-5650 }, { 226,-5650 }, { 227,-5650 }, { 228,-5650 },
 { 229,-5650 }, { 230,-5650 }, { 231,-5650 }, { 232,-5650 }, { 233,-5650 },
 { 234,-5650 }, { 235,-5650 }, { 236,-5650 }, { 237,-5650 }, { 238,-5650 },
 { 239,-5650 }, { 240,-5650 }, { 241,-5650 }, { 242,-5650 }, { 243,-5650 },
 { 244,-5650 }, { 245,-5650 }, { 246,-5650 }, { 247,-5650 }, { 248,-5650 },
 { 249,-5650 }, { 250,-5650 }, { 251,-5650 }, { 252,-5650 }, { 253,-5650 },
 { 254,-5650 }, { 255,-5650 }, {   0,  68 }, {   0,7474 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-5907 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,-5907 }, {  49,-5907 }, {  50,-5907 }, {  51,-5907 },

 {  52,-5907 }, {  53,-5907 }, {  54,-5907 }, {  55,-5907 }, {  56,-5907 },
 {  57,-5907 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-5907 }, {  66,-5907 },
 {  67,-5907 }, {  68,-5907 }, {  69,-5907 }, {  70,-5907 }, {  71,-5907 },
 {  72,-5907 }, {  73,-5907 }, {  74,-5907 }, {  75,-5907 }, {  76,-5907 },
 {  77,-5907 }, {  78,-5907 }, {  79,-5907 }, {  80,-5907 }, {  81,-5907 },
 {  82,-5907 }, {  83,-5907 }, {  84,-5907 }, {  85,-5907 }, {  86,-5907 },
 {  87,-5907 }, {  88,-5907 }, {  89,-5907 }, {  90,-5907 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-5907 }, {   0,   0 },
 {  97,-5907 }, {  98,-5907 }, {  99,-5907 }, { 100,-5907 }, { 101,-5907 },

 { 102,-5907 }, { 103,-5907 }, { 104,-5907 }, { 105,-5907 }, { 106,-5907 },
 { 107,-5907 }, { 108,-5907 }, { 109,-5907 }, { 110,-5907 }, { 111,-5907 },
 { 112,-5907 }, { 113,-5907 }, { 114,-5907 }, { 115,-5907 }, { 116,-5907 },
 { 117,-5907 }, { 118,-5907 }, { 119,-5907 }, { 120,-5907 }, { 121,-5907 },
 { 122,-5907 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-5907 }, { 129,-5907 }, { 130,-5907 }, { 131,-5907 },
 { 132,-5907 }, { 133,-5907 }, { 134,-5907 }, { 135,-5907 }, { 136,-5907 },
 { 137,-5907 }, { 138,-5907 }, { 139,-5907 }, { 140,-5907 }, { 141,-5907 },
 { 142,-5907 }, { 143,-5907 }, { 144,-5907 }, { 145,-5907 }, { 146,-5907 },
 { 147,-5907 }, { 148,-5907 }, { 149,-5907 }, { 150,-5907 }, { 151,-5907 },

 { 152,-5907 }, { 153,-5907 }, { 154,-5907 }, { 155,-5907 }, { 156,-5907 },
 { 157,-5907 }, { 158,-5907 }, { 159,-5907 }, { 160,-5907 }, { 161,-5907 },
 { 162,-5907 }, { 163,-5907 }, { 164,-5907 }, { 165,-5907 }, { 166,-5907 },
 { 167,-5907 }, { 168,-5907 }, { 169,-5907 }, { 170,-5907 }, { 171,-5907 },
 { 172,-5907 }, { 173,-5907 }, { 174,-5907 }, { 175,-5907 }, { 176,-5907 },
 { 177,-5907 }, { 178,-5907 }, { 179,-5907 }, { 180,-5907 }, { 181,-5907 },
 { 182,-5907 }, { 183,-5907 }, { 184,-5907 }, { 185,-5907 }, { 186,-5907 },
 { 187,-5907 }, { 188,-5907 }, { 189,-5907 }, { 190,-5907 }, { 191,-5907 },
 { 192,-5907 }, { 193,-5907 }, { 194,-5907 }, { 195,-5907 }, { 196,-5907 },
 { 197,-5907 }, { 198,-5907 }, { 199,-5907 }, { 200,-5907 }, { 201,-5907 },

 { 202,-5907 }, { 203,-5907 }, { 204,-5907 }, { 205,-5907 }, { 206,-5907 },
 { 207,-5907 }, { 208,-5907 }, { 209,-5907 }, { 210,-5907 }, { 211,-5907 },
 { 212,-5907 }, { 213,-5907 }, { 214,-5907 }, { 215,-5907 }, { 216,-5907 },
 { 217,-5907 }, { 218,-5907 }, { 219,-5907 }, { 220,-5907 }, { 221,-5907 },
 { 222,-5907 }, { 223,-5907 }, { 224,-5907 }, { 225,-5907 }, { 226,-5907 },
 { 227,-5907 }, { 228,-5907 }, { 229,-5907 }, { 230,-5907 }, { 231,-5907 },
 { 232,-5907 }, { 233,-5907 }, { 234,-5907 }, { 235,-5907 }, { 236,-5907 },
 { 237,-5907 }, { 238,-5907 }, { 239,-5907 }, { 240,-5907 }, { 241,-5907 },
 { 242,-5907 }, { 243,-5907 }, { 244,-5907 }, { 245,-5907 }, { 246,-5907 },
 { 247,-5907 }, { 248,-5907 }, { 249,-5907 }, { 250,-5907 }, { 251,-5907 },

 { 252,-5907 }, { 253,-5907 }, { 254,-5907 }, { 255,-5907 }, {   0,  68 },
 {   0,7217 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-6164 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  43,-5393 }, {   0,   0 },

 {  45,-5393 }, {   0,   0 }, {   0,   0 }, {  48,-5383 }, {  49,-5383 },
 {  50,-5383 }, {  51,-5383 }, {  52,-5383 }, {  53,-5383 }, {  54,-5383 },
 {  55,-5383 }, {  56,-5383 }, {  57,-5383 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-6164 }, {  66,-6164 }, {  67,-6164 }, {  68,-6164 }, {  69,-6164 },
 {  70,-6164 }, {  71,-6164 }, {  72,-6164 }, {  73,-6164 }, {  74,-6164 },
 {  75,-6164 }, {  76,-6164 }, {  77,-6164 }, {  78,-6164 }, {  79,-6164 },
 {  80,-6164 }, {  81,-6164 }, {  82,-6164 }, {  83,-6164 }, {  84,-6164 },
 {  85,-6164 }, {  86,-6164 }, {  87,-6164 }, {  88,-6164 }, {  89,-6164 },
 {  90,-6164 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  95,-6164 }, {   0,   0 }, {  97,-6164 }, {  98,-6164 }, {  99,-6164 },
 { 100,-6164 }, { 101,-6164 }, { 102,-6164 }, { 103,-6164 }, { 104,-6164 },
 { 105,-6164 }, { 106,-6164 }, { 107,-6164 }, { 108,-6164 }, { 109,-6164 },
 { 110,-6164 }, { 111,-6164 }, { 112,-6164 }, { 113,-6164 }, { 114,-6164 },
 { 115,-6164 }, { 116,-6164 }, { 117,-6164 }, { 118,-6164 }, { 119,-6164 },
 { 120,-6164 }, { 121,-6164 }, { 122,-6164 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-6164 }, { 129,-6164 },
 { 130,-6164 }, { 131,-6164 }, { 132,-6164 }, { 133,-6164 }, { 134,-6164 },
 { 135,-6164 }, { 136,-6164 }, { 137,-6164 }, { 138,-6164 }, { 139,-6164 },
 { 140,-6164 }, { 141,-6164 }, { 142,-6164 }, { 143,-6164 }, { 144,-6164 },

 { 145,-6164 }, { 146,-6164 }, { 147,-6164 }, { 148,-6164 }, { 149,-6164 },
 { 150,-6164 }, { 151,-6164 }, { 152,-6164 }, { 153,-6164 }, { 154,-6164 },
 { 155,-6164 }, { 156,-6164 }, { 157,-6164 }, { 158,-6164 }, { 159,-6164 },
 { 160,-6164 }, { 161,-6164 }, { 162,-6164 }, { 163,-6164 }, { 164,-6164 },
 { 165,-6164 }, { 166,-6164 }, { 167,-6164 }, { 168,-6164 }, { 169,-6164 },
 { 170,-6164 }, { 171,-6164 }, { 172,-6164 }, { 173,-6164 }, { 174,-6164 },
 { 175,-6164 }, { 176,-6164 }, { 177,-6164 }, { 178,-6164 }, { 179,-6164 },
 { 180,-6164 }, { 181,-6164 }, { 182,-6164 }, { 183,-6164 }, { 184,-6164 },
 { 185,-6164 }, { 186,-6164 }, { 187,-6164 }, { 188,-6164 }, { 189,-6164 },
 { 190,-6164 }, { 191,-6164 }, { 192,-6164 }, { 193,-6164 }, { 194,-6164 },

 { 195,-6164 }, { 196,-6164 }, { 197,-6164 }, { 198,-6164 }, { 199,-6164 },
 { 200,-6164 }, { 201,-6164 }, { 202,-6164 }, { 203,-6164 }, { 204,-6164 },
 { 205,-6164 }, { 206,-6164 }, { 207,-6164 }, { 208,-6164 }, { 209,-6164 },
 { 210,-6164 }, { 211,-6164 }, { 212,-6164 }, { 213,-6164 }, { 214,-6164 },
 { 215,-6164 }, { 216,-6164 }, { 217,-6164 }, { 218,-6164 }, { 219,-6164 },
 { 220,-6164 }, { 221,-6164 }, { 222,-6164 }, { 223,-6164 }, { 224,-6164 },
 { 225,-6164 }, { 226,-6164 }, { 227,-6164 }, { 228,-6164 }, { 229,-6164 },
 { 230,-6164 }, { 231,-6164 }, { 232,-6164 }, { 233,-6164 }, { 234,-6164 },
 { 235,-6164 }, { 236,-6164 }, { 237,-6164 }, { 238,-6164 }, { 239,-6164 },
 { 240,-6164 }, { 241,-6164 }, { 242,-6164 }, { 243,-6164 }, { 244,-6164 },

 { 245,-6164 }, { 246,-6164 }, { 247,-6164 }, { 248,-6164 }, { 249,-6164 },
 { 250,-6164 }, { 251,-6164 }, { 252,-6164 }, { 253,-6164 }, { 254,-6164 },
 { 255,-6164 }, {   0,  68 }, {   0,6960 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-6421 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-4355 }, {  49,-4355 }, {  50,-4355 }, {  51,-4355 }, {  52,-4355 },
 {  53,-4355 }, {  54,-4355 }, {  55,-4355 }, {  56,-4355 }, {  57,-4355 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-6421 }, {  66,-6421 }, {  67,-6421 },
 {  68,-6421 }, {  69,-6421 }, {  70,-6421 }, {  71,-6421 }, {  72,-6421 },
 {  73,-6421 }, {  74,-6421 }, {  75,-6421 }, {  76,-6421 }, {  77,-6421 },
 {  78,-6421 }, {  79,-6421 }, {  80,-6421 }, {  81,-6421 }, {  82,-6421 },
 {  83,-6421 }, {  84,-6421 }, {  85,-6421 }, {  86,-6421 }, {  87,-6421 },

 {  88,-6421 }, {  89,-6421 }, {  90,-6421 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-6421 }, {   0,   0 }, {  97,-6421 },
 {  98,-6421 }, {  99,-6421 }, { 100,-6421 }, { 101,-6421 }, { 102,-6421 },
 { 103,-6421 }, { 104,-6421 }, { 105,-6421 }, { 106,-6421 }, { 107,-6421 },
 { 108,-6421 }, { 109,-6421 }, { 110,-6421 }, { 111,-6421 }, { 112,-6421 },
 { 113,-6421 }, { 114,-6421 }, { 115,-6421 }, { 116,-6421 }, { 117,-6421 },
 { 118,-6421 }, { 119,-6421 }, { 120,-6421 }, { 121,-6421 }, { 122,-6421 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-6421 }, { 129,-6421 }, { 130,-6421 }, { 131,-6421 }, { 132,-6421 },
 { 133,-6421 }, { 134,-6421 }, { 135,-6421 }, { 136,-6421 }, { 137,-6421 },

 { 138,-6421 }, { 139,-6421 }, { 140,-6421 }, { 141,-6421 }, { 142,-6421 },
 { 143,-6421 }, { 144,-6421 }, { 145,-6421 }, { 146,-6421 }, { 147,-6421 },
 { 148,-6421 }, { 149,-6421 }, { 150,-6421 }, { 151,-6421 }, { 152,-6421 },
 { 153,-6421 }, { 154,-6421 }, { 155,-6421 }, { 156,-6421 }, { 157,-6421 },
 { 158,-6421 }, { 159,-6421 }, { 160,-6421 }, { 161,-6421 }, { 162,-6421 },
 { 163,-6421 }, { 164,-6421 }, { 165,-6421 }, { 166,-6421 }, { 167,-6421 },
 { 168,-6421 }, { 169,-6421 }, { 170,-6421 }, { 171,-6421 }, { 172,-6421 },
 { 173,-6421 }, { 174,-6421 }, { 175,-6421 }, { 176,-6421 }, { 177,-6421 },
 { 178,-6421 }, { 179,-6421 }, { 180,-6421 }, { 181,-6421 }, { 182,-6421 },
 { 183,-6421 }, { 184,-6421 }, { 185,-6421 }, { 186,-6421 }, { 187,-6421 },

 { 188,-6421 }, { 189,-6421 }, { 190,-6421 }, { 191,-6421 }, { 192,-6421 },
 { 193,-6421 }, { 194,-6421 }, { 195,-6421 }, { 196,-6421 }, { 197,-6421 },
 { 198,-6421 }, { 199,-6421 }, { 200,-6421 }, { 201,-6421 }, { 202,-6421 },
 { 203,-6421 }, { 204,-6421 }, { 205,-6421 }, { 206,-6421 }, { 207,-6421 },
 { 208,-6421 }, { 209,-6421 }, { 210,-6421 }, { 211,-6421 }, { 212,-6421 },
 { 213,-6421 }, { 214,-6421 }, { 215,-6421 }, { 216,-6421 }, { 217,-6421 },
 { 218,-6421 }, { 219,-6421 }, { 220,-6421 }, { 221,-6421 }, { 222,-6421 },
 { 223,-6421 }, { 224,-6421 }, { 225,-6421 }, { 226,-6421 }, { 227,-6421 },
 { 228,-6421 }, { 229,-6421 }, { 230,-6421 }, { 231,-6421 }, { 232,-6421 },
 { 233,-6421 }, { 234,-6421 }, { 235,-6421 }, { 236,-6421 }, { 237,-6421 },

 { 238,-6421 }, { 239,-6421 }, { 240,-6421 }, { 241,-6421 }, { 242,-6421 },
 { 243,-6421 }, { 244,-6421 }, { 245,-6421 }, { 246,-6421 }, { 247,-6421 },
 { 248,-6421 }, { 249,-6421 }, { 250,-6421 }, { 251,-6421 }, { 252,-6421 },
 { 253,-6421 }, { 254,-6421 }, { 255,-6421 }, {   0,  28 }, {   0,6703 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0,6680 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,3227 }, {  49,3227 }, {  50,3227 },
 {  51,3227 }, {  52,3227 }, {  53,3227 }, {  54,3227 }, {  55,3227 },
 {  56,3227 }, {  57,3227 }, {   0,   0 }, {   0,   0 }, {   0,  28 },
 {   0,6642 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3227 },
 {  66,3227 }, {  67,3227 }, {  68,3227 }, {  69,3227 }, {  70,3227 },
 {  48,3227 }, {  49,3227 }, {  50,3227 }, {  51,3227 }, {  52,3227 },
 {  53,3227 }, {  54,3227 }, {  55,3227 }, {  56,3227 }, {  57,3227 },

 {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,6619 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,3227 }, {  66,3227 }, {  67,3227 },
 {  68,3227 }, {  69,3227 }, {  70,3227 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,3227 }, {  98,3227 }, {  99,3227 }, { 100,3227 },
 { 101,3227 }, { 102,3227 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,3227 }, {  49,3227 },
 {  50,3227 }, {  51,3227 }, {  52,3227 }, {  53,3227 }, {  54,3227 },
 {  55,3227 }, {  56,3227 }, {  57,3227 }, {   0,   0 }, {  97,3227 },
 {  98,3227 }, {  99,3227 }, { 100,3227 }, { 101,3227 }, { 102,3227 },
 {  65,3227 }, {  66,3227 }, {  67,3227 }, {  68,3227 }, {  69,3227 },

 {  70,3227 }, {  48,3227 }, {  49,3227 }, {  50,3227 }, {  51,3227 },
 {  52,3227 }, {  53,3227 }, {  54,3227 }, {  55,3227 }, {  56,3227 },
 {  57,3227 }, {   0,  66 }, {   0,6560 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,3227 }, {  66,3227 },
 {  67,3227 }, {  68,3227 }, {  69,3227 }, {  70,3227 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,3227 }, {  98,3227 }, {  99,3227 },
 { 100,3227 }, { 101,3227 }, { 102,3227 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-3998 }, {   0,   0 },

 {  97,3227 }, {  98,3227 }, {  99,3227 }, { 100,3227 }, { 101,3227 },
 { 102,3227 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 257 }, {  66, 257 }, {  67, 257 },
 {  68, 257 }, {  69, 257 }, {  70, 257 }, {  71, 257 }, {  72, 257 },
 {  73, 257 }, {  74, 257 }, {  75, 257 }, {  76, 257 }, {  77, 257 },
 {  78, 257 }, {  79, 257 }, {  80, 257 }, {  81, 257 }, {  82, 257 },
 {  83, 257 }, {  84, 257 }, {  85, 257 }, {  86, 257 }, {  87, 257 },

 {  88, 257 }, {  89, 257 }, {  90, 257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95, 514 }, {   0,   0 }, {  97, 257 },
 {  98, 257 }, {  99, 257 }, { 100, 257 }, { 101, 257 }, { 102, 257 },
 { 103, 257 }, { 104, 257 }, { 105, 257 }, { 106, 257 }, { 107, 257 },
 { 108, 257 }, { 109, 257 }, { 110, 257 }, { 111, 257 }, { 112, 257 },
 { 113, 257 }, { 114, 257 }, { 115, 257 }, { 116, 257 }, { 117, 257 },
 { 118, 257 }, { 119, 257 }, { 120, 257 }, { 121, 257 }, { 122, 257 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128, 257 }, { 129, 257 }, { 130, 257 }, { 131, 257 }, { 132, 257 },
 { 133, 257 }, { 134, 257 }, { 135, 257 }, { 136, 257 }, { 137, 257 },

 { 138, 257 }, { 139, 257 }, { 140, 257 }, { 141, 257 }, { 142, 257 },
 { 143, 257 }, { 144, 257 }, { 145, 257 }, { 146, 257 }, { 147, 257 },
 { 148, 257 }, { 149, 257 }, { 150, 257 }, { 151, 257 }, { 152, 257 },
 { 153, 257 }, { 154, 257 }, { 155, 257 }, { 156, 257 }, { 157, 257 },
 { 158, 257 }, { 159, 257 }, { 160, 257 }, { 161, 257 }, { 162, 257 },
 { 163, 257 }, { 164, 257 }, { 165, 257 }, { 166, 257 }, { 167, 257 },
 { 168, 257 }, { 169, 257 }, { 170, 257 }, { 171, 257 }, { 172, 257 },
 { 173, 257 }, { 174, 257 }, { 175, 257 }, { 176, 257 }, { 177, 257 },
 { 178, 257 }, { 179, 257 }, { 180, 257 }, { 181, 257 }, { 182, 257 },
 { 183, 257 }, { 184, 257 }, { 185, 257 }, { 186, 257 }, { 187, 257 },

 { 188, 257 }, { 189, 257 }, { 190, 257 }, { 191, 257 }, { 192, 257 },
 { 193, 257 }, { 194, 257 }, { 195, 257 }, { 196, 257 }, { 197, 257 },
 { 198, 257 }, { 199, 257 }, { 200, 257 }, { 201, 257 }, { 202, 257 },
 { 203, 257 }, { 204, 257 }, { 205, 257 }, { 206, 257 }, { 207, 257 },
 { 208, 257 }, { 209, 257 }, { 210, 257 }, { 211, 257 }, { 212, 257 },
 { 213, 257 }, { 214, 257 }, { 215, 257 }, { 216, 257 }, { 217, 257 },
 { 218, 257 }, { 219, 257 }, { 220, 257 }, { 221, 257 }, { 222, 257 },
 { 223, 257 }, { 224, 257 }, { 225, 257 }, { 226, 257 }, { 227, 257 },
 { 228, 257 }, { 229, 257 }, { 230, 257 }, { 231, 257 }, { 232, 257 },
 { 233, 257 }, { 234, 257 }, { 235, 257 }, { 236, 257 }, { 237, 257 },

 { 238, 257 }, { 239, 257 }, { 240, 257 }, { 241, 257 }, { 242, 257 },
 { 243, 257 }, { 244, 257 }, { 245, 257 }, { 246, 257 }, { 247, 257 },
 { 248, 257 }, { 249, 257 }, { 250, 257 }, { 251, 257 }, { 252, 257 },
 { 253, 257 }, { 254, 257 }, { 255, 257 }, {   0,  69 }, {   0,6303 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,2970 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,2970 }, {  49,2970 }, {  50,2970 },
 {  51,2970 }, {  52,2970 }, {  53,2970 }, {  54,2970 }, {  55,2970 },
 {  56,2970 }, {  57,2970 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2970 },
 {  66,2970 }, {  67,2970 }, {  68,2970 }, {  69,2970 }, {  70,2970 },
 {  71,2970 }, {  72,2970 }, {  73,2970 }, {  74,2970 }, {  75,2970 },
 {  76,2970 }, {  77,2970 }, {  78,2970 }, {  79,2970 }, {  80,2970 },

 {  81,2970 }, {  82,2970 }, {  83,2970 }, {  84,2970 }, {  85,2970 },
 {  86,2970 }, {  87,2970 }, {  88,2970 }, {  89,2970 }, {  90,2970 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,2970 },
 {   0,   0 }, {  97,2970 }, {  98,2970 }, {  99,2970 }, { 100,2970 },
 { 101,2970 }, { 102,2970 }, { 103,2970 }, { 104,2970 }, { 105,2970 },
 { 106,2970 }, { 107,2970 }, { 108,2970 }, { 109,2970 }, { 110,2970 },
 { 111,2970 }, { 112,2970 }, { 113,2970 }, { 114,2970 }, { 115,2970 },
 { 116,2970 }, { 117,2970 }, { 118,2970 }, { 119,2970 }, { 120,2970 },
 { 121,2970 }, { 122,2970 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,2970 }, { 129,2970 }, { 130,2970 },

 { 131,2970 }, { 132,2970 }, { 133,2970 }, { 134,2970 }, { 135,2970 },
 { 136,2970 }, { 137,2970 }, { 138,2970 }, { 139,2970 }, { 140,2970 },
 { 141,2970 }, { 142,2970 }, { 143,2970 }, { 144,2970 }, { 145,2970 },
 { 146,2970 }, { 147,2970 }, { 148,2970 }, { 149,2970 }, { 150,2970 },
 { 151,2970 }, { 152,2970 }, { 153,2970 }, { 154,2970 }, { 155,2970 },
 { 156,2970 }, { 157,2970 }, { 158,2970 }, { 159,2970 }, { 160,2970 },
 { 161,2970 }, { 162,2970 }, { 163,2970 }, { 164,2970 }, { 165,2970 },
 { 166,2970 }, { 167,2970 }, { 168,2970 }, { 169,2970 }, { 170,2970 },
 { 171,2970 }, { 172,2970 }, { 173,2970 }, { 174,2970 }, { 175,2970 },
 { 176,2970 }, { 177,2970 }, { 178,2970 }, { 179,2970 }, { 180,2970 },

 { 181,2970 }, { 182,2970 }, { 183,2970 }, { 184,2970 }, { 185,2970 },
 { 186,2970 }, { 187,2970 }, { 188,2970 }, { 189,2970 }, { 190,2970 },
 { 191,2970 }, { 192,2970 }, { 193,2970 }, { 194,2970 }, { 195,2970 },
 { 196,2970 }, { 197,2970 }, { 198,2970 }, { 199,2970 }, { 200,2970 },
 { 201,2970 }, { 202,2970 }, { 203,2970 }, { 204,2970 }, { 205,2970 },
 { 206,2970 }, { 207,2970 }, { 208,2970 }, { 209,2970 }, { 210,2970 },
 { 211,2970 }, { 212,2970 }, { 213,2970 }, { 214,2970 }, { 215,2970 },
 { 216,2970 }, { 217,2970 }, { 218,2970 }, { 219,2970 }, { 220,2970 },
 { 221,2970 }, { 222,2970 }, { 223,2970 }, { 224,2970 }, { 225,2970 },
 { 226,2970 }, { 227,2970 }, { 228,2970 }, { 229,2970 }, { 230,2970 },

 { 231,2970 }, { 232,2970 }, { 233,2970 }, { 234,2970 }, { 235,2970 },
 { 236,2970 }, { 237,2970 }, { 238,2970 }, { 239,2970 }, { 240,2970 },
 { 241,2970 }, { 242,2970 }, { 243,2970 }, { 244,2970 }, { 245,2970 },
 { 246,2970 }, { 247,2970 }, { 248,2970 }, { 249,2970 }, { 250,2970 },
 { 251,2970 }, { 252,2970 }, { 253,2970 }, { 254,2970 }, { 255,2970 },
 {   0,  69 }, {   0,6046 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,2713 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,2970 },
 {  49,2970 }, {  50,2970 }, {  51,2970 }, {  52,2970 }, {  53,2970 },
 {  54,2970 }, {  55,2970 }, {  56,2970 }, {  57,2970 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,2713 }, {  66,2713 }, {  67,2713 }, {  68,2713 },
 {  69,2713 }, {  70,2713 }, {  71,2713 }, {  72,2713 }, {  73,2713 },

 {  74,2713 }, {  75,2713 }, {  76,2713 }, {  77,2713 }, {  78,2713 },
 {  79,2713 }, {  80,2713 }, {  81,2713 }, {  82,2713 }, {  83,2713 },
 {  84,2713 }, {  85,2713 }, {  86,2713 }, {  87,2713 }, {  88,2713 },
 {  89,2713 }, {  90,2713 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,2713 }, {   0,   0 }, {  97,2713 }, {  98,2713 },
 {  99,2713 }, { 100,2713 }, { 101,2713 }, { 102,2713 }, { 103,2713 },
 { 104,2713 }, { 105,2713 }, { 106,2713 }, { 107,2713 }, { 108,2713 },
 { 109,2713 }, { 110,2713 }, { 111,2713 }, { 112,2713 }, { 113,2713 },
 { 114,2713 }, { 115,2713 }, { 116,2713 }, { 117,2713 }, { 118,2713 },
 { 119,2713 }, { 120,2713 }, { 121,2713 }, { 122,2713 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,2713 },
 { 129,2713 }, { 130,2713 }, { 131,2713 }, { 132,2713 }, { 133,2713 },
 { 134,2713 }, { 135,2713 }, { 136,2713 }, { 137,2713 }, { 138,2713 },
 { 139,2713 }, { 140,2713 }, { 141,2713 }, { 142,2713 }, { 143,2713 },
 { 144,2713 }, { 145,2713 }, { 146,2713 }, { 147,2713 }, { 148,2713 },
 { 149,2713 }, { 150,2713 }, { 151,2713 }, { 152,2713 }, { 153,2713 },
 { 154,2713 }, { 155,2713 }, { 156,2713 }, { 157,2713 }, { 158,2713 },
 { 159,2713 }, { 160,2713 }, { 161,2713 }, { 162,2713 }, { 163,2713 },
 { 164,2713 }, { 165,2713 }, { 166,2713 }, { 167,2713 }, { 168,2713 },
 { 169,2713 }, { 170,2713 }, { 171,2713 }, { 172,2713 }, { 173,2713 },

 { 174,2713 }, { 175,2713 }, { 176,2713 }, { 177,2713 }, { 178,2713 },
 { 179,2713 }, { 180,2713 }, { 181,2713 }, { 182,2713 }, { 183,2713 },
 { 184,2713 }, { 185,2713 }, { 186,2713 }, { 187,2713 }, { 188,2713 },
 { 189,2713 }, { 190,2713 }, { 191,2713 }, { 192,2713 }, { 193,2713 },
 { 194,2713 }, { 195,2713 }, { 196,2713 }, { 197,2713 }, { 198,2713 },
 { 199,2713 }, { 200,2713 }, { 201,2713 }, { 202,2713 }, { 203,2713 },
 { 204,2713 }, { 205,2713 }, { 206,2713 }, { 207,2713 }, { 208,2713 },
 { 209,2713 }, { 210,2713 }, { 211,2713 }, { 212,2713 }, { 213,2713 },
 { 214,2713 }, { 215,2713 }, { 216,2713 }, { 217,2713 }, { 218,2713 },
 { 219,2713 }, { 220,2713 }, { 221,2713 }, { 222,2713 }, { 223,2713 },

 { 224,2713 }, { 225,2713 }, { 226,2713 }, { 227,2713 }, { 228,2713 },
 { 229,2713 }, { 230,2713 }, { 231,2713 }, { 232,2713 }, { 233,2713 },
 { 234,2713 }, { 235,2713 }, { 236,2713 }, { 237,2713 }, { 238,2713 },
 { 239,2713 }, { 240,2713 }, { 241,2713 }, { 242,2713 }, { 243,2713 },
 { 244,2713 }, { 245,2713 }, { 246,2713 }, { 247,2713 }, { 248,2713 },
 { 249,2713 }, { 250,2713 }, { 251,2713 }, { 252,2713 }, { 253,2713 },
 { 254,2713 }, { 255,2713 }, {   0,  69 }, {   0,5789 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-4769 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,-4769 }, {  49,-4769 }, {  50,-4769 }, {  51,-4769 },
 {  52,-4769 }, {  53,-4769 }, {  54,-4769 }, {  55,-4769 }, {  56,-4769 },
 {  57,-4769 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-4769 }, {  66,-4769 },

 {  67,-4769 }, {  68,-4769 }, {  69,-4769 }, {  70,-4769 }, {  71,-4769 },
 {  72,-4769 }, {  73,-4769 }, {  74,-4769 }, {  75,-4769 }, {  76,-4769 },
 {  77,-4769 }, {  78,-4769 }, {  79,-4769 }, {  80,-4769 }, {  81,-4769 },
 {  82,-4769 }, {  83,-4769 }, {  84,-4769 }, {  85,-4769 }, {  86,-4769 },
 {  87,-4769 }, {  88,-4769 }, {  89,-4769 }, {  90,-4769 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-4769 }, {   0,   0 },
 {  97,-4769 }, {  98,-4769 }, {  99,-4769 }, { 100,-4769 }, { 101,-4769 },
 { 102,-4769 }, { 103,-4769 }, { 104,-4769 }, { 105,-4769 }, { 106,-4769 },
 { 107,-4769 }, { 108,-4769 }, { 109,-4769 }, { 110,-4769 }, { 111,-4769 },
 { 112,-4769 }, { 113,-4769 }, { 114,-4769 }, { 115,-4769 }, { 116,-4769 },

 { 117,-4769 }, { 118,-4769 }, { 119,-4769 }, { 120,-4769 }, { 121,-4769 },
 { 122,-4769 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-4769 }, { 129,-4769 }, { 130,-4769 }, { 131,-4769 },
 { 132,-4769 }, { 133,-4769 }, { 134,-4769 }, { 135,-4769 }, { 136,-4769 },
 { 137,-4769 }, { 138,-4769 }, { 139,-4769 }, { 140,-4769 }, { 141,-4769 },
 { 142,-4769 }, { 143,-4769 }, { 144,-4769 }, { 145,-4769 }, { 146,-4769 },
 { 147,-4769 }, { 148,-4769 }, { 149,-4769 }, { 150,-4769 }, { 151,-4769 },
 { 152,-4769 }, { 153,-4769 }, { 154,-4769 }, { 155,-4769 }, { 156,-4769 },
 { 157,-4769 }, { 158,-4769 }, { 159,-4769 }, { 160,-4769 }, { 161,-4769 },
 { 162,-4769 }, { 163,-4769 }, { 164,-4769 }, { 165,-4769 }, { 166,-4769 },

 { 167,-4769 }, { 168,-4769 }, { 169,-4769 }, { 170,-4769 }, { 171,-4769 },
 { 172,-4769 }, { 173,-4769 }, { 174,-4769 }, { 175,-4769 }, { 176,-4769 },
 { 177,-4769 }, { 178,-4769 }, { 179,-4769 }, { 180,-4769 }, { 181,-4769 },
 { 182,-4769 }, { 183,-4769 }, { 184,-4769 }, { 185,-4769 }, { 186,-4769 },
 { 187,-4769 }, { 188,-4769 }, { 189,-4769 }, { 190,-4769 }, { 191,-4769 },
 { 192,-4769 }, { 193,-4769 }, { 194,-4769 }, { 195,-4769 }, { 196,-4769 },
 { 197,-4769 }, { 198,-4769 }, { 199,-4769 }, { 200,-4769 }, { 201,-4769 },
 { 202,-4769 }, { 203,-4769 }, { 204,-4769 }, { 205,-4769 }, { 206,-4769 },
 { 207,-4769 }, { 208,-4769 }, { 209,-4769 }, { 210,-4769 }, { 211,-4769 },
 { 212,-4769 }, { 213,-4769 }, { 214,-4769 }, { 215,-4769 }, { 216,-4769 },

 { 217,-4769 }, { 218,-4769 }, { 219,-4769 }, { 220,-4769 }, { 221,-4769 },
 { 222,-4769 }, { 223,-4769 }, { 224,-4769 }, { 225,-4769 }, { 226,-4769 },
 { 227,-4769 }, { 228,-4769 }, { 229,-4769 }, { 230,-4769 }, { 231,-4769 },
 { 232,-4769 }, { 233,-4769 }, { 234,-4769 }, { 235,-4769 }, { 236,-4769 },
 { 237,-4769 }, { 238,-4769 }, { 239,-4769 }, { 240,-4769 }, { 241,-4769 },
 { 242,-4769 }, { 243,-4769 }, { 244,-4769 }, { 245,-4769 }, { 246,-4769 },
 { 247,-4769 }, { 248,-4769 }, { 249,-4769 }, { 250,-4769 }, { 251,-4769 },
 { 252,-4769 }, { 253,-4769 }, { 254,-4769 }, { 255,-4769 }, {   0,  69 },
 {   0,5532 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-5026 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  43,-7078 }, {   0,   0 },
 {  45,-7078 }, {   0,   0 }, {   0,   0 }, {  48,-4769 }, {  49,-4769 },
 {  50,-4769 }, {  51,-4769 }, {  52,-4769 }, {  53,-4769 }, {  54,-4769 },
 {  55,-4769 }, {  56,-4769 }, {  57,-4769 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-5026 }, {  66,-5026 }, {  67,-5026 }, {  68,-5026 }, {  69,-5026 },
 {  70,-5026 }, {  71,-5026 }, {  72,-5026 }, {  73,-5026 }, {  74,-5026 },
 {  75,-5026 }, {  76,-5026 }, {  77,-5026 }, {  78,-5026 }, {  79,-5026 },
 {  80,-5026 }, {  81,-5026 }, {  82,-5026 }, {  83,-5026 }, {  84,-5026 },
 {  85,-5026 }, {  86,-5026 }, {  87,-5026 }, {  88,-5026 }, {  89,-5026 },
 {  90,-5026 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-5026 }, {   0,   0 }, {  97,-5026 }, {  98,-5026 }, {  99,-5026 },
 { 100,-5026 }, { 101,-5026 }, { 102,-5026 }, { 103,-5026 }, { 104,-5026 },
 { 105,-5026 }, { 106,-5026 }, { 107,-5026 }, { 108,-5026 }, { 109,-5026 },

 { 110,-5026 }, { 111,-5026 }, { 112,-5026 }, { 113,-5026 }, { 114,-5026 },
 { 115,-5026 }, { 116,-5026 }, { 117,-5026 }, { 118,-5026 }, { 119,-5026 },
 { 120,-5026 }, { 121,-5026 }, { 122,-5026 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-5026 }, { 129,-5026 },
 { 130,-5026 }, { 131,-5026 }, { 132,-5026 }, { 133,-5026 }, { 134,-5026 },
 { 135,-5026 }, { 136,-5026 }, { 137,-5026 }, { 138,-5026 }, { 139,-5026 },
 { 140,-5026 }, { 141,-5026 }, { 142,-5026 }, { 143,-5026 }, { 144,-5026 },
 { 145,-5026 }, { 146,-5026 }, { 147,-5026 }, { 148,-5026 }, { 149,-5026 },
 { 150,-5026 }, { 151,-5026 }, { 152,-5026 }, { 153,-5026 }, { 154,-5026 },
 { 155,-5026 }, { 156,-5026 }, { 157,-5026 }, { 158,-5026 }, { 159,-5026 },

 { 160,-5026 }, { 161,-5026 }, { 162,-5026 }, { 163,-5026 }, { 164,-5026 },
 { 165,-5026 }, { 166,-5026 }, { 167,-5026 }, { 168,-5026 }, { 169,-5026 },
 { 170,-5026 }, { 171,-5026 }, { 172,-5026 }, { 173,-5026 }, { 174,-5026 },
 { 175,-5026 }, { 176,-5026 }, { 177,-5026 }, { 178,-5026 }, { 179,-5026 },
 { 180,-5026 }, { 181,-5026 }, { 182,-5026 }, { 183,-5026 }, { 184,-5026 },
 { 185,-5026 }, { 186,-5026 }, { 187,-5026 }, { 188,-5026 }, { 189,-5026 },
 { 190,-5026 }, { 191,-5026 }, { 192,-5026 }, { 193,-5026 }, { 194,-5026 },
 { 195,-5026 }, { 196,-5026 }, { 197,-5026 }, { 198,-5026 }, { 199,-5026 },
 { 200,-5026 }, { 201,-5026 }, { 202,-5026 }, { 203,-5026 }, { 204,-5026 },
 { 205,-5026 }, { 206,-5026 }, { 207,-5026 }, { 208,-5026 }, { 209,-5026 },

 { 210,-5026 }, { 211,-5026 }, { 212,-5026 }, { 213,-5026 }, { 214,-5026 },
 { 215,-5026 }, { 216,-5026 }, { 217,-5026 }, { 218,-5026 }, { 219,-5026 },
 { 220,-5026 }, { 221,-5026 }, { 222,-5026 }, { 223,-5026 }, { 224,-5026 },
 { 225,-5026 }, { 226,-5026 }, { 227,-5026 }, { 228,-5026 }, { 229,-5026 },
 { 230,-5026 }, { 231,-5026 }, { 232,-5026 }, { 233,-5026 }, { 234,-5026 },
 { 235,-5026 }, { 236,-5026 }, { 237,-5026 }, { 238,-5026 }, { 239,-5026 },
 { 240,-5026 }, { 241,-5026 }, { 242,-5026 }, { 243,-5026 }, { 244,-5026 },
 { 245,-5026 }, { 246,-5026 }, { 247,-5026 }, { 248,-5026 }, { 249,-5026 },
 { 250,-5026 }, { 251,-5026 }, { 252,-5026 }, { 253,-5026 }, { 254,-5026 },
 { 255,-5026 }, {   0,  69 }, {   0,5275 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-5283 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-4769 }, {  49,-4769 }, {  50,-4769 }, {  51,-4769 }, {  52,-4769 },

 {  53,-4769 }, {  54,-4769 }, {  55,-4769 }, {  56,-4769 }, {  57,-4769 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-5283 }, {  66,-5283 }, {  67,-5283 },
 {  68,-5283 }, {  69,-5283 }, {  70,-5283 }, {  71,-5283 }, {  72,-5283 },
 {  73,-5283 }, {  74,-5283 }, {  75,-5283 }, {  76,-5283 }, {  77,-5283 },
 {  78,-5283 }, {  79,-5283 }, {  80,-5283 }, {  81,-5283 }, {  82,-5283 },
 {  83,-5283 }, {  84,-5283 }, {  85,-5283 }, {  86,-5283 }, {  87,-5283 },
 {  88,-5283 }, {  89,-5283 }, {  90,-5283 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-5283 }, {   0,   0 }, {  97,-5283 },
 {  98,-5283 }, {  99,-5283 }, { 100,-5283 }, { 101,-5283 }, { 102,-5283 },

 { 103,-5283 }, { 104,-5283 }, { 105,-5283 }, { 106,-5283 }, { 107,-5283 },
 { 108,-5283 }, { 109,-5283 }, { 110,-5283 }, { 111,-5283 }, { 112,-5283 },
 { 113,-5283 }, { 114,-5283 }, { 115,-5283 }, { 116,-5283 }, { 117,-5283 },
 { 118,-5283 }, { 119,-5283 }, { 120,-5283 }, { 121,-5283 }, { 122,-5283 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-5283 }, { 129,-5283 }, { 130,-5283 }, { 131,-5283 }, { 132,-5283 },
 { 133,-5283 }, { 134,-5283 }, { 135,-5283 }, { 136,-5283 }, { 137,-5283 },
 { 138,-5283 }, { 139,-5283 }, { 140,-5283 }, { 141,-5283 }, { 142,-5283 },
 { 143,-5283 }, { 144,-5283 }, { 145,-5283 }, { 146,-5283 }, { 147,-5283 },
 { 148,-5283 }, { 149,-5283 }, { 150,-5283 }, { 151,-5283 }, { 152,-5283 },

 { 153,-5283 }, { 154,-5283 }, { 155,-5283 }, { 156,-5283 }, { 157,-5283 },
 { 158,-5283 }, { 159,-5283 }, { 160,-5283 }, { 161,-5283 }, { 162,-5283 },
 { 163,-5283 }, { 164,-5283 }, { 165,-5283 }, { 166,-5283 }, { 167,-5283 },
 { 168,-5283 }, { 169,-5283 }, { 170,-5283 }, { 171,-5283 }, { 172,-5283 },
 { 173,-5283 }, { 174,-5283 }, { 175,-5283 }, { 176,-5283 }, { 177,-5283 },
 { 178,-5283 }, { 179,-5283 }, { 180,-5283 }, { 181,-5283 }, { 182,-5283 },
 { 183,-5283 }, { 184,-5283 }, { 185,-5283 }, { 186,-5283 }, { 187,-5283 },
 { 188,-5283 }, { 189,-5283 }, { 190,-5283 }, { 191,-5283 }, { 192,-5283 },
 { 193,-5283 }, { 194,-5283 }, { 195,-5283 }, { 196,-5283 }, { 197,-5283 },
 { 198,-5283 }, { 199,-5283 }, { 200,-5283 }, { 201,-5283 }, { 202,-5283 },

 { 203,-5283 }, { 204,-5283 }, { 205,-5283 }, { 206,-5283 }, { 207,-5283 },
 { 208,-5283 }, { 209,-5283 }, { 210,-5283 }, { 211,-5283 }, { 212,-5283 },
 { 213,-5283 }, { 214,-5283 }, { 215,-5283 }, { 216,-5283 }, { 217,-5283 },
 { 218,-5283 }, { 219,-5283 }, { 220,-5283 }, { 221,-5283 }, { 222,-5283 },
 { 223,-5283 }, { 224,-5283 }, { 225,-5283 }, { 226,-5283 }, { 227,-5283 },
 { 228,-5283 }, { 229,-5283 }, { 230,-5283 }, { 231,-5283 }, { 232,-5283 },
 { 233,-5283 }, { 234,-5283 }, { 235,-5283 }, { 236,-5283 }, { 237,-5283 },
 { 238,-5283 }, { 239,-5283 }, { 240,-5283 }, { 241,-5283 }, { 242,-5283 },
 { 243,-5283 }, { 244,-5283 }, { 245,-5283 }, { 246,-5283 }, { 247,-5283 },
 { 248,-5283 }, { 249,-5283 }, { 250,-5283 }, { 251,-5283 }, { 252,-5283 },

 { 253,-5283 }, { 254,-5283 }, { 255,-5283 }, {   0,  64 }, {   0,5018 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-5540 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-771 },
 {  66,-771 }, {  67,-771 }, {  68,-771 }, {  69,-514 }, {  70,-771 },
 {  71,-771 }, {  72,-771 }, {  73,-771 }, {  74,-771 }, {  75,-771 },
 {  76,-771 }, {  77,-771 }, {  78,-771 }, {  79,-771 }, {  80,-771 },
 {  81,-771 }, {  82,-771 }, {  83,-771 }, {  84,-771 }, {  85,-771 },
 {  86,-771 }, {  87,-771 }, {  88,-771 }, {  89,-771 }, {  90,-771 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,2199 },

 {   0,   0 }, {  97,-771 }, {  98,-771 }, {  99,-771 }, { 100,-771 },
 { 101,-514 }, { 102,-771 }, { 103,-771 }, { 104,-771 }, { 105,-771 },
 { 106,-771 }, { 107,-771 }, { 108,-771 }, { 109,-771 }, { 110,-771 },
 { 111,-771 }, { 112,-771 }, { 113,-771 }, { 114,-771 }, { 115,-771 },
 { 116,-771 }, { 117,-771 }, { 118,-771 }, { 119,-771 }, { 120,-771 },
 { 121,-771 }, { 122,-771 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-771 }, { 129,-771 }, { 130,-771 },
 { 131,-771 }, { 132,-771 }, { 133,-771 }, { 134,-771 }, { 135,-771 },
 { 136,-771 }, { 137,-771 }, { 138,-771 }, { 139,-771 }, { 140,-771 },
 { 141,-771 }, { 142,-771 }, { 143,-771 }, { 144,-771 }, { 145,-771 },

 { 146,-771 }, { 147,-771 }, { 148,-771 }, { 149,-771 }, { 150,-771 },
 { 151,-771 }, { 152,-771 }, { 153,-771 }, { 154,-771 }, { 155,-771 },
 { 156,-771 }, { 157,-771 }, { 158,-771 }, { 159,-771 }, { 160,-771 },
 { 161,-771 }, { 162,-771 }, { 163,-771 }, { 164,-771 }, { 165,-771 },
 { 166,-771 }, { 167,-771 }, { 168,-771 }, { 169,-771 }, { 170,-771 },
 { 171,-771 }, { 172,-771 }, { 173,-771 }, { 174,-771 }, { 175,-771 },
 { 176,-771 }, { 177,-771 }, { 178,-771 }, { 179,-771 }, { 180,-771 },
 { 181,-771 }, { 182,-771 }, { 183,-771 }, { 184,-771 }, { 185,-771 },
 { 186,-771 }, { 187,-771 }, { 188,-771 }, { 189,-771 }, { 190,-771 },
 { 191,-771 }, { 192,-771 }, { 193,-771 }, { 194,-771 }, { 195,-771 },

 { 196,-771 }, { 197,-771 }, { 198,-771 }, { 199,-771 }, { 200,-771 },
 { 201,-771 }, { 202,-771 }, { 203,-771 }, { 204,-771 }, { 205,-771 },
 { 206,-771 }, { 207,-771 }, { 208,-771 }, { 209,-771 }, { 210,-771 },
 { 211,-771 }, { 212,-771 }, { 213,-771 }, { 214,-771 }, { 215,-771 },
 { 216,-771 }, { 217,-771 }, { 218,-771 }, { 219,-771 }, { 220,-771 },
 { 221,-771 }, { 222,-771 }, { 223,-771 }, { 224,-771 }, { 225,-771 },
 { 226,-771 }, { 227,-771 }, { 228,-771 }, { 229,-771 }, { 230,-771 },
 { 231,-771 }, { 232,-771 }, { 233,-771 }, { 234,-771 }, { 235,-771 },
 { 236,-771 }, { 237,-771 }, { 238,-771 }, { 239,-771 }, { 240,-771 },
 { 241,-771 }, { 242,-771 }, { 243,-771 }, { 244,-771 }, { 245,-771 },

 { 246,-771 }, { 247,-771 }, { 248,-771 }, { 249,-771 }, { 250,-771 },
 { 251,-771 }, { 252,-771 }, { 253,-771 }, { 254,-771 }, { 255,-771 },
 {   0,  66 }, {   0,4761 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65, 257 }, {  66, 257 }, {  67, 257 }, {  68, 257 },
 {  69, 257 }, {  70, 257 }, {  71, 257 }, {  72, 257 }, {  73, 257 },
 {  74, 257 }, {  75, 257 }, {  76, 257 }, {  77, 257 }, {  78, 257 },
 {  79, 257 }, {  80, 257 }, {  81, 257 }, {  82, 257 }, {  83, 257 },
 {  84, 257 }, {  85, 257 }, {  86, 257 }, {  87, 257 }, {  88, 257 },

 {  89, 257 }, {  90, 257 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95, 514 }, {   0,   0 }, {  97, 257 }, {  98, 257 },
 {  99, 257 }, { 100, 257 }, { 101, 257 }, { 102, 257 }, { 103, 257 },
 { 104, 257 }, { 105, 257 }, { 106, 257 }, { 107, 257 }, { 108, 257 },
 { 109, 257 }, { 110, 257 }, { 111, 257 }, { 112, 257 }, { 113, 257 },
 { 114, 257 }, { 115, 257 }, { 116, 257 }, { 117, 257 }, { 118, 257 },
 { 119, 257 }, { 120, 257 }, { 121, 257 }, { 122, 257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128, 257 },
 { 129, 257 }, { 130, 257 }, { 131, 257 }, { 132, 257 }, { 133, 257 },
 { 134, 257 }, { 135, 257 }, { 136, 257 }, { 137, 257 }, { 138, 257 },

 { 139, 257 }, { 140, 257 }, { 141, 257 }, { 142, 257 }, { 143, 257 },
 { 144, 257 }, { 145, 257 }, { 146, 257 }, { 147, 257 }, { 148, 257 },
 { 149, 257 }, { 150, 257 }, { 151, 257 }, { 152, 257 }, { 153, 257 },
 { 154, 257 }, { 155, 257 }, { 156, 257 }, { 157, 257 }, { 158, 257 },
 { 159, 257 }, { 160, 257 }, { 161, 257 }, { 162, 257 }, { 163, 257 },
 { 164, 257 }, { 165, 257 }, { 166, 257 }, { 167, 257 }, { 168, 257 },
 { 169, 257 }, { 170, 257 }, { 171, 257 }, { 172, 257 }, { 173, 257 },
 { 174, 257 }, { 175, 257 }, { 176, 257 }, { 177, 257 }, { 178, 257 },
 { 179, 257 }, { 180, 257 }, { 181, 257 }, { 182, 257 }, { 183, 257 },
 { 184, 257 }, { 185, 257 }, { 186, 257 }, { 187, 257 }, { 188, 257 },

 { 189, 257 }, { 190, 257 }, { 191, 257 }, { 192, 257 }, { 193, 257 },
 { 194, 257 }, { 195, 257 }, { 196, 257 }, { 197, 257 }, { 198, 257 },
 { 199, 257 }, { 200, 257 }, { 201, 257 }, { 202, 257 }, { 203, 257 },
 { 204, 257 }, { 205, 257 }, { 206, 257 }, { 207, 257 }, { 208, 257 },
 { 209, 257 }, { 210, 257 }, { 211, 257 }, { 212, 257 }, { 213, 257 },
 { 214, 257 }, { 215, 257 }, { 216, 257 }, { 217, 257 }, { 218, 257 },
 { 219, 257 }, { 220, 257 }, { 221, 257 }, { 222, 257 }, { 223, 257 },
 { 224, 257 }, { 225, 257 }, { 226, 257 }, { 227, 257 }, { 228, 257 },
 { 229, 257 }, { 230, 257 }, { 231, 257 }, { 232, 257 }, { 233, 257 },
 { 234, 257 }, { 235, 257 }, { 236, 257 }, { 237, 257 }, { 238, 257 },

 { 239, 257 }, { 240, 257 }, { 241, 257 }, { 242, 257 }, { 243, 257 },
 { 244, 257 }, { 245, 257 }, { 246, 257 }, { 247, 257 }, { 248, 257 },
 { 249, 257 }, { 250, 257 }, { 251, 257 }, { 252, 257 }, { 253, 257 },
 { 254, 257 }, { 255, 257 }, {   0,  70 }, {   0,4504 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,1942 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,1942 }, {  49,1942 }, {  50,1942 }, {  51,1942 },
 {  52,1942 }, {  53,1942 }, {  54,1942 }, {  55,1942 }, {  56,1942 },
 {  57,1942 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1942 }, {  66,1942 },
 {  67,1942 }, {  68,1942 }, {  69,1942 }, {  70,1942 }, {  71,1942 },
 {  72,1942 }, {  73,1942 }, {  74,1942 }, {  75,1942 }, {  76,1942 },
 {  77,1942 }, {  78,1942 }, {  79,1942 }, {  80,1942 }, {  81,1942 },

 {  82,1942 }, {  83,1942 }, {  84,1942 }, {  85,1942 }, {  86,1942 },
 {  87,1942 }, {  88,1942 }, {  89,1942 }, {  90,1942 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,1942 }, {   0,   0 },
 {  97,1942 }, {  98,1942 }, {  99,1942 }, { 100,1942 }, { 101,1942 },
 { 102,1942 }, { 103,1942 }, { 104,1942 }, { 105,1942 }, { 106,1942 },
 { 107,1942 }, { 108,1942 }, { 109,1942 }, { 110,1942 }, { 111,1942 },
 { 112,1942 }, { 113,1942 }, { 114,1942 }, { 115,1942 }, { 116,1942 },
 { 117,1942 }, { 118,1942 }, { 119,1942 }, { 120,1942 }, { 121,1942 },
 { 122,1942 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,1942 }, { 129,1942 }, { 130,1942 }, { 131,1942 },

 { 132,1942 }, { 133,1942 }, { 134,1942 }, { 135,1942 }, { 136,1942 },
 { 137,1942 }, { 138,1942 }, { 139,1942 }, { 140,1942 }, { 141,1942 },
 { 142,1942 }, { 143,1942 }, { 144,1942 }, { 145,1942 }, { 146,1942 },
 { 147,1942 }, { 148,1942 }, { 149,1942 }, { 150,1942 }, { 151,1942 },
 { 152,1942 }, { 153,1942 }, { 154,1942 }, { 155,1942 }, { 156,1942 },
 { 157,1942 }, { 158,1942 }, { 159,1942 }, { 160,1942 }, { 161,1942 },
 { 162,1942 }, { 163,1942 }, { 164,1942 }, { 165,1942 }, { 166,1942 },
 { 167,1942 }, { 168,1942 }, { 169,1942 }, { 170,1942 }, { 171,1942 },
 { 172,1942 }, { 173,1942 }, { 174,1942 }, { 175,1942 }, { 176,1942 },
 { 177,1942 }, { 178,1942 }, { 179,1942 }, { 180,1942 }, { 181,1942 },

 { 182,1942 }, { 183,1942 }, { 184,1942 }, { 185,1942 }, { 186,1942 },
 { 187,1942 }, { 188,1942 }, { 189,1942 }, { 190,1942 }, { 191,1942 },
 { 192,1942 }, { 193,1942 }, { 194,1942 }, { 195,1942 }, { 196,1942 },
 { 197,1942 }, { 198,1942 }, { 199,1942 }, { 200,1942 }, { 201,1942 },
 { 202,1942 }, { 203,1942 }, { 204,1942 }, { 205,1942 }, { 206,1942 },
 { 207,1942 }, { 208,1942 }, { 209,1942 }, { 210,1942 }, { 211,1942 },
 { 212,1942 }, { 213,1942 }, { 214,1942 }, { 215,1942 }, { 216,1942 },
 { 217,1942 }, { 218,1942 }, { 219,1942 }, { 220,1942 }, { 221,1942 },
 { 222,1942 }, { 223,1942 }, { 224,1942 }, { 225,1942 }, { 226,1942 },
 { 227,1942 }, { 228,1942 }, { 229,1942 }, { 230,1942 }, { 231,1942 },

 { 232,1942 }, { 233,1942 }, { 234,1942 }, { 235,1942 }, { 236,1942 },
 { 237,1942 }, { 238,1942 }, { 239,1942 }, { 240,1942 }, { 241,1942 },
 { 242,1942 }, { 243,1942 }, { 244,1942 }, { 245,1942 }, { 246,1942 },
 { 247,1942 }, { 248,1942 }, { 249,1942 }, { 250,1942 }, { 251,1942 },
 { 252,1942 }, { 253,1942 }, { 254,1942 }, { 255,1942 }, {   0,  70 },
 {   0,4247 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,1685 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,1942 }, {  49,1942 },
 {  50,1942 }, {  51,1942 }, {  52,1942 }, {  53,1942 }, {  54,1942 },
 {  55,1942 }, {  56,1942 }, {  57,1942 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,1685 }, {  66,1685 }, {  67,1685 }, {  68,1685 }, {  69,1685 },
 {  70,1685 }, {  71,1685 }, {  72,1685 }, {  73,1685 }, {  74,1685 },

 {  75,1685 }, {  76,1685 }, {  77,1685 }, {  78,1685 }, {  79,1685 },
 {  80,1685 }, {  81,1685 }, {  82,1685 }, {  83,1685 }, {  84,1685 },
 {  85,1685 }, {  86,1685 }, {  87,1685 }, {  88,1685 }, {  89,1685 },
 {  90,1685 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,1685 }, {   0,   0 }, {  97,1685 }, {  98,1685 }, {  99,1685 },
 { 100,1685 }, { 101,1685 }, { 102,1685 }, { 103,1685 }, { 104,1685 },
 { 105,1685 }, { 106,1685 }, { 107,1685 }, { 108,1685 }, { 109,1685 },
 { 110,1685 }, { 111,1685 }, { 112,1685 }, { 113,1685 }, { 114,1685 },
 { 115,1685 }, { 116,1685 }, { 117,1685 }, { 118,1685 }, { 119,1685 },
 { 120,1685 }, { 121,1685 }, { 122,1685 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,1685 }, { 129,1685 },
 { 130,1685 }, { 131,1685 }, { 132,1685 }, { 133,1685 }, { 134,1685 },
 { 135,1685 }, { 136,1685 }, { 137,1685 }, { 138,1685 }, { 139,1685 },
 { 140,1685 }, { 141,1685 }, { 142,1685 }, { 143,1685 }, { 144,1685 },
 { 145,1685 }, { 146,1685 }, { 147,1685 }, { 148,1685 }, { 149,1685 },
 { 150,1685 }, { 151,1685 }, { 152,1685 }, { 153,1685 }, { 154,1685 },
 { 155,1685 }, { 156,1685 }, { 157,1685 }, { 158,1685 }, { 159,1685 },
 { 160,1685 }, { 161,1685 }, { 162,1685 }, { 163,1685 }, { 164,1685 },
 { 165,1685 }, { 166,1685 }, { 167,1685 }, { 168,1685 }, { 169,1685 },
 { 170,1685 }, { 171,1685 }, { 172,1685 }, { 173,1685 }, { 174,1685 },

 { 175,1685 }, { 176,1685 }, { 177,1685 }, { 178,1685 }, { 179,1685 },
 { 180,1685 }, { 181,1685 }, { 182,1685 }, { 183,1685 }, { 184,1685 },
 { 185,1685 }, { 186,1685 }, { 187,1685 }, { 188,1685 }, { 189,1685 },
 { 190,1685 }, { 191,1685 }, { 192,1685 }, { 193,1685 }, { 194,1685 },
 { 195,1685 }, { 196,1685 }, { 197,1685 }, { 198,1685 }, { 199,1685 },
 { 200,1685 }, { 201,1685 }, { 202,1685 }, { 203,1685 }, { 204,1685 },
 { 205,1685 }, { 206,1685 }, { 207,1685 }, { 208,1685 }, { 209,1685 },
 { 210,1685 }, { 211,1685 }, { 212,1685 }, { 213,1685 }, { 214,1685 },
 { 215,1685 }, { 216,1685 }, { 217,1685 }, { 218,1685 }, { 219,1685 },
 { 220,1685 }, { 221,1685 }, { 222,1685 }, { 223,1685 }, { 224,1685 },

 { 225,1685 }, { 226,1685 }, { 227,1685 }, { 228,1685 }, { 229,1685 },
 { 230,1685 }, { 231,1685 }, { 232,1685 }, { 233,1685 }, { 234,1685 },
 { 235,1685 }, { 236,1685 }, { 237,1685 }, { 238,1685 }, { 239,1685 },
 { 240,1685 }, { 241,1685 }, { 242,1685 }, { 243,1685 }, { 244,1685 },
 { 245,1685 }, { 246,1685 }, { 247,1685 }, { 248,1685 }, { 249,1685 },
 { 250,1685 }, { 251,1685 }, { 252,1685 }, { 253,1685 }, { 254,1685 },
 { 255,1685 }, {   0,  68 }, {   0,3990 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },

 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },

 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },

 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },

 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  66 }, {   0,3733 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1685 },
 {  66,1685 }, {  67,1685 }, {  68,1685 }, {  69,1685 }, {  70,1685 },
 {  71,1685 }, {  72,1685 }, {  73,1685 }, {  74,1685 }, {  75,1685 },
 {  76,1685 }, {  77,1685 }, {  78,1685 }, {  79,1685 }, {  80,1685 },
 {  81,1685 }, {  82,1685 }, {  83,1685 }, {  84,1685 }, {  85,1685 },
 {  86,1685 }, {  87,1685 }, {  88,1685 }, {  89,1685 }, {  90,1685 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,1942 },
 {   0,   0 }, {  97,1685 }, {  98,1685 }, {  99,1685 }, { 100,1685 },
 { 101,1685 }, { 102,1685 }, { 103,1685 }, { 104,1685 }, { 105,1685 },
 { 106,1685 }, { 107,1685 }, { 108,1685 }, { 109,1685 }, { 110,1685 },

 { 111,1685 }, { 112,1685 }, { 113,1685 }, { 114,1685 }, { 115,1685 },
 { 116,1685 }, { 117,1685 }, { 118,1685 }, { 119,1685 }, { 120,1685 },
 { 121,1685 }, { 122,1685 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,1685 }, { 129,1685 }, { 130,1685 },
 { 131,1685 }, { 132,1685 }, { 133,1685 }, { 134,1685 }, { 135,1685 },
 { 136,1685 }, { 137,1685 }, { 138,1685 }, { 139,1685 }, { 140,1685 },
 { 141,1685 }, { 142,1685 }, { 143,1685 }, { 144,1685 }, { 145,1685 },
 { 146,1685 }, { 147,1685 }, { 148,1685 }, { 149,1685 }, { 150,1685 },
 { 151,1685 }, { 152,1685 }, { 153,1685 }, { 154,1685 }, { 155,1685 },
 { 156,1685 }, { 157,1685 }, { 158,1685 }, { 159,1685 }, { 160,1685 },

 { 161,1685 }, { 162,1685 }, { 163,1685 }, { 164,1685 }, { 165,1685 },
 { 166,1685 }, { 167,1685 }, { 168,1685 }, { 169,1685 }, { 170,1685 },
 { 171,1685 }, { 172,1685 }, { 173,1685 }, { 174,1685 }, { 175,1685 },
 { 176,1685 }, { 177,1685 }, { 178,1685 }, { 179,1685 }, { 180,1685 },
 { 181,1685 }, { 182,1685 }, { 183,1685 }, { 184,1685 }, { 185,1685 },
 { 186,1685 }, { 187,1685 }, { 188,1685 }, { 189,1685 }, { 190,1685 },
 { 191,1685 }, { 192,1685 }, { 193,1685 }, { 194,1685 }, { 195,1685 },
 { 196,1685 }, { 197,1685 }, { 198,1685 }, { 199,1685 }, { 200,1685 },
 { 201,1685 }, { 202,1685 }, { 203,1685 }, { 204,1685 }, { 205,1685 },
 { 206,1685 }, { 207,1685 }, { 208,1685 }, { 209,1685 }, { 210,1685 },

 { 211,1685 }, { 212,1685 }, { 213,1685 }, { 214,1685 }, { 215,1685 },
 { 216,1685 }, { 217,1685 }, { 218,1685 }, { 219,1685 }, { 220,1685 },
 { 221,1685 }, { 222,1685 }, { 223,1685 }, { 224,1685 }, { 225,1685 },
 { 226,1685 }, { 227,1685 }, { 228,1685 }, { 229,1685 }, { 230,1685 },
 { 231,1685 }, { 232,1685 }, { 233,1685 }, { 234,1685 }, { 235,1685 },
 { 236,1685 }, { 237,1685 }, { 238,1685 }, { 239,1685 }, { 240,1685 },
 { 241,1685 }, { 242,1685 }, { 243,1685 }, { 244,1685 }, { 245,1685 },
 { 246,1685 }, { 247,1685 }, { 248,1685 }, { 249,1685 }, { 250,1685 },
 { 251,1685 }, { 252,1685 }, { 253,1685 }, { 254,1685 }, { 255,1685 },
 {   0,  28 }, {   0,3476 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0,3453 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,1942 },
 {  49,1942 }, {  50,1942 }, {  51,1942 }, {  52,1942 }, {  53,1942 },

 {  54,1942 }, {  55,1942 }, {  56,1942 }, {  57,1942 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0,3415 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,1942 }, {  66,1942 }, {  67,1942 }, {  68,1942 },
 {  69,1942 }, {  70,1942 }, {  48,-23334 }, {  49,-23334 }, {  50,-23334 },
 {  51,-23334 }, {  52,-23334 }, {  53,-23334 }, {  54,-23334 }, {  55,-23334 },
 {  56,-23334 }, {  57,-23334 }, {   0,   0 }, {   0,   0 }, {   0,  28 },
 {   0,3392 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-23334 },
 {  66,-23334 }, {  67,-23334 }, {  68,-23334 }, {  69,-23334 }, {  70,-23334 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,1942 }, {  98,1942 },
 {  99,1942 }, { 100,1942 }, { 101,1942 }, { 102,1942 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,1904 }, {  49,1904 }, {  50,1904 }, {  51,1904 }, {  52,1904 },
 {  53,1904 }, {  54,1904 }, {  55,1904 }, {  56,1904 }, {  57,1904 },
 {   0,   0 }, {  97,-23334 }, {  98,-23334 }, {  99,-23334 }, { 100,-23334 },
 { 101,-23334 }, { 102,-23334 }, {  65,1904 }, {  66,1904 }, {  67,1904 },
 {  68,1904 }, {  69,1904 }, {  70,1904 }, {  48,-23393 }, {  49,-23393 },
 {  50,-23393 }, {  51,-23393 }, {  52,-23393 }, {  53,-23393 }, {  54,-23393 },
 {  55,-23393 }, {  56,-23393 }, {  57,-23393 }, {   0,  69 }, {   0,3333 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-23393 }, {  66,-23393 }, {  67,-23393 }, {  68,-23393 }, {  69,-23393 },

 {  70,-23393 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,1904 },
 {  98,1904 }, {  99,1904 }, { 100,1904 }, { 101,1904 }, { 102,1904 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,   0 }, {   0,   0 }, {  97,-23393 }, {  98,-23393 }, {  99,-23393 },
 { 100,-23393 }, { 101,-23393 }, { 102,-23393 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 },
 {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },

 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },

 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },

 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 {   0,  66 }, {   0,3076 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-257 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },

 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,1624 }, {  66,1624 }, {  67,1624 }, {  68,1624 },
 {  69,1624 }, {  70,1624 }, {  71,1624 }, {  72,1624 }, {  73,1624 },
 {  74,1624 }, {  75,1624 }, {  76,1624 }, {  77,1624 }, {  78,1624 },
 {  79,1624 }, {  80,1624 }, {  81,1624 }, {  82,1624 }, {  83,1624 },
 {  84,1624 }, {  85,1624 }, {  86,1624 }, {  87,1624 }, {  88,1624 },
 {  89,1624 }, {  90,1624 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,1881 }, {   0,   0 }, {  97,1624 }, {  98,1624 },
 {  99,1624 }, { 100,1624 }, { 101,1624 }, { 102,1624 }, { 103,1624 },

 { 104,1624 }, { 105,1624 }, { 106,1624 }, { 107,1624 }, { 108,1624 },
 { 109,1624 }, { 110,1624 }, { 111,1624 }, { 112,1624 }, { 113,1624 },
 { 114,1624 }, { 115,1624 }, { 116,1624 }, { 117,1624 }, { 118,1624 },
 { 119,1624 }, { 120,1624 }, { 121,1624 }, { 122,1624 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,1624 },
 { 129,1624 }, { 130,1624 }, { 131,1624 }, { 132,1624 }, { 133,1624 },
 { 134,1624 }, { 135,1624 }, { 136,1624 }, { 137,1624 }, { 138,1624 },
 { 139,1624 }, { 140,1624 }, { 141,1624 }, { 142,1624 }, { 143,1624 },
 { 144,1624 }, { 145,1624 }, { 146,1624 }, { 147,1624 }, { 148,1624 },
 { 149,1624 }, { 150,1624 }, { 151,1624 }, { 152,1624 }, { 153,1624 },

 { 154,1624 }, { 155,1624 }, { 156,1624 }, { 157,1624 }, { 158,1624 },
 { 159,1624 }, { 160,1624 }, { 161,1624 }, { 162,1624 }, { 163,1624 },
 { 164,1624 }, { 165,1624 }, { 166,1624 }, { 167,1624 }, { 168,1624 },
 { 169,1624 }, { 170,1624 }, { 171,1624 }, { 172,1624 }, { 173,1624 },
 { 174,1624 }, { 175,1624 }, { 176,1624 }, { 177,1624 }, { 178,1624 },
 { 179,1624 }, { 180,1624 }, { 181,1624 }, { 182,1624 }, { 183,1624 },
 { 184,1624 }, { 185,1624 }, { 186,1624 }, { 187,1624 }, { 188,1624 },
 { 189,1624 }, { 190,1624 }, { 191,1624 }, { 192,1624 }, { 193,1624 },
 { 194,1624 }, { 195,1624 }, { 196,1624 }, { 197,1624 }, { 198,1624 },
 { 199,1624 }, { 200,1624 }, { 201,1624 }, { 202,1624 }, { 203,1624 },

 { 204,1624 }, { 205,1624 }, { 206,1624 }, { 207,1624 }, { 208,1624 },
 { 209,1624 }, { 210,1624 }, { 211,1624 }, { 212,1624 }, { 213,1624 },
 { 214,1624 }, { 215,1624 }, { 216,1624 }, { 217,1624 }, { 218,1624 },
 { 219,1624 }, { 220,1624 }, { 221,1624 }, { 222,1624 }, { 223,1624 },
 { 224,1624 }, { 225,1624 }, { 226,1624 }, { 227,1624 }, { 228,1624 },
 { 229,1624 }, { 230,1624 }, { 231,1624 }, { 232,1624 }, { 233,1624 },
 { 234,1624 }, { 235,1624 }, { 236,1624 }, { 237,1624 }, { 238,1624 },
 { 239,1624 }, { 240,1624 }, { 241,1624 }, { 242,1624 }, { 243,1624 },
 { 244,1624 }, { 245,1624 }, { 246,1624 }, { 247,1624 }, { 248,1624 },
 { 249,1624 }, { 250,1624 }, { 251,1624 }, { 252,1624 }, { 253,1624 },

 { 254,1624 }, { 255,1624 }, {   0,  69 }, {   0,2819 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-7739 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  48,-2199 }, {  49,-2199 }, {  50,-2199 }, {  51,-2199 },
 {  52,-2199 }, {  53,-2199 }, {  54,-2199 }, {  55,-2199 }, {  56,-2199 },
 {  57,-2199 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-7739 }, {  66,-7739 },
 {  67,-7739 }, {  68,-7739 }, {  69,-7739 }, {  70,-7739 }, {  71,-7739 },
 {  72,-7739 }, {  73,-7739 }, {  74,-7739 }, {  75,-7739 }, {  76,-7739 },
 {  77,-7739 }, {  78,-7739 }, {  79,-7739 }, {  80,-7739 }, {  81,-7739 },
 {  82,-7739 }, {  83,-7739 }, {  84,-7739 }, {  85,-7739 }, {  86,-7739 },
 {  87,-7739 }, {  88,-7739 }, {  89,-7739 }, {  90,-7739 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-7739 }, {   0,   0 },

 {  97,-7739 }, {  98,-7739 }, {  99,-7739 }, { 100,-7739 }, { 101,-7739 },
 { 102,-7739 }, { 103,-7739 }, { 104,-7739 }, { 105,-7739 }, { 106,-7739 },
 { 107,-7739 }, { 108,-7739 }, { 109,-7739 }, { 110,-7739 }, { 111,-7739 },
 { 112,-7739 }, { 113,-7739 }, { 114,-7739 }, { 115,-7739 }, { 116,-7739 },
 { 117,-7739 }, { 118,-7739 }, { 119,-7739 }, { 120,-7739 }, { 121,-7739 },
 { 122,-7739 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-7739 }, { 129,-7739 }, { 130,-7739 }, { 131,-7739 },
 { 132,-7739 }, { 133,-7739 }, { 134,-7739 }, { 135,-7739 }, { 136,-7739 },
 { 137,-7739 }, { 138,-7739 }, { 139,-7739 }, { 140,-7739 }, { 141,-7739 },
 { 142,-7739 }, { 143,-7739 }, { 144,-7739 }, { 145,-7739 }, { 146,-7739 },

 { 147,-7739 }, { 148,-7739 }, { 149,-7739 }, { 150,-7739 }, { 151,-7739 },
 { 152,-7739 }, { 153,-7739 }, { 154,-7739 }, { 155,-7739 }, { 156,-7739 },
 { 157,-7739 }, { 158,-7739 }, { 159,-7739 }, { 160,-7739 }, { 161,-7739 },
 { 162,-7739 }, { 163,-7739 }, { 164,-7739 }, { 165,-7739 }, { 166,-7739 },
 { 167,-7739 }, { 168,-7739 }, { 169,-7739 }, { 170,-7739 }, { 171,-7739 },
 { 172,-7739 }, { 173,-7739 }, { 174,-7739 }, { 175,-7739 }, { 176,-7739 },
 { 177,-7739 }, { 178,-7739 }, { 179,-7739 }, { 180,-7739 }, { 181,-7739 },
 { 182,-7739 }, { 183,-7739 }, { 184,-7739 }, { 185,-7739 }, { 186,-7739 },
 { 187,-7739 }, { 188,-7739 }, { 189,-7739 }, { 190,-7739 }, { 191,-7739 },
 { 192,-7739 }, { 193,-7739 }, { 194,-7739 }, { 195,-7739 }, { 196,-7739 },

 { 197,-7739 }, { 198,-7739 }, { 199,-7739 }, { 200,-7739 }, { 201,-7739 },
 { 202,-7739 }, { 203,-7739 }, { 204,-7739 }, { 205,-7739 }, { 206,-7739 },
 { 207,-7739 }, { 208,-7739 }, { 209,-7739 }, { 210,-7739 }, { 211,-7739 },
 { 212,-7739 }, { 213,-7739 }, { 214,-7739 }, { 215,-7739 }, { 216,-7739 },
 { 217,-7739 }, { 218,-7739 }, { 219,-7739 }, { 220,-7739 }, { 221,-7739 },
 { 222,-7739 }, { 223,-7739 }, { 224,-7739 }, { 225,-7739 }, { 226,-7739 },
 { 227,-7739 }, { 228,-7739 }, { 229,-7739 }, { 230,-7739 }, { 231,-7739 },
 { 232,-7739 }, { 233,-7739 }, { 234,-7739 }, { 235,-7739 }, { 236,-7739 },
 { 237,-7739 }, { 238,-7739 }, { 239,-7739 }, { 240,-7739 }, { 241,-7739 },
 { 242,-7739 }, { 243,-7739 }, { 244,-7739 }, { 245,-7739 }, { 246,-7739 },

 { 247,-7739 }, { 248,-7739 }, { 249,-7739 }, { 250,-7739 }, { 251,-7739 },
 { 252,-7739 }, { 253,-7739 }, { 254,-7739 }, { 255,-7739 }, {   0,  70 },
 {   0,2562 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },

 {  90,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,   0 }, {   0,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },

 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },

 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },

 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, {   0,  66 }, {   0,2305 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,1367 }, {  66,1367 }, {  67,1367 },
 {  68,1367 }, {  69,1367 }, {  70,1367 }, {  71,1367 }, {  72,1367 },
 {  73,1367 }, {  74,1367 }, {  75,1367 }, {  76,1367 }, {  77,1367 },
 {  78,1367 }, {  79,1367 }, {  80,1367 }, {  81,1367 }, {  82,1367 },

 {  83,1367 }, {  84,1367 }, {  85,1367 }, {  86,1367 }, {  87,1367 },
 {  88,1367 }, {  89,1367 }, {  90,1367 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,1624 }, {   0,   0 }, {  97,1367 },
 {  98,1367 }, {  99,1367 }, { 100,1367 }, { 101,1367 }, { 102,1367 },
 { 103,1367 }, { 104,1367 }, { 105,1367 }, { 106,1367 }, { 107,1367 },
 { 108,1367 }, { 109,1367 }, { 110,1367 }, { 111,1367 }, { 112,1367 },
 { 113,1367 }, { 114,1367 }, { 115,1367 }, { 116,1367 }, { 117,1367 },
 { 118,1367 }, { 119,1367 }, { 120,1367 }, { 121,1367 }, { 122,1367 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,1367 }, { 129,1367 }, { 130,1367 }, { 131,1367 }, { 132,1367 },

 { 133,1367 }, { 134,1367 }, { 135,1367 }, { 136,1367 }, { 137,1367 },
 { 138,1367 }, { 139,1367 }, { 140,1367 }, { 141,1367 }, { 142,1367 },
 { 143,1367 }, { 144,1367 }, { 145,1367 }, { 146,1367 }, { 147,1367 },
 { 148,1367 }, { 149,1367 }, { 150,1367 }, { 151,1367 }, { 152,1367 },
 { 153,1367 }, { 154,1367 }, { 155,1367 }, { 156,1367 }, { 157,1367 },
 { 158,1367 }, { 159,1367 }, { 160,1367 }, { 161,1367 }, { 162,1367 },
 { 163,1367 }, { 164,1367 }, { 165,1367 }, { 166,1367 }, { 167,1367 },
 { 168,1367 }, { 169,1367 }, { 170,1367 }, { 171,1367 }, { 172,1367 },
 { 173,1367 }, { 174,1367 }, { 175,1367 }, { 176,1367 }, { 177,1367 },
 { 178,1367 }, { 179,1367 }, { 180,1367 }, { 181,1367 }, { 182,1367 },

 { 183,1367 }, { 184,1367 }, { 185,1367 }, { 186,1367 }, { 187,1367 },
 { 188,1367 }, { 189,1367 }, { 190,1367 }, { 191,1367 }, { 192,1367 },
 { 193,1367 }, { 194,1367 }, { 195,1367 }, { 196,1367 }, { 197,1367 },
 { 198,1367 }, { 199,1367 }, { 200,1367 }, { 201,1367 }, { 202,1367 },
 { 203,1367 }, { 204,1367 }, { 205,1367 }, { 206,1367 }, { 207,1367 },
 { 208,1367 }, { 209,1367 }, { 210,1367 }, { 211,1367 }, { 212,1367 },
 { 213,1367 }, { 214,1367 }, { 215,1367 }, { 216,1367 }, { 217,1367 },
 { 218,1367 }, { 219,1367 }, { 220,1367 }, { 221,1367 }, { 222,1367 },
 { 223,1367 }, { 224,1367 }, { 225,1367 }, { 226,1367 }, { 227,1367 },
 { 228,1367 }, { 229,1367 }, { 230,1367 }, { 231,1367 }, { 232,1367 },

 { 233,1367 }, { 234,1367 }, { 235,1367 }, { 236,1367 }, { 237,1367 },
 { 238,1367 }, { 239,1367 }, { 240,1367 }, { 241,1367 }, { 242,1367 },
 { 243,1367 }, { 244,1367 }, { 245,1367 }, { 246,1367 }, { 247,1367 },
 { 248,1367 }, { 249,1367 }, { 250,1367 }, { 251,1367 }, { 252,1367 },
 { 253,1367 }, { 254,1367 }, { 255,1367 }, {   0,  68 }, {   0,2048 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-1942 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-1942 }, {  49,-1942 }, {  50,-1942 },
 {  51,-1942 }, {  52,-1942 }, {  53,-1942 }, {  54,-1942 }, {  55,-1942 },
 {  56,-1942 }, {  57,-1942 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-1942 },
 {  66,-1942 }, {  67,-1942 }, {  68,-1942 }, {  69,-1942 }, {  70,-1942 },
 {  71,-1942 }, {  72,-1942 }, {  73,-1942 }, {  74,-1942 }, {  75,-1942 },

 {  76,-1942 }, {  77,-1942 }, {  78,-1942 }, {  79,-1942 }, {  80,-1942 },
 {  81,-1942 }, {  82,-1942 }, {  83,-1942 }, {  84,-1942 }, {  85,-1942 },
 {  86,-1942 }, {  87,-1942 }, {  88,-1942 }, {  89,-1942 }, {  90,-1942 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-1942 },
 {   0,   0 }, {  97,-1942 }, {  98,-1942 }, {  99,-1942 }, { 100,-1942 },
 { 101,-1942 }, { 102,-1942 }, { 103,-1942 }, { 104,-1942 }, { 105,-1942 },
 { 106,-1942 }, { 107,-1942 }, { 108,-1942 }, { 109,-1942 }, { 110,-1942 },
 { 111,-1942 }, { 112,-1942 }, { 113,-1942 }, { 114,-1942 }, { 115,-1942 },
 { 116,-1942 }, { 117,-1942 }, { 118,-1942 }, { 119,-1942 }, { 120,-1942 },
 { 121,-1942 }, { 122,-1942 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,-1942 }, { 129,-1942 }, { 130,-1942 },
 { 131,-1942 }, { 132,-1942 }, { 133,-1942 }, { 134,-1942 }, { 135,-1942 },
 { 136,-1942 }, { 137,-1942 }, { 138,-1942 }, { 139,-1942 }, { 140,-1942 },
 { 141,-1942 }, { 142,-1942 }, { 143,-1942 }, { 144,-1942 }, { 145,-1942 },
 { 146,-1942 }, { 147,-1942 }, { 148,-1942 }, { 149,-1942 }, { 150,-1942 },
 { 151,-1942 }, { 152,-1942 }, { 153,-1942 }, { 154,-1942 }, { 155,-1942 },
 { 156,-1942 }, { 157,-1942 }, { 158,-1942 }, { 159,-1942 }, { 160,-1942 },
 { 161,-1942 }, { 162,-1942 }, { 163,-1942 }, { 164,-1942 }, { 165,-1942 },
 { 166,-1942 }, { 167,-1942 }, { 168,-1942 }, { 169,-1942 }, { 170,-1942 },
 { 171,-1942 }, { 172,-1942 }, { 173,-1942 }, { 174,-1942 }, { 175,-1942 },

 { 176,-1942 }, { 177,-1942 }, { 178,-1942 }, { 179,-1942 }, { 180,-1942 },
 { 181,-1942 }, { 182,-1942 }, { 183,-1942 }, { 184,-1942 }, { 185,-1942 },
 { 186,-1942 }, { 187,-1942 }, { 188,-1942 }, { 189,-1942 }, { 190,-1942 },
 { 191,-1942 }, { 192,-1942 }, { 193,-1942 }, { 194,-1942 }, { 195,-1942 },
 { 196,-1942 }, { 197,-1942 }, { 198,-1942 }, { 199,-1942 }, { 200,-1942 },
 { 201,-1942 }, { 202,-1942 }, { 203,-1942 }, { 204,-1942 }, { 205,-1942 },
 { 206,-1942 }, { 207,-1942 }, { 208,-1942 }, { 209,-1942 }, { 210,-1942 },
 { 211,-1942 }, { 212,-1942 }, { 213,-1942 }, { 214,-1942 }, { 215,-1942 },
 { 216,-1942 }, { 217,-1942 }, { 218,-1942 }, { 219,-1942 }, { 220,-1942 },
 { 221,-1942 }, { 222,-1942 }, { 223,-1942 }, { 224,-1942 }, { 225,-1942 },

 { 226,-1942 }, { 227,-1942 }, { 228,-1942 }, { 229,-1942 }, { 230,-1942 },
 { 231,-1942 }, { 232,-1942 }, { 233,-1942 }, { 234,-1942 }, { 235,-1942 },
 { 236,-1942 }, { 237,-1942 }, { 238,-1942 }, { 239,-1942 }, { 240,-1942 },
 { 241,-1942 }, { 242,-1942 }, { 243,-1942 }, { 244,-1942 }, { 245,-1942 },
 { 246,-1942 }, { 247,-1942 }, { 248,-1942 }, { 249,-1942 }, { 250,-1942 },
 { 251,-1942 }, { 252,-1942 }, { 253,-1942 }, { 254,-1942 }, { 255,-1942 },
 {   0,  68 }, {   0,1791 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-2199 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-1942 },
 {  49,-1942 }, {  50,-1942 }, {  51,-1942 }, {  52,-1942 }, {  53,-1942 },
 {  54,-1942 }, {  55,-1942 }, {  56,-1942 }, {  57,-1942 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-2199 }, {  66,-2199 }, {  67,-2199 }, {  68,-2199 },

 {  69,-2199 }, {  70,-2199 }, {  71,-2199 }, {  72,-2199 }, {  73,-2199 },
 {  74,-2199 }, {  75,-2199 }, {  76,-2199 }, {  77,-2199 }, {  78,-2199 },
 {  79,-2199 }, {  80,-2199 }, {  81,-2199 }, {  82,-2199 }, {  83,-2199 },
 {  84,-2199 }, {  85,-2199 }, {  86,-2199 }, {  87,-2199 }, {  88,-2199 },
 {  89,-2199 }, {  90,-2199 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-2199 }, {   0,   0 }, {  97,-2199 }, {  98,-2199 },
 {  99,-2199 }, { 100,-2199 }, { 101,-2199 }, { 102,-2199 }, { 103,-2199 },
 { 104,-2199 }, { 105,-2199 }, { 106,-2199 }, { 107,-2199 }, { 108,-2199 },
 { 109,-2199 }, { 110,-2199 }, { 111,-2199 }, { 112,-2199 }, { 113,-2199 },
 { 114,-2199 }, { 115,-2199 }, { 116,-2199 }, { 117,-2199 }, { 118,-2199 },

 { 119,-2199 }, { 120,-2199 }, { 121,-2199 }, { 122,-2199 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-2199 },
 { 129,-2199 }, { 130,-2199 }, { 131,-2199 }, { 132,-2199 }, { 133,-2199 },
 { 134,-2199 }, { 135,-2199 }, { 136,-2199 }, { 137,-2199 }, { 138,-2199 },
 { 139,-2199 }, { 140,-2199 }, { 141,-2199 }, { 142,-2199 }, { 143,-2199 },
 { 144,-2199 }, { 145,-2199 }, { 146,-2199 }, { 147,-2199 }, { 148,-2199 },
 { 149,-2199 }, { 150,-2199 }, { 151,-2199 }, { 152,-2199 }, { 153,-2199 },
 { 154,-2199 }, { 155,-2199 }, { 156,-2199 }, { 157,-2199 }, { 158,-2199 },
 { 159,-2199 }, { 160,-2199 }, { 161,-2199 }, { 162,-2199 }, { 163,-2199 },
 { 164,-2199 }, { 165,-2199 }, { 166,-2199 }, { 167,-2199 }, { 168,-2199 },

 { 169,-2199 }, { 170,-2199 }, { 171,-2199 }, { 172,-2199 }, { 173,-2199 },
 { 174,-2199 }, { 175,-2199 }, { 176,-2199 }, { 177,-2199 }, { 178,-2199 },
 { 179,-2199 }, { 180,-2199 }, { 181,-2199 }, { 182,-2199 }, { 183,-2199 },
 { 184,-2199 }, { 185,-2199 }, { 186,-2199 }, { 187,-2199 }, { 188,-2199 },
 { 189,-2199 }, { 190,-2199 }, { 191,-2199 }, { 192,-2199 }, { 193,-2199 },
 { 194,-2199 }, { 195,-2199 }, { 196,-2199 }, { 197,-2199 }, { 198,-2199 },
 { 199,-2199 }, { 200,-2199 }, { 201,-2199 }, { 202,-2199 }, { 203,-2199 },
 { 204,-2199 }, { 205,-2199 }, { 206,-2199 }, { 207,-2199 }, { 208,-2199 },
 { 209,-2199 }, { 210,-2199 }, { 211,-2199 }, { 212,-2199 }, { 213,-2199 },
 { 214,-2199 }, { 215,-2199 }, { 216,-2199 }, { 217,-2199 }, { 218,-2199 },

 { 219,-2199 }, { 220,-2199 }, { 221,-2199 }, { 222,-2199 }, { 223,-2199 },
 { 224,-2199 }, { 225,-2199 }, { 226,-2199 }, { 227,-2199 }, { 228,-2199 },
 { 229,-2199 }, { 230,-2199 }, { 231,-2199 }, { 232,-2199 }, { 233,-2199 },
 { 234,-2199 }, { 235,-2199 }, { 236,-2199 }, { 237,-2199 }, { 238,-2199 },
 { 239,-2199 }, { 240,-2199 }, { 241,-2199 }, { 242,-2199 }, { 243,-2199 },
 { 244,-2199 }, { 245,-2199 }, { 246,-2199 }, { 247,-2199 }, { 248,-2199 },
 { 249,-2199 }, { 250,-2199 }, { 251,-2199 }, { 252,-2199 }, { 253,-2199 },
 { 254,-2199 }, { 255,-2199 }, {   0,  28 }, {   0,1534 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0,1511 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,1110 }, {  49,1110 }, {  50,1110 }, {  51,1110 },
 {  52,1110 }, {  53,1110 }, {  54,1110 }, {  55,1110 }, {  56,1110 },
 {  57,1110 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,1110 }, {  66,1110 },
 {  67,1110 }, {  68,1110 }, {  69,1110 }, {  70,1110 }, {  48,1110 },
 {  49,1110 }, {  50,1110 }, {  51,1110 }, {  52,1110 }, {  53,1110 },
 {  54,1110 }, {  55,1110 }, {  56,1110 }, {  57,1110 }, {   0,  69 },
 {   0,1452 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,1110 }, {  66,1110 }, {  67,1110 }, {  68,1110 },
 {  69,1110 }, {  70,1110 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,1110 }, {  98,1110 }, {  99,1110 }, { 100,1110 }, { 101,1110 },
 { 102,1110 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,-1881 }, {   0,   0 }, {  97,1110 }, {  98,1110 },
 {  99,1110 }, { 100,1110 }, { 101,1110 }, { 102,1110 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-1881 }, {  49,-1881 },
 {  50,-1881 }, {  51,-1881 }, {  52,-1881 }, {  53,-1881 }, {  54,-1881 },
 {  55,-1881 }, {  56,-1881 }, {  57,-1881 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-1881 }, {  66,-1881 }, {  67,-1881 }, {  68,-1881 }, {  69,-1881 },
 {  70,-1881 }, {  71,-1881 }, {  72,-1881 }, {  73,-1881 }, {  74,-1881 },
 {  75,-1881 }, {  76,-1881 }, {  77,-1881 }, {  78,-1881 }, {  79,-1881 },

 {  80,-1881 }, {  81,-1881 }, {  82,-1881 }, {  83,-1881 }, {  84,-1881 },
 {  85,-1881 }, {  86,-1881 }, {  87,-1881 }, {  88,-1881 }, {  89,-1881 },
 {  90,-1881 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-1881 }, {   0,   0 }, {  97,-1881 }, {  98,-1881 }, {  99,-1881 },
 { 100,-1881 }, { 101,-1881 }, { 102,-1881 }, { 103,-1881 }, { 104,-1881 },
 { 105,-1881 }, { 106,-1881 }, { 107,-1881 }, { 108,-1881 }, { 109,-1881 },
 { 110,-1881 }, { 111,-1881 }, { 112,-1881 }, { 113,-1881 }, { 114,-1881 },
 { 115,-1881 }, { 116,-1881 }, { 117,-1881 }, { 118,-1881 }, { 119,-1881 },
 { 120,-1881 }, { 121,-1881 }, { 122,-1881 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1881 }, { 129,-1881 },

 { 130,-1881 }, { 131,-1881 }, { 132,-1881 }, { 133,-1881 }, { 134,-1881 },
 { 135,-1881 }, { 136,-1881 }, { 137,-1881 }, { 138,-1881 }, { 139,-1881 },
 { 140,-1881 }, { 141,-1881 }, { 142,-1881 }, { 143,-1881 }, { 144,-1881 },
 { 145,-1881 }, { 146,-1881 }, { 147,-1881 }, { 148,-1881 }, { 149,-1881 },
 { 150,-1881 }, { 151,-1881 }, { 152,-1881 }, { 153,-1881 }, { 154,-1881 },
 { 155,-1881 }, { 156,-1881 }, { 157,-1881 }, { 158,-1881 }, { 159,-1881 },
 { 160,-1881 }, { 161,-1881 }, { 162,-1881 }, { 163,-1881 }, { 164,-1881 },
 { 165,-1881 }, { 166,-1881 }, { 167,-1881 }, { 168,-1881 }, { 169,-1881 },
 { 170,-1881 }, { 171,-1881 }, { 172,-1881 }, { 173,-1881 }, { 174,-1881 },
 { 175,-1881 }, { 176,-1881 }, { 177,-1881 }, { 178,-1881 }, { 179,-1881 },

 { 180,-1881 }, { 181,-1881 }, { 182,-1881 }, { 183,-1881 }, { 184,-1881 },
 { 185,-1881 }, { 186,-1881 }, { 187,-1881 }, { 188,-1881 }, { 189,-1881 },
 { 190,-1881 }, { 191,-1881 }, { 192,-1881 }, { 193,-1881 }, { 194,-1881 },
 { 195,-1881 }, { 196,-1881 }, { 197,-1881 }, { 198,-1881 }, { 199,-1881 },
 { 200,-1881 }, { 201,-1881 }, { 202,-1881 }, { 203,-1881 }, { 204,-1881 },
 { 205,-1881 }, { 206,-1881 }, { 207,-1881 }, { 208,-1881 }, { 209,-1881 },
 { 210,-1881 }, { 211,-1881 }, { 212,-1881 }, { 213,-1881 }, { 214,-1881 },
 { 215,-1881 }, { 216,-1881 }, { 217,-1881 }, { 218,-1881 }, { 219,-1881 },
 { 220,-1881 }, { 221,-1881 }, { 222,-1881 }, { 223,-1881 }, { 224,-1881 },
 { 225,-1881 }, { 226,-1881 }, { 227,-1881 }, { 228,-1881 }, { 229,-1881 },

 { 230,-1881 }, { 231,-1881 }, { 232,-1881 }, { 233,-1881 }, { 234,-1881 },
 { 235,-1881 }, { 236,-1881 }, { 237,-1881 }, { 238,-1881 }, { 239,-1881 },
 { 240,-1881 }, { 241,-1881 }, { 242,-1881 }, { 243,-1881 }, { 244,-1881 },
 { 245,-1881 }, { 246,-1881 }, { 247,-1881 }, { 248,-1881 }, { 249,-1881 },
 { 250,-1881 }, { 251,-1881 }, { 252,-1881 }, { 253,-1881 }, { 254,-1881 },
 { 255,-1881 }, {   0,  69 }, {   0,1195 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-2138 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-1881 }, {  49,-1881 }, {  50,-1881 }, {  51,-1881 }, {  52,-1881 },
 {  53,-1881 }, {  54,-1881 }, {  55,-1881 }, {  56,-1881 }, {  57,-1881 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-2138 }, {  66,-2138 }, {  67,-2138 },
 {  68,-2138 }, {  69,-2138 }, {  70,-2138 }, {  71,-2138 }, {  72,-2138 },

 {  73,-2138 }, {  74,-2138 }, {  75,-2138 }, {  76,-2138 }, {  77,-2138 },
 {  78,-2138 }, {  79,-2138 }, {  80,-2138 }, {  81,-2138 }, {  82,-2138 },
 {  83,-2138 }, {  84,-2138 }, {  85,-2138 }, {  86,-2138 }, {  87,-2138 },
 {  88,-2138 }, {  89,-2138 }, {  90,-2138 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,-2138 }, {   0,   0 }, {  97,-2138 },
 {  98,-2138 }, {  99,-2138 }, { 100,-2138 }, { 101,-2138 }, { 102,-2138 },
 { 103,-2138 }, { 104,-2138 }, { 105,-2138 }, { 106,-2138 }, { 107,-2138 },
 { 108,-2138 }, { 109,-2138 }, { 110,-2138 }, { 111,-2138 }, { 112,-2138 },
 { 113,-2138 }, { 114,-2138 }, { 115,-2138 }, { 116,-2138 }, { 117,-2138 },
 { 118,-2138 }, { 119,-2138 }, { 120,-2138 }, { 121,-2138 }, { 122,-2138 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-2138 }, { 129,-2138 }, { 130,-2138 }, { 131,-2138 }, { 132,-2138 },
 { 133,-2138 }, { 134,-2138 }, { 135,-2138 }, { 136,-2138 }, { 137,-2138 },
 { 138,-2138 }, { 139,-2138 }, { 140,-2138 }, { 141,-2138 }, { 142,-2138 },
 { 143,-2138 }, { 144,-2138 }, { 145,-2138 }, { 146,-2138 }, { 147,-2138 },
 { 148,-2138 }, { 149,-2138 }, { 150,-2138 }, { 151,-2138 }, { 152,-2138 },
 { 153,-2138 }, { 154,-2138 }, { 155,-2138 }, { 156,-2138 }, { 157,-2138 },
 { 158,-2138 }, { 159,-2138 }, { 160,-2138 }, { 161,-2138 }, { 162,-2138 },
 { 163,-2138 }, { 164,-2138 }, { 165,-2138 }, { 166,-2138 }, { 167,-2138 },
 { 168,-2138 }, { 169,-2138 }, { 170,-2138 }, { 171,-2138 }, { 172,-2138 },

 { 173,-2138 }, { 174,-2138 }, { 175,-2138 }, { 176,-2138 }, { 177,-2138 },
 { 178,-2138 }, { 179,-2138 }, { 180,-2138 }, { 181,-2138 }, { 182,-2138 },
 { 183,-2138 }, { 184,-2138 }, { 185,-2138 }, { 186,-2138 }, { 187,-2138 },
 { 188,-2138 }, { 189,-2138 }, { 190,-2138 }, { 191,-2138 }, { 192,-2138 },
 { 193,-2138 }, { 194,-2138 }, { 195,-2138 }, { 196,-2138 }, { 197,-2138 },
 { 198,-2138 }, { 199,-2138 }, { 200,-2138 }, { 201,-2138 }, { 202,-2138 },
 { 203,-2138 }, { 204,-2138 }, { 205,-2138 }, { 206,-2138 }, { 207,-2138 },
 { 208,-2138 }, { 209,-2138 }, { 210,-2138 }, { 211,-2138 }, { 212,-2138 },
 { 213,-2138 }, { 214,-2138 }, { 215,-2138 }, { 216,-2138 }, { 217,-2138 },
 { 218,-2138 }, { 219,-2138 }, { 220,-2138 }, { 221,-2138 }, { 222,-2138 },

 { 223,-2138 }, { 224,-2138 }, { 225,-2138 }, { 226,-2138 }, { 227,-2138 },
 { 228,-2138 }, { 229,-2138 }, { 230,-2138 }, { 231,-2138 }, { 232,-2138 },
 { 233,-2138 }, { 234,-2138 }, { 235,-2138 }, { 236,-2138 }, { 237,-2138 },
 { 238,-2138 }, { 239,-2138 }, { 240,-2138 }, { 241,-2138 }, { 242,-2138 },
 { 243,-2138 }, { 244,-2138 }, { 245,-2138 }, { 246,-2138 }, { 247,-2138 },
 { 248,-2138 }, { 249,-2138 }, { 250,-2138 }, { 251,-2138 }, { 252,-2138 },
 { 253,-2138 }, { 254,-2138 }, { 255,-2138 }, {   0,  70 }, {   0, 938 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,-1624 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-1624 }, {  49,-1624 }, {  50,-1624 },
 {  51,-1624 }, {  52,-1624 }, {  53,-1624 }, {  54,-1624 }, {  55,-1624 },
 {  56,-1624 }, {  57,-1624 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-1624 },

 {  66,-1624 }, {  67,-1624 }, {  68,-1624 }, {  69,-1624 }, {  70,-1624 },
 {  71,-1624 }, {  72,-1624 }, {  73,-1624 }, {  74,-1624 }, {  75,-1624 },
 {  76,-1624 }, {  77,-1624 }, {  78,-1624 }, {  79,-1624 }, {  80,-1624 },
 {  81,-1624 }, {  82,-1624 }, {  83,-1624 }, {  84,-1624 }, {  85,-1624 },
 {  86,-1624 }, {  87,-1624 }, {  88,-1624 }, {  89,-1624 }, {  90,-1624 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-1624 },
 {   0,   0 }, {  97,-1624 }, {  98,-1624 }, {  99,-1624 }, { 100,-1624 },
 { 101,-1624 }, { 102,-1624 }, { 103,-1624 }, { 104,-1624 }, { 105,-1624 },
 { 106,-1624 }, { 107,-1624 }, { 108,-1624 }, { 109,-1624 }, { 110,-1624 },
 { 111,-1624 }, { 112,-1624 }, { 113,-1624 }, { 114,-1624 }, { 115,-1624 },

 { 116,-1624 }, { 117,-1624 }, { 118,-1624 }, { 119,-1624 }, { 120,-1624 },
 { 121,-1624 }, { 122,-1624 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-1624 }, { 129,-1624 }, { 130,-1624 },
 { 131,-1624 }, { 132,-1624 }, { 133,-1624 }, { 134,-1624 }, { 135,-1624 },
 { 136,-1624 }, { 137,-1624 }, { 138,-1624 }, { 139,-1624 }, { 140,-1624 },
 { 141,-1624 }, { 142,-1624 }, { 143,-1624 }, { 144,-1624 }, { 145,-1624 },
 { 146,-1624 }, { 147,-1624 }, { 148,-1624 }, { 149,-1624 }, { 150,-1624 },
 { 151,-1624 }, { 152,-1624 }, { 153,-1624 }, { 154,-1624 }, { 155,-1624 },
 { 156,-1624 }, { 157,-1624 }, { 158,-1624 }, { 159,-1624 }, { 160,-1624 },
 { 161,-1624 }, { 162,-1624 }, { 163,-1624 }, { 164,-1624 }, { 165,-1624 },

 { 166,-1624 }, { 167,-1624 }, { 168,-1624 }, { 169,-1624 }, { 170,-1624 },
 { 171,-1624 }, { 172,-1624 }, { 173,-1624 }, { 174,-1624 }, { 175,-1624 },
 { 176,-1624 }, { 177,-1624 }, { 178,-1624 }, { 179,-1624 }, { 180,-1624 },
 { 181,-1624 }, { 182,-1624 }, { 183,-1624 }, { 184,-1624 }, { 185,-1624 },
 { 186,-1624 }, { 187,-1624 }, { 188,-1624 }, { 189,-1624 }, { 190,-1624 },
 { 191,-1624 }, { 192,-1624 }, { 193,-1624 }, { 194,-1624 }, { 195,-1624 },
 { 196,-1624 }, { 197,-1624 }, { 198,-1624 }, { 199,-1624 }, { 200,-1624 },
 { 201,-1624 }, { 202,-1624 }, { 203,-1624 }, { 204,-1624 }, { 205,-1624 },
 { 206,-1624 }, { 207,-1624 }, { 208,-1624 }, { 209,-1624 }, { 210,-1624 },
 { 211,-1624 }, { 212,-1624 }, { 213,-1624 }, { 214,-1624 }, { 215,-1624 },

 { 216,-1624 }, { 217,-1624 }, { 218,-1624 }, { 219,-1624 }, { 220,-1624 },
 { 221,-1624 }, { 222,-1624 }, { 223,-1624 }, { 224,-1624 }, { 225,-1624 },
 { 226,-1624 }, { 227,-1624 }, { 228,-1624 }, { 229,-1624 }, { 230,-1624 },
 { 231,-1624 }, { 232,-1624 }, { 233,-1624 }, { 234,-1624 }, { 235,-1624 },
 { 236,-1624 }, { 237,-1624 }, { 238,-1624 }, { 239,-1624 }, { 240,-1624 },
 { 241,-1624 }, { 242,-1624 }, { 243,-1624 }, { 244,-1624 }, { 245,-1624 },
 { 246,-1624 }, { 247,-1624 }, { 248,-1624 }, { 249,-1624 }, { 250,-1624 },
 { 251,-1624 }, { 252,-1624 }, { 253,-1624 }, { 254,-1624 }, { 255,-1624 },
 {   0,  70 }, {   0, 681 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-1881 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-1624 },
 {  49,-1624 }, {  50,-1624 }, {  51,-1624 }, {  52,-1624 }, {  53,-1624 },
 {  54,-1624 }, {  55,-1624 }, {  56,-1624 }, {  57,-1624 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-1881 }, {  66,-1881 }, {  67,-1881 }, {  68,-1881 },
 {  69,-1881 }, {  70,-1881 }, {  71,-1881 }, {  72,-1881 }, {  73,-1881 },
 {  74,-1881 }, {  75,-1881 }, {  76,-1881 }, {  77,-1881 }, {  78,-1881 },
 {  79,-1881 }, {  80,-1881 }, {  81,-1881 }, {  82,-1881 }, {  83,-1881 },
 {  84,-1881 }, {  85,-1881 }, {  86,-1881 }, {  87,-1881 }, {  88,-1881 },
 {  89,-1881 }, {  90,-1881 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,-1881 }, {   0,   0 }, {  97,-1881 }, {  98,-1881 },
 {  99,-1881 }, { 100,-1881 }, { 101,-1881 }, { 102,-1881 }, { 103,-1881 },
 { 104,-1881 }, { 105,-1881 }, { 106,-1881 }, { 107,-1881 }, { 108,-1881 },

 { 109,-1881 }, { 110,-1881 }, { 111,-1881 }, { 112,-1881 }, { 113,-1881 },
 { 114,-1881 }, { 115,-1881 }, { 116,-1881 }, { 117,-1881 }, { 118,-1881 },
 { 119,-1881 }, { 120,-1881 }, { 121,-1881 }, { 122,-1881 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-1881 },
 { 129,-1881 }, { 130,-1881 }, { 131,-1881 }, { 132,-1881 }, { 133,-1881 },
 { 134,-1881 }, { 135,-1881 }, { 136,-1881 }, { 137,-1881 }, { 138,-1881 },
 { 139,-1881 }, { 140,-1881 }, { 141,-1881 }, { 142,-1881 }, { 143,-1881 },
 { 144,-1881 }, { 145,-1881 }, { 146,-1881 }, { 147,-1881 }, { 148,-1881 },
 { 149,-1881 }, { 150,-1881 }, { 151,-1881 }, { 152,-1881 }, { 153,-1881 },
 { 154,-1881 }, { 155,-1881 }, { 156,-1881 }, { 157,-1881 }, { 158,-1881 },

 { 159,-1881 }, { 160,-1881 }, { 161,-1881 }, { 162,-1881 }, { 163,-1881 },
 { 164,-1881 }, { 165,-1881 }, { 166,-1881 }, { 167,-1881 }, { 168,-1881 },
 { 169,-1881 }, { 170,-1881 }, { 171,-1881 }, { 172,-1881 }, { 173,-1881 },
 { 174,-1881 }, { 175,-1881 }, { 176,-1881 }, { 177,-1881 }, { 178,-1881 },
 { 179,-1881 }, { 180,-1881 }, { 181,-1881 }, { 182,-1881 }, { 183,-1881 },
 { 184,-1881 }, { 185,-1881 }, { 186,-1881 }, { 187,-1881 }, { 188,-1881 },
 { 189,-1881 }, { 190,-1881 }, { 191,-1881 }, { 192,-1881 }, { 193,-1881 },
 { 194,-1881 }, { 195,-1881 }, { 196,-1881 }, { 197,-1881 }, { 198,-1881 },
 { 199,-1881 }, { 200,-1881 }, { 201,-1881 }, { 202,-1881 }, { 203,-1881 },
 { 204,-1881 }, { 205,-1881 }, { 206,-1881 }, { 207,-1881 }, { 208,-1881 },

 { 209,-1881 }, { 210,-1881 }, { 211,-1881 }, { 212,-1881 }, { 213,-1881 },
 { 214,-1881 }, { 215,-1881 }, { 216,-1881 }, { 217,-1881 }, { 218,-1881 },
 { 219,-1881 }, { 220,-1881 }, { 221,-1881 }, { 222,-1881 }, { 223,-1881 },
 { 224,-1881 }, { 225,-1881 }, { 226,-1881 }, { 227,-1881 }, { 228,-1881 },
 { 229,-1881 }, { 230,-1881 }, { 231,-1881 }, { 232,-1881 }, { 233,-1881 },
 { 234,-1881 }, { 235,-1881 }, { 236,-1881 }, { 237,-1881 }, { 238,-1881 },
 { 239,-1881 }, { 240,-1881 }, { 241,-1881 }, { 242,-1881 }, { 243,-1881 },
 { 244,-1881 }, { 245,-1881 }, { 246,-1881 }, { 247,-1881 }, { 248,-1881 },
 { 249,-1881 }, { 250,-1881 }, { 251,-1881 }, { 252,-1881 }, { 253,-1881 },
 { 254,-1881 }, { 255,-1881 }, {   0,  28 }, {   0, 424 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0, 401 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 },

 {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 },
 {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  28 }, {   0, 363 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 },
 {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 }, {  48,  61 },
 {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 },
 {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 },
 {   0,   0 }, {   0,  28 }, {   0, 340 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 },
 {  69,  61 }, {  70,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 },

 { 102,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,  82 }, {  49,  82 }, {  50,  82 },
 {  51,  82 }, {  52,  82 }, {  53,  82 }, {  54,  82 }, {  55,  82 },
 {  56,  82 }, {  57,  82 }, {   0,   0 }, {  97,  61 }, {  98,  61 },
 {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 }, {  65,  82 },
 {  66,  82 }, {  67,  82 }, {  68,  82 }, {  69,  82 }, {  70,  82 },
 {  48,  82 }, {  49,  82 }, {  50,  82 }, {  51,  82 }, {  52,  82 },
 {  53,  82 }, {  54,  82 }, {  55,  82 }, {  56,  82 }, {  57,  82 },
 {   0,  28 }, {   0, 281 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,  82 }, {  66,  82 }, {  67,  82 },

 {  68,  82 }, {  69,  82 }, {  70,  82 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,  82 }, {  98,  82 }, {  99,  82 }, { 100,  82 },
 { 101,  82 }, { 102,  82 }, {   0,   0 }, {   0,  28 }, {   0, 258 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  82 },
 {  98,  82 }, {  99,  82 }, { 100,  82 }, { 101,  82 }, { 102,  82 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-26506 },
 {  49,-26506 }, {  50,-26506 }, {  51,-26506 }, {  52,-26506 }, {  53,-26506 },
 {  54,-26506 }, {  55,-26506 }, {  56,-26506 }, {  57,-26506 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-26506 }, {  66,-26506 }, {  67,-26506 }, {  68,-26506 },
 {  69,-26506 }, {  70,-26506 }, {  48,-26527 }, {  49,-26527 }, {  50,-26527 },
 {  51,-26527 }, {  52,-26527 }, {  53,-26527 }, {  54,-26527 }, {  55,-26527 },
 {  56,-26527 }, {  57,-26527 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-26527 },
 {  66,-26527 }, {  67,-26527 }, {  68,-26527 }, {  69,-26527 }, {  70,-26527 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-26506 }, {  98,-26506 },
 {  99,-26506 }, { 100,-26506 }, { 101,-26506 }, { 102,-26506 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,-26527 }, {  98,-26527 }, {  99,-26527 }, { 100,-26527 },
 { 101,-26527 }, { 102,-26527 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 257,  74 }, {   1,   0 },    };

static __thread const struct yy_trans_info *yy_start_state_list[25] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],
    &yy_transition[2583],
    &yy_transition[2841],
    &yy_transition[3099],
    &yy_transition[3357],
    &yy_transition[3615],
    &yy_transition[3873],
    &yy_transition[4131],
    &yy_transition[4389],
    &yy_transition[4647],
    &yy_transition[4905],
    &yy_transition[5163],
    &yy_transition[5421],
    &yy_transition[5679],
    &yy_transition[5937],

    }
;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "scan.l"

#line 49 "scan.l"

/* LCOV_EXCL_START */

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/*
 * GUC variables.  This is a DIRECT violation of the warning given at the
 * head of gram.y, ie flex/bison code must not depend on any GUC variables;
 * as such, changing their values can induce very unintuitive behavior.
 * But we shall have to live with it until we can remove these variables.
 */
__thread int			backslash_quote = BACKSLASH_QUOTE_SAFE_ENCODING;

__thread bool		escape_string_warning = true;

__thread bool		standard_conforming_strings = true;


/*
 * Constant data exported from this file.  This array maps from the
 * zero-based keyword numbers returned by ScanKeywordLookup to the
 * Bison token numbers needed by gram.y.  This is exported because
 * callers need to pass it to scanner_init, if they are using the
 * standard keyword list ScanKeywords.
 */
#define PG_KEYWORD(kwname, value, category, collabel) value,

const uint16 ScanKeywordTokens[] = {
#include "parser/kwlist.h"
};

#undef PG_KEYWORD

/*
 * Set the type of YYSTYPE.
 */
#define YYSTYPE core_YYSTYPE

/*
 * Set the type of yyextra.  All state variables used by the scanner should
 * be in yyextra, *not* statically allocated.
 */
#define YY_EXTRA_TYPE core_yy_extra_type *

/*
 * Each call to yylex must set yylloc to the location of the found token
 * (expressed as a byte offset from the start of the input text).
 * When we parse a token that requires multiple lexer rules to process,
 * this should be done in the first such rule, else yylloc will point
 * into the middle of the token.
 */
#define SET_YYLLOC()  (*(yylloc) = yytext - yyextra->scanbuf)

/*
 * Advance yylloc by the given number of bytes.
 */
#define ADVANCE_YYLLOC(delta)  ( *(yylloc) += (delta) )

/*
 * Sometimes, we do want yylloc to point into the middle of a token; this is
 * useful for instance to throw an error about an escape sequence within a
 * string literal.  But if we find no error there, we want to revert yylloc
 * to the token start, so that that's the location reported to the parser.
 * Use PUSH_YYLLOC/POP_YYLLOC to save/restore yylloc around such code.
 * (Currently the implied "stack" is just one location, but someday we might
 * need to nest these.)
 */
#define PUSH_YYLLOC()	(yyextra->save_yylloc = *(yylloc))
#define POP_YYLLOC()	(*(yylloc) = yyextra->save_yylloc)

#define startlit()	( yyextra->literallen = 0 )
static void addlit(char *ytext, int yleng, core_yyscan_t yyscanner);
static void addlitchar(unsigned char ychar, core_yyscan_t yyscanner);
static char *litbufdup(core_yyscan_t yyscanner);
static unsigned char unescape_single_char(unsigned char c, core_yyscan_t yyscanner);
static int	process_integer_literal(const char *token, YYSTYPE *lval, int base);
static void addunicode(pg_wchar c, yyscan_t yyscanner);

#define yyerror(msg)  scanner_yyerror(msg, yyscanner)

#define lexer_errposition()  scanner_errposition(*(yylloc), yyscanner)

static void check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner);
static void check_escape_warning(core_yyscan_t yyscanner);

/*
 * Work around a bug in flex 2.5.35: it emits a couple of functions that
 * it forgets to emit declarations for.  Since we use -Wmissing-prototypes,
 * this would cause warnings.  Providing our own declarations should be
 * harmless even when the bug gets fixed.
 */
extern int	core_yyget_column(yyscan_t yyscanner);
extern void core_yyset_column(int column_no, yyscan_t yyscanner);

#line 8123 "scan.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal byte string
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xeu> Unicode surrogate pair in extended quoted string
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * non_newline_space tracks all the other space characters except newlines.
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {numericfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* Positional parameters don't accept underscores. */
/*
 * An identifier immediately following an integer literal is disallowed because
 * in some cases it's ambiguous what is meant: for example, 0x1234 could be
 * either a hexinteger or a decinteger "0" and an identifier "x1234".  We can
 * detect such problems by seeing if integer_junk matches a longer substring
 * than any of the XXXinteger patterns (decinteger, hexinteger, octinteger,
 * bininteger).  One "junk" pattern is sufficient because
 * {decinteger}{identifier} will match all the same strings we'd match with
 * {hexinteger}{identifier} etc.
 *
 * Note that the rule for integer_junk must appear after the ones for
 * XXXinteger to make this work correctly: 0x1234 will match both hexinteger
 * and integer_junk, and we need hexinteger to be chosen in that case.
 *
 * Also disallow strings matched by numeric_junk, real_junk and param_junk
 * for consistency.
 */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 8291 "scan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xqs 6
#define xe 7
#define xdolq 8
#define xui 9
#define xus 10
#define xeu 11

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    yy_size_t yy_n_chars;
    yy_size_t yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			yy_size_t yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		yy_size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 454 "scan.l"


#line 8587 "scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 456 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 460 "scan.l"
{
					SET_YYLLOC();
					return SQL_COMMENT;
				}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 465 "scan.l"
{
					/* Set location in case of syntax error in comment */
					SET_YYLLOC();
					yyextra->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK

case 4:
YY_RULE_SETUP
#line 475 "scan.l"
{
					(yyextra->xcdepth)++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 481 "scan.l"
{
					if (yyextra->xcdepth <= 0)
					{
						BEGIN(INITIAL);
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return C_COMMENT;
					}
					else
						(yyextra->xcdepth)--;
				}
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 492 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 496 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 500 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 504 "scan.l"
{
					yyerror("unterminated /* comment");
				}
	YY_BREAK
/* <xc> */
case 9:
YY_RULE_SETUP
#line 509 "scan.l"
{
					/* Binary bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "b" on the string
					 * to mark it for the input routine as a binary string.
					 */
					SET_YYLLOC();
					BEGIN(xb);
					startlit();
					addlitchar('b', yyscanner);
				}
	YY_BREAK
case 10:
/* rule 10 can match eol */
#line 522 "scan.l"
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 522 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 525 "scan.l"
{ yyerror("unterminated bit string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 527 "scan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					SET_YYLLOC();
					BEGIN(xh);
					startlit();
					addlitchar('x', yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 539 "scan.l"
{ yyerror("unterminated hexadecimal string literal"); }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 541 "scan.l"
{
					/* National character.
					 * We will pass this along as a normal character string,
					 * but preceded with an internally-generated "NCHAR".
					 */
					int		kwnum;

					SET_YYLLOC();
					yyless(1);	/* eat only 'n' this time */

					kwnum = ScanKeywordLookup("nchar",
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}
					else
					{
						/* If NCHAR isn't a keyword, just return "n" */
						yylval->str = pstrdup("n");
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return IDENT;
					}
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 568 "scan.l"
{
					yyextra->warn_on_first_escape = true;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					if (yyextra->standard_conforming_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 578 "scan.l"
{
					yyextra->warn_on_first_escape = false;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 585 "scan.l"
{
					SET_YYLLOC();
					if (!yyextra->standard_conforming_strings)
						ereport(ERROR,
								(errcode(ERRCODE_FEATURE_NOT_SUPPORTED),
								 errmsg("unsafe use of string constant with Unicode escapes"),
								 errdetail("String constants with Unicode escapes cannot be used when \"standard_conforming_strings\" is off."),
								 lexer_errposition()));
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 597 "scan.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					yyextra->state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 609 "scan.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(yyextra->state_before_str_stop);
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 618 "scan.l"
case 20:
/* rule 20 can match eol */
#line 619 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 619 "scan.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(INITIAL);

					switch (yyextra->state_before_str_stop)
					{
						case xb:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return BCONST;
						case xh:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return XCONST;
						case xq:
						case xe:
							/*
							 * Check that the data remains valid, if it might
							 * have been made invalid by unescaping any chars.
							 */
							if (yyextra->saw_non_ascii)
								pg_verifymbstr(yyextra->literalbuf,
											   yyextra->literallen,
											   false);
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return SCONST;
						case xus:
							yylval->str = litbufdup(yyscanner);
							yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
							return USCONST;
						default:
							yyerror("unhandled previous state in xqs");
					}
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 660 "scan.l"
{
					addlitchar('\'', yyscanner);
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 663 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 666 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 669 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/*
					 * For consistency with other productions, issue any
					 * escape warning with cursor pointing to start of string.
					 * We might want to change that, someday.
					 */
					check_escape_warning(yyscanner);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (is_utf16_surrogate_first(c))
					{
						yyextra->utf16_first_part = c;
						BEGIN(xeu);
					}
					else if (is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");
					else
						addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 697 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (!is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");

					c = surrogate_pair_to_codepoint(yyextra->utf16_first_part, c);

					addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();

					BEGIN(xe);
				}
	YY_BREAK
case 26:
#line 718 "scan.l"
case 27:
/* rule 27 can match eol */
#line 719 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xeu):
#line 719 "scan.l"
{
					/* Set the error cursor to point at missing esc seq */
					SET_YYLLOC();
					yyerror("invalid Unicode surrogate pair");
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 724 "scan.l"
{
					/* Set the error cursor to point at malformed esc seq */
					SET_YYLLOC();
					ereport(ERROR,
							(errcode(ERRCODE_INVALID_ESCAPE_SEQUENCE),
							 errmsg("invalid Unicode escape"),
							 errhint("Unicode escapes must be \\uXXXX or \\UXXXXXXXX."),
							 lexer_errposition()));
				}
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 733 "scan.l"
{
					if (yytext[1] == '\'')
					{
						if (yyextra->backslash_quote == BACKSLASH_QUOTE_OFF ||
							(yyextra->backslash_quote == BACKSLASH_QUOTE_SAFE_ENCODING &&
							 PG_ENCODING_IS_CLIENT_ONLY(pg_get_client_encoding())))
							ereport(ERROR,
									(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
									 errmsg("unsafe use of \\' in a string literal"),
									 errhint("Use '' to write quotes in strings. \\' is insecure in client-only encodings."),
									 lexer_errposition()));
					}
					check_string_escape_warning(yytext[1], yyscanner);
					addlitchar(unescape_single_char(yytext[1], yyscanner),
							   yyscanner);
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 749 "scan.l"
{
					unsigned char c = strtoul(yytext + 1, NULL, 8);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 757 "scan.l"
{
					unsigned char c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 765 "scan.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xus):
#line 769 "scan.l"
{ yyerror("unterminated quoted string"); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 771 "scan.l"
{
					SET_YYLLOC();
					yyextra->dolqstart = pstrdup(yytext);
					BEGIN(xdolq);
					startlit();
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 777 "scan.l"
{
					SET_YYLLOC();
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 784 "scan.l"
{
					if (strcmp(yytext, yyextra->dolqstart) == 0)
					{
						pfree(yyextra->dolqstart);
						yyextra->dolqstart = NULL;
						BEGIN(INITIAL);
						yylval->str = litbufdup(yyscanner);
						yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1, yyscanner);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 805 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 808 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 811 "scan.l"
{
					/* This is only needed for $ inside the quoted text */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 815 "scan.l"
{ yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 817 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 822 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 827 "scan.l"
{
					char	   *ident;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbufdup(yyscanner);
					if (yyextra->literallen >= NAMEDATALEN)
						truncate_identifier(ident, yyextra->literallen, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 840 "scan.l"
{
					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					/* can't truncate till after we de-escape the ident */
					yylval->str = litbufdup(yyscanner);
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return UIDENT;
				}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 849 "scan.l"
{
					addlitchar('"', yyscanner);
				}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 852 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 855 "scan.l"
{ yyerror("unterminated quoted identifier"); }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 857 "scan.l"
{
					char	   *ident;

					SET_YYLLOC();
					/* throw back all but the initial u/U */
					yyless(1);
					/* and treat it as {identifier} */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 870 "scan.l"
{
					SET_YYLLOC();
					return TYPECAST;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 875 "scan.l"
{
					SET_YYLLOC();
					return DOT_DOT;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 880 "scan.l"
{
					SET_YYLLOC();
					return COLON_EQUALS;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 885 "scan.l"
{
					SET_YYLLOC();
					return EQUALS_GREATER;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 890 "scan.l"
{
					SET_YYLLOC();
					return LESS_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 895 "scan.l"
{
					SET_YYLLOC();
					return GREATER_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 900 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 906 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 912 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 917 "scan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					SET_YYLLOC();

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					/*
					 * Complain if operator is too long.  Unlike the case
					 * for identifiers, we make this an error not a notice-
					 * and-truncate, because the odds are we are looking at
					 * a syntactic mistake anyway.
					 */
					if (nchars >= NAMEDATALEN)
						yyerror("operator too long");

					yylval->str = pstrdup(yytext);
					return Op;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 1025 "scan.l"
{
					SET_YYLLOC();
					yylval->ival = atol(yytext + 1);
					return PARAM;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 1031 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 10);
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 1035 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 16);
				}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 1039 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 8);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 1043 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 2);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 1047 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid hexadecimal integer");
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 1051 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid octal integer");
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 1055 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid binary integer");
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1059 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1064 "scan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 10);
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1070 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1075 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1079 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1083 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 1087 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1093 "scan.l"
{
					int			kwnum;
					char	   *ident;

					SET_YYLLOC();

					/* Is it a keyword? */
					kwnum = ScanKeywordLookup(yytext,
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}

					/*
					 * No.  Convert the identifier to lower case, and truncate
					 * if necessary.
					 */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					yyextra->yyllocend = yytext - yyextra->scanbuf + yyleng;
					return IDENT;
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1119 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 1124 "scan.l"
{
					SET_YYLLOC();
					yyterminate();
				}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1129 "scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 9586 "scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			yy_size_t offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
   


/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */


/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */


/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */


/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */


#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        yy_size_t yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */


/** Get the current line number.
 * @param yyscanner The scanner object.
 */


/** Get the current column number.
 * @param yyscanner The scanner object.
 */


/** Get the input stream.
 * @param yyscanner The scanner object.
 */


/** Get the output stream.
 * @param yyscanner The scanner object.
 */


/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */


/** Get the current token.
 * @param yyscanner The scanner object.
 */



/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */


/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */


/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */








/* Accessor methods for yylval and yylloc */






    

    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */


static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */


/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1129 "scan.l"


/* LCOV_EXCL_STOP */

/*
 * Arrange access to yyextra for subroutines of the main yylex() function.
 * We expect each subroutine to have a yyscanner parameter.  Rather than
 * use the yyget_xxx functions, which might or might not get inlined by the
 * compiler, we cheat just a bit and cast yyscanner to the right type.
 */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

/* Likewise for a couple of other things we need. */
#undef yylloc
#define yylloc	(((struct yyguts_t *) yyscanner)->yylloc_r)
#undef yyleng
#define yyleng	(((struct yyguts_t *) yyscanner)->yyleng_r)


/*
 * scanner_errposition
 *		Report a lexer or grammar error cursor position, if possible.
 *
 * This is expected to be used within an ereport() call, or via an error
 * callback such as setup_scanner_errposition_callback().  The return value
 * is a dummy (always 0, in fact).
 *
 * Note that this can only be used for messages emitted during raw parsing
 * (essentially, scan.l, parser.c, and gram.y), since it requires the
 * yyscanner struct to still be available.
 */
int
scanner_errposition(int location, core_yyscan_t yyscanner)
{
	int			pos;

	if (location < 0)
		return 0;				/* no-op if location is unknown */

	/* Convert byte offset to character number */
	pos = pg_mbstrlen_with_len(yyextra->scanbuf, location) + 1;
	/* And pass it to the ereport mechanism */
	return errposition(pos);
}

/*
 * Error context callback for inserting scanner error location.
 *
 * Note that this will be called for *any* error occurring while the
 * callback is installed.  We avoid inserting an irrelevant error location
 * if the error is a query cancel --- are there any other important cases?
 */
static void
scb_error_callback(void *arg)
{
	ScannerCallbackState *scbstate = (ScannerCallbackState *) arg;

	if (geterrcode() != ERRCODE_QUERY_CANCELED)
		(void) scanner_errposition(scbstate->location, scbstate->yyscanner);
}

/*
 * setup_scanner_errposition_callback
 *		Arrange for non-scanner errors to report an error position
 *
 * Sometimes the scanner calls functions that aren't part of the scanner
 * subsystem and can't reasonably be passed the yyscanner pointer; yet
 * we would like any errors thrown in those functions to be tagged with an
 * error location.  Use this function to set up an error context stack
 * entry that will accomplish that.  Usage pattern:
 *
 *		declare a local variable "ScannerCallbackState scbstate"
 *		...
 *		setup_scanner_errposition_callback(&scbstate, yyscanner, location);
 *		call function that might throw error;
 *		cancel_scanner_errposition_callback(&scbstate);
 */
void
setup_scanner_errposition_callback(ScannerCallbackState *scbstate,
								   core_yyscan_t yyscanner,
								   int location)
{
	/* Setup error traceback support for ereport() */
	scbstate->yyscanner = yyscanner;
	scbstate->location = location;
	scbstate->errcallback.callback = scb_error_callback;
	scbstate->errcallback.arg = (void *) scbstate;
	scbstate->errcallback.previous = error_context_stack;
	error_context_stack = &scbstate->errcallback;
}

/*
 * Cancel a previously-set-up errposition callback.
 */
void
cancel_scanner_errposition_callback(ScannerCallbackState *scbstate)
{
	/* Pop the error context stack */
	error_context_stack = scbstate->errcallback.previous;
}

/*
 * scanner_yyerror
 *		Report a lexer or grammar error.
 *
 * The message's cursor position is whatever YYLLOC was last set to,
 * ie, the start of the current token if called within yylex(), or the
 * most recently lexed token if called from the grammar.
 * This is OK for syntax error messages from the Bison parser, because Bison
 * parsers report error as soon as the first unparsable token is reached.
 * Beware of using yyerror for other purposes, as the cursor position might
 * be misleading!
 */
void
scanner_yyerror(const char *message, core_yyscan_t yyscanner)
{
	const char *loc = yyextra->scanbuf + *yylloc;

	if (*loc == YY_END_OF_BUFFER_CHAR)
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically the translation of "syntax error" */
				 errmsg("%s at end of input", _(message)),
				 lexer_errposition()));
	}
	else
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically the translation of "syntax error" */
				 errmsg("%s at or near \"%s\"", _(message), loc),
				 lexer_errposition()));
	}
}


/*
 * Called before any actual parsing is done
 */
core_yyscan_t
scanner_init(const char *str,
			 core_yy_extra_type *yyext,
			 const ScanKeywordList *keywordlist,
			 const uint16 *keyword_tokens)
{
	Size		slen = strlen(str);
	yyscan_t	scanner;

	if (yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	core_yyset_extra(yyext, scanner);

	yyext->keywordlist = keywordlist;
	yyext->keyword_tokens = keyword_tokens;

	yyext->backslash_quote = backslash_quote;
	yyext->escape_string_warning = escape_string_warning;
	yyext->standard_conforming_strings = standard_conforming_strings;

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	yyext->scanbuf = (char *) palloc(slen + 2);
	yyext->scanbuflen = slen;
	memcpy(yyext->scanbuf, str, slen);
	yyext->scanbuf[slen] = yyext->scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	yy_scan_buffer(yyext->scanbuf, slen + 2, scanner);

	/* initialize literal buffer to a reasonable but expansible size */
	yyext->literalalloc = 1024;
	yyext->literalbuf = (char *) palloc(yyext->literalalloc);
	yyext->literallen = 0;

	return scanner;
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(core_yyscan_t yyscanner)
{
	/*
	 * We don't bother to call yylex_destroy(), because all it would do is
	 * pfree a small amount of control storage.  It's cheaper to leak the
	 * storage until the parsing context is destroyed.  The amount of space
	 * involved is usually negligible compared to the output parse tree
	 * anyway.
	 *
	 * We do bother to pfree the scanbuf and literal buffer, but only if they
	 * represent a nontrivial amount of space.  The 8K cutoff is arbitrary.
	 */
	if (yyextra->scanbuflen >= 8192)
		pfree(yyextra->scanbuf);
	if (yyextra->literalalloc >= 8192)
		pfree(yyextra->literalbuf);
}


static void
addlit(char *ytext, int yleng, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + yleng) >= yyextra->literalalloc)
	{
		yyextra->literalalloc = pg_nextpower2_32(yyextra->literallen + yleng + 1);
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	memcpy(yyextra->literalbuf + yyextra->literallen, ytext, yleng);
	yyextra->literallen += yleng;
}


static void
addlitchar(unsigned char ychar, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + 1) >= yyextra->literalalloc)
	{
		yyextra->literalalloc *= 2;
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	yyextra->literalbuf[yyextra->literallen] = ychar;
	yyextra->literallen += 1;
}


/*
 * Create a palloc'd copy of literalbuf, adding a trailing null.
 */
static char *
litbufdup(core_yyscan_t yyscanner)
{
	int			llen = yyextra->literallen;
	char	   *new;

	new = palloc(llen + 1);
	memcpy(new, yyextra->literalbuf, llen);
	new[llen] = '\0';
	return new;
}

/*
 * Process {decinteger}, {hexinteger}, etc.  Note this will also do the right
 * thing with {numeric}, ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval, int base)
{
	ErrorSaveContext escontext = {T_ErrorSaveContext};
	int32		val;

	val = pg_strtoint32_safe(token, (Node *) &escontext);
	if (escontext.error_occurred)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = pstrdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
addunicode(pg_wchar c, core_yyscan_t yyscanner)
{
	ScannerCallbackState scbstate;
	char		buf[MAX_UNICODE_EQUIVALENT_STRING + 1];

	if (!is_valid_unicode_codepoint(c))
		yyerror("invalid Unicode escape value");

	/*
	 * We expect that pg_unicode_to_server() will complain about any
	 * unconvertible code point, so we don't have to set saw_non_ascii.
	 */
	setup_scanner_errposition_callback(&scbstate, yyscanner, *(yylloc));
	pg_unicode_to_server(c, (unsigned char *) buf);
	cancel_scanner_errposition_callback(&scbstate);
	addlit(buf, strlen(buf), yyscanner);
}

static unsigned char
unescape_single_char(unsigned char c, core_yyscan_t yyscanner)
{
	switch (c)
	{
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		case 'v':
			return '\v';
		default:
			/* check for backslash followed by non-7-bit-ASCII */
			if (c == '\0' || IS_HIGHBIT_SET(c))
				yyextra->saw_non_ascii = true;

			return c;
	}
}

static void
check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner)
{
	if (ychar == '\'')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\' in a string literal"),
					 errhint("Use '' to write quotes in strings, or use the escape string syntax (E'...')."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else if (ychar == '\\')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\\\ in a string literal"),
					 errhint("Use the escape string syntax for backslashes, e.g., E'\\\\'."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else
		check_escape_warning(yyscanner);
}

static void
check_escape_warning(core_yyscan_t yyscanner)
{
	if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
		ereport(WARNING,
				(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
				 errmsg("nonstandard use of escape in a string literal"),
		errhint("Use the escape string syntax for escapes, e.g., E'\\r\\n'."),
				 lexer_errposition()));
	yyextra->warn_on_first_escape = false;		/* warn only once per string */
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
core_yyalloc(yy_size_t bytes, core_yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
core_yyrealloc(void *ptr, yy_size_t bytes, core_yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}



