// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIDirectoryObject.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAIDirectoryObjectPrivate {
    friend class OAIDirectoryObject;

     QString id;
     bool id_isSet;
     bool id_isValid;

     QDateTime deleted_date_time;
     bool deleted_date_time_isSet;
     bool deleted_date_time_isValid;
};

OAIDirectoryObject::OAIDirectoryObject()
    : d_ptr()
{
}

OAIDirectoryObject::OAIDirectoryObject(const OAIDirectoryObject& other)
    : d_ptr(other.d_ptr)
{
}

OAIDirectoryObject::OAIDirectoryObject(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAIDirectoryObject::~OAIDirectoryObject() = default;

void OAIDirectoryObject::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAIDirectoryObjectPrivate{});

        Q_D(OAIDirectoryObject);


        d->id_isSet = false;
        d->id_isValid = false;

        d->deleted_date_time_isSet = false;
        d->deleted_date_time_isValid = false;
    }
}

void OAIDirectoryObject::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAIDirectoryObject::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAIDirectoryObject);

    d->id_isValid = ::OpenAPI::fromJsonValue(d->id, json[QString("id")]);
    d->id_isSet = !json[QString("id")].isNull() && d->id_isValid;

    d->deleted_date_time_isValid = ::OpenAPI::fromJsonValue(d->deleted_date_time, json[QString("deletedDateTime")]);
    d->deleted_date_time_isSet = !json[QString("deletedDateTime")].isNull() && d->deleted_date_time_isValid;
}

QString OAIDirectoryObject::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAIDirectoryObject::asJsonObject() const {
    Q_D(const OAIDirectoryObject);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->id_isSet) {
        obj.insert(QString("id"), ::OpenAPI::toJsonValue(d->id));
    }
    if (d->deleted_date_time_isSet) {
        obj.insert(QString("deletedDateTime"), ::OpenAPI::toJsonValue(d->deleted_date_time));
    }
    return obj;
}

QString OAIDirectoryObject::getId() const {
    Q_D(const OAIDirectoryObject);
    if(!d){
        return {};
    }
    return d->id;
}
void OAIDirectoryObject::setId(const QString &id) {
    Q_D(OAIDirectoryObject);
    Q_ASSERT(d);

    d->id = id;
    d->id_isSet = true;
}

bool OAIDirectoryObject::is_id_Set() const{
    Q_D(const OAIDirectoryObject);
    if(!d){
        return false;
    }

    return d->id_isSet;
}

bool OAIDirectoryObject::is_id_Valid() const{
    Q_D(const OAIDirectoryObject);
    if(!d){
        return false;
    }
    return d->id_isValid;
}

QDateTime OAIDirectoryObject::getDeletedDateTime() const {
    Q_D(const OAIDirectoryObject);
    if(!d){
        return {};
    }
    return d->deleted_date_time;
}
void OAIDirectoryObject::setDeletedDateTime(const QDateTime &deleted_date_time) {
    Q_D(OAIDirectoryObject);
    Q_ASSERT(d);

    d->deleted_date_time = deleted_date_time;
    d->deleted_date_time_isSet = true;
}

bool OAIDirectoryObject::is_deleted_date_time_Set() const{
    Q_D(const OAIDirectoryObject);
    if(!d){
        return false;
    }

    return d->deleted_date_time_isSet;
}

bool OAIDirectoryObject::is_deleted_date_time_Valid() const{
    Q_D(const OAIDirectoryObject);
    if(!d){
        return false;
    }
    return d->deleted_date_time_isValid;
}

bool OAIDirectoryObject::isSet() const {
    Q_D(const OAIDirectoryObject);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->id_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->deleted_date_time_isSet) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAIDirectoryObject::isValid() const {
    Q_D(const OAIDirectoryObject);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return true;
}

} // namespace OpenAPI
