# -*- coding: utf-8 -*-
""" unit definitions """

# NEURON's default units
mM = 1
ms = 1
mV = 1
µm = um = 1

# concentration
µM = uM = 1e-3 * mM
nM = 1e-6 * mM
M = 1e3 * mM

# time
µs = us = 1e-3 * ms
s = sec = 1e3 * ms
minute = 60 * sec
hour = 60 * minute
day = 24 * hour

# space
nm = 1e-3 * um
mm = 1000 * um
cm = 10 * mm
m = 100 * cm

# voltage
μV = uV = 1e-3 * mV
V = 1e3 * mV
