# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

import msrest.serialization

from ._security_insights_enums import *


class ResourceWithEtag(msrest.serialization.Model):
    """An azure resource object with an Etag property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(ResourceWithEtag, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = etag


class DataConnector(ResourceWithEtag):
    """Data connector.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AwsCloudTrailDataConnector, AADDataConnector, AATPDataConnector, ASCDataConnector, MCASDataConnector, MDATPDataConnector, OfficeDataConnector, TIDataConnector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AmazonWebServicesCloudTrail': 'AwsCloudTrailDataConnector', 'AzureActiveDirectory': 'AADDataConnector', 'AzureAdvancedThreatProtection': 'AATPDataConnector', 'AzureSecurityCenter': 'ASCDataConnector', 'MicrosoftCloudAppSecurity': 'MCASDataConnector', 'MicrosoftDefenderAdvancedThreatProtection': 'MDATPDataConnector', 'Office365': 'OfficeDataConnector', 'ThreatIntelligence': 'TIDataConnector'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(DataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'DataConnector'  # type: str


class AADDataConnector(DataConnector):
    """Represents AAD (Azure Active Directory) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :param tenant_id: The tenant id to connect to, and get the data from.
    :type tenant_id: str
    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        super(AADDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AzureActiveDirectory'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class AATPDataConnector(DataConnector):
    """Represents AATP (Azure Advanced Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :param tenant_id: The tenant id to connect to, and get the data from.
    :type tenant_id: str
    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        super(AATPDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AzureAdvancedThreatProtection'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class ActionPropertiesBase(msrest.serialization.Model):
    """Action property bag base.

    All required parameters must be populated in order to send to Azure.

    :param logic_app_resource_id: Required. Logic App Resource Id, /subscriptions/{my-
     subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-
     workflow-id}.
    :type logic_app_resource_id: str
    """

    _validation = {
        'logic_app_resource_id': {'required': True},
    }

    _attribute_map = {
        'logic_app_resource_id': {'key': 'logicAppResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logic_app_resource_id: str,
        **kwargs
    ):
        super(ActionPropertiesBase, self).__init__(**kwargs)
        self.logic_app_resource_id = logic_app_resource_id


class ActionRequest(ResourceWithEtag):
    """Action for alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param logic_app_resource_id: Logic App Resource Id, /subscriptions/{my-
     subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-
     workflow-id}.
    :type logic_app_resource_id: str
    :param trigger_uri: Logic App Callback URL for this specific workflow.
    :type trigger_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'logic_app_resource_id': {'key': 'properties.logicAppResourceId', 'type': 'str'},
        'trigger_uri': {'key': 'properties.triggerUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        logic_app_resource_id: Optional[str] = None,
        trigger_uri: Optional[str] = None,
        **kwargs
    ):
        super(ActionRequest, self).__init__(etag=etag, **kwargs)
        self.logic_app_resource_id = logic_app_resource_id
        self.trigger_uri = trigger_uri


class ActionRequestProperties(ActionPropertiesBase):
    """Action property bag.

    All required parameters must be populated in order to send to Azure.

    :param logic_app_resource_id: Required. Logic App Resource Id, /subscriptions/{my-
     subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-
     workflow-id}.
    :type logic_app_resource_id: str
    :param trigger_uri: Logic App Callback URL for this specific workflow.
    :type trigger_uri: str
    """

    _validation = {
        'logic_app_resource_id': {'required': True},
    }

    _attribute_map = {
        'logic_app_resource_id': {'key': 'logicAppResourceId', 'type': 'str'},
        'trigger_uri': {'key': 'triggerUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logic_app_resource_id: str,
        trigger_uri: Optional[str] = None,
        **kwargs
    ):
        super(ActionRequestProperties, self).__init__(logic_app_resource_id=logic_app_resource_id, **kwargs)
        self.trigger_uri = trigger_uri


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ActionResponse(Resource):
    """Action for alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the action.
    :type etag: str
    :param logic_app_resource_id: Logic App Resource Id, /subscriptions/{my-
     subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-
     workflow-id}.
    :type logic_app_resource_id: str
    :param workflow_id: The name of the logic app's workflow.
    :type workflow_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'logic_app_resource_id': {'key': 'properties.logicAppResourceId', 'type': 'str'},
        'workflow_id': {'key': 'properties.workflowId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        logic_app_resource_id: Optional[str] = None,
        workflow_id: Optional[str] = None,
        **kwargs
    ):
        super(ActionResponse, self).__init__(**kwargs)
        self.etag = etag
        self.logic_app_resource_id = logic_app_resource_id
        self.workflow_id = workflow_id


class ActionResponseProperties(ActionPropertiesBase):
    """Action property bag.

    All required parameters must be populated in order to send to Azure.

    :param logic_app_resource_id: Required. Logic App Resource Id, /subscriptions/{my-
     subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-
     workflow-id}.
    :type logic_app_resource_id: str
    :param workflow_id: The name of the logic app's workflow.
    :type workflow_id: str
    """

    _validation = {
        'logic_app_resource_id': {'required': True},
    }

    _attribute_map = {
        'logic_app_resource_id': {'key': 'logicAppResourceId', 'type': 'str'},
        'workflow_id': {'key': 'workflowId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        logic_app_resource_id: str,
        workflow_id: Optional[str] = None,
        **kwargs
    ):
        super(ActionResponseProperties, self).__init__(logic_app_resource_id=logic_app_resource_id, **kwargs)
        self.workflow_id = workflow_id


class ActionsList(msrest.serialization.Model):
    """List all the actions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of actions.
    :vartype next_link: str
    :param value: Required. Array of actions.
    :type value: list[~azure.mgmt.securityinsight.models.ActionResponse]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ActionResponse]'},
    }

    def __init__(
        self,
        *,
        value: List["ActionResponse"],
        **kwargs
    ):
        super(ActionsList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class AlertRule(ResourceWithEtag):
    """Alert rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FusionAlertRule, MicrosoftSecurityIncidentCreationAlertRule, ScheduledAlertRule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The alert rule kind.Constant filled by server.  Possible values include:
     "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion".
    :type kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Fusion': 'FusionAlertRule', 'MicrosoftSecurityIncidentCreation': 'MicrosoftSecurityIncidentCreationAlertRule', 'Scheduled': 'ScheduledAlertRule'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(AlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'AlertRule'  # type: str


class AlertRulesList(msrest.serialization.Model):
    """List all the alert rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of alert rules.
    :vartype next_link: str
    :param value: Required. Array of alert rules.
    :type value: list[~azure.mgmt.securityinsight.models.AlertRule]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AlertRule]'},
    }

    def __init__(
        self,
        *,
        value: List["AlertRule"],
        **kwargs
    ):
        super(AlertRulesList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class AlertRuleTemplate(Resource):
    """Alert rule template.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FusionAlertRuleTemplate, MicrosoftSecurityIncidentCreationAlertRuleTemplate, ScheduledAlertRuleTemplate.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param kind: Required. The alert rule kind.Constant filled by server.  Possible values include:
     "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion".
    :type kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Fusion': 'FusionAlertRuleTemplate', 'MicrosoftSecurityIncidentCreation': 'MicrosoftSecurityIncidentCreationAlertRuleTemplate', 'Scheduled': 'ScheduledAlertRuleTemplate'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'AlertRuleTemplate'  # type: str


class AlertRuleTemplateDataSource(msrest.serialization.Model):
    """alert rule template data sources.

    :param connector_id: The connector id that provides the following data types.
    :type connector_id: str
    :param data_types: The data types used by the alert rule template.
    :type data_types: list[str]
    """

    _attribute_map = {
        'connector_id': {'key': 'connectorId', 'type': 'str'},
        'data_types': {'key': 'dataTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        connector_id: Optional[str] = None,
        data_types: Optional[List[str]] = None,
        **kwargs
    ):
        super(AlertRuleTemplateDataSource, self).__init__(**kwargs)
        self.connector_id = connector_id
        self.data_types = data_types


class AlertRuleTemplatesList(msrest.serialization.Model):
    """List all the alert rule templates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of alert rule templates.
    :vartype next_link: str
    :param value: Required. Array of alert rule templates.
    :type value: list[~azure.mgmt.securityinsight.models.AlertRuleTemplate]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AlertRuleTemplate]'},
    }

    def __init__(
        self,
        *,
        value: List["AlertRuleTemplate"],
        **kwargs
    ):
        super(AlertRuleTemplatesList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class AlertsDataTypeOfDataConnector(msrest.serialization.Model):
    """Alerts data type for data connectors.

    :param alerts: Alerts data type connection.
    :type alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _attribute_map = {
        'alerts': {'key': 'alerts', 'type': 'DataConnectorDataTypeCommon'},
    }

    def __init__(
        self,
        *,
        alerts: Optional["DataConnectorDataTypeCommon"] = None,
        **kwargs
    ):
        super(AlertsDataTypeOfDataConnector, self).__init__(**kwargs)
        self.alerts = alerts


class ASCDataConnector(DataConnector):
    """Represents ASC (Azure Security Center) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :param subscription_id: The subscription id to connect to, and get the data from.
    :type subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        super(ASCDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AzureSecurityCenter'  # type: str
        self.data_types = data_types
        self.subscription_id = subscription_id


class DataConnectorWithAlertsProperties(msrest.serialization.Model):
    """Data connector properties.

    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        super(DataConnectorWithAlertsProperties, self).__init__(**kwargs)
        self.data_types = data_types


class ASCDataConnectorProperties(DataConnectorWithAlertsProperties):
    """ASC (Azure Security Center) data connector properties.

    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    :param subscription_id: The subscription id to connect to, and get the data from.
    :type subscription_id: str
    """

    _attribute_map = {
        'data_types': {'key': 'dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        subscription_id: Optional[str] = None,
        **kwargs
    ):
        super(ASCDataConnectorProperties, self).__init__(data_types=data_types, **kwargs)
        self.subscription_id = subscription_id


class AwsCloudTrailDataConnector(DataConnector):
    """Represents Amazon Web Services CloudTrail data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :param aws_role_arn: The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access
     the Aws account.
    :type aws_role_arn: str
    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.AwsCloudTrailDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'aws_role_arn': {'key': 'properties.awsRoleArn', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AwsCloudTrailDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        aws_role_arn: Optional[str] = None,
        data_types: Optional["AwsCloudTrailDataConnectorDataTypes"] = None,
        **kwargs
    ):
        super(AwsCloudTrailDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'AmazonWebServicesCloudTrail'  # type: str
        self.aws_role_arn = aws_role_arn
        self.data_types = data_types


class AwsCloudTrailDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for Amazon Web Services CloudTrail data connector.

    :param logs: Logs data type.
    :type logs: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _attribute_map = {
        'logs': {'key': 'logs', 'type': 'DataConnectorDataTypeCommon'},
    }

    def __init__(
        self,
        *,
        logs: Optional["DataConnectorDataTypeCommon"] = None,
        **kwargs
    ):
        super(AwsCloudTrailDataConnectorDataTypes, self).__init__(**kwargs)
        self.logs = logs


class DataConnectorDataTypeCommon(msrest.serialization.Model):
    """Common field for data type in data connectors.

    :param state: Describe whether this data type connection is enabled or not. Possible values
     include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "DataTypeState"]] = None,
        **kwargs
    ):
        super(DataConnectorDataTypeCommon, self).__init__(**kwargs)
        self.state = state


class AwsCloudTrailDataConnectorDataTypesLogs(DataConnectorDataTypeCommon):
    """Logs data type.

    :param state: Describe whether this data type connection is enabled or not. Possible values
     include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "DataTypeState"]] = None,
        **kwargs
    ):
        super(AwsCloudTrailDataConnectorDataTypesLogs, self).__init__(state=state, **kwargs)


class Bookmark(ResourceWithEtag):
    """Represents a bookmark in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param created: The time the bookmark was created.
    :type created: ~datetime.datetime
    :param created_by: Describes a user that created the bookmark.
    :type created_by: ~azure.mgmt.securityinsight.models.UserInfo
    :param display_name: The display name of the bookmark.
    :type display_name: str
    :param labels: List of labels relevant to this bookmark.
    :type labels: list[str]
    :param notes: The notes of the bookmark.
    :type notes: str
    :param query: The query of the bookmark.
    :type query: str
    :param query_result: The query result of the bookmark.
    :type query_result: str
    :param updated: The last time the bookmark was updated.
    :type updated: ~datetime.datetime
    :param updated_by: Describes a user that updated the bookmark.
    :type updated_by: ~azure.mgmt.securityinsight.models.UserInfo
    :param incident_info: Describes an incident that relates to bookmark.
    :type incident_info: ~azure.mgmt.securityinsight.models.IncidentInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'UserInfo'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'query_result': {'key': 'properties.queryResult', 'type': 'str'},
        'updated': {'key': 'properties.updated', 'type': 'iso-8601'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'UserInfo'},
        'incident_info': {'key': 'properties.incidentInfo', 'type': 'IncidentInfo'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        created: Optional[datetime.datetime] = None,
        created_by: Optional["UserInfo"] = None,
        display_name: Optional[str] = None,
        labels: Optional[List[str]] = None,
        notes: Optional[str] = None,
        query: Optional[str] = None,
        query_result: Optional[str] = None,
        updated: Optional[datetime.datetime] = None,
        updated_by: Optional["UserInfo"] = None,
        incident_info: Optional["IncidentInfo"] = None,
        **kwargs
    ):
        super(Bookmark, self).__init__(etag=etag, **kwargs)
        self.created = created
        self.created_by = created_by
        self.display_name = display_name
        self.labels = labels
        self.notes = notes
        self.query = query
        self.query_result = query_result
        self.updated = updated
        self.updated_by = updated_by
        self.incident_info = incident_info


class BookmarkList(msrest.serialization.Model):
    """List all the bookmarks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of cases.
    :vartype next_link: str
    :param value: Required. Array of bookmarks.
    :type value: list[~azure.mgmt.securityinsight.models.Bookmark]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Bookmark]'},
    }

    def __init__(
        self,
        *,
        value: List["Bookmark"],
        **kwargs
    ):
        super(BookmarkList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class ClientInfo(msrest.serialization.Model):
    """Information on the client (user or application) that made some action.

    :param email: The email of the client.
    :type email: str
    :param name: The name of the client.
    :type name: str
    :param object_id: The object id of the client.
    :type object_id: str
    :param user_principal_name: The user principal name of the client.
    :type user_principal_name: str
    """

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'user_principal_name': {'key': 'userPrincipalName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        name: Optional[str] = None,
        object_id: Optional[str] = None,
        user_principal_name: Optional[str] = None,
        **kwargs
    ):
        super(ClientInfo, self).__init__(**kwargs)
        self.email = email
        self.name = name
        self.object_id = object_id
        self.user_principal_name = user_principal_name


class DataConnectorList(msrest.serialization.Model):
    """List all the data connectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of data connectors.
    :vartype next_link: str
    :param value: Required. Array of data connectors.
    :type value: list[~azure.mgmt.securityinsight.models.DataConnector]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataConnector]'},
    }

    def __init__(
        self,
        *,
        value: List["DataConnector"],
        **kwargs
    ):
        super(DataConnectorList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class DataConnectorTenantId(msrest.serialization.Model):
    """Properties data connector on tenant level.

    :param tenant_id: The tenant id to connect to, and get the data from.
    :type tenant_id: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(DataConnectorTenantId, self).__init__(**kwargs)
        self.tenant_id = tenant_id


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.securityinsight.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.securityinsight.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FusionAlertRule(AlertRule):
    """Represents Fusion alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The alert rule kind.Constant filled by server.  Possible values include:
     "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion".
    :type kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :param alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :type alert_rule_template_name: str
    :ivar description: The description of the alert rule.
    :vartype description: str
    :ivar display_name: The display name for alerts created by this alert rule.
    :vartype display_name: str
    :param enabled: Determines whether this alert rule is enabled or disabled.
    :type enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :vartype severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :ivar tactics: The tactics of the alert rule.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'description': {'readonly': True},
        'display_name': {'readonly': True},
        'last_modified_utc': {'readonly': True},
        'severity': {'readonly': True},
        'tactics': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        alert_rule_template_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(FusionAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'Fusion'  # type: str
        self.alert_rule_template_name = alert_rule_template_name
        self.description = None
        self.display_name = None
        self.enabled = enabled
        self.last_modified_utc = None
        self.severity = None
        self.tactics = None


class FusionAlertRuleTemplate(AlertRuleTemplate):
    """Represents Fusion alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param kind: Required. The alert rule kind.Constant filled by server.  Possible values include:
     "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion".
    :type kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :param alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :type alert_rules_created_by_template_count: int
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :param description: The description of the alert rule template.
    :type description: str
    :param display_name: The display name for alert rule template.
    :type display_name: str
    :param required_data_connectors: The required data connectors for this template.
    :type required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :param status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :type status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :param severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :type severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :param tactics: The tactics of the alert rule template.
    :type tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        **kwargs
    ):
        super(FusionAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'Fusion'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.severity = severity
        self.tactics = tactics


class Incident(ResourceWithEtag):
    """Represents an incident in Azure Security Insights.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :ivar additional_data: Additional data on the incident.
    :vartype additional_data: ~azure.mgmt.securityinsight.models.IncidentAdditionalData
    :param classification: The reason the incident was closed. Possible values include:
     "Undetermined", "TruePositive", "BenignPositive", "FalsePositive".
    :type classification: str or ~azure.mgmt.securityinsight.models.IncidentClassification
    :param classification_comment: Describes the reason the incident was closed.
    :type classification_comment: str
    :param classification_reason: The classification reason the incident was closed with. Possible
     values include: "SuspiciousActivity", "SuspiciousButExpected", "IncorrectAlertLogic",
     "InaccurateData".
    :type classification_reason: str or
     ~azure.mgmt.securityinsight.models.IncidentClassificationReason
    :ivar created_time_utc: The time the incident was created.
    :vartype created_time_utc: ~datetime.datetime
    :param description: The description of the incident.
    :type description: str
    :param first_activity_time_utc: The time of the first activity in the incident.
    :type first_activity_time_utc: ~datetime.datetime
    :ivar incident_url: The deep-link url to the incident in Azure portal.
    :vartype incident_url: str
    :ivar incident_number: A sequential number.
    :vartype incident_number: int
    :param labels: List of labels relevant to this incident.
    :type labels: list[~azure.mgmt.securityinsight.models.IncidentLabel]
    :param last_activity_time_utc: The time of the last activity in the incident.
    :type last_activity_time_utc: ~datetime.datetime
    :ivar last_modified_time_utc: The last time the incident was updated.
    :vartype last_modified_time_utc: ~datetime.datetime
    :param owner: Describes a user that the incident is assigned to.
    :type owner: ~azure.mgmt.securityinsight.models.IncidentOwnerInfo
    :ivar related_analytic_rule_ids: List of resource ids of Analytic rules related to the
     incident.
    :vartype related_analytic_rule_ids: list[str]
    :param severity: The severity of the incident. Possible values include: "High", "Medium",
     "Low", "Informational".
    :type severity: str or ~azure.mgmt.securityinsight.models.IncidentSeverity
    :param status: The status of the incident. Possible values include: "New", "Active", "Closed".
    :type status: str or ~azure.mgmt.securityinsight.models.IncidentStatus
    :param title: The title of the incident.
    :type title: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'additional_data': {'readonly': True},
        'created_time_utc': {'readonly': True},
        'incident_url': {'readonly': True},
        'incident_number': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'related_analytic_rule_ids': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'additional_data': {'key': 'properties.additionalData', 'type': 'IncidentAdditionalData'},
        'classification': {'key': 'properties.classification', 'type': 'str'},
        'classification_comment': {'key': 'properties.classificationComment', 'type': 'str'},
        'classification_reason': {'key': 'properties.classificationReason', 'type': 'str'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'first_activity_time_utc': {'key': 'properties.firstActivityTimeUtc', 'type': 'iso-8601'},
        'incident_url': {'key': 'properties.incidentUrl', 'type': 'str'},
        'incident_number': {'key': 'properties.incidentNumber', 'type': 'int'},
        'labels': {'key': 'properties.labels', 'type': '[IncidentLabel]'},
        'last_activity_time_utc': {'key': 'properties.lastActivityTimeUtc', 'type': 'iso-8601'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'owner': {'key': 'properties.owner', 'type': 'IncidentOwnerInfo'},
        'related_analytic_rule_ids': {'key': 'properties.relatedAnalyticRuleIds', 'type': '[str]'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        classification: Optional[Union[str, "IncidentClassification"]] = None,
        classification_comment: Optional[str] = None,
        classification_reason: Optional[Union[str, "IncidentClassificationReason"]] = None,
        description: Optional[str] = None,
        first_activity_time_utc: Optional[datetime.datetime] = None,
        labels: Optional[List["IncidentLabel"]] = None,
        last_activity_time_utc: Optional[datetime.datetime] = None,
        owner: Optional["IncidentOwnerInfo"] = None,
        severity: Optional[Union[str, "IncidentSeverity"]] = None,
        status: Optional[Union[str, "IncidentStatus"]] = None,
        title: Optional[str] = None,
        **kwargs
    ):
        super(Incident, self).__init__(etag=etag, **kwargs)
        self.additional_data = None
        self.classification = classification
        self.classification_comment = classification_comment
        self.classification_reason = classification_reason
        self.created_time_utc = None
        self.description = description
        self.first_activity_time_utc = first_activity_time_utc
        self.incident_url = None
        self.incident_number = None
        self.labels = labels
        self.last_activity_time_utc = last_activity_time_utc
        self.last_modified_time_utc = None
        self.owner = owner
        self.related_analytic_rule_ids = None
        self.severity = severity
        self.status = status
        self.title = title


class IncidentAdditionalData(msrest.serialization.Model):
    """Incident additional data property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alerts_count: The number of alerts in the incident.
    :vartype alerts_count: int
    :ivar bookmarks_count: The number of bookmarks in the incident.
    :vartype bookmarks_count: int
    :ivar comments_count: The number of comments in the incident.
    :vartype comments_count: int
    :ivar alert_product_names: List of product names of alerts in the incident.
    :vartype alert_product_names: list[str]
    :ivar tactics: The tactics associated with incident.
    :vartype tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    """

    _validation = {
        'alerts_count': {'readonly': True},
        'bookmarks_count': {'readonly': True},
        'comments_count': {'readonly': True},
        'alert_product_names': {'readonly': True},
        'tactics': {'readonly': True},
    }

    _attribute_map = {
        'alerts_count': {'key': 'alertsCount', 'type': 'int'},
        'bookmarks_count': {'key': 'bookmarksCount', 'type': 'int'},
        'comments_count': {'key': 'commentsCount', 'type': 'int'},
        'alert_product_names': {'key': 'alertProductNames', 'type': '[str]'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IncidentAdditionalData, self).__init__(**kwargs)
        self.alerts_count = None
        self.bookmarks_count = None
        self.comments_count = None
        self.alert_product_names = None
        self.tactics = None


class IncidentComment(Resource):
    """Represents an incident comment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar created_time_utc: The time the comment was created.
    :vartype created_time_utc: ~datetime.datetime
    :param message: The comment message.
    :type message: str
    :ivar author: Describes the client that created the comment.
    :vartype author: ~azure.mgmt.securityinsight.models.ClientInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time_utc': {'readonly': True},
        'author': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'ClientInfo'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        **kwargs
    ):
        super(IncidentComment, self).__init__(**kwargs)
        self.created_time_utc = None
        self.message = message
        self.author = None


class IncidentCommentList(msrest.serialization.Model):
    """List of incident comments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of comments.
    :vartype next_link: str
    :param value: Required. Array of comments.
    :type value: list[~azure.mgmt.securityinsight.models.IncidentComment]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[IncidentComment]'},
    }

    def __init__(
        self,
        *,
        value: List["IncidentComment"],
        **kwargs
    ):
        super(IncidentCommentList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class IncidentInfo(msrest.serialization.Model):
    """Describes related incident information for the bookmark.

    All required parameters must be populated in order to send to Azure.

    :param incident_id: Required. Incident Id.
    :type incident_id: str
    :param severity: Required. The severity of the incident. Possible values include: "Critical",
     "High", "Medium", "Low", "Informational".
    :type severity: str or ~azure.mgmt.securityinsight.models.CaseSeverity
    :param title: Required. The title of the incident.
    :type title: str
    :param relation_name: Required. Relation Name.
    :type relation_name: str
    """

    _validation = {
        'incident_id': {'required': True},
        'severity': {'required': True},
        'title': {'required': True},
        'relation_name': {'required': True},
    }

    _attribute_map = {
        'incident_id': {'key': 'incidentId', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'relation_name': {'key': 'relationName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        incident_id: str,
        severity: Union[str, "CaseSeverity"],
        title: str,
        relation_name: str,
        **kwargs
    ):
        super(IncidentInfo, self).__init__(**kwargs)
        self.incident_id = incident_id
        self.severity = severity
        self.title = title
        self.relation_name = relation_name


class IncidentLabel(msrest.serialization.Model):
    """Represents an incident label.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param label_name: Required. The name of the label.
    :type label_name: str
    :ivar label_type: The type of the label. Possible values include: "User", "System".
    :vartype label_type: str or ~azure.mgmt.securityinsight.models.IncidentLabelType
    """

    _validation = {
        'label_name': {'required': True},
        'label_type': {'readonly': True},
    }

    _attribute_map = {
        'label_name': {'key': 'labelName', 'type': 'str'},
        'label_type': {'key': 'labelType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        label_name: str,
        **kwargs
    ):
        super(IncidentLabel, self).__init__(**kwargs)
        self.label_name = label_name
        self.label_type = None


class IncidentList(msrest.serialization.Model):
    """List all the incidents.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of incidents.
    :vartype next_link: str
    :param value: Required. Array of incidents.
    :type value: list[~azure.mgmt.securityinsight.models.Incident]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Incident]'},
    }

    def __init__(
        self,
        *,
        value: List["Incident"],
        **kwargs
    ):
        super(IncidentList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class IncidentOwnerInfo(msrest.serialization.Model):
    """Information on the user an incident is assigned to.

    :param email: The email of the user the incident is assigned to.
    :type email: str
    :param assigned_to: The name of the user the incident is assigned to.
    :type assigned_to: str
    :param object_id: The object id of the user the incident is assigned to.
    :type object_id: str
    :param user_principal_name: The user principal name of the user the incident is assigned to.
    :type user_principal_name: str
    """

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
        'assigned_to': {'key': 'assignedTo', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'user_principal_name': {'key': 'userPrincipalName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        assigned_to: Optional[str] = None,
        object_id: Optional[str] = None,
        user_principal_name: Optional[str] = None,
        **kwargs
    ):
        super(IncidentOwnerInfo, self).__init__(**kwargs)
        self.email = email
        self.assigned_to = assigned_to
        self.object_id = object_id
        self.user_principal_name = user_principal_name


class MCASDataConnector(DataConnector):
    """Represents MCAS (Microsoft Cloud App Security) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :param tenant_id: The tenant id to connect to, and get the data from.
    :type tenant_id: str
    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.MCASDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'MCASDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["MCASDataConnectorDataTypes"] = None,
        **kwargs
    ):
        super(MCASDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'MicrosoftCloudAppSecurity'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class MCASDataConnectorDataTypes(AlertsDataTypeOfDataConnector):
    """The available data types for MCAS (Microsoft Cloud App Security) data connector.

    :param alerts: Alerts data type connection.
    :type alerts: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    :param discovery_logs: Discovery log data type connection.
    :type discovery_logs: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _attribute_map = {
        'alerts': {'key': 'alerts', 'type': 'DataConnectorDataTypeCommon'},
        'discovery_logs': {'key': 'discoveryLogs', 'type': 'DataConnectorDataTypeCommon'},
    }

    def __init__(
        self,
        *,
        alerts: Optional["DataConnectorDataTypeCommon"] = None,
        discovery_logs: Optional["DataConnectorDataTypeCommon"] = None,
        **kwargs
    ):
        super(MCASDataConnectorDataTypes, self).__init__(alerts=alerts, **kwargs)
        self.discovery_logs = discovery_logs


class MDATPDataConnector(DataConnector):
    """Represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :param tenant_id: The tenant id to connect to, and get the data from.
    :type tenant_id: str
    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.AlertsDataTypeOfDataConnector
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'AlertsDataTypeOfDataConnector'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["AlertsDataTypeOfDataConnector"] = None,
        **kwargs
    ):
        super(MDATPDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'MicrosoftDefenderAdvancedThreatProtection'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class MicrosoftSecurityIncidentCreationAlertRule(AlertRule):
    """Represents MicrosoftSecurityIncidentCreation rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The alert rule kind.Constant filled by server.  Possible values include:
     "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion".
    :type kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :param display_names_filter: the alerts' displayNames on which the cases will be generated.
    :type display_names_filter: list[str]
    :param display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :type display_names_exclude_filter: list[str]
    :param product_filter: The alerts' productName on which the cases will be generated. Possible
     values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
     Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT".
    :type product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :param severities_filter: the alerts' severities on which the cases will be generated.
    :type severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    :param alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :type alert_rule_template_name: str
    :param description: The description of the alert rule.
    :type description: str
    :param display_name: The display name for alerts created by this alert rule.
    :type display_name: str
    :param enabled: Determines whether this alert rule is enabled or disabled.
    :type enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'last_modified_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'display_names_filter': {'key': 'properties.displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'properties.displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'properties.productFilter', 'type': 'str'},
        'severities_filter': {'key': 'properties.severitiesFilter', 'type': '[str]'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        product_filter: Optional[Union[str, "MicrosoftSecurityProductName"]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        alert_rule_template_name: Optional[str] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(MicrosoftSecurityIncidentCreationAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'MicrosoftSecurityIncidentCreation'  # type: str
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter
        self.alert_rule_template_name = alert_rule_template_name
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None


class MicrosoftSecurityIncidentCreationAlertRuleCommonProperties(msrest.serialization.Model):
    """MicrosoftSecurityIncidentCreation rule common property bag.

    All required parameters must be populated in order to send to Azure.

    :param display_names_filter: the alerts' displayNames on which the cases will be generated.
    :type display_names_filter: list[str]
    :param display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :type display_names_exclude_filter: list[str]
    :param product_filter: Required. The alerts' productName on which the cases will be generated.
     Possible values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure
     Advanced Threat Protection", "Azure Active Directory Identity Protection", "Azure Security
     Center for IoT".
    :type product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :param severities_filter: the alerts' severities on which the cases will be generated.
    :type severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        'product_filter': {'required': True},
    }

    _attribute_map = {
        'display_names_filter': {'key': 'displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'productFilter', 'type': 'str'},
        'severities_filter': {'key': 'severitiesFilter', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        product_filter: Union[str, "MicrosoftSecurityProductName"],
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        **kwargs
    ):
        super(MicrosoftSecurityIncidentCreationAlertRuleCommonProperties, self).__init__(**kwargs)
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter


class MicrosoftSecurityIncidentCreationAlertRuleProperties(MicrosoftSecurityIncidentCreationAlertRuleCommonProperties):
    """MicrosoftSecurityIncidentCreation rule property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param display_names_filter: the alerts' displayNames on which the cases will be generated.
    :type display_names_filter: list[str]
    :param display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :type display_names_exclude_filter: list[str]
    :param product_filter: Required. The alerts' productName on which the cases will be generated.
     Possible values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure
     Advanced Threat Protection", "Azure Active Directory Identity Protection", "Azure Security
     Center for IoT".
    :type product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :param severities_filter: the alerts' severities on which the cases will be generated.
    :type severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    :param alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :type alert_rule_template_name: str
    :param description: The description of the alert rule.
    :type description: str
    :param display_name: Required. The display name for alerts created by this alert rule.
    :type display_name: str
    :param enabled: Required. Determines whether this alert rule is enabled or disabled.
    :type enabled: bool
    :ivar last_modified_utc: The last time that this alert has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    """

    _validation = {
        'product_filter': {'required': True},
        'display_name': {'required': True},
        'enabled': {'required': True},
        'last_modified_utc': {'readonly': True},
    }

    _attribute_map = {
        'display_names_filter': {'key': 'displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'productFilter', 'type': 'str'},
        'severities_filter': {'key': 'severitiesFilter', 'type': '[str]'},
        'alert_rule_template_name': {'key': 'alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'lastModifiedUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        product_filter: Union[str, "MicrosoftSecurityProductName"],
        display_name: str,
        enabled: bool,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        alert_rule_template_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(MicrosoftSecurityIncidentCreationAlertRuleProperties, self).__init__(display_names_filter=display_names_filter, display_names_exclude_filter=display_names_exclude_filter, product_filter=product_filter, severities_filter=severities_filter, **kwargs)
        self.alert_rule_template_name = alert_rule_template_name
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None


class MicrosoftSecurityIncidentCreationAlertRuleTemplate(AlertRuleTemplate):
    """Represents MicrosoftSecurityIncidentCreation rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param kind: Required. The alert rule kind.Constant filled by server.  Possible values include:
     "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion".
    :type kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :param alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :type alert_rules_created_by_template_count: int
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :param description: The description of the alert rule template.
    :type description: str
    :param display_name: The display name for alert rule template.
    :type display_name: str
    :param required_data_connectors: The required data connectors for this template.
    :type required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :param status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :type status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :param display_names_filter: the alerts' displayNames on which the cases will be generated.
    :type display_names_filter: list[str]
    :param display_names_exclude_filter: the alerts' displayNames on which the cases will not be
     generated.
    :type display_names_exclude_filter: list[str]
    :param product_filter: The alerts' productName on which the cases will be generated. Possible
     values include: "Microsoft Cloud App Security", "Azure Security Center", "Azure Advanced Threat
     Protection", "Azure Active Directory Identity Protection", "Azure Security Center for IoT".
    :type product_filter: str or ~azure.mgmt.securityinsight.models.MicrosoftSecurityProductName
    :param severities_filter: the alerts' severities on which the cases will be generated.
    :type severities_filter: list[str or ~azure.mgmt.securityinsight.models.AlertSeverity]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'display_names_filter': {'key': 'properties.displayNamesFilter', 'type': '[str]'},
        'display_names_exclude_filter': {'key': 'properties.displayNamesExcludeFilter', 'type': '[str]'},
        'product_filter': {'key': 'properties.productFilter', 'type': 'str'},
        'severities_filter': {'key': 'properties.severitiesFilter', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        display_names_filter: Optional[List[str]] = None,
        display_names_exclude_filter: Optional[List[str]] = None,
        product_filter: Optional[Union[str, "MicrosoftSecurityProductName"]] = None,
        severities_filter: Optional[List[Union[str, "AlertSeverity"]]] = None,
        **kwargs
    ):
        super(MicrosoftSecurityIncidentCreationAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'MicrosoftSecurityIncidentCreation'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.display_names_filter = display_names_filter
        self.display_names_exclude_filter = display_names_exclude_filter
        self.product_filter = product_filter
        self.severities_filter = severities_filter


class OfficeConsent(Resource):
    """Consent for Office365 tenant that already made.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param tenant_id: The tenantId of the Office365 with the consent.
    :type tenant_id: str
    :ivar tenant_name: The tenant name of the Office365 with the consent.
    :vartype tenant_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tenant_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'tenant_name': {'key': 'properties.tenantName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        super(OfficeConsent, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.tenant_name = None


class OfficeConsentList(msrest.serialization.Model):
    """List of all the office365 consents.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of office consents.
    :vartype next_link: str
    :param value: Required. Array of the consents.
    :type value: list[~azure.mgmt.securityinsight.models.OfficeConsent]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OfficeConsent]'},
    }

    def __init__(
        self,
        *,
        value: List["OfficeConsent"],
        **kwargs
    ):
        super(OfficeConsentList, self).__init__(**kwargs)
        self.next_link = None
        self.value = value


class OfficeDataConnector(DataConnector):
    """Represents office data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :param tenant_id: The tenant id to connect to, and get the data from.
    :type tenant_id: str
    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.OfficeDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'OfficeDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["OfficeDataConnectorDataTypes"] = None,
        **kwargs
    ):
        super(OfficeDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'Office365'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class OfficeDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for office data connector.

    :param exchange: Exchange data type connection.
    :type exchange: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    :param share_point: SharePoint data type connection.
    :type share_point: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _attribute_map = {
        'exchange': {'key': 'exchange', 'type': 'DataConnectorDataTypeCommon'},
        'share_point': {'key': 'sharePoint', 'type': 'DataConnectorDataTypeCommon'},
    }

    def __init__(
        self,
        *,
        exchange: Optional["DataConnectorDataTypeCommon"] = None,
        share_point: Optional["DataConnectorDataTypeCommon"] = None,
        **kwargs
    ):
        super(OfficeDataConnectorDataTypes, self).__init__(**kwargs)
        self.exchange = exchange
        self.share_point = share_point


class OfficeDataConnectorDataTypesExchange(DataConnectorDataTypeCommon):
    """Exchange data type connection.

    :param state: Describe whether this data type connection is enabled or not. Possible values
     include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "DataTypeState"]] = None,
        **kwargs
    ):
        super(OfficeDataConnectorDataTypesExchange, self).__init__(state=state, **kwargs)


class OfficeDataConnectorDataTypesSharePoint(DataConnectorDataTypeCommon):
    """SharePoint data type connection.

    :param state: Describe whether this data type connection is enabled or not. Possible values
     include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "DataTypeState"]] = None,
        **kwargs
    ):
        super(OfficeDataConnectorDataTypesSharePoint, self).__init__(state=state, **kwargs)


class Operation(msrest.serialization.Model):
    """Operation provided by provider.

    :param display: Properties of the operation.
    :type display: ~azure.mgmt.securityinsight.models.OperationDisplay
    :param name: Name of the operation.
    :type name: str
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.display = display
        self.name = name


class OperationDisplay(msrest.serialization.Model):
    """Properties of the operation.

    :param description: Description of the operation.
    :type description: str
    :param operation: Operation name.
    :type operation: str
    :param provider: Provider name.
    :type provider: str
    :param resource: Resource name.
    :type resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationsList(msrest.serialization.Model):
    """Lists the operations available in the SecurityInsights RP.

    All required parameters must be populated in order to send to Azure.

    :param next_link: URL to fetch the next set of operations.
    :type next_link: str
    :param value: Required. Array of operations.
    :type value: list[~azure.mgmt.securityinsight.models.Operation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: List["Operation"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationsList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ScheduledAlertRule(AlertRule):
    """Represents scheduled alert rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The alert rule kind.Constant filled by server.  Possible values include:
     "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion".
    :type kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :param query: The query that creates alerts for this rule.
    :type query: str
    :param query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :type query_frequency: ~datetime.timedelta
    :param query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :type query_period: ~datetime.timedelta
    :param severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :type severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :param trigger_operator: The operation against the threshold that triggers alert rule. Possible
     values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
    :type trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :param trigger_threshold: The threshold triggers this alert rule.
    :type trigger_threshold: int
    :param alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :type alert_rule_template_name: str
    :param description: The description of the alert rule.
    :type description: str
    :param display_name: The display name for alerts created by this alert rule.
    :type display_name: str
    :param enabled: Determines whether this alert rule is enabled or disabled.
    :type enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :param suppression_duration: The suppression (in ISO 8601 duration format) to wait since last
     time this alert rule been triggered.
    :type suppression_duration: ~datetime.timedelta
    :param suppression_enabled: Determines whether the suppression for this alert rule is enabled
     or disabled.
    :type suppression_enabled: bool
    :param tactics: The tactics of the alert rule.
    :type tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'last_modified_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'query_frequency': {'key': 'properties.queryFrequency', 'type': 'duration'},
        'query_period': {'key': 'properties.queryPeriod', 'type': 'duration'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'trigger_operator': {'key': 'properties.triggerOperator', 'type': 'str'},
        'trigger_threshold': {'key': 'properties.triggerThreshold', 'type': 'int'},
        'alert_rule_template_name': {'key': 'properties.alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'suppression_duration': {'key': 'properties.suppressionDuration', 'type': 'duration'},
        'suppression_enabled': {'key': 'properties.suppressionEnabled', 'type': 'bool'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        alert_rule_template_name: Optional[str] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        enabled: Optional[bool] = None,
        suppression_duration: Optional[datetime.timedelta] = None,
        suppression_enabled: Optional[bool] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        **kwargs
    ):
        super(ScheduledAlertRule, self).__init__(etag=etag, **kwargs)
        self.kind = 'Scheduled'  # type: str
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold
        self.alert_rule_template_name = alert_rule_template_name
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.suppression_duration = suppression_duration
        self.suppression_enabled = suppression_enabled
        self.tactics = tactics


class ScheduledAlertRuleCommonProperties(msrest.serialization.Model):
    """Schedule alert rule template property bag.

    :param query: The query that creates alerts for this rule.
    :type query: str
    :param query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :type query_frequency: ~datetime.timedelta
    :param query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :type query_period: ~datetime.timedelta
    :param severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :type severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :param trigger_operator: The operation against the threshold that triggers alert rule. Possible
     values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
    :type trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :param trigger_threshold: The threshold triggers this alert rule.
    :type trigger_threshold: int
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'query_frequency': {'key': 'queryFrequency', 'type': 'duration'},
        'query_period': {'key': 'queryPeriod', 'type': 'duration'},
        'severity': {'key': 'severity', 'type': 'str'},
        'trigger_operator': {'key': 'triggerOperator', 'type': 'str'},
        'trigger_threshold': {'key': 'triggerThreshold', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        **kwargs
    ):
        super(ScheduledAlertRuleCommonProperties, self).__init__(**kwargs)
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold


class ScheduledAlertRuleProperties(ScheduledAlertRuleCommonProperties):
    """Scheduled alert rule base property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param query: The query that creates alerts for this rule.
    :type query: str
    :param query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :type query_frequency: ~datetime.timedelta
    :param query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :type query_period: ~datetime.timedelta
    :param severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :type severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :param trigger_operator: The operation against the threshold that triggers alert rule. Possible
     values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
    :type trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :param trigger_threshold: The threshold triggers this alert rule.
    :type trigger_threshold: int
    :param alert_rule_template_name: The Name of the alert rule template used to create this rule.
    :type alert_rule_template_name: str
    :param description: The description of the alert rule.
    :type description: str
    :param display_name: Required. The display name for alerts created by this alert rule.
    :type display_name: str
    :param enabled: Required. Determines whether this alert rule is enabled or disabled.
    :type enabled: bool
    :ivar last_modified_utc: The last time that this alert rule has been modified.
    :vartype last_modified_utc: ~datetime.datetime
    :param suppression_duration: Required. The suppression (in ISO 8601 duration format) to wait
     since last time this alert rule been triggered.
    :type suppression_duration: ~datetime.timedelta
    :param suppression_enabled: Required. Determines whether the suppression for this alert rule is
     enabled or disabled.
    :type suppression_enabled: bool
    :param tactics: The tactics of the alert rule.
    :type tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    """

    _validation = {
        'display_name': {'required': True},
        'enabled': {'required': True},
        'last_modified_utc': {'readonly': True},
        'suppression_duration': {'required': True},
        'suppression_enabled': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'query_frequency': {'key': 'queryFrequency', 'type': 'duration'},
        'query_period': {'key': 'queryPeriod', 'type': 'duration'},
        'severity': {'key': 'severity', 'type': 'str'},
        'trigger_operator': {'key': 'triggerOperator', 'type': 'str'},
        'trigger_threshold': {'key': 'triggerThreshold', 'type': 'int'},
        'alert_rule_template_name': {'key': 'alertRuleTemplateName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'last_modified_utc': {'key': 'lastModifiedUtc', 'type': 'iso-8601'},
        'suppression_duration': {'key': 'suppressionDuration', 'type': 'duration'},
        'suppression_enabled': {'key': 'suppressionEnabled', 'type': 'bool'},
        'tactics': {'key': 'tactics', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        display_name: str,
        enabled: bool,
        suppression_duration: datetime.timedelta,
        suppression_enabled: bool,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        alert_rule_template_name: Optional[str] = None,
        description: Optional[str] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        **kwargs
    ):
        super(ScheduledAlertRuleProperties, self).__init__(query=query, query_frequency=query_frequency, query_period=query_period, severity=severity, trigger_operator=trigger_operator, trigger_threshold=trigger_threshold, **kwargs)
        self.alert_rule_template_name = alert_rule_template_name
        self.description = description
        self.display_name = display_name
        self.enabled = enabled
        self.last_modified_utc = None
        self.suppression_duration = suppression_duration
        self.suppression_enabled = suppression_enabled
        self.tactics = tactics


class ScheduledAlertRuleTemplate(AlertRuleTemplate):
    """Represents scheduled alert rule template.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param kind: Required. The alert rule kind.Constant filled by server.  Possible values include:
     "Scheduled", "MicrosoftSecurityIncidentCreation", "Fusion".
    :type kind: str or ~azure.mgmt.securityinsight.models.AlertRuleKind
    :param alert_rules_created_by_template_count: the number of alert rules that were created by
     this template.
    :type alert_rules_created_by_template_count: int
    :ivar created_date_utc: The time that this alert rule template has been added.
    :vartype created_date_utc: ~datetime.datetime
    :param description: The description of the alert rule template.
    :type description: str
    :param display_name: The display name for alert rule template.
    :type display_name: str
    :param required_data_connectors: The required data connectors for this template.
    :type required_data_connectors:
     list[~azure.mgmt.securityinsight.models.AlertRuleTemplateDataSource]
    :param status: The alert rule template status. Possible values include: "Installed",
     "Available", "NotAvailable".
    :type status: str or ~azure.mgmt.securityinsight.models.TemplateStatus
    :param query: The query that creates alerts for this rule.
    :type query: str
    :param query_frequency: The frequency (in ISO 8601 duration format) for this alert rule to run.
    :type query_frequency: ~datetime.timedelta
    :param query_period: The period (in ISO 8601 duration format) that this alert rule looks at.
    :type query_period: ~datetime.timedelta
    :param severity: The severity for alerts created by this alert rule. Possible values include:
     "High", "Medium", "Low", "Informational".
    :type severity: str or ~azure.mgmt.securityinsight.models.AlertSeverity
    :param trigger_operator: The operation against the threshold that triggers alert rule. Possible
     values include: "GreaterThan", "LessThan", "Equal", "NotEqual".
    :type trigger_operator: str or ~azure.mgmt.securityinsight.models.TriggerOperator
    :param trigger_threshold: The threshold triggers this alert rule.
    :type trigger_threshold: int
    :param tactics: The tactics of the alert rule template.
    :type tactics: list[str or ~azure.mgmt.securityinsight.models.AttackTactic]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'created_date_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'alert_rules_created_by_template_count': {'key': 'properties.alertRulesCreatedByTemplateCount', 'type': 'int'},
        'created_date_utc': {'key': 'properties.createdDateUTC', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_data_connectors': {'key': 'properties.requiredDataConnectors', 'type': '[AlertRuleTemplateDataSource]'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'query_frequency': {'key': 'properties.queryFrequency', 'type': 'duration'},
        'query_period': {'key': 'properties.queryPeriod', 'type': 'duration'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'trigger_operator': {'key': 'properties.triggerOperator', 'type': 'str'},
        'trigger_threshold': {'key': 'properties.triggerThreshold', 'type': 'int'},
        'tactics': {'key': 'properties.tactics', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        alert_rules_created_by_template_count: Optional[int] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        required_data_connectors: Optional[List["AlertRuleTemplateDataSource"]] = None,
        status: Optional[Union[str, "TemplateStatus"]] = None,
        query: Optional[str] = None,
        query_frequency: Optional[datetime.timedelta] = None,
        query_period: Optional[datetime.timedelta] = None,
        severity: Optional[Union[str, "AlertSeverity"]] = None,
        trigger_operator: Optional[Union[str, "TriggerOperator"]] = None,
        trigger_threshold: Optional[int] = None,
        tactics: Optional[List[Union[str, "AttackTactic"]]] = None,
        **kwargs
    ):
        super(ScheduledAlertRuleTemplate, self).__init__(**kwargs)
        self.kind = 'Scheduled'  # type: str
        self.alert_rules_created_by_template_count = alert_rules_created_by_template_count
        self.created_date_utc = None
        self.description = description
        self.display_name = display_name
        self.required_data_connectors = required_data_connectors
        self.status = status
        self.query = query
        self.query_frequency = query_frequency
        self.query_period = query_period
        self.severity = severity
        self.trigger_operator = trigger_operator
        self.trigger_threshold = trigger_threshold
        self.tactics = tactics


class Settings(ResourceWithEtag):
    """The Settings.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ToggleSettings, UebaSettings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "UebaSettings", "ToggleSettings".
    :type kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'ToggleSettings': 'ToggleSettings', 'UebaSettings': 'UebaSettings'}
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(Settings, self).__init__(etag=etag, **kwargs)
        self.kind = 'Settings'  # type: str


class ThreatIntelligence(msrest.serialization.Model):
    """ThreatIntelligence property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar confidence: Confidence (must be between 0 and 1).
    :vartype confidence: float
    :ivar provider_name: Name of the provider from whom this Threat Intelligence information was
     received.
    :vartype provider_name: str
    :ivar report_link: Report link.
    :vartype report_link: str
    :ivar threat_description: Threat description (free text).
    :vartype threat_description: str
    :ivar threat_name: Threat name (e.g. "Jedobot malware").
    :vartype threat_name: str
    :ivar threat_type: Threat type (e.g. "Botnet").
    :vartype threat_type: str
    """

    _validation = {
        'confidence': {'readonly': True},
        'provider_name': {'readonly': True},
        'report_link': {'readonly': True},
        'threat_description': {'readonly': True},
        'threat_name': {'readonly': True},
        'threat_type': {'readonly': True},
    }

    _attribute_map = {
        'confidence': {'key': 'confidence', 'type': 'float'},
        'provider_name': {'key': 'providerName', 'type': 'str'},
        'report_link': {'key': 'reportLink', 'type': 'str'},
        'threat_description': {'key': 'threatDescription', 'type': 'str'},
        'threat_name': {'key': 'threatName', 'type': 'str'},
        'threat_type': {'key': 'threatType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ThreatIntelligence, self).__init__(**kwargs)
        self.confidence = None
        self.provider_name = None
        self.report_link = None
        self.threat_description = None
        self.threat_name = None
        self.threat_type = None


class TIDataConnector(DataConnector):
    """Represents threat intelligence data connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "AzureActiveDirectory", "AzureSecurityCenter", "MicrosoftCloudAppSecurity",
     "ThreatIntelligence", "Office365", "AmazonWebServicesCloudTrail",
     "AzureAdvancedThreatProtection", "MicrosoftDefenderAdvancedThreatProtection".
    :type kind: str or ~azure.mgmt.securityinsight.models.DataConnectorKind
    :param tenant_id: The tenant id to connect to, and get the data from.
    :type tenant_id: str
    :param data_types: The available data types for the connector.
    :type data_types: ~azure.mgmt.securityinsight.models.TIDataConnectorDataTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'data_types': {'key': 'properties.dataTypes', 'type': 'TIDataConnectorDataTypes'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        tenant_id: Optional[str] = None,
        data_types: Optional["TIDataConnectorDataTypes"] = None,
        **kwargs
    ):
        super(TIDataConnector, self).__init__(etag=etag, **kwargs)
        self.kind = 'ThreatIntelligence'  # type: str
        self.tenant_id = tenant_id
        self.data_types = data_types


class TIDataConnectorDataTypes(msrest.serialization.Model):
    """The available data types for TI (Threat Intelligence) data connector.

    :param indicators: Data type for indicators connection.
    :type indicators: ~azure.mgmt.securityinsight.models.DataConnectorDataTypeCommon
    """

    _attribute_map = {
        'indicators': {'key': 'indicators', 'type': 'DataConnectorDataTypeCommon'},
    }

    def __init__(
        self,
        *,
        indicators: Optional["DataConnectorDataTypeCommon"] = None,
        **kwargs
    ):
        super(TIDataConnectorDataTypes, self).__init__(**kwargs)
        self.indicators = indicators


class TIDataConnectorDataTypesIndicators(DataConnectorDataTypeCommon):
    """Data type for indicators connection.

    :param state: Describe whether this data type connection is enabled or not. Possible values
     include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.securityinsight.models.DataTypeState
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "DataTypeState"]] = None,
        **kwargs
    ):
        super(TIDataConnectorDataTypesIndicators, self).__init__(state=state, **kwargs)


class ToggleSettings(Settings):
    """Settings with single toggle.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "UebaSettings", "ToggleSettings".
    :type kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :param is_enabled: Determines whether the setting is enable or disabled.
    :type is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(ToggleSettings, self).__init__(etag=etag, **kwargs)
        self.kind = 'ToggleSettings'  # type: str
        self.is_enabled = is_enabled


class UebaSettings(Settings):
    """Represents settings for User and Entity Behavior Analytics enablement.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param etag: Etag of the azure resource.
    :type etag: str
    :param kind: Required. The data connector kind.Constant filled by server.  Possible values
     include: "UebaSettings", "ToggleSettings".
    :type kind: str or ~azure.mgmt.securityinsight.models.SettingKind
    :ivar atp_license_status: Determines whether the tenant has ATP (Advanced Threat Protection)
     license. Possible values include: "Enabled", "Disabled".
    :vartype atp_license_status: str or ~azure.mgmt.securityinsight.models.LicenseStatus
    :param is_enabled: Determines whether User and Entity Behavior Analytics is enabled for this
     workspace.
    :type is_enabled: bool
    :ivar status_in_mcas: Determines whether User and Entity Behavior Analytics is enabled from
     MCAS (Microsoft Cloud App Security). Possible values include: "Enabled", "Disabled".
    :vartype status_in_mcas: str or ~azure.mgmt.securityinsight.models.StatusInMcas
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'atp_license_status': {'readonly': True},
        'status_in_mcas': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'atp_license_status': {'key': 'properties.atpLicenseStatus', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'status_in_mcas': {'key': 'properties.statusInMcas', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(UebaSettings, self).__init__(etag=etag, **kwargs)
        self.kind = 'UebaSettings'  # type: str
        self.atp_license_status = None
        self.is_enabled = is_enabled
        self.status_in_mcas = None


class UserInfo(msrest.serialization.Model):
    """User information that made some action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar email: The email of the user.
    :vartype email: str
    :ivar name: The name of the user.
    :vartype name: str
    :param object_id: Required. The object id of the user.
    :type object_id: str
    """

    _validation = {
        'email': {'readonly': True},
        'name': {'readonly': True},
        'object_id': {'required': True},
    }

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_id: str,
        **kwargs
    ):
        super(UserInfo, self).__init__(**kwargs)
        self.email = None
        self.name = None
        self.object_id = object_id
