% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat.R
\name{cat_line}
\alias{cat_line}
\alias{cat_bullet}
\alias{cat_boxx}
\alias{cat_rule}
\alias{cat_print}
\title{\code{cat()} helpers}
\usage{
cat_line(..., col = NULL, background_col = NULL, file = stdout())

cat_bullet(
  ...,
  col = NULL,
  background_col = NULL,
  bullet = "bullet",
  bullet_col = NULL,
  file = stdout()
)

cat_boxx(..., file = stdout())

cat_rule(..., file = stdout())

cat_print(x, file = "")
}
\arguments{
\item{...}{For \code{cat_line()} and \code{cat_bullet()}, paste'd together with
\code{collapse = "\\n"}. For \code{cat_rule()} and \code{cat_boxx()} passed on to
\code{\link[=rule]{rule()}} and \code{\link[=boxx]{boxx()}} respectively.}

\item{col, background_col, bullet_col}{Colours for text, background, and
bullets respectively.}

\item{file}{Output destination. Defaults to standard output.}

\item{bullet}{Name of bullet character. Indexes into \link{symbol}}

\item{x}{An object to print.}
}
\description{
These helpers provide useful wrappers around \code{\link[=cat]{cat()}}: most importantly
they all set \code{sep = ""}, and \code{cat_line()} automatically adds a newline.
}
\examples{
cat_line("This is ", "a ", "line of text.", col = "red")
cat_bullet(letters[1:5])
cat_bullet(letters[1:5], bullet = "tick", bullet_col = "green")
cat_rule()
}
