/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.picking;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickableNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;

public class BasePickableGroup
extends BaseGroupingNode
implements VRMLPickableNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{80};
    protected static final int FIELD_PICKABLE = 6;
    protected static final int FIELD_OBJECT_TYPE = 7;
    protected static final int LAST_PICK_INDEX = 7;
    protected static final int NUM_FIELDS = 8;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected String[] vfObjectType;
    protected boolean vfPickable;

    public BasePickableGroup() {
        super("PickableGroup");
        this.hasChanged = new boolean[8];
        this.vfObjectType = FieldConstants.EMPTY_MFSTRING;
        this.vfPickable = true;
    }

    public BasePickableGroup(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("objectType");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfObjectType = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfObjectType, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("pickable");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPickable = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setObjectType(String[] stringArray, int n) {
        if (this.vfObjectType.length != n) {
            this.vfObjectType = new String[n];
        }
        System.arraycopy(stringArray, 0, this.vfObjectType, 0, n);
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    public int numObjectType() {
        return this.vfObjectType.length;
    }

    public void getObjectType(String[] stringArray) {
        System.arraycopy(this.vfObjectType, 0, stringArray, 0, this.vfObjectType.length);
    }

    public void setPickable(boolean bl) {
        this.vfPickable = bl;
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    public boolean getPickable() {
        return this.vfPickable;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = this.vfObjectType.length;
                vRMLFieldData.stringArrayValue = this.vfObjectType;
                vRMLFieldData.dataType = (short)14;
                break;
            }
            case 6: {
                vRMLFieldData.booleanValue = this.vfPickable;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfPickable);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfObjectType, this.vfObjectType.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTransform.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setPickable(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                this.setObjectType(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(8);
        BasePickableGroup.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePickableGroup.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BasePickableGroup.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BasePickableGroup.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BasePickableGroup.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BasePickableGroup.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BasePickableGroup.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFString", "objectType");
        BasePickableGroup.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFBool", "pickable");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(7);
        fieldMap.put("objectType", n);
        fieldMap.put("set_objectType", n);
        fieldMap.put("objectType_changed", n);
        n = new Integer(6);
        fieldMap.put("pickable", n);
        fieldMap.put("set_pickable", n);
        fieldMap.put("pickable_changed", n);
    }
}

