/*
 * (llc_evnt.c)-LLC station component event match functions

 * Description :
 *   Functions in this module are implemetation of station component events.
 *   Details of events can be found in IEEE-802.2 standard document.
 *   All functions have one station and one event as input argument. All of 
 *   them return 0 On success and 1 otherwise.
 *
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 

#define LLC_EVNT_C


#include <net/cm_types.h>
#include <net/cm_mm.h>
#include <net/cm_dll.h>
#include <net/cm_frame.h>
#include <net/llc_if.h>
#include <net/llc_sap.h>
#include <net/llc_conn.h>
#include <net/llc_main.h>
#include <net/llc_evnt.h>
#include <net/llc_pdu.h>
#include <net/llc_dbg.h>

#ifdef LLC_EVNT_DBG
  #define  DBG_MSG(body) { printk body; }
#else
  #define  DBG_MSG(body)  ;
#endif


us16
stat_ev_enable_with_dup_addr_check(station_t * station,
						station_state_event_t * event)
{
	return (((event->type == STATION_EV_TYPE_SIMPLE) &&
			(event->data.a.event ==
			STATION_EV_ENABLE_WITH_DUP_ADDR_CHECK)) ? 0 : 1);
}



us16
stat_ev_enable_without_dup_addr_check (station_t * station,
						station_state_event_t * event)
{
	return (((event->type == STATION_EV_TYPE_SIMPLE) &&
				(event->data.a.event == 
				STATION_EV_ENABLE_WITHOUT_DUP_ADDR_CHECK)) ? 0 : 1);
}



us16
stat_ev_ack_timer_expired_lt_retry_count_max_retry (station_t * station,
					station_state_event_t * event)
{
	return (((event->type == STATION_EV_TYPE_ACK_TIMER) &&
			(station->retry_count < station->maximum_retry)) ? 0 : 1);
}


us16
stat_ev_ack_timer_expired_eq_retry_count_max_retry (station_t * station,
						station_state_event_t * event)
{
	return (((event->type == STATION_EV_TYPE_ACK_TIMER) &&
		(station->retry_count == station->maximum_retry)) ? 0 : 1);
}


us16
stat_ev_rx_null_dsap_xid_c(station_t * station, station_state_event_t * event)
{
	pdu_un_t *	pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == STATION_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_CMD(pdu)) &&		/* command PDU */
		(!LLC_PDU_TYPE_IS_U(pdu)) &&		/* U type PDU */
		(LLC_U_PDU_CMD(pdu) == LLC_1_PDU_CMD_XID) &&
		(!pdu->dsap)) ? 0 : 1);			/* NULL DSAP value */
}



us16
stat_ev_rx_null_dsap_0_xid_r_xid_r_count_eq (station_t * station,
						station_state_event_t * event)
{
	pdu_un_t *	pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == STATION_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_RSP(pdu)) &&		/* response PDU */
		(!LLC_PDU_TYPE_IS_U(pdu)) &&		/* U type PDU */
		(LLC_U_PDU_RSP(pdu) == LLC_1_PDU_CMD_XID) &&
		(!pdu->dsap) &&				/* NULL DSAP value */
		(!station->xid_r_count)) ? 0 : 1);
}



us16
stat_ev_rx_null_dsap_1_xid_r_xid_r_count_eq (station_t * station,
						station_state_event_t * event)
{
	pdu_un_t *      pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == STATION_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_RSP(pdu)) &&		/* response PDU */
		(!LLC_PDU_TYPE_IS_U(pdu)) &&		/* U type PDU */
		(LLC_U_PDU_RSP(pdu) == LLC_1_PDU_CMD_XID) &&
		(!pdu->dsap) &&				/* NULL DSAP value */
		(station->xid_r_count == 1)) ? 0 : 1);
}



us16
stat_ev_rx_null_dsap_test_c (station_t * station, station_state_event_t * event)
{
	pdu_un_t *	pdu = (pdu_un_t *) event->data.pdu.frame->llc_hdr;

	return (((event->type == STATION_EV_TYPE_PDU) &&
		(!LLC_PDU_IS_CMD(pdu)) &&		/* command PDU */
		(!LLC_PDU_TYPE_IS_U(pdu)) &&		/* U type PDU */
		(LLC_U_PDU_CMD(pdu) == LLC_1_PDU_CMD_TEST) &&
		(!pdu->dsap)) ? 0 : 1);			/* NULL DSAP */
}



us16
stat_ev_disable_request (station_t * station, station_state_event_t * event)
{
	return (((event->type == STATION_EV_TYPE_PRIM) &&
		(event->data.prim.prim == DISABLE_PRIM) &&
		(event->data.prim.type == PRIM_TYPE_REQUEST)) ? 0 : 1);
}
