#ifndef _VTUNE_VTDEF_H
#define _VTUNE_VTDEF_H

/*
 *  vtdef.h
 *
 *  Copyright (C) 2003 Intel Corporation
 *  Author/Maintainer - George W Artz <george.w.artz@intel.com>
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */
/*
 *  Author(s): 
 *
 *  File: vtdef.h
 *
 *  system: VTune Linux Sampling Driver
 *
 */

#include "include/vtypes.h"

#define SYS_VERSION_MAJOR               0
#define SYS_VERSION_MINOR               914

#define  PCMINOR                        0   /* /dev/vtune minor number */
#define  MDMINOR                        1   /* /dev/vtune_m */
#define  PIDMINOR                       2   /* /dev/vtune_p */

#define VFLAG_OFF                       0
#define VFLAG_ON                        1
#define SAMPMODE_MANUAL                 -1

#define XHDRM_SAMPLE_QTY                2
#define P6_FAMILY                       6

#define VTUNE_PERFMON_IRQ               0xED

#define CPUFAMILY                       0xF00

#define emask_t unsigned long

/*  NEW */
#define APIC_PERFLVT_FIXED_ENA          0x02000 /* fixed mode */
#define APIC_PERFLVT_INT_MASK           0x10000 /* mask perf interrupt 0=ints not masked, 1=perf ints masked */
#define APIC_TIMERLVT_ENA               0x22000 /* local apic timer enable */

#define APIC_BASE_MSR        0x1B   // apic base msr
#define APIC_BASE_MSR_ENABLE 0x800  // apic enable/disable bit

//#define EBS_CONFIG_SMP                    1

#define MAXNAMELEN                      256

/*---------------------------------------------------------------*/
/*
 *         performance Monitor Model Specific registers
 */
/*---------------------------------------------------------------*/

#define EM_MSR_TSC         0x10 /* Time Stamp Counter */
#define EM_MSR_CESR        0x11 /* control and Event Select */
#define EM_MSR_CTR0        0x12 /* Counter 0 */
#define EM_MSR_CTR1        0x13 /* Counter 1 */
/*** P6 Code ***/
/** P6 MSR's **/
#define EM_MSR_PESR0        0x186   /* performance Event Select */
#define EM_MSR_PESR1        0x187   /* performance Event Select */
#define EM_MSR_PCTR0        0x0C1   /* P6 Counter 0 */
#define EM_MSR_PCTR1        0x0C2   /* P6 Counter 1 */

/* 
 *  Pentium Pro, II, III PESR mask controls
 *
 *        33222222 2 2 2 2 1 1 1 1 11111100 00000000
 *        10987654 3 2 1 0 9 8 7 6 54321098 76543210
 *       +--------+-+-+-+-+-+-+-+-+--------+--------+
 *       |        |I|E|r|I|P|E|O|U|        |        |
 *       |  CMSK  |N|N|s|N|C| |S|S|  UMSK  |   ES   |
 *       |        |V| |v|T| | | |E|        |        |
 *       |        | | |d| | | | |R|        |        |
 *       +--------+-+-+-+-+-+-+-+-+--------+--------+
 */

#define EM_PERF_DISABLE         0x0003FFFF
#define EM_ES_MASK              0x000000FF
#define EM_UMSK_MASK            0x0000FF00
#define EM_USER_MASK            0x00010000
#define EM_OS_MASK              0x00020000
#define EM_E_MASK               0x00040000
#define EM_PC_MASK              0x00080000
#define EM_INT_MASK             0x00100000
#define EM_EN_MASK              0x00400000
#define EM_INV_MASK             0x00800000
#define EM_CMSK_MASK            0xFF000000

#ifdef linux64


#define itp_read_reg_pmc(a)     ia64_get_pmc(a)
#define itp_read_reg_pmd(a)     ia64_get_pmd(a)
#define itp_read_reg_pmv()      itp_get_pmv()

#define itp_write_reg_pmc(a, b) ia64_set_pmc(a, b)
#define itp_write_reg_pmd(a, b) ia64_set_pmd(a, b)
#define itp_write_reg_pmv(a)    ia64_set_pmv(a)

#define itp_get_cpuid(a)        ia64_get_cpuid(a)
#define itp_srlz_d()            ia64_srlz_d()
#define itp_get_dcr()           ia64_get_dcr()
#define itp_set_dcr(a)          ia64_set_dcr(a)

static __inline__ unsigned long
itp_get_itc(void)
{
    unsigned long result;

    __asm__ __volatile__("mov %0=ar.itc":"=r"(result)::"memory");
    return result;
}

static inline __u64
itp_get_pmv(void)
{
    __u64 r;
      __asm__("mov %0=cr.pmv":"=r"(r));
    return r;
}

//
// GDT entry
//

typedef struct _KGDTENTRY {
    __u16 limit_low;
    __u16 base_low;
    union {
        struct {
            char base_mid;
            char flags1;    // Declare as bytes to avoid alignment
            char flags2;    // Problems.
            char base_hi;
        } bytes;
        struct {
            __u32 base_mid:8;
            __u32 type:5;
            __u32 dpl:2;
            __u32 pres:1;
            __u32 limit_hi:4;
            __u32 sys:1;
            __u32 reserved_0:1;
            __u32 default_big:1;
            __u32 granularity:1;
            __u32 base_hi:8;
        } bits;
    } high_word;
} KGDTENTRY, *PKGDTENTRY;

#define TYPE_TSS    0x01    // 01001 = NonBusy TSS
#define TYPE_LDT    0x02    // 00010 = LDT

//
// UnScrambled Descriptor format
//
typedef struct _KDESCRIPTOR_UNSCRAM {
    union {
        __u64 descriptor_words;
        struct {
            __u64 base:32;
            __u64 limit:20;
            __u64 type:5;
            __u64 dpl:2;
            __u64 pres:1;
            __u64 sys:1;
            __u64 reserved_0:1;
            __u64 default_big:1;
            __u64 granularity:1;
        } bits;
    } words;
} KXDESCRIPTOR, *PKXDESCRIPTOR;

#define TYPE_CODE_USER                0x1A  // 0x11011 = Code, Readable, Accessed
#define TYPE_DATA_USER                0x13  // 0x10011 = Data, Readwrite, Accessed

#define DESCRIPTOR_EXPAND_DOWN        0x14
#define DESCRIPTOR_DATA_READWRITE     (0x8|0x2) // Data, Read/write

#define DPL_USER    3
#define DPL_SYSTEM  0

#define GRAN___u8   0
#define GRAN_PAGE   1

#define SELECTOR_TABLE_INDEX 0x04

#endif              // linux64


// Defines for Linux list functions
#define LIST_ENTRY   struct list_head
#define PLIST_ENTRY  LIST_ENTRY *

#define non_paged_pool 0

/*
 * ===========================================================================
 *      5-04-01 - TVK (New Model Port ) 
 * ===========================================================================
 */

#define STATUS_SUCCESS           0
#define STATUS_INVALID_PARAMETER -EINVAL
#define STATUS_NOT_SUPPORTED     -ENOSYS
#define STATUS_DEVICE_BUSY       -EBUSY

#define MAX_ACTIVE_EVENTS        32

#define MAXIMUM_PROCESSORS       32
#define MAX_REG_SET_ENTRIES      120

#define IA32_FAMILY5_MAX_COUNTER 0x0ffffffffff  // max counter on P5... cpu counters are 40 bits
#define IA32_FAMILY6_MAX_COUNTER 0x0ffffffffff  // max counter on P6... cpu counters are 40 bits
#define IA32_FAMILYF_MAX_COUNTER 0x0ffffffffff  // max counter on P4... cpu counters are 40 bits

typedef struct _REG_SET {
    __u8 options;
    __u8 pmc_num;
    union {
        __u8 c_index;   // if this is a CCCR, then ctrindex is the
        // index for the associated counter... 
        // reg_setx[ctrindex] is associated counter

        __u8 event_I_dindex;    // index of this event in the event ID table
    };

    __u8 event_ID;      // event ID passed to SampConfigure routine
    // in event_reg_set_ex structure
    __u32 reg_num;

    __u32 c_ovf[MAXIMUM_PROCESSORS];    // counter overflow status for
    // each cpu... non zero = xounter
    // has overflowed on that cpu
    ULARGE_INTEGER reg_val;

    ULARGE_INTEGER event_inc;   // value added to event_total on counter
    // overflow interrupt      03-30-01

    ULARGE_INTEGER event_total[MAXIMUM_PROCESSORS]; // event total from start of
    // sampling session   03-30-01
} REG_SET, *PREG_SET;

// Defines for REG_SET options field
#define REG_SET_CCCR            0x01    // this entry is a CCCR
#define REG_SET_COUNTER         0x02    // this entry is a counter
#define REG_SET_CINDEX_VALID    0x04    // indexToCtr is set

// Defines for bits of sample method                              09-10-00
#define METHOD_VTD     0x01
#define METHOD_RTC     0x02
#define METHOD_EBS     0x04

/* User allocation req's for SP structs */
typedef struct {
    unsigned int size_user_Sp3;
    unsigned int strlen_raw_file_name_Sp3;
    unsigned int strlen_mod_info_file_name_Sp3;
} samp_user_config_stat_t;

#define ITP_CPUID_REG3_FAMILY   0xFF000000
#define ITP_CPU_FAMILY_ITANIUM  7
#define ITP_CPU_FAMILY_ITANIUM2 0x1F

#define ITANIUM_INSTRUCTION_EAR_PMC 10
#define ITANIUM_DATA_EAR_PMC        11
#define ITANIUM_BRANCH_TRACE_BUFFER_PMC 10
#define ITANIUM_MAXCOUNTER          0xFFFFFFFF
#define ITANIUM_MAX_CONFIG_PMC      13
#define ITANIUM_PMD17_SLOT_MASK     0xC
#define ITANIUM_PMD17_SLOT_SHIFT    2
#define ITANIUM_PMC_ES_MASK         0x7F00
#define ITANIUM_PMC_ES_SHIFT        8
#define ITANIUM_DEAR_EVENT_CODE     0x67
#define ITANIUM_IEAR_EVENT_CODE     0x23
#define ITANIUM_BTRACE_EVENT_CODE   0x11

#define ITANIUM2_MAXCOUNTER         0x7FFFFFFFFFFF
#define ITANIUM2_MAX_CONFIG_PMC     15
#define ITANIUM2_PMD17_SLOT_MASK    0x3
#define ITANIUM2_PMD17_SLOT_SHIFT   0
#define ITANIUM2_PMC_ES_MASK        0xFF00
#define ITANIUM2_PMC_ES_SHIFT       8
#define ITANIUM2_DEAR_EVENT_CODE    0xC8
#define ITANIUM2_IEAR_EVENT_CODE    0x43
#define ITANIUM2_BTRACE_EVENT_CODE  0x11

#define PMC0_FREEZE   1
#define PMC0_OFLOW0   0x10  // perf counter 4 overflow status bit
#define PMC0_OFLOW1   0x20  // perf counter 5 overflow status bit
#define PMC0_OFLOW2   0x40  // perf counter 6 overflow status bit
#define PMC0_OFLOW3   0x80  // perf counter 7 overflow status bit
#define PMC0_OFLOWALL (PMC0_OFLOW0 | PMC0_OFLOW1 | PMC0_OFLOW2 | PMC0_OFLOW3)   // perf counter 4-7 overflow status bit

#define PMV_MASK_BIT 0x10000    // pmv.m  0 = unmask counter overflow interrrupts
                //                        1 = mask counter overflow interrupts
                // Note: 
                // Counter overflow interrupt is edge triggered so
                // is an counter overflow interrupt signal is generated while
                // pmv.m is set, then the interrupt is lost

#define PMC4_PLM  0x0F      // privilege level mask
#define PMC4_OI   0x20      // overflow interrupt 0 = no interrupt, 1 = generate counter overflow interrupt

#ifdef DEBUG
#define samp_dbg_print(fmt,args...) { printk(fmt,##args); }
#else
#define samp_dbg_print(fmt,args...) {;}
#endif

#define SampPrint(fmt,args...) { printk(fmt,##args); }

#endif /* _VTUNE_VTDEF_H */
