#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif

#include <linux/kernel.h>
#include <linux/module.h>
#include <asm/uaccess.h>
#include <linux/smp_lock.h>

#include "shfs.h"
#include "shfs_proc.h"

static int shfs_readlink(struct dentry*, char*, int);
static int shfs_follow_link(struct dentry*, struct nameidata*);

struct inode_operations shfs_symlink_inode_operations = {
	readlink:	shfs_readlink,
	follow_link:	shfs_follow_link,
	setattr:	shfs_notify_change,
	revalidate:	shfs_revalidate_inode,
};

static int
shfs_readlink(struct dentry *dentry, char *buffer, int bufflen)
{
	struct shfs_sb_info *info = (struct shfs_sb_info*)dentry->d_sb->u.generic_sbp;
	struct shfs_dir_entry *entry;
	char *real_name;
	int error;
	
	DEBUG("%s\n", dentry->d_name.name);
//	lock_kernel();
	if (!shfs_lock(info))
		return -EINTR;

	error = shfs_dcache_get_entry(dentry, &entry);
	if (error < 0) {
		VERBOSE(" shfs_cache_get failed!\n");
		goto error;
	}

	real_name = entry->name + strlen(entry->name) + 4;
	DEBUG("real name: %s\n", real_name);
	shfs_unlock(info);
//	unlock_kernel();

	return vfs_readlink(dentry, buffer, bufflen, real_name);
	
error:
	shfs_unlock(info);
//	unlock_kernel();
	return shfs_remove_sigpipe(error);
}

static int
shfs_follow_link(struct dentry *dentry, struct nameidata *nd)
{
	struct shfs_sb_info *info = (struct shfs_sb_info*)dentry->d_sb->u.generic_sbp;
	struct shfs_dir_entry *entry;
	char *real_name;
	int error;
	
	DEBUG("%s\n", dentry->d_name.name);

//	lock_kernel();
	if (!shfs_lock(info))
		return -EINTR;
	error = shfs_dcache_get_entry(dentry, &entry);
	if (error < 0) {
		VERBOSE(" shfs_dcache_get failed!\n");
		goto error;
	}
	real_name = entry->name + strlen(entry->name) + 4;
	DEBUG("real name: %s\n", real_name);
	shfs_unlock(info);
//	unlock_kernel();
	return  vfs_follow_link(nd, real_name);
	
error:
	shfs_unlock(info);
//	unlock_kernel();
	return shfs_remove_sigpipe(error);
}

