/*******************************************************************************
  
  Copyright(c) 2003 - 2004 Intel Corporation. All rights reserved.
  
  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  James P. Ketrenos <ipw2100-admin@linux.intel.com>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/
#ifndef _IPW2100_FW_H
#define _IPW2100_FW_H

#include <linux/netdevice.h>

#define IPW_HOST_FW_SHARED_AREA0 	0x0002f200
#define IPW_HOST_FW_SHARED_AREA0_END 	0x0002f510	// 0x310 bytes

#define IPW_HOST_FW_SHARED_AREA1 	0x0002f610
#define IPW_HOST_FW_SHARED_AREA1_END 	0x0002f630	// 0x20 bytes

#define IPW_HOST_FW_SHARED_AREA2 	0x0002fa00
#define IPW_HOST_FW_SHARED_AREA2_END 	0x0002fa20	// 0x20 bytes

#define IPW_HOST_FW_SHARED_AREA3 	0x0002fc00
#define IPW_HOST_FW_SHARED_AREA3_END 	0x0002fc10	// 0x10 bytes

#define IPW_HOST_FW_INTERRUPT_AREA 	0x0002ff80
#define IPW_HOST_FW_INTERRUPT_AREA_END 	0x00030000	// 0x80 bytes

struct ipw2100_fw_chunk {
	unsigned char *buf;
	long len;
	long pos;
	struct list_head list;
};

struct ipw2100_fw_chunk_set {
#ifdef CONFIG_IPW2100_LEGACY_FW_LOAD
	struct list_head chunk_list;
	unsigned int chunks;
#else
   	const void *data;
#endif
	unsigned long size;
};

struct ipw2100_fw {
	int version;
	struct ipw2100_fw_chunk_set fw;
	struct ipw2100_fw_chunk_set uc;
#ifndef CONFIG_IPW2100_LEGACY_FW_LOAD
	const struct firmware *fw_entry;
#endif
};

int ipw2100_get_firmware(struct ipw2100_priv *priv, struct ipw2100_fw *fw);
void ipw2100_release_firmware(struct ipw2100_priv *priv, struct ipw2100_fw *fw);
int ipw2100_fw_download(struct ipw2100_priv *priv, struct ipw2100_fw *fw);
int ipw2100_ucode_download(struct ipw2100_priv *priv, struct ipw2100_fw *fw);

#define MAX_FW_VERSION_LEN 14

int ipw2100_get_fwversion(struct ipw2100_priv *priv, char *buf, size_t max);
int ipw2100_get_ucodeversion(struct ipw2100_priv *priv, char *buf, size_t max);

#endif	/* _IPW2100_FW_H */
