#ifndef _X86_64_STRING_H_
#define _X86_64_STRING_H_

#ifdef __KERNEL__

#define struct_cpy(x,y) (*(x)=*(y))

/* Written 2002 by Andi Kleen */ 

/* Only used for special circumstances. Stolen from i386/string.h */ 
static inline void * __inline_memcpy(void * to, const void * from, size_t n)
{
unsigned long d0, d1, d2;
__asm__ __volatile__(
	"rep ; movsl\n\t"
	"testb $2,%b4\n\t"
	"je 1f\n\t"
	"movsw\n"
	"1:\ttestb $1,%b4\n\t"
	"je 2f\n\t"
	"movsb\n"
	"2:"
	: "=&c" (d0), "=&D" (d1), "=&S" (d2)
	:"0" (n/4), "q" (n),"1" ((long) to),"2" ((long) from)
	: "memory");
return (to);
}

/* Even with __builtin_ the compiler may decide to use the out of line
   function. */

#define __HAVE_ARCH_MEMCPY 1
extern void *__memcpy(void *to, const void *from, size_t len); 
#define memcpy(dst,src,len) \
	({ size_t __len = (len);				\
	   void *__ret;						\
	   if (__builtin_constant_p(len) && __len >= 64)	\
		 __ret = __memcpy((dst),(src),__len);		\
	   else							\
		 __ret = __builtin_memcpy((dst),(src),__len);	\
	   __ret; }) 

#if 0
#define __HAVE_ARCH_MEMSET
extern void *__memset(void *mem, int val, size_t len); 
#define memset(dst,val,len)					\
	({ size_t __len = (len);				\
	   void *__ret;						\
	   if (__builtin_constant_p(len) && __len >= 64)	\
		   __ret = __memset((dst),(val),__len);		\
	   else							\
		   __ret = __builtin_memset((dst),(val),__len);	\
	   __ret; }) 
#endif	   

#define __HAVE_ARCH_MEMMOVE
void * memmove(void * dest,const void *src,size_t count);

/* Use C out of line version for memcmp */ 
#define memcmp __builtin_memcmp
int memcmp(const void * cs,const void * ct,size_t count);

/* out of line string functions use always C versions */ 
#define strlen __builtin_strlen
size_t strlen(const char * s);

#define strcpy __builtin_strcpy
char * strcpy(char * dest,const char *src);

#define strcat __builtin_strcat
char * strcat(char * dest, const char * src);

#define strcmp __builtin_strcmp
int strcmp(const char * cs,const char * ct);

#endif /* __KERNEL__ */

#endif
