/* arch/arm/plat-s5pc1xx/include/plat/regs-clock.h
 *
 * Copyright 2009 Samsung Electronics Co.
 *	Byungho Min <bhmin@samsung.com>
 *
 * S5PC1XX clock register definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __PLAT_REGS_CLOCK_H
#define __PLAT_REGS_CLOCK_H __FILE__

#define S5PC1XX_CLKREG(x)		(S5PC1XX_VA_CLK + (x))

#define S5PC1XX_APLL_LOCK		S5PC1XX_CLKREG(0x00)
#define S5PC1XX_MPLL_LOCK		S5PC1XX_CLKREG(0x04)
#define S5PC1XX_EPLL_LOCK		S5PC1XX_CLKREG(0x08)
#define S5PC100_HPLL_LOCK		S5PC1XX_CLKREG(0x0C)

#define S5PC1XX_APLL_CON		S5PC1XX_CLKREG(0x100)
#define S5PC1XX_MPLL_CON		S5PC1XX_CLKREG(0x104)
#define S5PC1XX_EPLL_CON		S5PC1XX_CLKREG(0x108)
#define S5PC100_HPLL_CON		S5PC1XX_CLKREG(0x10C)

#define S5PC1XX_CLK_SRC0		S5PC1XX_CLKREG(0x200)
#define S5PC1XX_CLK_SRC1		S5PC1XX_CLKREG(0x204)
#define S5PC1XX_CLK_SRC2		S5PC1XX_CLKREG(0x208)
#define S5PC1XX_CLK_SRC3		S5PC1XX_CLKREG(0x20C)

#define S5PC1XX_CLK_DIV0		S5PC1XX_CLKREG(0x300)
#define S5PC1XX_CLK_DIV1		S5PC1XX_CLKREG(0x304)
#define S5PC1XX_CLK_DIV2		S5PC1XX_CLKREG(0x308)
#define S5PC1XX_CLK_DIV3		S5PC1XX_CLKREG(0x30C)
#define S5PC1XX_CLK_DIV4		S5PC1XX_CLKREG(0x310)

#define S5PC100_CLK_OUT			S5PC1XX_CLKREG(0x400)

#define S5PC100_CLKGATE_D00		S5PC1XX_CLKREG(0x500)
#define S5PC100_CLKGATE_D01		S5PC1XX_CLKREG(0x504)
#define S5PC100_CLKGATE_D02		S5PC1XX_CLKREG(0x508)

#define S5PC100_CLKGATE_D10		S5PC1XX_CLKREG(0x520)
#define S5PC100_CLKGATE_D11		S5PC1XX_CLKREG(0x524)
#define S5PC100_CLKGATE_D12		S5PC1XX_CLKREG(0x528)
#define S5PC100_CLKGATE_D13		S5PC1XX_CLKREG(0x52C)
#define S5PC100_CLKGATE_D14		S5PC1XX_CLKREG(0x530)
#define S5PC100_CLKGATE_D15		S5PC1XX_CLKREG(0x534)

#define S5PC100_CLKGATE_D20		S5PC1XX_CLKREG(0x540)

#define S5PC100_SCLKGATE0		S5PC1XX_CLKREG(0x560)
#define S5PC100_SCLKGATE1		S5PC1XX_CLKREG(0x564)

#define S5PC100_OTHERS          S5PC1XX_CLKREG(0x8200)

#define S5PC1XX_EPLL_EN     (1<<31)
#define S5PC1XX_EPLL_MASK   0xffffffff
#define S5PC1XX_EPLLVAL(_m, _p, _s)   ((_m) << 16 | ((_p) << 8) | ((_s)))

/* CLKSRC0 */
#define S5PC1XX_CLKSRC0_APLL_MASK		(0x1<<0)
#define S5PC1XX_CLKSRC0_APLL_SHIFT		(0)
#define S5PC1XX_CLKSRC0_MPLL_MASK		(0x1<<4)
#define S5PC1XX_CLKSRC0_MPLL_SHIFT		(4)
#define S5PC1XX_CLKSRC0_EPLL_MASK		(0x1<<8)
#define S5PC1XX_CLKSRC0_EPLL_SHIFT		(8)
#define S5PC100_CLKSRC0_HPLL_MASK		(0x1<<12)
#define S5PC100_CLKSRC0_HPLL_SHIFT		(12)
#define S5PC100_CLKSRC0_AMMUX_MASK		(0x1<<16)
#define S5PC100_CLKSRC0_AMMUX_SHIFT		(16)
#define S5PC100_CLKSRC0_HREF_MASK		(0x1<<20)
#define S5PC100_CLKSRC0_HREF_SHIFT		(20)
#define S5PC1XX_CLKSRC0_ONENAND_MASK	(0x1<<24)
#define S5PC1XX_CLKSRC0_ONENAND_SHIFT	(24)


/* CLKSRC1 */
#define S5PC100_CLKSRC1_UART_MASK		(0x1<<0)
#define S5PC100_CLKSRC1_UART_SHIFT		(0)
#define S5PC100_CLKSRC1_SPI0_MASK		(0x3<<4)
#define S5PC100_CLKSRC1_SPI0_SHIFT		(4)
#define S5PC100_CLKSRC1_SPI1_MASK		(0x3<<8)
#define S5PC100_CLKSRC1_SPI1_SHIFT		(8)
#define S5PC100_CLKSRC1_SPI2_MASK		(0x3<<12)
#define S5PC100_CLKSRC1_SPI2_SHIFT		(12)
#define S5PC100_CLKSRC1_IRDA_MASK		(0x3<<16)
#define S5PC100_CLKSRC1_IRDA_SHIFT		(16)
#define S5PC100_CLKSRC1_UHOST_MASK		(0x3<<20)
#define S5PC100_CLKSRC1_UHOST_SHIFT		(20)
#define S5PC100_CLKSRC1_CLK48M_MASK		(0x1<<24)
#define S5PC100_CLKSRC1_CLK48M_SHIFT	(24)

/* CLKSRC2 */
#define S5PC100_CLKSRC2_MMC0_MASK		(0x3<<0)
#define S5PC100_CLKSRC2_MMC0_SHIFT		(0)
#define S5PC100_CLKSRC2_MMC1_MASK		(0x3<<4)
#define S5PC100_CLKSRC2_MMC1_SHIFT		(4)
#define S5PC100_CLKSRC2_MMC2_MASK		(0x3<<8)
#define S5PC100_CLKSRC2_MMC2_SHIFT		(8)
#define S5PC100_CLKSRC2_LCD_MASK		(0x3<<12)
#define S5PC100_CLKSRC2_LCD_SHIFT		(12)
#define S5PC100_CLKSRC2_FIMC0_MASK		(0x3<<16)
#define S5PC100_CLKSRC2_FIMC0_SHIFT		(16)
#define S5PC100_CLKSRC2_FIMC1_MASK		(0x3<<20)
#define S5PC100_CLKSRC2_FIMC1_SHIFT		(20)
#define S5PC100_CLKSRC2_FIMC2_MASK		(0x3<<24)
#define S5PC100_CLKSRC2_FIMC2_SHIFT		(24)
#define S5PC100_CLKSRC2_MIXER_MASK		(0x3<<28)
#define S5PC100_CLKSRC2_MIXER_SHIFT		(28)

/* CLKSRC3 */
#define S5PC100_CLKSRC3_PWI_MASK		(0x3<<0)
#define S5PC100_CLKSRC3_PWI_SHIFT		(0)
#define S5PC100_CLKSRC3_HCLKD2_MASK		(0x1<<4)
#define S5PC100_CLKSRC3_HCLKD2_SHIFT	(4)
#define S5PC100_CLKSRC3_I2SD2_MASK		(0x3<<8)
#define S5PC100_CLKSRC3_I2SD2_SHIFT		(8)
#define S5PC100_CLKSRC3_AUDIO0_MASK		(0x7<<12)
#define S5PC100_CLKSRC3_AUDIO0_SHIFT	(12)
#define S5PC100_CLKSRC3_AUDIO1_MASK		(0x7<<16)
#define S5PC100_CLKSRC3_AUDIO1_SHIFT	(16)
#define S5PC100_CLKSRC3_AUDIO2_MASK		(0x7<<20)
#define S5PC100_CLKSRC3_AUDIO2_SHIFT	(20)
#define S5PC100_CLKSRC3_SPDIF_MASK		(0x3<<24)
#define S5PC100_CLKSRC3_SPDIF_SHIFT		(24)


/* CLKDIV0 */
#define S5PC1XX_CLKDIV0_APLL_MASK		(0x1<<0)
#define S5PC1XX_CLKDIV0_APLL_SHIFT		(0)
#define S5PC100_CLKDIV0_ARM_MASK		(0x7<<4)
#define S5PC100_CLKDIV0_ARM_SHIFT		(4)
#define S5PC100_CLKDIV0_D0_MASK		(0x7<<8)
#define S5PC100_CLKDIV0_D0_SHIFT		(8)
#define S5PC100_CLKDIV0_PCLKD0_MASK		(0x7<<12)
#define S5PC100_CLKDIV0_PCLKD0_SHIFT	(12)
#define S5PC100_CLKDIV0_SECSS_MASK		(0x7<<16)
#define S5PC100_CLKDIV0_SECSS_SHIFT		(16)

/* CLKDIV1 */
#define S5PC100_CLKDIV1_AM_MASK		(0x7<<0)
#define S5PC100_CLKDIV1_AM_SHIFT		(0)
#define S5PC100_CLKDIV1_MPLL_MASK		(0x3<<4)
#define S5PC100_CLKDIV1_MPLL_SHIFT		(4)
#define S5PC100_CLKDIV1_MPLL2_MASK		(0x1<<8)
#define S5PC100_CLKDIV1_MPLL2_SHIFT		(8)
#define S5PC100_CLKDIV1_D1_MASK		(0x7<<12)
#define S5PC100_CLKDIV1_D1_SHIFT		(12)
#define S5PC100_CLKDIV1_PCLKD1_MASK		(0x7<<16)
#define S5PC100_CLKDIV1_PCLKD1_SHIFT	(16)
#define S5PC100_CLKDIV1_ONENAND_MASK	(0x3<<20)
#define S5PC100_CLKDIV1_ONENAND_SHIFT	(20)
#define S5PC100_CLKDIV1_CAM_MASK		(0x1F<<24)
#define S5PC100_CLKDIV1_CAM_SHIFT		(24)

/* CLKDIV2 */
#define S5PC100_CLKDIV2_UART_MASK		(0x7<<0)
#define S5PC100_CLKDIV2_UART_SHIFT		(0)
#define S5PC100_CLKDIV2_SPI0_MASK		(0xf<<4)
#define S5PC100_CLKDIV2_SPI0_SHIFT		(4)
#define S5PC100_CLKDIV2_SPI1_MASK		(0xf<<8)
#define S5PC100_CLKDIV2_SPI1_SHIFT		(8)
#define S5PC100_CLKDIV2_SPI2_MASK		(0xf<<12)
#define S5PC100_CLKDIV2_SPI2_SHIFT		(12)
#define S5PC100_CLKDIV2_IRDA_MASK		(0xf<<16)
#define S5PC100_CLKDIV2_IRDA_SHIFT		(16)
#define S5PC100_CLKDIV2_UHOST_MASK		(0xf<<20)
#define S5PC100_CLKDIV2_UHOST_SHIFT		(20)

/* CLKDIV3 */
#define S5PC100_CLKDIV3_MMC0_MASK		(0xf<<0)
#define S5PC100_CLKDIV3_MMC0_SHIFT		(0)
#define S5PC100_CLKDIV3_MMC1_MASK		(0xf<<4)
#define S5PC100_CLKDIV3_MMC1_SHIFT		(4)
#define S5PC100_CLKDIV3_MMC2_MASK		(0xf<<8)
#define S5PC100_CLKDIV3_MMC2_SHIFT		(8)
#define S5PC100_CLKDIV3_LCD_MASK		(0xf<<12)
#define S5PC100_CLKDIV3_LCD_SHIFT		(12)
#define S5PC100_CLKDIV3_FIMC0_MASK		(0xf<<16)
#define S5PC100_CLKDIV3_FIMC0_SHIFT		(16)
#define S5PC100_CLKDIV3_FIMC1_MASK		(0xf<<20)
#define S5PC100_CLKDIV3_FIMC1_SHIFT		(20)
#define S5PC100_CLKDIV3_FIMC2_MASK		(0xf<<24)
#define S5PC100_CLKDIV3_FIMC2_SHIFT		(24)
#define S5PC100_CLKDIV3_HDMI_MASK		(0xf<<28)
#define S5PC100_CLKDIV3_HDMI_SHIFT		(28)

/* CLKDIV4 */
#define S5PC100_CLKDIV4_PWI_MASK		(0x7<<0)
#define S5PC100_CLKDIV4_PWI_SHIFT		(0)
#define S5PC100_CLKDIV4_HCLKD2_MASK		(0x7<<4)
#define S5PC100_CLKDIV4_HCLKD2_SHIFT	(4)
#define S5PC100_CLKDIV4_I2SD2_MASK		(0xf<<8)
#define S5PC100_CLKDIV4_I2SD2_SHIFT		(8)
#define S5PC100_CLKDIV4_AUDIO0_MASK		(0xf<<12)
#define S5PC100_CLKDIV4_AUDIO0_SHIFT	(12)
#define S5PC100_CLKDIV4_AUDIO1_MASK		(0xf<<16)
#define S5PC100_CLKDIV4_AUDIO1_SHIFT	(16)
#define S5PC100_CLKDIV4_AUDIO2_MASK		(0xf<<20)
#define S5PC100_CLKDIV4_AUDIO2_SHIFT	(20)


/* HCLKD0/PCLKD0 Clock Gate 0 Registers */
#define S5PC100_CLKGATE_D00_INTC		(1<<0)
#define S5PC100_CLKGATE_D00_TZIC		(1<<1)
#define S5PC100_CLKGATE_D00_CFCON		(1<<2)
#define S5PC100_CLKGATE_D00_MDMA		(1<<3)
#define S5PC100_CLKGATE_D00_G2D		(1<<4)
#define S5PC100_CLKGATE_D00_SECSS		(1<<5)
#define S5PC100_CLKGATE_D00_CSSYS		(1<<6)

/* HCLKD0/PCLKD0 Clock Gate 1 Registers */
#define S5PC100_CLKGATE_D01_DMC		(1<<0)
#define S5PC100_CLKGATE_D01_SROMC		(1<<1)
#define S5PC100_CLKGATE_D01_ONENAND		(1<<2)
#define S5PC100_CLKGATE_D01_NFCON		(1<<3)
#define S5PC100_CLKGATE_D01_INTMEM		(1<<4)
#define S5PC100_CLKGATE_D01_EBI		(1<<5)

/* PCLKD0 Clock Gate 2 Registers */
#define S5PC100_CLKGATE_D02_SECKEY		(1<<1)
#define S5PC100_CLKGATE_D02_SDM		(1<<2)

/* HCLKD1/PCLKD1 Clock Gate 0 Registers */
#define S5PC100_CLKGATE_D10_PDMA0		(1<<0)
#define S5PC100_CLKGATE_D10_PDMA1		(1<<1)
#define S5PC100_CLKGATE_D10_USBHOST		(1<<2)
#define S5PC100_CLKGATE_D10_USBOTG		(1<<3)
#define S5PC100_CLKGATE_D10_MODEMIF		(1<<4)
#define S5PC100_CLKGATE_D10_HSMMC0		(1<<5)
#define S5PC100_CLKGATE_D10_HSMMC1		(1<<6)
#define S5PC100_CLKGATE_D10_HSMMC2		(1<<7)

/* HCLKD1/PCLKD1 Clock Gate 1 Registers */
#define S5PC100_CLKGATE_D11_LCD		(1<<0)
#define S5PC100_CLKGATE_D11_ROTATOR		(1<<1)
#define S5PC100_CLKGATE_D11_FIMC0		(1<<2)
#define S5PC100_CLKGATE_D11_FIMC1		(1<<3)
#define S5PC100_CLKGATE_D11_FIMC2		(1<<4)
#define S5PC100_CLKGATE_D11_JPEG		(1<<5)
#define S5PC100_CLKGATE_D11_DSI		(1<<6)
#define S5PC100_CLKGATE_D11_CSI		(1<<7)
#define S5PC100_CLKGATE_D11_G3D		(1<<8)

/* HCLKD1/PCLKD1 Clock Gate 2 Registers */
#define S5PC100_CLKGATE_D12_TV		(1<<0)
#define S5PC100_CLKGATE_D12_VP		(1<<1)
#define S5PC100_CLKGATE_D12_MIXER		(1<<2)
#define S5PC100_CLKGATE_D12_HDMI		(1<<3)
#define S5PC100_CLKGATE_D12_MFC		(1<<4)

/* HCLKD1/PCLKD1 Clock Gate 3 Registers */
#define S5PC100_CLKGATE_D13_CHIPID		(1<<0)
#define S5PC100_CLKGATE_D13_GPIO		(1<<1)
#define S5PC100_CLKGATE_D13_APC		(1<<2)
#define S5PC100_CLKGATE_D13_IEC		(1<<3)
#define S5PC100_CLKGATE_D13_PWM		(1<<6)
#define S5PC100_CLKGATE_D13_SYSTIMER	(1<<7)
#define S5PC100_CLKGATE_D13_WDT		(1<<8)
#define S5PC100_CLKGATE_D13_RTC		(1<<9)

/* HCLKD1/PCLKD1 Clock Gate 4 Registers */
#define S5PC100_CLKGATE_D14_UART0		(1<<0)
#define S5PC100_CLKGATE_D14_UART1		(1<<1)
#define S5PC100_CLKGATE_D14_UART2		(1<<2)
#define S5PC100_CLKGATE_D14_UART3		(1<<3)
#define S5PC100_CLKGATE_D14_IIC		(1<<4)
#define S5PC100_CLKGATE_D14_HDMI_IIC	(1<<5)
#define S5PC100_CLKGATE_D14_SPI0		(1<<6)
#define S5PC100_CLKGATE_D14_SPI1		(1<<7)
#define S5PC100_CLKGATE_D14_SPI2		(1<<8)
#define S5PC100_CLKGATE_D14_IRDA		(1<<9)
#define S5PC100_CLKGATE_D14_CCAN0		(1<<10)
#define S5PC100_CLKGATE_D14_CCAN1		(1<<11)
#define S5PC100_CLKGATE_D14_HSITX		(1<<12)
#define S5PC100_CLKGATE_D14_HSIRX		(1<<13)

/* HCLKD1/PCLKD1 Clock Gate 5 Registers */
#define S5PC100_CLKGATE_D15_IIS0		(1<<0)
#define S5PC100_CLKGATE_D15_IIS1		(1<<1)
#define S5PC100_CLKGATE_D15_IIS2		(1<<2)
#define S5PC100_CLKGATE_D15_AC97		(1<<3)
#define S5PC100_CLKGATE_D15_PCM0		(1<<4)
#define S5PC100_CLKGATE_D15_PCM1		(1<<5)
#define S5PC100_CLKGATE_D15_SPDIF		(1<<6)
#define S5PC100_CLKGATE_D15_TSADC		(1<<7)
#define S5PC100_CLKGATE_D15_KEYIF		(1<<8)
#define S5PC100_CLKGATE_D15_CG		(1<<9)

/* HCLKD2 Clock Gate 0 Registers */
#define S5PC100_CLKGATE_D20_HCLKD2		(1<<0)
#define S5PC100_CLKGATE_D20_I2SD2		(1<<1)

/* Special Clock Gate 0 Registers */
#define	S5PC1XX_CLKGATE_SCLK0_HPM		(1<<0)
#define	S5PC1XX_CLKGATE_SCLK0_PWI		(1<<1)
#define	S5PC100_CLKGATE_SCLK0_ONENAND	(1<<2)
#define	S5PC100_CLKGATE_SCLK0_UART		(1<<3)
#define	S5PC100_CLKGATE_SCLK0_SPI0		(1<<4)
#define	S5PC100_CLKGATE_SCLK0_SPI1		(1<<5)
#define	S5PC100_CLKGATE_SCLK0_SPI2		(1<<6)
#define	S5PC100_CLKGATE_SCLK0_SPI0_48	(1<<7)
#define	S5PC100_CLKGATE_SCLK0_SPI1_48	(1<<8)
#define	S5PC100_CLKGATE_SCLK0_SPI2_48	(1<<9)
#define	S5PC100_CLKGATE_SCLK0_IRDA		(1<<10)
#define	S5PC100_CLKGATE_SCLK0_USBHOST	(1<<11)
#define	S5PC100_CLKGATE_SCLK0_MMC0		(1<<12)
#define	S5PC100_CLKGATE_SCLK0_MMC1		(1<<13)
#define	S5PC100_CLKGATE_SCLK0_MMC2		(1<<14)
#define	S5PC100_CLKGATE_SCLK0_MMC0_48	(1<<15)
#define	S5PC100_CLKGATE_SCLK0_MMC1_48	(1<<16)
#define	S5PC100_CLKGATE_SCLK0_MMC2_48	(1<<17)

/* Special Clock Gate 1 Registers */
#define	S5PC100_CLKGATE_SCLK1_LCD		(1<<0)
#define	S5PC100_CLKGATE_SCLK1_FIMC0		(1<<1)
#define	S5PC100_CLKGATE_SCLK1_FIMC1		(1<<2)
#define	S5PC100_CLKGATE_SCLK1_FIMC2		(1<<3)
#define	S5PC100_CLKGATE_SCLK1_TV54		(1<<4)
#define	S5PC100_CLKGATE_SCLK1_VDAC54	(1<<5)
#define	S5PC100_CLKGATE_SCLK1_MIXER		(1<<6)
#define	S5PC100_CLKGATE_SCLK1_HDMI		(1<<7)
#define	S5PC100_CLKGATE_SCLK1_AUDIO0	(1<<8)
#define	S5PC100_CLKGATE_SCLK1_AUDIO1	(1<<9)
#define	S5PC100_CLKGATE_SCLK1_AUDIO2	(1<<10)
#define	S5PC100_CLKGATE_SCLK1_SPDIF		(1<<11)
#define	S5PC100_CLKGATE_SCLK1_CAM		(1<<12)

/* register for power management */
#define S5PC100_PWR_CFG 		S5PC1XX_CLKREG(0x8000)
#define S5PC100_EINT_WAKEUP_MASK 	S5PC1XX_CLKREG(0x8004)
#define S5PC100_NORMAL_CFG 		S5PC1XX_CLKREG(0x8010)
#define S5PC100_STOP_CFG 		S5PC1XX_CLKREG(0x8014)
#define S5PC100_SLEEP_CFG 		S5PC1XX_CLKREG(0x8018)
#define S5PC100_STOP_MEM_CFG 	S5PC1XX_CLKREG(0x801C)
#define S5PC100_OSC_FREQ 		S5PC1XX_CLKREG(0x8100)
#define S5PC100_OSC_STABLE 		S5PC1XX_CLKREG(0x8104)
#define S5PC100_PWR_STABLE 		S5PC1XX_CLKREG(0x8108)
#define S5PC100_MTC_STABLE 		S5PC1XX_CLKREG(0x8110)
#define S5PC100_CLAMP_STABLE 	S5PC1XX_CLKREG(0x8114)
#define S5PC100_OTHERS 		S5PC1XX_CLKREG(0x8200)
#define S5PC100_RST_STAT 		S5PC1XX_CLKREG(0x8300)
#define S5PC100_WAKEUP_STAT 	S5PC1XX_CLKREG(0x8304)
#define S5PC100_BLK_PWR_STAT 	S5PC1XX_CLKREG(0x8308)
#define S5PC100_INFORM0 		S5PC1XX_CLKREG(0x8400)
#define S5PC100_INFORM1 		S5PC1XX_CLKREG(0x8404)
#define S5PC100_INFORM2 		S5PC1XX_CLKREG(0x8408)
#define S5PC100_INFORM3 		S5PC1XX_CLKREG(0x840C)
#define S5PC100_INFORM4 		S5PC1XX_CLKREG(0x8410)
#define S5PC100_INFORM5 		S5PC1XX_CLKREG(0x8414)
#define S5PC100_INFORM6 		S5PC1XX_CLKREG(0x8418)
#define S5PC100_INFORM7 		S5PC1XX_CLKREG(0x841C)
#define S5PC100_DCGIDX_MAP0 	S5PC1XX_CLKREG(0x8500)
#define S5PC100_DCGIDX_MAP1 	S5PC1XX_CLKREG(0x8504)
#define S5PC100_DCGIDX_MAP2 	S5PC1XX_CLKREG(0x8508)
#define S5PC100_DCGPERF_MAP0 	S5PC1XX_CLKREG(0x850C)
#define S5PC100_DCGPERF_MAP1 	S5PC1XX_CLKREG(0x8510)
#define S5PC100_DVCIDX_MAP 		S5PC1XX_CLKREG(0x8514)
#define S5PC100_FREQ_CPU 		S5PC1XX_CLKREG(0x8518)
#define S5PC100_FREQ_DPM 		S5PC1XX_CLKREG(0x851C)
#define S5PC100_DVSEMCLK_EN 	S5PC1XX_CLKREG(0x8520)
#define S5PC100_APLL_CON_L8 	S5PC1XX_CLKREG(0x8600)
#define S5PC100_APLL_CON_L7 	S5PC1XX_CLKREG(0x8604)
#define S5PC100_APLL_CON_L6 	S5PC1XX_CLKREG(0x8608)
#define S5PC100_APLL_CON_L5 	S5PC1XX_CLKREG(0x860C)
#define S5PC100_APLL_CON_L4 	S5PC1XX_CLKREG(0x8610)
#define S5PC100_APLL_CON_L3 	S5PC1XX_CLKREG(0x8614)
#define S5PC100_APLL_CON_L2 	S5PC1XX_CLKREG(0x8618)
#define S5PC100_APLL_CON_L1 	S5PC1XX_CLKREG(0x861C)
#define S5PC100_IEM_CONTROL 	S5PC1XX_CLKREG(0x8620)
#define S5PC100_CLKDIV_IEM_L8 	S5PC1XX_CLKREG(0x8700)
#define S5PC100_CLKDIV_IEM_L7 	S5PC1XX_CLKREG(0x8704)
#define S5PC100_CLKDIV_IEM_L6 	S5PC1XX_CLKREG(0x8708)
#define S5PC100_CLKDIV_IEM_L5 	S5PC1XX_CLKREG(0x870C)
#define S5PC100_CLKDIV_IEM_L4 	S5PC1XX_CLKREG(0x8710)
#define S5PC100_CLKDIV_IEM_L3 	S5PC1XX_CLKREG(0x8714)
#define S5PC100_CLKDIV_IEM_L2 	S5PC1XX_CLKREG(0x8718)
#define S5PC100_CLKDIV_IEM_L1 	S5PC1XX_CLKREG(0x871C)
#define S5PC100_IEM_HPMCLK_DIV 	S5PC1XX_CLKREG(0x8724)

#define S5PC100_SWRESET		S5PC1XX_CLKREG(0x100000)
#define S5PC100_OND_SWRESET		S5PC1XX_CLKREG(0x100008)
#define S5PC100_GEN_CTRL		S5PC1XX_CLKREG(0x100100)
#define S5PC100_GEN_STATUS		S5PC1XX_CLKREG(0x100104)
#define S5PC100_MEM_SYS_CFG		S5PC1XX_CLKREG(0x100200)
#define S5PC100_CAM_MUX_SEL		S5PC1XX_CLKREG(0x100300)
#define S5PC100_MIXER_OUT_SEL	S5PC1XX_CLKREG(0x100304)
#define S5PC100_LPMP_MODE_SEL	S5PC1XX_CLKREG(0x100308)
#define S5PC100_MIPI_PHY_CON0	S5PC1XX_CLKREG(0x100400)
#define S5PC100_MIPI_PHY_CON1	S5PC1XX_CLKREG(0x100414)
#define S5PC100_HDMI_PHY_CON0	S5PC1XX_CLKREG(0x100420)

#define S5PC100_CFG_WFI_CLEAN	(~(3<<5))
#define S5PC100_CFG_WFI_IDLE	(1<<5)
#define S5PC100_CFG_WFI_STOP	(2<<5)
#define S5PC100_CFG_WFI_SLEEP	(3<<5)

#define S5PC100_OTHER_SYS_INT	24
#define S5PC100_OTHER_STA_TYPE	23
#define STA_TYPE_EXPON		0
#define STA_TYPE_SFR		1

#define S5PC100_PWR_STA_EXP_SCALE	0
#define S5PC100_PWR_STA_CNT		4

#define S5PC100_PWR_STABLE_COUNT	85500

#define S5PC100_SLEEP_CFG_OSC_EN	0

/* OTHERS Resgister */
#define S5PC100_OTHERS_USB_SIG_MASK 	(1 << 16)
#define S5PC100_OTHERS_MIPI_DPHY_EN		(1 << 28)

/* MIPI D-PHY Control Register 0 */
#define S5PC100_MIPI_PHY_CON0_M_RESETN	(1 << 1)
#define S5PC100_MIPI_PHY_CON0_S_RESETN	(1 << 0)

#endif /* _PLAT_REGS_CLOCK_H */
