/* linux/arch/arm/mach-exynos4/include/mach/regs-clock.h
 *
 * Copyright (c) 2010-2011 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * EXYNOS4 - Clock register definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_REGS_CLOCK_H
#define __ASM_ARCH_REGS_CLOCK_H __FILE__

#include <plat/cpu.h>
#include <mach/map.h>

#define S5P_CLKREG(x)			(S5P_VA_CMU + (x))

#define S5P_CLKDIV_LEFTBUS		S5P_CLKREG(0x04500)
#define S5P_CLKDIV_STAT_LEFTBUS		S5P_CLKREG(0x04600)
#define S5P_CLKGATE_IP_LEFTBUS		S5P_CLKREG(0x04800)

#define S5P_CLKDIV_RIGHTBUS		S5P_CLKREG(0x08500)
#define S5P_CLKDIV_STAT_RIGHTBUS	S5P_CLKREG(0x08600)
#define S5P_CLKGATE_IP_RIGHTBUS		S5P_CLKREG(0x08800)

#define S5P_EPLL_LOCK			S5P_CLKREG(0x0C010)
#define S5P_VPLL_LOCK			S5P_CLKREG(0x0C020)

#define S5P_EPLL_CON0			S5P_CLKREG(0x0C110)
#define S5P_EPLL_CON1			S5P_CLKREG(0x0C114)
#define S5P_VPLL_CON0			S5P_CLKREG(0x0C120)
#define S5P_VPLL_CON1			S5P_CLKREG(0x0C124)

#define S5P_CLKSRC_TOP0			S5P_CLKREG(0x0C210)
#define S5P_CLKSRC_TOP1			S5P_CLKREG(0x0C214)
#define S5P_CLKSRC_CAM			S5P_CLKREG(0x0C220)
#define S5P_CLKSRC_TV			S5P_CLKREG(0x0C224)
#define S5P_CLKSRC_MFC			S5P_CLKREG(0x0C228)
#define S5P_CLKSRC_G3D			S5P_CLKREG(0x0C22C)
#define S5P_CLKSRC_IMAGE		S5P_CLKREG(0x0C230)
#define S5P_CLKSRC_LCD0			S5P_CLKREG(0x0C234)
#define S5P_CLKSRC_MAUDIO		S5P_CLKREG(0x0C23C)
#define S5P_CLKSRC_FSYS			S5P_CLKREG(0x0C240)
#define S5P_CLKSRC_PERIL0		S5P_CLKREG(0x0C250)
#define S5P_CLKSRC_PERIL1		S5P_CLKREG(0x0C254)

#define S5P_CLKSRC_MASK_TOP		S5P_CLKREG(0x0C310)
#define S5P_CLKSRC_MASK_CAM		S5P_CLKREG(0x0C320)
#define S5P_CLKSRC_MASK_TV		S5P_CLKREG(0x0C324)
#define S5P_CLKSRC_MASK_LCD0		S5P_CLKREG(0x0C334)
#define S5P_CLKSRC_MASK_MAUDIO		S5P_CLKREG(0x0C33C)
#define S5P_CLKSRC_MASK_FSYS		S5P_CLKREG(0x0C340)
#define S5P_CLKSRC_MASK_PERIL0		S5P_CLKREG(0x0C350)
#define S5P_CLKSRC_MASK_PERIL1		S5P_CLKREG(0x0C354)

#define S5P_CLKDIV_TOP			S5P_CLKREG(0x0C510)
#define S5P_CLKDIV_CAM			S5P_CLKREG(0x0C520)
#define S5P_CLKDIV_TV			S5P_CLKREG(0x0C524)
#define S5P_CLKDIV_MFC			S5P_CLKREG(0x0C528)
#define S5P_CLKDIV_G3D			S5P_CLKREG(0x0C52C)
#define S5P_CLKDIV_IMAGE		S5P_CLKREG(0x0C530)
#define S5P_CLKDIV_LCD0			S5P_CLKREG(0x0C534)
#define S5P_CLKDIV_MAUDIO		S5P_CLKREG(0x0C53C)
#define S5P_CLKDIV_FSYS0		S5P_CLKREG(0x0C540)
#define S5P_CLKDIV_FSYS1		S5P_CLKREG(0x0C544)
#define S5P_CLKDIV_FSYS2		S5P_CLKREG(0x0C548)
#define S5P_CLKDIV_FSYS3		S5P_CLKREG(0x0C54C)
#define S5P_CLKDIV_PERIL0		S5P_CLKREG(0x0C550)
#define S5P_CLKDIV_PERIL1		S5P_CLKREG(0x0C554)
#define S5P_CLKDIV_PERIL2		S5P_CLKREG(0x0C558)
#define S5P_CLKDIV_PERIL3		S5P_CLKREG(0x0C55C)
#define S5P_CLKDIV_PERIL4		S5P_CLKREG(0x0C560)
#define S5P_CLKDIV_PERIL5		S5P_CLKREG(0x0C564)
#define S5P_CLKDIV2_RATIO		S5P_CLKREG(0x0C580)

#define S5P_CLKDIV_STAT_TOP		S5P_CLKREG(0x0C610)

#define S5P_CLKGATE_SCLKCAM		S5P_CLKREG(0x0C820)
#define S5P_CLKGATE_IP_CAM		S5P_CLKREG(0x0C920)
#define S5P_CLKGATE_IP_TV		S5P_CLKREG(0x0C924)
#define S5P_CLKGATE_IP_MFC		S5P_CLKREG(0x0C928)
#define S5P_CLKGATE_IP_G3D		S5P_CLKREG(0x0C92C)
#define S5P_CLKGATE_IP_IMAGE		(soc_is_exynos4210() ? \
					S5P_CLKREG(0x0C930) : \
					S5P_CLKREG(0x04930))
#define S5P_CLKGATE_IP_IMAGE_4210	S5P_CLKREG(0x0C930)
#define S5P_CLKGATE_IP_IMAGE_4212	S5P_CLKREG(0x04930)
#define S5P_CLKGATE_IP_LCD0		S5P_CLKREG(0x0C934)
#define S5P_CLKGATE_IP_FSYS		S5P_CLKREG(0x0C940)
#define S5P_CLKGATE_IP_GPS		S5P_CLKREG(0x0C94C)
#define S5P_CLKGATE_IP_PERIL		S5P_CLKREG(0x0C950)
#define S5P_CLKGATE_IP_PERIR		(soc_is_exynos4210() ? \
					S5P_CLKREG(0x0C960) : \
					S5P_CLKREG(0x08960))
#define S5P_CLKGATE_IP_PERIR_4210	S5P_CLKREG(0x0C960)
#define S5P_CLKGATE_IP_PERIR_4212	S5P_CLKREG(0x08960)
#define S5P_CLKGATE_BLOCK		S5P_CLKREG(0x0C970)

#define S5P_CLKSRC_MASK_DMC		S5P_CLKREG(0x10300)
#define S5P_CLKSRC_DMC			S5P_CLKREG(0x10200)
#define S5P_CLKDIV_DMC0			S5P_CLKREG(0x10500)
#define S5P_CLKDIV_DMC1			S5P_CLKREG(0x10504)
#define S5P_CLKDIV_STAT_DMC0		S5P_CLKREG(0x10600)
#define S5P_CLKGATE_IP_DMC		S5P_CLKREG(0x10900)

#define S5P_APLL_LOCK			S5P_CLKREG(0x14000)
#define S5P_MPLL_LOCK			(soc_is_exynos4210() ? \
					S5P_CLKREG(0x14004) :  \
					S5P_CLKREG(0x10008))
#define S5P_APLL_CON0			S5P_CLKREG(0x14100)
#define S5P_APLL_CON1			S5P_CLKREG(0x14104)
#define S5P_MPLL_CON0			(soc_is_exynos4210() ? \
					S5P_CLKREG(0x14108) : \
					S5P_CLKREG(0x10108))
#define S5P_MPLL_CON1			(soc_is_exynos4210() ? \
					S5P_CLKREG(0x1410C) : \
					S5P_CLKREG(0x1010C))

#define S5P_CLKSRC_CPU			S5P_CLKREG(0x14200)
#define S5P_CLKMUX_STATCPU		S5P_CLKREG(0x14400)

#define S5P_CLKDIV_CPU			S5P_CLKREG(0x14500)
#define S5P_CLKDIV_CPU1			S5P_CLKREG(0x14504)
#define S5P_CLKDIV_STATCPU		S5P_CLKREG(0x14600)
#define S5P_CLKDIV_STATCPU1		S5P_CLKREG(0x14604)

#define S5P_CLKGATE_SCLKCPU		S5P_CLKREG(0x14800)
#define S5P_CLKGATE_IP_CPU		S5P_CLKREG(0x14900)

#define S5P_APLL_LOCKTIME		(0x1C20)	/* 300us */

#define S5P_APLLCON0_ENABLE_SHIFT	(31)
#define S5P_APLLCON0_LOCKED_SHIFT	(29)
#define S5P_APLL_VAL_1000		((250 << 16) | (6 << 8) | 1)
#define S5P_APLL_VAL_800		((200 << 16) | (6 << 8) | 1)

#define S5P_EPLLCON0_ENABLE_SHIFT	(31)
#define S5P_EPLLCON0_LOCKED_SHIFT	(29)

#define S5P_VPLLCON0_ENABLE_SHIFT	(31)
#define S5P_VPLLCON0_LOCKED_SHIFT	(29)

#define S5P_CLKSRC_CPU_MUXCORE_SHIFT	(16)
#define S5P_CLKMUX_STATCPU_MUXCORE_MASK	(0x7 << S5P_CLKSRC_CPU_MUXCORE_SHIFT)

#define S5P_CLKDIV_CPU0_CORE_SHIFT	(0)
#define S5P_CLKDIV_CPU0_CORE_MASK	(0x7 << S5P_CLKDIV_CPU0_CORE_SHIFT)
#define S5P_CLKDIV_CPU0_COREM0_SHIFT	(4)
#define S5P_CLKDIV_CPU0_COREM0_MASK	(0x7 << S5P_CLKDIV_CPU0_COREM0_SHIFT)
#define S5P_CLKDIV_CPU0_COREM1_SHIFT	(8)
#define S5P_CLKDIV_CPU0_COREM1_MASK	(0x7 << S5P_CLKDIV_CPU0_COREM1_SHIFT)
#define S5P_CLKDIV_CPU0_PERIPH_SHIFT	(12)
#define S5P_CLKDIV_CPU0_PERIPH_MASK	(0x7 << S5P_CLKDIV_CPU0_PERIPH_SHIFT)
#define S5P_CLKDIV_CPU0_ATB_SHIFT	(16)
#define S5P_CLKDIV_CPU0_ATB_MASK	(0x7 << S5P_CLKDIV_CPU0_ATB_SHIFT)
#define S5P_CLKDIV_CPU0_PCLKDBG_SHIFT	(20)
#define S5P_CLKDIV_CPU0_PCLKDBG_MASK	(0x7 << S5P_CLKDIV_CPU0_PCLKDBG_SHIFT)
#define S5P_CLKDIV_CPU0_APLL_SHIFT	(24)
#define S5P_CLKDIV_CPU0_APLL_MASK	(0x7 << S5P_CLKDIV_CPU0_APLL_SHIFT)

#define S5P_CLKDIV_DMC0_ACP_SHIFT	(0)
#define S5P_CLKDIV_DMC0_ACP_MASK	(0x7 << S5P_CLKDIV_DMC0_ACP_SHIFT)
#define S5P_CLKDIV_DMC0_ACPPCLK_SHIFT	(4)
#define S5P_CLKDIV_DMC0_ACPPCLK_MASK	(0x7 << S5P_CLKDIV_DMC0_ACPPCLK_SHIFT)
#define S5P_CLKDIV_DMC0_DPHY_SHIFT	(8)
#define S5P_CLKDIV_DMC0_DPHY_MASK	(0x7 << S5P_CLKDIV_DMC0_DPHY_SHIFT)
#define S5P_CLKDIV_DMC0_DMC_SHIFT	(12)
#define S5P_CLKDIV_DMC0_DMC_MASK	(0x7 << S5P_CLKDIV_DMC0_DMC_SHIFT)
#define S5P_CLKDIV_DMC0_DMCD_SHIFT	(16)
#define S5P_CLKDIV_DMC0_DMCD_MASK	(0x7 << S5P_CLKDIV_DMC0_DMCD_SHIFT)
#define S5P_CLKDIV_DMC0_DMCP_SHIFT	(20)
#define S5P_CLKDIV_DMC0_DMCP_MASK	(0x7 << S5P_CLKDIV_DMC0_DMCP_SHIFT)
#define S5P_CLKDIV_DMC0_COPY2_SHIFT	(24)
#define S5P_CLKDIV_DMC0_COPY2_MASK	(0x7 << S5P_CLKDIV_DMC0_COPY2_SHIFT)
#define S5P_CLKDIV_DMC0_CORETI_SHIFT	(28)
#define S5P_CLKDIV_DMC0_CORETI_MASK	(0x7 << S5P_CLKDIV_DMC0_CORETI_SHIFT)

#define S5P_CLKDIV_TOP_ACLK200_SHIFT	(0)
#define S5P_CLKDIV_TOP_ACLK200_MASK	(0x7 << S5P_CLKDIV_TOP_ACLK200_SHIFT)
#define S5P_CLKDIV_TOP_ACLK100_SHIFT	(4)
#define S5P_CLKDIV_TOP_ACLK100_MASK	(0xf << S5P_CLKDIV_TOP_ACLK100_SHIFT)
#define S5P_CLKDIV_TOP_ACLK160_SHIFT	(8)
#define S5P_CLKDIV_TOP_ACLK160_MASK	(0x7 << S5P_CLKDIV_TOP_ACLK160_SHIFT)
#define S5P_CLKDIV_TOP_ACLK133_SHIFT	(12)
#define S5P_CLKDIV_TOP_ACLK133_MASK	(0x7 << S5P_CLKDIV_TOP_ACLK133_SHIFT)
#define S5P_CLKDIV_TOP_ONENAND_SHIFT	(16)
#define S5P_CLKDIV_TOP_ONENAND_MASK	(0x7 << S5P_CLKDIV_TOP_ONENAND_SHIFT)

#define S5P_CLKDIV_BUS_GDLR_SHIFT	(0)
#define S5P_CLKDIV_BUS_GDLR_MASK	(0x7 << S5P_CLKDIV_BUS_GDLR_SHIFT)
#define S5P_CLKDIV_BUS_GPLR_SHIFT	(4)
#define S5P_CLKDIV_BUS_GPLR_MASK	(0x7 << S5P_CLKDIV_BUS_GPLR_SHIFT)

/* Only for EXYNOS4210 */

#define S5P_CLKSRC_LCD1			S5P_CLKREG(0x0C238)
#define S5P_CLKSRC_MASK_LCD1		S5P_CLKREG(0x0C338)
#define S5P_CLKDIV_LCD1			S5P_CLKREG(0x0C538)
#define S5P_CLKGATE_IP_LCD1		S5P_CLKREG(0x0C938)

/* Compatibility defines and inclusion */

#include <mach/regs-pmu.h>

#define S5P_EPLL_CON			S5P_EPLL_CON0

#endif /* __ASM_ARCH_REGS_CLOCK_H */
