#!/bin/sh
# -*- mode: shell-script; indent-tabs-mode: nil; sh-basic-offset: 4; -*-
# ex: ts=8 sw=4 sts=4 et filetype=sh
#
# Licensed under the GPLv2
#
# Copyright 2011, Red Hat, Inc.
# Harald Hoyer <harald@redhat.com>

#!/bin/sh
. /lib/dracut-lib.sh
export TERM=linux

emergency_shell()
{
    local _ctty
    set +e
    if [ "$1" = "-n" ]; then
        _rdshell_name=$2
        shift 2
    else
        _rdshell_name=dracut
    fi
    echo ; echo
    warn $@
    source_hook shutdown-emergency
    echo
    if getargbool 1 rd.shell -y rdshell || getarg rd.break rdbreak; then
        echo "Dropping to debug shell."
        echo
        export PS1="$_rdshell_name:\${PWD}# "
        [ -e /.profile ] || >/.profile
        _ctty=/dev/console
        if [ -n "$(command -v setsid)" ]; then
            _ctty="$(getarg rd.ctty=)" && _ctty="/dev/${_ctty##*/}"
            [ -c "$_ctty" ] || _ctty=/dev/tty1
            setsid sh -i -l 0<$_ctty 1>$_ctty 2>&1
        elif [ -n "$(command -v openvt)" ] && ! getarg "console=" >/dev/null 2>&1 && getargbool 1 "rd.openvt" ; then
            openvt -f -c 1 -w -s -l -- sh
        else
            sh -i -l 0<$_ctty 1>$_ctty 2>&1
        fi
    else
        exec /lib/systemd/systemd-shutdown "$@"
        warn "Shutdown has failed. To debug this issue add \"rdshell\" to the kernel command line."
        # cause a kernel panic
        exit 1
    fi
}

trap "emergency_shell Signal caught!" 0

getarg 'rd.break=pre-shutdown' && emergency_shell -n cmdline "Break before pre-shutdown"

umount_a() {
    local _did_umount="n"
    while read a mp a; do
        if strstr "$mp" oldroot; then
            if umount "$mp"; then
                _did_umount="y"
                echo "Unmounted $mp."
            fi
        fi
    done </proc/mounts
    [ "$_did_umount" = "y" ] && return 0
    return 1
}

_cnt=0
while [ $_cnt -le 40 ]; do
    umount_a 2>/dev/null || break
    _cnt=$(($_cnt+1))
done
[ $_cnt -ge 40 ] && umount_a

_check_shutdown() {
    local __f
    local __s=1
    for __f in $hookdir/shutdown/*.sh; do
        [ -e "$__f" ] || continue
        ( . "$__f" $1 ) 
        if [ $? -eq 0 ]; then 
            rm -f $__f
            __s=0
        fi
    done
    return $__s
}

_cnt=0
while _check_shutdown; do
:
done
_check_shutdown final

getarg 'rd.break=shutdown' && emergency_shell -n cmdline "Break before shutdown"
[ "$1" = "reboot" ] && reboot -f -d -n --no-wall
[ "$1" = "poweroff" ] && poweroff -f -d -n --no-wall
[ "$1" = "halt" ] && halt -f -d -n --no-wall
[ "$1" = "kexec" ] && kexec -e
