#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <error.h>
#include <errno.h>

#include <kbdfile.h>

int
main(void)
{
	struct kbdfile *fp = kbdfile_open(NULL, DATADIR "/findfile/test_0/keymaps/i386/qwerty/test0.map");
	if (!fp)
		error(EXIT_FAILURE, 0, "unable to create kbdfile");

	const char *expect = DATADIR "/findfile/test_0/keymaps/i386/qwerty/test0.map";
	if (strcmp(expect, kbdfile_get_pathname(fp)) != 0)
		error(EXIT_FAILURE, 0, "unexpected file: %s (expected %s)", kbdfile_get_pathname(fp), expect);

	kbdfile_free(fp);

	return EXIT_SUCCESS;
}
