/* Copyright (C) 1998, 1999 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/time.h>
#include <rpcsvc/nis.h>

#include "nisd.h"

int
start_clock (struct timeval *start)
{
  if (start == NULL)
    return -1;

  gettimeofday (start, NULL);

  return 0;
}

u_long
stop_clock (struct timeval *start)
{
  struct timeval end;

  if (start == NULL)
    return 0;

  gettimeofday (&end, NULL);

  return (end.tv_usec - start->tv_usec) +
    ((end.tv_sec - start->tv_sec) * 1000000);
}
