#!/usr/bin/tclsh

# If it is a link get the path to the target, if not, the path is the path of the script
if { [ catch { file link $argv0 } ] } {
	set scriptpath [file dirname $argv0]
} else {
	set scriptpath [file dirname [file readlink $argv0]]
}

append guifilename $scriptpath "/remotedesktopclientGUI.tcl"

source $guifilename

set optionsVisible false
set hostname ""
set currentFileName ""

#Checks to see if the remotedesktop configuration folder exists. If not, create it
set defaultFolder [file normalize "~/.config/remotedesktopclient/"]
if { [ file exists $defaultFolder ] == 0 } {
		file mkdir $defaultFolder
}

#see if the rdesktop command is accessible
set rdesktop ""
catch { set rdesktop [ exec which rdesktop ] }
if { [ file exists $rdesktop ] == 0 } {
	showError "rdesktop was not found please ensure that the command is in your path"
	exit
}

buildMainWindow

proc saveProfile { } {
	global defaultFolder currentFileName
	global hostname username password domain consolemode displaysize colors 
	global sound keyboardbindings disks comports 
	global connectionspeed bitmapcaching compression mousemotion bitmapupdates
	
	if { $currentFileName == "" } {
		if { $hostname == "" } {
			set currentFileName "$defaultFolder/new.rdp"
		} else {
			set currentFileName "$defaultFolder/$hostname.rdp"
		}
	}

	set newFileName [getSaveFileName $currentFileName]

	if {$newFileName != ""} {
    set file [ open $newFileName w ]
    set currentFileName $newFileName
    puts $file "Ver 0.3"
		puts $file $hostname
		puts $file $username 
		puts $file $domain
		puts $file $bitmapcaching
		puts $file $displaysize
		puts $file $connectionspeed
		puts $file $colors
		puts $file $disks
		puts $file $comports
		puts $file $sound
		puts $file $compression
		puts $file $consolemode
		puts $file $mousemotion
		puts $file $bitmapupdates
		puts $file $keyboardbindings

    close $file
	}
}

proc loadProfile { } {
	global defaultFolder currentFileName
	global hostname username password domain consolemode displaysize colors 
	global sound keyboardbindings disks comports 
	global connectionspeed bitmapcaching compression mousemotion bitmapupdates
	
	set newFileName [getOpenFileName $defaultFolder]
	
	if {$newFileName != ""} {
    set file [ open $newFileName r ]
    set currentFileName $newFileName
    gets $file 
		gets $file hostname
		gets $file username
		gets $file domain
		gets $file bitmapcaching
		gets $file displaysize
		gets $file connectionspeed
		gets $file colors
		gets $file disks
		gets $file comports
		gets $file sound
		gets $file compression
		gets $file consolemode
		gets $file mousemotion
		gets $file bitmapupdates
		gets $file keyboardbindings

    close $file
	}
}

proc connect { } {
	global rdesktop
	global hostname username password domain consolemode displaysize colors 
	global sound keyboardbindings disks comports 
	global connectionspeed bitmapcaching compression mousemotion bitmapupdates

	if { $hostname == "" } { showError "You Must Enter a Hostname" } \
	else {
    if {$domain != ""} { set d  "-d $domain" } \
    else { set d "" }

    if {$username != ""} { set u  "-u $username"	} \
    else { set u "" }
		
    if {$password != ""} { set p  "-p $password" } \
    else { set p "" }

    if {$disks == "1"} { set rd "-r disk:local=/" } \
    else { set rd "" }

    if {$comports == "1"} { set rc "-r com1:COM1=/dev/ttyS0" } \
    else { set rc "" }
    
    switch -exact $sound {
    	"Bring to this computer"  { set rs "-r sound:local" }
    	"Keep in remote computer" { set rs "-r sound:remote" }
    	"No sound" { set rs "-r sound:off" }
    	default  { set rs "" }
    }

    switch -exact $keyboardbindings {
    	"In full screen mode only" { 
    		if {$displaysize == "Full Screen"} { set K "-K" } \
    		else { set K ""}
    	}
    	"Always" { set K "-K" }
    	"Never" { set K "" }
    	default { set K "" }
    }

    switch -exact $colors {
    	"256" { set a "-a 8" } 
    	"65,000" { set a "-a 16" } 
    	"Millions" { set a "-a 24" }
    	default {	set a "" }
    }
	
		switch -exact $connectionspeed {
			"Modem (dial-up)" { set x "-x m" }
			"Broadband (high speed)" { set x "-x b" } 
			"LAN (10Mbps or higher)" { set x "-x l" }
			default {	set x "" }
    }

    if {$compression == "1"} { set z "-z" }  \
    else { set z "" }

    if {$bitmapcaching == "1"} { set P "-P" } \
    else { set P "" }

    if {$bitmapupdates == "1"} { set b "-b" } \
    else { set b "" }

    if {$mousemotion == "1"} { set m "-m" } \
    else { set m "" }

    if {$consolemode == "1"} { set cm "-0" } \
    else { set cm "" }

    if {$displaysize == "Full Screen"} { set g "-f" } \
    else { set g "-g$displaysize" }

		#puts "$rdesktop $u $p $d $g $x $a $z $rd $rc $rs $cm $m $P $b $K $hostname"
		open "| $rdesktop $u $p $d $g $x $a $z $rd $rc $rs $cm $m $P $b $hostname"
		exit
	}
}
