#!/bin/tclsh

package require Gnocl

proc showError { message} {
	gnocl::dialog -type error -title "Remote desktop client" -text $message

}

proc createStandardEntryFrame {} {
	return [gnocl::box -orientation horizontal -borderWidth 0 -align left]
}

proc showHideNotebook {} {
	global optionsVisible
	global optionsFrame
	global hostFrame
	global hostEntry
	global hostEntry2

	
	if { $optionsVisible } {
		set optionsVisible false
		$hostEntry configure -hasFocus true
	} else {
		set optionsVisible true
		$hostEntry2 configure -hasFocus true
	}
		
	$hostFrame configure -visible [expr ! $optionsVisible ]
	$optionsFrame configure -visible $optionsVisible
}

proc buildMainWindow {} {
	global optionsFrame
	global optionsNotebook
	global optionsVisible
	global hostFrame
	global hostEntry
	
	set mainWin [gnocl::window -title "Remote desktop client" -onDestroy {exit} -allowGrow false -resizable false -x 50 -y 50]
	set mainFrame [gnocl::box -orientation vertical -borderWidth 0 -spacing 0]
	$mainWin configure -child $mainFrame

	global scriptpath
	append imagefilename "%/" $scriptpath "/remotedesktopclient.png"
	
	$mainFrame add [set headerImg [gnocl::image -image $imagefilename]]

	$mainFrame add [set hostFrame [gnocl::box -orientation horizontal -align left]]
	$hostFrame add [set hostLbl [gnocl::label -text "ホスト名 " -widthChars 11 -align right]]
	$hostFrame add [set hostEntry [gnocl::entry -variable hostname]]

	$mainFrame add [set optionsFrame [gnocl::box -orientation vertical]]
	$optionsFrame configure -visible $optionsVisible

	$optionsFrame add [set optionsNotebook [gnocl::notebook]]

	addGeneralTab
	addDisplayTab
	addResourcesTab
	addExperienceTab
	
	$mainFrame add [set btnFrame [gnocl::box -orientation horizontal -buttonType 1 -layout end -spacing small]]
	$btnFrame add [gnocl::button -text "接続" -icon "%#Network" -widthGroup buttons -onClicked { connect }]
	$btnFrame add [gnocl::button -text "%#Cancel" -widthGroup buttons -onClicked { exit }]
	#$btnFrame add [gnocl::button -text "%#Help" -widthGroup buttons -onClicked {exit}]
	$btnFrame add [gnocl::button -text "オプション" -icon "%#Preferences" -widthGroup buttons -onClicked {showHideNotebook}]

	$hostEntry configure -hasFocus true
}

proc addGeneralTab {} {
	global hostEntry2
	global optionsNotebook
	$optionsNotebook addPage [set generaPage [gnocl::box -orientation vertical -spacing small]] "一般"
	
	$generaPage add [set loginFrame [gnocl::box -orientation vertical -spacing normal -shadow etchedIn -label "ログイン設定"]]

	$loginFrame add [set hostFrame2 [createStandardEntryFrame]]
	$hostFrame2 add [gnocl::label -text "ホスト名 " -widthChars 10 -align right]
	$hostFrame2 add [set hostEntry2 [gnocl::entry -variable hostname]]

	$loginFrame add [set userFrame [createStandardEntryFrame]]
	$userFrame add [gnocl::label -text "ユーザ名 " -widthChars 10 -align right]
	$userFrame add [set userEntry [gnocl::entry -variable username]]

	$loginFrame add [set passwordFrame [createStandardEntryFrame]]
	$passwordFrame add [gnocl::label -text "パスワード " -widthChars 10 -align right]
	$passwordFrame add [set passwordEntry [gnocl::entry -variable password -textVisible false]]

	$loginFrame add [set domainFrame [createStandardEntryFrame]]
	$domainFrame add [gnocl::label -text "ドメイン " -widthChars 10 -align right]
	$domainFrame add [set domainEntry [gnocl::entry -variable domain]]

	$loginFrame add [set consoleFrame [createStandardEntryFrame]]
	$consoleFrame add [gnocl::label -text " " -widthChars 10 -align right]
	$consoleFrame add [set consoleCheck [gnocl::checkButton -text "コンソールモード" -relief half -variable consolemode]]
	
	$generaPage add [set fileFrame [gnocl::box -orientation horizontal -buttonType 1 -layout spread -label "現在の設定を保存する、又は保存された接続を開く" -shadow etchedIn]]
	$fileFrame add [gnocl::button -text "%#Save" -widthGroup buttons -onClicked {saveProfile}]
	$fileFrame add [gnocl::button -text "%#Open" -widthGroup buttons -onClicked {loadProfile}]

}

proc addDisplayTab {} {
	global optionsNotebook
	$optionsNotebook addPage [set displayPage [gnocl::box -orientation vertical -spacing small]] "ディスプレイ"
	
	$displayPage add [set sizeFrame [gnocl::box -orientation vertical -spacing small -shadow etchedIn -label "リモートデスクトップサイズ"]]
	$sizeFrame add [gnocl::label -align left -text  "リモートデスクトップの解像度を選択して下さい."]
	$sizeFrame add [set sizeFrameIn [createStandardEntryFrame]]
	$sizeFrameIn add [gnocl::label -text " " -widthChars 5 -align right]
	$sizeFrameIn add [set displayCombo [gnocl::optionMenu -items {"640x480" "800x600" "1024x768" "Full Screen"} -variable displaysize]]

	$displayPage add [set colorsFrame [gnocl::box -orientation vertical -spacing small -shadow etchedIn -label "色"]]
	$colorsFrame add [set colorsFrameIn [createStandardEntryFrame]]
	$colorsFrameIn add [gnocl::label -text " " -widthChars 5 -align right]
	$colorsFrameIn add [set displayCombo [gnocl::optionMenu -items {"256" "65,000" "Millions"} -variable colors]]
	$colorsFrame add [gnocl::label -align left -text  "注意: リモートコンピュータの設定はこの設定を\n無効にするか知れません"]

}

proc addResourcesTab {} {
	global optionsNotebook
	$optionsNotebook addPage [set resourcesPage [gnocl::box -orientation vertical -spacing small]] "ローカルリソース"
	
	$resourcesPage add [set soundFrame [gnocl::box -orientation vertical -spacing small -shadow etchedIn -label "リモートコンピュータのサウンド"]]
	$soundFrame add [set soundFrameIn [createStandardEntryFrame]]
	$soundFrameIn add [gnocl::label -text " " -widthChars 5 -align right]
	$soundFrameIn add [set displayCombo [gnocl::optionMenu -items {"Bring to this computer" "Keep in remote computer" "No sound"} -variable sound]]

	$resourcesPage add [set keyboardFrame [gnocl::box -orientation vertical -spacing small -shadow etchedIn -label "キーボード"]]
	$keyboardFrame add [gnocl::label -align left -text  "ウィンドウマネージャはキーバインドを保持(例えば Alt-Tab)"]
	$keyboardFrame add [set keyboardFrameIn [createStandardEntryFrame]]
	$keyboardFrameIn add [gnocl::label -text " " -widthChars 5 -align right]
	$keyboardFrameIn add [set displayCombo [gnocl::optionMenu -items {"In full screen mode only" "Always" "Never"} -variable keyboardbindings]]

	$resourcesPage add [set devicesFrame [gnocl::box -orientation vertical -spacing small -shadow etchedIn -label "ローカルデバイス"]]
	$devicesFrame add [gnocl::label -align left -text  "リモートコンピュータにログオンするとこのローカルデバイスに\n自動的に接続:"]

	$devicesFrame add [set disksFrame [createStandardEntryFrame]]
	#$disksFrame add [gnocl::label -text " " -widthChars 5 -align right]
	$disksFrame add [set consoleCheck [gnocl::checkButton -text "ディスクドライブ" -relief half -variable disks]]

	#$devicesFrame add [set comFrame [createStandardEntryFrame]]
	#$comFrame add [gnocl::label -text " " -widthChars 5 -align right]
	$disksFrame add [set consoleCheck [gnocl::checkButton -text "COMポート" -relief half -variable comports]]

}

proc addExperienceTab {} {
	global optionsNotebook
	$optionsNotebook addPage [set experiencePage [gnocl::box -orientation vertical -spacing small]] "経験"

	$experiencePage add [gnocl::label -align left -text  "性能を最適化する接続速度を選択して下さい"]
	$experiencePage add [set speedFrame [createStandardEntryFrame]]
	$speedFrame add [gnocl::label -text " " -widthChars 5 -align right]
	$speedFrame add [set displayCombo [gnocl::optionMenu -items {"Modem (dial-up)" "Broadband (high speed)" "LAN (10Mbps or higher)"} -variable connectionspeed]]

	$experiencePage add [gnocl::label -align left -text  "\n以下を許可"]
	
	$experiencePage add [set bitmapCachingFrame [createStandardEntryFrame]]
	$bitmapCachingFrame add [gnocl::label -text " " -widthChars 5 -align right]
	$bitmapCachingFrame add [set consoleCheck [gnocl::checkButton -text "ビットマップキャッシュ" -relief half -variable bitmapcaching]]

	$experiencePage add [set compressionFrame [createStandardEntryFrame]]
	$compressionFrame add [gnocl::label -text " " -widthChars 5 -align right]
	$compressionFrame add [set consoleCheck [gnocl::checkButton -text "圧縮を可能にする" -relief half -variable compression]]

	$experiencePage add [set bitmapUpdatesFrame [createStandardEntryFrame]]
	$bitmapUpdatesFrame add [gnocl::label -text " " -widthChars 5 -align right]
	$bitmapUpdatesFrame add [set consoleCheck [gnocl::checkButton -text "ビットマップを強制的にアップデート" -relief half -variable bitmapupdates]]
	
	$experiencePage add [set mouseMotionFrame [createStandardEntryFrame]]
	$mouseMotionFrame add [gnocl::label -text " " -widthChars 5 -align right]
	$mouseMotionFrame add [set consoleCheck [gnocl::checkButton -text "マウス動作イベントを送らない" -relief half -variable mousemotion]]

}

proc getOpenFileName { defaultFolder } {
	set filename [gnocl::fileChooser -title "Please choose an rdp connection file" -currentFolder $defaultFolder ]

	return $filename
}

proc getSaveFileName { currentFileName } {
	return [gnocl::fileChooser -action save -title "Please choose a name rdp connection file" -currentFolder [file dirname $currentFileName] -currentName [file tail $currentFileName ]]
}
