package postal;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.border.*;

/* for Swing 1.1 beta2
import com.sun.java.swing.*;
import com.sun.java.swing.table.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.border.*;
*/

public class Postal extends JFrame {

  // ǥեȥե
  Font font = new Font("Serif",Font.PLAIN,12);

  Container pane = getContentPane();

  JTextField oldPcode;
  JTextField newPcode;
  JTextField city;
  JTextField town;
  JTextField kana_city;
  JTextField kana_town;
  JTextField host;
  JTextField port;
  JTextField user;
  JPasswordField pwd;
  JTextField db;
  JComboBox pre;
  JTable table;
  dbTableModel myTableModel;

  boolean isQuery;

  Dimension horizontalPadding = new Dimension(10, 1);
  Border raisedBorder = new BevelBorder(BevelBorder.RAISED);


  Postal() {
    super("Postal Code Search System");

    /* Motif Look & Feel
    try {
      UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    } catch (Exception ex) {
      System.out.println("Unable to set Motif Look & Feel");
    }
    */

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {System.exit(0);}
    });

    pane.setLayout(new BoxLayout(pane,BoxLayout.Y_AXIS));

    //---------------------------------------------------------------------
    // pcodes
    //
    JPanel pcodes = new JPanel();
    pcodes.setBorder(new BevelBorder(BevelBorder.LOWERED));

    // 좩ֹ
    JLabel l = new JLabel("͹ֹ");
    l.setFont(font);
    pcodes.add(l);

    oldPcode = new JTextField(10);
    oldPcode.setToolTipText("͹ֹ123-45ηϤޤ");
    oldPcode.setFont(font);

    pcodes.add(oldPcode);

    // ֹ
    l = new JLabel("͹ֹ");
    l.setFont(font);
    pcodes.add(l);
    newPcode = new JTextField(10);
    newPcode.setFont(font);
    newPcode.setToolTipText("͹ֹ123-4567ηϤޤ");
    pcodes.add(newPcode);

    //---------------------------------------------------------------------
    // pre
    //
    l = new JLabel("ƻܸ");
    l.setFont(font);
    pcodes.add(l);
    pre = new JComboBox(Prefecture.preList);
    pre.setFont(font);
    pre.setSelectedItem(Prefecture.preList[0]);
    pcodes.add(pre);

    pane.add(pcodes);

    //---------------------------------------------------------------------
    // labelPanel
    //
    JPanel labelPanel = new JPanel(new GridLayout(0, 1));
    // Į¼̾
    l = new JLabel("Į¼̾");
    l.setFont(font);
    labelPanel.add(l);
    // Į̾
    l = new JLabel("Į̾");
    labelPanel.add(l);
    l.setFont(font);
    // Į¼̾()
    l = new JLabel("Į¼̾()");
    labelPanel.add(l);
    l.setFont(font);
    // Į̾()
    l = new JLabel("Į̾()");
    labelPanel.add(l);
    l.setFont(font);

    //---------------------------------------------------------------------
    // textPanel
    //
    JPanel textPanel = new JPanel(new GridLayout(0, 1));
    city = new JTextField(30);
    city.setFont(font);
    textPanel.add(city);

    town = new JTextField(30);
    town.setFont(font);
    textPanel.add(town);

    kana_city = new JTextField(30);
    kana_city.setFont(font);
    textPanel.add(kana_city);

    kana_town = new JTextField(30);
    kana_town.setFont(font);
    textPanel.add(kana_town);

    JPanel areaPanel = new JPanel();
    areaPanel.add(labelPanel);
    areaPanel.add(textPanel);

    //---------------------------------------------------------------------
    // ButtonPanel
    //
    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));

    // ϥܥ
    JButton execQueryButton = new JButton("");
    execQueryButton.setFont(font);
    execQueryButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
	execQuery();
      }
    }
				  );

    execQueryButton.setBorder(raisedBorder);

    buttonPanel.add(execQueryButton);
    
    buttonPanel.add(Box.createRigidArea(horizontalPadding));

    // 說ꥢܥ
    JButton clearButton = new JButton("說ꥢ");
    clearButton.setFont(font);
    clearButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	clear();
      }
    }
				  );
    clearButton.setBorder(raisedBorder);

    buttonPanel.add(clearButton);

    JPanel subPanel = new JPanel();
    subPanel.add(buttonPanel);

    JPanel middlePanel = new JPanel();
    middlePanel.add(areaPanel);
    middlePanel.add(subPanel);

    //---------------------------------------------------------------------
    // ButtonPanel
    //
    JPanel exitPanel = new JPanel(new GridLayout(0, 1));
    exitPanel.setBorder(new BevelBorder(BevelBorder.LOWERED));

    JButton exitButton = new JButton("λ");
    exitButton.setFont(font);
    exitButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	int opt = JOptionPane.showConfirmDialog(null,
						"λƤǤ",
						"Question", 
						JOptionPane.OK_CANCEL_OPTION,
						JOptionPane.QUESTION_MESSAGE
						);
	if (opt == 0) {
	  System.exit(0);
	}
      }
    });
    exitButton.setBorder(raisedBorder);
    exitPanel.add(exitButton);

    middlePanel.add(exitButton);
    
    pane.add(middlePanel);

    //---------------------------------------------------------------------
    // host, port, user etc.
    //
    JPanel url = new JPanel();
    url.setBorder(new BevelBorder(BevelBorder.LOWERED));

    l = new JLabel("ۥ̾");
    l.setFont(font);
    url.add(l);
    host = new JTextField("localhost", 8);
    host.setFont(font);
    url.add(host);

    l = new JLabel("ǡ١");
    l.setFont(font);
    url.add(l);
    db = new JTextField("postal", 8);
    db.setFont(font);
    url.add(db);

    l = new JLabel("桼̾");
    l.setFont(font);
    url.add(l);
    user = new JTextField(System.getProperty("user.name"), 8);
    user.setFont(font);
    url.add(user);

    l = new JLabel("ѥ");
    l.setFont(font);
    url.add(l);
    pwd = new JPasswordField(8);
    pwd.setFont(font);
    url.add(pwd);

    l = new JLabel("ݡֹ");
    l.setFont(font);
    url.add(l);
    port = new JTextField("5432", 5);
    port.setFont(font);
    url.add(port);

    pane.add(url);

    //---------------------------------------------------------------------
    // ɽơ֥
    //
    pane.add(createTable());
  }

  public void clear() {
    oldPcode.setText("");
    newPcode.setText("");
    city.setText("");
    town.setText("");
    kana_city.setText("");
    kana_town.setText("");
  }

  public void execQuery() {
    isQuery = false;
    String sql = "select newcode,oldcode,pid,city,town,kana_city,kana_town from postal";
    sql = makeup1(sql,"oldcode", oldPcode.getText());
    sql = makeup1(sql,"newcode", newPcode.getText());
    sql = makeup2(sql,"pid", pre.getSelectedIndex()-1);
    sql = makeup3(sql,"city",city.getText());
    sql = makeup3(sql,"town",town.getText());
    sql = makeup3(sql,"kana_city",kana_city.getText());
    sql = makeup3(sql,"kana_town",kana_town.getText());

    if (isQuery == false) {
      Object msg[] = {"ϤƤޤ"};
      JOptionPane.showMessageDialog(pane, msg, "Info", 
				    JOptionPane.WARNING_MESSAGE);
	return;
    }
      
    sql = sql.concat(" order by newcode");
    String password = new String(pwd.getPassword());

    Object msg[] = myTableModel.doSelect(sql,
					 host.getText(),
					 port.getText(),
					 db.getText(),
					 user.getText(),
					 password
					 );

    if (msg != null) {
      JOptionPane.showMessageDialog(pane, msg, "Error", 
				    JOptionPane.ERROR_MESSAGE);
    }
    myTableModel.fireTableDataChanged();
  }

/**
 * ͹ֹեɤ䤤碌ʳʸ̵뤹롣
 * @param sqlstr SQLʸ
 * @param name ̾
 * @param value 桼Ϥθ
 */
  public String makeup1 (String sqlstr, String name, String value) {

    StringBuffer sql = new StringBuffer(sqlstr);
    StringBuffer v = new StringBuffer();

    if (value.length() != 0) {
      for (int i=0;i<value.length();i++) {
	String s = value.substring(i,i+1);
	try {
	  Integer idigit = new Integer(s);
	  v.append(s);
	} catch (NumberFormatException ex) {
	}
      }
      if (isQuery == true) {
	sql.append(" and");
      } else {
	sql.append(" where");
      }
      sql.append(" "+name+" = '"+v+"'");
      isQuery = true;
    }
    return new String(sql);
  }

/**
 * ƻܸɥեɤ䤤碌
 * @param sqlstr SQLʸ
 * @param name ̾
 * @param value 桼Ϥθ(ƻܸ)
 */
  public String makeup2 (String sqlstr, String name, int value) {
    StringBuffer sql = new StringBuffer(sqlstr);

    if (value >= 0) {
      if (isQuery == true) {
	sql.append(" and");
      } else {
	sql.append(" where");
      }
      sql.append(" "+name+" = '"+value+"'");
      isQuery = true;
    }
    return new String(sql);
  }

/**
 * Į¼̾ʤɤʸեɤ䤤碌
 * ̵׸Ԥ
 * @param sqlstr SQLʸ
 * @param name ̾
 * @param value 桼Ϥθ
 */
  public String makeup3 (String sqlstr, String name, String value) {

    StringBuffer sql = new StringBuffer(sqlstr);
    StringBuffer v = new StringBuffer();

    if (value.length() != 0) {
      if (value.substring(0,1).equals("^") == false) {
	v.append("^");
      }
      v.append(value);
      if (isQuery == true) {
	sql.append(" and");
      } else {
	sql.append(" where");
      }
      sql.append(" "+name+" = '"+v+"'");
      isQuery = true;
    }
    return new String(sql);
  }
	
/**
 * ɽơ֥롣
 *
 */
  public JScrollPane createTable() {
    myTableModel = new dbTableModel();
    table = new JTable(myTableModel); 
    table.setFont(font);
    table.getTableHeader().setFont(font);
    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF); 
    JScrollPane scrollpane = new JScrollPane(table);

    // Į¼̾()Į̾()Υ򹭤롣
    Component c = table.getDefaultRenderer(myTableModel.getColumnClass(5)).
      getTableCellRendererComponent(
				    table, "ˤʤФ",
				    false, false, 0, 5);
    int width = c.getPreferredSize().width;
    TableColumn tc = table.getColumnModel().getColumn(5);
    tc.setPreferredWidth(width);
    tc = table.getColumnModel().getColumn(6);
    tc.setPreferredWidth(width);
    return scrollpane;
  }

  public static void main(String s[]) {
    Postal postal = new Postal();
    postal.pack();
    postal.setVisible(true);
  }
}
