package svpgpost;

import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import svpgpost.common.*;

public class SvPgPost extends HttpServlet {

  public void doGet(HttpServletRequest request,HttpServletResponse response)  throws ServletException, IOException {
    doPost(request, response);
  }

  public void doPost (HttpServletRequest request,HttpServletResponse response)  throws ServletException, IOException {

    String title = "SvPgpost: jpgpost servlet version";

    myServletContents contents = new myServletContents(response);
    contents.Header(title);
    contents.Body(request);
    contents.Footer();
  }

  private class myServletContents extends ServletContents {

    protected myServletContents (HttpServletResponse response) throws ServletException {
      super(response);
    }

    public void Body(HttpServletRequest request) {

      PrintWriter out;
      Connection db;
      String url;
      String user = "nobody";
      String password = "";
      ResultSet rs;
      int cnt = 0;
      int ucnt;
      int limit;

      out = this.getWriter();

      String oldcode = request.getParameter("oldcode");
      String newcode = request.getParameter("newcode");
      String prefecture = request.getParameter("prefecture");
      String city = Misc.myGetParameter(request, "city");
      String town = Misc.myGetParameter(request, "town");
      String kana_city = Misc.myGetParameter(request, "kana_city");
      String kana_town = Misc.myGetParameter(request, "kana_town");
      String ulimit = request.getParameter("ulimit");

      try {
	limit = Integer.parseInt(ulimit);
      } catch (NumberFormatException e) {
	out.println("ɽ·:" + ulimit + " ޤ");
	return;
      }

      String dbname = request.getParameter("dbname");
      String hostname = request.getParameter("hostname");
      String port = request.getParameter("port");
      String sqlprint = request.getParameter("sqlprint");

      /*
       * PostgreSQL URL style is one of:
       * jdbc:postgresql:database
       * jdbc:postgresql://host/database
       * jdbc:postgresql://host:port/database
       */
      if (port.length() > 0) {
	if (hostname.length() == 0) {
	  hostname = "localhost";
	}
	url = "jdbc:postgresql://" + hostname + ":" + port + "/" + dbname;
      } else {
	if (hostname.length() == 0) {
	  url = "jdbc:postgresql:" + dbname;
	} else {
	url = "jdbc:postgresql.EUC_JP://" + hostname + "/" + dbname;
	}
      }

      try {
	Class.forName("postgresql.Driver");
      } catch (java.lang.ClassNotFoundException e) {
	out.println("PostgreSQL  JDBC ɥ饤Фޤ");
	e.printStackTrace(out);
	return;
      }
      try {
	db = DriverManager.getConnection(url, user, password);
      } catch (java.sql.SQLException e) {
	out.println("PostgreSQL  JDBC ɥ饤Фޤ");
	e.printStackTrace(out);
	return;
      } catch (java.lang.NullPointerException e) {
	out.println("url:" + url + " user:" + user + " password" + password);
	e.printStackTrace(out);
	return;
      }

      Qual query = new Qual("SELECT newcode,oldcode,pref,city,town,kana_city,kana_town from postal,prefecture ");

      if (oldcode.length() > 0) {
	query.add("oldcode = '" + oldcode + "'");
      }
      if (newcode.length() > 0) {
	query.add("newcode = '" + newcode + "'");
      }
      if (prefecture.equals("-1") == false && prefecture.length() > 0) {
	query.add("postal.pid = '" + prefecture + "'");
      }
      if (city.length() > 0) {
	query.add("city ~ '^" + city + "'");
      }
      if (town.length() > 0) {
	query.add("town ~ '^" + town + "'");
      }
      if (kana_city.length() > 0) {
	query.add("kana_city ~ '^" + kana_city + "'");
      }
      if (kana_town.length() > 0) {
	query.add("kana_town ~ '^" + kana_town + "'");
      }

      if (query.hasQual() == false) {
	out.println("ꤵƤޤ");
	return;
      }

      query.add("postal.pid = prefecture.pid order by newcode");

      if (sqlprint != null && sqlprint.length() > 0) {
	out.println("ʲSQLʸȯԤޤ<br>");
	query.printQual(out);
      }

      try {
	Statement st = db.createStatement();
	st.executeUpdate("BEGIN");
	String q = "DECLARE C CURSOR FOR "+ query.getString();
	st.executeUpdate(q);

	out.println("<h1></h1>");
	out.println("<table border>");
	out.println("<tr>");
	out.println("<th nowrap>͹ֹ</th>");
	out.println("<th nowrap>͹ֹ</th>");
	out.println("<th nowrap>ƻܸ</th>");
	out.println("<th nowrap>Į¼</th>");
	out.println("<th nowrap>Į̾</th>");
	out.println("<th nowrap>Į¼()</th>");
	out.println("<th nowrap>Į̾()</th>");

	rs = st.executeQuery("FETCH " + ulimit + " IN C");

	ucnt = 0;
	while (rs.next()) {
	  ucnt++;
	  out.println("<tr>");

	  String h_newcode = rs.getString(1);
	  out.println("<td>"+h_newcode.substring(0,3)+"-"+h_newcode.substring(3,7)+"</td>");

	  String h_oldcode = rs.getString(2);
	  if (h_oldcode.length() > 3) {
	    out.println("<td>"+h_oldcode.substring(0,4)+"-"+h_oldcode.substring(3,5)+"</td>");
	  } else {
	    out.println("<td>"+h_oldcode+"</td>");
	  }

	  for (int i=3;i<=7;i++) {
	    out.println("<td nowrap>" + rs.getString(i) + "</td>");
	  }

	  out.println("</tr>");
	}

	if (limit <= ucnt) {
	  ucnt = limit;
	  for (;;) {
	    rs = st.executeQuery("FETCH 1000 IN C");
	    int n = ((postgresql.ResultSet)rs).getTupleCount();
	    ucnt += n;
	    if (n != 1000) {
	      break;
	    }
	  }
	} else {
	  limit = ucnt;
	}

	st.executeUpdate("END");
	st.close();

	out.println(ucnt + "" + limit + "ɽޤ");

	out.println("</table>");

      } catch (SQLException e) {
	out.println("SQL 顼Ǥ");
	e.printStackTrace(out);	
	return;
      }
    }
  }
}
