package svpgpost.common;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public abstract class ServletContents {
  private PrintWriter out = null;

  public ServletContents (HttpServletResponse response) throws ServletException {
    response.setContentType("text/html; charset=iso-2022-jp");
    String encoding = response.getCharacterEncoding();
    OutputStreamWriter osw = null;
    try {
      osw = new OutputStreamWriter(response.getOutputStream(), encoding);
    } catch (java.io.UnsupportedEncodingException e) {
      throw new ServletException("OutputStreamWriter failed");
    } catch (java.io.IOException e) {
      throw new ServletException("OutputStreamWriter failed");
    }
    this.out = new PrintWriter(osw);
  }

  public void Header(String title) {
    this.out.println("<html>");
    this.out.println("<head>");
    this.out.println("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=iso-2022-jp\">");
    this.out.println("<title>"+title+"</title>");
    this.out.println("</head>");
    this.out.println("<body bgcolor=\"white\">");
  }

  public void Footer() {
    this.out.println("</body>");
    this.out.println("</html>");
    this.out.flush();
    this.out.close();
  }

  public PrintWriter getWriter() {
    return this.out;
  }

  public abstract void Body(HttpServletRequest request);
}
