.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DELETE" "" "2005-01-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
DELETE \- delete rows of a table

.SH SYNOPSIS
.sp
.nf
DELETE FROM [ ONLY ] \fItable\fR [ WHERE \fIcondition\fR ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDELETE\fR deletes rows that satisfy the
WHERE clause from the specified table. If the
WHERE clause is absent, the effect is to delete
all rows in the table. The result is a valid, but empty table.
.sp
.RS
.B "Tip:"
TRUNCATE [\fBtruncate\fR(l)] is a
PostgreSQL extension that provides a
faster mechanism to remove all rows from a table.
.RE
.sp
.PP
By default, \fBDELETE\fR will delete rows in the
specified table and all its subtables. If you wish to delete only
from the specific table mentioned, you must use the
ONLY clause.
.PP
You must have the DELETE privilege on the table
to delete from it, as well as the SELECT
privilege for any table whose values are read in the \fIcondition\fR.
.SH "PARAMETERS"
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of an existing table.
.TP
\fB\fIcondition\fB\fR
A value expression that returns a value of type
\fBboolean\fR that determines the rows which are to be
deleted.
.SH "OUTPUTS"
.PP
On successful completion, a \fBDELETE\fR command returns a command
tag of the form
.sp
.nf
DELETE \fIcount\fR
.sp
.fi
The \fIcount\fR is the number
of rows deleted. If \fIcount\fR is
0, no rows matched the \fIcondition\fR (this is not considered
an error).
.SH "EXAMPLES"
.PP
Delete all films but musicals:
.sp
.nf
DELETE FROM films WHERE kind <> 'Musical';
.sp
.fi
.PP
Clear the table films:
.sp
.nf
DELETE FROM films;
.sp
.fi
.SH "COMPATIBILITY"
.PP
This command conforms to the SQL standard.
