/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.PGResultSetMetaData;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Field;
import org.postgresql.jdbc2.TypeInfoCache;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2ResultSetMetaData
implements PGResultSetMetaData {
    protected final BaseConnection connection;
    protected final Field[] fields;
    private Hashtable tableNameCache;
    private Hashtable schemaNameCache;

    public AbstractJdbc2ResultSetMetaData(BaseConnection connection, Field[] fields) {
        this.connection = connection;
        this.fields = fields;
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getAutoIncrement(this.connection);
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        Field field = this.getField(column);
        return TypeInfoCache.isCaseSensitive(field.getOID());
    }

    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        String type_name = this.getPGType(column);
        return type_name.equals("cash") || type_name.equals("money");
    }

    public int isNullable(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getNullable(this.connection);
    }

    public boolean isSigned(int column) throws SQLException {
        Field field = this.getField(column);
        return TypeInfoCache.isSigned(field.getOID());
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        Field field = this.getField(column);
        return TypeInfoCache.getDisplaySize(field.getOID(), field.getMod());
    }

    public String getColumnLabel(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getColumnLabel();
    }

    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    public String getBaseColumnName(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getColumnName(this.connection);
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseSchemaName(int column) throws SQLException {
        String schemaName;
        Field field = this.getField(column);
        if (field.getTableOid() == 0) {
            return "";
        }
        Integer tableOid = new Integer(field.getTableOid());
        if (this.schemaNameCache == null) {
            this.schemaNameCache = new Hashtable();
        }
        if ((schemaName = (String)this.schemaNameCache.get(tableOid)) != null) {
            return schemaName;
        }
        ResultSet res = null;
        PreparedStatement ps = null;
        try {
            String sql = "SELECT n.nspname FROM pg_catalog.pg_class c, pg_catalog.pg_namespace n WHERE n.oid = c.relnamespace AND c.oid = ?;";
            ps = this.connection.prepareStatement(sql);
            ps.setInt(1, tableOid);
            res = ps.executeQuery();
            schemaName = "";
            if (res.next()) {
                schemaName = res.getString(1);
            }
            this.schemaNameCache.put(tableOid, schemaName);
            String string = schemaName;
            return string;
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public int getPrecision(int column) throws SQLException {
        Field field = this.getField(column);
        return TypeInfoCache.getPrecision(field.getOID(), field.getMod());
    }

    public int getScale(int column) throws SQLException {
        Field field = this.getField(column);
        return TypeInfoCache.getScale(field.getOID(), field.getMod());
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseTableName(int column) throws SQLException {
        String tableName;
        Field field = this.getField(column);
        if (field.getTableOid() == 0) {
            return "";
        }
        Integer tableOid = new Integer(field.getTableOid());
        if (this.tableNameCache == null) {
            this.tableNameCache = new Hashtable();
        }
        if ((tableName = (String)this.tableNameCache.get(tableOid)) != null) {
            return tableName;
        }
        ResultSet res = null;
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement("SELECT relname FROM pg_catalog.pg_class WHERE oid = ?");
            ps.setInt(1, tableOid);
            res = ps.executeQuery();
            tableName = "";
            if (res.next()) {
                tableName = res.getString(1);
            }
            this.tableNameCache.put(tableOid, tableName);
            String string = tableName;
            return string;
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        return this.getSQLType(column);
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.getPGType(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[columnIndex - 1];
    }

    protected String getPGType(int columnIndex) throws SQLException {
        return this.connection.getPGType(this.getField(columnIndex).getOID());
    }

    protected int getSQLType(int columnIndex) throws SQLException {
        return this.connection.getSQLType(this.getField(columnIndex).getOID());
    }

    public String getColumnClassName(int column) throws SQLException {
        Field field = this.getField(column);
        String result = this.connection.getJavaClass(field.getOID());
        if (result != null) {
            return result;
        }
        int sqlType = this.getSQLType(column);
        switch (sqlType) {
            case 2003: {
                return "java.sql.Array";
            }
        }
        String type = this.getPGType(column);
        if ("unknown".equals(type)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }
}

