<?php
$title="Chit-Groups";
require_once "calpp_config.inc";
require_once "$CLP_BASE/authentication.inc";
require_once "$CLP_BASE/validate.inc";
require_once "$CLP_BASE/form_elements.inc";
require_once "$CLP_BASE/design.inc";

$work_links = work_area_links();
echo $work_links;



echo "<b>Create New <a href=Chit-Groups.php?action=InsertChitGroupType>Chit Group Type</a>|<a href=Proceedings.php?action=invoke_step&proc_new=true&first_step_code=00Resolution&first_step=1&proc_code=ConductChitGroup>Chit Group</a></b>";
require_once "$CLP_BASE/index.inc";
if (!isset($action)){
    // show all existing chit group types
    echo "<h1>List of Chit Group Types</h1>";
    $sql = "select chitgrouptype_id as id, chitgroup_prefix as prefix, subscribers, ' x ' as _, subscription, ' = ' as _, chit_amount from chitgrouptypes order by chit_amount, subscribers";
    Show_Sql($sql);
}
if ($action=='InsertChitGroupType'){
    // show form to create new chit group type
    echo "<h1>Create New Chit Group Type</h1>";
    echo "<form><table>
    <tr><td>Number of Subscribers:<td><input type=text name=subscribers size=20 maxlength=20>
    <tr><td>Monthly Subscription:<td><input type=text name=subscription size=20 maxlength=20>
    <tr><td>Chit Group Prefix:<td><input type=text name=chitgroup_prefix size=20 maxlength=20>
    <tr><td>Default Foreman Commission:<td><input type=text name=default_foreman_commission size=5 maxlength=5 value=5>%
    <tr><td>Default Foreman Instalment:<td><input type=text name=default_foreman_instalment size=5 maxlength=5 value=1>
    <tr><td>Default simple interest payable by<br> defaulting prized subscribers:<td><input type=text name=default_si_prized size=5 maxlength=5 value=12>%
    <tr><td>Default simple interest payable by<br> defaulting non-prized subscribers:<td><input type=text name=default_si_non_prized size=5 maxlength=5 value=12>%
    <tr><td><td><input type=reset name=reset value=Reset><input type=submit name=action value=SaveChitGroupType>
    </table></form>";
}

if ($action=='SaveChitGroupType'){
    // save chit group type
    // do validation
    $blank = 0;
    $result = is_pln($subscribers);
    if (($result==0) || ($subscribers <= 0)){
         $blank = 1;
	 $why[]="Invalid value for Subscribers: $subscribers";
    }
    $result = is_pcr($subscription);
    if (($result==0) || ($subscription==0)){
         $blank = 1;
	 $why[]="Invalid value for Subscription: $subscription";
    }
    $result = is_pft($default_foreman_commission);
    if ($result==0){
         $blank = 1;
	 $why[]="Invalid value for Default Foreman Commission: $default_foreman_commission";
    }
    $result = is_pft($default_foreman_instalment);
    if ($result==0){
	 $blank = 1;
         $why[]="Invalid value for Default Foreman Instalment: $default_foreman_instalment";
    }
    if ($default_foreman_instalment > $subscribers){
	 $blank = 1;
         $why[]="Default Foreman Instalment cannot be greater than the total number of instalments.";
    }
    $result = is_pft($default_si_prized);
    if (($result==0) || ($default_si_prized > 12)){
         $blank = 1;
	 $why[]="Invalid value for default simple interest payable by defaulting prized subscribers. Please note that the interest payable cannot exceed 12%.";
    }   
    $result = is_pft($default_si_non_prized);
    if (($result==0) || ($default_si_non_prized > 12)){
         $blank = 1;
	 $why[]="Invalid value for default simple interest payable by defaulting non- prized subscribers. Please note that the interest payable cannot exceed 12%.";
    }
    if ($blank==1){
         $blank = 1;
         $why[]=give_reasons();
         echo "<h1>Failed to create new chit group type for the following reasons:</h1>";
	 while (list($key, $value)=each($why)){
	      echo "<p>$value</p>";
	 }
    } else {
         $chit_amount = $subscribers * $subscription;
         $instalments = $subscribers;
         $sql = "insert into chitgrouptypes (subscribers, subscription, chit_amount, chitgroup_prefix, instalments, default_foreman_contact_id, default_foreman_commission, default_foreman_instalment, default_si_prized, default_si_non_prized, default_penalty_prized, default_penalty_non_prized) values ($subscribers, $subscription, $chit_amount, '$chitgroup_prefix', $instalments, 1, $default_foreman_commission, $default_foreman_instalment, $default_si_prized, $default_si_non_prized, 0, 0)";
	 $result = Exec_Sql($sql);
         if ($result > 0){
	      echo "<h1>New Chit Group Type successfully created.</h1>";
	 } else {
	      echo "<h1>Failed to create new chit group type.</h1>";
         }
    }
}



?>




