#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from common import *
from dtdgraph import *
import getopt
import sys

def main():
	"""
	dtd2pgml output a pgml file

	usage: dtd2pgml -f <dtd file> -o <pgml file> [-h] 
	-h : this help
	-f : dtd file
	-o : pgml file
	"""
	
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'o:f:hd')
	except getopt.error, msg:
		usage(msg)

	dtdFilename=''
	pgmlFilename=''
	debug = PYTHONDEBUG
	
	for o, a in opts:
		if o == '-f': dtdFilename = a
		if o == '-o': pgmlFilename = a
		if o == '-h': usage(main.__doc__)
		if o == '-d': debug = 1

	if not dtdFilename: usage(main.__doc__,'error : missing dtd file')

	g = DtdGraph('DtdGraph',debug)
	g.read(dtdFilename)

	output = stdout
	if pgmlFilename:
		output = open(pgmlFilename,'w')
	g.write_pgml(output)

if __name__ == '__main__':
	main()
