#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from common import *
from pgmlgraph import *
import getopt
import sys

def main():
	"""
	simplify-pgml : output simplified pgml schema (no relations of degre > 2 )

	usage: simplify-pgml -f <pgml schema file> [-h] 
	-h : this help
	-o : pgml output
	-f : pgml file
	-i : id sequence
	-u : use postgreSql isa keyword when table inherits
	-r : ref default (like '0')

	"""
	
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'o:f:hdi:cur:')
	except getopt.error, msg:
		usage(msg)

	pgmlFilename=''
	outputFilename=''
	idSequence = None
	debug = PYTHONDEBUG
	usePostgreSqlIsa = None
	usePostgreSqlConstraints = None
	refDefault = None

	for o, a in opts:
		if o == '-f': pgmlFilename = a
		if o == '-h': usage(main.__doc__)
		if o == '-o': outputFilename = a
		if o == '-i': idSequence = a
		if o == '-d': debug = 1
		if o == '-u': usePostgreSqlIsa = 1
		if o == '-c': usePostgreSqlConstraints = 1
		if o == '-r': refDefault = a

	if not pgmlFilename: usage(main.__doc__,'error : missing database pgml file')

	g = PgmlGraph('PgmlGraph',debug,idSequence,usePostgreSqlIsa,usePostgreSqlConstraints,refDefault);
	g.read(pgmlFilename);
	g.simplify()
	
	output = stdout
	if outputFilename:
		output = open(outputFilename,'w')
	g.write_pgml(output)

if __name__ == '__main__':
	main()
