#! /bin/bash

case $DEBUG in
  1) set -x
     ;;
  *)
     ;;
esac

error() { # juste pour usage
    echo $1 1>&2
}

usage() {
    error "usage : exec-sql.sh [-h] -H <host> -d <dbname> -u <user> -p <password> [ -f <sql file> || -c <sql command> ] -F<separator> -o <output> -l <log file>"
    error "example : exec-sql.sh -H bonnie -d barbie -u pimentech -p \"\" -f schema.sql -F'|' -header -o output.lst -l exec-sql.log"
}

separator='|'
csql=0
header="-t"
output=""

TMPDIR=/tmp/`whoami`
mkdir -p ${TMPDIR}
if [ $? -ne 0 ]
then
	error "cannot mkdir -p ${TMPDIR}"
	exit 1
fi

while true
do
    case $1 in
	-o) output="-o $2"
	    shift 2
	;;
	-F) separator="$2"
	    shift 2
	;;
	-f) file="$2"
	    shift 2
	;;
	-c) file="${TMPDIR}/csql_$$.sql"
	    echo "$2" > $file
	    csql=1
	    shift 2
	;;
	-H) host="$2"
	    shift 2
	;;
	-u)	user="$2"
	    shift 2
        ;;
	-p) password="$2"
	    shift 2
        ;;
	-d) dbname="$2"
	    shift 2
	;;
	-l) logfile="$2"
	    shift 2
	;;
	-header) header=""
	    shift 1
	;;
	-h) usage
	    exit 0
	;;
	*)
	    break
	;;
  esac
done

if [ -z "$dbname" -o -z "$host" -o -z "$user" -o -z "$logfile" -o -z "$file" ] 
then
    usage
    exit 1
fi

date=`date '+%d-%m-%Y'`
error() {
    echo "ERROR:exec-sql.sh:$date: $1" 1>&2
    echo "ERROR:exec-sql.sh:$date: $1" >> $logfile
}

PGVERSION=`psql -V  | grep psql | awk '{ print $3 }' | awk -F'.' '{ print $1$2 }'`

expect -- <<EOC
	
#	exp_internal -f $logfile 0

 	log_user 0

	spawn -noecho psql -W -h $host -f $file $dbname -U $user $header -A -F "$separator" -P pager $output

	set timeout -1

	expect {
		"Password: " { 
			send -- "$password\r" 
			expect {
				"\r\n" { }
				eof { send_error -- "no cr/lf after login\n" }
			}
			if { $PGVERSION < 71 } {
				expect {
					"\r\n" { }
					eof { send_error -- "no cr/lf after login\n" }
				}
			}
			exp_continue
		}
		-re "(You are now connected.*)\r\n" { 
			send_error -- "\$expect_out(1,string)\n"
			exp_continue
		}
		-re "(psql:.*)\r\n" {
			send_error -- "\$expect_out(1,string)\n"
			exp_continue
		}
		-re "(.*)\r\n" {
			send_user -- "\$expect_out(1,string)\n"
			exp_continue
		}
		-re "(.+)" { 
			send_user -- "\$expect_out(1,string)" 
			exp_continue
		}
	}

    exit [ lindex [ wait ] 3 ]

EOC

err=$?

if [ $err -ne 0 ]
then
	if [ $csql -eq 0 ]
	then
		error "cannot exec $file in $dbname@$host"
	else
		error "cannot exec `cat $file` in $dbname@$host"
	fi
fi

if [ $csql -ne 0 ]
then
    rm -f $file
fi

exit $err
