<?php

//this gets rid of a hidden session form field which we dont want
ini_set("session.use_trans_sid","0");

//set to use short tags
ini_set("short_open_tag","1");

//register globals to on for DocMGR
ini_set("register_globals","1");

//set our max execution time
ini_set("max_execution_time",EXECUTION_TIME);

//first call the config file to get our settings, call our base functions, and get our wrapper
include("include/config.inc.php");
include("include/postgresql.inc.php");
include("include/function.inc.php");
include("include/bitset.inc.php");

//connect
$conn = db_connect(DBHOST,DBUSER,DBPASSWORD,DBPORT,DBNAME);

//get our central auth settings if desired
if (AUTHHOST) $auth_conn = db_connect(AUTHHOST,AUTHUSER,AUTHPASSWORD,AUTHPORT,AUTHNAME);
else $auth_conn = $conn;

$browser = browser_check($HTTP_USER_AGENT);

//get the users browser type
define("BROWSER","$browser");

$permError = null;
$checkValue = null;

//do we authorize people in this site
if (AUTHORIZE == "yes" || $siteModSettings["modAuth"][$key] || $_GET["logout"] || $_POST["login"] || $_SESSION["authorize"]) {

	include("auth/auth.inc.php");

	//show the first login page if we are authorizing on every page
	if (defined("AUTHORIZE") && !$_SESSION["authorize"] && !$incorrect_login && !$show_login_menu) $show_login_menu = 1;

}

//Get our site layout if we have not already.
if (!$siteModSettings) {
	$siteModSettings = getSiteSettings($conn);
	$_SESSION["siteModSettings"] = $siteModSettings;
}


