/*
	dbagent.h

	The DbAgent class implements functionality specific to a database agent.

	Project: pgjobs
	Author: Zlatko Michailov
	Created: 13-Oct-2003
	Updated:  5-May-2004
	Updated: 26-May-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003-2004, Zlatko Michailov

*/



#ifndef __DBAGENT_H__
#define __DBAGENT_H__



//--------------------------------------------------------------------------------

#include "../../../msdk/include/msdk.h"
#include "agent.h"
#include "config.h"
#include "sql.h"


using namespace msdk;



//--------------------------------------------------------------------------------
// Class DbAgent

class DbAgent : public Agent, public Thread
{
// Data members
protected:
	DbInfo	DbConfig;
	string	PsqlOptions;


// Construction
public:
	DbAgent( const DbInfo& dbinfo );


// Overridables
protected:
	void Startup();
	void Shutdown();
	void Run();


// Support
protected:
	void ComputePsqlOptions();
	void InitSession( SQL& sql );
	int  ComputeSleepSeconds( SQL& sql );
	void ExecuteStartupJobs( SQL& sql );
	void ExecuteJobs( SQL& sql );
};



#endif	// __DBAGENT_H__


