/*
------------------------------------------------
-- Internal table for storing temporary trigger
-- information. Should not be used directly.
------------------------------------------------
create table pgj_trigger_
(
	schid			integer		not null references pgj_schedule_ ( schid ),
	schtriggertime	timestamp	null,
	isup			boolean		null
);
*/



/*
------------------------------------------------
-- Internal table for storing system/session
-- Settings. Should not be used directly.
------------------------------------------------
create table pgj_settings_
(
	startuptime		timestamp	null
);
*/

truncate table pgj_settings_;

insert into pgj_settings_( startuptime )
values( date_trunc( 'minute', current_timestamp() ) );



------------------------------------------------
-- Recomputes the trigger times for all schedules.
-- The output is stored in table pgj_trigger_.
------------------------------------------------
create or replace function pgj_recompute_schedules()
returns boolean
as '
	declare
		startupTime		timestamp;
		currentTime		timestamp;
		temp			text;

	begin
		select into	startupTime S.startuptime
		from		pgj_settings_ S;

		currentTime := date_trunc( ''minute'', current_timestamp() );

		temp := ''
			truncate table pgj_trigger_;

			insert into	pgj_trigger_( schid, schtriggertime )
			select		schid, pgj_schedule_trigger_time( '' || quote_literal( startupTime ) || '',
														  '' || quote_literal( currentTime ) || '',
														  schtype,
														  schyear,
														  schmonth,
														  schday,
														  schhour,
														  schminute )
			from		pgj_schedule_;

			update	pgj_trigger_
			set		isup = ( schtriggertime = '' || quote_literal( currentTime ) || '' );
			
			update	pgj_job_
			set		jobisstartschup = TRUE
			from	pgj_job_ J
					join pgj_trigger_ T
						on J.jobstartschid = T.schid
			where	T.isup;
			'';
		execute temp;

		return TRUE;
	end;
' language 'plpgsql';



------------------------------------------------
-- Returns the next trigger time.
------------------------------------------------
create or replace function pgj_trigger_time()
returns timestamp
as '
	declare
		triggerTime		timestamp;
		currentTime		timestamp;

	begin
		currentTime := date_trunc( ''minute'', current_timestamp() );

		select into	triggerTime min( schtriggertime )
		from		pgj_trigger_
		where		schtriggertime >= currentTime;

		if triggerTime = currentTime then
			triggerTime = currentTime + interval ''1 minute'';
		end if;

		return triggerTime;
	end;
' language 'plpgsql';





