SET autocommit TO 'on';

CREATE OR REPLACE FUNCTION uuid_in(cstring)
RETURNS uuid
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_out(uuid)
RETURNS cstring
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE TYPE uuid (
	INTERNALLENGTH = 16,
	INPUT = uuid_in,
	OUTPUT = uuid_out
);

COMMENT ON TYPE uuid
  is 'UUID type for PostgreSQL';

--
--	The various boolean tests:
--

CREATE OR REPLACE FUNCTION uuid_gt(uuid, uuid)
RETURNS bool
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_lt(uuid, uuid)
RETURNS bool
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_eq(uuid, uuid)
RETURNS bool
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_ge(uuid, uuid)
RETURNS bool
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_le(uuid, uuid)
RETURNS bool
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_ne(uuid, uuid)
RETURNS bool
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

--
--	Now the operators.  Note how some of the parameters to some
--	of the 'create operator' commands are commented out.  This
--	is because they reference as yet undefined operators, and
--	will be implicitly defined when those are, further down.
--

CREATE OPERATOR < (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = >,
	PROCEDURE = uuid_lt
);

CREATE OPERATOR <= (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = >=,
	PROCEDURE = uuid_le
);

CREATE OPERATOR = (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	COMMUTATOR = =,
	NEGATOR = <>,
	PROCEDURE = uuid_eq
);

CREATE OPERATOR >= (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = <=,
	PROCEDURE = uuid_ge
);

CREATE OPERATOR > (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = <=,
	PROCEDURE = uuid_gt
);

CREATE OPERATOR <> (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	COMMUTATOR = <>,
	NEGATOR = =,
	PROCEDURE = uuid_ne
);

-- Register 'uuid' create function
CREATE OR REPLACE FUNCTION newid_time()
RETURNS uuid
VOLATILE
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION newid_random()
RETURNS uuid
VOLATILE
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION newid_name(uuid, cstring)
RETURNS uuid
IMMUTABLE
STRICT
AS '$libdir/pguuid', 'newid_name'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION newid_name2(cstring, cstring)
RETURNS uuid
IMMUTABLE
STRICT
AS '$libdir/pguuid', 'newid_name2'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION newid_nil()
RETURNS uuid
IMMUTABLE
STRICT
AS '$libdir/pguuid'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION newid() --default is create a time base uuid
RETURNS uuid
VOLATILE
STRICT
AS '$libdir/pguuid', 'newid_time'
LANGUAGE 'C';

-- Register 'uuid' comparison util function
CREATE OR REPLACE FUNCTION uuid_cmp(uuid, uuid)
RETURNS int2
STRICT
AS '$libdir/pguuid', 'util_uuid_cmp'
LANGUAGE 'C';

-------------------------------------------------
-- Create default operator class for 'uuid'    --
-- Needed to create index or primary key       --
-------------------------------------------------

CREATE OPERATOR CLASS uuid_ops
DEFAULT FOR TYPE uuid USING btree 
AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       uuid_cmp(uuid, uuid);

-- Register util function
CREATE OR REPLACE FUNCTION uuid_type(uuid)
RETURNS int2
STRICT
AS '$libdir/pguuid', 'util_uuid_type'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_variant(uuid)
RETURNS int2
STRICT
AS '$libdir/pguuid', 'util_uuid_variant'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_timestamp(uuid)
RETURNS timestamp
STRICT
AS '$libdir/pguuid', 'util_uuid_timestamp'
LANGUAGE 'C';

CREATE OR REPLACE FUNCTION uuid_macaddr(uuid)
RETURNS macaddr
STRICT
AS '$libdir/pguuid', 'util_uuid_macaddr'
LANGUAGE 'C';

-- Create cast
CREATE CAST (uuid AS timestamp)
WITH FUNCTION uuid_timestamp(uuid)
AS IMPLICIT;

CREATE CAST (uuid AS macaddr)
WITH FUNCTION uuid_macaddr(uuid)
AS IMPLICIT;
--
--	eof
--
