<?php // $Id: graph-weekly.php,v 1.11 2001/07/09 16:43:05 ciaccia Exp $ - #phpAdsNew Revision: 1.5 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by Martin Braun <martin@braun.cc>                 */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/



// Include required files
require ("config.php");
require ("stats-weekly.inc.php");



/*********************************************************/
/* Prepare data for graph                                */
/*********************************************************/

$where=urldecode($where); 

// Get week signs for PostgreSQL queries
list($php_week_sign) = GetWeekSigns();

//my_sql_select_db($GLOBALS["phpAds_db"]);

if (isset ($GLOBALS['phpAds_CharSet']) && $GLOBALS['phpAds_CharSet'] != '')
	$text=array(
	    'value1' => 'AdViews',
	    'value2' => 'AdClicks');
else
	$text=array(
	    'value1' => $GLOBALS['strViews'],
	    'value2' => $GLOBALS['strClicks']);


if ($phpAds_compact_stats) {
    // Get totals from compact stats
    $query="
    	SELECT 
    		sum(views), 
    		sum(clicks),
    		phpads_yyyy($phpAds_begin_of_week, day) || phpads_ww($phpAds_begin_of_week, day) AS week 
    	FROM
    		".$GLOBALS['phpAds_tbl_adstats']."
    	$where
    	GROUP BY 
    		week
    	ORDER BY 
    		week DESC
    	LIMIT ".$max_weeks;
    
    $result = db_query($query) or pg_die();
    
    $items = array();
    $num2 = pg_numrows($result);
    
    for ($i=0; $row = @pg_fetch_row($result, $i); $i++)   
    {
    	$items[$i]=array();
    	$items[$i]['value1'] = $row[0];     // views
    	$items[$i]['value2'] = $row[1];     // clicks
    	$items[$i]['text'] = ereg_replace("^([0-9]{4})([0-9]{2})$", "\\2/\\1", $row[2]);       // week sign
    }
}
else
{
    $query="
    	SELECT 
    		count(*), 
    		phpads_yyyy($phpAds_begin_of_week, t_stamp) || phpads_ww($phpAds_begin_of_week, t_stamp) AS week 
    	FROM
    		".$GLOBALS['phpAds_tbl_adviews']."
    	$where
    	GROUP BY 
    		week
    	ORDER BY 
    		week DESC
    	LIMIT ".$max_weeks;
    
    $query2="
    	SELECT 
    		count(*),
    		phpads_yyyy($phpAds_begin_of_week, t_stamp) || phpads_ww($phpAds_begin_of_week, t_stamp) AS week 
    	FROM
    		".$GLOBALS['phpAds_tbl_adclicks']."
    	$where
    	GROUP BY 
    		week
    	ORDER BY 
    		week DESC
    	LIMIT ".$max_weeks;
                
    $result = db_query($query) or pg_die();
    $result2 = db_query($query2) or pg_die();
    
    $items = array();
    $num2 = pg_numrows($result2);
    $row2 = @pg_fetch_row($result2, $ii = 0);
    
    for ($i=0; $row = @pg_fetch_row($result, $i); $i++)   
    {
    	$items[$i]=array();
    	$items[$i]['value1'] = $row[0];
    	$items[$i]['text'] = ereg_replace("^([0-9]{4})([0-9]{2})$", "\\2/\\1", $row[1]);
    	if ($row[1]==$row2[1])
    	{
    		$items[$i]['value2'] = $row2[0];
    		if ( $ii < $num2 - 1 )
    			$row2 = pg_fetch_row($result2, ++$ii);
    	}
    	else
    		$items[$i]['value2'] = 0;
    }
}

// Build the graph
include('lib-graph.inc.php');

?>
 
