/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.EOXactListener;
import org.postgresql.pljava.internal.TransactionEvent;
import org.postgresql.pljava.internal.TransactionListener;
import org.postgresql.pljava.internal.TransactionalMap;

public class Session
implements EOXactListener,
org.postgresql.pljava.Session {
    private final ArrayList m_xactListeners;
    private final TransactionalMap m_attributes;

    private /* synthetic */ void finit$() {
        this.m_xactListeners = new ArrayList();
        this.m_attributes = new TransactionalMap((Map)new HashMap());
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        if (!this.m_xactListeners.contains(transactionListener)) {
            this.m_xactListeners.add(transactionListener);
        }
    }

    public Object getAttribute(String string) {
        return this.m_attributes.get(string);
    }

    public TransactionListener[] getTransactionListeners() {
        return this.m_xactListeners.toArray(new TransactionListener[this.m_xactListeners.size()]);
    }

    public String getUserName() {
        return AclId.getUser().getName();
    }

    public String getSessionUserName() {
        return AclId.getSessionUser().getName();
    }

    public void onEOXact(boolean bl) {
        if (bl) {
            this.m_attributes.commit();
        } else {
            this.m_attributes.abort();
        }
        int n = this.m_xactListeners.size();
        if (n == 0) {
            return;
        }
        TransactionEvent transactionEvent = new TransactionEvent(this);
        TransactionListener[] transactionListenerArray = this.getTransactionListeners();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                transactionListenerArray[i].afterCommit(transactionEvent);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                transactionListenerArray[i].afterAbort(transactionEvent);
            }
        }
    }

    public void removeAttribute(String string) {
        this.m_attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.m_attributes.put(string, object);
    }

    public void removeTransactionListener(TransactionListener transactionListener) {
        ((AbstractCollection)this.m_xactListeners).remove(transactionListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeAsSessionUser(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                boolean bl;
                AclId aclId2 = AclId.getSessionUser();
                AclId aclId = AclId.getUser();
                if (aclId2.equals(aclId)) {
                    return statement.execute(string);
                }
                try {
                    Session._setUser(aclId2);
                    bl = statement.execute(string);
                    Object var8_10 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    Session._setUser(aclId);
                    throw throwable;
                }
                Session._setUser(aclId);
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                throw throwable;
            }
        }
    }

    private static native void _setUser(AclId var0);

    public Session() {
        this.finit$();
    }
}

