/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIParameterMetaData
implements ParameterMetaData {
    private final int[] m_sqlTypes;

    SPIParameterMetaData(int[] nArray) {
        this.m_sqlTypes = nArray;
    }

    public int getParameterCount() throws SQLException {
        if (this.m_sqlTypes == null) {
            return 0;
        }
        return this.m_sqlTypes.length;
    }

    public int isNullable(int n) throws SQLException {
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    public int getPrecision(int n) throws SQLException {
        return 0;
    }

    public int getScale(int n) throws SQLException {
        return 0;
    }

    public int getParameterType(int n) throws SQLException {
        if (n < 1 || n > this.getParameterCount()) {
            throw new SQLException("Parameter index out of range");
        }
        return this.m_sqlTypes[n - 1];
    }

    public String getParameterTypeName(int n) throws SQLException {
        throw new UnsupportedFeatureException("Parameter type name support not yet implemented");
    }

    public String getParameterClassName(int n) throws SQLException {
        throw new UnsupportedFeatureException("Parameter class name support not yet implemented");
    }

    public int getParameterMode(int n) throws SQLException {
        if (n < 1 || n > this.getParameterCount()) {
            throw new SQLException("Parameter index out of range");
        }
        return 1;
    }
}

