/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Portal;

public class ExecutionPlan {
    static final int INITIAL_CACHE_CAPACITY = 29;
    static final float CACHE_LOAD_FACTOR = 0.75f;
    private long m_pointer;
    private static final Map s_planCache;
    private final Object m_key;

    private ExecutionPlan(Object object, long l) {
        this.m_key = object;
        this.m_pointer = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ExecutionPlan executionPlan = s_planCache.put(this.m_key, this);
        if (executionPlan != null && executionPlan.m_pointer != 0L) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                ExecutionPlan._invalidate(executionPlan.m_pointer);
                executionPlan.m_pointer = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Portal cursorOpen(String string, Object[] objectArray) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._cursorOpen(this.m_pointer, System.identityHashCode(Thread.currentThread()), string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCursorPlan() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._isCursorPlan(this.m_pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] objectArray, int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._execute(this.m_pointer, System.identityHashCode(Thread.currentThread()), objectArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionPlan prepare(String string, Oid[] oidArray) throws SQLException {
        Object object = oidArray == null ? string : new PlanKey(string, oidArray);
        ExecutionPlan executionPlan = (ExecutionPlan)s_planCache.remove(object);
        if (executionPlan == null) {
            Object object2 = Backend.THREADLOCK;
            synchronized (object2) {
                executionPlan = new ExecutionPlan(object, ExecutionPlan._prepare(string, oidArray));
            }
        }
        return executionPlan;
    }

    private static native Portal _cursorOpen(long var0, long var2, String var4, Object[] var5) throws SQLException;

    private static native boolean _isCursorPlan(long var0) throws SQLException;

    private static native int _execute(long var0, long var2, Object[] var4, int var5) throws SQLException;

    private static native long _prepare(String var0, Oid[] var1) throws SQLException;

    private static native void _invalidate(long var0);

    static {
        int n = Backend.getStatementCacheSize();
        s_planCache = Collections.synchronizedMap(new PlanCache(n < 11 ? 11 : n));
    }

    static final class PlanKey {
        private final int m_hashCode;
        private final String m_stmt;
        private final Oid[] m_argTypes;

        PlanKey(String string, Oid[] oidArray) {
            this.m_stmt = string;
            this.m_hashCode = string.hashCode() + 1;
            this.m_argTypes = oidArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PlanKey)) {
                return false;
            }
            PlanKey planKey = (PlanKey)object;
            if (!planKey.m_stmt.equals(this.m_stmt)) {
                return false;
            }
            Oid[] oidArray = this.m_argTypes;
            Oid[] oidArray2 = planKey.m_argTypes;
            int n = oidArray2.length;
            if (oidArray.length != n) {
                return false;
            }
            while (--n >= 0) {
                if (oidArray2[n].equals(oidArray[n])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }

    static final class PlanCache
    extends LinkedHashMap {
        private final int m_cacheSize;

        public PlanCache(int n) {
            super(29, 0.75f, true);
            this.m_cacheSize = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() <= this.m_cacheSize) {
                return false;
            }
            ExecutionPlan executionPlan = (ExecutionPlan)entry.getValue();
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                if (executionPlan.m_pointer != 0L) {
                    ExecutionPlan._invalidate(executionPlan.m_pointer);
                    executionPlan.m_pointer = 0L;
                }
            }
            return true;
        }
    }
}

