/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.postgresql.pljava.Server;
import org.postgresql.pljava.TriggerData;
import org.postgresql.pljava.TriggerException;

public class Triggers {
    static void insertUsername(TriggerData triggerData) throws SQLException {
        if (triggerData.isFiredForStatement()) {
            throw new TriggerException(triggerData, "can't process STATEMENT events");
        }
        if (triggerData.isFiredAfter()) {
            throw new TriggerException(triggerData, "must be fired before event");
        }
        if (triggerData.isFiredByDelete()) {
            throw new TriggerException(triggerData, "can't process DELETE events");
        }
        ResultSet resultSet = triggerData.getNew();
        String[] stringArray = triggerData.getArguments();
        if (stringArray.length != 1) {
            throw new TriggerException(triggerData, "one argument was expected");
        }
        if (resultSet.getString(stringArray[0]) == null) {
            resultSet.updateString(stringArray[0], Server.getUserName());
        }
    }

    static void moddatetime(TriggerData triggerData) throws SQLException {
        if (triggerData.isFiredForStatement()) {
            throw new TriggerException(triggerData, "can't process STATEMENT events");
        }
        if (triggerData.isFiredAfter()) {
            throw new TriggerException(triggerData, "must be fired before event");
        }
        if (!triggerData.isFiredByUpdate()) {
            throw new TriggerException(triggerData, "can only process UPDATE events");
        }
        ResultSet resultSet = triggerData.getNew();
        String[] stringArray = triggerData.getArguments();
        if (stringArray.length != 1) {
            throw new TriggerException(triggerData, "one argument was expected");
        }
        resultSet.updateTimestamp(stringArray[0], new Timestamp(System.currentTimeMillis()));
    }
}

