/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.BaseSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectorContainer;
import org.apache.tools.ant.types.selectors.SizeSelector;

public abstract class BaseSelectorContainer
extends BaseSelector
implements SelectorContainer {
    private Vector selectorsList = new Vector();

    public boolean hasSelectors() {
        return !this.selectorsList.isEmpty();
    }

    public int selectorCount() {
        return this.selectorsList.size();
    }

    public FileSelector[] getSelectors(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getSelectors(p);
        }
        Object[] result = new FileSelector[this.selectorsList.size()];
        this.selectorsList.copyInto(result);
        return result;
    }

    public Enumeration selectorElements() {
        return this.selectorsList.elements();
    }

    private SelectorContainer getRef(Project p) {
        Object o;
        if (!this.checked) {
            Stack<BaseSelectorContainer> stk = new Stack<BaseSelectorContainer>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        if (!((o = this.ref.getReferencedObject(p)) instanceof SelectorContainer)) {
            throw new BuildException(this.ref.getRefId() + " doesn't denote a selector type");
        }
        return (SelectorContainer)o;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.selectorElements();
        if (e.hasMoreElements()) {
            while (e.hasMoreElements()) {
                buf.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public void appendSelector(FileSelector selector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.selectorsList.addElement(selector);
    }

    public void validate() {
        this.verifySettings();
        String errmsg = this.getError();
        if (errmsg != null) {
            throw new BuildException(errmsg);
        }
        Enumeration e = this.selectorElements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof BaseSelector)) continue;
            ((BaseSelector)o).validate();
        }
    }

    public abstract boolean isSelected(File var1, String var2, File var3);

    public void addAnd(AndSelector selector) {
        this.appendSelector(selector);
    }

    public void addOr(OrSelector selector) {
        this.appendSelector(selector);
    }

    public void addNot(NotSelector selector) {
        this.appendSelector(selector);
    }

    public void addNone(NoneSelector selector) {
        this.appendSelector(selector);
    }

    public void addMajority(MajoritySelector selector) {
        this.appendSelector(selector);
    }

    public void addDateselect(DateSelector selector) {
        this.appendSelector(selector);
    }

    public void addSizeselect(SizeSelector selector) {
        this.appendSelector(selector);
    }

    public void addFilenameselect(FilenameSelector selector) {
        this.appendSelector(selector);
    }

    public void addExtendSelect(ExtendSelector selector) {
        this.appendSelector(selector);
    }

    public void addContainsSelect(ContainsSelector selector) {
        this.appendSelector(selector);
    }

    public void addPresentSelect(PresentSelector selector) {
        this.appendSelector(selector);
    }

    public void addDepthSelect(DepthSelector selector) {
        this.appendSelector(selector);
    }

    public void addDependSelect(DependSelector selector) {
        this.appendSelector(selector);
    }
}

