/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS UpdateTable v 0.1                                                   
* Descripcion:
* Esta clase se encarga de manejar el dialogo mediante el cual
* es posible actualizar uno o varios registros en una tabla.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;

public class UpdateTable extends JDialog implements ActionListener{

 JTextField area;
 Table mytable;
 Hashtable hashText = new Hashtable();
 String[] fieldName;
 boolean[] active;
 int itemsA = 0;
 int numFields;
 String SQLupdate = "";
 String Where = "";
 String update = "";
 boolean noW = true;
 boolean wellDone = false;
 JFrame myframe;
 Language idiom;

 public UpdateTable(Table table,JFrame frame,Language leng) {
  super(frame, true);
  idiom = leng;
  setTitle(idiom.getWord("UPDT"));
  mytable = table;
  myframe = frame;
  JPanel global = new JPanel();
  global.setLayout(new BoxLayout(global,BoxLayout.Y_AXIS));

  JPanel base = new JPanel();
  base.setLayout(new GridLayout(0,1));
  JPanel data = new JPanel();
  data.setLayout(new GridLayout(0,1));

  numFields = mytable.base.NumFields;
  active = new boolean[numFields];
  Hashtable hashFields = mytable.base.hashFields;
  Vector fields = mytable.base.fields;
  fieldName = new String[numFields];
  int i=0;
 
  for (; i<numFields ;i++) 
  {
   active[i] = false;
   String nfield = (String) fields.elementAt(i);
   area = new JTextField(10);
   area.setEditable(false);
   area.setEnabled(false);
   JCheckBox check = new JCheckBox(nfield + " [" + mytable.base.getType(nfield) + "] = ");
   String label = "check-" + i;
   check.setActionCommand(label);
   check.addActionListener(this);
   fieldName[i] = nfield;
   base.add(check);
   hashText.put(label,area);
   data.add(area);
  }

 JLabel title = new JLabel("UPDATE " + mytable.Name,JLabel.CENTER);
 JPanel first = new JPanel();
 first.setLayout(new FlowLayout(FlowLayout.CENTER));
 first.add(title);

 Border etched1 = BorderFactory.createEtchedBorder();
 TitledBorder title1 = BorderFactory.createTitledBorder(etched1);
 first.setBorder(title1);

 JButton where = new JButton("WHERE");
 where.setActionCommand("ButtonW");
 where.addActionListener(this);

 JPanel center = new JPanel();
 center.setLayout(new BorderLayout());
 center.add(base,BorderLayout.WEST);
 center.add(data,BorderLayout.CENTER);

 JPanel up = new JPanel();
 up.setLayout(new FlowLayout(FlowLayout.CENTER));
 up.add(center);
 up.add(where);

 title1 = BorderFactory.createTitledBorder(etched1,"SET");
 up.setBorder(title1);

 JButton ok = new JButton(idiom.getWord("UPDT"));
 ok.setActionCommand("ButtonOk");
 ok.addActionListener(this);
 JButton clear = new JButton(idiom.getWord("CLR"));
 clear.setActionCommand("ButtonClear");
 clear.addActionListener(this);
 JButton cancel = new JButton(idiom.getWord("CANCEL"));
 cancel.setActionCommand("ButtonCancel");
 cancel.addActionListener(this);

 JPanel botons = new JPanel();
 botons.setLayout(new FlowLayout(FlowLayout.CENTER));
 botons.add(ok);
 botons.add(clear);
 botons.add(cancel); 

 global.add(first);

 if(numFields > 15)
  {
   JScrollPane scroll = new JScrollPane(up);
   scroll.setPreferredSize(new Dimension(400,400));
   global.add(scroll);
  }
 else
   global.add(up);

 global.add(botons);

 getContentPane().add(global);
 pack();
 setLocationRelativeTo(frame);
 setVisible(true);

}

 public void actionPerformed(java.awt.event.ActionEvent e) {

 if(e.getActionCommand().equals("ButtonOk"))
   {
    update = "UPDATE " + mytable.Name + " SET ";
    String values = "";
    int t=0;
    if(itemsA == 0) 
      {
       JOptionPane.showMessageDialog(UpdateTable.this,idiom.getWord("NFSU"),idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
      }
    else { 
    for (int i=0; i<numFields ;i++) 
     {
       if(active[i]) {
           t++;
           String label = "check-" + i;
           JTextField tmp = (JTextField) hashText.get(label);
           String data = tmp.getText();
           data = data.trim();
           if(data.length()!=0) {
             String type = mytable.base.getType(fieldName[i]);
             if(type.startsWith("varchar") && !(data.startsWith("'")))
                data = "'" + data + "'";
             values += fieldName[i] + " = " + data;
             if(t<itemsA)
               values += ", ";            
     } // fin  
           else
            {
             t = -1;
             JOptionPane.showMessageDialog(UpdateTable.this,idiom.getWord("EFIN") + fieldName[i] + "'.",idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
             tmp.requestFocus();
             break;
            } // fin else 
     } // fin for
          } // fin else

     if(t>0)
      {
       boolean ignore = false;
       update += values;
       if(!noW)
          update += " WHERE " + Where;
       else
         {
          String mesg = idiom.getWord("U1") + mytable.Name + idiom.getWord("U2");
          BoolOption askhim = new BoolOption(myframe,idiom.getWord("OK"),idiom.getWord("CANCEL"),idiom.getWord("ADV"),mesg);
          askhim.setLocationRelativeTo(UpdateTable.this);
          askhim.pack();
          askhim.show();
          if(!askhim.getSelecction())
            ignore = true;
          }
       if(!ignore) 
         {
           update += ";";
           wellDone = true;
           setVisible(false);
         }
      } 
     }
   }

 if(e.getActionCommand().equals("ButtonCancel")) 
   {
     setVisible(false);
   }

 if(e.getActionCommand().equals("ButtonClear"))
   {    
    for (Enumeration t = hashText.elements() ; t.hasMoreElements() ;) 
     {
       JTextField tmp = (JTextField) t.nextElement();
       tmp.setText("");
     }
   }

 if(e.getActionCommand().equals("ButtonW"))
   {
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    UpdateWhere win = new UpdateWhere(mytable,UpdateTable.this,idiom);
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

    if(win.where.length() > 0) 
     {
       Where = win.where;
       noW = false; 
     } 
    else
       noW = true;
   }

 if(e.getActionCommand().startsWith("check-"))
   {
    String cad = e.getActionCommand();
    int num = Integer.parseInt(cad.substring(cad.indexOf("-")+1,cad.length()));
    JCheckBox checktmp= (JCheckBox) e.getSource();
    JTextField tmp = (JTextField) hashText.get(cad);
    if(checktmp.isSelected())
     {
       active[num] = true;
       itemsA++;
       tmp.setEnabled(true);
       tmp.setEditable(true);
       tmp.requestFocus();
     }
    else 
     {
       tmp.setEditable(false);
       tmp.setEnabled(false);
       active[num] = false;
       itemsA--;
     } 
   }

 }

} // Fin de la Clase
