/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS ReportHeader v 0.1                                                   
* Descripcion:
* Esta clase se encarga de manejar el dialogo mediante el
* cual se definen las caracteristicas del encabezado de un
* reporte.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*; 
import java.io.File;
import javax.swing.colorchooser.*;

public class ReportHeader extends JDialog implements ActionListener{

 JTextArea HeaderText;
 JComboBox Fstyle;
 String headerD;
 JComboBox Fsize;
 JComboBox types;
 JTextField filePath;
 JTextField eltitulo;
 JCheckBox file;
 JButton Browse;
 JButton Fcolor;
 boolean isWell = false;
 JPanel pColor;
 String fore = "#000000";
 File filex;
 String cab;
 Language idiom;

 public ReportHeader(JDialog diag,JFrame parent, Language lang) 
  {
   super(diag,true);
   idiom = lang;
   setTitle(idiom.getWord("REPHSETT"));
   getContentPane().setLayout(new BorderLayout()); 
   HeaderText = new JTextArea(5,5);
   JScrollPane holdHeader = new JScrollPane(HeaderText);
   JPanel Header = new JPanel();
   Header.setLayout(new BorderLayout());
   Border etched1 = BorderFactory.createEtchedBorder();
   TitledBorder title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("HEADER"));
   JPanel nH = new JPanel();
   nH.setLayout(new GridLayout(1,0));
   JPanel cH = new JPanel();
   cH.setLayout(new BorderLayout());
   title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("HEADERT"));
   cH.setBorder(title1);

   JPanel bloke = new JPanel();
   bloke.setLayout(new BorderLayout());
   eltitulo = new JTextField();
   title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("TITTEXT"));
   bloke.setBorder(title1);
   bloke.add(eltitulo,BorderLayout.CENTER);
 
   JPanel FontPanel = new JPanel();
   FontPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
 
   String[] values = {"Arial","Arial Black","Arial Narrow","Book Antiqua","Bookman Old Style","Calixto MT","Century Gothic","Comic Sans MS","Copperplate Gothic Bold","Copperplate Gothic Light","Courier New","Garamond","Impact","Lucida Console","Lucida Handwriting","Lucida Sans","Lucida Sans Unicode","Map Symbols","Marlett","Matisse ITC","Monotype Sorts","MS Outlook","MT Extra","News Gothic MT","OCR A Extended","Symbol","Tahoma","Tempus Sans ITC","Times New Roman","Verdana","Webdings","Westminster","Wingdings"};

   JLabel style = new JLabel(idiom.getWord("STYLE")+":");
   Fstyle = new JComboBox(values);
   JLabel size = new JLabel(" "+idiom.getWord("LONGTYPE")+":");
   String[] values1 = {"1","2","3","4"};
   Fsize = new JComboBox(values1);
   Fcolor = new JButton(idiom.getWord("FCOLOR"));
   Fcolor.setActionCommand("ButtonColor");
   Fcolor.addActionListener(this);
   pColor = new JPanel();
   pColor.setPreferredSize(new Dimension(15,15));
   title1 = BorderFactory.createTitledBorder(etched1);
   pColor.setBorder(title1);
   title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("HEADER")+idiom.getWord("FSETT"));
   FontPanel.setBorder(title1);
   pColor.setBackground(Color.black);
 
   FontPanel.add(style);
   FontPanel.add(Fstyle);
   FontPanel.add(size);
   FontPanel.add(Fsize);
   FontPanel.add(Fcolor); 
   FontPanel.add(pColor);

   JPanel Pdate = new JPanel();
   Pdate.setLayout(new GridLayout(0,1));
   title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("DATE"));
   Pdate.setBorder(title1);
   JLabel format = new JLabel(idiom.getWord("FORMAT")+":");
   String[] dates = {idiom.getWord("NODATE"),idiom.getWord("DATE1"),idiom.getWord("DATE2"),idiom.getWord("DATE3")};
   types = new JComboBox(dates);
   JPanel level = new JPanel();
   level.setLayout(new FlowLayout(FlowLayout.CENTER));
   level.add(format);
   level.add(types);
   level.setBorder(title1);
 
   JPanel Plogo = new JPanel();
   Plogo.setLayout(new FlowLayout(FlowLayout.CENTER)); 
   title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("WIMGLOGO"));
   Plogo.setBorder(title1);
   file = new JCheckBox(idiom.getWord("FILE")+":");
   file.setActionCommand("FILE");
   file.addActionListener(this);
   filePath = new JTextField(10);
   Browse = new JButton(idiom.getWord("BROWSE"));
   Browse.setActionCommand("BROWSE");
   Browse.addActionListener(this);
   filePath.setEditable(false);
   filePath.setEnabled(false);
   Browse.setEnabled(false);
   Plogo.add(file);
   Plogo.add(filePath);
   Plogo.add(Browse);
 
   JPanel sH = new JPanel();
   sH.setLayout(new GridLayout(0,1));
   sH.add(level); 
   sH.add(Plogo);

   nH.add(FontPanel);
   cH.add(holdHeader,BorderLayout.CENTER);

   JPanel pri = new JPanel();
   pri.setLayout(new BorderLayout());
   pri.add(nH,BorderLayout.NORTH);
   pri.add(cH,BorderLayout.CENTER);

   Header.add(bloke,BorderLayout.NORTH);
   Header.add(pri,BorderLayout.CENTER);
   Header.add(sH,BorderLayout.SOUTH); 

   JButton ok = new JButton(idiom.getWord("OK"));
   ok.setActionCommand("ButtonOk");
   ok.addActionListener(this);
   JButton cancel = new JButton(idiom.getWord("CANCEL"));
   cancel.setActionCommand("ButtonCancel");
   cancel.addActionListener(this); 
   JPanel botonD = new JPanel();
   botonD.setLayout(new FlowLayout(FlowLayout.CENTER));
   botonD.add(ok);
   botonD.add(cancel);

   getContentPane().add(Header,BorderLayout.CENTER);
   getContentPane().add(botonD,BorderLayout.SOUTH); 
   pack();
   setLocationRelativeTo(parent);
   setVisible(true); 

 }

 public void actionPerformed(java.awt.event.ActionEvent e) 
  {

   if(e.getActionCommand().equals("ButtonCancel"))
    {
      setVisible(false);
    }

   if(e.getActionCommand().equals("BROWSE"))
    {
      String s = "file:" + System.getProperty("user.dir");

      String[] Sarray = {"jpg", "gif", "png"};
      ExtensionFilter filter = new ExtensionFilter(Sarray, idiom.getWord("IMGF"));

      JFileChooser fc = new JFileChooser(s);
      fc.addChoosableFileFilter(filter);

      int returnVal = fc.showDialog(ReportHeader.this,idiom.getWord("LIMG"));

      if (returnVal == JFileChooser.APPROVE_OPTION) 
       {
         filex = fc.getSelectedFile();
         if(filex.exists())
               filePath.setText(filex.getAbsolutePath());
         else
               JOptionPane.showMessageDialog(ReportHeader.this,                               
               idiom.getWord("AFDE"),                       
               idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
       }
  }

 if(e.getActionCommand().equals("FILE"))
  {
   if(file.isSelected())
    {
     filePath.setEnabled(true);
     filePath.setEditable(true);
     Browse.setEnabled(true);
    }
   else
    { 
     filePath.setText("");
     filePath.setEditable(false);
     filePath.setEnabled(false);
     Browse.setEnabled(false);
    }
  }

 if(e.getActionCommand().equals("ButtonColor"))
  {
    Color newColor = JColorChooser.showDialog(ReportHeader.this,
                                              idiom.getWord("CTC"),
                                              Color.white);
    if (newColor != null) 
     {
       pColor.setBackground(newColor);
       int valR = newColor.getRed();
       int valG = newColor.getGreen();
       int valB = newColor.getBlue();
       // Transformar Color a hexadecimal y asignarlo a fore = "#" + hexa
     }
  }

 if(e.getActionCommand().equals("ButtonOk"))
  {
    String Cabecera = "";
    String Ttitulo = "";
    String tfecha = "";
    String logo = "";
    String fecha = (String) types.getSelectedItem();
    int typeFe = types.getSelectedIndex();
    headerD = HeaderText.getText();
    String priLinea = eltitulo.getText();

    if(headerD.length()>0) 
     {
       String estilo = (String) Fstyle.getSelectedItem();
       String tam = (String) Fsize.getSelectedItem();
       String fontStyle = "<font face=" + estilo + " size=" + tam + " color=\"" + fore + "\">\n";
       Cabecera = "<blockquote><blockquote>" + fontStyle + headerD + "</font></blockquote></blockquote>";
     }

    if(priLinea.length()>0) 
         Ttitulo = "<b><u>" + priLinea + "</u></b>\n";

    if(!fecha.equals(idiom.getWord("NODATE")))
     {
      switch(typeFe) 
        {
          case 1 : tfecha = "[day/month/year]\n"; break;
          case 2 : tfecha = "[month/day/year]\n"; break;
          case 3 : tfecha = "[Month Day of Year]\n"; break;
        }
     }
    boolean fail = false;
    if(file.isSelected())
     {
       String camino = filePath.getText();
       if(camino.length()>0)
           logo = "<img src=\"" + camino + "\" align=top>\n";
       else 
         {
           fail = true;
           JOptionPane.showMessageDialog(ReportHeader.this,                               
           idiom.getWord("NIWC"),                       
           idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
         }
     }
    if(!fail) 
     {
       cab = "<center>" + logo + Ttitulo + tfecha + "\n<br clear=all></center>" + Cabecera;          
       isWell = true;
       setVisible(false);
     } 
   }
 }

} //Fin de la Clase
