/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS TableHeader v 0.1                                                   
* Descripcion:
* Esta clase se encarga de manejar la estructura de Datos
* asociada al conjunto de atributos que definen una tabla.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import java.util.Vector;
import java.util.Hashtable;

public class TableHeader {

  Vector fields = new Vector();
  Hashtable hashFields = new Hashtable();
  int NumFields;

  public TableHeader() {
    NumFields = 0;
  }

  public TableHeader(Vector columns) {
    NumFields = columns.size();    
    for(int k=0;k<NumFields;k++)
     {
       FieldReg tmp = (FieldReg)columns.elementAt(k);
       hashFields.put(tmp.Name,tmp);
       fields.addElement(tmp.Name);
     }

  }

  public String getType(String oneColumn) {
    String Type = "";
    FieldReg tmp = (FieldReg) hashFields.get(oneColumn);
    Type = tmp.Type; 
    return Type;
  }

  public Vector getNameFields() {
    return fields;
  }

  public int getNumFields() {
    return NumFields;
  }

  public Hashtable getHashtable() {
    return hashFields;
  }

} // Fin de la Clase
