#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Order entry module
#
#======================================================================

package creditnote;


sub transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);
 
  my $query;

  my $query = qq|SELECT o.id, o.ordnumber, o.transdate, o.reqdate,o.salesperson,ct.$form->{vc}number as number,
                 o.amount, ct.name, o.netamount, o.$form->{vc}_id,o.invoice,o.notes,o.transtype,o.transno,o.batch,o.subtransno,o.subb,o.project
	         FROM creditnote o, $form->{vc} ct
	         WHERE o.$form->{vc}_id = ct.id|;
	      
  my $ordnumber = $form->like(lc $form->{ordnumber});

  my $sortorder = join ', ', $form->sort_columns(qw(transdate ordnumber name));
  $sortorder = $form->{sort} unless $sortorder;

  $query .= " AND lower(ordnumber) LIKE '$ordnumber'" if $form->{ordnumber};
  $query .= qq| AND $form->{vc}_id = $form->{"$form->{vc}_id"}| if ($form->{"$form->{vc}_id"});
  $query .= " AND transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND transdate <= '$form->{transdateto}'" if $form->{transdateto};
  $query .= " ORDER by $sortorder";
  
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $oe = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{OE} }, $oe;
  }

  $sth->finish;
  $dbh->disconnect;
  
}

sub last_invoice {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get rest for the customer
  my $query = qq|select lastinvnumber from (SELECT id,ordnumber as lastinvnumber
	         FROM creditnote 
	         WHERE transtype='$form->{transtype}' order by id desc limit 2) as foo order by id DESC|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
# $form->dberror($query);
  $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;

  $sth->finish;
  $dbh->disconnect;

}


sub reverse_invoice {
  my ($dbh, $form,$dbname) = @_;
 
  # reverse inventory items
  my $query = qq|SELECT  i.parts_id,
                 i.qty, false as assemblyitem, assembly,inventory_accno_id
		 
                 FROM credititems i, parts p
		 WHERE i.parts_id = p.id
		 AND i.trans_id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  

  


  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    if ($ref->{inventory_accno_id} || $ref->{assembly}) {
 	# update parts table
    	#$query = qq|UPDATE parts SET
	#avgcost = ((avgcost * (onhand)) - ( $ref->{qty} *$ref->{lastcost}))/(onhand-($ref->{qty}))
	#            WHERE id = $ref->{parts_id}|;
	#$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
	
	
      # if the invoice item is not an assemblyitem adjust parts onhand
      unless ($ref->{assemblyitem}) {

	# adjust onhand in parts table
	$form->update_balance($dbh,
			      "parts",
			      "onhand",
			      qq|id = $ref->{parts_id}|,
			      $ref->{qty}*$rev);
      }
#$form->dberror($rev);
      # loop if it is an assembly
      next if ($ref->{assembly});
      
      # adjust allocated
      $query = qq|SELECT id, allocated,trans_id
                  FROM invoice
		  WHERE parts_id = $ref->{parts_id}
		 
		  AND allocated > 0
		  ORDER BY trans_id DESC|;
      my $ith = $dbh->prepare($query);
      $ith->execute || $form->dberror($query);
#$form->dberror($query);
      while (my $inhref = $ith->fetchrow_hashref(NAME_lc)) {
	  $qty = $ref->{qty};
	if (($qty = $ref->{qty} + $inhref->{allocated}) > 0) {
	  $qty = $inhref->{allocated};
	}
	# update invoice
	$form->update_balance($dbh,
			      "invoice",
			      "allocated",
			      qq|id = $inhref->{id}|,
			      $qty *$rev* -1);

        last if (($ref->{qty} -= $qty) <= 0);
      }
      $sth->finish;
    }
  }
  
  $sth->finish;
  
  # delete acc_trans
  $query = qq|DELETE FROM acc_trans
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$dbname,$query); 
    # delete invoice entries
  $query = qq|DELETE FROM credititems
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$dbname,$query); 
 
     # delete invoice entries
  $query = qq|DELETE FROM invoice
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$dbname,$query); 


  # $form->dberror($query);
}




sub save_order {
  my ($self, $myconfig, $form) = @_;
  
  # connect to database, turn off autocommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  my ($query, $uid, $sth);
  my $exchangerate = 0;
  $rev=1;
    if($form->{type} ne "purchase_order"){
	 $rev=-1;   
    }

  if ($form->{id}) {
	#  if($form->{type} ne 'purchase_order'){
	#	  &reverse_invoice2($dbh, $form,$myconfig->{dbname});
		  
	#  }else{
		  &reverse_invoice($dbh, $form,$myconfig->{dbname});
	#  }

  } else {
    # create OE entry
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO creditnote (ordnumber, employee_id,invoice)
                VALUES ('$uid',
		(SELECT id FROM employee WHERE login = '$form->{login}'),'true')|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    # retrieve id
    $query = qq|SELECT id FROM creditnote WHERE ordnumber = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $sth->finish;
  }

  map { $form->{$_} =~ s/'/\\'/g } qw(ordnumber);

  my ($amount, $linetotal, $discount, $taxrate, $taxbase, $taxamount, $fxsellprice);
  my ($netamount, $tax) = (0, 0);

  for my $i (1 .. $form->{rowcount}) {

    $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});

    if ($form->{"qty_$i"} != 0) {

      map { $form->{"${_}_$i"} =~ s/'/\\'/g } qw(partnumber description unit);

      # set values to 0 if nothing entered
      $form->{"discount_$i"} = $form->parse_amount($myconfig, $form->{"discount_$i"}) / 100;

      $form->{"sellprice_$i"} = $form->parse_amount($myconfig, $form->{"sellprice_$i"});
      $fxsellprice = $form->{"sellprice_$i"};

      my ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      my $decimalplaces = ($dec > 2) ? $dec : 2;

      $discount = $form->round_amount($form->{"sellprice_$i"} * $form->{"discount_$i"}, $decimalplaces);
      $form->{"sellprice_$i"} = $form->round_amount($form->{"sellprice_$i"} - $discount, $decimalplaces);

      $form->{"inventory_accno_$i"} *= 1;
      $form->{"expense_accno_$i"} *= 1;

      $linetotal = $form->round_amount($form->{"sellprice_$i"} * $form->{"qty_$i"}, 2);
      $taxrate = 0;
      map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};



      $netamount += $form->{"sellprice_$i"} * $form->{"qty_$i"};
    
      if ($form->{"inventory_accno_$i"} || $form->{"assembly_$i"}) {

 #    $form->dberror($rev ); 

        # adjust parts onhand quantity, this should go into a trigger
	$allocated=0;
	$form->update_balance($dbh,
			      "parts",
			      "onhand",
			      qq|id = $form->{"id_$i"}|,
			      ( $form->{"qty_$i"}*$rev*-1) );
    if($form->{type} eq 'purchase_order'){
        if ($form->{"assembly_$i"}) {
	  # record assembly item as allocated
	  &process_assembly($dbh, $form, $form->{"id_$i"}, ( $form->{"qty_$i"}));
	} else {
		
	  $allocated = &cogs($dbh, $form, $form->{"id_$i"}, ( $form->{"qty_$i"}));
     #$form->dberror($allocated ); 
	}
    }
      }
  #if($form->{type} eq 'purchase_order'){
       $query = qq|INSERT INTO invoice (trans_id, description, parts_id, qty,
                sellprice, fxsellprice, allocated, assemblyitem, unit)
		VALUES
		($form->{id}, '$form->{"description_$i"}',
		$form->{"id_$i"}, $form->{"qty_$i"}*$rev, 0, 0, $allocated, 'f',
		'$form->{"unit_$i"}')|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
 # }
    
      # save detail record in orderitems table
      $query = qq|INSERT INTO credititems
		 (trans_id, parts_id, description, qty, sellprice, discount,
		  unit) VALUES (
		  $form->{id}, $form->{"id_$i"}, '$form->{"description_$i"}',
		  $form->{"qty_$i"}, $fxsellprice, $form->{"discount_$i"},
		  '$form->{"unit_$i"}')|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    ##############3adjust here
   # if($form->{type} eq "purchase_order"){
#		$query = qq|update parts set
#				onhand=onhand - $form->{"qty_$i"}
#				where id=$form->{"id_$i"}

#			|;
#		$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
#	}
#	else{
#		$query = qq|update parts set
#				onhand=onhand + $form->{"qty_$i"}
#				where id=$form->{"id_$i"}

#			|;
#		$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

#	}
    }
  }


  # set values which could be empty
  $form->{vendor_id} *= 1;
  $form->{customer_id} *= 1;
  $form->{taxincluded} *= 1;

  my $reqdate = ($form->{reqdate}) ? qq|'$form->{reqdate}'| : "NULL";
  
  # add up the tax
 # foreach my $item (sort keys %taxaccounts) {
 #   $tax += $form->round_amount($taxaccounts{$item}, 2);
 # }
  
  $amount = $form->round_amount($netamount + $tax, 2);
  $netamount = $form->round_amount($netamount, 2);

  if ($form->{currency} eq $form->{defaultcurrency}) {
    $form->{exchangerate} = 1;
  } else {
    $exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{transdate}, ($form->{vc} eq 'customer') ? 'buy' : 'sell');
  }
  
  $form->{exchangerate} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{exchangerate});
  

  # save OE record
  $query = qq|UPDATE creditnote set
	      ordnumber = '$form->{ordnumber}',
	      salesperson = '$form->{salesperson}',
              transdate = '$form->{orddate}',
              vendor_id = $form->{vendor_id},
	      customer_id = $form->{customer_id},
              amount = $amount,
              netamount = $netamount,
	      reqdate = $reqdate,
	      taxincluded = '$form->{taxincluded}',
	      shippingpoint = '$form->{shippingpoint}',
	      notes = '$form->{notes}',
	      transno = '$form->{transno}',
	      batch = '$form->{batch}',
	      transtype = '$form->{transtype}',
	      subtransno = '$form->{subtransno}',
	      project = '$form->{project}',
	      subb = '$form->{subb}',
	      curr = '$form->{currency}'
              WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  ################################## adjust here insert acc_trans transactions
    # extract accno
    ($accno) = split(/--/, $form->{"accno_1"});
    my $amount1 = $amount*-1;

    # if there is an amount, add the record
    if ($amount1 != 0) {
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,
                  source,project,sub)
		  VALUES
		  ($form->{id}, (SELECT id
		                 FROM chart
				 WHERE accno = '$accno'),
		   $amount1, '$form->{orddate}', '$form->{ordnumber}' ,'$form->{project}','$form->{subb}')|;

      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


   }
 # }

     ###add credit
   ($accno) = split(/--/, $form->{"accno_2"});
    my $amount2 = $amount;

   # if there is an amount, add the record
   if ($amount2 != 0) {
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,
                  source,project,sub)
		  VALUES
		  ($form->{id}, (SELECT id
		                 FROM chart
				 WHERE accno = '$accno'),
		   $amount2, '$form->{orddate}', '$form->{ordnumber}' ,'$form->{project}','$form->{subb}')|;

      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  }
  ######################################################


  if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
    if ($form->{vc} eq 'customer') {
      $form->update_exchangerate($dbh, $form->{currency}, $form->{orddate}, $form->{exchangerate}, 0);
    }
    if ($form->{vc} eq 'vendor') {
      $form->update_exchangerate($dbh, $form->{currency}, $form->{orddate}, 0, $form->{exchangerate});
    }
  }

  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}



sub cogs {
  my ($dbh, $form, $id, $totalqty) = @_;
    
  #my $query = qq|SELECT i.id, i.qty, i.allocated, i.sellprice,
  #                      (SELECT c.accno FROM chart c
#			 WHERE p.inventory_accno_id = c.id)
#			 AS inventory_accno,
#			(SELECT c.accno FROM chart c
#			 WHERE p.income_accno_id = c.id)
#			 AS income_accno,
#			(SELECT c.accno FROM chart c
#			 WHERE p.expense_accno_id = c.id)
#			 AS expense_accno
#		  FROM invoice i, parts p
#		  WHERE i.parts_id = p.id
#		  AND i.parts_id = $id
#		  AND i.qty < 0
#		  AND (i.qty + i.allocated) < 0
#		  ORDER BY id|;

  my $query = qq|SELECT i.id, i.trans_id, (i.qty) as qty, i.sellprice,i.allocated, 
                        (SELECT c.accno FROM chart c
			 WHERE p.inventory_accno_id = c.id)
			 AS inventory_accno,
			(SELECT c.accno FROM chart c
			 WHERE p.expense_accno_id = c.id)
			 AS expense_accno
		  FROM invoice i, parts p
		  WHERE i.parts_id = p.id
		  AND i.parts_id = $id
		  AND (i.qty + i.allocated) < 0
		  ORDER BY trans_id|;



my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $allocated = 0;
  my $qty;
  
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
#	  $form->dberror($query.'<br><br>'. $totalqty.' '.$ref->{qty}.' '.$ref->{allocated});
   if (($qty = (($ref->{qty} * -1) - $ref->{allocated})) > $totalqty) {
      $qty = $totalqty;
    }
    $form->update_balance($dbh,
			  "invoice",
			  "allocated",
			  qq|id = $ref->{id}|,
			  $qty);

    # total expenses and inventory
    # sellprice is the cost of the item
    $linetotal = $form->round_amount($ref->{sellprice} * $qty, 2);

    # add to expense
    $form->{amount}{$form->{id}}{$ref->{expense_accno}} += -$linetotal;

    # deduct inventory
    $form->{amount}{$form->{id}}{$ref->{inventory_accno}} -= -$linetotal;

    # add allocated
    $allocated += -$qty;

    last if (($totalqty -= $qty) <= 0);
  }

  $sth->finish;

  $allocated;
  
}

sub cogs_old {
  my ($dbh, $form, $id, $totalqty) = @_;
    
  my $query = qq|SELECT i.id, i.trans_id, i.qty, i.allocated, i.sellprice,
                        (SELECT c.accno FROM chart c
			 WHERE p.inventory_accno_id = c.id)
			 AS inventory_accno,
			(SELECT c.accno FROM chart c
			 WHERE p.expense_accno_id = c.id)
			 AS expense_accno
		  FROM invoice i, parts p
		  WHERE i.parts_id = p.id
		  AND i.parts_id = $id
		  AND (i.qty + i.allocated) < 0
		  ORDER BY trans_id|;

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $allocated = 0;
  my $qty;
  
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    if (($qty = (($ref->{qty} * -1) - $ref->{allocated})) > $totalqty) {
      $qty = $totalqty;
    }
    
    $form->update_balance($dbh,
			  "invoice",
			  "allocated",
			  qq|id = $ref->{id}|,
			  $qty);

    # total expenses and inventory
    # sellprice is the cost of the item
    $linetotal = $form->round_amount($ref->{sellprice} * $qty, 2);

    # add to expense
    $form->{amount}{$form->{id}}{$ref->{expense_accno}} += -$linetotal;

    # deduct inventory
    $form->{amount}{$form->{id}}{$ref->{inventory_accno}} -= -$linetotal;

    # add allocated
    $allocated += -$qty;

    last if (($totalqty -= $qty) <= 0);
  }

  $sth->finish;

  $allocated;
  
}

sub delete_order {
  my ($self, $myconfig, $form) = @_;
  $rev=1;
    if($form->{type} ne "purchase_order"){
	 $rev=-1;   
    }
  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  # check for other foreign currency transactions
  $form->delete_exchangerate($dbh) if ($form->{currency} ne $form->{defaultcurrency});
 
  &reverse_invoice($dbh, $form,$myconfig->{dbname});
  
  # delete AR record
  my $query = qq|DELETE FROM creditnote
                 WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}

sub delete_order2 {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my $query;

  # can't use $form->delete_exchangerate
  if ($form->{currency} ne $form->{defaultcurrency}) {
       $query = qq|SELECT transdate FROM acc_trans
		   WHERE ar.id = trans_id
		   AND ar.curr = '$form->{currency}'
		   AND transdate = '$form->{orddate}'
	   UNION SELECT transdate FROM acc_trans
		   WHERE ap.id = trans_id
		   AND ap.curr = '$form->{currency}'
		   AND transdate = '$form->{orddate}'|;
    my $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
    
    my ($transdate) = $sth->fetchrow_array;
    $sth->finish;

    if (!$transdate) {
      $query = qq|DELETE FROM exchangerate
		  WHERE curr = '$form->{currency}'
		  AND transdate = '$form->{orddate}'|;
      $dbh->do($query) || $self->dberror($query);
    }
  }
	      
   $query = qq|SELECT (SELECT c.accno FROM chart c
                       WHERE p.inventory_accno_id = c.id)
                       AS inventory_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.income_accno_id = c.id)
		       AS income_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.expense_accno_id = c.id)
		       AS expense_accno,
                p.partnumber, p.assembly, o.description, o.qty, o.sellprice,
		o.parts_id AS id, o.unit, o.discount, p.bin
		FROM credititems o, parts p
		WHERE o.parts_id = p.id
		AND trans_id = $form->{id}
                |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ###############adjust here
    while ($ref = $sth->fetchrow_hashref(NAME_lc)) {
    if($form->{type} eq "purchase_order"){
		$query = qq|update parts set
				onhand=onhand + $ref->{"qty"}
				where id=$ref->{"id"}

			|;
		$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
	}
	else{
		$query = qq|update parts set
				onhand=onhand -$ref->{"qty"}
				where id=$ref->{"id"}

			|;
		$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

	}

    }

  # delete OE record
  $query = qq|DELETE FROM creditnote
              WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  # delete individual entries
  $query = qq|DELETE FROM credititems
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  		$query = qq|DELETE FROM acc_trans
				WHERE trans_id = $form->{id}|;
		$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

		
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}



sub retrieve_order {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my $query;

  if ($form->{id}) {
    # get default accounts and last order number
    $query = qq|SELECT (SELECT c.accno FROM chart c
                        WHERE d.inventory_accno_id = c.id) AS inventory_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.income_accno_id = c.id) AS income_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.expense_accno_id = c.id) AS expense_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxloss_accno_id = c.id) AS fxloss_accno,
                d.curr AS currencies
	 	FROM defaults d|;
  } else {
   # my $ordnumber = ($form->{vc} eq 'customer') ? 'creditnumbercus' : 'creditnumber';
    my $ordnumber =  'creditnumber';
    $query = qq|SELECT (SELECT c.accno FROM chart c
                        WHERE d.inventory_accno_id = c.id) AS inventory_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.income_accno_id = c.id) AS income_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.expense_accno_id = c.id) AS expense_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxloss_accno_id = c.id) AS fxloss_accno,
                "$ordnumber" AS ordnumber, d.curr AS currencies,
		current_date AS orddate, current_date AS reqdate
	 	FROM defaults d|;
  }
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;
  $sth->finish;

  if ($form->{id}) {
    
    $query = qq|SELECT $form->{vc}_id
                FROM creditnote
		WHERE id = $form->{id}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    if ($form->{vc} eq 'vendor') {
      use SL::IR;
      ($form->{vendor_id}) = $sth->fetchrow_array;
      IR->get_vendor($myconfig, $form);
    }
    if ($form->{vc} eq 'customer') {
      use SL::IS;
      ($form->{customer_id}) = $sth->fetchrow_array;
      IS->get_customer($myconfig, $form);
    }
    $sth->finish;
    
    # retrieve order
    $query = qq|SELECT ordnumber, transdate AS orddate, reqdate,
                taxincluded, shippingpoint, notes, curr AS currency,transtype,transno,batch,subtransno,subb,project
		FROM creditnote
		WHERE id = $form->{id}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    $ref = $sth->fetchrow_hashref(NAME_lc);
    map { $form->{$_} = $ref->{$_} } keys %$ref;
    $sth->finish;

    my %oid = ( 'Pg'		=> 'oid',
                'Oracle'	=> 'rowid',
                'DB2'		=> '' );

    # retrieve individual items
    $query = qq|SELECT (SELECT c.accno FROM chart c
                       WHERE p.inventory_accno_id = c.id)
                       AS inventory_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.income_accno_id = c.id)
		       AS income_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.expense_accno_id = c.id)
		       AS expense_accno,
                p.partnumber, p.assembly, o.description, o.qty, o.sellprice,
		o.parts_id AS id, o.unit, o.discount, p.bin
		FROM credititems o, parts p
		WHERE o.parts_id = p.id
		AND trans_id = $form->{id}
                ORDER BY o.$oid{$myconfig->{dbdriver}}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
#$form->dberror($query);
    while ($ref = $sth->fetchrow_hashref(NAME_lc)) {

      # get tax rates for part
      $query = qq|SELECT c.accno
                  FROM chart c, tax t, partstax pt
                  WHERE t.chart_id = pt.chart_id
	          AND pt.chart_id = c.id
	          AND pt.parts_id = $ref->{id}|;
      my $pth = $dbh->prepare($query);
      $pth->execute || $form->dberror($query);

      $ref->{taxaccounts} = "";
      my $taxrate = 0;
      
      while (my $ptref = $pth->fetchrow_hashref(NAME_lc)) {
        $ref->{taxaccounts} .= "$ptref->{accno} ";
        $taxrate += $form->{"$ptref->{accno}_rate"};
      }
      $pth->finish;
      chop $ref->{taxaccounts};

      push @{ $form->{order_details} }, $ref;
      
    }
    $sth->finish;

    $form->{exchangerate} = $form->get_exchangerate($dbh, $form->{currency}, $form->{orddate}, ($form->{vc} eq 'customer') ? "buy" : "sell");
    

  } else {

    my $ordnumber = ($form->{vc} eq 'customer') ? 'creditnumbercus' : 'creditnumber';
    # up order number by 1
    $form->{ordnumber}++;

    # save the new number
    $query = qq|UPDATE defaults
                SET "$ordnumber" = '$form->{ordnumber}'|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    
  }
  
        $query = qq|SELECT current_date AS transdate, current_date + 30 AS duedate,
                d.curr AS currencies, d.closedto, d.revtrans,
                  (SELECT c.accno FROM chart c
		   WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
                  (SELECT c.accno FROM chart c
		   WHERE d.fxloss_accno_id = c.id) AS fxloss_accno
		FROM defaults d|;
    $sth = $dbh->prepare($query);
    $sth->execute || $self->dberror($query);

    $ref = $sth->fetchrow_hashref(NAME_lc);
    map { $form->{$_} = $ref->{$_} } keys %$ref;
    $sth->finish;

    

  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}



sub order_details {
  my ($self, $myconfig, $form) = @_;

  my $tax = 0;
  
  foreach my $i (1 .. $form->{rowcount}) {
    $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});
    
    if ($form->{"qty_$i"} != 0) {

      # add number, description and qty to $form->{number}, ....
      push(@{ $form->{runningnumber} }, $i);
      push(@{ $form->{number} }, qq|$form->{"partnumber_$i"}|);
      push(@{ $form->{description} }, qq|$form->{"description_$i"}|);
      push(@{ $form->{qty} }, $form->format_amount($myconfig, $form->{"qty_$i"}));
      push(@{ $form->{unit} }, qq|$form->{"unit_$i"}|);
      
      push(@{ $form->{sellprice} }, $form->{"sellprice_$i"});
      
      my $sellprice = $form->parse_amount($myconfig, $form->{"sellprice_$i"});
      my ($dec) = ($sellprice =~ /\.(\d+)/);
      $dec = length $dec;
      my $decimalplaces = ($dec > 2) ? $dec : 2;
      
      my $discount = $form->round_amount($sellprice * $form->parse_amount($myconfig, $form->{"discount_$i"}) / 100, $decimalplaces);

      # keep a netprice as well, (sellprice - discount)
      $form->{"netprice_$i"} = $sellprice - $discount;

      my $linetotal = $form->round_amount($form->{"qty_$i"} * $form->{"netprice_$i"}, 2);

      push(@{ $form->{netprice} }, ($form->{"netprice_$i"} != 0) ? $form->format_amount($myconfig, $form->{"netprice_$i"}, $decimalplaces) : " ");
      
      $discount = ($discount != 0) ? $form->format_amount($myconfig, $discount * -1, $decimalplaces) : " ";
      $linetotal = ($linetotal != 0) ? $linetotal : " ";

      push(@{ $form->{discount} }, $discount);
      
      $form->{ordtotal} += $linetotal;

      push(@{ $form->{linetotal} }, $form->format_amount($myconfig, $linetotal, 2));
      
      my ($taxamount, $taxbase);
      my $taxrate = 0;
      
      map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};

      if ($form->{taxincluded}) {
	# calculate tax
	$taxamount = $linetotal * $taxrate / (1 + $taxrate);
	$taxbase = $linetotal / (1 + $taxrate);
      } else {
        $taxamount = $linetotal * $taxrate;
	$taxbase = $linetotal;
      }


      if ($taxamount != 0) {
	foreach my $item (split / /, $form->{"taxaccounts_$i"}) {
	  $taxaccounts{$item} += $taxamount * $form->{"${item}_rate"} / $taxrate;
	  $taxbase{$item} += $taxbase;
	}
      }
    }
  }


  foreach my $item (sort keys %taxaccounts) {
    if ($form->round_amount($taxaccounts{$item}, 2) != 0) {
      push(@{ $form->{taxbase} }, $form->format_amount($myconfig, $taxbase{$item}, 2));
      $tax += $taxamount = $form->round_amount($taxaccounts{$item}, 2);
      push(@{ $form->{tax} }, $form->format_amount($myconfig, $taxamount, 2));
      push(@{ $form->{taxdescription} }, $form->{"${item}_description"});
      push(@{ $form->{taxrate} }, $form->format_amount($myconfig, $form->{"${item}_rate"} * 100));
      push(@{ $form->{taxnumber} }, $form->{"${item}_taxnumber"});
    }
  }
    
  $tax = 0 if $form->{taxincluded};
  $form->{subtotal} = $form->format_amount($myconfig, $form->{ordtotal}, 2);
  $form->{ordtotal} += $tax;

  
  # format amounts
  $form->{ordtotal} = $form->format_amount($myconfig, $form->{ordtotal}, 2, "-");

  # myconfig variables
  map { $form->{$_} = $myconfig->{$_} } (qw(company address tel fax signature businessnumber));
  $form->{username} = $myconfig->{name};

}


1;

