  
#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# General ledger backend code
#
# CHANGE LOG:
#   DS. 2000-07-04  Created
#   DS. 2001-06-12  Changed relations from accno to chart_id
#
#======================================================================

package receipt;

sub last_invoice {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get rest for the customer
  my $query = qq|select lastinvnumber from (SELECT id,orid as lastinvnumber
	         FROM oreceipt 
	          order by id desc limit 2) as foo order by id DESC|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
# $form->dberror($query);
  $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;

  $sth->finish;
  $dbh->disconnect;

}

sub transaction {
  my ($self, $myconfig, $form) = @_;

  my ($query, $sth);

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

if ($form->{id}) {
    $query = "SELECT closedto, revtrans
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);




    ($form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
    $sth->finish;

    $query = "SELECT source, orid, transdate,id,chart_id,ar_chart_id,amount,curr,exchangerate,transno,subtransno,batch,transtype,customernumber
              FROM oreceipt
	      WHERE id = $form->{id}";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{source}, $form->{orid}, $form->{transdate}, $form->{id}, $form->{chart_id}, $form->{ar_chart_id}, $form->{amount}, $form->{currency}, $form->{exchangerate}, $form->{transno}, $form->{subtransno}, $form->{batch}, $form->{transtype}, $form->{customer_key}) = $sth->fetchrow_array;
    $sth->finish;

$form->{chart_key}=$form->{chart_id};
    
    # retrieve individual rows
    $query = "SELECT  (acc_trans.amount*-1) as amount,ar_chart_id,(select invnumber from ar where ar.id=ar_chart_id) as invnumber,(select transdate from ar where ar.id=ar_chart_id) as ar_date,(select notes  from ar where ar.id=ar_chart_id) as description,status,due,oreceipt_items.amount as amount1
	      FROM acc_trans,oreceipt_items
	      WHERE acc_trans.trans_id = oreceipt_items.ar_chart_id
	      AND oreceipt_items.trans_id = $form->{id}
	      AND acc_trans.source = '$form->{source}'
	      and acc_trans.chart_id=(select id from chart where accno='$form->{chart_id}')
		";
    $sth = $dbh->prepare($query);
    #$form->dberror($query);
    $sth->execute || $form->dberror($query);

    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      push @{ $form->{GL} }, $ref;
    }
  } else {
    $query = "SELECT current_date AS transdate, closedto, revtrans,orid
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{transdate}, $form->{closedto}, $form->{revtrans}, $form->{orid}) = $sth->fetchrow_array;
  $form->{orid}++;
  
     $query = qq|update defaults set orid='$form->{orid}'|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  }

  $sth->finish;


  $dbh->disconnect;
}

c_chart{
  my ($self, $myconfig, $form) = @_;

  my ($query, $sth);

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get AR_paid chart of accounts
  $query = qq|SELECT accno,description
              FROM chart
	      WHERE charttype = 'A' and link like '%AR_paid%'
              ORDER by accno|;
  $sth = $dbh->prepare($query);
  #$form->dberror($query);
  $sth->execute || $form->dberror($query);
  $form->{chart} = "";
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{chart} .= "<option>$ref->{accno}--$ref->{description}\n";
  }

   # get AR chart of accounts
  $query = qq|SELECT accno,description
              FROM chart
	      WHERE  link like 'AR'
              ORDER by accno|;
  $sth = $dbh->prepare($query);
 # $form->dberror($query);
  $sth->execute || $form->dberror($query);
  $form->{customer} = "";
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{customer} .= "<option>$ref->{accno}--$ref->{description}\n";
  }
  #$form->dberror($form->{customer});
  $sth->finish;

  $dbh->disconnect;
}



sub get_ar_list {
  my ($self, $myconfig, $form) = @_;
 #$form->dberror($myconfig->{dbdriver);
  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
 ($customerno, $form->{customer1}) = split(/--/, $form->{customer});
  if ($form->{customer1}) {
   # my $source = $form->like(lc $customerno);
    $glwhere .= " AND customernumber = '$customerno'";
  }

 #$form->dberror($form->{customer});

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( transdate invnumber amount ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;

  my $query = qq|SELECT ar.id,invnumber ,amount from ar,customer  where $glwhere and paid-amount!=0 and customer.id=ar.customer_id
	         ORDER BY invnumber|;
  my $sth = $dbh->prepare($query);

#$form->dberror($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {


    push @{ $form->{GL} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

sub get_AR {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");


 if ($form->{ar_id1}) {
  #  my $source = $form->like(lc $form->{customer1});
    $glwhere .= " AND id = $form->{ar_id1}";
}

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( transdate invnumber amount ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;

  my $query = qq|SELECT transdate as ar_date,id,invnumber,amount as amount1,paid ,  amount-paid as total,notes as description from ar where $glwhere
	         ORDER BY $form->{sort}|;
  my $sth = $dbh->prepare($query);


  $sth->execute || $form->dberror($query);
   ($form->{ar_date}, $form->{ar_id}, $form->{invnumber}, $form->{amount1}, $form->{paid}, $form->{total}, $form->{description}) = $sth->fetchrow_array;


  $sth->finish;


  $dbh->disconnect;

#$form->dberror($query);
}


sub add {
  my ($self, $myconfig, $form) = @_;
   ($chart_id, $value) = split /--/, $form->{chart_key};
   ($customer_id, $value) = split /--/, $form->{customer};


  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");


  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;


    # customer id
    $query = qq|(select id from customer where customernumber='$customer_id')|;

    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{customer_id}) = $sth->fetchrow_array;
    $sth->finish;
  
  
  my $sortorder = join ', ', $form->sort_columns(qw( transdate invnumber amount ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  if ($form->{id}) {

    # delete detail records
    $query = qq|DELETE FROM oreceipt WHERE id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  my $query = qq|SELECT * from oreceipt_items  WHERE trans_id = $form->{id}
	         |;
  my $sth = $dbh->prepare($query);


  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    $query = qq|DELETE FROM acc_trans WHERE trans_id = $ref->{ar_chart_id} and source='$form->{source}'|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 



  }

     $query = qq|DELETE FROM oreceipt_items WHERE trans_id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


  }
    $uid = time;
    $uid .= $form->{login};
   
   $query = qq|INSERT INTO oreceipt (orid, source,chart_id,employee_id,ar_chart_id,amount,transdate)
                VALUES ('$uid','$form->{source}',$chart_id,(SELECT id FROM employee WHERE login = '$form->{login}'),$form->{customer_id},$form->{amount},'$form->{transdate}'
		)|;

	#	$form->dberror($query);

    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    



    # retrieve id
    $query = qq|SELECT id
                FROM oreceipt
		WHERE orid = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $sth->finish;

$form->{exchangerate}=$form->parse_amount($myconfig, $form->{"exchangerate"});
 ($customernumber, $form->{customer1}) = split(/--/, $form->{customer});

 $query = qq|UPDATE oreceipt set
	      orid = '$form->{orid}',
	      customernumber = '$customernumber',
	      source = '$form->{source}',
	      exchangerate = $form->{exchangerate},
	      curr = '$form->{currency}',
	      transdate = '$form->{transdate}',
	      chart_id = $chart_id,
	      ar_chart_id = $form->{customer_id},
	      transno = '$form->{transno}',
	      batch = '$form->{batch}',
	      transtype = '$form->{transtype}',
	      subtransno = '$form->{subtransno}',
	      amount = $form->{amount}
	      WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 



   for $i (1 .. $form->{rowcount}) {

   # if there is an amount, add the record
  $form->{"amount1_$i"} =$form->parse_amount($myconfig, $form->{"amount1_$i"});
 $form->{"due_$i"} =$form->parse_amount($myconfig, $form->{"due_$i"});
   if ($form->{"total_$i"} != 0) {
      $query = qq|INSERT INTO oreceipt_items (trans_id, ar_chart_id,status,due,amount
                  )
		  VALUES
		  ($form->{id}, $form->{"ar_id_$i"},'$form->{"status_$i"}',$form->{"due_$i"},$form->{"amount1_$i"}
		    )|;

      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    
    $form->{"total_$i"}=$form->parse_amount($myconfig, $form->{"total_$i"});
    
    ###debit
    $query = qq|INSERT INTO acc_trans (trans_id, chart_id,amount,transdate,source
                  )
		  VALUES
		  ($form->{"ar_id_$i"},(select id from chart where accno='$chart_id'),($form->{"total_$i"}*-1),'$form->{transdate}','$form->{source}'
		    )|;

      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

      
      ##credit
     $query = qq|INSERT INTO acc_trans (trans_id, chart_id,amount,transdate,source
                  )
		  VALUES
		  ($form->{"ar_id_$i"},(select id from chart where accno='$customer_id'),($form->{"total_$i"}),'$form->{transdate}','$form->{source}'
		    )|;

      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
#$form->dberror($query);
      
       $query = qq|UPDATE ar set
	      paid = paid + ($form->{"total_$i"}),
	      datepaid = '$form->{"transdate"}'

	      WHERE  id='$form->{"ar_id_$i"}'|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  
  
    # update exchangerate
  if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
    $form->update_exchangerate($dbh, $form->{currency}, $form->{transdate}, $form->{exchangerate}, 0);
  }
  
    }
  }

  $dbh->disconnect;

}

sub lastid {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $query = qq|
		select max(orid) as id from oreceipt group by orid

	         |;


  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {


#    push @{ $form->{curr_year} }, $ref;
$form->{lastid}= $ref->{id};

  }

  $sth->finish;


  $dbh->disconnect;

}

sub delete_receipt {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);
   # delete detail records
    $query = qq|DELETE FROM oreceipt WHERE id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  my $query = qq|SELECT *,acc_trans.amount as amount1 from oreceipt_items,acc_trans  WHERE acc_trans.trans_id=ar_chart_id and source='$form->{source}'  and oreceipt_items.trans_id = $form->{id}
	         |;
  my $sth = $dbh->prepare($query);
#$form->dberror($query);

  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

			$query = qq|DELETE FROM acc_trans WHERE trans_id = $ref->{ar_chart_id} and source='$form->{source}'|;
			$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

			$query = qq|update ar set paid=paid-$ref->{amount1} WHERE id = $ref->{ar_chart_id} |;
			$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 



  }
 #$self->transaction(\%myconfig, \%$form);

     $query = qq|DELETE FROM oreceipt_items WHERE trans_id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 



  # commit and redirect
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}

sub updatepaid{
 my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

    # retrieve id
    $query = qq|SELECT sum(amount)
                FROM acc_trans
		WHERE trans_id = $form->{id} group by amount|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{amount}) = $sth->fetchrow_array;
    $sth->finish;
 

    $query = qq|UPDATE ar set
	      paid = $form->{amount},
	      WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


    # commit and redirect
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}

sub list_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere) = ("1 = 1");

 if ($form->{source}) {
    my $source = $form->like(lc $form->{source});
    $glwhere.=" and source like '$form->{source}%' ";
 }
 if ($form->{customer_id}) {
     $glwhere.=" and customer.id=$form->{customer_id}";
  }

  
  if ($form->{orid}) {
    $glwhere.=" and orid='$form->{orid}' ";
  }
  if ($form->{datefrom}) {
    $glwhere .= " AND transdate >= '$form->{datefrom}'";
   }
  if ($form->{dateto}) {
    $glwhere .= " AND transdate <= '$form->{dateto}'";
   }
  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( orid ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;

  my $query = qq|SELECT oreceipt.id,  oreceipt.transtype,oreceipt.batch,oreceipt.transno,oreceipt.subtransno, oreceipt.transdate, oreceipt.orid,customer.name,oreceipt.source,(select login from employee where id=oreceipt.employee_id) as employee,oreceipt.curr,oreceipt.amount
  		from oreceipt,customer where oreceipt.ar_chart_id=customer.id and $glwhere
		ORDER BY $form->{sort}|;
  my $sth = $dbh->prepare($query);
#$form->dberror($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
      $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }

    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

sub list_transactions2 {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere) = ("1 = 1");

 if ($form->{source}) {
    my $source = $form->like(lc $form->{source});
    $glwhere.=" and oreceipt.source like '$form->{source}%' ";
 }
 if ($form->{customer_id}) {
     $glwhere.=" and customer.id=$form->{customer_id}";
  }
 if ($form->{payment_id}) {
     $glwhere.=" and oreceipt.chart_id=$form->{payment_id}";
  }

  
  if ($form->{orid}) {
    $glwhere.=" and oreceipt.orid='$form->{orid}' ";
  }
  if ($form->{datefrom}) {
    $glwhere .= " AND oreceipt.transdate >= '$form->{datefrom}'";
   }
  if ($form->{dateto}) {
    $glwhere .= " AND oreceipt.transdate <= '$form->{dateto}'";
   }
  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( orid ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;

  my $query = qq| select customer.customernumber,oreceipt.id, employee.login as employee,oreceipt.source,oreceipt.curr,oreceipt.transtype,oreceipt.batch,oreceipt.transno,oreceipt.subtransno,oreceipt.transdate,customer.name,orid,oreceipt.chart_id,chart.description,ar.invnumber,(acc_trans.amount*-1) as amount 
  		from customer,chart, ar,oreceipt,oreceipt_items, acc_trans ,employee
		where employee.id=oreceipt.employee_id and oreceipt.id=oreceipt_items.trans_id and acc_trans.trans_id=oreceipt_items.ar_chart_id and ar.id=acc_trans.trans_id and ar.id=oreceipt_items.ar_chart_id and chart.accno=oreceipt.chart_id and chart.link like '%paid%' and acc_trans.chart_id=chart.id and ar.customer_id=customer.id and oreceipt.source=acc_trans.source 
		and $glwhere
		ORDER BY $form->{sort}|;
  my $sth = $dbh->prepare($query);
#$form->dberror($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

 
      $ref->{credit} = $ref->{subtotal};


    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

1;
