
#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# General ledger backend code
#
# CHANGE LOG:
#   DS. 2000-07-04  Created
#   DS. 2001-06-12  Changed relations from accno to chart_id
#
#======================================================================

package statement;

sub all_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
 ($customerno, $form->{AR1}) = split(/--/, $form->{AR});
  if ($customerno) {
    my $source = $form->like(lc $customerno);
    $glwhere .= " AND lower(accno) LIKE '$source'";
  }
  
  

  ($customerno, $form->{AP1}) = split(/--/, $form->{AP});
  if ($customerno) {
    my $source = $form->like(lc $customerno);
    $glwhere .= " AND lower(accno) LIKE '$source'";
  }
  
  if ($form->{date}) {
    my $source = $form->like(lc $form->{date});
    #$glwhere .= " AND date_part('month',transdate) <= $source";
	  my $query = qq|
			select extract(month from date '$form->{date}') as month,extract(day from date '$form->{date}') as day,extract(year from date '$form->{date}') as year
			 ;
	  |;
	  my $sth = $dbh->prepare($query);
	 #$form->dberror($query);
	
	  $sth->execute || $form->dberror($query);


	  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
	
            $glwhere2 =$glwhere. " AND transdate >='$ref->{year}-$ref->{month}-1' AND transdate <='$ref->{year}-$ref->{month}-$ref->{day}'";
	    $glwhere .= " AND transdate <'$ref->{year}-$ref->{month}-1' ";

	    push @{ $form->{date} }, $ref;
	    
	    
		  $querymonth=$ref->{month};
$queryyear=$ref->{year};
#$form->dberror($ref->{month});

	  }
	  


   }




  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( transdate refnumber number  debit credit  ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  
my $query ="";
if(!$form->{stype}){
   $query = qq|
		select foo.*
		 from (select type, min(transtype) as transtype ,min(batch) as batch , min(transno) as transno,min(subtransno) as subtransno,id,max(source) as source,min(transdate) as transdate,max(accno) as accno ,max(accdesc) as accdesc, description,sum(amount) as amount from statement2 
		 where $glwhere group by id,description,type) as foo where amount !=0
		 
		 union all
		 
		 select type, transtype,batch, transno,subtransno,id, source,transdate,accno,accdesc,description,amount from statement2 where $glwhere2 order by transdate
		 ;
  |;
}else{
  $query = qq|
		 select text '' as type, text '' as transtype,text '' as batch,text '' as transno,text '' as subtransno,0 as id, text '' as source, date '$queryyear-$querymonth-01' as transdate, text '' as accno, '' as accdesc,text 'Opening balance' as description,sum(amount) as amount
		 from (select min(transtype) as transtype ,min(batch) as batch , min(transno) as transno,min(subtransno) as subtransno,id,max(source) as source,min(transdate) as transdate,max(accno),max(accdesc),text 'Outstanding Payment' as description,sum(amount) as amount from statement2 
		 where $glwhere group by id) as foo group by description
			 
		 union all
		 
		 select type , transtype,batch, transno,subtransno,id, source,transdate,accno,accdesc,description,amount from statement2 where $glwhere2 order by transdate
		 ;
  |;	
}
  my $sth = $dbh->prepare($query);
 #$form->dberror($ref->{month});

  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
     if ($ref->{type} eq "gl") {
	     $ref->{description}='General Ledger';
     }
     if ($ref->{type} eq "ar") {
	     if($ref->{amount} < 0){
	     $ref->{description}='Sales Invoice';
	     }else{
	     $ref->{description}='Sales Payment';
	     }
     }
     if ($ref->{type} eq "ap") {
	     if($ref->{amount}>0){
	     $ref->{description}='Purchase Invoice';
	     }else{
	     $ref->{description}='Purchase Payment';
	     }
      }
     if ($ref->{type} eq "cn") {
	     $ref->{description}='Credit Notes';
     }
     if ($ref->{type} eq "cn1") {
	     $ref->{description}='Credit Notes';
     }

     if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
   #   $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }
    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

sub all_transactions3 {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
 ($customerno, $form->{AR1}) = split(/--/, $form->{AR});
  if ($customerno) {
    my $source = $form->like(lc $customerno);
    $glwhere .= " AND lower(accno) LIKE '$source'";
  }

  ($customerno, $form->{AP1}) = split(/--/, $form->{AP});
  if ($customerno) {
    my $source = $form->like(lc $customerno);
    $glwhere .= " AND lower(accno) LIKE '$source'";
  }
  
  if ($form->{date}) {
    my $source = $form->like(lc $form->{date});
    #$glwhere .= " AND date_part('month',transdate) <= $source";
	  my $query = qq|
			select extract(month from date '$form->{date}') as month,extract(day from date '$form->{date}') as day,extract(year from date '$form->{date}') as year
			 ;
	  |;
	  my $sth = $dbh->prepare($query);
	 #$form->dberror($query);
	
	  $sth->execute || $form->dberror($query);


	  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
	
          #  $glwhere2 =$glwhere. " AND transdate >='$ref->{year}-$ref->{month}-1' AND transdate <='$ref->{year}-$ref->{month}-$ref->{day}'";
	 
             $glwhere2 =$glwhere. " AND  transdate >'$ref->{year}-$ref->{month}-$ref->{day}'";
	   # $glwhere .= " AND transdate <'$ref->{year}-$ref->{month}-1' ";

	    push @{ $form->{date} }, $ref;
	    
	    
		  $querymonth=$ref->{month};
$queryyear=$ref->{year};
#$form->dberror($ref->{month});

	  }
	  


   }




  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( transdate refnumber number  debit credit  ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  
my $query ="";
   $query = qq|
		 select transtype,batch, transno,subtransno,id, source,transdate,accno,accdesc,description,amount from statement2 where $glwhere2 order by transdate
		 ;
  |;

  my $sth = $dbh->prepare($query);
 #$form->dberror($query);

  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
   #   $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }
    push @{ $form->{report2} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}


sub all_transactions2 {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere,$paywhere,$transwhere) = ("1 = 1", "1 = 1", "1 = 1", "1 = 1", "1 = 1");
 ($customerno, $form->{AR1}) = split(/--/, $form->{AR});
  if ($customerno) {
    my $source = $form->like(lc $customerno);
    $glwhere .= " AND lower(accno) LIKE '$source'";
  }
   ($customerno, $form->{AP1}) = split(/--/, $form->{AP});
  if ($customerno) {
    my $source = $form->like(lc $customerno);
    $glwhere .= " AND lower(accno) LIKE '$source'";
  }
  ####statement for more than 4 months
 	  my $query = qq|
	
			  select  sum(amount) as lastamount from (
			 select sum(amount) as amount,month ,year from (
			 select source, sum(amount) as amount,extract( month from min(transdate)) as month,extract( year from min(transdate)) as year from statement2 where $glwhere group by source
			 ) as foo group by month,year order by year desc,month desc offset 4
			 ) as foo ;
	  |;
	  my $sth = $dbh->prepare($query);
	 #$form->dberror($query);
	
	  $sth->execute || $form->dberror($query);
	
	($form->{lastamount}) = $sth->fetchrow_array;

  if ($form->{date}) {
    my $source = $form->like(lc $form->{date});
    #$glwhere .= " AND date_part('month',transdate) <= $source";
	    $glwhere .= " AND transdate <='$form->{date}' ";

   }


  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( date total  ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
 
 
 ####statement for first 4 months

  my $query = qq|
 select sum(amount) as amount,month ,year from (
 select source, sum(amount) as amount,extract( month from min(transdate)) as month,extract( year from min(transdate)) as year from statement2 where $glwhere group by source
 ) as foo group by month,year order by year desc,month desc limit 4;
 
	         |;

#$form->dberror($query);

  my $sth = $dbh->prepare($query);
  
 # $form->dberror($query);

  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
   #   $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }

    push @{ $form->{statement} }, $ref;

  }

 
	  
  $sth->finish;


  $dbh->disconnect;

}

sub current_month {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere,$paywhere,$transwhere) = ("1 = 1", "1 = 1", "1 = 1", "1 = 1", "1 = 1");


  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $query = qq|
		select date_part('month',current_date) as month

	         |;


  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {


   # push @{ $form->{curr_month} }, $ref;
$form->{curr_month}= $ref->{month};
  }

  $sth->finish;


  $dbh->disconnect;

}

sub current_year {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere,$paywhere,$transwhere) = ("1 = 1", "1 = 1", "1 = 1", "1 = 1", "1 = 1");


  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $query = qq|
		select date_part('year',current_date)as year

	         |;


  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {


#    push @{ $form->{curr_year} }, $ref;
$form->{curr_year}= $ref->{year};

  }

  $sth->finish;


  $dbh->disconnect;

}

######################new added
sub statement {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
# ($customerno, $form->{AR1}) = split(/--/, $form->{AR});
  #if ($customerno) {
   # my $source = $form->like(lc $customerno);
    #$glwhere .= " AND lower(accno) LIKE '$source'";
  #}
  
  if($form->{customer_id}){
   # my $source = $form->like(lc $customerno);
   $glwhere .= " AND chart_id=$form->{customer_id}";
  
  }

  #($customerno, $form->{AP1}) = split(/--/, $form->{AP});
  #if ($customerno) {
    #my $source = $form->like(lc $customerno);
    #$glwhere .= " AND lower(accno) LIKE '$source'";
  #}
  
  if ($form->{todate}) {
    my $source = $form->like(lc $form->{todate});
    #$glwhere .= " AND date_part('month',transdate) <= $source";
	  my $query = qq|
			select extract(month from date '$form->{todate}') as month,extract(day from date '$form->{todate}') as day,extract(year from date '$form->{todate}') as year
			 ;
	  |;
	  my $sth = $dbh->prepare($query);
	# $form->dberror($query);
	
	  $sth->execute || $form->dberror($query);


	  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
	
            $glwhere2 =$glwhere. " AND transdate >='$ref->{year}-$ref->{month}-1' AND transdate <='$ref->{year}-$ref->{month}-$ref->{day}'";
	    $glwhere .= " AND transdate <'$ref->{year}-$ref->{month}-1' ";

	    push @{ $form->{todate} }, $ref;
	    
	    
		  $querymonth=$ref->{month};
$queryyear=$ref->{year};
#$form->dberror($ref->{month});

	  }
	  


   }




  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( transdate refnumber number  debit credit  ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  
my $query ="";
if(!$form->{stype}){
   $query = qq|
		select foo.*
		 from (select type, min(transtype) as transtype ,min(batch) as batch , min(transno) as transno,min(subtransno) as subtransno,id,max(source) as source,min(transdate) as transdate,max(accno) as accno ,max(accdesc) as accdesc, description,sum(amount) as amount from statement2 
		 where $glwhere group by id,description,type) as foo where amount !=0
		 
		 union all
		 
		 select type, transtype,batch, transno,subtransno,id, source,transdate,accno,accdesc,description,amount from statement2 where $glwhere2 order by transdate
		 ;
  |;
}else{
  $query = qq|
		 select text '' as type, text '' as transtype,text '' as batch,text '' as transno,text '' as subtransno,0 as id, text '' as source, date '$queryyear-$querymonth-01' as transdate, text '' as accno, '' as accdesc,text 'Opening balance' as description,sum(amount) as amount
		 from (select min(transtype) as transtype ,min(batch) as batch , min(transno) as transno,min(subtransno) as subtransno,id,max(source) as source,min(transdate) as transdate,max(accno),max(accdesc),text 'Outstanding Payment' as description,sum(amount) as amount from statement2 
		 where $glwhere group by id) as foo group by description
			 
		 union all
		 
		 select type , transtype,batch, transno,subtransno,id, source,transdate,accno,accdesc,description,amount from statement2 where $glwhere2 order by transdate
		 ;
  |;	
}
  my $sth = $dbh->prepare($query);
 #$form->dberror($ref->{month});

  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
     if ($ref->{type} eq "gl") {
	     $ref->{description}='General Ledger';
     }
     if ($ref->{type} eq "ar") {
	     if($ref->{amount} < 0){
	     $ref->{description}='Sales Invoice';
	     }else{
	     $ref->{description}='Sales Payment';
	     }
     }
     if ($ref->{type} eq "ap") {
	     if($ref->{amount}>0){
	     $ref->{description}='Purchase Invoice';
	     }else{
	     $ref->{description}='Purchase Payment';
	     }
      }
     if ($ref->{type} eq "cn") {
	     $ref->{description}='Credit Notes';
     }
     if ($ref->{type} eq "cn1") {
	     $ref->{description}='Credit Notes';
     }

     if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
   #   $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }
    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}


sub postdated {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
   if($form->{customer_id}){
   # my $source = $form->like(lc $customerno);
   $glwhere .= " AND chart_id=$form->{customer_id}";
  
  }

  if ($form->{todate}) {
    my $source = $form->like(lc $form->{todate});
    #$glwhere .= " AND date_part('month',transdate) <= $source";
	  my $query = qq|
			select extract(month from date '$form->{todate}') as month,extract(day from date '$form->{todate}') as day,extract(year from date '$form->{todate}') as year
			 ;
	  |;
	  my $sth = $dbh->prepare($query);
	 #$form->dberror($query);
	
	  $sth->execute || $form->dberror($query);


	  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
	
          #  $glwhere2 =$glwhere. " AND transdate >='$ref->{year}-$ref->{month}-1' AND transdate <='$ref->{year}-$ref->{month}-$ref->{day}'";
	 
             $glwhere2 =$glwhere. " AND  transdate >'$ref->{year}-$ref->{month}-$ref->{day}'";
	   # $glwhere .= " AND transdate <'$ref->{year}-$ref->{month}-1' ";

	    push @{ $form->{todate} }, $ref;
	    
	    
		  $querymonth=$ref->{month};
$queryyear=$ref->{year};
#$form->dberror($ref->{month});

	  }
	  


   }




  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( transdate refnumber number  debit credit  ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  
my $query ="";
   $query = qq|
		 select type,transtype,batch, transno,subtransno,id, source,transdate,accno,accdesc,description,amount from statement2 where $glwhere2 order by transdate
		 ;
  |;

  my $sth = $dbh->prepare($query);
# $form->dberror($query);

  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
if ($ref->{type} eq "gl") {
	     $ref->{description}='General Ledger';
     }
     if ($ref->{type} eq "ar") {
	     if($ref->{amount} < 0){
	     $ref->{description}='Sales Invoice';
	     }else{
	     $ref->{description}='Sales Payment';
	     }
     }
     if ($ref->{type} eq "ap") {
	     if($ref->{amount}>0){
	     $ref->{description}='Purchase Invoice';
	     }else{
	     $ref->{description}='Purchase Payment';
	     }
      }
     if ($ref->{type} eq "cn") {
	     $ref->{description}='Credit Notes';
     }
     if ($ref->{type} eq "cn1") {
	     $ref->{description}='Credit Notes';
     }
    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }


    push @{ $form->{report2} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

1;
