/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.renderer.DelegatingNodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.util.ComputableFactory;
import com.vladsch.flexmark.util.dependency.Dependent;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class DelegatingNodeRendererFactoryWrapper
implements ComputableFactory<NodeRenderer, DataHolder>,
Dependent<DelegatingNodeRendererFactoryWrapper>,
DelegatingNodeRendererFactory {
    private final NodeRendererFactory nodeRendererFactory;
    private List<DelegatingNodeRendererFactoryWrapper> nodeRenderers;
    private Set<Class> myDelegates = null;

    public DelegatingNodeRendererFactoryWrapper(List<DelegatingNodeRendererFactoryWrapper> nodeRenderers, NodeRendererFactory nodeRendererFactory) {
        this.nodeRendererFactory = nodeRendererFactory;
        this.nodeRenderers = nodeRenderers;
    }

    @Override
    public NodeRenderer create(DataHolder options) {
        return this.nodeRendererFactory.create(options);
    }

    public NodeRendererFactory getFactory() {
        return this.nodeRendererFactory;
    }

    @Override
    public Set<Class<? extends NodeRendererFactory>> getDelegates() {
        return this.nodeRendererFactory instanceof DelegatingNodeRendererFactory ? ((DelegatingNodeRendererFactory)this.nodeRendererFactory).getDelegates() : null;
    }

    public final Set<? extends Class> getAfterDependents() {
        return null;
    }

    public Set<? extends Class> getBeforeDependents() {
        if (this.myDelegates == null && this.nodeRenderers != null) {
            Set<Class<? extends NodeRendererFactory>> delegates = this.getDelegates();
            if (delegates != null) {
                this.myDelegates = new HashSet<Class>();
                for (DelegatingNodeRendererFactoryWrapper factory : this.nodeRenderers) {
                    if (!delegates.contains(factory.getFactory().getClass())) continue;
                    this.myDelegates.add(factory.getFactory().getClass());
                }
            }
            this.nodeRenderers = null;
        }
        return this.myDelegates;
    }

    public final boolean affectsGlobalScope() {
        return false;
    }
}

