/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.matchers.ProfilingCharMatcherNodeGen;

public abstract class ProfilingCharMatcher
extends CharMatcher {
    @Node.Child
    private CharMatcher byteMatcher;
    @Node.Child
    private CharMatcher charMatcher;

    ProfilingCharMatcher(CharMatcher byteMatcher, CharMatcher charMatcher) {
        this.byteMatcher = byteMatcher;
        this.charMatcher = charMatcher;
    }

    public static ProfilingCharMatcher create(CharMatcher byteMatcher, CharMatcher charMatcher) {
        return ProfilingCharMatcherNodeGen.create(byteMatcher, charMatcher);
    }

    @Specialization(guards={"compactString"})
    boolean matchCompactString(char c, boolean compactString) {
        return this.byteMatcher.execute(c, compactString);
    }

    @Specialization(guards={"!compactString", "isByte(c)"})
    boolean matchByte(char c, boolean compactString) {
        return this.byteMatcher.execute(c, compactString);
    }

    @Specialization(guards={"!compactString"}, replaces={"matchByte"})
    boolean matchChar(char c, boolean compactString) {
        return this.charMatcher.execute(c, compactString);
    }

    static boolean isByte(char c) {
        return c < '\u0100';
    }

    @Override
    public int estimatedCost() {
        return this.charMatcher.estimatedCost();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.charMatcher.toString();
    }
}

