/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.ArrayCreateNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArray;

@ImportStatic(value={JSRuntime.class, Integer.class})
public abstract class ArrayCreateNode
extends JavaScriptBaseNode {
    private final JSContext context;

    protected ArrayCreateNode(JSContext context) {
        this.context = context;
    }

    public static ArrayCreateNode create(JSContext context) {
        return ArrayCreateNodeGen.create(context);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length <= MAX_VALUE"})
    protected DynamicObject doDefault(long length) {
        return JSArray.createEmptyChecked(this.context, length);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length > MAX_VALUE"})
    protected DynamicObject doLargeLength(long length) {
        return JSArray.createSparseArray(this.context, length);
    }

    @Specialization(guards={"!isValidArrayLength(length)"})
    protected DynamicObject doInvalidLength(long length) {
        throw Errors.createRangeErrorInvalidArrayLength();
    }

    public abstract DynamicObject execute(long var1);
}

