/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.ArrayFunctionBuiltins;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ArrayAllocationSite;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantByteArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyPrototypeArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultIndicesArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSSlowArray;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import java.util.ArrayList;
import java.util.List;

public final class JSArray
extends JSAbstractArray
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final String CLASS_NAME = "Array";
    public static final String PROTOTYPE_NAME = "Array.prototype";
    public static final String ITERATOR_CLASS_NAME = "Array Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "Array Iterator.prototype";
    public static final String ENTRIES = "entries";
    public static final JSArray INSTANCE = new JSArray();
    static final Property ARRAY_LENGTH_PROXY_PROPERTY = JSArray.makeArrayLengthProxyProperty();
    public static final HiddenKey ARRAY_ITERATION_KIND_ID = new HiddenKey("ArrayIterationKind");

    private JSArray() {
    }

    public static DynamicObject createConstant(JSContext context, Object[] elements) {
        return JSArray.create(context, ScriptArray.createConstantArray(elements), elements, elements.length);
    }

    public static DynamicObject createEmpty(JSContext context, int length) {
        if (length < 0) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        return JSArray.createEmptyChecked(context, length);
    }

    private static DynamicObject createEmptyChecked(JSContext context, int length) {
        return JSArray.createConstantEmptyArray(context, length);
    }

    public static DynamicObject createEmpty(JSContext context, long length) {
        if (!JSRuntime.isValidArrayLength(length)) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        if (length > Integer.MAX_VALUE) {
            return JSArray.createSparseArray(context, length);
        }
        return JSArray.createEmptyChecked(context, length);
    }

    public static DynamicObject createEmptyChecked(JSContext context, long length) {
        assert (0L <= length && length <= Integer.MAX_VALUE);
        return JSArray.createConstantEmptyArray(context, (int)length);
    }

    public static DynamicObject createEmptyZeroLength(JSContext context) {
        return JSArray.createConstantEmptyArray(context);
    }

    public static DynamicObject create(JSContext context, ScriptArray arrayType, Object array, long length) {
        return JSArray.create(context, arrayType, array, length, 0);
    }

    public static DynamicObject create(JSContext context, ScriptArray arrayType, Object array, long length, int usedLength) {
        return JSArray.create(context, arrayType, array, length, usedLength, 0, 0);
    }

    public static DynamicObject create(JSContext context, ScriptArray arrayType, Object array, long length, int usedLength, int indexOffset, int arrayOffset) {
        return JSArray.create(context, arrayType, array, length, usedLength, indexOffset, arrayOffset, 0);
    }

    public static DynamicObject create(JSContext context, ScriptArray arrayType, Object array, long length, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        return JSArray.createImpl(context, arrayType, array, null, length, usedLength, indexOffset, arrayOffset, holeCount);
    }

    public static DynamicObject create(JSContext context, ScriptArray arrayType, Object array, ArrayAllocationSite site, long length, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        return JSArray.createImpl(context, arrayType, array, site, length, usedLength, indexOffset, arrayOffset, holeCount);
    }

    private static DynamicObject createImpl(JSContext context, ScriptArray arrayType, Object array, ArrayAllocationSite site, long length, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        DynamicObject obj = JSObject.create(context, context.getArrayFactory(), array, arrayType, site, (int)length, usedLength, indexOffset, arrayOffset, holeCount);
        assert (JSArray.isJSArray(obj));
        return obj;
    }

    public static boolean isJSArray(Object obj) {
        return JSObject.isDynamicObject(obj) && JSArray.isJSArray((DynamicObject)obj);
    }

    public static boolean isJSArray(DynamicObject obj) {
        return JSArray.isInstance(obj, (JSClass)INSTANCE) || JSArray.isInstance(obj, (JSClass)JSSlowArray.INSTANCE);
    }

    public static boolean isJSFastArray(Object obj) {
        return JSObject.isDynamicObject(obj) && JSArray.isJSFastArray((DynamicObject)obj);
    }

    public static boolean isJSFastArray(DynamicObject obj) {
        return JSArray.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject arrayPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)INSTANCE);
        JSArray.putArrayProperties(arrayPrototype, ConstantEmptyPrototypeArray.createConstantEmptyPrototypeArray());
        JSObjectUtil.putConstructorProperty(ctx, arrayPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayPrototype, ArrayPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putProxyProperty(arrayPrototype, ARRAY_LENGTH_PROXY_PROPERTY);
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSObjectUtil.putDataProperty(ctx, arrayPrototype, Symbol.SYMBOL_ITERATOR, arrayPrototype.get((Object)"values"), JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty(ctx, arrayPrototype, Symbol.SYMBOL_UNSCOPABLES, JSArray.createUnscopables(ctx, JSArray.unscopableNameList(ctx)), JSAttributes.configurableNotEnumerableNotWritable());
        }
        return arrayPrototype;
    }

    private static List<String> unscopableNameList(JSContext context) {
        ArrayList<String> names = new ArrayList<String>();
        names.add("copyWithin");
        names.add(ENTRIES);
        names.add("fill");
        names.add("find");
        names.add("findIndex");
        if (context.getEcmaScriptVersion() >= 10) {
            names.add("flat");
            names.add("flatMap");
        }
        if (context.getEcmaScriptVersion() >= 7) {
            names.add("includes");
        }
        names.add("keys");
        names.add("values");
        return names;
    }

    private static DynamicObject createUnscopables(JSContext context, List<String> unscopableNames) {
        DynamicObject unscopables = JSObject.createInit(context.getEmptyShapeNullPrototype());
        for (String name : unscopableNames) {
            JSObjectUtil.putDataProperty(unscopables, name, true, JSAttributes.getDefault());
        }
        return unscopables;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = JSArray.addArrayProperties(initialShape);
        initialShape = initialShape.addProperty(ARRAY_LENGTH_PROXY_PROPERTY);
        return initialShape;
    }

    @Override
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        return JSArray.ownPropertyKeysFastArray(thisObj, strings, symbols);
    }

    public static Property makeArrayLengthProxyProperty() {
        return JSObjectUtil.makeProxyProperty("length", new ArrayLengthProxyProperty(), JSAttributes.notConfigurableNotEnumerableWritable());
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, ArrayFunctionBuiltins.BUILTINS);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean setLength(DynamicObject store, Object value) {
        long arrLength = 0L;
        arrLength = value instanceof Integer && (Integer)value >= 0 ? (long)((Integer)value).intValue() : JSArray.toArrayIndexOrRangeError(value);
        assert (arrLength >= 0L);
        return !JSAbstractArray.arrayGetArrayType(store).isLengthNotWritable() && ((JSAbstractArray)JSObject.getJSClass(store)).setLength(store, arrLength, false);
    }

    public static DynamicObject createConstantEmptyArray(JSContext context, int capacity) {
        AbstractConstantArray arrayType = ScriptArray.createConstantEmptyArray();
        return JSArray.create(context, arrayType, ScriptArray.EMPTY_OBJECT_ARRAY, capacity);
    }

    public static DynamicObject createConstantEmptyArray(JSContext context) {
        return JSArray.createConstantEmptyArray(context, 0);
    }

    public static DynamicObject createConstantEmptyArray(JSContext context, ArrayAllocationSite site) {
        return JSArray.createConstantEmptyArray(context, site, 0);
    }

    public static DynamicObject createConstantEmptyArray(JSContext context, ArrayAllocationSite site, int capacity) {
        AbstractConstantArray arrayType = ScriptArray.createConstantEmptyArray();
        return JSArray.create(context, arrayType, ScriptArray.EMPTY_OBJECT_ARRAY, site, capacity, 0, 0, 0, 0);
    }

    public static DynamicObject createConstantByteArray(JSContext context, byte[] byteArray) {
        ConstantByteArray arrayType = ConstantByteArray.createConstantByteArray();
        return JSArray.create(context, arrayType, byteArray, byteArray.length);
    }

    public static DynamicObject createConstantIntArray(JSContext context, int[] intArray) {
        ConstantIntArray arrayType = ConstantIntArray.createConstantIntArray();
        return JSArray.create(context, arrayType, intArray, intArray.length);
    }

    public static DynamicObject createConstantDoubleArray(JSContext context, double[] doubleArray) {
        ConstantDoubleArray arrayType = ConstantDoubleArray.createConstantDoubleArray();
        return JSArray.create(context, arrayType, doubleArray, doubleArray.length);
    }

    public static DynamicObject createConstantObjectArray(JSContext context, Object[] objectArray) {
        ConstantObjectArray arrayType = ConstantObjectArray.createConstantObjectArray();
        return JSArray.create(context, arrayType, objectArray, objectArray.length);
    }

    public static DynamicObject createZeroBasedHolesObjectArray(JSContext context, Object[] objectArray, int usedLength, int arrayOffset, int holeCount) {
        return JSArray.create(context, HolesObjectArray.createHolesObjectArray(), objectArray, objectArray.length, usedLength, 0, arrayOffset, holeCount);
    }

    public static DynamicObject createZeroBasedIntArray(JSContext context, int[] intArray) {
        return JSArray.create(context, ZeroBasedIntArray.createZeroBasedIntArray(), intArray, intArray.length, intArray.length, 0, 0);
    }

    public static DynamicObject createZeroBasedDoubleArray(JSContext context, double[] doubleArray) {
        return JSArray.create(context, ZeroBasedDoubleArray.createZeroBasedDoubleArray(), doubleArray, doubleArray.length, doubleArray.length, 0, 0);
    }

    public static DynamicObject createZeroBasedObjectArray(JSContext context, Object[] objectArray) {
        return JSArray.create(context, ZeroBasedObjectArray.createZeroBasedObjectArray(), objectArray, objectArray.length, objectArray.length, 0, 0);
    }

    public static DynamicObject createZeroBasedJSObjectArray(JSContext context, DynamicObject[] objectArray) {
        return JSArray.create(context, ZeroBasedJSObjectArray.createZeroBasedJSObjectArray(), objectArray, objectArray.length, objectArray.length, 0, 0);
    }

    public static DynamicObject createSparseArray(JSContext context, long length) {
        return JSArray.create(context, SparseArray.createSparseArray(), SparseArray.createArrayMap(), length);
    }

    public static DynamicObject createLazyRegexArray(JSContext context, int length, Object regexResult, String input, DynamicObject groups, DynamicObject indicesGroups) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        LazyRegexResultArray arrayType = LazyRegexResultArray.createLazyRegexResultArray();
        Object[] array = new Object[length];
        Object site = null;
        int usedLength = 0;
        int indexOffset = 0;
        int arrayOffset = 0;
        int holeCount = 0;
        JSObjectFactory factory = context.getLazyRegexArrayFactory();
        DynamicObject obj = null;
        if (context.isOptionRegexpMatchIndices()) {
            DynamicObject indices = JSArray.createLazyRegexIndicesArray(context, length, regexResult, indicesGroups);
            obj = JSObject.create(context, factory, array, arrayType, site, length, usedLength, indexOffset, arrayOffset, holeCount, regexResult, input, input, groups, indices);
        } else {
            obj = JSObject.create(context, factory, array, arrayType, site, length, usedLength, indexOffset, arrayOffset, holeCount, regexResult, input, input, groups);
        }
        assert (JSArray.isJSArray(obj));
        return obj;
    }

    private static DynamicObject createLazyRegexIndicesArray(JSContext context, int length, Object regexResult, DynamicObject indicesGroups) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length));
        LazyRegexResultIndicesArray arrayType = LazyRegexResultIndicesArray.createLazyRegexResultIndicesArray();
        Object[] array = new Object[length];
        Object site = null;
        int usedLength = 0;
        int indexOffset = 0;
        int arrayOffset = 0;
        int holeCount = 0;
        JSObjectFactory factory = context.getLazyRegexIndicesArrayFactory();
        DynamicObject arrayObject = JSObject.create(context, factory, array, arrayType, site, length, usedLength, indexOffset, arrayOffset, holeCount, regexResult, indicesGroups);
        return arrayObject;
    }

    public static DynamicObject createLazyArray(JSContext context, List<?> list) {
        return JSArray.create(context, LazyArray.createLazyArray(), list, Boundaries.listSize(list));
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getArrayPrototype();
    }

    public static class ArrayLengthProxyProperty
    implements PropertyProxy {
        @Override
        public Object get(DynamicObject store) {
            assert (JSArray.isJSArray(store));
            long length = INSTANCE.getLength(store);
            return (double)length;
        }

        @Override
        public boolean set(DynamicObject store, Object value) {
            assert (JSArray.isJSArray(store));
            return JSArray.setLength(store, value);
        }
    }
}

