/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToNumberNode.class)
public final class JSToNumberNodeGen
extends JSToNumberNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private JSToPrimitiveNode jSObject_toPrimitiveNode_;
    @Node.Child
    private JSToPrimitiveNode foreignObject_toPrimitiveNode_;

    private JSToNumberNodeGen() {
    }

    @Override
    public Object execute(Object arg0Value) {
        Object arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return JSToNumberNode.doInteger(arg0Value_2);
        }
        if ((state & 2) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_3 = (Boolean)arg0Value;
            return JSToNumberNode.doBoolean(arg0Value_3);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x7800) >>> 11, arg0Value)) {
            double arg0Value_4 = JSTypesGen.asImplicitDouble((state & 0x7800) >>> 11, arg0Value);
            return JSToNumberNode.doDouble(arg0Value_4);
        }
        if ((state & 0x18) != 0) {
            if ((state & 8) != 0 && JSGuards.isJSNull(arg0Value)) {
                return JSToNumberNode.doNull(arg0Value);
            }
            if ((state & 0x10) != 0 && JSGuards.isUndefined(arg0Value)) {
                return JSToNumberNode.doUndefined(arg0Value);
            }
        }
        if ((state & 0x20) != 0 && JSTypesGen.isImplicitString((state & 0x78000) >>> 15, arg0Value)) {
            String arg0Value_5 = JSTypesGen.asImplicitString((state & 0x78000) >>> 15, arg0Value);
            return this.doString(arg0Value_5);
        }
        if ((state & 0x40) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doJSObject((DynamicObject)arg0Value_, this.jSObject_toPrimitiveNode_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Symbol) {
            arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol((Symbol)arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof BigInt) {
            arg0Value_ = (BigInt)arg0Value;
            return this.doBigInt((BigInt)arg0Value_);
        }
        if ((state & 0x600) != 0) {
            if ((state & 0x200) != 0 && JSGuards.isForeignObject(arg0Value)) {
                return this.doForeignObject(arg0Value, this.foreignObject_toPrimitiveNode_);
            }
            if ((state & 0x400) != 0 && JSGuards.isJavaNumber(arg0Value)) {
                return JSToNumberNode.doJavaObject(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            DynamicObject arg0Value_;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = JSToNumberNode.doInteger(arg0Value_2);
                return n;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_3 = (Boolean)arg0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Integer n = JSToNumberNode.doBoolean(arg0Value_3);
                return n;
            }
            int doubleCast02 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast02 != 0) {
                double arg0Value_4 = JSTypesGen.asImplicitDouble(doubleCast02, arg0Value);
                state |= doubleCast02 << 11;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Double d = JSToNumberNode.doDouble(arg0Value_4);
                return d;
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Integer doubleCast02 = JSToNumberNode.doNull(arg0Value);
                return doubleCast02;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Double doubleCast02 = JSToNumberNode.doUndefined(arg0Value);
                return doubleCast02;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_5 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                state |= stringCast0 << 15;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Number number = this.doString(arg0Value_5);
                return number;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
                this.jSObject_toPrimitiveNode_ = (JSToPrimitiveNode)super.insert((Node)JSToPrimitiveNode.createHintNumber());
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Number number = this.doJSObject(arg0Value_, this.jSObject_toPrimitiveNode_);
                return number;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_6 = (Symbol)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Number number = this.doSymbol(arg0Value_6);
                return number;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_7 = (BigInt)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Number number = this.doBigInt(arg0Value_7);
                return number;
            }
            if (JSGuards.isForeignObject(arg0Value)) {
                this.foreignObject_toPrimitiveNode_ = (JSToPrimitiveNode)super.insert((Node)JSToPrimitiveNode.createHintNumber());
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                Number number = this.doForeignObject(arg0Value, this.foreignObject_toPrimitiveNode_);
                return number;
            }
            if (JSGuards.isJavaNumber(arg0Value)) {
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                Double d = JSToNumberNode.doJavaObject(arg0Value);
                return d;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x7FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x7FF & (state & 0x7FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<JSToPrimitiveNode>> cached;
        Object[] data = new Object[12];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<JSToPrimitiveNode>>();
            cached.add(Arrays.asList(this.jSObject_toPrimitiveNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.foreignObject_toPrimitiveNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doJavaObject";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToNumberNode create() {
        return new JSToNumberNodeGen();
    }

    @GeneratedBy(value=JSToNumberNode.JSToNumberUnaryNode.class)
    public static final class JSToNumberUnaryNodeGen
    extends JSToNumberNode.JSToNumberUnaryNode
    implements Introspection.Provider {
        private JSToNumberUnaryNodeGen(JavaScriptNode operand) {
            super(operand);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return this.doDefault(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doDefault(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "doDefault";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static JSToNumberNode.JSToNumberUnaryNode create(JavaScriptNode operand) {
            return new JSToNumberUnaryNodeGen(operand);
        }
    }
}

